require 'src/com/zoho/crm/api/util/Constants.pm';
require 'src/com/zoho/api/exception/SDKException.pm';
package currencies::ResponseWrapper;
use Moose;
sub new
{
	my ($class) = shift;
	my $self = 
	{
		currencies => undef,
		key_modified => (),
	};
	bless $self,$class;
	return $self;
}
sub get_currencies
{
	my ($self) = shift;
	return $self->{currencies}; 
}

sub set_currencies
{
	my ($self,$currencies) = @_;
	if(!(ref($currencies) eq "ARRAY"))
	{
		die SDKException->new($Constants::DATA_TYPE_ERROR, "KEY: currencies EXPECTED TYPE: ARRAY", undef, undef); 
	}
	$self->{currencies} = $currencies; 
	$self->{key_modified}{"currencies"} = 1; 
}

sub is_key_modified
{
	my ($self,$key) = @_;
	if((exists($self->{key_modified}{$key})))
	{
		return $self->{key_modified}{$key}; 
	}
	return undef; 
}

sub set_key_modified
{
	my ($self,$key,$modification) = @_;
	$self->{key_modified}{$key} = $modification; 
}
1;