// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53 provides a client for Amazon Route 53.
package route53

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateVPCWithHostedZone = "AssociateVPCWithHostedZone"

// AssociateVPCWithHostedZoneRequest generates a request for the AssociateVPCWithHostedZone operation.
func (c *Route53) AssociateVPCWithHostedZoneRequest(input *AssociateVPCWithHostedZoneInput) (req *request.Request, output *AssociateVPCWithHostedZoneOutput) {
	op := &request.Operation{
		Name:       opAssociateVPCWithHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/associatevpc",
	}

	if input == nil {
		input = &AssociateVPCWithHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateVPCWithHostedZoneOutput{}
	req.Data = output
	return
}

// This action associates a VPC with an hosted zone.
//
// To associate a VPC with an hosted zone, send a POST request to the /Route
// 53 API version/hostedzone/hosted zone ID/associatevpc resource. The request
// body must include a document with a AssociateVPCWithHostedZoneRequest element.
// The response returns the AssociateVPCWithHostedZoneResponse element that
// contains ChangeInfo for you to track the progress of the AssociateVPCWithHostedZoneRequest
// you made. See GetChange operation for how to track the progress of your change.
func (c *Route53) AssociateVPCWithHostedZone(input *AssociateVPCWithHostedZoneInput) (*AssociateVPCWithHostedZoneOutput, error) {
	req, out := c.AssociateVPCWithHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opChangeResourceRecordSets = "ChangeResourceRecordSets"

// ChangeResourceRecordSetsRequest generates a request for the ChangeResourceRecordSets operation.
func (c *Route53) ChangeResourceRecordSetsRequest(input *ChangeResourceRecordSetsInput) (req *request.Request, output *ChangeResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opChangeResourceRecordSets,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset/",
	}

	if input == nil {
		input = &ChangeResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeResourceRecordSetsOutput{}
	req.Data = output
	return
}

// Use this action to create or change your authoritative DNS information. To
// use this action, send a POST request to the /Route 53 API version/hostedzone/hosted
// Zone ID/rrset resource. The request body must include a document with a ChangeResourceRecordSetsRequest
// element.
//
// Changes are a list of change items and are considered transactional. For
// more information on transactional changes, also known as change batches,
// see POST ChangeResourceRecordSets (http://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html)
// in the Amazon Route 53 API Reference.
//
// Due to the nature of transactional changes, you cannot delete the same resource
// record set more than once in a single change batch. If you attempt to delete
// the same change batch more than once, Amazon Route 53 returns an InvalidChangeBatch
// error. In response to a ChangeResourceRecordSets request, your DNS data is
// changed on all Amazon Route 53 DNS servers. Initially, the status of a change
// is PENDING. This means the change has not yet propagated to all the authoritative
// Amazon Route 53 DNS servers. When the change is propagated to all hosts,
// the change returns a status of INSYNC.
//
// Note the following limitations on a ChangeResourceRecordSets request:
//
//  A request cannot contain more than 100 Change elements.  A request cannot
// contain more than 1000 ResourceRecord elements. The sum of the number of
// characters (including spaces) in all Value elements in a request cannot exceed
// 32,000 characters.
func (c *Route53) ChangeResourceRecordSets(input *ChangeResourceRecordSetsInput) (*ChangeResourceRecordSetsOutput, error) {
	req, out := c.ChangeResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

const opChangeTagsForResource = "ChangeTagsForResource"

// ChangeTagsForResourceRequest generates a request for the ChangeTagsForResource operation.
func (c *Route53) ChangeTagsForResourceRequest(input *ChangeTagsForResourceInput) (req *request.Request, output *ChangeTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opChangeTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ChangeTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeTagsForResourceOutput{}
	req.Data = output
	return
}

func (c *Route53) ChangeTagsForResource(input *ChangeTagsForResourceInput) (*ChangeTagsForResourceOutput, error) {
	req, out := c.ChangeTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHealthCheck = "CreateHealthCheck"

// CreateHealthCheckRequest generates a request for the CreateHealthCheck operation.
func (c *Route53) CreateHealthCheckRequest(input *CreateHealthCheckInput) (req *request.Request, output *CreateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opCreateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck",
	}

	if input == nil {
		input = &CreateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHealthCheckOutput{}
	req.Data = output
	return
}

// This action creates a new health check.
//
// To create a new health check, send a POST request to the /Route 53 API version/healthcheck
// resource. The request body must include a document with a CreateHealthCheckRequest
// element. The response returns the CreateHealthCheckResponse element that
// contains metadata about the health check.
func (c *Route53) CreateHealthCheck(input *CreateHealthCheckInput) (*CreateHealthCheckOutput, error) {
	req, out := c.CreateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHostedZone = "CreateHostedZone"

// CreateHostedZoneRequest generates a request for the CreateHostedZone operation.
func (c *Route53) CreateHostedZoneRequest(input *CreateHostedZoneInput) (req *request.Request, output *CreateHostedZoneOutput) {
	op := &request.Operation{
		Name:       opCreateHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone",
	}

	if input == nil {
		input = &CreateHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHostedZoneOutput{}
	req.Data = output
	return
}

// This action creates a new hosted zone.
//
// To create a new hosted zone, send a POST request to the /Route 53 API version/hostedzone
// resource. The request body must include a document with a CreateHostedZoneRequest
// element. The response returns the CreateHostedZoneResponse element that contains
// metadata about the hosted zone.
//
// Amazon Route 53 automatically creates a default SOA record and four NS records
// for the zone. The NS records in the hosted zone are the name servers you
// give your registrar to delegate your domain to. For more information about
// SOA and NS records, see NS and SOA Records that Amazon Route 53 Creates for
// a Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html)
// in the Amazon Route 53 Developer Guide.
//
// When you create a zone, its initial status is PENDING. This means that it
// is not yet available on all DNS servers. The status of the zone changes to
// INSYNC when the NS and SOA records are available on all Amazon Route 53 DNS
// servers.
//
// When trying to create a hosted zone using a reusable delegation set, you
// could specify an optional DelegationSetId, and Route53 would assign those
// 4 NS records for the zone, instead of alloting a new one.
func (c *Route53) CreateHostedZone(input *CreateHostedZoneInput) (*CreateHostedZoneOutput, error) {
	req, out := c.CreateHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReusableDelegationSet = "CreateReusableDelegationSet"

// CreateReusableDelegationSetRequest generates a request for the CreateReusableDelegationSet operation.
func (c *Route53) CreateReusableDelegationSetRequest(input *CreateReusableDelegationSetInput) (req *request.Request, output *CreateReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opCreateReusableDelegationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &CreateReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReusableDelegationSetOutput{}
	req.Data = output
	return
}

// This action creates a reusable delegationSet.
//
// To create a new reusable delegationSet, send a POST request to the /Route
// 53 API version/delegationset resource. The request body must include a document
// with a CreateReusableDelegationSetRequest element. The response returns the
// CreateReusableDelegationSetResponse element that contains metadata about
// the delegationSet.
//
// If the optional parameter HostedZoneId is specified, it marks the delegationSet
// associated with that particular hosted zone as reusable.
func (c *Route53) CreateReusableDelegationSet(input *CreateReusableDelegationSetInput) (*CreateReusableDelegationSetOutput, error) {
	req, out := c.CreateReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicy = "CreateTrafficPolicy"

// CreateTrafficPolicyRequest generates a request for the CreateTrafficPolicy operation.
func (c *Route53) CreateTrafficPolicyRequest(input *CreateTrafficPolicyInput) (req *request.Request, output *CreateTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy",
	}

	if input == nil {
		input = &CreateTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyOutput{}
	req.Data = output
	return
}

// Creates a traffic policy, which you use to create multiple DNS resource record
// sets for one domain name (such as example.com) or one subdomain name (such
// as www.example.com).
//
// To create a traffic policy, send a POST request to the /Route 53 API version/trafficpolicy
// resource. The request body must include a document with a CreateTrafficPolicyRequest
// element. The response includes the CreateTrafficPolicyResponse element, which
// contains information about the new traffic policy.
func (c *Route53) CreateTrafficPolicy(input *CreateTrafficPolicyInput) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicyInstance = "CreateTrafficPolicyInstance"

// CreateTrafficPolicyInstanceRequest generates a request for the CreateTrafficPolicyInstance operation.
func (c *Route53) CreateTrafficPolicyInstanceRequest(input *CreateTrafficPolicyInstanceInput) (req *request.Request, output *CreateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance",
	}

	if input == nil {
		input = &CreateTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// Creates resource record sets in a specified hosted zone based on the settings
// in a specified traffic policy version. In addition, CreateTrafficPolicyInstance
// associates the resource record sets with a specified domain name (such as
// example.com) or subdomain name (such as www.example.com). Amazon Route 53
// responds to DNS queries for the domain or subdomain name by using the resource
// record sets that CreateTrafficPolicyInstance created.
//
// To create a traffic policy instance, send a POST request to the /Route 53
// API version/trafficpolicyinstance resource. The request body must include
// a document with a CreateTrafficPolicyRequest element. The response returns
// the CreateTrafficPolicyInstanceResponse element, which contains information
// about the traffic policy instance.
func (c *Route53) CreateTrafficPolicyInstance(input *CreateTrafficPolicyInstanceInput) (*CreateTrafficPolicyInstanceOutput, error) {
	req, out := c.CreateTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicyVersion = "CreateTrafficPolicyVersion"

// CreateTrafficPolicyVersionRequest generates a request for the CreateTrafficPolicyVersion operation.
func (c *Route53) CreateTrafficPolicyVersionRequest(input *CreateTrafficPolicyVersionInput) (req *request.Request, output *CreateTrafficPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}",
	}

	if input == nil {
		input = &CreateTrafficPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyVersionOutput{}
	req.Data = output
	return
}

// Creates a new version of an existing traffic policy. When you create a new
// version of a traffic policy, you specify the ID of the traffic policy that
// you want to update and a JSON-formatted document that describes the new version.
//
// You use traffic policies to create multiple DNS resource record sets for
// one domain name (such as example.com) or one subdomain name (such as www.example.com).
//
// To create a new version, send a POST request to the /Route 53 API version/trafficpolicy/
// resource. The request body includes a document with a CreateTrafficPolicyVersionRequest
// element. The response returns the CreateTrafficPolicyVersionResponse element,
// which contains information about the new version of the traffic policy.
func (c *Route53) CreateTrafficPolicyVersion(input *CreateTrafficPolicyVersionInput) (*CreateTrafficPolicyVersionOutput, error) {
	req, out := c.CreateTrafficPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHealthCheck = "DeleteHealthCheck"

// DeleteHealthCheckRequest generates a request for the DeleteHealthCheck operation.
func (c *Route53) DeleteHealthCheckRequest(input *DeleteHealthCheckInput) (req *request.Request, output *DeleteHealthCheckOutput) {
	op := &request.Operation{
		Name:       opDeleteHealthCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &DeleteHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHealthCheckOutput{}
	req.Data = output
	return
}

// This action deletes a health check. To delete a health check, send a DELETE
// request to the /Route 53 API version/healthcheck/health check ID resource.
//
//  You can delete a health check only if there are no resource record sets
// associated with this health check. If resource record sets are associated
// with this health check, you must disassociate them before you can delete
// your health check. If you try to delete a health check that is associated
// with resource record sets, Amazon Route 53 will deny your request with a
// HealthCheckInUse error. For information about disassociating the records
// from your health check, see ChangeResourceRecordSets.
func (c *Route53) DeleteHealthCheck(input *DeleteHealthCheckInput) (*DeleteHealthCheckOutput, error) {
	req, out := c.DeleteHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHostedZone = "DeleteHostedZone"

// DeleteHostedZoneRequest generates a request for the DeleteHostedZone operation.
func (c *Route53) DeleteHostedZoneRequest(input *DeleteHostedZoneInput) (req *request.Request, output *DeleteHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDeleteHostedZone,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &DeleteHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHostedZoneOutput{}
	req.Data = output
	return
}

// This action deletes a hosted zone. To delete a hosted zone, send a DELETE
// request to the /Route 53 API version/hostedzone/hosted zone ID resource.
//
// For more information about deleting a hosted zone, see Deleting a Hosted
// Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html)
// in the Amazon Route 53 Developer Guide.
//
//  You can delete a hosted zone only if there are no resource record sets
// other than the default SOA record and NS resource record sets. If your hosted
// zone contains other resource record sets, you must delete them before you
// can delete your hosted zone. If you try to delete a hosted zone that contains
// other resource record sets, Amazon Route 53 will deny your request with a
// HostedZoneNotEmpty error. For information about deleting records from your
// hosted zone, see ChangeResourceRecordSets.
func (c *Route53) DeleteHostedZone(input *DeleteHostedZoneInput) (*DeleteHostedZoneOutput, error) {
	req, out := c.DeleteHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReusableDelegationSet = "DeleteReusableDelegationSet"

// DeleteReusableDelegationSetRequest generates a request for the DeleteReusableDelegationSet operation.
func (c *Route53) DeleteReusableDelegationSetRequest(input *DeleteReusableDelegationSetInput) (req *request.Request, output *DeleteReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReusableDelegationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &DeleteReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReusableDelegationSetOutput{}
	req.Data = output
	return
}

// This action deletes a reusable delegation set. To delete a reusable delegation
// set, send a DELETE request to the /Route 53 API version/delegationset/delegation
// set ID resource.
//
//  You can delete a reusable delegation set only if there are no associated
// hosted zones. If your reusable delegation set contains associated hosted
// zones, you must delete them before you can delete your reusable delegation
// set. If you try to delete a reusable delegation set that contains associated
// hosted zones, Amazon Route 53 will deny your request with a DelegationSetInUse
// error.
func (c *Route53) DeleteReusableDelegationSet(input *DeleteReusableDelegationSetInput) (*DeleteReusableDelegationSetOutput, error) {
	req, out := c.DeleteReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrafficPolicy = "DeleteTrafficPolicy"

// DeleteTrafficPolicyRequest generates a request for the DeleteTrafficPolicy operation.
func (c *Route53) DeleteTrafficPolicyRequest(input *DeleteTrafficPolicyInput) (req *request.Request, output *DeleteTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrafficPolicyOutput{}
	req.Data = output
	return
}

// Deletes a traffic policy. To delete a traffic policy, send a DELETE request
// to the /Route 53 API version/trafficpolicy resource.
func (c *Route53) DeleteTrafficPolicy(input *DeleteTrafficPolicyInput) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrafficPolicyInstance = "DeleteTrafficPolicyInstance"

// DeleteTrafficPolicyInstanceRequest generates a request for the DeleteTrafficPolicyInstance operation.
func (c *Route53) DeleteTrafficPolicyInstanceRequest(input *DeleteTrafficPolicyInstanceInput) (req *request.Request, output *DeleteTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicyInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// Deletes a traffic policy instance and all of the resource record sets that
// Amazon Route 53 created when you created the instance.
//
// To delete a traffic policy instance, send a DELETE request to the /Route
// 53 API version/trafficpolicy/traffic policy instance ID resource.
//
// When you delete a traffic policy instance, Amazon Route 53 also deletes
// all of the resource record sets that were created when you created the traffic
// policy instance.
func (c *Route53) DeleteTrafficPolicyInstance(input *DeleteTrafficPolicyInstanceInput) (*DeleteTrafficPolicyInstanceOutput, error) {
	req, out := c.DeleteTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateVPCFromHostedZone = "DisassociateVPCFromHostedZone"

// DisassociateVPCFromHostedZoneRequest generates a request for the DisassociateVPCFromHostedZone operation.
func (c *Route53) DisassociateVPCFromHostedZoneRequest(input *DisassociateVPCFromHostedZoneInput) (req *request.Request, output *DisassociateVPCFromHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDisassociateVPCFromHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/disassociatevpc",
	}

	if input == nil {
		input = &DisassociateVPCFromHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateVPCFromHostedZoneOutput{}
	req.Data = output
	return
}

// This action disassociates a VPC from an hosted zone.
//
// To disassociate a VPC to a hosted zone, send a POST request to the /Route
// 53 API version/hostedzone/hosted zone ID/disassociatevpc resource. The request
// body must include a document with a DisassociateVPCFromHostedZoneRequest
// element. The response returns the DisassociateVPCFromHostedZoneResponse element
// that contains ChangeInfo for you to track the progress of the DisassociateVPCFromHostedZoneRequest
// you made. See GetChange operation for how to track the progress of your change.
func (c *Route53) DisassociateVPCFromHostedZone(input *DisassociateVPCFromHostedZoneInput) (*DisassociateVPCFromHostedZoneOutput, error) {
	req, out := c.DisassociateVPCFromHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetChange = "GetChange"

// GetChangeRequest generates a request for the GetChange operation.
func (c *Route53) GetChangeRequest(input *GetChangeInput) (req *request.Request, output *GetChangeOutput) {
	op := &request.Operation{
		Name:       opGetChange,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/change/{Id}",
	}

	if input == nil {
		input = &GetChangeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeOutput{}
	req.Data = output
	return
}

// This action returns the current status of a change batch request. The status
// is one of the following values:
//
// - PENDING indicates that the changes in this request have not replicated
// to all Amazon Route 53 DNS servers. This is the initial status of all change
// batch requests.
//
// - INSYNC indicates that the changes have replicated to all Amazon Route
// 53 DNS servers.
func (c *Route53) GetChange(input *GetChangeInput) (*GetChangeOutput, error) {
	req, out := c.GetChangeRequest(input)
	err := req.Send()
	return out, err
}

const opGetChangeDetails = "GetChangeDetails"

// GetChangeDetailsRequest generates a request for the GetChangeDetails operation.
func (c *Route53) GetChangeDetailsRequest(input *GetChangeDetailsInput) (req *request.Request, output *GetChangeDetailsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetChangeDetails, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetChangeDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/changedetails/{Id}",
	}

	if input == nil {
		input = &GetChangeDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeDetailsOutput{}
	req.Data = output
	return
}

// This action returns the status and changes of a change batch request.
func (c *Route53) GetChangeDetails(input *GetChangeDetailsInput) (*GetChangeDetailsOutput, error) {
	req, out := c.GetChangeDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opGetCheckerIpRanges = "GetCheckerIpRanges"

// GetCheckerIpRangesRequest generates a request for the GetCheckerIpRanges operation.
func (c *Route53) GetCheckerIpRangesRequest(input *GetCheckerIpRangesInput) (req *request.Request, output *GetCheckerIpRangesOutput) {
	op := &request.Operation{
		Name:       opGetCheckerIpRanges,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/checkeripranges",
	}

	if input == nil {
		input = &GetCheckerIpRangesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCheckerIpRangesOutput{}
	req.Data = output
	return
}

// To retrieve a list of the IP ranges used by Amazon Route 53 health checkers
// to check the health of your resources, send a GET request to the /Route 53
// API version/checkeripranges resource. You can use these IP addresses to configure
// router and firewall rules to allow health checkers to check the health of
// your resources.
func (c *Route53) GetCheckerIpRanges(input *GetCheckerIpRangesInput) (*GetCheckerIpRangesOutput, error) {
	req, out := c.GetCheckerIpRangesRequest(input)
	err := req.Send()
	return out, err
}

const opGetGeoLocation = "GetGeoLocation"

// GetGeoLocationRequest generates a request for the GetGeoLocation operation.
func (c *Route53) GetGeoLocationRequest(input *GetGeoLocationInput) (req *request.Request, output *GetGeoLocationOutput) {
	op := &request.Operation{
		Name:       opGetGeoLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocation",
	}

	if input == nil {
		input = &GetGeoLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGeoLocationOutput{}
	req.Data = output
	return
}

// To retrieve a single geo location, send a GET request to the /Route 53 API
// version/geolocation resource with one of these options: continentcode | countrycode
// | countrycode and subdivisioncode.
func (c *Route53) GetGeoLocation(input *GetGeoLocationInput) (*GetGeoLocationOutput, error) {
	req, out := c.GetGeoLocationRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheck = "GetHealthCheck"

// GetHealthCheckRequest generates a request for the GetHealthCheck operation.
func (c *Route53) GetHealthCheckRequest(input *GetHealthCheckInput) (req *request.Request, output *GetHealthCheckOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheck,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &GetHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckOutput{}
	req.Data = output
	return
}

// To retrieve the health check, send a GET request to the /Route 53 API version/healthcheck/health
// check ID resource.
func (c *Route53) GetHealthCheck(input *GetHealthCheckInput) (*GetHealthCheckOutput, error) {
	req, out := c.GetHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckCount = "GetHealthCheckCount"

// GetHealthCheckCountRequest generates a request for the GetHealthCheckCount operation.
func (c *Route53) GetHealthCheckCountRequest(input *GetHealthCheckCountInput) (req *request.Request, output *GetHealthCheckCountOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheckcount",
	}

	if input == nil {
		input = &GetHealthCheckCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckCountOutput{}
	req.Data = output
	return
}

// To retrieve a count of all your health checks, send a GET request to the
// /Route 53 API version/healthcheckcount resource.
func (c *Route53) GetHealthCheckCount(input *GetHealthCheckCountInput) (*GetHealthCheckCountOutput, error) {
	req, out := c.GetHealthCheckCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckLastFailureReason = "GetHealthCheckLastFailureReason"

// GetHealthCheckLastFailureReasonRequest generates a request for the GetHealthCheckLastFailureReason operation.
func (c *Route53) GetHealthCheckLastFailureReasonRequest(input *GetHealthCheckLastFailureReasonInput) (req *request.Request, output *GetHealthCheckLastFailureReasonOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckLastFailureReason,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
	}

	if input == nil {
		input = &GetHealthCheckLastFailureReasonInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckLastFailureReasonOutput{}
	req.Data = output
	return
}

// If you want to learn why a health check is currently failing or why it failed
// most recently (if at all), you can get the failure reason for the most recent
// failure. Send a GET request to the /Route 53 API version/healthcheck/health
// check ID/lastfailurereason resource.
func (c *Route53) GetHealthCheckLastFailureReason(input *GetHealthCheckLastFailureReasonInput) (*GetHealthCheckLastFailureReasonOutput, error) {
	req, out := c.GetHealthCheckLastFailureReasonRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckStatus = "GetHealthCheckStatus"

// GetHealthCheckStatusRequest generates a request for the GetHealthCheckStatus operation.
func (c *Route53) GetHealthCheckStatusRequest(input *GetHealthCheckStatusInput) (req *request.Request, output *GetHealthCheckStatusOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/status",
	}

	if input == nil {
		input = &GetHealthCheckStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckStatusOutput{}
	req.Data = output
	return
}

// To retrieve the health check status, send a GET request to the /Route 53
// API version/healthcheck/health check ID/status resource. You can use this
// call to get a health check's current status.
func (c *Route53) GetHealthCheckStatus(input *GetHealthCheckStatusInput) (*GetHealthCheckStatusOutput, error) {
	req, out := c.GetHealthCheckStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZone = "GetHostedZone"

// GetHostedZoneRequest generates a request for the GetHostedZone operation.
func (c *Route53) GetHostedZoneRequest(input *GetHostedZoneInput) (req *request.Request, output *GetHostedZoneOutput) {
	op := &request.Operation{
		Name:       opGetHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &GetHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneOutput{}
	req.Data = output
	return
}

// To retrieve the delegation set for a hosted zone, send a GET request to the
// /Route 53 API version/hostedzone/hosted zone ID resource. The delegation
// set is the four Amazon Route 53 name servers that were assigned to the hosted
// zone when you created it.
func (c *Route53) GetHostedZone(input *GetHostedZoneInput) (*GetHostedZoneOutput, error) {
	req, out := c.GetHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZoneCount = "GetHostedZoneCount"

// GetHostedZoneCountRequest generates a request for the GetHostedZoneCount operation.
func (c *Route53) GetHostedZoneCountRequest(input *GetHostedZoneCountInput) (req *request.Request, output *GetHostedZoneCountOutput) {
	op := &request.Operation{
		Name:       opGetHostedZoneCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonecount",
	}

	if input == nil {
		input = &GetHostedZoneCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneCountOutput{}
	req.Data = output
	return
}

// To retrieve a count of all your hosted zones, send a GET request to the /Route
// 53 API version/hostedzonecount resource.
func (c *Route53) GetHostedZoneCount(input *GetHostedZoneCountInput) (*GetHostedZoneCountOutput, error) {
	req, out := c.GetHostedZoneCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetReusableDelegationSet = "GetReusableDelegationSet"

// GetReusableDelegationSetRequest generates a request for the GetReusableDelegationSet operation.
func (c *Route53) GetReusableDelegationSetRequest(input *GetReusableDelegationSetInput) (req *request.Request, output *GetReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opGetReusableDelegationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &GetReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetReusableDelegationSetOutput{}
	req.Data = output
	return
}

// To retrieve the reusable delegation set, send a GET request to the /Route
// 53 API version/delegationset/delegation set ID resource.
func (c *Route53) GetReusableDelegationSet(input *GetReusableDelegationSetInput) (*GetReusableDelegationSetOutput, error) {
	req, out := c.GetReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicy = "GetTrafficPolicy"

// GetTrafficPolicyRequest generates a request for the GetTrafficPolicy operation.
func (c *Route53) GetTrafficPolicyRequest(input *GetTrafficPolicyInput) (req *request.Request, output *GetTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &GetTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyOutput{}
	req.Data = output
	return
}

// Gets information about a specific traffic policy version. To get the information,
// send a GET request to the /Route 53 API version/trafficpolicy resource.
func (c *Route53) GetTrafficPolicy(input *GetTrafficPolicyInput) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicyInstance = "GetTrafficPolicyInstance"

// GetTrafficPolicyInstanceRequest generates a request for the GetTrafficPolicyInstance operation.
func (c *Route53) GetTrafficPolicyInstanceRequest(input *GetTrafficPolicyInstanceInput) (req *request.Request, output *GetTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// Gets information about a specified traffic policy instance.
//
// To get information about the traffic policy instance, send a GET request
// to the /Route 53 API version/trafficpolicyinstance resource.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
func (c *Route53) GetTrafficPolicyInstance(input *GetTrafficPolicyInstanceInput) (*GetTrafficPolicyInstanceOutput, error) {
	req, out := c.GetTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicyInstanceCount = "GetTrafficPolicyInstanceCount"

// GetTrafficPolicyInstanceCountRequest generates a request for the GetTrafficPolicyInstanceCount operation.
func (c *Route53) GetTrafficPolicyInstanceCountRequest(input *GetTrafficPolicyInstanceCountInput) (req *request.Request, output *GetTrafficPolicyInstanceCountOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstanceCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstancecount",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyInstanceCountOutput{}
	req.Data = output
	return
}

// Gets the number of traffic policy instances that are associated with the
// current AWS account.
//
// To get the number of traffic policy instances, send a GET request to the
// /Route 53 API version/trafficpolicyinstancecount resource.
func (c *Route53) GetTrafficPolicyInstanceCount(input *GetTrafficPolicyInstanceCountInput) (*GetTrafficPolicyInstanceCountOutput, error) {
	req, out := c.GetTrafficPolicyInstanceCountRequest(input)
	err := req.Send()
	return out, err
}

const opListChangeBatchesByHostedZone = "ListChangeBatchesByHostedZone"

// ListChangeBatchesByHostedZoneRequest generates a request for the ListChangeBatchesByHostedZone operation.
func (c *Route53) ListChangeBatchesByHostedZoneRequest(input *ListChangeBatchesByHostedZoneInput) (req *request.Request, output *ListChangeBatchesByHostedZoneOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChangeBatchesByHostedZone, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChangeBatchesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/changes",
	}

	if input == nil {
		input = &ListChangeBatchesByHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListChangeBatchesByHostedZoneOutput{}
	req.Data = output
	return
}

// This action gets the list of ChangeBatches in a given time period for a given
// hosted zone.
func (c *Route53) ListChangeBatchesByHostedZone(input *ListChangeBatchesByHostedZoneInput) (*ListChangeBatchesByHostedZoneOutput, error) {
	req, out := c.ListChangeBatchesByHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opListChangeBatchesByRRSet = "ListChangeBatchesByRRSet"

// ListChangeBatchesByRRSetRequest generates a request for the ListChangeBatchesByRRSet operation.
func (c *Route53) ListChangeBatchesByRRSetRequest(input *ListChangeBatchesByRRSetInput) (req *request.Request, output *ListChangeBatchesByRRSetOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChangeBatchesByRRSet, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChangeBatchesByRRSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrsChanges",
	}

	if input == nil {
		input = &ListChangeBatchesByRRSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListChangeBatchesByRRSetOutput{}
	req.Data = output
	return
}

// This action gets the list of ChangeBatches in a given time period for a given
// hosted zone and RRSet.
func (c *Route53) ListChangeBatchesByRRSet(input *ListChangeBatchesByRRSetInput) (*ListChangeBatchesByRRSetOutput, error) {
	req, out := c.ListChangeBatchesByRRSetRequest(input)
	err := req.Send()
	return out, err
}

const opListGeoLocations = "ListGeoLocations"

// ListGeoLocationsRequest generates a request for the ListGeoLocations operation.
func (c *Route53) ListGeoLocationsRequest(input *ListGeoLocationsInput) (req *request.Request, output *ListGeoLocationsOutput) {
	op := &request.Operation{
		Name:       opListGeoLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocations",
	}

	if input == nil {
		input = &ListGeoLocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGeoLocationsOutput{}
	req.Data = output
	return
}

// To retrieve a list of supported geo locations, send a GET request to the
// /Route 53 API version/geolocations resource. The response to this request
// includes a GeoLocationDetailsList element with zero, one, or multiple GeoLocationDetails
// child elements. The list is sorted by country code, and then subdivision
// code, followed by continents at the end of the list.
//
// By default, the list of geo locations is displayed on a single page. You
// can control the length of the page that is displayed by using the MaxItems
// parameter. If the list is truncated, IsTruncated will be set to true and
// a combination of NextContinentCode, NextCountryCode, NextSubdivisionCode
// will be populated. You can pass these as parameters to StartContinentCode,
// StartCountryCode, StartSubdivisionCode to control the geo location that the
// list begins with.
func (c *Route53) ListGeoLocations(input *ListGeoLocationsInput) (*ListGeoLocationsOutput, error) {
	req, out := c.ListGeoLocationsRequest(input)
	err := req.Send()
	return out, err
}

const opListHealthChecks = "ListHealthChecks"

// ListHealthChecksRequest generates a request for the ListHealthChecks operation.
func (c *Route53) ListHealthChecksRequest(input *ListHealthChecksInput) (req *request.Request, output *ListHealthChecksOutput) {
	op := &request.Operation{
		Name:       opListHealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHealthChecksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHealthChecksOutput{}
	req.Data = output
	return
}

// To retrieve a list of your health checks, send a GET request to the /Route
// 53 API version/healthcheck resource. The response to this request includes
// a HealthChecks element with zero, one, or multiple HealthCheck child elements.
// By default, the list of health checks is displayed on a single page. You
// can control the length of the page that is displayed by using the MaxItems
// parameter. You can use the Marker parameter to control the health check that
// the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHealthChecks(input *ListHealthChecksInput) (*ListHealthChecksOutput, error) {
	req, out := c.ListHealthChecksRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListHealthChecksPages(input *ListHealthChecksInput, fn func(p *ListHealthChecksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHealthChecksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHealthChecksOutput), lastPage)
	})
}

const opListHostedZones = "ListHostedZones"

// ListHostedZonesRequest generates a request for the ListHostedZones operation.
func (c *Route53) ListHostedZonesRequest(input *ListHostedZonesInput) (req *request.Request, output *ListHostedZonesOutput) {
	op := &request.Operation{
		Name:       opListHostedZones,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHostedZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesOutput{}
	req.Data = output
	return
}

// To retrieve a list of your hosted zones, send a GET request to the /Route
// 53 API version/hostedzone resource. The response to this request includes
// a HostedZones element with zero, one, or multiple HostedZone child elements.
// By default, the list of hosted zones is displayed on a single page. You can
// control the length of the page that is displayed by using the MaxItems parameter.
// You can use the Marker parameter to control the hosted zone that the list
// begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHostedZones(input *ListHostedZonesInput) (*ListHostedZonesOutput, error) {
	req, out := c.ListHostedZonesRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListHostedZonesPages(input *ListHostedZonesInput, fn func(p *ListHostedZonesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHostedZonesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHostedZonesOutput), lastPage)
	})
}

const opListHostedZonesByName = "ListHostedZonesByName"

// ListHostedZonesByNameRequest generates a request for the ListHostedZonesByName operation.
func (c *Route53) ListHostedZonesByNameRequest(input *ListHostedZonesByNameInput) (req *request.Request, output *ListHostedZonesByNameOutput) {
	op := &request.Operation{
		Name:       opListHostedZonesByName,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyname",
	}

	if input == nil {
		input = &ListHostedZonesByNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesByNameOutput{}
	req.Data = output
	return
}

// To retrieve a list of your hosted zones in lexicographic order, send a GET
// request to the /Route 53 API version/hostedzonesbyname resource. The response
// to this request includes a HostedZones element with zero or more HostedZone
// child elements lexicographically ordered by DNS name. By default, the list
// of hosted zones is displayed on a single page. You can control the length
// of the page that is displayed by using the MaxItems parameter. You can use
// the DNSName and HostedZoneId parameters to control the hosted zone that the
// list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHostedZonesByName(input *ListHostedZonesByNameInput) (*ListHostedZonesByNameOutput, error) {
	req, out := c.ListHostedZonesByNameRequest(input)
	err := req.Send()
	return out, err
}

const opListResourceRecordSets = "ListResourceRecordSets"

// ListResourceRecordSetsRequest generates a request for the ListResourceRecordSets operation.
func (c *Route53) ListResourceRecordSetsRequest(input *ListResourceRecordSetsInput) (req *request.Request, output *ListResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"StartRecordName", "StartRecordType", "StartRecordIdentifier"},
			OutputTokens:    []string{"NextRecordName", "NextRecordType", "NextRecordIdentifier"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListResourceRecordSetsOutput{}
	req.Data = output
	return
}

// Imagine all the resource record sets in a zone listed out in front of you.
// Imagine them sorted lexicographically first by DNS name (with the labels
// reversed, like "com.amazon.www" for example), and secondarily, lexicographically
// by record type. This operation retrieves at most MaxItems resource record
// sets from this list, in order, starting at a position specified by the Name
// and Type arguments:
//
//  If both Name and Type are omitted, this means start the results at the
// first RRSET in the HostedZone. If Name is specified but Type is omitted,
// this means start the results at the first RRSET in the list whose name is
// greater than or equal to Name.  If both Name and Type are specified, this
// means start the results at the first RRSET in the list whose name is greater
// than or equal to Name and whose type is greater than or equal to Type. It
// is an error to specify the Type but not the Name.  Use ListResourceRecordSets
// to retrieve a single known record set by specifying the record set's name
// and type, and setting MaxItems = 1
//
// To retrieve all the records in a HostedZone, first pause any processes making
// calls to ChangeResourceRecordSets. Initially call ListResourceRecordSets
// without a Name and Type to get the first page of record sets. For subsequent
// calls, set Name and Type to the NextName and NextType values returned by
// the previous response.
//
// In the presence of concurrent ChangeResourceRecordSets calls, there is no
// consistency of results across calls to ListResourceRecordSets. The only way
// to get a consistent multi-page snapshot of all RRSETs in a zone is to stop
// making changes while pagination is in progress.
//
// However, the results from ListResourceRecordSets are consistent within a
// page. If MakeChange calls are taking place concurrently, the result of each
// one will either be completely visible in your results or not at all. You
// will not see partial changes, or changes that do not ultimately succeed.
// (This follows from the fact that MakeChange is atomic)
//
// The results from ListResourceRecordSets are strongly consistent with ChangeResourceRecordSets.
// To be precise, if a single process makes a call to ChangeResourceRecordSets
// and receives a successful response, the effects of that change will be visible
// in a subsequent call to ListResourceRecordSets by that process.
func (c *Route53) ListResourceRecordSets(input *ListResourceRecordSetsInput) (*ListResourceRecordSetsOutput, error) {
	req, out := c.ListResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListResourceRecordSetsPages(input *ListResourceRecordSetsInput, fn func(p *ListResourceRecordSetsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListResourceRecordSetsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListResourceRecordSetsOutput), lastPage)
	})
}

const opListReusableDelegationSets = "ListReusableDelegationSets"

// ListReusableDelegationSetsRequest generates a request for the ListReusableDelegationSets operation.
func (c *Route53) ListReusableDelegationSetsRequest(input *ListReusableDelegationSetsInput) (req *request.Request, output *ListReusableDelegationSetsOutput) {
	op := &request.Operation{
		Name:       opListReusableDelegationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &ListReusableDelegationSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListReusableDelegationSetsOutput{}
	req.Data = output
	return
}

// To retrieve a list of your reusable delegation sets, send a GET request to
// the /Route 53 API version/delegationset resource. The response to this request
// includes a DelegationSets element with zero, one, or multiple DelegationSet
// child elements. By default, the list of delegation sets is displayed on a
// single page. You can control the length of the page that is displayed by
// using the MaxItems parameter. You can use the Marker parameter to control
// the delegation set that the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListReusableDelegationSets(input *ListReusableDelegationSetsInput) (*ListReusableDelegationSetsOutput, error) {
	req, out := c.ListReusableDelegationSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a request for the ListTagsForResource operation.
func (c *Route53) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

func (c *Route53) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResources = "ListTagsForResources"

// ListTagsForResourcesRequest generates a request for the ListTagsForResources operation.
func (c *Route53) ListTagsForResourcesRequest(input *ListTagsForResourcesInput) (req *request.Request, output *ListTagsForResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagsForResources,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}",
	}

	if input == nil {
		input = &ListTagsForResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourcesOutput{}
	req.Data = output
	return
}

func (c *Route53) ListTagsForResources(input *ListTagsForResourcesInput) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicies = "ListTrafficPolicies"

// ListTrafficPoliciesRequest generates a request for the ListTrafficPolicies operation.
func (c *Route53) ListTrafficPoliciesRequest(input *ListTrafficPoliciesInput) (req *request.Request, output *ListTrafficPoliciesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies",
	}

	if input == nil {
		input = &ListTrafficPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPoliciesOutput{}
	req.Data = output
	return
}

// Gets information about the latest version for every traffic policy that is
// associated with the current AWS account. To get the information, send a GET
// request to the /Route 53 API version/trafficpolicy resource.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you
// have a lot of traffic policies, you can use the maxitems parameter to list
// them in groups of up to 100.
//
// The response includes three values that help you navigate from one group
// of maxitems traffic policies to the next:
//
//  IsTruncated If the value of IsTruncated in the response is true, there
// are more traffic policies associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last traffic policy
// that is associated with the current account.
//
// TrafficPolicyIdMarker If IsTruncated is true, TrafficPolicyIdMarker is the
// ID of the first traffic policy in the next group of MaxItems traffic policies.
// If you want to list more traffic policies, make another call to ListTrafficPolicies,
// and specify the value of the TrafficPolicyIdMarker element from the response
// in the TrafficPolicyIdMarker request parameter.
//
// If IsTruncated is false, the TrafficPolicyIdMarker element is omitted from
// the response.
//
// MaxItems The value that you specified for the MaxItems parameter in the
// request that produced the current response.
func (c *Route53) ListTrafficPolicies(input *ListTrafficPoliciesInput) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstances = "ListTrafficPolicyInstances"

// ListTrafficPolicyInstancesRequest generates a request for the ListTrafficPolicyInstances operation.
func (c *Route53) ListTrafficPolicyInstancesRequest(input *ListTrafficPolicyInstancesInput) (req *request.Request, output *ListTrafficPolicyInstancesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesOutput{}
	req.Data = output
	return
}

// Gets information about the traffic policy instances that you created by using
// the current AWS account.
//
// After you submit an UpdateTrafficPolicyInstance request, there's a brief
// delay while Amazon Route 53 creates the resource record sets that are specified
// in the traffic policy definition. For more information, see the State response
// element. To get information about the traffic policy instances that are associated
// with the current AWS account, send a GET request to the /Route 53 API version/trafficpolicyinstance
// resource.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you
// have a lot of traffic policy instances, you can use the MaxItems parameter
// to list them in groups of up to 100.
//
// The response includes five values that help you navigate from one group
// of MaxItems traffic policy instances to the next:
//
//  IsTruncated If the value of IsTruncated in the response is true, there
// are more traffic policy instances associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last traffic policy
// instance that is associated with the current account.
//
// MaxItems The value that you specified for the MaxItems parameter in the
// request that produced the current response.
//
// HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
// If IsTruncated is true, these three values in the response represent the
// first traffic policy instance in the next group of MaxItems traffic policy
// instances. To list more traffic policy instances, make another call to ListTrafficPolicyInstances,
// and specify these values in the corresponding request parameters.
//
// If IsTruncated is false, all three elements are omitted from the response.
func (c *Route53) ListTrafficPolicyInstances(input *ListTrafficPolicyInstancesInput) (*ListTrafficPolicyInstancesOutput, error) {
	req, out := c.ListTrafficPolicyInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstancesByHostedZone = "ListTrafficPolicyInstancesByHostedZone"

// ListTrafficPolicyInstancesByHostedZoneRequest generates a request for the ListTrafficPolicyInstancesByHostedZone operation.
func (c *Route53) ListTrafficPolicyInstancesByHostedZoneRequest(input *ListTrafficPolicyInstancesByHostedZoneInput) (req *request.Request, output *ListTrafficPolicyInstancesByHostedZoneOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/hostedzone",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesByHostedZoneOutput{}
	req.Data = output
	return
}

// Gets information about the traffic policy instances that you created in a
// specified hosted zone.
//
// After you submit an UpdateTrafficPolicyInstance request, there's a brief
// delay while Amazon Route 53 creates the resource record sets that are specified
// in the traffic policy definition. For more information, see the State response
// element. To get information about the traffic policy instances that you created
// in a specified hosted zone, send a GET request to the /Route 53 API version/trafficpolicyinstance
// resource and include the ID of the hosted zone.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you
// have a lot of traffic policy instances, you can use the MaxItems parameter
// to list them in groups of up to 100.
//
// The response includes four values that help you navigate from one group
// of MaxItems traffic policy instances to the next:
//
//  IsTruncated If the value of IsTruncated in the response is true, there
// are more traffic policy instances associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last traffic policy
// instance that is associated with the current account.
//
// MaxItems The value that you specified for the MaxItems parameter in the
// request that produced the current response.
//
// TrafficPolicyInstanceNameMarker and TrafficPolicyInstanceTypeMarker If IsTruncated
// is true, these two values in the response represent the first traffic policy
// instance in the next group of MaxItems traffic policy instances. To list
// more traffic policy instances, make another call to ListTrafficPolicyInstancesByHostedZone,
// and specify these values in the corresponding request parameters.
//
// If IsTruncated is false, all three elements are omitted from the response.
func (c *Route53) ListTrafficPolicyInstancesByHostedZone(input *ListTrafficPolicyInstancesByHostedZoneInput) (*ListTrafficPolicyInstancesByHostedZoneOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstancesByPolicy = "ListTrafficPolicyInstancesByPolicy"

// ListTrafficPolicyInstancesByPolicyRequest generates a request for the ListTrafficPolicyInstancesByPolicy operation.
func (c *Route53) ListTrafficPolicyInstancesByPolicyRequest(input *ListTrafficPolicyInstancesByPolicyInput) (req *request.Request, output *ListTrafficPolicyInstancesByPolicyOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/trafficpolicy",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesByPolicyOutput{}
	req.Data = output
	return
}

// Gets information about the traffic policy instances that you created by using
// a specify traffic policy version.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element. To get information about the
// traffic policy instances that you created by using a specify traffic policy
// version, send a GET request to the /Route 53 API version/trafficpolicyinstance
// resource and include the ID and version of the traffic policy.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you
// have a lot of traffic policy instances, you can use the MaxItems parameter
// to list them in groups of up to 100.
//
// The response includes five values that help you navigate from one group
// of MaxItems traffic policy instances to the next:
//
//  IsTruncated If the value of IsTruncated in the response is true, there
// are more traffic policy instances associated with the specified traffic policy.
//
// If IsTruncated is false, this response includes the last traffic policy
// instance that is associated with the specified traffic policy.
//
//  MaxItems The value that you specified for the MaxItems parameter in the
// request that produced the current response.
//
//  HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
// If IsTruncated is true, these values in the response represent the first
// traffic policy instance in the next group of MaxItems traffic policy instances.
// To list more traffic policy instances, make another call to ListTrafficPolicyInstancesByPolicy,
// and specify these values in the corresponding request parameters.
//
// If IsTruncated is false, all three elements are omitted from the response.
func (c *Route53) ListTrafficPolicyInstancesByPolicy(input *ListTrafficPolicyInstancesByPolicyInput) (*ListTrafficPolicyInstancesByPolicyOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyVersions = "ListTrafficPolicyVersions"

// ListTrafficPolicyVersionsRequest generates a request for the ListTrafficPolicyVersions operation.
func (c *Route53) ListTrafficPolicyVersionsRequest(input *ListTrafficPolicyVersionsInput) (req *request.Request, output *ListTrafficPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies/{Id}/versions",
	}

	if input == nil {
		input = &ListTrafficPolicyVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyVersionsOutput{}
	req.Data = output
	return
}

// Gets information about all of the versions for a specified traffic policy.
// ListTrafficPolicyVersions lists only versions that have not been deleted.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you
// have a lot of traffic policies, you can use the maxitems parameter to list
// them in groups of up to 100.
//
// The response includes three values that help you navigate from one group
// of maxitemsmaxitems traffic policies to the next:
//
//  IsTruncated If the value of IsTruncated in the response is true, there
// are more traffic policy versions associated with the specified traffic policy.
//
// If IsTruncated is false, this response includes the last traffic policy
// version that is associated with the specified traffic policy.
//
// TrafficPolicyVersionMarker The ID of the next traffic policy version that
// is associated with the current AWS account. If you want to list more traffic
// policies, make another call to ListTrafficPolicyVersions, and specify the
// value of the TrafficPolicyVersionMarker element in the TrafficPolicyVersionMarker
// request parameter.
//
// If IsTruncated is false, Amazon Route 53 omits the TrafficPolicyVersionMarker
// element from the response.
//
// MaxItems The value that you specified for the MaxItems parameter in the
// request that produced the current response.
func (c *Route53) ListTrafficPolicyVersions(input *ListTrafficPolicyVersionsInput) (*ListTrafficPolicyVersionsOutput, error) {
	req, out := c.ListTrafficPolicyVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHealthCheck = "UpdateHealthCheck"

// UpdateHealthCheckRequest generates a request for the UpdateHealthCheck operation.
func (c *Route53) UpdateHealthCheckRequest(input *UpdateHealthCheckInput) (req *request.Request, output *UpdateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opUpdateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &UpdateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHealthCheckOutput{}
	req.Data = output
	return
}

// This action updates an existing health check.
//
// To update a health check, send a POST request to the /Route 53 API version/healthcheck/health
// check ID resource. The request body must include a document with an UpdateHealthCheckRequest
// element. The response returns an UpdateHealthCheckResponse element, which
// contains metadata about the health check.
func (c *Route53) UpdateHealthCheck(input *UpdateHealthCheckInput) (*UpdateHealthCheckOutput, error) {
	req, out := c.UpdateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHostedZoneComment = "UpdateHostedZoneComment"

// UpdateHostedZoneCommentRequest generates a request for the UpdateHostedZoneComment operation.
func (c *Route53) UpdateHostedZoneCommentRequest(input *UpdateHostedZoneCommentInput) (req *request.Request, output *UpdateHostedZoneCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateHostedZoneComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &UpdateHostedZoneCommentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHostedZoneCommentOutput{}
	req.Data = output
	return
}

// To update the hosted zone comment, send a POST request to the /Route 53 API
// version/hostedzone/hosted zone ID resource. The request body must include
// a document with a UpdateHostedZoneCommentRequest element. The response to
// this request includes the modified HostedZone element.
//
//  The comment can have a maximum length of 256 characters.
func (c *Route53) UpdateHostedZoneComment(input *UpdateHostedZoneCommentInput) (*UpdateHostedZoneCommentOutput, error) {
	req, out := c.UpdateHostedZoneCommentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTrafficPolicyComment = "UpdateTrafficPolicyComment"

// UpdateTrafficPolicyCommentRequest generates a request for the UpdateTrafficPolicyComment operation.
func (c *Route53) UpdateTrafficPolicyCommentRequest(input *UpdateTrafficPolicyCommentInput) (req *request.Request, output *UpdateTrafficPolicyCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyCommentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTrafficPolicyCommentOutput{}
	req.Data = output
	return
}

// Updates the comment for a specified traffic policy version.
//
// To update the comment, send a POST request to the /Route 53 API version/trafficpolicy/
// resource.
//
// The request body must include a document with an UpdateTrafficPolicyCommentRequest
// element.
func (c *Route53) UpdateTrafficPolicyComment(input *UpdateTrafficPolicyCommentInput) (*UpdateTrafficPolicyCommentOutput, error) {
	req, out := c.UpdateTrafficPolicyCommentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTrafficPolicyInstance = "UpdateTrafficPolicyInstance"

// UpdateTrafficPolicyInstanceRequest generates a request for the UpdateTrafficPolicyInstance operation.
func (c *Route53) UpdateTrafficPolicyInstanceRequest(input *UpdateTrafficPolicyInstanceInput) (req *request.Request, output *UpdateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// Updates the resource record sets in a specified hosted zone that were created
// based on the settings in a specified traffic policy version.
//
// The DNS type of the resource record sets that you're updating must match
// the DNS type in the JSON document that is associated with the traffic policy
// version that you're using to update the traffic policy instance. When you
// update a traffic policy instance, Amazon Route 53 continues to respond to
// DNS queries for the root resource record set name (such as example.com) while
// it replaces one group of resource record sets with another. Amazon Route
// 53 performs the following operations:
//
//  Amazon Route 53 creates a new group of resource record sets based on the
// specified traffic policy. This is true regardless of how substantial the
// differences are between the existing resource record sets and the new resource
// record sets.  When all of the new resource record sets have been created,
// Amazon Route 53 starts to respond to DNS queries for the root resource record
// set name (such as example.com) by using the new resource record sets. Amazon
// Route 53 deletes the old group of resource record sets that are associated
// with the root resource record set name.  To update a traffic policy instance,
// send a POST request to the /Route 53 API version/trafficpolicyinstance/traffic
// policy ID resource. The request body must include a document with an UpdateTrafficPolicyInstanceRequest
// element.
func (c *Route53) UpdateTrafficPolicyInstance(input *UpdateTrafficPolicyInstanceInput) (*UpdateTrafficPolicyInstanceOutput, error) {
	req, out := c.UpdateTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

// Alias resource record sets only: Information about the CloudFront distribution,
// ELB load balancer, Amazon S3 bucket, or Amazon Route 53 resource record set
// to which you are routing traffic.
//
// If you're creating resource record sets for a private hosted zone, note
// the following:
//
//  You can create alias resource record sets only for Amazon Route 53 resource
// record sets in the same private hosted zone. Creating alias resource record
// sets for CloudFront distributions, ELB load balancers, and Amazon S3 buckets
// is not supported. You can't create alias resource record sets for failover,
// geolocation, or latency resource record sets in a private hosted zone.  For
// more information and an example, see Example: Creating Alias Resource Record
// Sets (http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html)
// in the Amazon Route 53 API Reference.
type AliasTarget struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: The external DNS name associated with the
	// AWS Resource. The value that you specify depends on where you want to route
	// queries:
	//
	//  A CloudFront distribution: Specify the domain name that CloudFront assigned
	// when you created your distribution. Your CloudFront distribution must include
	// an alternate domain name that matches the name of the resource record set.
	// For example, if the name of the resource record set is acme.example.com,
	// your CloudFront distribution must include acme.example.com as one of the
	// alternate domain names. For more information, see Using Alternate Domain
	// Names (CNAMEs) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html)
	// in the Amazon CloudFront Developer Guide. An ELB load balancer: Specify the
	// DNS name associated with the load balancer. You can get the DNS name by using
	// the AWS Management Console, the ELB API, or the AWS CLI. Use the same method
	// to get values for HostedZoneId and DNSName. If you get one value from the
	// console and the other value from the API or the CLI, creating the resource
	// record set will fail. An Elastic Beanstalk environment: Specify the CNAME
	// attribute for the environment. (The environment must have a regionalized
	// domain name.)  An Amazon S3 bucket that is configured as a static website:
	// Specify the domain name of the Amazon S3 website endpoint in which you created
	// the bucket; for example, s3-website-us-east-1.amazonaws.com. For more information
	// about valid values, see the table Amazon Simple Storage Service (S3) Website
	// Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the Amazon Web Services General Reference. For more information about
	// using Amazon S3 buckets for websites, see Hosting a Static Website on Amazon
	// S3 (http://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html) in
	// the Amazon Simple Storage Service Developer Guide. Another Amazon Route 53
	// resource record set: Specify the value of the Name element for a resource
	// record set in the current hosted zone.  For more information and an example,
	// see Example: Creating Alias Resource Record Sets (http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html)
	// in the Amazon Route 53 API Reference.
	DNSName *string `type:"string" required:"true"`

	// Alias resource record sets only: If you set the value of EvaluateTargetHealth
	// to true for the resource record set or sets in an alias, weighted alias,
	// latency alias, or failover alias resource record set, and if you specify
	// a value for HealthCheckId for every resource record set that is referenced
	// by these alias resource record sets, the alias resource record sets inherit
	// the health of the referenced resource record sets.
	//
	// In this configuration, when Amazon Route 53 receives a DNS query for an
	// alias resource record set:
	//
	//  Amazon Route 53 looks at the resource record sets that are referenced by
	// the alias resource record sets to determine which health checks they're using.
	// Amazon Route 53 checks the current status of each health check. (Amazon Route
	// 53 periodically checks the health of the endpoint that is specified in a
	// health check; it doesn't perform the health check when the DNS query arrives.)
	// Based on the status of the health checks, Amazon Route 53 determines which
	// resource record sets are healthy. Unhealthy resource record sets are immediately
	// removed from consideration. In addition, if all of the resource record sets
	// that are referenced by an alias resource record set are unhealthy, that alias
	// resource record set also is immediately removed from consideration. Based
	// on the configuration of the alias resource record sets (weighted alias or
	// latency alias, for example) and the configuration of the resource record
	// sets that they reference, Amazon Route 53 chooses a resource record set from
	// the healthy resource record sets, and responds to the query.  Note the following:
	//
	// You cannot set EvaluateTargetHealth to true when the alias target is a CloudFront
	// distribution. If the AWS resource that you specify in AliasTarget is a resource
	// record set or a group of resource record sets (for example, a group of weighted
	// resource record sets), but it is not another alias resource record set, we
	// recommend that you associate a health check with all of the resource record
	// sets in the alias target. For more information, see What Happens When You
	// Omit Health Checks? (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting)
	// in the Amazon Route 53 Developer Guide. If you specify an ELB load balancer
	// in AliasTarget, Elastic Load Balancing routes queries only to the healthy
	// Amazon EC2 instances that are registered with the load balancer. If no Amazon
	// EC2 instances are healthy or if the load balancer itself is unhealthy, and
	// if EvaluateTargetHealth is true for the corresponding alias resource record
	// set, Amazon Route 53 routes queries to other resources. When you create a
	// load balancer, you configure settings for Elastic Load Balancing health checks;
	// they're not Amazon Route 53 health checks, but they perform a similar function.
	// Do not create Amazon Route 53 health checks for the Amazon EC2 instances
	// that you register with an ELB load balancer. For more information, see How
	// Health Checks Work in More Complex Amazon Route 53 Configurations (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html)
	// in the Amazon Route 53 Developer Guide.  We recommend that you set EvaluateTargetHealth
	// to true only when you have enough idle capacity to handle the failure of
	// one or more endpoints.
	//
	// For more information and examples, see Amazon Route 53 Health Checks and
	// DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	// in the Amazon Route 53 Developer Guide.
	EvaluateTargetHealth *bool `type:"boolean" required:"true"`

	// Alias resource record sets only: The value you use depends on where you want
	// to route queries:
	//
	//  A CloudFront distribution: Specify Z2FDTNDATAQYW2. An ELB load balancer:
	// Specify the value of the hosted zone ID for the load balancer. You can get
	// the hosted zone ID by using the AWS Management Console, the ELB API, or the
	// AWS CLI. Use the same method to get values for HostedZoneId and DNSName.
	// If you get one value from the console and the other value from the API or
	// the CLI, creating the resource record set will fail. An Amazon S3 bucket
	// that is configured as a static website: Specify the hosted zone ID for the
	// Amazon S3 website endpoint in which you created the bucket. For more information
	// about valid values, see the table Amazon Simple Storage Service (S3) Website
	// Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the Amazon Web Services General Reference. Another Amazon Route 53 resource
	// record set in your hosted zone: Specify the hosted zone ID of your hosted
	// zone. (An alias resource record set cannot reference a resource record set
	// in a different hosted zone.)  For more information and an example, see Example:
	// Creating Alias Resource Record Sets (http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html)
	// in the Amazon Route 53 API Reference.
	HostedZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AliasTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasTarget) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to associate a
// VPC with an hosted zone.
type AssociateVPCWithHostedZoneInput struct {
	_ struct{} `locationName:"AssociateVPCWithHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: Any comments you want to include about a AssociateVPCWithHostedZoneRequest.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to associate your VPC with.
	//
	// Note that you cannot associate a VPC with a hosted zone that doesn't have
	// an existing VPC association.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The VPC that you want your hosted zone to be associated with.
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type AssociateVPCWithHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID, the status, and the date and time of
	// your AssociateVPCWithHostedZoneRequest.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information for each change in a change
// batch request.
type Change struct {
	_ struct{} `type:"structure"`

	// The action to perform:
	//
	//  CREATE: Creates a resource record set that has the specified values. DELETE:
	// Deletes a existing resource record set that has the specified values for
	// Name, Type, SetIdentifier (for latency, weighted, geolocation, and failover
	// resource record sets), and TTL (except alias resource record sets, for which
	// the TTL is determined by the AWS resource that you're routing DNS queries
	// to). UPSERT: If a resource record set does not already exist, Amazon Route
	// 53 creates it. If a resource record set does exist, Amazon Route 53 updates
	// it with the values in the request. Amazon Route 53 can update an existing
	// resource record set only when all of the following values match: Name, Type,
	// and SetIdentifier (for weighted, latency, geolocation, and failover resource
	// record sets).
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the resource record set to create or delete.
	ResourceRecordSet *ResourceRecordSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// A complex type that contains an optional comment and the changes that you
// want to make with a change batch request.
type ChangeBatch struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one Change element for each resource record
	// set that you want to create or delete.
	Changes []*Change `locationNameList:"Change" min:"1" type:"list" required:"true"`

	// Optional: Any comments you want to include about a change batch request.
	Comment *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatch) GoString() string {
	return s.String()
}

// A complex type that lists the changes and information for a ChangeBatch.
type ChangeBatchRecord struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// A list of changes made in the ChangeBatch.
	Changes []*Change `locationNameList:"Change" min:"1" type:"list"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request. Use this ID to track when the change has completed
	// across all Amazon Route 53 DNS servers.
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Valid Values: PENDING | INSYNC
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time the change was submitted, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC).
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID attached to the changes.
	Submitter *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatchRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatchRecord) GoString() string {
	return s.String()
}

// A complex type that describes change information about changes made to your
// hosted zone.
//
// This element contains an ID that you use when performing a GetChange action
// to get detailed information about the change.
type ChangeInfo struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request. Use this ID to track when the change has completed
	// across all Amazon Route 53 DNS servers.
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Valid Values: PENDING | INSYNC
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time the change was submitted, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC).
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ChangeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeInfo) GoString() string {
	return s.String()
}

// A complex type that contains a change batch.
type ChangeResourceRecordSetsInput struct {
	_ struct{} `locationName:"ChangeResourceRecordSetsRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains an optional comment and the Changes element.
	ChangeBatch *ChangeBatch `type:"structure" required:"true"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to change.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsInput) GoString() string {
	return s.String()
}

// A complex type containing the response for the request.
type ChangeResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about changes made to your hosted
	// zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request to add, change, or
// delete the tags that are associated with a resource.
type ChangeTagsForResourceInput struct {
	_ struct{} `locationName:"ChangeTagsForResourceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains a list of Tag elements. Each Tag element identifies
	// a tag that you want to add or update for the specified resource.
	AddTags []*Tag `locationNameList:"Tag" min:"1" type:"list"`

	// A list of Tag keys that you want to remove from the specified resource.
	RemoveTagKeys []*string `locationNameList:"Key" min:"1" type:"list"`

	// The ID of the resource for which you want to add, change, or delete tags.
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ChangeTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type ChangeTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangeTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceOutput) GoString() string {
	return s.String()
}

// >A complex type that contains information about the request to create a health
// check.
type CreateHealthCheckInput struct {
	_ struct{} `locationName:"CreateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateHealthCheck
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a health
	// check. CallerReference can be any unique string; you might choose to use
	// a string that identifies your project.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains health check configuration.
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the new health check.
type CreateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains identifying information about the health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The unique URL representing the new health check.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to create a hosted
// zone.
type CreateHostedZoneInput struct {
	_ struct{} `locationName:"CreateHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateHostedZone
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a hosted
	// zone. CallerReference can be any unique string; you might choose to use a
	// string that identifies your project, such as DNSMigration_01.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// The delegation set id of the reusable delgation set whose NS records you
	// want to assign to the new hosted zone.
	DelegationSetId *string `type:"string"`

	// A complex type that contains an optional comment about your hosted zone.
	HostedZoneConfig *HostedZoneConfig `type:"structure"`

	// The name of the domain. This must be a fully-specified domain, for example,
	// www.example.com. The trailing dot is optional; Amazon Route 53 assumes that
	// the domain name is fully qualified. This means that Amazon Route 53 treats
	// www.example.com (without a trailing dot) and www.example.com. (with a trailing
	// dot) as identical.
	//
	// This is the name you have registered with your DNS registrar. You should
	// ask your registrar to change the authoritative name servers for your domain
	// to the set of NameServers elements returned in DelegationSet.
	Name *string `type:"string" required:"true"`

	// The VPC that you want your hosted zone to be associated with. By providing
	// this parameter, your newly created hosted cannot be resolved anywhere other
	// than the given VPC.
	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the new hosted zone.
type CreateHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the request to create a hosted
	// zone. This includes an ID that you use when you call the GetChange action
	// to get the current status of the change request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	// A complex type that contains name server information.
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// A complex type that contains identifying information about the hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`

	// The unique URL representing the new hosted zone.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneOutput) GoString() string {
	return s.String()
}

type CreateReusableDelegationSetInput struct {
	_ struct{} `locationName:"CreateReusableDelegationSetRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateReusableDelegationSet
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a reusable
	// delegation set. CallerReference can be any unique string; you might choose
	// to use a string that identifies your project, such as DNSMigration_01.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// The ID of the hosted zone whose delegation set you want to mark as reusable.
	// It is an optional parameter.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetInput) GoString() string {
	return s.String()
}

type CreateReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains name server information.
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// The unique URL representing the new reusbale delegation set.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy that you
// want to create.
type CreateTrafficPolicyInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Any comments that you want to include about the traffic policy.
	Comment *string `type:"string"`

	// The definition of this traffic policy in JSON format.
	Document *string `type:"string" required:"true"`

	// The name of the traffic policy.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// you want to create based on a specified traffic policy.
type CreateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the hosted zone in which you want Amazon Route 53 to create resource
	// record sets by using the configuration in a traffic policy.
	HostedZoneId *string `type:"string" required:"true"`

	// The domain name (such as example.com) or subdomain name (such as www.example.com)
	// for which Amazon Route 53 responds to DNS queries by using the resource record
	// sets that Amazon Route 53 creates for this traffic policy instance.
	Name *string `type:"string" required:"true"`

	// The TTL that you want Amazon Route 53 to assign to all of the resource record
	// sets that it creates in the specified hosted zone.
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want to use to create resource record
	// sets in the specified hosted zone.
	TrafficPolicyId *string `type:"string" required:"true"`

	// The version of the traffic policy that you want to use to create resource
	// record sets in the specified hosted zone.
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the CreateTrafficPolicyInstance
// request.
type CreateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy instance.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy instance.
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the CreateTrafficPolicy
// request.
type CreateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy.
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy for which
// you want to create a new version.
type CreateTrafficPolicyVersionInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyVersionRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Any comments that you want to include about the new traffic policy version.
	Comment *string `type:"string"`

	// The definition of a new traffic policy version, in JSON format. You must
	// specify the full definition of the new traffic policy. You cannot specify
	// just the differences between the new version and a previous version.
	Document *string `type:"string" required:"true"`

	// The ID of the traffic policy for which you want to create a new version.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the CreateTrafficPolicyVersion
// request.
type CreateTrafficPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new version of the traffic
	// policy.
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionOutput) GoString() string {
	return s.String()
}

// A complex type that contains name server information.
type DelegationSet struct {
	_ struct{} `type:"structure"`

	CallerReference *string `min:"1" type:"string"`

	Id *string `type:"string"`

	// A complex type that contains the authoritative name servers for the hosted
	// zone. Use the method provided by your domain registrar to add an NS record
	// to your domain for each NameServer that is assigned to your hosted zone.
	NameServers []*string `locationNameList:"NameServer" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DelegationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegationSet) GoString() string {
	return s.String()
}

// A complex type containing the request information for delete health check.
type DeleteHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The ID of the health check to delete.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type DeleteHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the hosted zone that you want
// to delete.
type DeleteHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone you want to delete.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type DeleteHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID, the status, and the date and time of
	// your delete request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type containing the information for the delete request.
type DeleteReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set you want to delete.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type DeleteReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A request to delete a specified traffic policy version.
type DeleteTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy that you want to delete.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version number of the traffic policy that you want to delete.
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy instance
// that you want to delete.
type DeleteTrafficPolicyInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy instance that you want to delete.
	//
	// When you delete a traffic policy instance, Amazon Route 53 also deletes
	// all of the resource record sets that were created when you created the traffic
	// policy instance.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// An empty element.
type DeleteTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// An empty element.
type DeleteTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to disassociate
// a VPC from an hosted zone.
type DisassociateVPCFromHostedZoneInput struct {
	_ struct{} `locationName:"DisassociateVPCFromHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: Any comments you want to include about a DisassociateVPCFromHostedZoneRequest.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to disassociate your VPC from.
	//
	// Note that you cannot disassociate the last VPC from a hosted zone.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The VPC that you want your hosted zone to be disassociated from.
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type DisassociateVPCFromHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID, the status, and the date and time of
	// your DisassociateVPCFromHostedZoneRequest.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about a geo location.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `min:"2" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	SubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// A complex type that contains information about a GeoLocation.
type GeoLocationDetails struct {
	_ struct{} `type:"structure"`

	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	ContinentCode *string `min:"2" type:"string"`

	// The name of the continent. This element is only present if ContinentCode
	// is also present.
	ContinentName *string `min:"1" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `min:"1" type:"string"`

	// The name of the country. This element is only present if CountryCode is also
	// present.
	CountryName *string `min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	SubdivisionCode *string `min:"1" type:"string"`

	// The name of the subdivision. This element is only present if SubdivisionCode
	// is also present.
	SubdivisionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocationDetails) GoString() string {
	return s.String()
}

// The input for a GetChangeDetails request.
type GetChangeDetailsInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeDetailsInput) GoString() string {
	return s.String()
}

// A complex type that contains the ChangeBatchRecord element.
type GetChangeDetailsOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// A complex type that contains information about the specified change batch,
	// including the change batch ID, the status of the change, and the contained
	// changes.
	ChangeBatchRecord *ChangeBatchRecord `deprecated:"true" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeDetailsOutput) GoString() string {
	return s.String()
}

// The input for a GetChange request.
type GetChangeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeInput) GoString() string {
	return s.String()
}

// A complex type that contains the ChangeInfo element.
type GetChangeOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified change batch,
	// including the change batch ID, the status of the change, and the date and
	// time of the request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeOutput) GoString() string {
	return s.String()
}

// Empty request.
type GetCheckerIpRangesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetCheckerIpRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesInput) GoString() string {
	return s.String()
}

// A complex type that contains the CheckerIpRanges element.
type GetCheckerIpRangesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains sorted list of IP ranges in CIDR format for
	// Amazon Route 53 health checkers.
	CheckerIpRanges []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetCheckerIpRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get a geo location.
type GetGeoLocationInput struct {
	_ struct{} `type:"structure"`

	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `location:"querystring" locationName:"continentcode" min:"2" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `location:"querystring" locationName:"countrycode" min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	SubdivisionCode *string `location:"querystring" locationName:"subdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s GetGeoLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified geo location.
type GetGeoLocationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the information about the specified geo location.
	GeoLocationDetails *GeoLocationDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGeoLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your health checks, send a GET request to the
// /Route 53 API version/healthcheckcount resource.
type GetHealthCheckCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the count of health checks associated with the
// current AWS account.
type GetHealthCheckCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of health checks associated with the current AWS account.
	HealthCheckCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get a health
// check.
type GetHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The ID of the health check to retrieve.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get the most
// recent failure reason for a health check.
type GetHealthCheckLastFailureReasonInput struct {
	_ struct{} `type:"structure"`

	// The ID of the health check for which you want to retrieve the reason for
	// the most recent failure.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the most recent failure for
// the specified health check.
type GetHealthCheckLastFailureReasonOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HealthCheckObservation element for each Amazon Route
	// 53 health checker.
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified health check.
type GetHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the information about the specified health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get health
// check status for a health check.
type GetHealthCheckStatusInput struct {
	_ struct{} `type:"structure"`

	// If you want Amazon Route 53 to return this resource record set in response
	// to a DNS query only when a health check is passing, include the HealthCheckId
	// element and specify the ID of the applicable health check.
	//
	// Amazon Route 53 determines whether a resource record set is healthy by periodically
	// sending a request to the endpoint that is specified in the health check.
	// If that endpoint returns an HTTP status code of 2xx or 3xx, the endpoint
	// is healthy. If the endpoint returns an HTTP status code of 400 or greater,
	// or if the endpoint doesn't respond for a certain amount of time, Amazon Route
	// 53 considers the endpoint unhealthy and also considers the resource record
	// set unhealthy.
	//
	// The HealthCheckId element is only useful when Amazon Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you
	// want Amazon Route 53 to base the choice in part on the status of a health
	// check. Configuring health checks only makes sense in the following configurations:
	//
	//  You're checking the health of the resource record sets in a weighted, latency,
	// geolocation, or failover resource record set, and you specify health check
	// IDs for all of the resource record sets. If the health check for one resource
	// record set specifies an endpoint that is not healthy, Amazon Route 53 stops
	// responding to queries using the value for that resource record set. You set
	// EvaluateTargetHealth to true for the resource record sets in an alias, weighted
	// alias, latency alias, geolocation alias, or failover alias resource record
	// set, and you specify health check IDs for all of the resource record sets
	// that are referenced by the alias resource record sets. For more information
	// about this configuration, see EvaluateTargetHealth.
	//
	// Amazon Route 53 doesn't check the health of the endpoint specified in the
	// resource record set, for example, the endpoint specified by the IP address
	// in the Value element. When you add a HealthCheckId element to a resource
	// record set, Amazon Route 53 checks the health of the endpoint that you specified
	// in the health check.
	//
	//   For geolocation resource record sets, if an endpoint is unhealthy, Amazon
	// Route 53 looks for a resource record set for the larger, associated geographic
	// region. For example, suppose you have resource record sets for a state in
	// the United States, for the United States, for North America, and for all
	// locations. If the endpoint for the state resource record set is unhealthy,
	// Amazon Route 53 checks the resource record sets for the United States, for
	// North America, and for all locations (a resource record set for which the
	// value of CountryCode is *), in that order, until it finds a resource record
	// set for which the endpoint is healthy.
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create
	// a health check for each HTTP server that is serving content for www.example.com.
	// For the value of FullyQualifiedDomainName, specify the domain name of the
	// server (such as us-east-1-www.example.com), not the name of the resource
	// record sets (example.com).
	//
	// In this configuration, if you create a health check for which the value
	// of FullyQualifiedDomainName matches the name of the resource record sets
	// and then associate the health check with those resource record sets, health
	// check results will be unpredictable.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the status of the specified
// health check.
type GetHealthCheckStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HealthCheckObservation element for each Amazon Route
	// 53 health checker.
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your hosted zones, send a GET request to the /Route
// 53 API version/hostedzonecount resource.
type GetHostedZoneCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the count of hosted zones associated with the
// current AWS account.
type GetHostedZoneCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of hosted zones associated with the current AWS account.
	HostedZoneCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountOutput) GoString() string {
	return s.String()
}

// The input for a GetHostedZone request.
type GetHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone for which you want to get a list of the name servers
	// in the delegation set.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified hosted zone.
type GetHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the name servers for the specified
	// hosted zone.
	DelegationSet *DelegationSet `type:"structure"`

	// A complex type that contains the information about the specified hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`

	// A complex type that contains information about VPCs associated with the specified
	// hosted zone.
	VPCs []*VPC `locationNameList:"VPC" min:"1" type:"list"`
}

// String returns the string representation
func (s GetHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneOutput) GoString() string {
	return s.String()
}

// The input for a GetReusableDelegationSet request.
type GetReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set for which you want to get a list of
	// the name server.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified reusable delegation
// set.
type GetReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the information about the nameservers for the
	// specified delegation set ID.
	DelegationSet *DelegationSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// Gets information about a specific traffic policy version. To get the information,
// send a GET request to the /Route 53 API version/trafficpolicy resource, and
// specify the ID and the version of the traffic policy.
type GetTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy that you want to get information about.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version number of the traffic policy that you want to get information
	// about.
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInput) GoString() string {
	return s.String()
}

// To retrieve a count of all your traffic policy instances, send a GET request
// to the /Route 53 API version/trafficpolicyinstancecount resource.
type GetTrafficPolicyInstanceCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the number of traffic policy
// instances that are associated with the current AWS account.
type GetTrafficPolicyInstanceCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of traffic policy instances that are associated with the current
	// AWS account.
	TrafficPolicyInstanceCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) GoString() string {
	return s.String()
}

// Gets information about a specified traffic policy instance.
//
// To get information about a traffic policy instance, send a GET request to
// the /Route 53 API version/trafficpolicyinstance/Id resource.
type GetTrafficPolicyInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy instance that you want to get information about.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type GetTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the traffic policy instance.
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type GetTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains identifying information about the health check.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request to create the health check.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains the health check configuration.
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	// The version of the health check. You can optionally pass this value in a
	// call to UpdateHealthCheck to prevent overwriting another change to the health
	// check.
	HealthCheckVersion *int64 `min:"1" type:"long" required:"true"`

	// The ID of the specified health check.
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheck) GoString() string {
	return s.String()
}

// A complex type that contains the health check configuration.
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// For a specified parent health check, a list of HealthCheckId values for the
	// associated child health checks.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. If you
	// don't specify a value for EnableSNI, Amazon Route 53 defaults to true when
	// Type is HTTPS or HTTPS_STR_MATCH and defaults to false when Type is any other
	// value.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa.
	//
	// Valid values are integers between 1 and 10. For more information, see "How
	// Amazon Route 53 Determines Whether an Endpoint Is Healthy" in the Amazon
	// Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Fully qualified domain name of the instance to be health checked.
	FullyQualifiedDomainName *string `type:"string"`

	// The minimum number of child health checks that must be healthy for Amazon
	// Route 53 to consider the parent health check to be healthy. Valid values
	// are integers between 0 and 256, inclusive.
	HealthThreshold *int64 `type:"integer"`

	// IP Address of the instance being checked.
	IPAddress *string `type:"string"`

	// A boolean value that indicates whether the status of health check should
	// be inverted. For example, if a health check is healthy but Inverted is True,
	// then Amazon Route 53 considers the health check to be unhealthy.
	Inverted *bool `type:"boolean"`

	// A Boolean value that indicates whether you want Amazon Route 53 to measure
	// the latency between health checkers in multiple AWS regions and your endpoint
	// and to display CloudWatch latency graphs in the Amazon Route 53 console.
	MeasureLatency *bool `type:"boolean"`

	// Port on which connection will be opened to the instance to health check.
	// For HTTP and HTTP_STR_MATCH this defaults to 80 if the port is not specified.
	// For HTTPS and HTTPS_STR_MATCH this defaults to 443 if the port is not specified.
	Port *int64 `min:"1" type:"integer"`

	// The number of seconds between the time that Amazon Route 53 gets a response
	// from your endpoint and the time that it sends the next health-check request.
	//
	// Each Amazon Route 53 health checker makes requests at this interval. Valid
	// values are 10 and 30. The default value is 30.
	RequestInterval *int64 `min:"10" type:"integer"`

	// Path to ping on the instance to check the health. Required for HTTP, HTTPS,
	// HTTP_STR_MATCH, and HTTPS_STR_MATCH health checks. The HTTP request is issued
	// to the instance on the given port and path.
	ResourcePath *string `type:"string"`

	// A string to search for in the body of a health check response. Required for
	// HTTP_STR_MATCH and HTTPS_STR_MATCH health checks. Amazon Route 53 considers
	// case when searching for SearchString in the response body.
	SearchString *string `type:"string"`

	// The type of health check to be performed. Currently supported types are TCP,
	// HTTP, HTTPS, HTTP_STR_MATCH, and HTTPS_STR_MATCH.
	Type *string `type:"string" required:"true" enum:"HealthCheckType"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// A complex type that contains the IP address of a Amazon Route 53 health checker
// and the reason for the health check status.
type HealthCheckObservation struct {
	_ struct{} `type:"structure"`

	// The IP address of the Amazon Route 53 health checker that performed the health
	// check.
	IPAddress *string `type:"string"`

	// A complex type that contains information about the health check status for
	// the current observation.
	StatusReport *StatusReport `type:"structure"`
}

// String returns the string representation
func (s HealthCheckObservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckObservation) GoString() string {
	return s.String()
}

// A complex type that contain information about the specified hosted zone.
type HostedZone struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request to create the hosted zone.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains the Comment element.
	Config *HostedZoneConfig `type:"structure"`

	// The ID of the specified hosted zone.
	Id *string `type:"string" required:"true"`

	// The name of the domain. This must be a fully-specified domain, for example,
	// www.example.com. The trailing dot is optional; Amazon Route 53 assumes that
	// the domain name is fully qualified. This means that Amazon Route 53 treats
	// www.example.com (without a trailing dot) and www.example.com. (with a trailing
	// dot) as identical.
	//
	// This is the name you have registered with your DNS registrar. You should
	// ask your registrar to change the authoritative name servers for your domain
	// to the set of NameServers elements returned in DelegationSet.
	Name *string `type:"string" required:"true"`

	// Total number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64 `type:"long"`
}

// String returns the string representation
func (s HostedZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZone) GoString() string {
	return s.String()
}

// A complex type that contains an optional comment about your hosted zone.
// If you don't want to specify a comment, you can omit the HostedZoneConfig
// and Comment elements from the XML document.
type HostedZoneConfig struct {
	_ struct{} `type:"structure"`

	// An optional comment about your hosted zone. If you don't want to specify
	// a comment, you can omit the HostedZoneConfig and Comment elements from the
	// XML document.
	Comment *string `type:"string"`

	PrivateZone *bool `type:"boolean"`
}

// String returns the string representation
func (s HostedZoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneConfig) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByHostedZone request.
type ListChangeBatchesByHostedZoneInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The end of the time period you want to see changes for.
	EndDate *string `location:"querystring" locationName:"endDate" deprecated:"true" type:"string" required:"true"`

	// The ID of the hosted zone that you want to see changes for.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The page marker.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of items on a page.
	MaxItems *string `location:"querystring" locationName:"maxItems" type:"string"`

	// The start of the time period you want to see changes for.
	StartDate *string `location:"querystring" locationName:"startDate" deprecated:"true" type:"string" required:"true"`
}

// String returns the string representation
func (s ListChangeBatchesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByHostedZoneInput) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByHostedZone request.
type ListChangeBatchesByHostedZoneOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The change batches within the given hosted zone and time period.
	ChangeBatchRecords []*ChangeBatchRecord `locationNameList:"ChangeBatchRecord" min:"1" deprecated:"true" type:"list" required:"true"`

	// A flag that indicates if there are more change batches to list.
	IsTruncated *bool `type:"boolean"`

	// The page marker.
	Marker *string `type:"string" required:"true"`

	// The maximum number of items on a page.
	MaxItems *string `type:"string" required:"true"`

	// The next page marker.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListChangeBatchesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByHostedZoneOutput) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByRRSet request.
type ListChangeBatchesByRRSetInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The end of the time period you want to see changes for.
	EndDate *string `location:"querystring" locationName:"endDate" deprecated:"true" type:"string" required:"true"`

	// The ID of the hosted zone that you want to see changes for.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The page marker.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of items on a page.
	MaxItems *string `location:"querystring" locationName:"maxItems" type:"string"`

	// The name of the RRSet that you want to see changes for.
	Name *string `location:"querystring" locationName:"rrSet_name" type:"string" required:"true"`

	// The identifier of the RRSet that you want to see changes for.
	SetIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The start of the time period you want to see changes for.
	StartDate *string `location:"querystring" locationName:"startDate" deprecated:"true" type:"string" required:"true"`

	// The type of the RRSet that you want to see changes for.
	Type *string `location:"querystring" locationName:"type" type:"string" required:"true" enum:"RRType"`
}

// String returns the string representation
func (s ListChangeBatchesByRRSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByRRSetInput) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByRRSet request.
type ListChangeBatchesByRRSetOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The change batches within the given hosted zone and time period.
	ChangeBatchRecords []*ChangeBatchRecord `locationNameList:"ChangeBatchRecord" min:"1" deprecated:"true" type:"list" required:"true"`

	// A flag that indicates if there are more change batches to list.
	IsTruncated *bool `type:"boolean"`

	// The page marker.
	Marker *string `type:"string" required:"true"`

	// The maximum number of items on a page.
	MaxItems *string `type:"string" required:"true"`

	// The next page marker.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListChangeBatchesByRRSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByRRSetOutput) GoString() string {
	return s.String()
}

// The input for a ListGeoLocations request.
type ListGeoLocationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of geo locations you want in the response body.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The first continent code in the lexicographic ordering of geo locations that
	// you want the ListGeoLocations request to list. For non-continent geo locations,
	// this should be null.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	StartContinentCode *string `location:"querystring" locationName:"startcontinentcode" min:"2" type:"string"`

	// The first country code in the lexicographic ordering of geo locations that
	// you want the ListGeoLocations request to list.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	StartCountryCode *string `location:"querystring" locationName:"startcountrycode" min:"1" type:"string"`

	// The first subdivision code in the lexicographic ordering of geo locations
	// that you want the ListGeoLocations request to list.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	StartSubdivisionCode *string `location:"querystring" locationName:"startsubdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the geo locations that are
// returned by the request and information about the response.
type ListGeoLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the geo locations that are
	// returned by the request.
	GeoLocationDetailsList []*GeoLocationDetails `locationNameList:"GeoLocationDetails" type:"list" required:"true"`

	// A flag that indicates whether there are more geo locations to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the values included in the ListGeoLocationsResponse$NextContinentCode,
	// ListGeoLocationsResponse$NextCountryCode and ListGeoLocationsResponse$NextSubdivisionCode
	// elements.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested. The maximum value of MaxItems
	// is 100.
	MaxItems *string `type:"string" required:"true"`

	// If the results were truncated, the continent code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location to list is a continent location.
	NextContinentCode *string `min:"2" type:"string"`

	// If the results were truncated, the country code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location to list is not a continent location.
	NextCountryCode *string `min:"1" type:"string"`

	// If the results were truncated, the subdivision code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location has a subdivision.
	NextSubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your health checks, send a GET request to the /Route
// 53 API version/healthcheck resource. The response to this request includes
// a HealthChecks element with zero or more HealthCheck child elements. By default,
// the list of health checks is displayed on a single page. You can control
// the length of the page that is displayed by using the MaxItems parameter.
// You can use the Marker parameter to control the health check that the list
// begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
type ListHealthChecksInput struct {
	_ struct{} `type:"structure"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of health checks to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHealthChecksOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the health checks associated
	// with the current AWS account.
	HealthChecks []*HealthCheck `locationNameList:"HealthCheck" type:"list" required:"true"`

	// A flag indicating whether there are more health checks to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of health checks to be included in the response body.
	// If the number of health checks associated with this AWS account exceeds MaxItems,
	// the value of ListHealthChecksResponse$IsTruncated in the response is true.
	// Call ListHealthChecks again and specify the value of ListHealthChecksResponse$NextMarker
	// in the ListHostedZonesRequest$Marker element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing health checks. If ListHealthChecksResponse$IsTruncated
	// is true, make another request to ListHealthChecks and include the value of
	// the NextMarker element in the Marker element to get the next page of results.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your hosted zones in lexicographic order, send a GET
// request to the /Route 53 API version/hostedzonesbyname resource. The response
// to this request includes a HostedZones element with zero or more HostedZone
// child elements lexicographically ordered by DNS name. By default, the list
// of hosted zones is displayed on a single page. You can control the length
// of the page that is displayed by using the MaxItems parameter. You can use
// the DNSName and HostedZoneId parameters to control the hosted zone that the
// list begins with.
//
// For more information about listing hosted zones, see Listing the Hosted
// Zones for an AWS Account (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ListInfoOnHostedZone.html)
// in the Amazon Route 53 Developer Guide.
type ListHostedZonesByNameInput struct {
	_ struct{} `type:"structure"`

	// The first name in the lexicographic ordering of domain names that you want
	// the ListHostedZonesByNameRequest request to list.
	//
	// If the request returned more than one page of results, submit another request
	// and specify the value of NextDNSName and NextHostedZoneId from the last response
	// in the DNSName and HostedZoneId parameters to get the next page of results.
	DNSName *string `location:"querystring" locationName:"dnsname" type:"string"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextDNSName and NextHostedZoneId from the last response
	// in the DNSName and HostedZoneId parameters to get the next page of results.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// Specify the maximum number of hosted zones to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHostedZonesByNameOutput struct {
	_ struct{} `type:"structure"`

	// The DNSName value sent in the request.
	DNSName *string `type:"string"`

	// The HostedZoneId value sent in the request.
	HostedZoneId *string `type:"string"`

	// A complex type that contains information about the hosted zones associated
	// with the current AWS account.
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the NextDNSName and NextHostedZoneId elements.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of hosted zones to be included in the response body. If
	// the number of hosted zones associated with this AWS account exceeds MaxItems,
	// the value of ListHostedZonesByNameResponse$IsTruncated in the response is
	// true. Call ListHostedZonesByName again and specify the value of ListHostedZonesByNameResponse$NextDNSName
	// and ListHostedZonesByNameResponse$NextHostedZoneId elements respectively
	// to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// If ListHostedZonesByNameResponse$IsTruncated is true, there are more hosted
	// zones associated with the current AWS account. To get the next page of results,
	// make another request to ListHostedZonesByName. Specify the value of ListHostedZonesByNameResponse$NextDNSName
	// in the ListHostedZonesByNameRequest$DNSName element and ListHostedZonesByNameResponse$NextHostedZoneId
	// in the ListHostedZonesByNameRequest$HostedZoneId element.
	NextDNSName *string `type:"string"`

	// If ListHostedZonesByNameResponse$IsTruncated is true, there are more hosted
	// zones associated with the current AWS account. To get the next page of results,
	// make another request to ListHostedZonesByName. Specify the value of ListHostedZonesByNameResponse$NextDNSName
	// in the ListHostedZonesByNameRequest$DNSName element and ListHostedZonesByNameResponse$NextHostedZoneId
	// in the ListHostedZonesByNameRequest$HostedZoneId element.
	NextHostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your hosted zones, send a GET request to the /Route
// 53 API version/hostedzone resource. The response to this request includes
// a HostedZones element with zero or more HostedZone child elements. By default,
// the list of hosted zones is displayed on a single page. You can control the
// length of the page that is displayed by using the MaxItems parameter. You
// can use the Marker parameter to control the hosted zone that the list begins
// with. For more information about listing hosted zones, see Listing the Hosted
// Zones for an AWS Account (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ListInfoOnHostedZone.html)
// in the Amazon Route 53 Developer Guide.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
type ListHostedZonesInput struct {
	_ struct{} `type:"structure"`

	DelegationSetId *string `location:"querystring" locationName:"delegationsetid" type:"string"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of hosted zones to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHostedZonesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the hosted zones associated
	// with the current AWS account.
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of hosted zones to be included in the response body. If
	// the number of hosted zones associated with this AWS account exceeds MaxItems,
	// the value of ListHostedZonesResponse$IsTruncated in the response is true.
	// Call ListHostedZones again and specify the value of ListHostedZonesResponse$NextMarker
	// in the ListHostedZonesRequest$Marker element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing hosted zones. If ListHostedZonesResponse$IsTruncated
	// is true, make another request to ListHostedZones and include the value of
	// the NextMarker element in the Marker element to get the next page of results.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesOutput) GoString() string {
	return s.String()
}

// The input for a ListResourceRecordSets request.
type ListResourceRecordSetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to get.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The maximum number of records you want in the response body.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// Weighted resource record sets only: If results were truncated for a given
	// DNS name and type, specify the value of ListResourceRecordSetsResponse$NextRecordIdentifier
	// from the previous response to get the next resource record set that has the
	// current DNS name and type.
	StartRecordIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The first name in the lexicographic ordering of domain names that you want
	// the ListResourceRecordSets request to list.
	StartRecordName *string `location:"querystring" locationName:"name" type:"string"`

	// The DNS type at which to begin the listing of resource record sets.
	//
	// Valid values: A | AAAA | CNAME | MX | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for Weighted Resource Record Sets: A | AAAA | CNAME | TXT
	//
	// Values for Regional Resource Record Sets: A | AAAA | CNAME | TXT
	//
	// Values for Alias Resource Record Sets: A | AAAA
	//
	// Constraint: Specifying type without specifying name returns an InvalidInput
	// error.
	StartRecordType *string `location:"querystring" locationName:"type" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// are returned by the request and information about the response.
type ListResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more resource record sets to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the ListResourceRecordSetsResponse$NextRecordName
	// element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested. The maximum value of MaxItems
	// is 100.
	MaxItems *string `type:"string" required:"true"`

	// Weighted resource record sets only: If results were truncated for a given
	// DNS name and type, the value of SetIdentifier for the next resource record
	// set that has the current DNS name and type.
	NextRecordIdentifier *string `min:"1" type:"string"`

	// If the results were truncated, the name of the next record in the list. This
	// element is present only if ListResourceRecordSetsResponse$IsTruncated is
	// true.
	NextRecordName *string `type:"string"`

	// If the results were truncated, the type of the next record in the list. This
	// element is present only if ListResourceRecordSetsResponse$IsTruncated is
	// true.
	NextRecordType *string `type:"string" enum:"RRType"`

	// A complex type that contains information about the resource record sets that
	// are returned by the request.
	ResourceRecordSets []*ResourceRecordSet `locationNameList:"ResourceRecordSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your reusable delegation sets, send a GET request to
// the /Route 53 API version/delegationset resource. The response to this request
// includes a DelegationSets element with zero or more DelegationSet child elements.
// By default, the list of reusable delegation sets is displayed on a single
// page. You can control the length of the page that is displayed by using the
// MaxItems parameter. You can use the Marker parameter to control the delegation
// set that the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
type ListReusableDelegationSetsInput struct {
	_ struct{} `type:"structure"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of reusable delegation sets to return per page
	// of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListReusableDelegationSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the reusable delegation sets
	// associated with the current AWS account.
	DelegationSets []*DelegationSet `locationNameList:"DelegationSet" type:"list" required:"true"`

	// A flag indicating whether there are more reusable delegation sets to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of reusable delegation sets to be included in the response
	// body. If the number of reusable delegation sets associated with this AWS
	// account exceeds MaxItems, the value of ListReusablDelegationSetsResponse$IsTruncated
	// in the response is true. Call ListReusableDelegationSets again and specify
	// the value of ListReusableDelegationSetsResponse$NextMarker in the ListReusableDelegationSetsRequest$Marker
	// element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing reusable delegation sets. If ListReusableDelegationSetsResponse$IsTruncated
	// is true, make another request to ListReusableDelegationSets and include the
	// value of the NextMarker element in the Marker element to get the next page
	// of results.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request for a list of the tags
// that are associated with an individual resource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource for which you want to retrieve tags.
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// A complex type containing tags for the specified resource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A ResourceTagSet containing tags associated with the specified resource.
	ResourceTagSet *ResourceTagSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request for a list of the tags
// that are associated with up to 10 specified resources.
type ListTagsForResourcesInput struct {
	_ struct{} `locationName:"ListTagsForResourcesRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains the ResourceId element for each resource for
	// which you want to get a list of tags.
	ResourceIds []*string `locationNameList:"ResourceId" min:"1" type:"list" required:"true"`

	// The type of the resources.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesInput) GoString() string {
	return s.String()
}

// A complex type containing tags for the specified resources.
type ListTagsForResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ResourceTagSets containing tags associated with the specified resources.
	ResourceTagSets []*ResourceTagSet `locationNameList:"ResourceTagSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list the
// traffic policies that are associated with the current AWS account.
type ListTrafficPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of traffic policies to be included in the response body
	// for this request. If you have more than MaxItems traffic policies, the value
	// of the IsTruncated element in the response is true, and the value of the
	// TrafficPolicyIdMarker element is the ID of the first traffic policy in the
	// next group of MaxItems traffic policies.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For your first request to ListTrafficPolicies, do not include the TrafficPolicyIdMarker
	// parameter.
	//
	// If you have more traffic policies than the value of MaxItems, ListTrafficPolicies
	// returns only the first MaxItems traffic policies. To get the next group of
	// MaxItems policies, submit another request to ListTrafficPolicies. For the
	// value of TrafficPolicyIdMarker, specify the value of the TrafficPolicyIdMarker
	// element that was returned in the previous response.
	//
	// Policies are listed in the order in which they were created.
	TrafficPolicyIdMarker *string `location:"querystring" locationName:"trafficpolicyid" type:"string"`
}

// String returns the string representation
func (s ListTrafficPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of MaxItems traffic
	// policies by calling ListTrafficPolicies again and specifying the value of
	// the TrafficPolicyIdMarker element in the TrafficPolicyIdMarker request parameter.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicies
	// that produced the current response.
	MaxItems *string `type:"string" required:"true"`

	// If the value of IsTruncated is true, TrafficPolicyIdMarker is the ID of the
	// first traffic policy in the next group of MaxItems traffic policies.
	TrafficPolicyIdMarker *string `type:"string" required:"true"`

	// A list that contains one TrafficPolicySummary element for each traffic policy
	// that was created by the current AWS account.
	TrafficPolicySummaries []*TrafficPolicySummary `locationNameList:"TrafficPolicySummary" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesOutput) GoString() string {
	return s.String()
}

// A request for the traffic policy instances that you created in a specified
// hosted zone.
type ListTrafficPolicyInstancesByHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone for which you want to list traffic policy instances.
	HostedZoneId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByHostedZone, omit this
	// value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByHostedZone, omit this
	// value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstancesByHostedZone
	// again and specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByHostedZone
	// that produced the current response.
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesByPolicyInput struct {
	_ struct{} `type:"structure"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, HostedZoneIdMarker
	// is the ID of the hosted zone for the first traffic policy instance in the
	// next group of MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The ID of the traffic policy for which you want to list traffic policy instances.
	TrafficPolicyId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`

	// The version of the traffic policy for which you want to list traffic policy
	// instances. The version must be associated with the traffic policy that is
	// specified by TrafficPolicyId.
	TrafficPolicyVersion *int64 `location:"querystring" locationName:"version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstancesByPolicy again
	// and specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByPolicy
	// that produced the current response.
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesInput struct {
	_ struct{} `type:"structure"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, you have
	// more traffic policy instances. To get the next group of MaxItems traffic
	// policy instances, submit another ListTrafficPolicyInstances request. For
	// the value of HostedZoneIdMarker, specify the value of HostedZoneIdMarker
	// from the previous response, which is the hosted zone ID of the first traffic
	// policy instance in the next group of MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstances again and
	// specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstances
	// that produced the current response.
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policies.
type ListTrafficPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specify the value of Id of the traffic policy for which you want to list
	// all versions.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The maximum number of traffic policy versions that you want Amazon Route
	// 53 to include in the response body for this request. If the specified traffic
	// policy has more than MaxItems versions, the value of the IsTruncated element
	// in the response is true, and the value of the TrafficPolicyVersionMarker
	// element is the ID of the first version in the next group of MaxItems traffic
	// policy versions.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For your first request to ListTrafficPolicyVersions, do not include the TrafficPolicyVersionMarker
	// parameter.
	//
	// If you have more traffic policy versions than the value of MaxItems, ListTrafficPolicyVersions
	// returns only the first group of MaxItems versions. To get the next group
	// of MaxItems traffic policy versions, submit another request to ListTrafficPolicyVersions.
	// For the value of TrafficPolicyVersionMarker, specify the value of the TrafficPolicyVersionMarker
	// element that was returned in the previous response.
	//
	// Traffic policy versions are listed in sequential order.
	TrafficPolicyVersionMarker *string `location:"querystring" locationName:"trafficpolicyversion" type:"string"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of maxitems traffic
	// policies by calling ListTrafficPolicyVersions again and specifying the value
	// of the NextMarker element in the marker parameter.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListTrafficPolicyVersions
	// that produced the current response.
	MaxItems *string `type:"string" required:"true"`

	// A list that contains one TrafficPolicy element for each traffic policy version
	// that is associated with the specified traffic policy.
	TrafficPolicies []*TrafficPolicy `locationNameList:"TrafficPolicy" type:"list" required:"true"`

	// If IsTruncated is true, the value of TrafficPolicyVersionMarker identifies
	// the first traffic policy in the next group of MaxItems traffic policies.
	// Call ListTrafficPolicyVersions again and specify the value of TrafficPolicyVersionMarker
	// in the TrafficPolicyVersionMarker request parameter.
	//
	// This element is present only if IsTruncated is true.
	TrafficPolicyVersionMarker *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsOutput) GoString() string {
	return s.String()
}

// A complex type that contains the value of the Value element for the current
// resource record set.
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The current or new DNS record value, not to exceed 4,000 characters. In the
	// case of a DELETE action, if the current value does not match the actual value,
	// an error is returned. For descriptions about how to format Value for different
	// record types, see Supported DNS Resource Record Types (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can specify more than one value for all record types except CNAME and
	// SOA.
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecord) GoString() string {
	return s.String()
}

// A complex type that contains information about the current resource record
// set.
type ResourceRecordSet struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: Information about the AWS resource to which
	// you are redirecting traffic.
	AliasTarget *AliasTarget `type:"structure"`

	// Failover resource record sets only: To configure failover, you add the Failover
	// element to two resource record sets. For one resource record set, you specify
	// PRIMARY as the value for Failover; for the other resource record set, you
	// specify SECONDARY. In addition, you include the HealthCheckId element and
	// specify the health check that you want Amazon Route 53 to perform for each
	// resource record set.
	//
	// You can create failover and failover alias resource record sets only in
	// public hosted zones. Except where noted, the following failover behaviors
	// assume that you have included the HealthCheckId element in both resource
	// record sets:
	//
	//  When the primary resource record set is healthy, Amazon Route 53 responds
	// to DNS queries with the applicable value from the primary resource record
	// set regardless of the health of the secondary resource record set. When the
	// primary resource record set is unhealthy and the secondary resource record
	// set is healthy, Amazon Route 53 responds to DNS queries with the applicable
	// value from the secondary resource record set. When the secondary resource
	// record set is unhealthy, Amazon Route 53 responds to DNS queries with the
	// applicable value from the primary resource record set regardless of the health
	// of the primary resource record set. If you omit the HealthCheckId element
	// for the secondary resource record set, and if the primary resource record
	// set is unhealthy, Amazon Route 53 always responds to DNS queries with the
	// applicable value from the secondary resource record set. This is true regardless
	// of the health of the associated endpoint.  You cannot create non-failover
	// resource record sets that have the same values for the Name and Type elements
	// as failover resource record sets.
	//
	// For failover alias resource record sets, you must also include the EvaluateTargetHealth
	// element and set the value to true.
	//
	// For more information about configuring failover for Amazon Route 53, see
	// Amazon Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Valid values: PRIMARY | SECONDARY
	Failover *string `type:"string" enum:"ResourceRecordSetFailover"`

	// Geo location resource record sets only: A complex type that lets you control
	// how Amazon Route 53 responds to DNS queries based on the geographic origin
	// of the query. For example, if you want all queries from Africa to be routed
	// to a web server with an IP address of 192.0.2.111, create a resource record
	// set with a Type of A and a ContinentCode of AF.
	//
	// You can create geolocation and geolocation alias resource record sets only
	// in public hosted zones. If you create separate resource record sets for overlapping
	// geographic regions (for example, one resource record set for a continent
	// and one for a country on the same continent), priority goes to the smallest
	// geographic region. This allows you to route most queries for a continent
	// to one resource and to route queries for a country on that continent to a
	// different resource.
	//
	// You cannot create two geolocation resource record sets that specify the
	// same geographic location.
	//
	// The value * in the CountryCode element matches all geographic locations
	// that aren't specified in other geolocation resource record sets that have
	// the same values for the Name and Type elements.
	//
	// Geolocation works by mapping IP addresses to locations. However, some IP
	// addresses aren't mapped to geographic locations, so even if you create geolocation
	// resource record sets that cover all seven continents, Amazon Route 53 will
	// receive some DNS queries from locations that it can't identify. We recommend
	// that you create a resource record set for which the value of CountryCode
	// is *, which handles both queries that come from locations for which you haven't
	// created geolocation resource record sets and queries from IP addresses that
	// aren't mapped to a location. If you don't create a * resource record set,
	// Amazon Route 53 returns a "no answer" response for queries from those locations.
	// You cannot create non-geolocation resource record sets that have the same
	// values for the Name and Type elements as geolocation resource record sets.
	GeoLocation *GeoLocation `type:"structure"`

	// Health Check resource record sets only, not required for alias resource record
	// sets: An identifier that is used to identify health check associated with
	// the resource record set.
	HealthCheckId *string `type:"string"`

	// The name of the domain you want to perform the action on.
	//
	// Enter a fully qualified domain name, for example, www.example.com. You can
	// optionally include a trailing dot. If you omit the trailing dot, Amazon Route
	// 53 still assumes that the domain name that you specify is fully qualified.
	// This means that Amazon Route 53 treats www.example.com (without a trailing
	// dot) and www.example.com. (with a trailing dot) as identical.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see DNS Domain
	// Name Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can use an asterisk (*) character in the name. DNS treats the * character
	// either as a wildcard or as the * character (ASCII 42), depending on where
	// it appears in the name. For more information, see Using an Asterisk (*) in
	// the Names of Hosted Zones and Resource Record Sets (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-asterisk)
	// in the Amazon Route 53 Developer Guide
	//
	// You can't use the * wildcard for resource records sets that have a type
	// of NS.
	Name *string `type:"string" required:"true"`

	// Latency-based resource record sets only: The Amazon EC2 region where the
	// resource that is specified in this resource record set resides. The resource
	// typically is an AWS resource, such as an Amazon EC2 instance or an ELB load
	// balancer, and is referred to by an IP address or a DNS domain name, depending
	// on the record type.
	//
	// You can create latency and latency alias resource record sets only in public
	// hosted zones. When Amazon Route 53 receives a DNS query for a domain name
	// and type for which you have created latency resource record sets, Amazon
	// Route 53 selects the latency resource record set that has the lowest latency
	// between the end user and the associated Amazon EC2 region. Amazon Route 53
	// then returns the value that is associated with the selected resource record
	// set.
	//
	// Note the following:
	//
	//  You can only specify one ResourceRecord per latency resource record set.
	// You can only create one latency resource record set for each Amazon EC2 region.
	// You are not required to create latency resource record sets for all Amazon
	// EC2 regions. Amazon Route 53 will choose the region with the best latency
	// from among the regions for which you create latency resource record sets.
	// You cannot create non-latency resource record sets that have the same values
	// for the Name and Type elements as latency resource record sets.
	Region *string `min:"1" type:"string" enum:"ResourceRecordSetRegion"`

	// A complex type that contains the resource records for the current resource
	// record set.
	ResourceRecords []*ResourceRecord `locationNameList:"ResourceRecord" min:"1" type:"list"`

	// Weighted, Latency, Geo, and Failover resource record sets only: An identifier
	// that differentiates among multiple resource record sets that have the same
	// combination of DNS name and type. The value of SetIdentifier must be unique
	// for each resource record set that has the same combination of DNS name and
	// type.
	SetIdentifier *string `min:"1" type:"string"`

	// The cache time to live for the current resource record set. Note the following:
	//
	//  If you're creating an alias resource record set, omit TTL. Amazon Route
	// 53 uses the value of TTL for the alias target.  If you're associating this
	// resource record set with a health check (if you're adding a HealthCheckId
	// element), we recommend that you specify a TTL of 60 seconds or less so clients
	// respond quickly to changes in health status. All of the resource record sets
	// in a group of weighted, latency, geolocation, or failover resource record
	// sets must have the same value for TTL. If a group of weighted resource record
	// sets includes one or more weighted alias resource record sets for which the
	// alias target is an ELB load balancer, we recommend that you specify a TTL
	// of 60 seconds for all of the non-alias weighted resource record sets that
	// have the same name and type. Values other than 60 seconds (the TTL for load
	// balancers) will change the effect of the values that you specify for Weight.
	TTL *int64 `type:"long"`

	TrafficPolicyInstanceId *string `type:"string"`

	// The DNS record type. For information about different record types and how
	// data is encoded for them, see Supported DNS Resource Record Types (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Valid values for basic resource record sets: A | AAAA | CNAME | MX | NS
	// | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record
	// sets: A | AAAA | CNAME | MX | PTR | SPF | SRV | TXT. When creating a group
	// of weighted, latency, geolocation, or failover resource record sets, specify
	// the same value for all of the resource record sets in the group.
	//
	// SPF records were formerly used to verify the identity of the sender of email
	// messages. However, we no longer recommend that you create resource record
	// sets for which the value of Type is SPF. RFC 7208, Sender Policy Framework
	// (SPF) for Authorizing Use of Domains in Email, Version 1, has been updated
	// to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to
	// some interoperability issues. Accordingly, its use is no longer appropriate
	// for SPF version 1; implementations are not to use it." In RFC 7208, see section
	// 14.1, The SPF DNS Record Type (http://tools.ietf.org/html/rfc7208#section-14.1).
	// Values for alias resource record sets:
	//
	//  CloudFront distributions: A ELB load balancers: A | AAAA Amazon S3 buckets:
	// A Another resource record set in this hosted zone: Specify the type of the
	// resource record set for which you're creating the alias. Specify any value
	// except NS or SOA.
	Type *string `type:"string" required:"true" enum:"RRType"`

	// Weighted resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that determines the proportion
	// of DNS queries that Amazon Route 53 responds to using the current resource
	// record set. Amazon Route 53 calculates the sum of the weights for the resource
	// record sets that have the same combination of DNS name and type. Amazon Route
	// 53 then responds to queries based on the ratio of a resource's weight to
	// the total. Note the following:
	//
	//  You must specify a value for the Weight element for every weighted resource
	// record set. You can only specify one ResourceRecord per weighted resource
	// record set. You cannot create latency, failover, or geolocation resource
	// record sets that have the same values for the Name and Type elements as weighted
	// resource record sets. You can create a maximum of 100 weighted resource record
	// sets that have the same values for the Name and Type elements. For weighted
	// (but not weighted alias) resource record sets, if you set Weight to 0 for
	// a resource record set, Amazon Route 53 never responds to queries with the
	// applicable value for that resource record set. However, if you set Weight
	// to 0 for all resource record sets that have the same combination of DNS name
	// and type, traffic is routed to all resources with equal probability.
	//
	// The effect of setting Weight to 0 is different when you associate health
	// checks with weighted resource record sets. For more information, see Options
	// for Configuring Amazon Route 53 Active-Active and Active-Passive Failover
	// (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html)
	// in the Amazon Route 53 Developer Guide.
	Weight *int64 `type:"long"`
}

// String returns the string representation
func (s ResourceRecordSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecordSet) GoString() string {
	return s.String()
}

// A complex type containing a resource and its associated tags.
type ResourceTagSet struct {
	_ struct{} `type:"structure"`

	// The ID for the specified resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `type:"string" enum:"TagResourceType"`

	// The tags associated with the specified resource.
	Tags []*Tag `locationNameList:"Tag" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagSet) GoString() string {
	return s.String()
}

// A complex type that contains information about the health check status for
// the current observation.
type StatusReport struct {
	_ struct{} `type:"structure"`

	// The date and time the health check status was observed, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC).
	CheckedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The observed health check status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s StatusReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReport) GoString() string {
	return s.String()
}

// A single tag containing a key and value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for a Tag.
	Key *string `type:"string"`

	// The value for a Tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

type TrafficPolicy struct {
	_ struct{} `type:"structure"`

	Comment *string `type:"string"`

	Document *string `type:"string" required:"true"`

	Id *string `type:"string" required:"true"`

	Name *string `type:"string" required:"true"`

	Type *string `type:"string" required:"true" enum:"RRType"`

	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicy) GoString() string {
	return s.String()
}

type TrafficPolicyInstance struct {
	_ struct{} `type:"structure"`

	HostedZoneId *string `type:"string" required:"true"`

	Id *string `type:"string" required:"true"`

	Message *string `type:"string" required:"true"`

	Name *string `type:"string" required:"true"`

	State *string `type:"string" required:"true"`

	TTL *int64 `type:"long" required:"true"`

	TrafficPolicyId *string `type:"string" required:"true"`

	TrafficPolicyType *string `type:"string" required:"true" enum:"RRType"`

	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicyInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicyInstance) GoString() string {
	return s.String()
}

type TrafficPolicySummary struct {
	_ struct{} `type:"structure"`

	Id *string `type:"string" required:"true"`

	LatestVersion *int64 `min:"1" type:"integer" required:"true"`

	Name *string `type:"string" required:"true"`

	TrafficPolicyCount *int64 `min:"1" type:"integer" required:"true"`

	Type *string `type:"string" required:"true" enum:"RRType"`
}

// String returns the string representation
func (s TrafficPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicySummary) GoString() string {
	return s.String()
}

// >A complex type that contains information about the request to update a health
// check.
type UpdateHealthCheckInput struct {
	_ struct{} `locationName:"UpdateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// For a specified parent health check, a list of HealthCheckId values for the
	// associated child health checks.
	//
	// Specify this value only if you want to change it.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. If you
	// don't specify a value for EnableSNI, Amazon Route 53 defaults to true when
	// Type is HTTPS or HTTPS_STR_MATCH and defaults to false when Type is any other
	// value.
	//
	// Specify this value only if you want to change it.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa.
	//
	// Valid values are integers between 1 and 10. For more information, see "How
	// Amazon Route 53 Determines Whether an Endpoint Is Healthy" in the Amazon
	// Route 53 Developer Guide.
	//
	// Specify this value only if you want to change it.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Fully qualified domain name of the instance to be health checked.
	//
	// Specify this value only if you want to change it.
	FullyQualifiedDomainName *string `type:"string"`

	// The ID of the health check to update.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	// Optional. When you specify a health check version, Amazon Route 53 compares
	// this value with the current value in the health check, which prevents you
	// from updating the health check when the versions don't match. Using HealthCheckVersion
	// lets you prevent overwriting another change to the health check.
	HealthCheckVersion *int64 `min:"1" type:"long"`

	// The minimum number of child health checks that must be healthy for Amazon
	// Route 53 to consider the parent health check to be healthy. Valid values
	// are integers between 0 and 256, inclusive.
	//
	// Specify this value only if you want to change it.
	HealthThreshold *int64 `type:"integer"`

	// The IP address of the resource that you want to check.
	//
	// Specify this value only if you want to change it.
	IPAddress *string `type:"string"`

	// A boolean value that indicates whether the status of health check should
	// be inverted. For example, if a health check is healthy but Inverted is True,
	// then Amazon Route 53 considers the health check to be unhealthy.
	//
	// Specify this value only if you want to change it.
	Inverted *bool `type:"boolean"`

	// The port on which you want Amazon Route 53 to open a connection to perform
	// health checks.
	//
	// Specify this value only if you want to change it.
	Port *int64 `min:"1" type:"integer"`

	// The path that you want Amazon Route 53 to request when performing health
	// checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
	// the file /docs/route53-health-check.html.
	//
	// Specify this value only if you want to change it.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTP_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Amazon Route 53 considers
	// the resource healthy. Amazon Route 53 considers case when searching for SearchString
	// in the response body.
	//
	// Specify this value only if you want to change it.
	SearchString *string `type:"string"`
}

// String returns the string representation
func (s UpdateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckInput) GoString() string {
	return s.String()
}

type UpdateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains identifying information about the health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to update a hosted
// zone comment.
type UpdateHostedZoneCommentInput struct {
	_ struct{} `locationName:"UpdateHostedZoneCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A comment about your hosted zone.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to update.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified hosted zone after
// the update.
type UpdateHostedZoneCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contain information about the specified hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy for which
// you want to update the comment.
type UpdateTrafficPolicyCommentInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the specified traffic policy and version.
	Comment *string `type:"string" required:"true"`

	// The value of Id for the traffic policy for which you want to update the comment.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of Version for the traffic policy for which you want to update
	// the comment.
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the traffic policy.
type UpdateTrafficPolicyCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// you want to update based on a specified traffic policy instance.
type UpdateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the traffic policy instance that you want to update.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The TTL that you want Amazon Route 53 to assign to all of the updated resource
	// record sets.
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want Amazon Route 53 to use to update
	// resource record sets for the specified traffic policy instance.
	TrafficPolicyId *string `type:"string" required:"true"`

	// The version of the traffic policy that you want Amazon Route 53 to use to
	// update resource record sets for the specified traffic policy instance.
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type UpdateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the updated traffic policy instance.
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

type VPC struct {
	_ struct{} `type:"structure"`

	// A VPC ID
	VPCId *string `type:"string"`

	VPCRegion *string `min:"1" type:"string" enum:"VPCRegion"`
}

// String returns the string representation
func (s VPC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPC) GoString() string {
	return s.String()
}

const (
	// @enum ChangeAction
	ChangeActionCreate = "CREATE"
	// @enum ChangeAction
	ChangeActionDelete = "DELETE"
	// @enum ChangeAction
	ChangeActionUpsert = "UPSERT"
)

const (
	// @enum ChangeStatus
	ChangeStatusPending = "PENDING"
	// @enum ChangeStatus
	ChangeStatusInsync = "INSYNC"
)

const (
	// @enum HealthCheckType
	HealthCheckTypeHttp = "HTTP"
	// @enum HealthCheckType
	HealthCheckTypeHttps = "HTTPS"
	// @enum HealthCheckType
	HealthCheckTypeHttpStrMatch = "HTTP_STR_MATCH"
	// @enum HealthCheckType
	HealthCheckTypeHttpsStrMatch = "HTTPS_STR_MATCH"
	// @enum HealthCheckType
	HealthCheckTypeTcp = "TCP"
	// @enum HealthCheckType
	HealthCheckTypeCalculated = "CALCULATED"
)

const (
	// @enum RRType
	RRTypeSoa = "SOA"
	// @enum RRType
	RRTypeA = "A"
	// @enum RRType
	RRTypeTxt = "TXT"
	// @enum RRType
	RRTypeNs = "NS"
	// @enum RRType
	RRTypeCname = "CNAME"
	// @enum RRType
	RRTypeMx = "MX"
	// @enum RRType
	RRTypePtr = "PTR"
	// @enum RRType
	RRTypeSrv = "SRV"
	// @enum RRType
	RRTypeSpf = "SPF"
	// @enum RRType
	RRTypeAaaa = "AAAA"
)

const (
	// @enum ResourceRecordSetFailover
	ResourceRecordSetFailoverPrimary = "PRIMARY"
	// @enum ResourceRecordSetFailover
	ResourceRecordSetFailoverSecondary = "SECONDARY"
)

const (
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsEast1 = "us-east-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsWest1 = "us-west-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsWest2 = "us-west-2"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionEuWest1 = "eu-west-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionEuCentral1 = "eu-central-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApSoutheast1 = "ap-southeast-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApSoutheast2 = "ap-southeast-2"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApNortheast1 = "ap-northeast-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApNortheast2 = "ap-northeast-2"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionSaEast1 = "sa-east-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionCnNorth1 = "cn-north-1"
)

const (
	// @enum TagResourceType
	TagResourceTypeHealthcheck = "healthcheck"
	// @enum TagResourceType
	TagResourceTypeHostedzone = "hostedzone"
)

const (
	// @enum VPCRegion
	VPCRegionUsEast1 = "us-east-1"
	// @enum VPCRegion
	VPCRegionUsWest1 = "us-west-1"
	// @enum VPCRegion
	VPCRegionUsWest2 = "us-west-2"
	// @enum VPCRegion
	VPCRegionEuWest1 = "eu-west-1"
	// @enum VPCRegion
	VPCRegionEuCentral1 = "eu-central-1"
	// @enum VPCRegion
	VPCRegionApSoutheast1 = "ap-southeast-1"
	// @enum VPCRegion
	VPCRegionApSoutheast2 = "ap-southeast-2"
	// @enum VPCRegion
	VPCRegionApNortheast1 = "ap-northeast-1"
	// @enum VPCRegion
	VPCRegionApNortheast2 = "ap-northeast-2"
	// @enum VPCRegion
	VPCRegionSaEast1 = "sa-east-1"
	// @enum VPCRegion
	VPCRegionCnNorth1 = "cn-north-1"
)
