; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use.i8(i8)
define i8 @fold_add_zext_eq_0(i8 %x) {
; CHECK-LABEL: @fold_add_zext_eq_0(
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 1)
; CHECK-NEXT:    ret i8 [[R]]
;
  %x_eq = icmp eq i8 %x, 0
  %x_eq_ext = zext i1 %x_eq to i8
  %r = add i8 %x, %x_eq_ext
  ret i8 %r
}

define <2 x i8> @fold_add_sext_eq_4_6(<2 x i6> %xx) {
; CHECK-LABEL: @fold_add_sext_eq_4_6(
; CHECK-NEXT:    [[X:%.*]] = zext <2 x i6> [[XX:%.*]] to <2 x i8>
; CHECK-NEXT:    [[X_EQ:%.*]] = icmp eq <2 x i8> [[X]], <i8 4, i8 -127>
; CHECK-NEXT:    [[R:%.*]] = select <2 x i1> [[X_EQ]], <2 x i8> <i8 3, i8 -128>, <2 x i8> [[X]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %x = zext <2 x i6> %xx to <2 x i8>
  %x_eq = icmp eq <2 x i8> %x, <i8 4, i8 129>
  %x_eq_ext = sext <2 x i1> %x_eq to <2 x i8>
  %r = add <2 x i8> %x_eq_ext, %x
  ret <2 x i8> %r
}

define i8 @fold_add_zext_eq_0_fail_multiuse_exp(i8 %x) {
; CHECK-LABEL: @fold_add_zext_eq_0_fail_multiuse_exp(
; CHECK-NEXT:    [[X_EQ:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    [[X_EQ_EXT:%.*]] = zext i1 [[X_EQ]] to i8
; CHECK-NEXT:    [[R:%.*]] = add i8 [[X_EQ_EXT]], [[X]]
; CHECK-NEXT:    call void @use.i8(i8 [[X_EQ_EXT]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %x_eq = icmp eq i8 %x, 0
  %x_eq_ext = zext i1 %x_eq to i8
  %r = add i8 %x, %x_eq_ext
  call void @use.i8(i8 %x_eq_ext)
  ret i8 %r
}

define i8 @fold_add_sext_eq_4_fail_wrong_cond(i8 %x, i8 %y) {
; CHECK-LABEL: @fold_add_sext_eq_4_fail_wrong_cond(
; CHECK-NEXT:    [[X_EQ:%.*]] = icmp eq i8 [[Y:%.*]], 4
; CHECK-NEXT:    [[X_EQ_EXT:%.*]] = sext i1 [[X_EQ]] to i8
; CHECK-NEXT:    [[R:%.*]] = add i8 [[X_EQ_EXT]], [[X:%.*]]
; CHECK-NEXT:    call void @use.i8(i8 [[X_EQ_EXT]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %x_eq = icmp eq i8 %y, 4
  %x_eq_ext = sext i1 %x_eq to i8
  %r = add i8 %x, %x_eq_ext
  call void @use.i8(i8 %x_eq_ext)
  ret i8 %r
}
