/*
 *
 * Copyright 2018 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// This binary can only run on Google Cloud Platform (GCP).
package main

import (
	"flag"
	"net"

	grpc "google.golang.org/grpc"
	"google.golang.org/grpc/credentials/alts"
	"google.golang.org/grpc/grpclog"
	"google.golang.org/grpc/interop"
	testpb "google.golang.org/grpc/interop/grpc_testing"
)

var (
	serverAddr = flag.String("server_address", ":8080", "The port on which the server is listening")
)

func main() {
	flag.Parse()

	lis, err := net.Listen("tcp", *serverAddr)
	if err != nil {
		grpclog.Fatalf("gRPC Server: failed to start the server at %v: %v", *serverAddr, err)
	}
	altsTC := alts.NewServerCreds()
	grpcServer := grpc.NewServer(grpc.Creds(altsTC))
	testpb.RegisterTestServiceServer(grpcServer, interop.NewTestServer())
	grpcServer.Serve(lis)
}
