; Proof support for zcash gadgets
;
; Copyright (C) 2021 Kestrel Institute
;
; License: A 3-clause BSD license. See the file books/3BSD-mod.txt.
;
; Author: Eric Smith (eric.smith@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ZCASH")

;(include-book "kestrel/crypto/ecurve/points" :dir :system)
(include-book "kestrel/crypto/ecurve/points-fty" :dir :system)
(include-book "kestrel/axe/known-booleans" :dir :system)
(include-book "kestrel/zcash/jubjub" :dir :system)

;move
;todo: the variant of this generated by define has an unnecessary b*, which causes problems for Axe
(defthm ecurve::pointp-of-point-finite-better
  (ecurve::pointp (ecurve::point-finite x y)))

;move
;todo: the variant of this generated by define has an unnecessary b*, which causes problems for Axe
(defthm ecurve::pointp-of-point-infinite-better
  (ecurve::pointp (ecurve::point-infinite)))

;move
(defthm ecurve::point-kind-of-if
  (equal (ecurve::point-kind (if test x y))
         (if test
             (ecurve::point-kind x)
           (ecurve::point-kind y))))

;move
(defthm ecurve::pointp-of-if
  (equal (ecurve::pointp (if test x y))
         (if test
             (ecurve::pointp x)
           (ecurve::pointp y))))

;move
;; todo: should be in zcash package:
;todo: the variant of this generated by define has an unnecessary b*, which causes problems for Axe
(defthm zcash::primep-of-jubjub-q-better
  (rtl::primep (zcash::jubjub-q)))

;move
(acl2::add-known-boolean ecurve::pointp)

;; (primes::bls12-381-scalar-field-prime), or (zcash::jubjub-q)
(table acl2::evisc-table 52435875175126190479447740508185965837690552500527637822603658699938581184513 "<p>")

;; (+ -1 (zcash::jubjub-q))
(table acl2::evisc-table 52435875175126190479447740508185965837690552500527637822603658699938581184512 "<p-1>")

;; (zcash::jubjub-d)
(table acl2::evisc-table 19257038036680949359750312669786877991949435402254120286184196891950884077233 "<d>")

;; (div (mod -1 (zcash::jubjub-q)) (zcash::jubjub-d) (zcash::jubjub-q))
(table acl2::evisc-table 31456404414140643370629635736502576966887994532298953041431081581418232833640 "<-1/d>")

;; (div 1 (zcash::jubjub-d) (zcash::jubjub-q))
(table acl2::evisc-table 20979470760985547108818104771683388870802557968228684781172577118520348350873 "<1/d>")
