/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:43:11 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.genebuilder.GeneEdit;
import uk.ac.sanger.artemis.io.DatabaseDocumentEntry;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class GeneEdit_ESTest extends GeneEdit_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      String[] stringArray0 = new String[2];
      // Undeclared exception!
      try { 
        GeneEdit.main(stringArray0);
        
      
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneEdit.showGeneEditor("@XZng", "@XZng", (DatabaseDocumentEntry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneEdit", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn("uk.ac.sanger.artemis.components.genebuilder.GeneEdit$1").when(databaseDocument0).getLocation();
      // Undeclared exception!
      try { 
        GeneEdit.makeGeneEntry("uk.ac.sanger.artemis.components.genebuilder.GeneEdit$1", "uk.ac.sanger.artemis.components.genebuilder.GeneEdit$1", databaseDocument0, (InputStreamProgressListener) null);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneEdit.makeGeneEntry((String) null, ";rV", (DatabaseDocument) null, (InputStreamProgressListener) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn((Object) null).when(databaseDocument0).getLocation();
      // Undeclared exception!
      try { 
        GeneEdit.makeGeneEntry("", "", databaseDocument0, (InputStreamProgressListener) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneEdit.main((String[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneEdit", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      String[] stringArray0 = new String[1];
      // Undeclared exception!
      try { 
        GeneEdit.main(stringArray0);
      
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      GeneEdit geneEdit0 = null;
      try {
        geneEdit0 = new GeneEdit("\"~-)");
      
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      DatabaseDocument databaseDocument0 = mock(DatabaseDocument.class, new ViolatedAssumptionAnswer());
      doReturn("s<Qnpf( ^meR1~7").when(databaseDocument0).getLocation();
      // Undeclared exception!
      GeneEdit.makeGeneEntry("s<Qnpf( ^meR1~7", "s<Qnpf( ^meR1~7", databaseDocument0, (InputStreamProgressListener) null);
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      GeneEdit geneEdit0 = null;
      try {
        geneEdit0 = new GeneEdit();
       
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }
}
