/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:14:04 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.OutputStream;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.RemoteFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class RemoteFileDocument_ESTest extends RemoteFileDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setString("]b@");
      String string0 = remoteFileDocument0.toString();
      assertEquals("]b@", string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setString("");
      String string0 = remoteFileDocument0.toString();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation((Object) null);
      RemoteFileNode remoteFileNode1 = remoteFileDocument0.getRemoteFileNode();
      assertNull(remoteFileNode1);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      RemoteFileNode remoteFileNode1 = remoteFileDocument0.getRemoteFileNode();
      assertNull(remoteFileNode1.getFullName());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      RemoteFileNode remoteFileNode1 = remoteFileDocument0.getRemoteFileNode();
      assertTrue(remoteFileNode1.isLeaf());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn("", "ew>fBzB \")B6 ").when(remoteFileNode0).toString();
      doReturn("z^iVM&f", "").when(remoteFileNode0).getFile();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.getName();
      String string0 = remoteFileDocument0.getName();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        remoteFileDocument0.getOutputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation("qVMj)V]>:Tp_D8xy");
      // Undeclared exception!
      try { 
        remoteFileDocument0.getOutputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(remoteFileNode0).toString();
      doReturn((String) null).when(remoteFileNode0).getFile();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      FileSystemHandling.shouldAllThrowIOExceptions();
      remoteFileDocument0.getOutputStream();
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        remoteFileDocument0.getName();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation("o61ai~K5Ug{+9s>?");
      // Undeclared exception!
      try { 
        remoteFileDocument0.getName();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.setLocation("1=oiBMV>qZ;h*y@d");
      // Undeclared exception!
      try { 
        remoteFileDocument0.getInputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn("").when(remoteFileNode0).toString();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      // Undeclared exception!
      try { 
        remoteFileDocument0.getInputStream();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RemoteFileDocument remoteFileDocument0 = null;
      try {
        remoteFileDocument0 = new RemoteFileDocument((RemoteFileNode) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(remoteFileNode0).toString();
      doReturn((String) null).when(remoteFileNode0).getFile();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      OutputStream outputStream0 = remoteFileDocument0.getOutputStream();
      remoteFileDocument0.setLocation(outputStream0);
      // Undeclared exception!
      try { 
        remoteFileDocument0.getRemoteFileNode();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.io.MockFileOutputStream cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.util.RemoteFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      MockFile mockFile0 = new MockFile("FLOW_LINE_BREAK");
      // Undeclared exception!
      try { 
        remoteFileDocument0.saveEntry(mockFile0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn(".gz.gz", ".gz.gz", (String) null, (String) null).when(remoteFileNode0).toString();
      doReturn(".gz.gz", ".gz.gz", (String) null, (String) null).when(remoteFileNode0).getFile();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.getOutputStream();
      // Undeclared exception!
      try { 
        remoteFileDocument0.getOutputStream();
      
      } catch(Exception e) {
    	  	fail("caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      boolean boolean0 = remoteFileDocument0.writable();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      Document document0 = remoteFileDocument0.append("FLOW_LINE_BREAK");
      assertNull(document0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      String string0 = remoteFileDocument0.toString();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      boolean boolean0 = remoteFileDocument0.readable();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(remoteFileNode0).toString();
      doReturn((String) null).when(remoteFileNode0).getFile();
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      String string0 = remoteFileDocument0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = mock(RemoteFileNode.class, new ViolatedAssumptionAnswer());
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      Document document0 = remoteFileDocument0.getParent();
      assertNull(document0);
  }
}
