# Configure paths for DivX

dnl Usage:
dnl AM_PATH_DIVX([ACTION-IF-FOUND-DECORE [, ACTION-IF-NOT-FOUND-DECORE
dnl		 [, ACTION-IF-FOUND-ENCORE, [ACTION-IF-NOT-FOUND-DECORE]]]] )
dnl Test for libdivxdecore, libdivxencore, and define DIVX_CFLAGS and DIVX_LIBS
dnl
AC_DEFUN([AM_PATH_DIVX],
[
    AC_ARG_WITH(divx4_prefix, [  --with-divx4-prefix=PFX where divx4linux is installed.],
	        [], with_divx4_prefix=)

    have_divx_decore=no
    have_divx_encore=no
    DIVX_CFLAGS=""
    DIVX_LIBS=""
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_divx4_prefix"; then
	dnl user has specified extra path for DivX4 instalation
	CPPFLAGS="-I$with_divx4_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/decore.h,
			DIVX_CFLAGS="-I$with_divx4_prefix/include"
			DIVX_LIBS="-L$with_divx4_prefix/lib"
			have_divx_decore=yes)
	if test "$have_divx_decore" = no; then
	    AC_CHECK_HEADER(decore.h,
			    DIVX_CFLAGS="-I$with_divx4_prefix"
			    DIVX_LIBS="-L$with_divx4_prefix"
			    have_divx_decore=yes)
	fi
    else
	AC_CHECK_HEADER(decore.h, have_divx_decore=yes)
    fi

    AC_CHECK_HEADER(encore2.h, have_divx_encore=yes)
    CPPFLAGS=$ac_save_CPPFLAGS

    ac_save_LIBS=$LIBS
    if test "$have_divx_decore" = yes; then
        AC_CHECK_LIB(divxdecore, decore, [],
                     have_divx_decore=no, $DIVX_LIBS)
    fi

    if test "$have_divx_encore" = yes; then
	AC_CHECK_LIB(divxencore, encore, [],
		     have_divx_encore=no, $DIVX_LIBS)
    fi
    LIBS=$ac_save_LIBS

    if test "$have_divx_decore" = yes; then
        DIVX_LIBS="$DIVX_LIBS -ldivxdecore"
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi

    if test "$have_divx_encore" = yes; then
        DIVX_LIBS="$DIVX_LIBS -ldivxencore"
        ifelse([$3], , :, [$3])
    else
        ifelse([$4], , :, [$4])
    fi

    AC_SUBST(DIVX_CFLAGS)
    AC_SUBST(DIVX_LIBS)
])

