/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using Cowbell.Base;

namespace Cowbell.Gui
{
	public class FileChooser : FileChooserDialog
	{
		public FileChooser () : base (Catalog.GetString ("Import Songs"),
		                              null, FileChooserAction.Open,
		                              Stock.Cancel, ResponseType.Cancel,
		                              Stock.Open, ResponseType.Accept)
		{
			SelectMultiple = true;
			DefaultResponse = ResponseType.Accept;

			SetCurrentFolder (Runtime.Preferences.LastPath);

			FileFilter filter = new FileFilter ();
			filter.Name = Catalog.GetString ("All Audio Files");
			filter.AddMimeType ("audio/x-mp3");
			filter.AddMimeType ("audio/x-mpeg3");
			filter.AddMimeType ("audio/mpeg");
			filter.AddMimeType ("audio/x-ogg");
			filter.AddMimeType ("audio/ogg");
			filter.AddMimeType ("application/x-ogg");
			filter.AddMimeType ("application/ogg");
			filter.AddMimeType ("application/x-flac");
			filter.AddMimeType ("audio/x-flac");
			filter.AddPattern ("*.mpc");
			AddFilter (filter);
			Filter = filter;

			filter = new FileFilter ();
			filter.Name = Catalog.GetString ("Musepack Audio");
			filter.AddPattern ("*.mpc");
			AddFilter (filter);

			filter = new FileFilter ();
			filter.Name = Catalog.GetString ("MP3 Audio");
			filter.AddMimeType ("audio/x-mp3");
			filter.AddMimeType ("audio/x-mpeg3");
			AddFilter (filter);

			filter = new FileFilter ();
			filter.Name = Catalog.GetString ("Ogg Vorbis Audio");
			filter.AddMimeType ("audio/x-ogg");
			filter.AddMimeType ("audio/ogg");
			filter.AddMimeType ("application/x-ogg");
			filter.AddMimeType ("application/ogg");
			AddFilter (filter);
			
			filter = new FileFilter ();
			filter.Name = Catalog.GetString ("FLAC Audio");
			filter.AddMimeType ("application/x-flac");
			filter.AddMimeType ("audio/x-flac");
			AddFilter (filter);
		}

		public new int Run ()
		{
			int resp = base.Run ();
			Runtime.Preferences.LastPath = CurrentFolder;
			return resp;
		}
	}
}
