#line 2 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"

#line 4 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"

#define  MPFIT_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define MPFIT_FLEX_MAJOR_VERSION 2
#define MPFIT_FLEX_MINOR_VERSION 6
#define MPFIT_FLEX_SUBMINOR_VERSION 4
#if MPFIT_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define mpfitconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define mpfitnoreturn __attribute__((__noreturn__))
#else
#define mpfitnoreturn
#endif

/* Returned upon end-of-file. */
#define MPFIT_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define MPFIT_SC_TO_UI(c) ((MPFIT_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (mpfit_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The MPFITSTATE alias is for lex
 * compatibility.
 */
#define MPFIT_START (((mpfit_start) - 1) / 2)
#define MPFITSTATE MPFIT_START
/* Action number for EOF rule of a given start state. */
#define MPFIT_STATE_EOF(state) (MPFIT_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define MPFIT_NEW_FILE mpfitrestart( mpfitin  )
#define MPFIT_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef MPFIT_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, MPFIT_BUF_SIZE is 2*MPFIT_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define MPFIT_BUF_SIZE 32768
#else
#define MPFIT_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define MPFIT_STATE_BUF_SIZE   ((MPFIT_BUF_SIZE + 2) * sizeof(mpfit_state_type))

#ifndef MPFIT_TYPEDEF_MPFIT_BUFFER_STATE
#define MPFIT_TYPEDEF_MPFIT_BUFFER_STATE
typedef struct mpfit_buffer_state *MPFIT_BUFFER_STATE;
#endif

#ifndef MPFIT_TYPEDEF_MPFIT_SIZE_T
#define MPFIT_TYPEDEF_MPFIT_SIZE_T
typedef size_t mpfit_size_t;
#endif

extern int mpfitleng;

extern FILE *mpfitin, *mpfitout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for mpfit_rule_can_match_eol because it requires
     *       access to the local variable mpfit_act. Since mpfitless() is a macro, it would break
     *       existing scanners that call mpfitless() from OUTSIDE mpfitlex.
     *       One obvious solution it to make mpfit_act a global. I tried that, and saw
     *       a 5% performance hit in a non-mpfitlineno scanner, because mpfit_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  MPFIT_LESS_LINENO(n) \
            do { \
                int mpfitl;\
                for ( mpfitl = n; mpfitl < mpfitleng; ++mpfitl )\
                    if ( mpfittext[mpfitl] == '\n' )\
                        --mpfitlineno;\
            }while(0)
    #define MPFIT_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = mpfit_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --mpfitlineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define mpfitless(n) \
	do \
		{ \
		/* Undo effects of setting up mpfittext. */ \
        int mpfitless_macro_arg = (n); \
        MPFIT_LESS_LINENO(mpfitless_macro_arg);\
		*mpfit_cp = (mpfit_hold_char); \
		MPFIT_RESTORE_MPFIT_MORE_OFFSET \
		(mpfit_c_buf_p) = mpfit_cp = mpfit_bp + mpfitless_macro_arg - MPFIT_MORE_ADJ; \
		MPFIT_DO_BEFORE_ACTION; /* set up mpfittext again */ \
		} \
	while ( 0 )
#define unput(c) mpfitunput( c, (mpfittext_ptr)  )

#ifndef MPFIT_STRUCT_MPFIT_BUFFER_STATE
#define MPFIT_STRUCT_MPFIT_BUFFER_STATE
struct mpfit_buffer_state
	{
	FILE *mpfit_input_file;

	char *mpfit_ch_buf;		/* input buffer */
	char *mpfit_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int mpfit_buf_size;

	/* Number of characters read into mpfit_ch_buf, not including EOB
	 * characters.
	 */
	int mpfit_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mpfit_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mpfit_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mpfit_at_bol;

    int mpfit_bs_lineno; /**< The line count. */
    int mpfit_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mpfit_fill_buffer;

	int mpfit_buffer_status;

#define MPFIT_BUFFER_NEW 0
#define MPFIT_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as MPFIT_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mpfitrestart()), so that the user can continue scanning by
	 * just pointing mpfitin at a new input file.
	 */
#define MPFIT_BUFFER_EOF_PENDING 2

	};
#endif /* !MPFIT_STRUCT_MPFIT_BUFFER_STATE */

/* Stack of input buffers. */
static size_t mpfit_buffer_stack_top = 0; /**< index of top of stack. */
static size_t mpfit_buffer_stack_max = 0; /**< capacity of stack. */
static MPFIT_BUFFER_STATE * mpfit_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define MPFIT_CURRENT_BUFFER ( (mpfit_buffer_stack) \
                          ? (mpfit_buffer_stack)[(mpfit_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define MPFIT_CURRENT_BUFFER_LVALUE (mpfit_buffer_stack)[(mpfit_buffer_stack_top)]

/* mpfit_hold_char holds the character lost when mpfittext is formed. */
static char mpfit_hold_char;
static int mpfit_n_chars;		/* number of characters read into mpfit_ch_buf */
int mpfitleng;

/* Points to current character in buffer. */
static char *mpfit_c_buf_p = NULL;
static int mpfit_init = 0;		/* whether we need to initialize */
static int mpfit_start = 0;	/* start state number */

/* Flag which is used to allow mpfitwrap()'s to do buffer switches
 * instead of setting up a fresh mpfitin.  A bit of a hack ...
 */
static int mpfit_did_buffer_switch_on_eof;

void mpfitrestart ( FILE *input_file  );
void mpfit_switch_to_buffer ( MPFIT_BUFFER_STATE new_buffer  );
MPFIT_BUFFER_STATE mpfit_create_buffer ( FILE *file, int size  );
void mpfit_delete_buffer ( MPFIT_BUFFER_STATE b  );
void mpfit_flush_buffer ( MPFIT_BUFFER_STATE b  );
void mpfitpush_buffer_state ( MPFIT_BUFFER_STATE new_buffer  );
void mpfitpop_buffer_state ( void );

static void mpfitensure_buffer_stack ( void );
static void mpfit_load_buffer_state ( void );
static void mpfit_init_buffer ( MPFIT_BUFFER_STATE b, FILE *file  );
#define MPFIT_FLUSH_BUFFER mpfit_flush_buffer( MPFIT_CURRENT_BUFFER )

MPFIT_BUFFER_STATE mpfit_scan_buffer ( char *base, mpfit_size_t size  );
MPFIT_BUFFER_STATE mpfit_scan_string ( const char *mpfit_str  );
MPFIT_BUFFER_STATE mpfit_scan_bytes ( const char *bytes, int len  );

void *mpfitalloc ( mpfit_size_t  );
void *mpfitrealloc ( void *, mpfit_size_t  );
void mpfitfree ( void *  );

#define mpfit_new_buffer mpfit_create_buffer
#define mpfit_set_interactive(is_interactive) \
	{ \
	if ( ! MPFIT_CURRENT_BUFFER ){ \
        mpfitensure_buffer_stack (); \
		MPFIT_CURRENT_BUFFER_LVALUE =    \
            mpfit_create_buffer( mpfitin, MPFIT_BUF_SIZE ); \
	} \
	MPFIT_CURRENT_BUFFER_LVALUE->mpfit_is_interactive = is_interactive; \
	}
#define mpfit_set_bol(at_bol) \
	{ \
	if ( ! MPFIT_CURRENT_BUFFER ){\
        mpfitensure_buffer_stack (); \
		MPFIT_CURRENT_BUFFER_LVALUE =    \
            mpfit_create_buffer( mpfitin, MPFIT_BUF_SIZE ); \
	} \
	MPFIT_CURRENT_BUFFER_LVALUE->mpfit_at_bol = at_bol; \
	}
#define MPFIT_AT_BOL() (MPFIT_CURRENT_BUFFER_LVALUE->mpfit_at_bol)

/* Begin user sect3 */

#define mpfitwrap() (/*CONSTCOND*/1)
#define MPFIT_SKIP_MPFITWRAP
typedef flex_uint8_t MPFIT_CHAR;

FILE *mpfitin = NULL, *mpfitout = NULL;

typedef int mpfit_state_type;

#define MPFIT_FLEX_LEX_COMPAT
extern int mpfitlineno;
int mpfitlineno = 1;

extern char mpfittext[];

static mpfit_state_type mpfit_get_previous_state ( void );
static mpfit_state_type mpfit_try_NUL_trans ( mpfit_state_type current_state  );
static int mpfit_get_next_buffer ( void );
static void mpfitnoreturn mpfit_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mpfittext.
 */
#define MPFIT_DO_BEFORE_ACTION \
	(mpfittext_ptr) = mpfit_bp; \
	mpfitleng = (int) (mpfit_cp - mpfit_bp); \
	(mpfit_hold_char) = *mpfit_cp; \
	*mpfit_cp = '\0'; \
	if ( mpfitleng >= MPFITLMAX ) \
		MPFIT_FATAL_ERROR( "token too large, exceeds MPFITLMAX" ); \
	mpfit_flex_strncpy( mpfittext, (mpfittext_ptr), mpfitleng + 1 ); \
	(mpfit_c_buf_p) = mpfit_cp;
#define MPFIT_NUM_RULES 8
#define MPFIT_END_OF_BUFFER 9
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct mpfit_trans_info
	{
	flex_int32_t mpfit_verify;
	flex_int32_t mpfit_nxt;
	};
static const flex_int16_t mpfit_accept[23] =
    {   0,
        0,    0,    9,    7,    6,    5,    7,    1,    4,    2,
        2,    1,    0,    0,    3,    4,    0,    0,    2,    0,
        2,    0
    } ;

static const MPFIT_CHAR mpfit_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    1,    1,    1,    1,    1,    1,    1,    4,
        5,    5,    6,    5,    6,    7,    5,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    5,    1,
        5,    1,    1,    1,    9,    9,    9,   10,   10,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        1,    1,    1,    5,    9,    1,    9,    9,    9,   10,

       10,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const MPFIT_CHAR mpfit_meta[11] =
    {   0,
        1,    1,    2,    2,    1,    1,    1,    2,    2,    2
    } ;

static const flex_int16_t mpfit_base[24] =
    {   0,
        0,    0,   33,   34,   34,   34,   24,    4,   12,    9,
       21,    0,   14,   20,   34,   22,   21,   22,   20,   13,
       10,   34,   11
    } ;

static const flex_int16_t mpfit_def[24] =
    {   0,
       22,    1,   22,   22,   22,   22,   22,   22,   23,   22,
       10,    8,   22,   22,   22,   23,   22,   22,   22,   22,
       22,    0,   22
    } ;

static const flex_int16_t mpfit_nxt[45] =
    {   0,
        4,    5,    4,    6,    6,    6,    7,    8,    9,    9,
       11,   12,   16,   13,   14,   15,   10,   21,   17,   18,
       21,   19,   14,   15,   14,   15,   20,   19,   21,   19,
       13,   10,   22,    3,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22
    } ;

static const flex_int16_t mpfit_chk[45] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        8,    8,   23,    8,    9,    9,   10,   21,   10,   13,
       20,   13,   14,   14,   16,   16,   17,   19,   17,   18,
       11,    7,    3,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t mpfit_rule_can_match_eol[9] =
    {   0,
0, 0, 0, 0, 0, 1, 0, 0,     };

static mpfit_state_type mpfit_last_accepting_state;
static char *mpfit_last_accepting_cpos;

extern int mpfit_flex_debug;
int mpfit_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mpfitmore() mpfitmore_used_but_not_detected
#define MPFIT_MORE_ADJ 0
#define MPFIT_RESTORE_MPFIT_MORE_OFFSET
#ifndef MPFITLMAX
#define MPFITLMAX 8192
#endif

char mpfittext[MPFITLMAX];
char *mpfittext_ptr;
#line 1 "mpfit/mpfit.l"
#line 3 "mpfit/mpfit.l"
#include <cstdlib>
#include <string>
#include "mpfitAST.h"
#include "dpuser_utils.h"

int mpfitparse();
void mpfiterror(const char *s);
void initialize_mpfit_functions(void);

#include "mpfitParser.h"
#line 499 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"
#line 500 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"

#define INITIAL 0

#ifndef MPFIT_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef MPFIT_EXTRA_TYPE
#define MPFIT_EXTRA_TYPE void *
#endif

static int mpfit_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int mpfitlex_destroy ( void );

int mpfitget_debug ( void );

void mpfitset_debug ( int debug_flag  );

MPFIT_EXTRA_TYPE mpfitget_extra ( void );

void mpfitset_extra ( MPFIT_EXTRA_TYPE user_defined  );

FILE *mpfitget_in ( void );

void mpfitset_in  ( FILE * _in_str  );

FILE *mpfitget_out ( void );

void mpfitset_out  ( FILE * _out_str  );

			int mpfitget_leng ( void );

char *mpfitget_text ( void );

int mpfitget_lineno ( void );

void mpfitset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef MPFIT_SKIP_MPFITWRAP
#ifdef __cplusplus
extern "C" int mpfitwrap ( void );
#else
extern int mpfitwrap ( void );
#endif
#endif

#ifndef MPFIT_NO_UNPUT
    
    static void mpfitunput ( int c, char *buf_ptr  );
    
#endif

#ifndef mpfittext_ptr
static void mpfit_flex_strncpy ( char *, const char *, int );
#endif

#ifdef MPFIT_NEED_STRLEN
static int mpfit_flex_strlen ( const char * );
#endif

#ifndef MPFIT_NO_INPUT
#ifdef __cplusplus
static int mpfitinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef MPFIT_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define MPFIT_READ_BUF_SIZE 16384
#else
#define MPFIT_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( mpfittext, (size_t) mpfitleng, 1, mpfitout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or MPFIT_NULL,
 * is returned in "result".
 */
#ifndef MPFIT_INPUT
#define MPFIT_INPUT(buf,result,max_size) \
	if ( MPFIT_CURRENT_BUFFER_LVALUE->mpfit_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mpfitin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mpfitin ) ) \
			MPFIT_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (mpfit_size_t) max_size, mpfitin)) == 0 && ferror(mpfitin)) \
			{ \
			if( errno != EINTR) \
				{ \
				MPFIT_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(mpfitin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "mpfitterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mpfitterminate
#define mpfitterminate() return MPFIT_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef MPFIT_START_STACK_INCR
#define MPFIT_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef MPFIT_FATAL_ERROR
#define MPFIT_FATAL_ERROR(msg) mpfit_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef MPFIT_DECL
#define MPFIT_DECL_IS_OURS 1

extern int mpfitlex (void);

#define MPFIT_DECL int mpfitlex (void)
#endif /* !MPFIT_DECL */

/* Code executed at the beginning of each rule, after mpfittext and mpfitleng
 * have been set up.
 */
#ifndef MPFIT_USER_ACTION
#define MPFIT_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef MPFIT_BREAK
#define MPFIT_BREAK /*LINTED*/break;
#endif

#define MPFIT_RULE_SETUP \
	MPFIT_USER_ACTION

/** The main scanner function which does all the work.
 */
MPFIT_DECL
{
	mpfit_state_type mpfit_current_state;
	char *mpfit_cp, *mpfit_bp;
	int mpfit_act;
    
	if ( !(mpfit_init) )
		{
		(mpfit_init) = 1;

#ifdef MPFIT_USER_INIT
		MPFIT_USER_INIT;
#endif

		if ( ! (mpfit_start) )
			(mpfit_start) = 1;	/* first start state */

		if ( ! mpfitin )
			mpfitin = stdin;

		if ( ! mpfitout )
			mpfitout = stdout;

		if ( ! MPFIT_CURRENT_BUFFER ) {
			mpfitensure_buffer_stack ();
			MPFIT_CURRENT_BUFFER_LVALUE =
				mpfit_create_buffer( mpfitin, MPFIT_BUF_SIZE );
		}

		mpfit_load_buffer_state(  );
		}

	{
#line 25 "mpfit/mpfit.l"


#line 720 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		mpfit_cp = (mpfit_c_buf_p);

		/* Support of mpfittext. */
		*mpfit_cp = (mpfit_hold_char);

		/* mpfit_bp points to the position in mpfit_ch_buf of the start of
		 * the current run.
		 */
		mpfit_bp = mpfit_cp;

		mpfit_current_state = (mpfit_start);
mpfit_match:
		do
			{
			MPFIT_CHAR mpfit_c = mpfit_ec[MPFIT_SC_TO_UI(*mpfit_cp)] ;
			if ( mpfit_accept[mpfit_current_state] )
				{
				(mpfit_last_accepting_state) = mpfit_current_state;
				(mpfit_last_accepting_cpos) = mpfit_cp;
				}
			while ( mpfit_chk[mpfit_base[mpfit_current_state] + mpfit_c] != mpfit_current_state )
				{
				mpfit_current_state = (int) mpfit_def[mpfit_current_state];
				if ( mpfit_current_state >= 23 )
					mpfit_c = mpfit_meta[mpfit_c];
				}
			mpfit_current_state = mpfit_nxt[mpfit_base[mpfit_current_state] + mpfit_c];
			++mpfit_cp;
			}
		while ( mpfit_base[mpfit_current_state] != 34 );

mpfit_find_action:
		mpfit_act = mpfit_accept[mpfit_current_state];
		if ( mpfit_act == 0 )
			{ /* have to back up */
			mpfit_cp = (mpfit_last_accepting_cpos);
			mpfit_current_state = (mpfit_last_accepting_state);
			mpfit_act = mpfit_accept[mpfit_current_state];
			}

		MPFIT_DO_BEFORE_ACTION;

		if ( mpfit_act != MPFIT_END_OF_BUFFER && mpfit_rule_can_match_eol[mpfit_act] )
			{
			int mpfitl;
			for ( mpfitl = 0; mpfitl < mpfitleng; ++mpfitl )
				if ( mpfittext[mpfitl] == '\n' )
					
    mpfitlineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( mpfit_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of MPFIT_DO_BEFORE_ACTION */
			*mpfit_cp = (mpfit_hold_char);
			mpfit_cp = (mpfit_last_accepting_cpos);
			mpfit_current_state = (mpfit_last_accepting_state);
			goto mpfit_find_action;

case 1:
MPFIT_RULE_SETUP
#line 27 "mpfit/mpfit.l"
{
                mpfitlval.i = atof(mpfittext);
                return REAL;
            }
	MPFIT_BREAK
case 2:
MPFIT_RULE_SETUP
#line 32 "mpfit/mpfit.l"
{
								for (int _c_ = 0; _c_ < strlen(mpfittext); _c_++) {
									if (mpfittext[_c_] == 'd') mpfittext[_c_] = 'e';
									else if (mpfittext[_c_] == 'D') mpfittext[_c_] = 'E';
								}
								mpfitlval.i = atof(mpfittext);
								return REAL;
						}
	MPFIT_BREAK
case 3:
MPFIT_RULE_SETUP
#line 41 "mpfit/mpfit.l"
{
                              mpfitlval.s = new std::string(mpfittext);
															return FUNC;
								 }
	MPFIT_BREAK
case 4:
MPFIT_RULE_SETUP
#line 47 "mpfit/mpfit.l"
mpfitlval.s = new std::string(mpfittext);  return VAR;
	MPFIT_BREAK
case 5:
MPFIT_RULE_SETUP
#line 48 "mpfit/mpfit.l"
return *mpfittext;
	MPFIT_BREAK
case 6:
/* rule 6 can match eol */
MPFIT_RULE_SETUP
#line 49 "mpfit/mpfit.l"
return ENTER ; 
	MPFIT_BREAK
case 7:
MPFIT_RULE_SETUP
#line 50 "mpfit/mpfit.l"
mpfiterror("Unknown character"); /* ignore all the rest */
	MPFIT_BREAK
case 8:
MPFIT_RULE_SETUP
#line 51 "mpfit/mpfit.l"
ECHO;
	MPFIT_BREAK
#line 841 "/home/ott/ottl/project/dpuser/build/mpfitScanner.cpp"
case MPFIT_STATE_EOF(INITIAL):
	mpfitterminate();

	case MPFIT_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mpfit_amount_of_matched_text = (int) (mpfit_cp - (mpfittext_ptr)) - 1;

		/* Undo the effects of MPFIT_DO_BEFORE_ACTION. */
		*mpfit_cp = (mpfit_hold_char);
		MPFIT_RESTORE_MPFIT_MORE_OFFSET

		if ( MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buffer_status == MPFIT_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mpfitin at a new source and called
			 * mpfitlex().  If so, then we have to assure
			 * consistency between MPFIT_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(mpfit_n_chars) = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars;
			MPFIT_CURRENT_BUFFER_LVALUE->mpfit_input_file = mpfitin;
			MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buffer_status = MPFIT_BUFFER_NORMAL;
			}

		/* Note that here we test for mpfit_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mpfit_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (mpfit_c_buf_p) <= &MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars)] )
			{ /* This was really a NUL. */
			mpfit_state_type mpfit_next_state;

			(mpfit_c_buf_p) = (mpfittext_ptr) + mpfit_amount_of_matched_text;

			mpfit_current_state = mpfit_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mpfit_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mpfit_next_state = mpfit_try_NUL_trans( mpfit_current_state );

			mpfit_bp = (mpfittext_ptr) + MPFIT_MORE_ADJ;

			if ( mpfit_next_state )
				{
				/* Consume the NUL. */
				mpfit_cp = ++(mpfit_c_buf_p);
				mpfit_current_state = mpfit_next_state;
				goto mpfit_match;
				}

			else
				{
				mpfit_cp = (mpfit_c_buf_p);
				goto mpfit_find_action;
				}
			}

		else switch ( mpfit_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(mpfit_did_buffer_switch_on_eof) = 0;

				if ( mpfitwrap(  ) )
					{
					/* Note: because we've taken care in
					 * mpfit_get_next_buffer() to have set up
					 * mpfittext, we can now set up
					 * mpfit_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * MPFIT_NULL, it'll still work - another
					 * MPFIT_NULL will get returned.
					 */
					(mpfit_c_buf_p) = (mpfittext_ptr) + MPFIT_MORE_ADJ;

					mpfit_act = MPFIT_STATE_EOF(MPFIT_START);
					goto do_action;
					}

				else
					{
					if ( ! (mpfit_did_buffer_switch_on_eof) )
						MPFIT_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(mpfit_c_buf_p) =
					(mpfittext_ptr) + mpfit_amount_of_matched_text;

				mpfit_current_state = mpfit_get_previous_state(  );

				mpfit_cp = (mpfit_c_buf_p);
				mpfit_bp = (mpfittext_ptr) + MPFIT_MORE_ADJ;
				goto mpfit_match;

			case EOB_ACT_LAST_MATCH:
				(mpfit_c_buf_p) =
				&MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars)];

				mpfit_current_state = mpfit_get_previous_state(  );

				mpfit_cp = (mpfit_c_buf_p);
				mpfit_bp = (mpfittext_ptr) + MPFIT_MORE_ADJ;
				goto mpfit_find_action;
			}
		break;
		}

	default:
		MPFIT_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of mpfitlex */

/* mpfit_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int mpfit_get_next_buffer (void)
{
    	char *dest = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf;
	char *source = (mpfittext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (mpfit_c_buf_p) > &MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars) + 1] )
		MPFIT_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( MPFIT_CURRENT_BUFFER_LVALUE->mpfit_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (mpfit_c_buf_p) - (mpfittext_ptr) - MPFIT_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((mpfit_c_buf_p) - (mpfittext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buffer_status == MPFIT_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars = (mpfit_n_chars) = 0;

	else
		{
			int num_to_read =
			MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			MPFIT_BUFFER_STATE b = MPFIT_CURRENT_BUFFER_LVALUE;

			int mpfit_c_buf_p_offset =
				(int) ((mpfit_c_buf_p) - b->mpfit_ch_buf);

			if ( b->mpfit_is_our_buffer )
				{
				int new_size = b->mpfit_buf_size * 2;

				if ( new_size <= 0 )
					b->mpfit_buf_size += b->mpfit_buf_size / 8;
				else
					b->mpfit_buf_size *= 2;

				b->mpfit_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mpfitrealloc( (void *) b->mpfit_ch_buf,
							 (mpfit_size_t) (b->mpfit_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mpfit_ch_buf = NULL;

			if ( ! b->mpfit_ch_buf )
				MPFIT_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(mpfit_c_buf_p) = &b->mpfit_ch_buf[mpfit_c_buf_p_offset];

			num_to_read = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > MPFIT_READ_BUF_SIZE )
			num_to_read = MPFIT_READ_BUF_SIZE;

		/* Read in more data. */
		MPFIT_INPUT( (&MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[number_to_move]),
			(mpfit_n_chars), num_to_read );

		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars = (mpfit_n_chars);
		}

	if ( (mpfit_n_chars) == 0 )
		{
		if ( number_to_move == MPFIT_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mpfitrestart( mpfitin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buffer_status =
				MPFIT_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((mpfit_n_chars) + number_to_move) > MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (mpfit_n_chars) + number_to_move + ((mpfit_n_chars) >> 1);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf = (char *) mpfitrealloc(
			(void *) MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf, (mpfit_size_t) new_size  );
		if ( ! MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf )
			MPFIT_FATAL_ERROR( "out of dynamic memory in mpfit_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size = (int) (new_size - 2);
	}

	(mpfit_n_chars) += number_to_move;
	MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars)] = MPFIT_END_OF_BUFFER_CHAR;
	MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars) + 1] = MPFIT_END_OF_BUFFER_CHAR;

	(mpfittext_ptr) = &MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[0];

	return ret_val;
}

/* mpfit_get_previous_state - get the state just before the EOB char was reached */

    static mpfit_state_type mpfit_get_previous_state (void)
{
	mpfit_state_type mpfit_current_state;
	char *mpfit_cp;
    
	mpfit_current_state = (mpfit_start);

	for ( mpfit_cp = (mpfittext_ptr) + MPFIT_MORE_ADJ; mpfit_cp < (mpfit_c_buf_p); ++mpfit_cp )
		{
		MPFIT_CHAR mpfit_c = (*mpfit_cp ? mpfit_ec[MPFIT_SC_TO_UI(*mpfit_cp)] : 1);
		if ( mpfit_accept[mpfit_current_state] )
			{
			(mpfit_last_accepting_state) = mpfit_current_state;
			(mpfit_last_accepting_cpos) = mpfit_cp;
			}
		while ( mpfit_chk[mpfit_base[mpfit_current_state] + mpfit_c] != mpfit_current_state )
			{
			mpfit_current_state = (int) mpfit_def[mpfit_current_state];
			if ( mpfit_current_state >= 23 )
				mpfit_c = mpfit_meta[mpfit_c];
			}
		mpfit_current_state = mpfit_nxt[mpfit_base[mpfit_current_state] + mpfit_c];
		}

	return mpfit_current_state;
}

/* mpfit_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mpfit_try_NUL_trans( current_state );
 */
    static mpfit_state_type mpfit_try_NUL_trans  (mpfit_state_type mpfit_current_state )
{
	int mpfit_is_jam;
    	char *mpfit_cp = (mpfit_c_buf_p);

	MPFIT_CHAR mpfit_c = 1;
	if ( mpfit_accept[mpfit_current_state] )
		{
		(mpfit_last_accepting_state) = mpfit_current_state;
		(mpfit_last_accepting_cpos) = mpfit_cp;
		}
	while ( mpfit_chk[mpfit_base[mpfit_current_state] + mpfit_c] != mpfit_current_state )
		{
		mpfit_current_state = (int) mpfit_def[mpfit_current_state];
		if ( mpfit_current_state >= 23 )
			mpfit_c = mpfit_meta[mpfit_c];
		}
	mpfit_current_state = mpfit_nxt[mpfit_base[mpfit_current_state] + mpfit_c];
	mpfit_is_jam = (mpfit_current_state == 22);

		return mpfit_is_jam ? 0 : mpfit_current_state;
}

#ifndef MPFIT_NO_UNPUT

    static void mpfitunput (int c, char * mpfit_bp )
{
	char *mpfit_cp;
    
    mpfit_cp = (mpfit_c_buf_p);

	/* undo effects of setting up mpfittext */
	*mpfit_cp = (mpfit_hold_char);

	if ( mpfit_cp < MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (mpfit_n_chars) + 2;
		char *dest = &MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[
					MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size + 2];
		char *source =
				&MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[number_to_move];

		while ( source > MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf )
			*--dest = *--source;

		mpfit_cp += (int) (dest - source);
		mpfit_bp += (int) (dest - source);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars =
			(mpfit_n_chars) = (int) MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_size;

		if ( mpfit_cp < MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf + 2 )
			MPFIT_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--mpfit_cp = (char) c;

    if ( c == '\n' ){
        --mpfitlineno;
    }

	(mpfittext_ptr) = mpfit_bp;
	(mpfit_hold_char) = *mpfit_cp;
	(mpfit_c_buf_p) = mpfit_cp;
}

#endif

#ifndef MPFIT_NO_INPUT
#ifdef __cplusplus
    static int mpfitinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(mpfit_c_buf_p) = (mpfit_hold_char);

	if ( *(mpfit_c_buf_p) == MPFIT_END_OF_BUFFER_CHAR )
		{
		/* mpfit_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (mpfit_c_buf_p) < &MPFIT_CURRENT_BUFFER_LVALUE->mpfit_ch_buf[(mpfit_n_chars)] )
			/* This was really a NUL. */
			*(mpfit_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((mpfit_c_buf_p) - (mpfittext_ptr));
			++(mpfit_c_buf_p);

			switch ( mpfit_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mpfit_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mpfitrestart( mpfitin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( mpfitwrap(  ) )
						return 0;

					if ( ! (mpfit_did_buffer_switch_on_eof) )
						MPFIT_NEW_FILE;
#ifdef __cplusplus
					return mpfitinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(mpfit_c_buf_p) = (mpfittext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (mpfit_c_buf_p);	/* cast for 8-bit char's */
	*(mpfit_c_buf_p) = '\0';	/* preserve mpfittext */
	(mpfit_hold_char) = *++(mpfit_c_buf_p);

	if ( c == '\n' )
		
    mpfitlineno++;
;

	return c;
}
#endif	/* ifndef MPFIT_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void mpfitrestart  (FILE * input_file )
{
    
	if ( ! MPFIT_CURRENT_BUFFER ){
        mpfitensure_buffer_stack ();
		MPFIT_CURRENT_BUFFER_LVALUE =
            mpfit_create_buffer( mpfitin, MPFIT_BUF_SIZE );
	}

	mpfit_init_buffer( MPFIT_CURRENT_BUFFER, input_file );
	mpfit_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void mpfit_switch_to_buffer  (MPFIT_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		mpfitpop_buffer_state();
	 *		mpfitpush_buffer_state(new_buffer);
     */
	mpfitensure_buffer_stack ();
	if ( MPFIT_CURRENT_BUFFER == new_buffer )
		return;

	if ( MPFIT_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mpfit_c_buf_p) = (mpfit_hold_char);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_pos = (mpfit_c_buf_p);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars = (mpfit_n_chars);
		}

	MPFIT_CURRENT_BUFFER_LVALUE = new_buffer;
	mpfit_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (mpfitwrap()) processing, but the only time this flag
	 * is looked at is after mpfitwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(mpfit_did_buffer_switch_on_eof) = 1;
}

static void mpfit_load_buffer_state  (void)
{
    	(mpfit_n_chars) = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars;
	(mpfittext_ptr) = (mpfit_c_buf_p) = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_pos;
	mpfitin = MPFIT_CURRENT_BUFFER_LVALUE->mpfit_input_file;
	(mpfit_hold_char) = *(mpfit_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c MPFIT_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    MPFIT_BUFFER_STATE mpfit_create_buffer  (FILE * file, int  size )
{
	MPFIT_BUFFER_STATE b;
    
	b = (MPFIT_BUFFER_STATE) mpfitalloc( sizeof( struct mpfit_buffer_state )  );
	if ( ! b )
		MPFIT_FATAL_ERROR( "out of dynamic memory in mpfit_create_buffer()" );

	b->mpfit_buf_size = size;

	/* mpfit_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mpfit_ch_buf = (char *) mpfitalloc( (mpfit_size_t) (b->mpfit_buf_size + 2)  );
	if ( ! b->mpfit_ch_buf )
		MPFIT_FATAL_ERROR( "out of dynamic memory in mpfit_create_buffer()" );

	b->mpfit_is_our_buffer = 1;

	mpfit_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with mpfit_create_buffer()
 * 
 */
    void mpfit_delete_buffer (MPFIT_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == MPFIT_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		MPFIT_CURRENT_BUFFER_LVALUE = (MPFIT_BUFFER_STATE) 0;

	if ( b->mpfit_is_our_buffer )
		mpfitfree( (void *) b->mpfit_ch_buf  );

	mpfitfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a mpfitrestart() or at EOF.
 */
    static void mpfit_init_buffer  (MPFIT_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	mpfit_flush_buffer( b );

	b->mpfit_input_file = file;
	b->mpfit_fill_buffer = 1;

    /* If b is the current buffer, then mpfit_init_buffer was _probably_
     * called from mpfitrestart() or through mpfit_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != MPFIT_CURRENT_BUFFER){
        b->mpfit_bs_lineno = 1;
        b->mpfit_bs_column = 0;
    }

        b->mpfit_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, MPFIT_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c MPFIT_CURRENT_BUFFER.
 * 
 */
    void mpfit_flush_buffer (MPFIT_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->mpfit_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mpfit_ch_buf[0] = MPFIT_END_OF_BUFFER_CHAR;
	b->mpfit_ch_buf[1] = MPFIT_END_OF_BUFFER_CHAR;

	b->mpfit_buf_pos = &b->mpfit_ch_buf[0];

	b->mpfit_at_bol = 1;
	b->mpfit_buffer_status = MPFIT_BUFFER_NEW;

	if ( b == MPFIT_CURRENT_BUFFER )
		mpfit_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void mpfitpush_buffer_state (MPFIT_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	mpfitensure_buffer_stack();

	/* This block is copied from mpfit_switch_to_buffer. */
	if ( MPFIT_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mpfit_c_buf_p) = (mpfit_hold_char);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_buf_pos = (mpfit_c_buf_p);
		MPFIT_CURRENT_BUFFER_LVALUE->mpfit_n_chars = (mpfit_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (MPFIT_CURRENT_BUFFER)
		(mpfit_buffer_stack_top)++;
	MPFIT_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from mpfit_switch_to_buffer. */
	mpfit_load_buffer_state(  );
	(mpfit_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void mpfitpop_buffer_state (void)
{
    	if (!MPFIT_CURRENT_BUFFER)
		return;

	mpfit_delete_buffer(MPFIT_CURRENT_BUFFER );
	MPFIT_CURRENT_BUFFER_LVALUE = NULL;
	if ((mpfit_buffer_stack_top) > 0)
		--(mpfit_buffer_stack_top);

	if (MPFIT_CURRENT_BUFFER) {
		mpfit_load_buffer_state(  );
		(mpfit_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void mpfitensure_buffer_stack (void)
{
	mpfit_size_t num_to_alloc;
    
	if (!(mpfit_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(mpfit_buffer_stack) = (struct mpfit_buffer_state**)mpfitalloc
								(num_to_alloc * sizeof(struct mpfit_buffer_state*)
								);
		if ( ! (mpfit_buffer_stack) )
			MPFIT_FATAL_ERROR( "out of dynamic memory in mpfitensure_buffer_stack()" );

		memset((mpfit_buffer_stack), 0, num_to_alloc * sizeof(struct mpfit_buffer_state*));

		(mpfit_buffer_stack_max) = num_to_alloc;
		(mpfit_buffer_stack_top) = 0;
		return;
	}

	if ((mpfit_buffer_stack_top) >= ((mpfit_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		mpfit_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (mpfit_buffer_stack_max) + grow_size;
		(mpfit_buffer_stack) = (struct mpfit_buffer_state**)mpfitrealloc
								((mpfit_buffer_stack),
								num_to_alloc * sizeof(struct mpfit_buffer_state*)
								);
		if ( ! (mpfit_buffer_stack) )
			MPFIT_FATAL_ERROR( "out of dynamic memory in mpfitensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((mpfit_buffer_stack) + (mpfit_buffer_stack_max), 0, grow_size * sizeof(struct mpfit_buffer_state*));
		(mpfit_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
MPFIT_BUFFER_STATE mpfit_scan_buffer  (char * base, mpfit_size_t  size )
{
	MPFIT_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != MPFIT_END_OF_BUFFER_CHAR ||
	     base[size-1] != MPFIT_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (MPFIT_BUFFER_STATE) mpfitalloc( sizeof( struct mpfit_buffer_state )  );
	if ( ! b )
		MPFIT_FATAL_ERROR( "out of dynamic memory in mpfit_scan_buffer()" );

	b->mpfit_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->mpfit_buf_pos = b->mpfit_ch_buf = base;
	b->mpfit_is_our_buffer = 0;
	b->mpfit_input_file = NULL;
	b->mpfit_n_chars = b->mpfit_buf_size;
	b->mpfit_is_interactive = 0;
	b->mpfit_at_bol = 1;
	b->mpfit_fill_buffer = 0;
	b->mpfit_buffer_status = MPFIT_BUFFER_NEW;

	mpfit_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to mpfitlex() will
 * scan from a @e copy of @a str.
 * @param mpfitstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       mpfit_scan_bytes() instead.
 */
MPFIT_BUFFER_STATE mpfit_scan_string (const char * mpfitstr )
{
    
	return mpfit_scan_bytes( mpfitstr, (int) strlen(mpfitstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to mpfitlex() will
 * scan from a @e copy of @a bytes.
 * @param mpfitbytes the byte buffer to scan
 * @param _mpfitbytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
MPFIT_BUFFER_STATE mpfit_scan_bytes  (const char * mpfitbytes, int  _mpfitbytes_len )
{
	MPFIT_BUFFER_STATE b;
	char *buf;
	mpfit_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (mpfit_size_t) (_mpfitbytes_len + 2);
	buf = (char *) mpfitalloc( n  );
	if ( ! buf )
		MPFIT_FATAL_ERROR( "out of dynamic memory in mpfit_scan_bytes()" );

	for ( i = 0; i < _mpfitbytes_len; ++i )
		buf[i] = mpfitbytes[i];

	buf[_mpfitbytes_len] = buf[_mpfitbytes_len+1] = MPFIT_END_OF_BUFFER_CHAR;

	b = mpfit_scan_buffer( buf, n );
	if ( ! b )
		MPFIT_FATAL_ERROR( "bad buffer in mpfit_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mpfit_is_our_buffer = 1;

	return b;
}

#ifndef MPFIT_EXIT_FAILURE
#define MPFIT_EXIT_FAILURE 2
#endif

static void mpfitnoreturn mpfit_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( MPFIT_EXIT_FAILURE );
}

/* Redefine mpfitless() so it works in section 3 code. */

#undef mpfitless
#define mpfitless(n) \
	do \
		{ \
		/* Undo effects of setting up mpfittext. */ \
        int mpfitless_macro_arg = (n); \
        MPFIT_LESS_LINENO(mpfitless_macro_arg);\
		mpfittext[mpfitleng] = (mpfit_hold_char); \
		(mpfit_c_buf_p) = mpfittext + mpfitless_macro_arg; \
		(mpfit_hold_char) = *(mpfit_c_buf_p); \
		*(mpfit_c_buf_p) = '\0'; \
		mpfitleng = mpfitless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int mpfitget_lineno  (void)
{
    
    return mpfitlineno;
}

/** Get the input stream.
 * 
 */
FILE *mpfitget_in  (void)
{
        return mpfitin;
}

/** Get the output stream.
 * 
 */
FILE *mpfitget_out  (void)
{
        return mpfitout;
}

/** Get the length of the current token.
 * 
 */
int mpfitget_leng  (void)
{
        return mpfitleng;
}

/** Get the current token.
 * 
 */

char *mpfitget_text  (void)
{
        return mpfittext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void mpfitset_lineno (int  _line_number )
{
    
    mpfitlineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see mpfit_switch_to_buffer
 */
void mpfitset_in (FILE *  _in_str )
{
        mpfitin = _in_str ;
}

void mpfitset_out (FILE *  _out_str )
{
        mpfitout = _out_str ;
}

int mpfitget_debug  (void)
{
        return mpfit_flex_debug;
}

void mpfitset_debug (int  _bdebug )
{
        mpfit_flex_debug = _bdebug ;
}

static int mpfit_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from mpfitlex_destroy(), so don't allocate here.
     */

    /* We do not touch mpfitlineno unless the option is enabled. */
    mpfitlineno =  1;
    
    (mpfit_buffer_stack) = NULL;
    (mpfit_buffer_stack_top) = 0;
    (mpfit_buffer_stack_max) = 0;
    (mpfit_c_buf_p) = NULL;
    (mpfit_init) = 0;
    (mpfit_start) = 0;

/* Defined in main.c */
#ifdef MPFIT_STDINIT
    mpfitin = stdin;
    mpfitout = stdout;
#else
    mpfitin = NULL;
    mpfitout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * mpfitlex_init()
     */
    return 0;
}

/* mpfitlex_destroy is for both reentrant and non-reentrant scanners. */
int mpfitlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(MPFIT_CURRENT_BUFFER){
		mpfit_delete_buffer( MPFIT_CURRENT_BUFFER  );
		MPFIT_CURRENT_BUFFER_LVALUE = NULL;
		mpfitpop_buffer_state();
	}

	/* Destroy the stack itself. */
	mpfitfree((mpfit_buffer_stack) );
	(mpfit_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * mpfitlex() is called, initialization will occur. */
    mpfit_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef mpfittext_ptr
static void mpfit_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef MPFIT_NEED_STRLEN
static int mpfit_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *mpfitalloc (mpfit_size_t  size )
{
			return malloc(size);
}

void *mpfitrealloc  (void * ptr, mpfit_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void mpfitfree (void * ptr )
{
			free( (char *) ptr );	/* see mpfitrealloc() for (char *) cast */
}

#define MPFITTABLES_NAME "mpfittables"

#line 51 "mpfit/mpfit.l"


void mpfiterror(const char *s) {
/*	dp_output("%s\n", s); */
	throw dpuserTypeException(const_cast<char*>(s));
}

int main_mpfit(std::string line) {
	initialize_mpfit_functions();
	mpfit_sorted_variables.clear();
	mpfitAST_dummy.clear();
	mpfit_scan_string(line.c_str());
	mpfitparse();
	return 0;
}

