/* $Id$ 
 *
 * Add: addition (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ADD_HPP_INCLUDED
#define __ADD_HPP_INCLUDED

#include "intermediate/operands/Register.hpp"

namespace intermediate {

//! add two operands and return a new operand as result.
/** This class will add both operands together and put the result in the
 *  target register.
 *  In case that left + right is a bigger value than dst can store, the
 *  result is undefined.
 *
 *  Read operands: left, right
 *  Write operands: dst
 *
 *  left operand: left operand for addition
 *  right operand: right operand for addition
 *  dst: destination operand, to which the result will get written to (any
 *  	 virtual register*)
 *
 *  Operation : dst = left + right
 *
 *  all operands must have the same type.
 *
 */
class Add : public OpCode {
public:
	//! c'tor
	/** @param l left source operand
	 *  @param r right source operand
	 *  @param destination destination register.
	 */
	Add(
		Operand *l,
		Operand *r,
		Register *destination
		) :	left(l), right(r), dst(destination) {

		assert(l->type == r->type);
		assert(l->type == destination->type);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination
	Register *dst;

protected:
	virtual ~Add() {
		util::MiscUtil::terminate(this->left);
		util::MiscUtil::terminate(this->right);
		util::MiscUtil::terminate(this->dst);
	}
};

}; /* namespace intermediate */

#endif /* __ADD_HPP_INCLUDED */
