/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include "delay_panel.h"

#define DP_DELAY    0
#define DP_FEEDBACK 1

#ifndef __GTK_DIAL_H__
 #include "gtkdial.h"
#endif

typedef struct mix_data{
  mixer *mix;
  int   index;
}mix_data;


static void time_callback(GtkAdjustment *adj, gpointer data)
{
  delay_set_time((delay *)data,adj->value);

}

static void feedback_callback(GtkAdjustment *adj, gpointer data)
{
    delay_set_feedback((delay *) data,(int)adj->value);
}


static void tap_mix_callback(GtkAdjustment *adj, gpointer data)
{
  mix_data *d = (mix_data *)data;
  mixer_set_amplitude(d->mix,(int)adj->value,d->index);
}

GtkWidget *delay_panel_new(multi_tap_delay *target,GtkStyle *dial_style)
{
  int i;
  int c1,c2,r1,r2;
  GtkWidget *panel;
  GtkWidget *table;
  GtkObject *range;
  GtkWidget *dial;
  GtkWidget *s_button;
  mix_data *md;

  panel = gtk_hbox_new(TRUE,10);
  table = gtk_table_new(3,target->num_taps,TRUE);
  c1 = 0;
  c2 = 1;
  r1 = 0;
  r2 = 1;

  for(i = 0; i < target->num_taps;i++){
    if(i == 0 )
      range = gtk_adjustment_new(375,0,2000,0.5,0.5,0.5);
    else
      range = gtk_adjustment_new(0,0,2000,0.5,0.5,0.5);
 
    s_button = gtk_spin_button_new(GTK_ADJUSTMENT(range),1,1);
    gtk_signal_connect (GTK_OBJECT (range), "value_changed",
			GTK_SIGNAL_FUNC (time_callback), 
			(gpointer)target->combs[i] );
    gtk_table_attach(GTK_TABLE(table),s_button,c1,c2,r1,r2,0,0,3,0);
    gtk_widget_set_usize(s_button,60,20);
    gtk_widget_show(s_button);

    if(i == 0 )
      range =  gtk_adjustment_new(MAX_FEEDBACK *.5,0,MAX_FEEDBACK ,1,1,1);
    else
      range =  gtk_adjustment_new(0,0,MAX_FEEDBACK ,1,1,1);

    dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
    gtk_signal_connect (GTK_OBJECT (range), "value_changed",
			GTK_SIGNAL_FUNC (feedback_callback), 
			(gpointer)target->combs[i]);
    gtk_table_attach(GTK_TABLE(table),dial,c1 + 1, c2 + 1,r1,r2,0,0,3,0);

    gtk_widget_set_usize(dial,32,32);
    gtk_widget_set_style(dial,dial_style);
    gtk_widget_show(dial);

    if(i == 0 )
      range =  gtk_adjustment_new(MAX_FEEDBACK,0,MAX_FEEDBACK ,1,1,1);
    else
      range =  gtk_adjustment_new(0,0,MAX_FEEDBACK ,1,1,1);

    dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
    
    md = (mix_data*)malloc(sizeof(mix_data));
    md->mix = target->mix;
    md->index = i;
    gtk_signal_connect (GTK_OBJECT (range), "value_changed",
			GTK_SIGNAL_FUNC (tap_mix_callback), 
			(gpointer)md);
    gtk_table_attach(GTK_TABLE(table),dial,c1 + 2, c2 + 2,r1,r2,0,0,3,0);

    gtk_widget_set_usize(dial,32,32);
    gtk_widget_set_style(dial,dial_style);
    gtk_widget_show(dial);

    r1++;
    r2++;
  }  
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(panel),table);
  
  return panel;
}







/*
  Local Variables:
  mode: font-lock
  End:
*/
