/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.ISequenceDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IGate;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionUse;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.ObList;

public class SequenceUpdater {
    public boolean createInteractionFromInteractionFragment(IModelingSession session, IInteractionUse use) {
        INameSpace creationDestination = use.getEnclosingInteraction().getOwner();
        IInteraction interaction = session.getModel().createInteraction();
        creationDestination.addOwnedBehavior((IBehavior)interaction);
        interaction.setName(use.getName());
        ISequenceDiagram diagram = session.getModel().createSequenceDiagram();
        diagram.setOrigin((IModelElement)interaction);
        diagram.setOwner(session.getModel().getUmlProject().getDiagramRoot());
        for (IGate gate : use.getActualGate()) {
            IGate formalGate = session.getModel().createGate(gate.getName());
            gate.setFormal(formalGate);
            formalGate.setEnclosingInteraction(interaction);
        }
        return true;
    }

    public void updateInteractionUseFromInteraction(IModelingSession session, IInteractionUse use) {
        IInteraction interaction = use.getRefersTo();
        if (interaction != null) {
            ObList existingGates = interaction.getFormalGate();
            boolean found = false;
            for (IGate gate : use.getActualGate()) {
                IGate formalGate = gate.getFormal();
                if (formalGate != null) {
                    if (formalGate.getEnclosingInteraction().equals((Object)interaction)) {
                        found = true;
                        break;
                    }
                    for (IGate existingGate : interaction.getFormalGate()) {
                        if (!existingGate.getName().equals(gate.getName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                gate.delete();
            }
            for (IGate existingGate : existingGates) {
                this.createGate(session, use, existingGate);
            }
        }
    }

    private void createGate(IModelingSession session, IInteractionUse use, IGate existingGate) {
        IGate formalGate = session.getModel().createGate();
        formalGate.setFormal(existingGate);
        use.addActualGate(formalGate);
        formalGate.setName(existingGate.getName());
    }
}

