/*
 * This file is part of Ginkgo CADx
 *
 * Copyright (c) 2015-2016 Gert Wollny
 * Copyright (c) 2008-2014 MetaEmotion S.L. All rights reserved.
 *
 * Ginkgo CADx is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser Public License
 * along with Ginkgo CADx; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once
#ifndef DOXMAINPAGE_H
#define DOXMAINPAGE_H

/**
    @mainpage Ginkgo CADx 3.0.0

     Ginkgo CADx is an extensible multi-platform Open Source Medical Imaging software which provides a complete DICOM Viewer solution with advanced capabilities.

	Extensions are both free or commercial plugins that allows you to expand the capabilities of Ginkgo CADx for your personal needs and provide advanced features such as image analytics based auto-diagnosis. Everyone can create their own extensions!.

    Key Classes:\n
      GNC::GCS::ICommand\n
      GNC::GCS::IView\n


    @ref whatsnew\n
    @ref basics\n
    @ref visualization\n
	@ref coordinates\n
    @ref integration\n
    @ref extending\n

    @section whatsnew What's new in Ginkgo CADx 3.0.0?

    For comprehensive list of changes and new features, please see the changelog.

    @section basics Understanding Ginkgo CADx framework

    As seen here, Ginkgo CADx application is constructed:

    @code

    #include <api/api.h>

    ...

    @endcode


	@section visualization The visualization system

	...

	@section coordinates The coordinates system

	...

	@section integration Integration

	...

	@section extending Extending Ginkgo CADx

	...

**/
#endif

