// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a program.
func (c *Client) CreateProgram(ctx context.Context, params *CreateProgramInput, optFns ...func(*Options)) (*CreateProgramOutput, error) {
	if params == nil {
		params = &CreateProgramInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProgram", params, optFns, c.addOperationCreateProgramMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProgramOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProgramInput struct {

	// The identifier for the channel you are working on.
	//
	// This member is required.
	ChannelName *string

	// The identifier for the program you are working on.
	//
	// This member is required.
	ProgramName *string

	// The schedule configuration settings.
	//
	// This member is required.
	ScheduleConfiguration *types.ScheduleConfiguration

	// The name of the source location.
	//
	// This member is required.
	SourceLocationName *string

	// The ad break configuration settings.
	AdBreaks []types.AdBreak

	// The name of the LiveSource for this Program.
	LiveSourceName *string

	// The name that's used to refer to a VOD source.
	VodSourceName *string

	noSmithyDocumentSerde
}

type CreateProgramOutput struct {

	// The ad break configuration settings.
	AdBreaks []types.AdBreak

	// The ARN of the program.
	Arn *string

	// The name of the channel that the program belongs to.
	ChannelName *string

	// The timestamp of when the program was created.
	CreationTime *time.Time

	// The name of the LiveSource for this Program.
	LiveSourceName *string

	// The name of the program.
	ProgramName *string

	// The date and time that the program is scheduled to start in ISO 8601 format and
	// Coordinated Universal Time (UTC). For example, the value
	// 2021-03-27T17:48:16.751Z represents March 27, 2021 at 17:48:16.751 UTC.
	ScheduledStartTime *time.Time

	// The source location name.
	SourceLocationName *string

	// The name that's used to refer to a VOD source.
	VodSourceName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProgramMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateProgram{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateProgram{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateProgramValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProgram(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProgram(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "mediatailor",
		OperationName: "CreateProgram",
	}
}
