//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import "time"

// Account - A billing account.
type Account struct {
	// The properties of the billing account.
	Properties *AccountProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AccountListResult - The list of billing accounts.
type AccountListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of billing accounts.
	Value []*Account
}

// AccountProperties - The properties of the billing account.
type AccountProperties struct {
	// The billing profiles associated with the billing account. By default this is not populated, unless it's specified in $expand.
	BillingProfiles *ProfilesOnExpand

	// The departments associated to the enrollment.
	Departments []*Department

	// The billing account name.
	DisplayName *string

	// The accounts associated to the enrollment.
	EnrollmentAccounts []*EnrollmentAccount

	// Notification email address, only for legacy accounts
	NotificationEmailAddress *string

	// The address of the individual or organization that is responsible for the billing account.
	SoldTo *AddressDetails

	// READ-ONLY; The current status of the billing account.
	AccountStatus *AccountStatus

	// READ-ONLY; The type of customer.
	AccountType *AccountType

	// READ-ONLY; The type of agreement.
	AgreementType *AgreementType

	// READ-ONLY; The details about the associated legacy enrollment. By default this is not populated, unless it's specified
	// in $expand.
	EnrollmentDetails *Enrollment

	// READ-ONLY; Indicates whether user has read access to the billing account.
	HasReadAccess *bool
}

// AccountUpdateRequest - The request properties of the billing account that can be updated.
type AccountUpdateRequest struct {
	// A billing property.
	Properties *AccountProperties
}

// AddressDetails - Address details.
type AddressDetails struct {
	// REQUIRED; Address line 1.
	AddressLine1 *string

	// REQUIRED; Country code uses ISO2, 2-digit format.
	Country *string

	// Address line 2.
	AddressLine2 *string

	// Address line 3.
	AddressLine3 *string

	// Address city.
	City *string

	// Company name.
	CompanyName *string

	// Address district.
	District *string

	// Email address.
	Email *string

	// First name.
	FirstName *string

	// Last name.
	LastName *string

	// Middle name.
	MiddleName *string

	// Phone number.
	PhoneNumber *string

	// Postal code.
	PostalCode *string

	// Address region.
	Region *string
}

// Agreement - An agreement.
type Agreement struct {
	// The properties of an agreement.
	Properties *AgreementProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AgreementListResult - Result of listing agreements.
type AgreementListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of agreements.
	Value []*Agreement
}

// AgreementProperties - The properties of an agreement.
type AgreementProperties struct {
	// The list of participants that participates in acceptance of an agreement.
	Participants []*Participants

	// READ-ONLY; The mode of acceptance for an agreement.
	AcceptanceMode *AcceptanceMode

	// READ-ONLY; The URL to download the agreement.
	AgreementLink *string

	// READ-ONLY; The list of billing profiles associated with agreement and present only for specific agreements.
	BillingProfileInfo *ProfileInfo

	// READ-ONLY; The category of the agreement signed by a customer.
	Category *Category

	// READ-ONLY; The date from which the agreement is effective.
	EffectiveDate *time.Time

	// READ-ONLY; The date when the agreement expires.
	ExpirationDate *time.Time

	// READ-ONLY; The current status of the agreement.
	Status *string
}

// Amount - The amount.
type Amount struct {
	// Amount value.
	Value *float32

	// READ-ONLY; The currency for the amount value.
	Currency *string
}

// AvailableBalance - The latest Azure credit balance. This is the balance available for pay now.
type AvailableBalance struct {
	// The properties of available balance.
	Properties *AvailableBalanceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AvailableBalanceProperties - The properties of available balance.
type AvailableBalanceProperties struct {
	// READ-ONLY; Balance amount.
	Amount *Amount
}

// AzurePlan - Details of the Azure plan.
type AzurePlan struct {
	// The sku id.
	SKUID *string

	// READ-ONLY; The sku description.
	SKUDescription *string
}

// Customer - A partner's customer.
type Customer struct {
	// The customer.
	Properties *CustomerProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomerListResult - The list of customers.
type CustomerListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of customers.
	Value []*Customer
}

// CustomerPolicy - The customer's Policy.
type CustomerPolicy struct {
	// The properties of a customer's policy.
	Properties *CustomerPolicyProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomerPolicyProperties - The properties of a customer's policy.
type CustomerPolicyProperties struct {
	// The policy that controls whether the users in customer's organization can view charges at pay-as-you-go prices.
	ViewCharges *ViewCharges
}

// CustomerProperties - The properties of a customer.
type CustomerProperties struct {
	// The name of the customer.
	DisplayName *string

	// Azure plans enabled for the customer.
	EnabledAzurePlans []*AzurePlan

	// The list of resellers for which an Azure plan is enabled for the customer.
	Resellers []*Reseller

	// READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string
}

// Department - A department.
type Department struct {
	// A department.
	Properties *DepartmentProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DepartmentProperties - The properties of a department.
type DepartmentProperties struct {
	// The cost center associated with the department.
	CostCenter *string

	// The name of the department.
	DepartmentName *string

	// Associated enrollment accounts. By default this is not populated, unless it's specified in $expand.
	EnrollmentAccounts []*EnrollmentAccount

	// The status of the department.
	Status *string
}

// Document - The properties of a document.
type Document struct {
	// READ-ONLY; The type of the document.
	Kind *DocumentType

	// READ-ONLY; The source of the document. ENF for Brazil and DRS for rest of the world.
	Source *DocumentSource

	// READ-ONLY; Document URL.
	URL *string
}

// DownloadURL - A secure URL that can be used to download a an entity until the URL expires.
type DownloadURL struct {
	// READ-ONLY; The time in UTC when the download URL will expire.
	ExpiryTime *time.Time

	// READ-ONLY; The URL to the PDF file.
	URL *string
}

// Enrollment - The properties of an enrollment.
type Enrollment struct {
	// The end date of the enrollment.
	EndDate *time.Time

	// The start date of the enrollment.
	StartDate *time.Time

	// READ-ONLY; The billing cycle for the enrollment.
	BillingCycle *string

	// READ-ONLY; The channel type of the enrollment.
	Channel *string

	// READ-ONLY; The country code of the enrollment.
	CountryCode *string

	// READ-ONLY; The billing currency for the enrollment.
	Currency *string

	// READ-ONLY; The language for the enrollment.
	Language *string

	// READ-ONLY; The policies for Enterprise Agreement enrollments.
	Policies *EnrollmentPolicies

	// READ-ONLY; The current status of the enrollment.
	Status *string
}

// EnrollmentAccount - An enrollment account.
type EnrollmentAccount struct {
	// The properties of an enrollment account.
	Properties *EnrollmentAccountProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// EnrollmentAccountContext - The enrollment account context
type EnrollmentAccountContext struct {
	// The cost center associated with the enrollment account.
	CostCenter *string

	// The end date of the enrollment account.
	EndDate *time.Time

	// The ID of the enrollment account.
	EnrollmentAccountName *string

	// The start date of the enrollment account.
	StartDate *time.Time
}

// EnrollmentAccountListResult - Result of listing enrollment accounts.
type EnrollmentAccountListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of enrollment accounts.
	Value []*EnrollmentAccountSummary
}

// EnrollmentAccountProperties - The properties of an enrollment account.
type EnrollmentAccountProperties struct {
	// The name of the enrollment account.
	AccountName *string

	// The owner of the enrollment account.
	AccountOwner *string

	// The enrollment account owner email address.
	AccountOwnerEmail *string

	// The cost center associated with the enrollment account.
	CostCenter *string

	// Associated department. By default this is not populated, unless it's specified in $expand.
	Department *Department

	// The end date of the enrollment account.
	EndDate *time.Time

	// The start date of the enrollment account.
	StartDate *time.Time

	// The status of the enrollment account.
	Status *string
}

// EnrollmentAccountSummary - An enrollment account resource.
type EnrollmentAccountSummary struct {
	// An enrollment account.
	Properties *EnrollmentAccountSummaryProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// EnrollmentAccountSummaryProperties - The properties of the enrollment account.
type EnrollmentAccountSummaryProperties struct {
	// READ-ONLY; The account owner's principal name.
	PrincipalName *string
}

// EnrollmentPolicies - The policies for Enterprise Agreement enrollments.
type EnrollmentPolicies struct {
	// READ-ONLY; The policy that controls whether Account Owners can view charges.
	AccountOwnerViewCharges *bool

	// READ-ONLY; The policy that controls whether Department Administrators can view charges.
	DepartmentAdminViewCharges *bool

	// READ-ONLY; The policy that controls whether Azure marketplace purchases are allowed in the enrollment.
	MarketplaceEnabled *bool

	// READ-ONLY; The policy that controls whether Azure reservation purchases are allowed in the enrollment.
	ReservedInstancesEnabled *bool
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; The sub details of the error.
	Details []*ErrorSubDetailsItem

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails
}

type ErrorSubDetailsItem struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// IndirectRelationshipInfo - The billing profile details of the partner of the customer for an indirect motion.
type IndirectRelationshipInfo struct {
	// The billing account name of the partner or the customer for an indirect motion.
	BillingAccountName *string

	// The billing profile name of the partner or the customer for an indirect motion.
	BillingProfileName *string

	// The display name of the partner or customer for an indirect motion.
	DisplayName *string
}

// Instruction - An instruction.
type Instruction struct {
	// A billing instruction used during invoice generation.
	Properties *InstructionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// InstructionListResult - The list of billing instructions used during invoice generation.
type InstructionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of billing instructions used during invoice generation.
	Value []*Instruction
}

// InstructionProperties - A billing instruction used during invoice generation.
type InstructionProperties struct {
	// REQUIRED; The amount budgeted for this billing instruction.
	Amount *float32

	// REQUIRED; The date this billing instruction is no longer in effect.
	EndDate *time.Time

	// REQUIRED; The date this billing instruction goes into effect.
	StartDate *time.Time

	// The date this billing instruction was created.
	CreationDate *time.Time
}

// Invoice - An invoice.
type Invoice struct {
	// An invoice.
	Properties *InvoiceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// InvoiceListResult - The list of invoices.
type InvoiceListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of invoices.
	Value []*Invoice
}

// InvoiceProperties - The properties of the invoice.
type InvoiceProperties struct {
	// READ-ONLY; The amount due as of now.
	AmountDue *Amount

	// READ-ONLY; The amount of Azure prepayment applied to the charges. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	AzurePrepaymentApplied *Amount

	// READ-ONLY; The total charges for the invoice billing period.
	BilledAmount *Amount

	// READ-ONLY; The Id of the active invoice which is originally billed after this invoice was voided. This field is applicable
	// to the void invoices only.
	BilledDocumentID *string

	// READ-ONLY; The name of the billing profile for which the invoice is generated.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile for which the invoice is generated.
	BillingProfileID *string

	// READ-ONLY; The total refund for returns and cancellations during the invoice billing period. This field is applicable to
	// billing accounts with agreement type Microsoft Customer Agreement.
	CreditAmount *Amount

	// READ-ONLY; The Id of the invoice which got voided and this credit note was issued as a result. This field is applicable
	// to the credit notes only.
	CreditForDocumentID *string

	// READ-ONLY; The type of the document.
	DocumentType *InvoiceDocumentType

	// READ-ONLY; List of documents available to download such as invoice and tax receipt.
	Documents []*Document

	// READ-ONLY; The due date for the invoice.
	DueDate *time.Time

	// READ-ONLY; The amount of free Azure credits applied to the charges. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	FreeAzureCreditApplied *Amount

	// READ-ONLY; The date when the invoice was generated.
	InvoiceDate *time.Time

	// READ-ONLY; The end date of the billing period for which the invoice is generated.
	InvoicePeriodEndDate *time.Time

	// READ-ONLY; The start date of the billing period for which the invoice is generated.
	InvoicePeriodStartDate *time.Time

	// READ-ONLY; Invoice type.
	InvoiceType *InvoiceType

	// READ-ONLY; Specifies if the invoice is generated as part of monthly invoicing cycle or not. This field is applicable to
	// billing accounts with agreement type Microsoft Customer Agreement.
	IsMonthlyInvoice *bool

	// READ-ONLY; List of payments.
	Payments []*PaymentProperties

	// READ-ONLY; An optional purchase order number for the invoice.
	PurchaseOrderNumber *string

	// READ-ONLY; Rebill details for an invoice.
	RebillDetails map[string]*RebillDetails

	// READ-ONLY; The current status of the invoice.
	Status *InvoiceStatus

	// READ-ONLY; The pre-tax amount due. This field is applicable to billing accounts with agreement type Microsoft Customer
	// Agreement.
	SubTotal *Amount

	// READ-ONLY; The ID of the subscription for which the invoice is generated.
	SubscriptionID *string

	// READ-ONLY; The amount of tax charged for the billing period. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	TaxAmount *Amount

	// READ-ONLY; The amount due when the invoice was generated. This field is applicable to billing accounts with agreement type
	// Microsoft Customer Agreement.
	TotalAmount *Amount
}

// InvoiceSection - An invoice section.
type InvoiceSection struct {
	// The properties of an invoice section.
	Properties *InvoiceSectionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// InvoiceSectionCreationRequest - The properties of the invoice section.
type InvoiceSectionCreationRequest struct {
	// The name of the invoice section.
	DisplayName *string
}

// InvoiceSectionListResult - The list of invoice sections.
type InvoiceSectionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of invoice sections.
	Value []*InvoiceSection
}

// InvoiceSectionListWithCreateSubPermissionResult - The list of invoice section properties with create subscription permission.
type InvoiceSectionListWithCreateSubPermissionResult struct {
	// The list of invoice section properties with create subscription permission.
	Value []*InvoiceSectionWithCreateSubPermission

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// InvoiceSectionProperties - The properties of an invoice section.
type InvoiceSectionProperties struct {
	// The name of the invoice section.
	DisplayName *string

	// Dictionary of metadata associated with the invoice section.
	Labels map[string]*string

	// Dictionary of metadata associated with the invoice section. Maximum key/value length supported of 256 characters. Keys/value
	// should not empty value nor null. Keys can not contain < > % & \ ? /
	Tags map[string]*string

	// READ-ONLY; Identifies the state of an invoice section.
	State *InvoiceSectionState

	// READ-ONLY; The system generated unique identifier for an invoice section.
	SystemID *string

	// READ-ONLY; Identifies the cloud environments that are associated with an invoice section. This is a system managed optional
	// field and gets updated as the invoice section gets associated with accounts in various
	// clouds.
	TargetCloud *TargetCloud
}

// InvoiceSectionWithCreateSubPermission - Invoice section properties with create subscription permission.
type InvoiceSectionWithCreateSubPermission struct {
	// Enabled azure plans for the associated billing profile.
	EnabledAzurePlans []*AzurePlan

	// READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string

	// READ-ONLY; The billing profile spending limit.
	BillingProfileSpendingLimit *SpendingLimitForBillingProfile

	// READ-ONLY; The status of the billing profile.
	BillingProfileStatus *BillingProfileStatus

	// READ-ONLY; Reason for the specified billing profile status.
	BillingProfileStatusReasonCode *StatusReasonCodeForBillingProfile

	// READ-ONLY; The system generated unique identifier for a billing profile.
	BillingProfileSystemID *string

	// READ-ONLY; The name of the invoice section.
	InvoiceSectionDisplayName *string

	// READ-ONLY; The ID of the invoice section.
	InvoiceSectionID *string

	// READ-ONLY; The system generated unique identifier for an invoice section.
	InvoiceSectionSystemID *string
}

// InvoiceSectionsOnExpand - The invoice sections associated to the billing profile. By default this is not populated, unless
// it's specified in $expand.
type InvoiceSectionsOnExpand struct {
	// The invoice sections associated to the billing profile.
	Value []*InvoiceSection

	// READ-ONLY; Indicates whether there are more invoice sections than the ones listed in this collection. The collection lists
	// a maximum of 50 invoice sections. To get all invoice sections, use the list invoice
	// sections API.
	HasMoreResults *bool
}

// Operation - A Billing REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Identifies if the operation is a data operation.
	IsDataAction *bool

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of operation.
	Description *string

	// READ-ONLY; Operation type such as read, write and delete.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.Billing.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed such as invoice and billing subscription.
	Resource *string
}

// OperationListResult - The list of billing operations and a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; The list of billing operations supported by the Microsoft.Billing resource provider.
	Value []*Operation
}

// OperationsErrorDetails - The details of the error.
type OperationsErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// OperationsErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason
// is provided in the error message.
type OperationsErrorResponse struct {
	// The details of the error.
	Error *OperationsErrorDetails
}

// Participants - The details about a participant.
type Participants struct {
	// READ-ONLY; The email address of the participant.
	Email *string

	// READ-ONLY; The acceptance status of the participant.
	Status *string

	// READ-ONLY; The date when the status got changed.
	StatusDate *time.Time
}

// PaymentProperties - The properties of a payment.
type PaymentProperties struct {
	// The family of payment method.
	PaymentMethodFamily *PaymentMethodFamily

	// READ-ONLY; The paid amount.
	Amount *Amount

	// READ-ONLY; The date when the payment was made.
	Date *time.Time

	// READ-ONLY; The type of payment method.
	PaymentMethodType *string

	// READ-ONLY; The type of payment.
	PaymentType *string
}

// Period - A billing period resource.
type Period struct {
	// A billing period.
	Properties *PeriodProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PeriodProperties - The properties of the billing period.
type PeriodProperties struct {
	// READ-ONLY; The end of the date range covered by the billing period.
	BillingPeriodEndDate *time.Time

	// READ-ONLY; The start of the date range covered by the billing period.
	BillingPeriodStartDate *time.Time

	// READ-ONLY; Array of invoice ids that associated with.
	InvoiceIDs []*string
}

// PeriodsListResult - Result of listing billing periods. It contains a list of available billing periods in reverse chronological
// order.
type PeriodsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of billing periods.
	Value []*Period
}

// PermissionsListResult - Result of list billingPermissions a caller has on a billing account.
type PermissionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of billingPermissions a caller has on a billing account.
	Value []*PermissionsProperties
}

// PermissionsProperties - The set of allowed action and not allowed actions a caller has on a billing account
type PermissionsProperties struct {
	// READ-ONLY; The set of actions that the caller is allowed to perform.
	Actions []*string

	// READ-ONLY; The set of actions that the caller is not allowed to perform.
	NotActions []*string
}

// Policy - A policy.
type Policy struct {
	// The properties of a policy.
	Properties *PolicyProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PolicyProperties - The properties of a policy.
type PolicyProperties struct {
	// The policy that controls whether Azure marketplace purchases are allowed for a billing profile.
	MarketplacePurchases *MarketplacePurchasesPolicy

	// The policy that controls whether Azure reservation purchases are allowed for a billing profile.
	ReservationPurchases *ReservationPurchasesPolicy

	// The policy that controls whether users with Azure RBAC access to a subscription can view its charges.
	ViewCharges *ViewChargesPolicy
}

// Product - A product.
type Product struct {
	// The properties of a product.
	Properties *ProductProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProductProperties - The properties of a product.
type ProductProperties struct {
	// Indicates whether auto renewal is turned on or off for a product.
	AutoRenew *AutoRenew

	// The frequency at which the product will be billed.
	BillingFrequency *BillingFrequency

	// The current status of the product.
	Status *ProductStatusType

	// READ-ONLY; The availability of the product.
	AvailabilityID *string

	// READ-ONLY; The name of the billing profile to which the product is billed.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile to which the product is billed.
	BillingProfileID *string

	// READ-ONLY; The name of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string

	// READ-ONLY; The ID of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string

	// READ-ONLY; The display name of the product.
	DisplayName *string

	// READ-ONLY; The date when the product will be renewed or canceled.
	EndDate *time.Time

	// READ-ONLY; The name of the invoice section to which the product is billed.
	InvoiceSectionDisplayName *string

	// READ-ONLY; The ID of the invoice section to which the product is billed.
	InvoiceSectionID *string

	// READ-ONLY; The last month charges.
	LastCharge *Amount

	// READ-ONLY; The date of the last charge.
	LastChargeDate *time.Time

	// READ-ONLY; The description of the type of product.
	ProductType *string

	// READ-ONLY; The ID of the type of product.
	ProductTypeID *string

	// READ-ONLY; The date when the product was purchased.
	PurchaseDate *time.Time

	// READ-ONLY; The quantity purchased for the product.
	Quantity *float32

	// READ-ONLY; Reseller for this product.
	Reseller *Reseller

	// READ-ONLY; The sku description of the product.
	SKUDescription *string

	// READ-ONLY; The sku ID of the product.
	SKUID *string

	// READ-ONLY; The id of the tenant in which the product is used.
	TenantID *string
}

// ProductsListResult - The list of products. It contains a list of available product summaries in reverse chronological order
// by purchase date.
type ProductsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of products.
	Value []*Product
}

// Profile - A billing profile.
type Profile struct {
	// The properties of the billing profile.
	Properties *ProfileProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProfileCreationRequest - The request parameters for creating a new billing profile.
type ProfileCreationRequest struct {
	// The address of the individual or organization that is responsible for the billing profile.
	BillTo *AddressDetails

	// The name of the billing profile.
	DisplayName *string

	// Enabled azure plans for the billing profile.
	EnabledAzurePlans []*AzurePlan

	// Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool

	// The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string
}

// ProfileInfo - Details about billing profile associated with agreement and available only for specific agreements.
type ProfileInfo struct {
	// The name of the billing profile
	BillingProfileDisplayName *string

	// The unique identifier for the billing profile.
	BillingProfileID *string

	// Billing account name. This property is available for a specific type of agreement.
	IndirectRelationshipOrganizationName *string
}

// ProfileListResult - The list of billing profiles.
type ProfileListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of billing profiles.
	Value []*Profile
}

// ProfileProperties - The properties of the billing profile.
type ProfileProperties struct {
	// Billing address.
	BillTo *AddressDetails

	// The name of the billing profile.
	DisplayName *string

	// Information about the enabled azure plans.
	EnabledAzurePlans []*AzurePlan

	// Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool

	// The invoice sections associated to the billing profile. By default this is not populated, unless it's specified in $expand.
	InvoiceSections *InvoiceSectionsOnExpand

	// The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string

	// Tags of billing profiles.
	Tags map[string]*string

	// READ-ONLY; Identifies which services and purchases are paid by a billing profile.
	BillingRelationshipType *BillingRelationshipType

	// READ-ONLY; The currency in which the charges for the billing profile are billed.
	Currency *string

	// READ-ONLY; Indicates whether user has read access to the billing profile.
	HasReadAccess *bool

	// READ-ONLY; Identifies the billing profile that is linked to another billing profile in indirect purchase motion.
	IndirectRelationshipInfo *IndirectRelationshipInfo

	// READ-ONLY; The day of the month when the invoice for the billing profile is generated.
	InvoiceDay *int32

	// READ-ONLY; The billing profile spending limit.
	SpendingLimit *SpendingLimit

	// READ-ONLY; The status of the billing profile.
	Status *BillingProfileStatus

	// READ-ONLY; Reason for the specified billing profile status.
	StatusReasonCode *StatusReasonCode

	// READ-ONLY; The system generated unique identifier for a billing profile.
	SystemID *string

	// READ-ONLY; Identifies the cloud environments that are associated with a billing profile. This is a system managed optional
	// field and gets updated as the billing profile gets associated with accounts in various
	// clouds.
	TargetClouds []*TargetCloud
}

// ProfilesOnExpand - The billing profiles associated with the billing account. By default this is not populated, unless it's
// specified in $expand.
type ProfilesOnExpand struct {
	// The billing profiles associated with the billing account.
	Value []*Profile

	// READ-ONLY; Indicates whether there are more billing profiles than the ones listed in this collection. The collection lists
	// a maximum of 50 billing profiles. To get all billing profiles, use the list billing
	// profiles API.
	HasMoreResults *bool
}

// Property - A billing property.
type Property struct {
	// A billing property.
	Properties *PropertyProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PropertyProperties - The billing property.
type PropertyProperties struct {
	// The cost center applied to the subscription.
	CostCenter *string

	// READ-ONLY; The email address on which the account admin gets all Azure notifications.
	AccountAdminNotificationEmailAddress *string

	// READ-ONLY; The name of the billing account to which the subscription is billed.
	BillingAccountDisplayName *string

	// READ-ONLY; The ID of the billing account to which the subscription is billed.
	BillingAccountID *string

	// READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string

	// READ-ONLY; The billing profile spending limit.
	BillingProfileSpendingLimit *BillingProfileSpendingLimit

	// READ-ONLY; The status of the billing profile.
	BillingProfileStatus *BillingProfileStatus

	// READ-ONLY; Reason for the specified billing profile status.
	BillingProfileStatusReasonCode *BillingProfileStatusReasonCode

	// READ-ONLY; The Azure AD tenant ID of the billing account for the subscription.
	BillingTenantID *string

	// READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string

	// READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string

	// READ-ONLY; Indicates whether user is the account admin.
	IsAccountAdmin *bool

	// READ-ONLY; The product ID of the Azure plan.
	ProductID *string

	// READ-ONLY; The product name of the Azure plan.
	ProductName *string

	// READ-ONLY; The sku description of the Azure plan for the subscription.
	SKUDescription *string

	// READ-ONLY; The sku ID of the Azure plan for the subscription.
	SKUID *string
}

// RebillDetails - The rebill details of an invoice.
type RebillDetails struct {
	// READ-ONLY; The ID of credit note.
	CreditNoteDocumentID *string

	// READ-ONLY; The ID of invoice.
	InvoiceDocumentID *string

	// READ-ONLY; Rebill details for an invoice.
	RebillDetails map[string]*RebillDetails
}

// Reseller - Details of the reseller.
type Reseller struct {
	// READ-ONLY; The name of the reseller.
	Description *string

	// READ-ONLY; The MPN ID of the reseller.
	ResellerID *string
}

// Reservation - The definition of the reservation.
type Reservation struct {
	// The properties associated to this reservation
	Properties *ReservationProperty

	// The sku information associated to this reservation
	SKU *ReservationSKUProperty

	// READ-ONLY; The id of the reservation.
	ID *string

	// READ-ONLY; The location of the reservation.
	Location *string

	// READ-ONLY; The name of the reservation.
	Name *string

	// READ-ONLY; The type of the reservation.
	Type *string
}

// ReservationProperty - The property of reservation object.
type ReservationProperty struct {
	// The array of applied scopes of a reservation. Will be null if the reservation is in Shared scope
	AppliedScopes []*string

	// READ-ONLY; The applied scope type of the reservation.
	AppliedScopeType *string

	// READ-ONLY; The display name of the reservation
	DisplayName *string

	// READ-ONLY; The provisioning state of the reservation for display, e.g. Succeeded
	DisplayProvisioningState *string

	// READ-ONLY; The effective date time of the reservation
	EffectiveDateTime *string

	// READ-ONLY; The expiry date of the reservation
	ExpiryDate *string

	// READ-ONLY; The provisioning state of the reservation, e.g. Succeeded
	ProvisioningState *string

	// READ-ONLY; The provisioning state of the reservation, e.g. Succeeded
	ProvisioningSubState *string

	// READ-ONLY; The number of the reservation.
	Quantity *float32

	// READ-ONLY; The renew state of the reservation
	Renew *bool

	// READ-ONLY; The renew source of the reservation
	RenewSource *string

	// READ-ONLY; The reserved source type of the reservation, e.g. virtual machine.
	ReservedResourceType *string

	// READ-ONLY; The sku description of the reservation
	SKUDescription *string

	// READ-ONLY; The term of the reservation, e.g. P1Y
	Term *string

	// READ-ONLY; The applied scope type of the reservation for display, e.g. Shared
	UserFriendlyAppliedScopeType *string

	// READ-ONLY; The renew state of the reservation for display, e.g. On
	UserFriendlyRenewState *string

	// READ-ONLY; Reservation utilization
	Utilization *ReservationPropertyUtilization
}

// ReservationPropertyUtilization - Reservation utilization
type ReservationPropertyUtilization struct {
	// The array of aggregates of a reservation's utilization
	Aggregates []*ReservationUtilizationAggregates

	// READ-ONLY; The number of days trend for a reservation
	Trend *string
}

// ReservationSKUProperty - The property of reservation sku object.
type ReservationSKUProperty struct {
	// READ-ONLY; The name of the reservation sku.
	Name *string
}

// ReservationSummary - The roll up count summary of reservations in each state
type ReservationSummary struct {
	// READ-ONLY; The number of reservation in Cancelled state
	CancelledCount *float32

	// READ-ONLY; The number of reservation in Expired state
	ExpiredCount *float32

	// READ-ONLY; The number of reservation in Expiring state
	ExpiringCount *float32

	// READ-ONLY; The number of reservation in Failed state
	FailedCount *float32

	// READ-ONLY; The number of reservation in Pending state
	PendingCount *float32

	// READ-ONLY; The number of reservation in Succeeded state
	SucceededCount *float32
}

// ReservationUtilizationAggregates - The aggregate values of reservation utilization
type ReservationUtilizationAggregates struct {
	// READ-ONLY; The grain of the aggregate
	Grain *float32

	// READ-ONLY; The grain unit of the aggregate
	GrainUnit *string

	// READ-ONLY; The aggregate value
	Value *float32

	// READ-ONLY; The aggregate value unit
	ValueUnit *string
}

// ReservationsListResult - The list of reservations and summary of roll out count of reservations in each state.
type ReservationsListResult struct {
	// The roll out count summary of the reservations
	Summary *ReservationSummary

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of reservations.
	Value []*Reservation
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RoleAssignment - The role assignment
type RoleAssignment struct {
	// The properties of the role assignment.
	Properties *RoleAssignmentProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RoleAssignmentListResult - The list of role assignments.
type RoleAssignmentListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of role assignments.
	Value []*RoleAssignment
}

// RoleAssignmentProperties - The properties of the role assignment.
type RoleAssignmentProperties struct {
	// The principal id of the user to whom the role was assigned.
	PrincipalID *string

	// The principal tenant id of the user to whom the role was assigned.
	PrincipalTenantID *string

	// The ID of the role definition.
	RoleDefinitionID *string

	// The authentication type.
	UserAuthenticationType *string

	// The email address of the user.
	UserEmailAddress *string

	// READ-ONLY; The principal Id of the user who created the role assignment.
	CreatedByPrincipalID *string

	// READ-ONLY; The tenant Id of the user who created the role assignment.
	CreatedByPrincipalTenantID *string

	// READ-ONLY; The email address of the user who created the role assignment.
	CreatedByUserEmailAddress *string

	// READ-ONLY; The date the role assignment was created.
	CreatedOn *string

	// READ-ONLY; The scope at which the role was assigned.
	Scope *string
}

// RoleDefinition - The properties of a role definition.
type RoleDefinition struct {
	// The properties of the a role definition.
	Properties *RoleDefinitionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RoleDefinitionListResult - The list of role definitions.
type RoleDefinitionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The role definitions.
	Value []*RoleDefinition
}

// RoleDefinitionProperties - The properties of the a role definition.
type RoleDefinitionProperties struct {
	// The billingPermissions the role has
	Permissions []*PermissionsProperties

	// READ-ONLY; The role description
	Description *string

	// READ-ONLY; The name of the role
	RoleName *string
}

// Subscription - A billing subscription.
type Subscription struct {
	// The billing properties of a subscription.
	Properties *SubscriptionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SubscriptionProperties - The billing properties of a subscription.
type SubscriptionProperties struct {
	// The cost center applied to the subscription.
	CostCenter *string

	// The sku ID of the Azure plan for the subscription.
	SKUID *string

	// The current billing status of the subscription.
	SubscriptionBillingStatus *BillingSubscriptionStatusType

	// READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string

	// READ-ONLY; The name of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string

	// READ-ONLY; The ID of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string

	// READ-ONLY; The name of the subscription.
	DisplayName *string

	// READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string

	// READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string

	// READ-ONLY; The last month charges.
	LastMonthCharges *Amount

	// READ-ONLY; The current month to date charges.
	MonthToDateCharges *Amount

	// READ-ONLY; Reseller for this subscription.
	Reseller *Reseller

	// READ-ONLY; The sku description of the Azure plan for the subscription.
	SKUDescription *string

	// READ-ONLY; The ID of the subscription.
	SubscriptionID *string

	// READ-ONLY; The suspension reason for a subscription. Applies only to subscriptions in Microsoft Online Services Program
	// billing accounts.
	SuspensionReasons []*string
}

// SubscriptionsListResult - The list of billing subscriptions.
type SubscriptionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of billing subscriptions.
	Value []*Subscription
}

// Transaction - A transaction.
type Transaction struct {
	// The properties of a transaction.
	Properties *TransactionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// TransactionListResult - The list of transactions.
type TransactionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of records.
	TotalCount *int32

	// READ-ONLY; The list of transactions.
	Value []*Transaction
}

// TransactionProperties - The properties of a transaction.
type TransactionProperties struct {
	// The kind of transaction. Options are all or reservation.
	Kind *TransactionTypeKind

	// The type of transaction.
	TransactionType *ReservationType

	// READ-ONLY; The amount of any Azure credits automatically applied to this transaction.
	AzureCreditApplied *Amount

	// READ-ONLY; The type of azure plan of the subscription that was used for the transaction.
	AzurePlan *string

	// READ-ONLY; The ISO 4217 code for the currency in which this transaction is billed.
	BillingCurrency *string

	// READ-ONLY; The name of the billing profile which will be billed for the transaction.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID of the billing profile which will be billed for the transaction.
	BillingProfileID *string

	// READ-ONLY; The name of the customer for which the transaction took place. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string

	// READ-ONLY; The ID of the customer for which the transaction took place. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string

	// READ-ONLY; The date of transaction.
	Date *time.Time

	// READ-ONLY; The percentage discount, if any, applied to this transaction.
	Discount *float32

	// READ-ONLY; The price of the product after applying any discounts.
	EffectivePrice *Amount

	// READ-ONLY; The exchange rate used to convert charged amount to billing currency, if applicable.
	ExchangeRate *float32

	// READ-ONLY; Invoice on which the transaction was billed or 'pending' if the transaction is not billed.
	Invoice *string

	// READ-ONLY; The ID of the invoice on which the transaction was billed. This field is only applicable for transactions which
	// are billed.
	InvoiceID *string

	// READ-ONLY; The name of the invoice section which will be billed for the transaction.
	InvoiceSectionDisplayName *string

	// READ-ONLY; The ID of the invoice section which will be billed for the transaction.
	InvoiceSectionID *string

	// READ-ONLY; The retail price of the product.
	MarketPrice *Amount

	// READ-ONLY; The order ID of the reservation. The field is only applicable for transaction of kind reservation.
	OrderID *string

	// READ-ONLY; The name of the reservation order. The field is only applicable for transactions of kind reservation.
	OrderName *string

	// READ-ONLY; The ISO 4217 code for the currency in which the product is priced.
	PricingCurrency *string

	// READ-ONLY; The description of the product for which the transaction took place.
	ProductDescription *string

	// READ-ONLY; The family of the product for which the transaction took place.
	ProductFamily *string

	// READ-ONLY; The type of the product for which the transaction took place.
	ProductType *string

	// READ-ONLY; The ID of the product type for which the transaction took place.
	ProductTypeID *string

	// READ-ONLY; The quantity purchased in the transaction.
	Quantity *int32

	// READ-ONLY; The end date of the product term, or the end date of the month in which usage ended.
	ServicePeriodEndDate *time.Time

	// READ-ONLY; The date of the purchase of the product, or the start date of the month in which usage started.
	ServicePeriodStartDate *time.Time

	// READ-ONLY; The pre-tax charged amount for the transaction.
	SubTotal *Amount

	// READ-ONLY; The ID of the subscription that was used for the transaction. The field is only applicable for transaction of
	// kind reservation.
	SubscriptionID *string

	// READ-ONLY; The name of the subscription that was used for the transaction. The field is only applicable for transaction
	// of kind reservation.
	SubscriptionName *string

	// READ-ONLY; The tax amount applied to the transaction.
	Tax *Amount

	// READ-ONLY; The charge associated with the transaction.
	TransactionAmount *Amount

	// READ-ONLY; The unit of measure used to bill for the product. For example, compute services are billed per hour.
	UnitOfMeasure *string

	// READ-ONLY; The description for the unit of measure for a given product.
	UnitType *string

	// READ-ONLY; The number of units used for a given product.
	Units *float32
}

// TransferBillingSubscriptionRequestProperties - Request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequestProperties struct {
	// REQUIRED; The destination invoice section id.
	DestinationInvoiceSectionID *string
}

// TransferProductRequestProperties - The properties of the product to initiate a transfer.
type TransferProductRequestProperties struct {
	// The destination invoice section id.
	DestinationInvoiceSectionID *string
}

// ValidateAddressResponse - Result of the address validation
type ValidateAddressResponse struct {
	// status of the address validation.
	Status *AddressValidationStatus

	// The list of suggested addresses.
	SuggestedAddresses []*AddressDetails

	// Validation error message.
	ValidationMessage *string
}

// ValidateProductTransferEligibilityError - Error details of the product transfer eligibility validation.
type ValidateProductTransferEligibilityError struct {
	// Error code for the product transfer validation.
	Code *ProductTransferValidationErrorCode

	// Detailed error message explaining the error.
	Details *string

	// The error message.
	Message *string
}

// ValidateProductTransferEligibilityResult - Result of the product transfer eligibility validation.
type ValidateProductTransferEligibilityResult struct {
	// Validation error details.
	ErrorDetails *ValidateProductTransferEligibilityError

	// READ-ONLY; Specifies whether the transfer is eligible or not.
	IsMoveEligible *bool
}

// ValidateSubscriptionTransferEligibilityError - Error details of the transfer eligibility validation
type ValidateSubscriptionTransferEligibilityError struct {
	// Error code for the product transfer validation.
	Code *SubscriptionTransferValidationErrorCode

	// Detailed error message explaining the error.
	Details *string

	// The error message.
	Message *string
}

// ValidateSubscriptionTransferEligibilityResult - Result of the transfer eligibility validation.
type ValidateSubscriptionTransferEligibilityResult struct {
	// Validation error details.
	ErrorDetails *ValidateSubscriptionTransferEligibilityError

	// READ-ONLY; Specifies whether the subscription is eligible to be transferred.
	IsMoveEligible *bool
}
