//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Account.
func (a *Account) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountListResult.
func (a AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountListResult.
func (a *AccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountProperties.
func (a AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountStatus", a.AccountStatus)
	populate(objectMap, "accountType", a.AccountType)
	populate(objectMap, "agreementType", a.AgreementType)
	populate(objectMap, "billingProfiles", a.BillingProfiles)
	populate(objectMap, "departments", a.Departments)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "enrollmentAccounts", a.EnrollmentAccounts)
	populate(objectMap, "enrollmentDetails", a.EnrollmentDetails)
	populate(objectMap, "hasReadAccess", a.HasReadAccess)
	populate(objectMap, "notificationEmailAddress", a.NotificationEmailAddress)
	populate(objectMap, "soldTo", a.SoldTo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountProperties.
func (a *AccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountStatus":
			err = unpopulate(val, "AccountStatus", &a.AccountStatus)
			delete(rawMsg, key)
		case "accountType":
			err = unpopulate(val, "AccountType", &a.AccountType)
			delete(rawMsg, key)
		case "agreementType":
			err = unpopulate(val, "AgreementType", &a.AgreementType)
			delete(rawMsg, key)
		case "billingProfiles":
			err = unpopulate(val, "BillingProfiles", &a.BillingProfiles)
			delete(rawMsg, key)
		case "departments":
			err = unpopulate(val, "Departments", &a.Departments)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "enrollmentAccounts":
			err = unpopulate(val, "EnrollmentAccounts", &a.EnrollmentAccounts)
			delete(rawMsg, key)
		case "enrollmentDetails":
			err = unpopulate(val, "EnrollmentDetails", &a.EnrollmentDetails)
			delete(rawMsg, key)
		case "hasReadAccess":
			err = unpopulate(val, "HasReadAccess", &a.HasReadAccess)
			delete(rawMsg, key)
		case "notificationEmailAddress":
			err = unpopulate(val, "NotificationEmailAddress", &a.NotificationEmailAddress)
			delete(rawMsg, key)
		case "soldTo":
			err = unpopulate(val, "SoldTo", &a.SoldTo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateRequest.
func (a AccountUpdateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateRequest.
func (a *AccountUpdateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressDetails.
func (a AddressDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressLine1", a.AddressLine1)
	populate(objectMap, "addressLine2", a.AddressLine2)
	populate(objectMap, "addressLine3", a.AddressLine3)
	populate(objectMap, "city", a.City)
	populate(objectMap, "companyName", a.CompanyName)
	populate(objectMap, "country", a.Country)
	populate(objectMap, "district", a.District)
	populate(objectMap, "email", a.Email)
	populate(objectMap, "firstName", a.FirstName)
	populate(objectMap, "lastName", a.LastName)
	populate(objectMap, "middleName", a.MiddleName)
	populate(objectMap, "phoneNumber", a.PhoneNumber)
	populate(objectMap, "postalCode", a.PostalCode)
	populate(objectMap, "region", a.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressDetails.
func (a *AddressDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressLine1":
			err = unpopulate(val, "AddressLine1", &a.AddressLine1)
			delete(rawMsg, key)
		case "addressLine2":
			err = unpopulate(val, "AddressLine2", &a.AddressLine2)
			delete(rawMsg, key)
		case "addressLine3":
			err = unpopulate(val, "AddressLine3", &a.AddressLine3)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "companyName":
			err = unpopulate(val, "CompanyName", &a.CompanyName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &a.Country)
			delete(rawMsg, key)
		case "district":
			err = unpopulate(val, "District", &a.District)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &a.Email)
			delete(rawMsg, key)
		case "firstName":
			err = unpopulate(val, "FirstName", &a.FirstName)
			delete(rawMsg, key)
		case "lastName":
			err = unpopulate(val, "LastName", &a.LastName)
			delete(rawMsg, key)
		case "middleName":
			err = unpopulate(val, "MiddleName", &a.MiddleName)
			delete(rawMsg, key)
		case "phoneNumber":
			err = unpopulate(val, "PhoneNumber", &a.PhoneNumber)
			delete(rawMsg, key)
		case "postalCode":
			err = unpopulate(val, "PostalCode", &a.PostalCode)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &a.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Agreement.
func (a Agreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Agreement.
func (a *Agreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgreementListResult.
func (a AgreementListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgreementListResult.
func (a *AgreementListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgreementProperties.
func (a AgreementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptanceMode", a.AcceptanceMode)
	populate(objectMap, "agreementLink", a.AgreementLink)
	populate(objectMap, "billingProfileInfo", a.BillingProfileInfo)
	populate(objectMap, "category", a.Category)
	populateDateTimeRFC3339(objectMap, "effectiveDate", a.EffectiveDate)
	populateDateTimeRFC3339(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "participants", a.Participants)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgreementProperties.
func (a *AgreementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptanceMode":
			err = unpopulate(val, "AcceptanceMode", &a.AcceptanceMode)
			delete(rawMsg, key)
		case "agreementLink":
			err = unpopulate(val, "AgreementLink", &a.AgreementLink)
			delete(rawMsg, key)
		case "billingProfileInfo":
			err = unpopulate(val, "BillingProfileInfo", &a.BillingProfileInfo)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "effectiveDate":
			err = unpopulateDateTimeRFC3339(val, "EffectiveDate", &a.EffectiveDate)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "participants":
			err = unpopulate(val, "Participants", &a.Participants)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Amount.
func (a Amount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currency", a.Currency)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Amount.
func (a *Amount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currency":
			err = unpopulate(val, "Currency", &a.Currency)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableBalance.
func (a AvailableBalance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableBalance.
func (a *AvailableBalance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableBalanceProperties.
func (a AvailableBalanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", a.Amount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableBalanceProperties.
func (a *AvailableBalanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &a.Amount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePlan.
func (a AzurePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skuDescription", a.SKUDescription)
	populate(objectMap, "skuId", a.SKUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePlan.
func (a *AzurePlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &a.SKUDescription)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &a.SKUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Customer.
func (c Customer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Customer.
func (c *Customer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerListResult.
func (c CustomerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "totalCount", c.TotalCount)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerListResult.
func (c *CustomerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &c.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerPolicy.
func (c CustomerPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerPolicy.
func (c *CustomerPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerPolicyProperties.
func (c CustomerPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "viewCharges", c.ViewCharges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerPolicyProperties.
func (c *CustomerPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "viewCharges":
			err = unpopulate(val, "ViewCharges", &c.ViewCharges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerProperties.
func (c CustomerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfileDisplayName", c.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", c.BillingProfileID)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "enabledAzurePlans", c.EnabledAzurePlans)
	populate(objectMap, "resellers", c.Resellers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerProperties.
func (c *CustomerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &c.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &c.BillingProfileID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "enabledAzurePlans":
			err = unpopulate(val, "EnabledAzurePlans", &c.EnabledAzurePlans)
			delete(rawMsg, key)
		case "resellers":
			err = unpopulate(val, "Resellers", &c.Resellers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Department.
func (d Department) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Department.
func (d *Department) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DepartmentProperties.
func (d DepartmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costCenter", d.CostCenter)
	populate(objectMap, "departmentName", d.DepartmentName)
	populate(objectMap, "enrollmentAccounts", d.EnrollmentAccounts)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DepartmentProperties.
func (d *DepartmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costCenter":
			err = unpopulate(val, "CostCenter", &d.CostCenter)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &d.DepartmentName)
			delete(rawMsg, key)
		case "enrollmentAccounts":
			err = unpopulate(val, "EnrollmentAccounts", &d.EnrollmentAccounts)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Document.
func (d Document) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "source", d.Source)
	populate(objectMap, "url", d.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Document.
func (d *Document) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &d.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DownloadURL.
func (d DownloadURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiryTime", d.ExpiryTime)
	populate(objectMap, "url", d.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURL.
func (d *DownloadURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryTime", &d.ExpiryTime)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &d.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Enrollment.
func (e Enrollment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCycle", e.BillingCycle)
	populate(objectMap, "channel", e.Channel)
	populate(objectMap, "countryCode", e.CountryCode)
	populate(objectMap, "currency", e.Currency)
	populateDateTimeRFC3339(objectMap, "endDate", e.EndDate)
	populate(objectMap, "language", e.Language)
	populate(objectMap, "policies", e.Policies)
	populateDateTimeRFC3339(objectMap, "startDate", e.StartDate)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Enrollment.
func (e *Enrollment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCycle":
			err = unpopulate(val, "BillingCycle", &e.BillingCycle)
			delete(rawMsg, key)
		case "channel":
			err = unpopulate(val, "Channel", &e.Channel)
			delete(rawMsg, key)
		case "countryCode":
			err = unpopulate(val, "CountryCode", &e.CountryCode)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &e.Currency)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &e.EndDate)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &e.Language)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &e.Policies)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &e.StartDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccount.
func (e EnrollmentAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccount.
func (e *EnrollmentAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccountContext.
func (e EnrollmentAccountContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costCenter", e.CostCenter)
	populateDateTimeRFC3339(objectMap, "endDate", e.EndDate)
	populate(objectMap, "enrollmentAccountName", e.EnrollmentAccountName)
	populateDateTimeRFC3339(objectMap, "startDate", e.StartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccountContext.
func (e *EnrollmentAccountContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costCenter":
			err = unpopulate(val, "CostCenter", &e.CostCenter)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &e.EndDate)
			delete(rawMsg, key)
		case "enrollmentAccountName":
			err = unpopulate(val, "EnrollmentAccountName", &e.EnrollmentAccountName)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &e.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccountListResult.
func (e EnrollmentAccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccountListResult.
func (e *EnrollmentAccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccountProperties.
func (e EnrollmentAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", e.AccountName)
	populate(objectMap, "accountOwner", e.AccountOwner)
	populate(objectMap, "accountOwnerEmail", e.AccountOwnerEmail)
	populate(objectMap, "costCenter", e.CostCenter)
	populate(objectMap, "department", e.Department)
	populateDateTimeRFC3339(objectMap, "endDate", e.EndDate)
	populateDateTimeRFC3339(objectMap, "startDate", e.StartDate)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccountProperties.
func (e *EnrollmentAccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &e.AccountName)
			delete(rawMsg, key)
		case "accountOwner":
			err = unpopulate(val, "AccountOwner", &e.AccountOwner)
			delete(rawMsg, key)
		case "accountOwnerEmail":
			err = unpopulate(val, "AccountOwnerEmail", &e.AccountOwnerEmail)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &e.CostCenter)
			delete(rawMsg, key)
		case "department":
			err = unpopulate(val, "Department", &e.Department)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &e.EndDate)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &e.StartDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccountSummary.
func (e EnrollmentAccountSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccountSummary.
func (e *EnrollmentAccountSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentAccountSummaryProperties.
func (e EnrollmentAccountSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalName", e.PrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentAccountSummaryProperties.
func (e *EnrollmentAccountSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalName":
			err = unpopulate(val, "PrincipalName", &e.PrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrollmentPolicies.
func (e EnrollmentPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountOwnerViewCharges", e.AccountOwnerViewCharges)
	populate(objectMap, "departmentAdminViewCharges", e.DepartmentAdminViewCharges)
	populate(objectMap, "marketplaceEnabled", e.MarketplaceEnabled)
	populate(objectMap, "reservedInstancesEnabled", e.ReservedInstancesEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrollmentPolicies.
func (e *EnrollmentPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountOwnerViewCharges":
			err = unpopulate(val, "AccountOwnerViewCharges", &e.AccountOwnerViewCharges)
			delete(rawMsg, key)
		case "departmentAdminViewCharges":
			err = unpopulate(val, "DepartmentAdminViewCharges", &e.DepartmentAdminViewCharges)
			delete(rawMsg, key)
		case "marketplaceEnabled":
			err = unpopulate(val, "MarketplaceEnabled", &e.MarketplaceEnabled)
			delete(rawMsg, key)
		case "reservedInstancesEnabled":
			err = unpopulate(val, "ReservedInstancesEnabled", &e.ReservedInstancesEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorSubDetailsItem.
func (e ErrorSubDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorSubDetailsItem.
func (e *ErrorSubDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IndirectRelationshipInfo.
func (i IndirectRelationshipInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingAccountName", i.BillingAccountName)
	populate(objectMap, "billingProfileName", i.BillingProfileName)
	populate(objectMap, "displayName", i.DisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IndirectRelationshipInfo.
func (i *IndirectRelationshipInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingAccountName":
			err = unpopulate(val, "BillingAccountName", &i.BillingAccountName)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &i.BillingProfileName)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Instruction.
func (i Instruction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Instruction.
func (i *Instruction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstructionListResult.
func (i InstructionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstructionListResult.
func (i *InstructionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstructionProperties.
func (i InstructionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", i.Amount)
	populateDateTimeRFC3339(objectMap, "creationDate", i.CreationDate)
	populateDateTimeRFC3339(objectMap, "endDate", i.EndDate)
	populateDateTimeRFC3339(objectMap, "startDate", i.StartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstructionProperties.
func (i *InstructionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &i.Amount)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &i.CreationDate)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &i.EndDate)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &i.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Invoice.
func (i Invoice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Invoice.
func (i *Invoice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceListResult.
func (i InvoiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "totalCount", i.TotalCount)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceListResult.
func (i *InvoiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &i.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceProperties.
func (i InvoiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amountDue", i.AmountDue)
	populate(objectMap, "azurePrepaymentApplied", i.AzurePrepaymentApplied)
	populate(objectMap, "billedAmount", i.BilledAmount)
	populate(objectMap, "billedDocumentId", i.BilledDocumentID)
	populate(objectMap, "billingProfileDisplayName", i.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", i.BillingProfileID)
	populate(objectMap, "creditAmount", i.CreditAmount)
	populate(objectMap, "creditForDocumentId", i.CreditForDocumentID)
	populate(objectMap, "documentType", i.DocumentType)
	populate(objectMap, "documents", i.Documents)
	populateDateTimeRFC3339(objectMap, "dueDate", i.DueDate)
	populate(objectMap, "freeAzureCreditApplied", i.FreeAzureCreditApplied)
	populateDateTimeRFC3339(objectMap, "invoiceDate", i.InvoiceDate)
	populateDateTimeRFC3339(objectMap, "invoicePeriodEndDate", i.InvoicePeriodEndDate)
	populateDateTimeRFC3339(objectMap, "invoicePeriodStartDate", i.InvoicePeriodStartDate)
	populate(objectMap, "invoiceType", i.InvoiceType)
	populate(objectMap, "isMonthlyInvoice", i.IsMonthlyInvoice)
	populate(objectMap, "payments", i.Payments)
	populate(objectMap, "purchaseOrderNumber", i.PurchaseOrderNumber)
	populate(objectMap, "rebillDetails", i.RebillDetails)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "subTotal", i.SubTotal)
	populate(objectMap, "subscriptionId", i.SubscriptionID)
	populate(objectMap, "taxAmount", i.TaxAmount)
	populate(objectMap, "totalAmount", i.TotalAmount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceProperties.
func (i *InvoiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amountDue":
			err = unpopulate(val, "AmountDue", &i.AmountDue)
			delete(rawMsg, key)
		case "azurePrepaymentApplied":
			err = unpopulate(val, "AzurePrepaymentApplied", &i.AzurePrepaymentApplied)
			delete(rawMsg, key)
		case "billedAmount":
			err = unpopulate(val, "BilledAmount", &i.BilledAmount)
			delete(rawMsg, key)
		case "billedDocumentId":
			err = unpopulate(val, "BilledDocumentID", &i.BilledDocumentID)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &i.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &i.BillingProfileID)
			delete(rawMsg, key)
		case "creditAmount":
			err = unpopulate(val, "CreditAmount", &i.CreditAmount)
			delete(rawMsg, key)
		case "creditForDocumentId":
			err = unpopulate(val, "CreditForDocumentID", &i.CreditForDocumentID)
			delete(rawMsg, key)
		case "documentType":
			err = unpopulate(val, "DocumentType", &i.DocumentType)
			delete(rawMsg, key)
		case "documents":
			err = unpopulate(val, "Documents", &i.Documents)
			delete(rawMsg, key)
		case "dueDate":
			err = unpopulateDateTimeRFC3339(val, "DueDate", &i.DueDate)
			delete(rawMsg, key)
		case "freeAzureCreditApplied":
			err = unpopulate(val, "FreeAzureCreditApplied", &i.FreeAzureCreditApplied)
			delete(rawMsg, key)
		case "invoiceDate":
			err = unpopulateDateTimeRFC3339(val, "InvoiceDate", &i.InvoiceDate)
			delete(rawMsg, key)
		case "invoicePeriodEndDate":
			err = unpopulateDateTimeRFC3339(val, "InvoicePeriodEndDate", &i.InvoicePeriodEndDate)
			delete(rawMsg, key)
		case "invoicePeriodStartDate":
			err = unpopulateDateTimeRFC3339(val, "InvoicePeriodStartDate", &i.InvoicePeriodStartDate)
			delete(rawMsg, key)
		case "invoiceType":
			err = unpopulate(val, "InvoiceType", &i.InvoiceType)
			delete(rawMsg, key)
		case "isMonthlyInvoice":
			err = unpopulate(val, "IsMonthlyInvoice", &i.IsMonthlyInvoice)
			delete(rawMsg, key)
		case "payments":
			err = unpopulate(val, "Payments", &i.Payments)
			delete(rawMsg, key)
		case "purchaseOrderNumber":
			err = unpopulate(val, "PurchaseOrderNumber", &i.PurchaseOrderNumber)
			delete(rawMsg, key)
		case "rebillDetails":
			err = unpopulate(val, "RebillDetails", &i.RebillDetails)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		case "subTotal":
			err = unpopulate(val, "SubTotal", &i.SubTotal)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &i.SubscriptionID)
			delete(rawMsg, key)
		case "taxAmount":
			err = unpopulate(val, "TaxAmount", &i.TaxAmount)
			delete(rawMsg, key)
		case "totalAmount":
			err = unpopulate(val, "TotalAmount", &i.TotalAmount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSection.
func (i InvoiceSection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSection.
func (i *InvoiceSection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionCreationRequest.
func (i InvoiceSectionCreationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", i.DisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionCreationRequest.
func (i *InvoiceSectionCreationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionListResult.
func (i InvoiceSectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "totalCount", i.TotalCount)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionListResult.
func (i *InvoiceSectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &i.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionListWithCreateSubPermissionResult.
func (i InvoiceSectionListWithCreateSubPermissionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionListWithCreateSubPermissionResult.
func (i *InvoiceSectionListWithCreateSubPermissionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionProperties.
func (i InvoiceSectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", i.DisplayName)
	populate(objectMap, "labels", i.Labels)
	populate(objectMap, "state", i.State)
	populate(objectMap, "systemId", i.SystemID)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "targetCloud", i.TargetCloud)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionProperties.
func (i *InvoiceSectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &i.Labels)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "systemId":
			err = unpopulate(val, "SystemID", &i.SystemID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "targetCloud":
			err = unpopulate(val, "TargetCloud", &i.TargetCloud)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionWithCreateSubPermission.
func (i InvoiceSectionWithCreateSubPermission) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfileDisplayName", i.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", i.BillingProfileID)
	populate(objectMap, "billingProfileSpendingLimit", i.BillingProfileSpendingLimit)
	populate(objectMap, "billingProfileStatus", i.BillingProfileStatus)
	populate(objectMap, "billingProfileStatusReasonCode", i.BillingProfileStatusReasonCode)
	populate(objectMap, "billingProfileSystemId", i.BillingProfileSystemID)
	populate(objectMap, "enabledAzurePlans", i.EnabledAzurePlans)
	populate(objectMap, "invoiceSectionDisplayName", i.InvoiceSectionDisplayName)
	populate(objectMap, "invoiceSectionId", i.InvoiceSectionID)
	populate(objectMap, "invoiceSectionSystemId", i.InvoiceSectionSystemID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionWithCreateSubPermission.
func (i *InvoiceSectionWithCreateSubPermission) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &i.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &i.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileSpendingLimit":
			err = unpopulate(val, "BillingProfileSpendingLimit", &i.BillingProfileSpendingLimit)
			delete(rawMsg, key)
		case "billingProfileStatus":
			err = unpopulate(val, "BillingProfileStatus", &i.BillingProfileStatus)
			delete(rawMsg, key)
		case "billingProfileStatusReasonCode":
			err = unpopulate(val, "BillingProfileStatusReasonCode", &i.BillingProfileStatusReasonCode)
			delete(rawMsg, key)
		case "billingProfileSystemId":
			err = unpopulate(val, "BillingProfileSystemID", &i.BillingProfileSystemID)
			delete(rawMsg, key)
		case "enabledAzurePlans":
			err = unpopulate(val, "EnabledAzurePlans", &i.EnabledAzurePlans)
			delete(rawMsg, key)
		case "invoiceSectionDisplayName":
			err = unpopulate(val, "InvoiceSectionDisplayName", &i.InvoiceSectionDisplayName)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &i.InvoiceSectionID)
			delete(rawMsg, key)
		case "invoiceSectionSystemId":
			err = unpopulate(val, "InvoiceSectionSystemID", &i.InvoiceSectionSystemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InvoiceSectionsOnExpand.
func (i InvoiceSectionsOnExpand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hasMoreResults", i.HasMoreResults)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InvoiceSectionsOnExpand.
func (i *InvoiceSectionsOnExpand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hasMoreResults":
			err = unpopulate(val, "HasMoreResults", &i.HasMoreResults)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsErrorDetails.
func (o OperationsErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "message", o.Message)
	populate(objectMap, "target", o.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsErrorDetails.
func (o *OperationsErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &o.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsErrorResponse.
func (o OperationsErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", o.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsErrorResponse.
func (o *OperationsErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Participants.
func (p Participants) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", p.Email)
	populate(objectMap, "status", p.Status)
	populateDateTimeRFC3339(objectMap, "statusDate", p.StatusDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Participants.
func (p *Participants) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &p.Email)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "statusDate":
			err = unpopulateDateTimeRFC3339(val, "StatusDate", &p.StatusDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PaymentProperties.
func (p PaymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", p.Amount)
	populateDateTimeRFC3339(objectMap, "date", p.Date)
	populate(objectMap, "paymentMethodFamily", p.PaymentMethodFamily)
	populate(objectMap, "paymentMethodType", p.PaymentMethodType)
	populate(objectMap, "paymentType", p.PaymentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PaymentProperties.
func (p *PaymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &p.Amount)
			delete(rawMsg, key)
		case "date":
			err = unpopulateDateTimeRFC3339(val, "Date", &p.Date)
			delete(rawMsg, key)
		case "paymentMethodFamily":
			err = unpopulate(val, "PaymentMethodFamily", &p.PaymentMethodFamily)
			delete(rawMsg, key)
		case "paymentMethodType":
			err = unpopulate(val, "PaymentMethodType", &p.PaymentMethodType)
			delete(rawMsg, key)
		case "paymentType":
			err = unpopulate(val, "PaymentType", &p.PaymentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Period.
func (p Period) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Period.
func (p *Period) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeriodProperties.
func (p PeriodProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateType(objectMap, "billingPeriodEndDate", p.BillingPeriodEndDate)
	populateDateType(objectMap, "billingPeriodStartDate", p.BillingPeriodStartDate)
	populate(objectMap, "invoiceIds", p.InvoiceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeriodProperties.
func (p *PeriodProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingPeriodEndDate":
			err = unpopulateDateType(val, "BillingPeriodEndDate", &p.BillingPeriodEndDate)
			delete(rawMsg, key)
		case "billingPeriodStartDate":
			err = unpopulateDateType(val, "BillingPeriodStartDate", &p.BillingPeriodStartDate)
			delete(rawMsg, key)
		case "invoiceIds":
			err = unpopulate(val, "InvoiceIDs", &p.InvoiceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeriodsListResult.
func (p PeriodsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeriodsListResult.
func (p *PeriodsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PermissionsListResult.
func (p PermissionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PermissionsListResult.
func (p *PermissionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PermissionsProperties.
func (p PermissionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", p.Actions)
	populate(objectMap, "notActions", p.NotActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PermissionsProperties.
func (p *PermissionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &p.Actions)
			delete(rawMsg, key)
		case "notActions":
			err = unpopulate(val, "NotActions", &p.NotActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Policy.
func (p *Policy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProperties.
func (p PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplacePurchases", p.MarketplacePurchases)
	populate(objectMap, "reservationPurchases", p.ReservationPurchases)
	populate(objectMap, "viewCharges", p.ViewCharges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplacePurchases":
			err = unpopulate(val, "MarketplacePurchases", &p.MarketplacePurchases)
			delete(rawMsg, key)
		case "reservationPurchases":
			err = unpopulate(val, "ReservationPurchases", &p.ReservationPurchases)
			delete(rawMsg, key)
		case "viewCharges":
			err = unpopulate(val, "ViewCharges", &p.ViewCharges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Product.
func (p Product) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Product.
func (p *Product) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductProperties.
func (p ProductProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoRenew", p.AutoRenew)
	populate(objectMap, "availabilityId", p.AvailabilityID)
	populate(objectMap, "billingFrequency", p.BillingFrequency)
	populate(objectMap, "billingProfileDisplayName", p.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", p.BillingProfileID)
	populate(objectMap, "customerDisplayName", p.CustomerDisplayName)
	populate(objectMap, "customerId", p.CustomerID)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "endDate", p.EndDate)
	populate(objectMap, "invoiceSectionDisplayName", p.InvoiceSectionDisplayName)
	populate(objectMap, "invoiceSectionId", p.InvoiceSectionID)
	populate(objectMap, "lastCharge", p.LastCharge)
	populateDateTimeRFC3339(objectMap, "lastChargeDate", p.LastChargeDate)
	populate(objectMap, "productType", p.ProductType)
	populate(objectMap, "productTypeId", p.ProductTypeID)
	populateDateTimeRFC3339(objectMap, "purchaseDate", p.PurchaseDate)
	populate(objectMap, "quantity", p.Quantity)
	populate(objectMap, "reseller", p.Reseller)
	populate(objectMap, "skuDescription", p.SKUDescription)
	populate(objectMap, "skuId", p.SKUID)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "tenantId", p.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductProperties.
func (p *ProductProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoRenew":
			err = unpopulate(val, "AutoRenew", &p.AutoRenew)
			delete(rawMsg, key)
		case "availabilityId":
			err = unpopulate(val, "AvailabilityID", &p.AvailabilityID)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &p.BillingFrequency)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &p.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &p.BillingProfileID)
			delete(rawMsg, key)
		case "customerDisplayName":
			err = unpopulate(val, "CustomerDisplayName", &p.CustomerDisplayName)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &p.CustomerID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &p.EndDate)
			delete(rawMsg, key)
		case "invoiceSectionDisplayName":
			err = unpopulate(val, "InvoiceSectionDisplayName", &p.InvoiceSectionDisplayName)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &p.InvoiceSectionID)
			delete(rawMsg, key)
		case "lastCharge":
			err = unpopulate(val, "LastCharge", &p.LastCharge)
			delete(rawMsg, key)
		case "lastChargeDate":
			err = unpopulateDateTimeRFC3339(val, "LastChargeDate", &p.LastChargeDate)
			delete(rawMsg, key)
		case "productType":
			err = unpopulate(val, "ProductType", &p.ProductType)
			delete(rawMsg, key)
		case "productTypeId":
			err = unpopulate(val, "ProductTypeID", &p.ProductTypeID)
			delete(rawMsg, key)
		case "purchaseDate":
			err = unpopulateDateTimeRFC3339(val, "PurchaseDate", &p.PurchaseDate)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &p.Quantity)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &p.Reseller)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &p.SKUDescription)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &p.SKUID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductsListResult.
func (p ProductsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "totalCount", p.TotalCount)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductsListResult.
func (p *ProductsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &p.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Profile.
func (p *Profile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileCreationRequest.
func (p ProfileCreationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billTo", p.BillTo)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "enabledAzurePlans", p.EnabledAzurePlans)
	populate(objectMap, "invoiceEmailOptIn", p.InvoiceEmailOptIn)
	populate(objectMap, "poNumber", p.PoNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileCreationRequest.
func (p *ProfileCreationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billTo":
			err = unpopulate(val, "BillTo", &p.BillTo)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "enabledAzurePlans":
			err = unpopulate(val, "EnabledAzurePlans", &p.EnabledAzurePlans)
			delete(rawMsg, key)
		case "invoiceEmailOptIn":
			err = unpopulate(val, "InvoiceEmailOptIn", &p.InvoiceEmailOptIn)
			delete(rawMsg, key)
		case "poNumber":
			err = unpopulate(val, "PoNumber", &p.PoNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileInfo.
func (p ProfileInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfileDisplayName", p.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", p.BillingProfileID)
	populate(objectMap, "indirectRelationshipOrganizationName", p.IndirectRelationshipOrganizationName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileInfo.
func (p *ProfileInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &p.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &p.BillingProfileID)
			delete(rawMsg, key)
		case "indirectRelationshipOrganizationName":
			err = unpopulate(val, "IndirectRelationshipOrganizationName", &p.IndirectRelationshipOrganizationName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileListResult.
func (p ProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "totalCount", p.TotalCount)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileListResult.
func (p *ProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &p.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileProperties.
func (p ProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billTo", p.BillTo)
	populate(objectMap, "billingRelationshipType", p.BillingRelationshipType)
	populate(objectMap, "currency", p.Currency)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "enabledAzurePlans", p.EnabledAzurePlans)
	populate(objectMap, "hasReadAccess", p.HasReadAccess)
	populate(objectMap, "indirectRelationshipInfo", p.IndirectRelationshipInfo)
	populate(objectMap, "invoiceDay", p.InvoiceDay)
	populate(objectMap, "invoiceEmailOptIn", p.InvoiceEmailOptIn)
	populate(objectMap, "invoiceSections", p.InvoiceSections)
	populate(objectMap, "poNumber", p.PoNumber)
	populate(objectMap, "spendingLimit", p.SpendingLimit)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "statusReasonCode", p.StatusReasonCode)
	populate(objectMap, "systemId", p.SystemID)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "targetClouds", p.TargetClouds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileProperties.
func (p *ProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billTo":
			err = unpopulate(val, "BillTo", &p.BillTo)
			delete(rawMsg, key)
		case "billingRelationshipType":
			err = unpopulate(val, "BillingRelationshipType", &p.BillingRelationshipType)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &p.Currency)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "enabledAzurePlans":
			err = unpopulate(val, "EnabledAzurePlans", &p.EnabledAzurePlans)
			delete(rawMsg, key)
		case "hasReadAccess":
			err = unpopulate(val, "HasReadAccess", &p.HasReadAccess)
			delete(rawMsg, key)
		case "indirectRelationshipInfo":
			err = unpopulate(val, "IndirectRelationshipInfo", &p.IndirectRelationshipInfo)
			delete(rawMsg, key)
		case "invoiceDay":
			err = unpopulate(val, "InvoiceDay", &p.InvoiceDay)
			delete(rawMsg, key)
		case "invoiceEmailOptIn":
			err = unpopulate(val, "InvoiceEmailOptIn", &p.InvoiceEmailOptIn)
			delete(rawMsg, key)
		case "invoiceSections":
			err = unpopulate(val, "InvoiceSections", &p.InvoiceSections)
			delete(rawMsg, key)
		case "poNumber":
			err = unpopulate(val, "PoNumber", &p.PoNumber)
			delete(rawMsg, key)
		case "spendingLimit":
			err = unpopulate(val, "SpendingLimit", &p.SpendingLimit)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "statusReasonCode":
			err = unpopulate(val, "StatusReasonCode", &p.StatusReasonCode)
			delete(rawMsg, key)
		case "systemId":
			err = unpopulate(val, "SystemID", &p.SystemID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "targetClouds":
			err = unpopulate(val, "TargetClouds", &p.TargetClouds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfilesOnExpand.
func (p ProfilesOnExpand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hasMoreResults", p.HasMoreResults)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfilesOnExpand.
func (p *ProfilesOnExpand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hasMoreResults":
			err = unpopulate(val, "HasMoreResults", &p.HasMoreResults)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Property.
func (p Property) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Property.
func (p *Property) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertyProperties.
func (p PropertyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountAdminNotificationEmailAddress", p.AccountAdminNotificationEmailAddress)
	populate(objectMap, "billingAccountDisplayName", p.BillingAccountDisplayName)
	populate(objectMap, "billingAccountId", p.BillingAccountID)
	populate(objectMap, "billingProfileDisplayName", p.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", p.BillingProfileID)
	populate(objectMap, "billingProfileSpendingLimit", p.BillingProfileSpendingLimit)
	populate(objectMap, "billingProfileStatus", p.BillingProfileStatus)
	populate(objectMap, "billingProfileStatusReasonCode", p.BillingProfileStatusReasonCode)
	populate(objectMap, "billingTenantId", p.BillingTenantID)
	populate(objectMap, "costCenter", p.CostCenter)
	populate(objectMap, "invoiceSectionDisplayName", p.InvoiceSectionDisplayName)
	populate(objectMap, "invoiceSectionId", p.InvoiceSectionID)
	populate(objectMap, "isAccountAdmin", p.IsAccountAdmin)
	populate(objectMap, "productId", p.ProductID)
	populate(objectMap, "productName", p.ProductName)
	populate(objectMap, "skuDescription", p.SKUDescription)
	populate(objectMap, "skuId", p.SKUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertyProperties.
func (p *PropertyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountAdminNotificationEmailAddress":
			err = unpopulate(val, "AccountAdminNotificationEmailAddress", &p.AccountAdminNotificationEmailAddress)
			delete(rawMsg, key)
		case "billingAccountDisplayName":
			err = unpopulate(val, "BillingAccountDisplayName", &p.BillingAccountDisplayName)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &p.BillingAccountID)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &p.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &p.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileSpendingLimit":
			err = unpopulate(val, "BillingProfileSpendingLimit", &p.BillingProfileSpendingLimit)
			delete(rawMsg, key)
		case "billingProfileStatus":
			err = unpopulate(val, "BillingProfileStatus", &p.BillingProfileStatus)
			delete(rawMsg, key)
		case "billingProfileStatusReasonCode":
			err = unpopulate(val, "BillingProfileStatusReasonCode", &p.BillingProfileStatusReasonCode)
			delete(rawMsg, key)
		case "billingTenantId":
			err = unpopulate(val, "BillingTenantID", &p.BillingTenantID)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &p.CostCenter)
			delete(rawMsg, key)
		case "invoiceSectionDisplayName":
			err = unpopulate(val, "InvoiceSectionDisplayName", &p.InvoiceSectionDisplayName)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &p.InvoiceSectionID)
			delete(rawMsg, key)
		case "isAccountAdmin":
			err = unpopulate(val, "IsAccountAdmin", &p.IsAccountAdmin)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &p.ProductID)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &p.ProductName)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &p.SKUDescription)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &p.SKUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RebillDetails.
func (r RebillDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creditNoteDocumentId", r.CreditNoteDocumentID)
	populate(objectMap, "invoiceDocumentId", r.InvoiceDocumentID)
	populate(objectMap, "rebillDetails", r.RebillDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RebillDetails.
func (r *RebillDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creditNoteDocumentId":
			err = unpopulate(val, "CreditNoteDocumentID", &r.CreditNoteDocumentID)
			delete(rawMsg, key)
		case "invoiceDocumentId":
			err = unpopulate(val, "InvoiceDocumentID", &r.InvoiceDocumentID)
			delete(rawMsg, key)
		case "rebillDetails":
			err = unpopulate(val, "RebillDetails", &r.RebillDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Reseller.
func (r Reseller) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "resellerId", r.ResellerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Reseller.
func (r *Reseller) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "resellerId":
			err = unpopulate(val, "ResellerID", &r.ResellerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Reservation.
func (r Reservation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Reservation.
func (r *Reservation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationProperty.
func (r ReservationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeType", r.AppliedScopeType)
	populate(objectMap, "appliedScopes", r.AppliedScopes)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "displayProvisioningState", r.DisplayProvisioningState)
	populate(objectMap, "effectiveDateTime", r.EffectiveDateTime)
	populate(objectMap, "expiryDate", r.ExpiryDate)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "provisioningSubState", r.ProvisioningSubState)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "renew", r.Renew)
	populate(objectMap, "renewSource", r.RenewSource)
	populate(objectMap, "reservedResourceType", r.ReservedResourceType)
	populate(objectMap, "skuDescription", r.SKUDescription)
	populate(objectMap, "term", r.Term)
	populate(objectMap, "userFriendlyAppliedScopeType", r.UserFriendlyAppliedScopeType)
	populate(objectMap, "userFriendlyRenewState", r.UserFriendlyRenewState)
	populate(objectMap, "utilization", r.Utilization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationProperty.
func (r *ReservationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &r.AppliedScopeType)
			delete(rawMsg, key)
		case "appliedScopes":
			err = unpopulate(val, "AppliedScopes", &r.AppliedScopes)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "displayProvisioningState":
			err = unpopulate(val, "DisplayProvisioningState", &r.DisplayProvisioningState)
			delete(rawMsg, key)
		case "effectiveDateTime":
			err = unpopulate(val, "EffectiveDateTime", &r.EffectiveDateTime)
			delete(rawMsg, key)
		case "expiryDate":
			err = unpopulate(val, "ExpiryDate", &r.ExpiryDate)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningSubState":
			err = unpopulate(val, "ProvisioningSubState", &r.ProvisioningSubState)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &r.Renew)
			delete(rawMsg, key)
		case "renewSource":
			err = unpopulate(val, "RenewSource", &r.RenewSource)
			delete(rawMsg, key)
		case "reservedResourceType":
			err = unpopulate(val, "ReservedResourceType", &r.ReservedResourceType)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &r.SKUDescription)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &r.Term)
			delete(rawMsg, key)
		case "userFriendlyAppliedScopeType":
			err = unpopulate(val, "UserFriendlyAppliedScopeType", &r.UserFriendlyAppliedScopeType)
			delete(rawMsg, key)
		case "userFriendlyRenewState":
			err = unpopulate(val, "UserFriendlyRenewState", &r.UserFriendlyRenewState)
			delete(rawMsg, key)
		case "utilization":
			err = unpopulate(val, "Utilization", &r.Utilization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationPropertyUtilization.
func (r ReservationPropertyUtilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregates", r.Aggregates)
	populate(objectMap, "trend", r.Trend)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationPropertyUtilization.
func (r *ReservationPropertyUtilization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregates":
			err = unpopulate(val, "Aggregates", &r.Aggregates)
			delete(rawMsg, key)
		case "trend":
			err = unpopulate(val, "Trend", &r.Trend)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSKUProperty.
func (r ReservationSKUProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSKUProperty.
func (r *ReservationSKUProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSummary.
func (r ReservationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancelledCount", r.CancelledCount)
	populate(objectMap, "expiredCount", r.ExpiredCount)
	populate(objectMap, "expiringCount", r.ExpiringCount)
	populate(objectMap, "failedCount", r.FailedCount)
	populate(objectMap, "pendingCount", r.PendingCount)
	populate(objectMap, "succeededCount", r.SucceededCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummary.
func (r *ReservationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancelledCount":
			err = unpopulate(val, "CancelledCount", &r.CancelledCount)
			delete(rawMsg, key)
		case "expiredCount":
			err = unpopulate(val, "ExpiredCount", &r.ExpiredCount)
			delete(rawMsg, key)
		case "expiringCount":
			err = unpopulate(val, "ExpiringCount", &r.ExpiringCount)
			delete(rawMsg, key)
		case "failedCount":
			err = unpopulate(val, "FailedCount", &r.FailedCount)
			delete(rawMsg, key)
		case "pendingCount":
			err = unpopulate(val, "PendingCount", &r.PendingCount)
			delete(rawMsg, key)
		case "succeededCount":
			err = unpopulate(val, "SucceededCount", &r.SucceededCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationUtilizationAggregates.
func (r ReservationUtilizationAggregates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grain", r.Grain)
	populate(objectMap, "grainUnit", r.GrainUnit)
	populate(objectMap, "value", r.Value)
	populate(objectMap, "valueUnit", r.ValueUnit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationUtilizationAggregates.
func (r *ReservationUtilizationAggregates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grain":
			err = unpopulate(val, "Grain", &r.Grain)
			delete(rawMsg, key)
		case "grainUnit":
			err = unpopulate(val, "GrainUnit", &r.GrainUnit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		case "valueUnit":
			err = unpopulate(val, "ValueUnit", &r.ValueUnit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationsListResult.
func (r ReservationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "summary", r.Summary)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationsListResult.
func (r *ReservationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &r.Summary)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignment.
func (r RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignment.
func (r *RoleAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentListResult.
func (r RoleAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentListResult.
func (r *RoleAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentProperties.
func (r RoleAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdByPrincipalId", r.CreatedByPrincipalID)
	populate(objectMap, "createdByPrincipalTenantId", r.CreatedByPrincipalTenantID)
	populate(objectMap, "createdByUserEmailAddress", r.CreatedByUserEmailAddress)
	populate(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalTenantId", r.PrincipalTenantID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "userAuthenticationType", r.UserAuthenticationType)
	populate(objectMap, "userEmailAddress", r.UserEmailAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentProperties.
func (r *RoleAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdByPrincipalId":
			err = unpopulate(val, "CreatedByPrincipalID", &r.CreatedByPrincipalID)
			delete(rawMsg, key)
		case "createdByPrincipalTenantId":
			err = unpopulate(val, "CreatedByPrincipalTenantID", &r.CreatedByPrincipalTenantID)
			delete(rawMsg, key)
		case "createdByUserEmailAddress":
			err = unpopulate(val, "CreatedByUserEmailAddress", &r.CreatedByUserEmailAddress)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulate(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalTenantId":
			err = unpopulate(val, "PrincipalTenantID", &r.PrincipalTenantID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "userAuthenticationType":
			err = unpopulate(val, "UserAuthenticationType", &r.UserAuthenticationType)
			delete(rawMsg, key)
		case "userEmailAddress":
			err = unpopulate(val, "UserEmailAddress", &r.UserEmailAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinition.
func (r RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinition.
func (r *RoleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinitionListResult.
func (r RoleDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinitionListResult.
func (r *RoleDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinitionProperties.
func (r RoleDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "permissions", r.Permissions)
	populate(objectMap, "roleName", r.RoleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinitionProperties.
func (r *RoleDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &r.Permissions)
			delete(rawMsg, key)
		case "roleName":
			err = unpopulate(val, "RoleName", &r.RoleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subscription.
func (s Subscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subscription.
func (s *Subscription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionProperties.
func (s SubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfileDisplayName", s.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", s.BillingProfileID)
	populate(objectMap, "costCenter", s.CostCenter)
	populate(objectMap, "customerDisplayName", s.CustomerDisplayName)
	populate(objectMap, "customerId", s.CustomerID)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "invoiceSectionDisplayName", s.InvoiceSectionDisplayName)
	populate(objectMap, "invoiceSectionId", s.InvoiceSectionID)
	populate(objectMap, "lastMonthCharges", s.LastMonthCharges)
	populate(objectMap, "monthToDateCharges", s.MonthToDateCharges)
	populate(objectMap, "reseller", s.Reseller)
	populate(objectMap, "skuDescription", s.SKUDescription)
	populate(objectMap, "skuId", s.SKUID)
	populate(objectMap, "subscriptionBillingStatus", s.SubscriptionBillingStatus)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	populate(objectMap, "suspensionReasons", s.SuspensionReasons)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionProperties.
func (s *SubscriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &s.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &s.BillingProfileID)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &s.CostCenter)
			delete(rawMsg, key)
		case "customerDisplayName":
			err = unpopulate(val, "CustomerDisplayName", &s.CustomerDisplayName)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &s.CustomerID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "invoiceSectionDisplayName":
			err = unpopulate(val, "InvoiceSectionDisplayName", &s.InvoiceSectionDisplayName)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &s.InvoiceSectionID)
			delete(rawMsg, key)
		case "lastMonthCharges":
			err = unpopulate(val, "LastMonthCharges", &s.LastMonthCharges)
			delete(rawMsg, key)
		case "monthToDateCharges":
			err = unpopulate(val, "MonthToDateCharges", &s.MonthToDateCharges)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &s.Reseller)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &s.SKUDescription)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &s.SKUID)
			delete(rawMsg, key)
		case "subscriptionBillingStatus":
			err = unpopulate(val, "SubscriptionBillingStatus", &s.SubscriptionBillingStatus)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		case "suspensionReasons":
			err = unpopulate(val, "SuspensionReasons", &s.SuspensionReasons)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionsListResult.
func (s SubscriptionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "totalCount", s.TotalCount)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionsListResult.
func (s *SubscriptionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &s.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Transaction.
func (t Transaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Transaction.
func (t *Transaction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransactionListResult.
func (t TransactionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "totalCount", t.TotalCount)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransactionListResult.
func (t *TransactionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &t.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransactionProperties.
func (t TransactionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureCreditApplied", t.AzureCreditApplied)
	populate(objectMap, "azurePlan", t.AzurePlan)
	populate(objectMap, "billingCurrency", t.BillingCurrency)
	populate(objectMap, "billingProfileDisplayName", t.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", t.BillingProfileID)
	populate(objectMap, "customerDisplayName", t.CustomerDisplayName)
	populate(objectMap, "customerId", t.CustomerID)
	populateDateTimeRFC3339(objectMap, "date", t.Date)
	populate(objectMap, "discount", t.Discount)
	populate(objectMap, "effectivePrice", t.EffectivePrice)
	populate(objectMap, "exchangeRate", t.ExchangeRate)
	populate(objectMap, "invoice", t.Invoice)
	populate(objectMap, "invoiceId", t.InvoiceID)
	populate(objectMap, "invoiceSectionDisplayName", t.InvoiceSectionDisplayName)
	populate(objectMap, "invoiceSectionId", t.InvoiceSectionID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "marketPrice", t.MarketPrice)
	populate(objectMap, "orderId", t.OrderID)
	populate(objectMap, "orderName", t.OrderName)
	populate(objectMap, "pricingCurrency", t.PricingCurrency)
	populate(objectMap, "productDescription", t.ProductDescription)
	populate(objectMap, "productFamily", t.ProductFamily)
	populate(objectMap, "productType", t.ProductType)
	populate(objectMap, "productTypeId", t.ProductTypeID)
	populate(objectMap, "quantity", t.Quantity)
	populateDateTimeRFC3339(objectMap, "servicePeriodEndDate", t.ServicePeriodEndDate)
	populateDateTimeRFC3339(objectMap, "servicePeriodStartDate", t.ServicePeriodStartDate)
	populate(objectMap, "subTotal", t.SubTotal)
	populate(objectMap, "subscriptionId", t.SubscriptionID)
	populate(objectMap, "subscriptionName", t.SubscriptionName)
	populate(objectMap, "tax", t.Tax)
	populate(objectMap, "transactionAmount", t.TransactionAmount)
	populate(objectMap, "transactionType", t.TransactionType)
	populate(objectMap, "unitOfMeasure", t.UnitOfMeasure)
	populate(objectMap, "unitType", t.UnitType)
	populate(objectMap, "units", t.Units)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransactionProperties.
func (t *TransactionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCreditApplied":
			err = unpopulate(val, "AzureCreditApplied", &t.AzureCreditApplied)
			delete(rawMsg, key)
		case "azurePlan":
			err = unpopulate(val, "AzurePlan", &t.AzurePlan)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &t.BillingCurrency)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &t.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &t.BillingProfileID)
			delete(rawMsg, key)
		case "customerDisplayName":
			err = unpopulate(val, "CustomerDisplayName", &t.CustomerDisplayName)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &t.CustomerID)
			delete(rawMsg, key)
		case "date":
			err = unpopulateDateTimeRFC3339(val, "Date", &t.Date)
			delete(rawMsg, key)
		case "discount":
			err = unpopulate(val, "Discount", &t.Discount)
			delete(rawMsg, key)
		case "effectivePrice":
			err = unpopulate(val, "EffectivePrice", &t.EffectivePrice)
			delete(rawMsg, key)
		case "exchangeRate":
			err = unpopulate(val, "ExchangeRate", &t.ExchangeRate)
			delete(rawMsg, key)
		case "invoice":
			err = unpopulate(val, "Invoice", &t.Invoice)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &t.InvoiceID)
			delete(rawMsg, key)
		case "invoiceSectionDisplayName":
			err = unpopulate(val, "InvoiceSectionDisplayName", &t.InvoiceSectionDisplayName)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &t.InvoiceSectionID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "marketPrice":
			err = unpopulate(val, "MarketPrice", &t.MarketPrice)
			delete(rawMsg, key)
		case "orderId":
			err = unpopulate(val, "OrderID", &t.OrderID)
			delete(rawMsg, key)
		case "orderName":
			err = unpopulate(val, "OrderName", &t.OrderName)
			delete(rawMsg, key)
		case "pricingCurrency":
			err = unpopulate(val, "PricingCurrency", &t.PricingCurrency)
			delete(rawMsg, key)
		case "productDescription":
			err = unpopulate(val, "ProductDescription", &t.ProductDescription)
			delete(rawMsg, key)
		case "productFamily":
			err = unpopulate(val, "ProductFamily", &t.ProductFamily)
			delete(rawMsg, key)
		case "productType":
			err = unpopulate(val, "ProductType", &t.ProductType)
			delete(rawMsg, key)
		case "productTypeId":
			err = unpopulate(val, "ProductTypeID", &t.ProductTypeID)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &t.Quantity)
			delete(rawMsg, key)
		case "servicePeriodEndDate":
			err = unpopulateDateTimeRFC3339(val, "ServicePeriodEndDate", &t.ServicePeriodEndDate)
			delete(rawMsg, key)
		case "servicePeriodStartDate":
			err = unpopulateDateTimeRFC3339(val, "ServicePeriodStartDate", &t.ServicePeriodStartDate)
			delete(rawMsg, key)
		case "subTotal":
			err = unpopulate(val, "SubTotal", &t.SubTotal)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &t.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &t.SubscriptionName)
			delete(rawMsg, key)
		case "tax":
			err = unpopulate(val, "Tax", &t.Tax)
			delete(rawMsg, key)
		case "transactionAmount":
			err = unpopulate(val, "TransactionAmount", &t.TransactionAmount)
			delete(rawMsg, key)
		case "transactionType":
			err = unpopulate(val, "TransactionType", &t.TransactionType)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &t.UnitOfMeasure)
			delete(rawMsg, key)
		case "unitType":
			err = unpopulate(val, "UnitType", &t.UnitType)
			delete(rawMsg, key)
		case "units":
			err = unpopulate(val, "Units", &t.Units)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferBillingSubscriptionRequestProperties.
func (t TransferBillingSubscriptionRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationInvoiceSectionId", t.DestinationInvoiceSectionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferBillingSubscriptionRequestProperties.
func (t *TransferBillingSubscriptionRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationInvoiceSectionId":
			err = unpopulate(val, "DestinationInvoiceSectionID", &t.DestinationInvoiceSectionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferProductRequestProperties.
func (t TransferProductRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationInvoiceSectionId", t.DestinationInvoiceSectionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferProductRequestProperties.
func (t *TransferProductRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationInvoiceSectionId":
			err = unpopulate(val, "DestinationInvoiceSectionID", &t.DestinationInvoiceSectionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateAddressResponse.
func (v ValidateAddressResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "suggestedAddresses", v.SuggestedAddresses)
	populate(objectMap, "validationMessage", v.ValidationMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateAddressResponse.
func (v *ValidateAddressResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "suggestedAddresses":
			err = unpopulate(val, "SuggestedAddresses", &v.SuggestedAddresses)
			delete(rawMsg, key)
		case "validationMessage":
			err = unpopulate(val, "ValidationMessage", &v.ValidationMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProductTransferEligibilityError.
func (v ValidateProductTransferEligibilityError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "details", v.Details)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProductTransferEligibilityError.
func (v *ValidateProductTransferEligibilityError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &v.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProductTransferEligibilityResult.
func (v ValidateProductTransferEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorDetails", v.ErrorDetails)
	populate(objectMap, "isMoveEligible", v.IsMoveEligible)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProductTransferEligibilityResult.
func (v *ValidateProductTransferEligibilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &v.ErrorDetails)
			delete(rawMsg, key)
		case "isMoveEligible":
			err = unpopulate(val, "IsMoveEligible", &v.IsMoveEligible)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSubscriptionTransferEligibilityError.
func (v ValidateSubscriptionTransferEligibilityError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "details", v.Details)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateSubscriptionTransferEligibilityError.
func (v *ValidateSubscriptionTransferEligibilityError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &v.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSubscriptionTransferEligibilityResult.
func (v ValidateSubscriptionTransferEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorDetails", v.ErrorDetails)
	populate(objectMap, "isMoveEligible", v.IsMoveEligible)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateSubscriptionTransferEligibilityResult.
func (v *ValidateSubscriptionTransferEligibilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &v.ErrorDetails)
			delete(rawMsg, key)
		case "isMoveEligible":
			err = unpopulate(val, "IsMoveEligible", &v.IsMoveEligible)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
