//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// OrchestratorInstanceServiceClient contains the methods for the OrchestratorInstanceService group.
// Don't use this type directly, use NewOrchestratorInstanceServiceClient() instead.
type OrchestratorInstanceServiceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewOrchestratorInstanceServiceClient creates a new instance of OrchestratorInstanceServiceClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewOrchestratorInstanceServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*OrchestratorInstanceServiceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &OrchestratorInstanceServiceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Create a orchestrator instance
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - OrchestratorInstance type parameters
//   - options - OrchestratorInstanceServiceClientBeginCreateOptions contains the optional parameters for the OrchestratorInstanceServiceClient.BeginCreate
//     method.
func (client *OrchestratorInstanceServiceClient) BeginCreate(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*runtime.Poller[OrchestratorInstanceServiceClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[OrchestratorInstanceServiceClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[OrchestratorInstanceServiceClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create a orchestrator instance
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *OrchestratorInstanceServiceClient) create(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "OrchestratorInstanceServiceClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *OrchestratorInstanceServiceClient) createCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - OrchestratorInstanceServiceClientBeginDeleteOptions contains the optional parameters for the OrchestratorInstanceServiceClient.BeginDelete
//     method.
func (client *OrchestratorInstanceServiceClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*runtime.Poller[OrchestratorInstanceServiceClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[OrchestratorInstanceServiceClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[OrchestratorInstanceServiceClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *OrchestratorInstanceServiceClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "OrchestratorInstanceServiceClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *OrchestratorInstanceServiceClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the orchestrator instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - OrchestratorInstanceServiceClientGetDetailsOptions contains the optional parameters for the OrchestratorInstanceServiceClient.GetDetails
//     method.
func (client *OrchestratorInstanceServiceClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientGetDetailsOptions) (OrchestratorInstanceServiceClientGetDetailsResponse, error) {
	var err error
	const operationName = "OrchestratorInstanceServiceClient.GetDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	resp, err := client.getDetailsHandleResponse(httpResp)
	return resp, err
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *OrchestratorInstanceServiceClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *OrchestratorInstanceServiceClient) getDetailsHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientGetDetailsResponse, error) {
	result := OrchestratorInstanceServiceClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrator); err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get all the OrchestratorInstances resources in a resource group.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - OrchestratorInstanceServiceClientListByResourceGroupOptions contains the optional parameters for the OrchestratorInstanceServiceClient.NewListByResourceGroupPager
//     method.
func (client *OrchestratorInstanceServiceClient) NewListByResourceGroupPager(resourceGroupName string, options *OrchestratorInstanceServiceClientListByResourceGroupOptions) *runtime.Pager[OrchestratorInstanceServiceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[OrchestratorInstanceServiceClientListByResourceGroupResponse]{
		More: func(page OrchestratorInstanceServiceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OrchestratorInstanceServiceClientListByResourceGroupResponse) (OrchestratorInstanceServiceClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "OrchestratorInstanceServiceClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *OrchestratorInstanceServiceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *OrchestratorInstanceServiceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *OrchestratorInstanceServiceClient) listByResourceGroupHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientListByResourceGroupResponse, error) {
	result := OrchestratorInstanceServiceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrators); err != nil {
		return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get all the orchestratorInstance resources in a subscription.
//
// Generated from API version 2021-03-15
//   - options - OrchestratorInstanceServiceClientListBySubscriptionOptions contains the optional parameters for the OrchestratorInstanceServiceClient.NewListBySubscriptionPager
//     method.
func (client *OrchestratorInstanceServiceClient) NewListBySubscriptionPager(options *OrchestratorInstanceServiceClientListBySubscriptionOptions) *runtime.Pager[OrchestratorInstanceServiceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[OrchestratorInstanceServiceClientListBySubscriptionResponse]{
		More: func(page OrchestratorInstanceServiceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OrchestratorInstanceServiceClientListBySubscriptionResponse) (OrchestratorInstanceServiceClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "OrchestratorInstanceServiceClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *OrchestratorInstanceServiceClient) listBySubscriptionCreateRequest(ctx context.Context, options *OrchestratorInstanceServiceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DelegatedNetwork/orchestrators"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *OrchestratorInstanceServiceClient) listBySubscriptionHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientListBySubscriptionResponse, error) {
	result := OrchestratorInstanceServiceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrators); err != nil {
		return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Patch - Update Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - OrchestratorInstance update parameters
//   - options - OrchestratorInstanceServiceClientPatchOptions contains the optional parameters for the OrchestratorInstanceServiceClient.Patch
//     method.
func (client *OrchestratorInstanceServiceClient) Patch(ctx context.Context, resourceGroupName string, resourceName string, parameters OrchestratorResourceUpdateParameters, options *OrchestratorInstanceServiceClientPatchOptions) (OrchestratorInstanceServiceClientPatchResponse, error) {
	var err error
	const operationName = "OrchestratorInstanceServiceClient.Patch"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	resp, err := client.patchHandleResponse(httpResp)
	return resp, err
}

// patchCreateRequest creates the Patch request.
func (client *OrchestratorInstanceServiceClient) patchCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters OrchestratorResourceUpdateParameters, options *OrchestratorInstanceServiceClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// patchHandleResponse handles the Patch response.
func (client *OrchestratorInstanceServiceClient) patchHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientPatchResponse, error) {
	result := OrchestratorInstanceServiceClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrator); err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	return result, nil
}
