//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationProtectableItemsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationProtectableItemsClient type.
type ReplicationProtectableItemsServer struct {
	// Get is the fake for method ReplicationProtectableItemsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, protectableItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectableItemsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationProtectableItemsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByReplicationProtectionContainersPager is the fake for method ReplicationProtectableItemsClient.NewListByReplicationProtectionContainersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationProtectionContainersPager func(resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, options *armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersResponse])
}

// NewReplicationProtectableItemsServerTransport creates a new instance of ReplicationProtectableItemsServerTransport with the provided implementation.
// The returned ReplicationProtectableItemsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationProtectableItemsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationProtectableItemsServerTransport(srv *ReplicationProtectableItemsServer) *ReplicationProtectableItemsServerTransport {
	return &ReplicationProtectableItemsServerTransport{
		srv: srv,
		newListByReplicationProtectionContainersPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersResponse]](),
	}
}

// ReplicationProtectableItemsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationProtectableItemsClient to instances of ReplicationProtectableItemsServer.
// Don't use this type directly, use NewReplicationProtectableItemsServerTransport instead.
type ReplicationProtectableItemsServerTransport struct {
	srv                                           *ReplicationProtectableItemsServer
	newListByReplicationProtectionContainersPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersResponse]]
}

// Do implements the policy.Transporter interface for ReplicationProtectableItemsServerTransport.
func (r *ReplicationProtectableItemsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationProtectableItemsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationProtectableItemsClient.NewListByReplicationProtectionContainersPager":
		resp, err = r.dispatchNewListByReplicationProtectionContainersPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationProtectableItemsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectableItems/(?P<protectableItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
	if err != nil {
		return nil, err
	}
	protectableItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectableItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, protectableItemNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProtectableItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationProtectableItemsServerTransport) dispatchNewListByReplicationProtectionContainersPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReplicationProtectionContainersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationProtectionContainersPager not implemented")}
	}
	newListByReplicationProtectionContainersPager := r.newListByReplicationProtectionContainersPager.get(req)
	if newListByReplicationProtectionContainersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectableItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		takeUnescaped, err := url.QueryUnescape(qp.Get("$take"))
		if err != nil {
			return nil, err
		}
		takeParam := getOptional(takeUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersOptions
		if filterParam != nil || takeParam != nil || skipTokenParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersOptions{
				Filter:    filterParam,
				Take:      takeParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := r.srv.NewListByReplicationProtectionContainersPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, options)
		newListByReplicationProtectionContainersPager = &resp
		r.newListByReplicationProtectionContainersPager.add(req, newListByReplicationProtectionContainersPager)
		server.PagerResponderInjectNextLinks(newListByReplicationProtectionContainersPager, req, func(page *armrecoveryservicessiterecovery.ReplicationProtectableItemsClientListByReplicationProtectionContainersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationProtectionContainersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReplicationProtectionContainersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationProtectionContainersPager) {
		r.newListByReplicationProtectionContainersPager.remove(req)
	}
	return resp, nil
}
