//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedapplications

// Application - Information about managed application.
type Application struct {
	// REQUIRED; The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string

	// REQUIRED; The managed application properties.
	Properties *ApplicationProperties

	// The identity of the resource.
	Identity *Identity

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The plan information.
	Plan *Plan

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationArtifact - Managed application artifact.
type ApplicationArtifact struct {
	// The managed application artifact name.
	Name *string

	// The managed application artifact type.
	Type *ApplicationArtifactType

	// The managed application artifact blob uri.
	URI *string
}

// ApplicationDefinition - Information about managed application definition.
type ApplicationDefinition struct {
	// REQUIRED; The managed application definition properties.
	Properties *ApplicationDefinitionProperties

	// The identity of the resource.
	Identity *Identity

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationDefinitionListResult - List of managed application definitions.
type ApplicationDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of managed application definitions.
	Value []*ApplicationDefinition
}

// ApplicationDefinitionProperties - The managed application definition properties.
type ApplicationDefinitionProperties struct {
	// REQUIRED; The managed application provider authorizations.
	Authorizations []*ApplicationProviderAuthorization

	// REQUIRED; The managed application lock level.
	LockLevel *ApplicationLockLevel

	// The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the
	// user experience of creating a managed application from a managed application
	// definition.
	Artifacts []*ApplicationArtifact

	// The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject
	// or well-formed JSON string.
	CreateUIDefinition any

	// The managed application definition description.
	Description *string

	// The managed application definition display name.
	DisplayName *string

	// A value indicating whether the package is enabled or not.
	IsEnabled *string

	// The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
	MainTemplate any

	// The managed application definition package file Uri. Use this element
	PackageFileURI *string
}

// ApplicationListResult - List of managed applications.
type ApplicationListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of managed applications.
	Value []*Application
}

// ApplicationPatchable - Information about managed application.
type ApplicationPatchable struct {
	// The identity of the resource.
	Identity *Identity

	// The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The plan information.
	Plan *PlanPatchable

	// The managed application properties.
	Properties *ApplicationPropertiesPatchable

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationProperties - The managed application properties.
type ApplicationProperties struct {
	// REQUIRED; The managed resource group Id.
	ManagedResourceGroupID *string

	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters any

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs any

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState
}

// ApplicationPropertiesPatchable - The managed application properties.
type ApplicationPropertiesPatchable struct {
	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string

	// The managed resource group Id.
	ManagedResourceGroupID *string

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters any

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs any

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState
}

// ApplicationProviderAuthorization - The managed application provider authorization.
type ApplicationProviderAuthorization struct {
	// REQUIRED; The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the
	// managed application resources.
	PrincipalID *string

	// REQUIRED; The provider's role definition identifier. This role will define all the permissions that the provider must have
	// on the managed application's container resource group. This role definition cannot have
	// permission to delete the resource group.
	RoleDefinitionID *string
}

// ErrorResponse - Error response indicates managed application is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// Error code.
	ErrorCode *string

	// Error message indicating why the operation failed.
	ErrorMessage *string

	// Http status code.
	HTTPStatus *string
}

// GenericResource - Resource information.
type GenericResource struct {
	// The identity of the resource.
	Identity *Identity

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// Operation - Microsoft.Solutions operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Solutions
	Provider *string

	// Resource on which the operation is performed: Application, JitRequest, etc.
	Resource *string
}

// OperationListResult - Result of the request to list Microsoft.Solutions operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Microsoft.Solutions operations.
	Value []*Operation
}

// Plan for the managed application.
type Plan struct {
	// REQUIRED; The plan name.
	Name *string

	// REQUIRED; The product code.
	Product *string

	// REQUIRED; The publisher ID.
	Publisher *string

	// REQUIRED; The plan's version.
	Version *string

	// The promotion code.
	PromotionCode *string
}

// PlanPatchable - Plan for the managed application.
type PlanPatchable struct {
	// The plan name.
	Name *string

	// The product code.
	Product *string

	// The promotion code.
	PromotionCode *string

	// The publisher ID.
	Publisher *string

	// The plan's version.
	Version *string
}

// Resource information.
type Resource struct {
	// Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SKU for the resource.
type SKU struct {
	// REQUIRED; The SKU name.
	Name *string

	// The SKU capacity.
	Capacity *int32

	// The SKU family.
	Family *string

	// The SKU model.
	Model *string

	// The SKU size.
	Size *string

	// The SKU tier.
	Tier *string
}
