#pragma once
/*
 *  $Id: graph-area.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_AREA_H__
#define __GWYUI_GRAPH_AREA_H__

#include <gtk/gtk.h>
#include <libgwyddion/selection.h>
#include <libgwyui/gwygraphmodel.h>
#include <libgwyui/graph-key.h>

G_BEGIN_DECLS

typedef enum {
    GWY_GRAPH_KEY_NORTHEAST = 0,
    GWY_GRAPH_KEY_NORTHWEST = 1,
    GWY_GRAPH_KEY_SOUTHEAST = 2,
    GWY_GRAPH_KEY_SOUTHWEST = 3,
    GWY_GRAPH_KEY_USER      = 4
} GwyGraphKeyPosition;

typedef enum {
    GWY_GRAPH_STATUS_PLAIN,
    GWY_GRAPH_STATUS_XSEL,
    GWY_GRAPH_STATUS_YSEL,
    GWY_GRAPH_STATUS_XLINES,
    GWY_GRAPH_STATUS_YLINES,
    GWY_GRAPH_STATUS_POINTS,
    GWY_GRAPH_STATUS_ZOOM,
} GwyGraphStatusType;

#define GWY_TYPE_GRAPH_AREA            (gwy_graph_area_get_type())
#define GWY_GRAPH_AREA(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_AREA, GwyGraphArea))
#define GWY_GRAPH_AREA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_AREA, GwyGraphAreaClass))
#define GWY_IS_GRAPH_AREA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_AREA))
#define GWY_IS_GRAPH_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_AREA))
#define GWY_GRAPH_AREA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_AREA, GwyGraphAreaClass))

typedef struct _GwyGraphArea             GwyGraphArea;
typedef struct _GwyGraphAreaClass        GwyGraphAreaClass;
typedef struct _GwyGraphAreaPrivate      GwyGraphAreaPrivate;

struct _GwyGraphArea {
    GtkBin parent_instance;
    GwyGraphAreaPrivate *priv;
};

struct _GwyGraphAreaClass {
    GtkBinClass parent_class;

    void (*edit_curve)(GwyGraphArea *area,
                       gint id);

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType              gwy_graph_area_get_type              (void)                       G_GNUC_CONST;
GtkWidget*         gwy_graph_area_new                   (void);
void               gwy_graph_area_set_model             (GwyGraphArea *area,
                                                         GwyGraphModel *gmodel);
GwyGraphModel*     gwy_graph_area_get_model             (GwyGraphArea *area);
void               gwy_graph_area_set_x_range           (GwyGraphArea *area,
                                                         gdouble x_min,
                                                         gdouble x_max);
void               gwy_graph_area_set_y_range           (GwyGraphArea *area,
                                                         gdouble y_min,
                                                         gdouble y_max);
void               gwy_graph_area_set_x_grid_data       (GwyGraphArea *area,
                                                         guint ndata,
                                                         const gdouble *grid_data);
void               gwy_graph_area_set_y_grid_data       (GwyGraphArea *area,
                                                         guint ndata,
                                                         const gdouble *grid_data);
const gdouble*     gwy_graph_area_get_x_grid_data       (GwyGraphArea *area,
                                                         guint *ndata);
const gdouble*     gwy_graph_area_get_y_grid_data       (GwyGraphArea *area,
                                                         guint *ndata);
GwySelection*      gwy_graph_area_get_selection         (GwyGraphArea *area,
                                                         GwyGraphStatusType status);
void               gwy_graph_area_set_status            (GwyGraphArea *area,
                                                         GwyGraphStatusType status);
GwyGraphStatusType gwy_graph_area_get_status            (GwyGraphArea *area);
void               gwy_graph_area_enable_user_input     (GwyGraphArea *area,
                                                         gboolean enable);
void               gwy_graph_area_set_selection_editable(GwyGraphArea *area,
                                                         gboolean setting);
void               gwy_graph_area_edit_curve            (GwyGraphArea *area,
                                                         gint id);
void               gwy_graph_area_coords_widget_to_real (GwyGraphArea *area,
                                                         gdouble xscr,
                                                         gdouble yscr,
                                                         gdouble *x,
                                                         gdouble *y);
void               gwy_graph_area_set_natural_size      (GwyGraphArea *area,
                                                         gint width,
                                                         gint height);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
