#pragma once
/*
 *  $Id: graph-axis.h 28517 2025-09-05 07:38:23Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_AXIS_H__
#define __GWYUI_GRAPH_AXIS_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <libgwyddion/unit.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRAPH_AXIS            (gwy_graph_axis_get_type())
#define GWY_GRAPH_AXIS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_AXIS, GwyGraphAxis))
#define GWY_GRAPH_AXIS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_AXIS, GwyGraphAxisClass))
#define GWY_IS_GRAPH_AXIS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_AXIS))
#define GWY_IS_GRAPH_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_AXIS))
#define GWY_GRAPH_AXIS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_AXIS, GwyGraphAxisClass))

typedef struct _GwyGraphAxis             GwyGraphAxis;
typedef struct _GwyGraphAxisClass        GwyGraphAxisClass;
typedef struct _GwyGraphAxisPrivate      GwyGraphAxisPrivate;

struct _GwyGraphAxis {
    GtkWidget parent_instance;
    GwyGraphAxisPrivate *priv;
};

struct _GwyGraphAxisClass {
    GtkWidgetClass parent_class;

    void (*rescaled)(GwyGraphAxis *axis);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
};

GType           gwy_graph_axis_get_type                (void)                      G_GNUC_CONST;
GtkWidget*      gwy_graph_axis_new                     (GtkPositionType position);
void            gwy_graph_axis_set_logarithmic         (GwyGraphAxis *axis,
                                                        gboolean is_logarithmic);
gboolean        gwy_graph_axis_is_logarithmic          (GwyGraphAxis *axis);
GtkPositionType gwy_graph_axis_get_position            (GwyGraphAxis *axis);
void            gwy_graph_axis_set_auto                (GwyGraphAxis *axis,
                                                        gboolean is_auto);
void            gwy_graph_axis_request_range           (GwyGraphAxis *axis,
                                                        gdouble min,
                                                        gdouble max);
void            gwy_graph_axis_get_range               (GwyGraphAxis *axis,
                                                        gdouble *min,
                                                        gdouble *max);
void            gwy_graph_axis_get_requested_range     (GwyGraphAxis *axis,
                                                        gdouble *min,
                                                        gdouble *max);
gdouble         gwy_graph_axis_get_magnification       (GwyGraphAxis *axis);
const gchar*    gwy_graph_axis_get_magnification_string(GwyGraphAxis *axis);
void            gwy_graph_axis_set_label               (GwyGraphAxis *axis,
                                                        const gchar *label);
const gchar*    gwy_graph_axis_get_label               (GwyGraphAxis *axis);
GwyUnit*        gwy_graph_axis_get_unit                (GwyGraphAxis *axis);
void            gwy_graph_axis_enable_label_edit       (GwyGraphAxis *axis,
                                                        gboolean enable);
gdouble*        gwy_graph_axis_get_major_ticks         (GwyGraphAxis *axis,
                                                        guint *nticks);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
