-- Object store tables.

create table objects (
    store_user varchar not null,
    object_uid varchar not null,
    object_text varchar not null,
    status varchar not null, -- 'active', 'cancelled'
    primary key(store_user, object_uid)
);

create table countered_objects (
    store_user varchar not null,
    other varchar not null,
    object_uid varchar not null,
    object_text varchar not null,
    primary key(store_user, object_uid)
);

create table recurrences (
    store_user varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar not null,
    object_text varchar not null,
    status varchar not null, -- 'active', 'cancelled'
    primary key(store_user, object_uid, object_recurrenceid)
);

create table countered_recurrences (
    store_user varchar not null,
    other varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar not null,
    object_text varchar not null,
    primary key(store_user, object_uid, object_recurrenceid)
);

-- Object store free/busy details.

create table freebusy (
    store_user varchar not null,
    "start" varchar not null,
    "end" varchar not null,
    object_uid varchar,
    transp varchar,
    object_recurrenceid varchar,
    summary varchar,
    organiser varchar
);

create index freebusy_start on freebusy(store_user, "start");
create index freebusy_end on freebusy(store_user, "end");

create table freebusy_offers (
    store_user varchar not null,
    "start" varchar not null,
    "end" varchar not null,
    object_uid varchar,
    transp varchar,
    object_recurrenceid varchar,
    summary varchar,
    organiser varchar,
    expires varchar
);

create index freebusy_offers_start on freebusy_offers(store_user, "start");
create index freebusy_offers_end on freebusy_offers(store_user, "end");

create table freebusy_other (
    store_user varchar not null,
    other varchar not null,
    "start" varchar not null,
    "end" varchar not null,
    object_uid varchar,
    transp varchar,
    object_recurrenceid varchar,
    summary varchar,
    organiser varchar,
    attendee varchar -- used by quotas
);

create index freebusy_other_start on freebusy_other(store_user, other, "start");
create index freebusy_other_end on freebusy_other(store_user, other, "end");

create table freebusy_providers (
    store_user varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar
);

create index freebusy_providers_store_user on freebusy_providers(store_user);

create table freebusy_provider_datetimes (
    store_user varchar not null,
    "start" varchar
);

create index freebusy_provider_datetimes_store_user on freebusy_provider_datetimes(store_user);

-- Object store request details.

create table requests (
    store_user varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar,
    request_type varchar
);

create index requests_object_uid on requests(store_user, object_uid);



-- Journal store tables.

create table quota_delegates (
    quota varchar not null,
    store_user varchar not null,
    primary key(quota, store_user)
);

-- Journal user groups and limits.

create table quota_limits (
    quota varchar not null,
    user_group varchar not null,
    quota_limit varchar not null,
    primary key(quota, user_group)
);

create table user_groups (
    quota varchar not null,
    store_user varchar not null,
    user_group varchar not null,
    primary key(quota, store_user, user_group)
);

-- Separate object store tables.

create table journal_objects (
    store_user varchar not null,
    object_uid varchar not null,
    object_text varchar not null,
    status varchar not null, -- 'active', 'cancelled'
    primary key(store_user, object_uid)
);

create table journal_recurrences (
    store_user varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar not null,
    object_text varchar not null,
    status varchar not null, -- 'active', 'cancelled'
    primary key(store_user, object_uid, object_recurrenceid)
);

-- Separate object store free/busy details.

create table journal_freebusy_other (
    store_user varchar not null,
    other varchar not null,
    "start" varchar not null,
    "end" varchar not null,
    object_uid varchar,
    transp varchar,
    object_recurrenceid varchar,
    summary varchar,
    organiser varchar,
    attendee varchar -- used by quotas
);

create index journal_freebusy_other_start on journal_freebusy_other(store_user, other, "start");
create index journal_freebusy_other_end on journal_freebusy_other(store_user, other, "end");

create table journal_freebusy_providers (
    store_user varchar not null,
    object_uid varchar not null,
    object_recurrenceid varchar
);

create index journal_freebusy_providers_store_user on journal_freebusy_providers(store_user);

create table journal_freebusy_provider_datetimes (
    store_user varchar not null,
    "start" varchar
);

create index journal_freebusy_provider_datetimes_store_user on journal_freebusy_provider_datetimes(store_user);
