Contributing to Janus
=====================

If you really want to help, then first of all, thank you! Janus is a
project we firmly believe in, and so any contribution is more than
welcome to make it better.

If you want to open an issue, please make sure that:

1. you actually found a bug: for generic questions, use the
[meetecho-janus](http://groups.google.com/d/forum/meetecho-janus)
group instead;
2. nobody opened the same bug already (do a search);
3. the issue wasn't already solved;
4. you don't paste a huge amount of text in the issue or comments: use
a service like [pastebin](http://pastebin.com/) or similar;
5. you provide a GDB stacktrace if Janus crashed on you, and/or output
from AddressSanitizer or Valgrind (more details available
[here](http://janus.conf.meetecho.com/docs/debug.html)).

If you want to contribute to the project by providing fixes, enhancements,
new features or other materials, then just clone the repo, make your changes, push to
your fork (good commit messages that explain what changed are welcome!)
and submit a pull request. Please make sure that, especially if you're
modifying the C code, you follow the same coding style we're using and
that you properly comment the code as we usually do ourselves.

That said, please beware that we do require all contributors to
<a href="https://cla.conf.meetecho.com/janus">sign the Contributor License Agreement</a>
before we can accept any code.
