The main coroutines guide has moved to the [docs folder](docs/coroutines-guide.md) and split up into smaller documents.

## Table of contents

<!--- TOC_REF docs/basics.md -->
* <a name='coroutine-basics'></a>[Coroutine basics](docs/basics.md#coroutine-basics)
  * <a name='your-first-coroutine'></a>[Your first coroutine](docs/basics.md#your-first-coroutine)
  * <a name='bridging-blocking-and-non-blocking-worlds'></a>[Bridging blocking and non-blocking worlds](docs/basics.md#bridging-blocking-and-non-blocking-worlds)
  * <a name='waiting-for-a-job'></a>[Waiting for a job](docs/basics.md#waiting-for-a-job)
  * <a name='structured-concurrency'></a>[Structured concurrency](docs/basics.md#structured-concurrency)
  * <a name='scope-builder'></a>[Scope builder](docs/basics.md#scope-builder)
  * <a name='extract-function-refactoring'></a>[Extract function refactoring](docs/basics.md#extract-function-refactoring)
  * <a name='coroutines-are-light-weight'></a>[Coroutines ARE light-weight](docs/basics.md#coroutines-are-light-weight)
  * <a name='global-coroutines-are-like-daemon-threads'></a>[Global coroutines are like daemon threads](docs/basics.md#global-coroutines-are-like-daemon-threads)
<!--- TOC_REF docs/cancellation-and-timeouts.md -->
* <a name='cancellation-and-timeouts'></a>[Cancellation and timeouts](docs/cancellation-and-timeouts.md#cancellation-and-timeouts)
  * <a name='cancelling-coroutine-execution'></a>[Cancelling coroutine execution](docs/cancellation-and-timeouts.md#cancelling-coroutine-execution)
  * <a name='cancellation-is-cooperative'></a>[Cancellation is cooperative](docs/cancellation-and-timeouts.md#cancellation-is-cooperative)
  * <a name='making-computation-code-cancellable'></a>[Making computation code cancellable](docs/cancellation-and-timeouts.md#making-computation-code-cancellable)
  * <a name='closing-resources-with-finally'></a>[Closing resources with finally](docs/cancellation-and-timeouts.md#closing-resources-with-finally)
  * <a name='run-non-cancellable-block'></a>[Run non-cancellable block](docs/cancellation-and-timeouts.md#run-non-cancellable-block)
  * <a name='timeout'></a>[Timeout](docs/cancellation-and-timeouts.md#timeout)
<!--- TOC_REF docs/composing-suspending-functions.md -->
* <a name='composing-suspending-functions'></a>[Composing suspending functions](docs/composing-suspending-functions.md#composing-suspending-functions)
  * <a name='sequential-by-default'></a>[Sequential by default](docs/composing-suspending-functions.md#sequential-by-default)
  * <a name='concurrent-using-async'></a>[Concurrent using async](docs/composing-suspending-functions.md#concurrent-using-async)
  * <a name='lazily-started-async'></a>[Lazily started async](docs/composing-suspending-functions.md#lazily-started-async)
  * <a name='async-style-functions'></a>[Async-style functions](docs/composing-suspending-functions.md#async-style-functions)
  * <a name='structured-concurrency-with-async'></a>[Structured concurrency with async](docs/composing-suspending-functions.md#structured-concurrency-with-async)
<!--- TOC_REF docs/coroutine-context-and-dispatchers.md -->
* <a name='coroutine-context-and-dispatchers'></a>[Coroutine context and dispatchers](docs/coroutine-context-and-dispatchers.md#coroutine-context-and-dispatchers)
  * <a name='dispatchers-and-threads'></a>[Dispatchers and threads](docs/coroutine-context-and-dispatchers.md#dispatchers-and-threads)
  * <a name='unconfined-vs-confined-dispatcher'></a>[Unconfined vs confined dispatcher](docs/coroutine-context-and-dispatchers.md#unconfined-vs-confined-dispatcher)
  * <a name='debugging-coroutines-and-threads'></a>[Debugging coroutines and threads](docs/coroutine-context-and-dispatchers.md#debugging-coroutines-and-threads)
  * <a name='jumping-between-threads'></a>[Jumping between threads](docs/coroutine-context-and-dispatchers.md#jumping-between-threads)
  * <a name='job-in-the-context'></a>[Job in the context](docs/coroutine-context-and-dispatchers.md#job-in-the-context)
  * <a name='children-of-a-coroutine'></a>[Children of a coroutine](docs/coroutine-context-and-dispatchers.md#children-of-a-coroutine)
  * <a name='parental-responsibilities'></a>[Parental responsibilities](docs/coroutine-context-and-dispatchers.md#parental-responsibilities)
  * <a name='naming-coroutines-for-debugging'></a>[Naming coroutines for debugging](docs/coroutine-context-and-dispatchers.md#naming-coroutines-for-debugging)
  * <a name='combining-context-elements'></a>[Combining context elements](docs/coroutine-context-and-dispatchers.md#combining-context-elements)
  * <a name='cancellation-via-explicit-job'></a>[Cancellation via explicit job](docs/coroutine-context-and-dispatchers.md#cancellation-via-explicit-job)
  * <a name='thread-local-data'></a>[Thread-local data](docs/coroutine-context-and-dispatchers.md#thread-local-data)
<!--- TOC_REF docs/exception-handling.md -->
* <a name='exception-handling'></a>[Exception handling](docs/exception-handling.md#exception-handling)
  * <a name='exception-propagation'></a>[Exception propagation](docs/exception-handling.md#exception-propagation)
  * <a name='coroutineexceptionhandler'></a>[CoroutineExceptionHandler](docs/exception-handling.md#coroutineexceptionhandler)
  * <a name='cancellation-and-exceptions'></a>[Cancellation and exceptions](docs/exception-handling.md#cancellation-and-exceptions)
  * <a name='exceptions-aggregation'></a>[Exceptions aggregation](docs/exception-handling.md#exceptions-aggregation)
* <a name='supervision'></a>[Supervision](docs/exception-handling.md#supervision)
  * <a name='supervision-job'></a>[Supervision job](docs/exception-handling.md#supervision-job)
  * <a name='supervision-scope'></a>[Supervision scope](docs/exception-handling.md#supervision-scope)
  * <a name='exceptions-in-supervised-coroutines'></a>[Exceptions in supervised coroutines](docs/exception-handling.md#exceptions-in-supervised-coroutines)
<!--- TOC_REF docs/channels.md -->
* <a name='channels-experimental'></a>[Channels (experimental)](docs/channels.md#channels-experimental)
  * <a name='channel-basics'></a>[Channel basics](docs/channels.md#channel-basics)
  * <a name='closing-and-iteration-over-channels'></a>[Closing and iteration over channels](docs/channels.md#closing-and-iteration-over-channels)
  * <a name='building-channel-producers'></a>[Building channel producers](docs/channels.md#building-channel-producers)
  * <a name='pipelines'></a>[Pipelines](docs/channels.md#pipelines)
  * <a name='prime-numbers-with-pipeline'></a>[Prime numbers with pipeline](docs/channels.md#prime-numbers-with-pipeline)
  * <a name='fan-out'></a>[Fan-out](docs/channels.md#fan-out)
  * <a name='fan-in'></a>[Fan-in](docs/channels.md#fan-in)
  * <a name='buffered-channels'></a>[Buffered channels](docs/channels.md#buffered-channels)
  * <a name='channels-are-fair'></a>[Channels are fair](docs/channels.md#channels-are-fair)
  * <a name='ticker-channels'></a>[Ticker channels](docs/channels.md#ticker-channels)
<!--- TOC_REF docs/shared-mutable-state-and-concurrency.md -->
* <a name='shared-mutable-state-and-concurrency'></a>[Shared mutable state and concurrency](docs/shared-mutable-state-and-concurrency.md#shared-mutable-state-and-concurrency)
  * <a name='the-problem'></a>[The problem](docs/shared-mutable-state-and-concurrency.md#the-problem)
  * <a name='volatiles-are-of-no-help'></a>[Volatiles are of no help](docs/shared-mutable-state-and-concurrency.md#volatiles-are-of-no-help)
  * <a name='thread-safe-data-structures'></a>[Thread-safe data structures](docs/shared-mutable-state-and-concurrency.md#thread-safe-data-structures)
  * <a name='thread-confinement-fine-grained'></a>[Thread confinement fine-grained](docs/shared-mutable-state-and-concurrency.md#thread-confinement-fine-grained)
  * <a name='thread-confinement-coarse-grained'></a>[Thread confinement coarse-grained](docs/shared-mutable-state-and-concurrency.md#thread-confinement-coarse-grained)
  * <a name='mutual-exclusion'></a>[Mutual exclusion](docs/shared-mutable-state-and-concurrency.md#mutual-exclusion)
  * <a name='actors'></a>[Actors](docs/shared-mutable-state-and-concurrency.md#actors)
<!--- TOC_REF docs/select-expression.md -->
* <a name='select-expression-experimental'></a>[Select expression (experimental)](docs/select-expression.md#select-expression-experimental)
  * <a name='selecting-from-channels'></a>[Selecting from channels](docs/select-expression.md#selecting-from-channels)
  * <a name='selecting-on-close'></a>[Selecting on close](docs/select-expression.md#selecting-on-close)
  * <a name='selecting-to-send'></a>[Selecting to send](docs/select-expression.md#selecting-to-send)
  * <a name='selecting-deferred-values'></a>[Selecting deferred values](docs/select-expression.md#selecting-deferred-values)
  * <a name='switch-over-a-channel-of-deferred-values'></a>[Switch over a channel of deferred values](docs/select-expression.md#switch-over-a-channel-of-deferred-values)
<!--- END -->
