/*
 * Copyright (c) 2017 Cray Inc. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef _GNIX_PROGRESS_H_
#define _GNIX_PROGRESS_H_

#include "gnix_util.h"

/*
 * Progress common code
 */

struct gnix_prog_set {
	struct dlist_entry prog_objs;
	rwlock_t lock;
	int requires_lock;
};

int _gnix_prog_progress(struct gnix_prog_set *set);
int _gnix_prog_obj_add(struct gnix_prog_set *set, void *obj,
		       int (*prog_fn)(void *data));
int _gnix_prog_obj_rem(struct gnix_prog_set *set, void *obj,
		       int (*prog_fn)(void *data));
int _gnix_prog_init(struct gnix_prog_set *set);
int _gnix_prog_fini(struct gnix_prog_set *set);

#endif /* _GNIX_PROGRESS_H_ */

