/* ----- encode/1277x7879, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1277x7879_checksums[] = {
  "874f6a1453352eca4a08618cc88c78c7d798edf2c91aa173c3b0be7f72427559",
  "73815848894e97f8bf4fdb4d097a9021b4f978b13e7db123278e60901bfd0afb",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1277x7879_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1277x7879_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1277x7879_ITEMBYTES

static void *storage_encode_1277x7879_s;
static unsigned char *test_encode_1277x7879_s;
static void *storage_encode_1277x7879_x;
static unsigned char *test_encode_1277x7879_x;
static void *storage_encode_1277x7879_s2;
static unsigned char *test_encode_1277x7879_s2;
static void *storage_encode_1277x7879_x2;
static unsigned char *test_encode_1277x7879_x2;

#define precomputed_encode_1277x7879_NUM 4

static const unsigned char precomputed_encode_1277x7879_s[precomputed_encode_1277x7879_NUM][crypto_encode_STRBYTES] = {
  {236,248,165,97,43,217,218,165,85,141,52,190,1,108,250,36,228,242,174,44,195,134,200,121,5,227,28,78,81,11,11,131,65,239,42,30,152,89,117,171,68,59,192,225,130,205,152,104,39,198,145,45,245,254,105,23,27,134,61,93,104,111,16,72,186,195,172,2,84,196,181,251,127,173,148,159,87,13,145,33,191,68,150,44,121,86,194,90,167,185,234,71,20,183,187,195,220,191,146,196,213,53,53,86,8,4,54,140,19,215,167,167,210,175,6,221,102,64,174,241,105,128,121,232,183,245,173,237,77,31,70,111,38,199,165,181,219,125,203,43,250,4,13,7,24,60,56,41,5,250,190,38,217,148,132,163,34,191,226,91,104,200,205,222,179,49,246,178,146,184,242,130,86,30,18,126,32,132,245,41,4,45,113,59,103,38,210,159,216,104,168,73,225,182,223,5,166,136,73,189,251,227,91,110,255,199,10,97,18,185,102,92,102,40,77,71,231,171,111,110,179,166,75,138,134,33,245,221,31,47,185,230,164,239,53,61,254,129,24,110,164,110,41,154,250,50,26,69,80,206,14,235,207,19,36,95,97,99,220,59,73,225,255,189,197,202,136,104,26,129,192,134,54,23,180,102,128,169,154,59,115,216,141,195,67,211,167,140,252,248,101,182,43,175,69,221,66,2,149,18,238,226,202,43,46,90,77,50,221,76,237,34,12,129,148,52,130,186,243,241,187,136,99,217,231,30,8,61,190,252,37,72,111,144,77,145,6,143,85,152,190,92,139,139,12,241,224,136,75,251,189,96,97,119,225,86,181,56,29,62,247,189,182,89,250,113,104,199,147,23,135,75,244,96,210,40,6,171,87,22,66,68,202,221,155,101,112,12,250,247,176,121,246,73,209,65,1,237,156,189,152,167,89,192,86,254,6,210,218,213,28,142,224,206,235,163,221,252,192,159,222,240,9,160,170,171,142,201,249,100,122,40,76,47,7,126,98,180,50,225,100,231,211,178,200,110,152,99,135,123,234,239,21,107,23,240,106,223,39,181,51,184,224,68,53,62,95,42,204,145,180,25,39,14,33,133,201,16,230,102,5,1,22,86,158,39,136,138,26,144,230,70,31,226,70,61,30,243,126,24,35,95,38,250,27,84,45,125,115,1,114,53,220,157,218,48,227,144,121,55,206,225,51,240,183,220,205,27,232,223,236,253,69,170,169,29,122,154,158,226,0,215,199,14,113,109,76,129,245,120,144,49,237,75,38,242,186,171,93,48,74,28,168,233,205,85,133,117,31,160,216,195,205,100,242,45,220,176,106,210,72,123,248,253,38,121,130,66,6,183,26,68,72,60,16,118,211,199,119,97,147,46,203,50,95,77,142,42,172,173,221,237,53,132,101,104,50,16,25,78,33,204,172,244,215,104,159,35,241,82,254,143,39,176,220,211,45,53,147,22,162,126,62,31,84,92,3,248,112,210,143,31,68,43,88,218,76,31,154,148,254,81,208,65,45,50,147,94,223,231,136,7,202,73,142,37,246,0,175,49,205,223,86,250,252,43,142,120,70,152,17,118,92,120,123,237,198,177,176,71,25,250,170,123,181,61,64,50,214,44,228,93,149,177,53,149,9,68,118,222,38,126,54,208,34,184,4,88,9,236,65,215,219,15,250,226,95,236,142,82,87,73,127,214,6,153,192,89,59,207,150,31,22,213,236,223,101,23,202,66,239,214,106,180,165,238,46,118,58,38,130,159,154,60,113,213,180,200,122,72,183,69,47,70,189,188,243,237,211,177,222,192,121,23,158,139,9,238,248,89,6,81,239,69,201,215,118,242,120,10,78,226,100,154,116,87,118,255,226,12,191,20,51,162,211,150,203,227,253,211,107,22,54,129,35,79,28,9,135,196,30,94,140,214,182,14,132,6,218,154,91,20,135,37,189,250,109,7,99,151,165,169,111,63,74,157,133,64,46,84,25,193,31,145,23,211,149,111,133,40,88,225,116,209,241,133,186,167,85,75,34,128,48,40,39,216,195,24,35,225,157,204,32,181,132,181,50,105,114,231,161,175,200,163,144,183,219,121,165,149,112,13,142,91,193,206,128,158,2,97,32,121,91,219,61,213,202,85,78,101,130,213,119,135,173,231,150,81,175,181,157,83,192,235,49,242,112,213,132,1,214,116,62,89,254,89,200,246,211,168,214,124,175,171,90,255,90,128,3,236,124,182,211,10,115,160,163,208,222,234,239,247,56,207,207,85,70,76,206,33,94,211,44,8,51,129,255,229,14,62,93,177,115,247,45,7,16,223,97,88,7,107,35,59,242,117,33,122,42,248,163,101,119,173,165,20,105,238,148,33,237,54,178,218,226,49,237,237,233,154,117,65,255,45,12,163,234,139,253,76,177,180,99,201,19,133,210,125,24,221,48,32,145,166,252,95,176,126,37,22,179,168,234,72,237,207,129,7,110,99,18,55,65,161,131,166,238,16,68,182,44,85,165,136,38,191,28,149,13,14,58,202,62,193,237,105,220,103,160,143,50,80,39,205,200,247,160,42,209,71,32,121,117,66,95,51,99,216,12,195,228,100,92,23,81,11,116,25,25,119,149,80,201,188,185,55,48,56,156,87,29,188,66,165,192,146,102,150,1,168,169,43,83,182,196,176,233,140,62,111,156,83,179,34,217,181,36,178,70,86,221,217,153,91,96,24,63,138,38,199,15,79,85,158,116,105,165,165,234,186,228,119,173,189,171,39,224,84,125,80,158,224,216,33,85,217,126,37,25,79,218,87,251,35,186,77,101,75,42,6,11,17,56,39,243,226,150,45,177,246,117,209,178,12,159,59,43,141,64,212,8,90,91,2,9,74,41,205,133,114,243,224,247,248,193,164,96,245,52,8,23,116,12,167,198,139,45,204,129,121,136,250,246,170,218,14,42,63,152,108,253,204,71,147,131,106,34,227,67,18,19,207,122,236,249,168,216,157,193,40,43,136,68,112,207,11,71,203,248,74,235,155,171,86,6,124,107,154,112,123,2,3,103,208,70,3,176,235,1,196,184,96,76,82,89,214,249,251,223,177,237,67,116,120,247,182,10,193,94,97,152,46,135,59,155,56,225,139,227,36,45,223,61,234,42,44,170,198,13,232,160,116,97,127,149,193,173,77,193,176,11,99,221,148,172,232,73,47,93,2,141,195,187,145,126,246,96,167,24,152,81,246,170,21,212,89,177,146,149,230,166,51,198,121,188,37,44,229,246,155,9,22,34,3,138,231,209,250,190,246,238,45,241,138,128,182,220,155,98,142,184,90,173,145,99,38,172,120,64,134,147,149,112,173,22,162,68,126,78,8,245,47,224,56,240,178,86,0,165,247,150,17,116,109,188,102,76,10,105,186,55,206,45,160,254,139,146,217,104,78,18,51,99,149,202,64,118,81,197,2,193,42,160,159,67,110,61,148,136,253,241,67,19,254,45,66,171,94,167,255,126,77,228,213,196,95,24,143,89,252,139,240,38,101,229,155,242,10,117,209,72,60,22,195,245,59,81,14,10,245,138,177,174,55,197,114,168,28,133,230,223,69,113,37,169,116,188,249,191,206,210,223,173,83,32,106,76,67,232,162,42,230,231,59,214,89,140,133,120,132,240,27,145,245,108,116,218,40,162,125,65,232,175,175,156,237,186,82,186,135,115,30,90,10,123,187,67,247,35,179,246,228,40,174,73,208,105,125,23,40,147,150,65,168,176,165,216,169,89,133,197,94,247,214,221,101,61,154,9,72,99,5,139,179,111,135,149,101,29,72,190,136,37,88,117,53,75,55,36,98,89,116,73,244,149,44,192,130,216,241,151,130,236,103,87,145,231,81,40,2,21,49,234,219,158,74,116,102,70,154,5,30,30,126,74,200,128,22,10,208,104,181,86,74,102,56,110,248,78,91,154,225,4,132,126,251,203,60,139,227,165,134,54,16,128,153,121,109,89,199,203,234,185,9,234,168,241,124,222,228,148,60,173,81,31,52,205,145,212,112,158,200,231,180,199,217,122,199,34,158,20,98,9,18,22,220,47,1,2,13,24,83,23,223,250,137,149,238,183,147,177,66,89,63,224,149,39,253,35,166,250,201,67,107,41,142,247,207,196,100,171,15,20,72,244,144,77,144,235,75,51,141,218,106,17,98,10,157,195,134,160,201,142,238,120,51,204,125,13,205,244,92,111,164,232,134,45,4,24,188,208,194,40,160,68,223,100,62,20,250,227,200,203,249,177,46,63,164,94,202,210,155,82,229,248,193,83,139,99,203,152,17,255,170,228,116,193,117,238,23,250,196,249,16,180,200,12,179,134,98,61,251,103,164,126,169,12,28,214,105,53,174,152,110,156,4,241,162,16,60,207,184,34,180,35,69,152,251,194,204,59,124,39,100,148,198,240,35,231,189,146,81,215,47,254,214,19,192,36,67,210,204,58,13,254,129,2,50,62,191,141,192,31,62,251,219,119,82,96,147,123,198,23,14,12,97,58,81,65,254,203,233,141,203,75,239,203,161,153,235,239,217,253,34,38,146,8,56,173,243,73,87,90,227,138,144,159,117,114,27,234,9,1,93,39,101,156,182,106,222,163,122,253,46,61,164,0,115,72,62,204,33,70,68,192,207,132,47,112,113,212,126,213,227,169,162,18},
  {86,126,239,128,202,102,152,127,231,120,122,137,40,102,188,245,18,96,54,139,105,124,84,11,4,62,140,51,218,92,127,140,99,97,100,96,154,250,184,221,142,69,136,189,85,231,234,153,168,59,167,243,14,167,70,127,68,14,29,145,87,183,249,69,219,224,143,60,32,54,198,14,217,146,76,29,64,82,71,85,71,54,98,126,151,194,230,116,237,148,201,78,19,143,26,63,21,61,72,158,235,236,90,83,170,54,135,44,58,34,169,134,222,156,97,145,21,60,251,40,224,90,243,28,214,26,165,228,107,149,16,44,88,237,211,143,36,23,199,231,143,188,67,73,94,23,65,238,129,23,31,209,107,217,85,214,183,174,140,210,167,57,235,173,225,91,152,121,18,242,89,135,140,100,227,35,129,167,243,209,218,17,170,4,34,147,237,229,12,183,41,183,176,105,18,125,211,132,241,60,247,186,127,161,34,168,198,174,215,33,157,26,104,0,185,163,215,3,213,98,127,23,177,65,59,69,234,23,212,235,26,135,163,189,215,76,141,184,82,223,222,171,160,65,6,218,106,95,52,166,70,81,135,164,217,114,121,46,235,192,14,225,118,232,186,23,188,173,49,74,66,55,88,240,77,55,73,45,166,57,8,31,77,216,149,2,174,183,160,240,217,16,179,242,13,147,64,49,60,155,163,130,49,232,210,93,221,167,47,216,195,244,215,174,215,251,77,232,78,102,11,238,193,175,116,236,0,64,119,12,98,179,51,165,51,179,238,239,114,115,213,221,205,150,22,109,141,186,49,3,246,70,72,41,207,136,139,201,171,110,124,167,255,243,242,246,242,175,108,251,38,44,107,246,243,200,60,183,37,70,105,217,231,189,95,98,40,104,175,107,47,19,93,93,202,101,38,126,142,17,69,69,183,255,24,247,73,36,214,66,163,145,45,111,102,131,95,153,45,61,15,176,213,211,76,35,110,54,178,179,77,82,116,144,114,145,184,146,199,129,213,25,79,113,21,250,111,159,108,134,243,52,134,60,7,42,235,225,218,80,103,214,194,92,182,242,186,155,236,30,230,113,105,202,123,155,115,26,206,14,197,21,50,254,215,16,72,94,238,117,165,10,177,234,125,123,101,249,224,99,154,28,255,240,77,229,200,255,100,59,148,58,207,145,172,97,205,21,211,124,120,170,145,188,194,75,118,202,75,246,41,156,81,126,71,152,14,80,109,162,97,100,149,35,244,39,82,131,147,170,9,91,167,87,212,111,242,143,29,79,16,137,50,79,243,224,56,242,48,71,156,56,185,18,74,112,67,207,164,224,162,77,178,234,38,249,151,158,4,206,63,59,41,31,226,217,9,160,54,99,161,225,89,172,208,144,70,237,205,28,0,38,187,69,220,26,7,232,33,106,94,212,216,128,62,3,19,91,38,74,174,71,75,173,118,92,194,101,10,11,236,247,65,174,35,89,60,113,210,212,134,252,66,145,180,80,73,222,198,209,213,47,122,172,3,0,5,83,18,127,52,87,137,22,112,187,181,236,44,12,218,14,246,134,234,121,157,84,98,133,245,228,253,252,226,216,218,179,82,53,150,16,24,36,26,33,164,62,114,80,73,48,197,236,237,242,122,26,17,2,94,60,138,13,33,160,149,89,152,181,8,58,233,49,171,18,89,18,1,90,166,186,92,68,11,149,163,159,228,244,199,3,20,224,36,75,134,15,4,88,37,7,139,240,174,195,194,113,125,128,11,35,222,11,145,252,77,86,99,129,121,68,20,136,158,86,35,145,206,67,125,138,133,231,55,220,133,15,226,0,227,138,216,85,251,41,69,91,113,22,102,228,159,97,175,52,85,237,184,203,221,177,253,138,139,183,1,31,169,247,231,212,212,92,158,27,199,12,118,186,75,233,47,143,153,151,204,136,205,179,218,77,186,242,73,140,67,17,231,225,45,232,115,63,97,83,122,60,168,53,102,231,34,40,223,143,35,230,122,236,41,204,120,103,212,189,18,255,94,96,193,72,137,56,160,37,20,190,213,208,79,136,134,24,113,101,35,22,62,205,177,193,88,232,217,13,185,167,204,215,161,245,70,241,81,0,130,43,95,7,8,85,0,61,170,247,6,8,188,221,193,144,30,106,102,78,124,61,215,206,249,247,25,160,172,232,164,219,235,39,198,226,59,223,210,28,160,4,158,0,62,137,104,24,36,225,66,7,141,120,129,30,165,255,243,204,112,242,110,76,102,91,131,81,167,70,180,241,77,169,236,179,170,95,21,81,224,191,130,111,98,199,125,56,3,123,95,57,151,23,169,251,115,126,210,188,236,228,200,72,65,109,132,229,180,238,13,238,12,173,81,188,209,152,15,146,135,99,119,50,197,108,75,106,243,220,134,167,169,132,54,94,113,24,141,117,225,82,148,196,162,102,102,41,45,125,65,59,242,226,120,0,44,135,197,9,253,75,133,170,26,69,203,101,26,163,252,63,156,67,33,37,241,54,14,89,5,206,191,115,249,31,82,248,6,37,82,145,152,21,57,90,38,249,212,236,1,55,40,109,59,95,212,111,224,230,170,120,15,189,151,170,246,140,233,14,241,88,62,67,241,99,247,26,37,168,83,9,128,87,227,145,132,23,19,207,150,165,3,52,14,109,83,69,71,40,52,104,14,18,44,211,164,218,39,248,134,64,105,247,231,5,132,84,114,250,34,62,211,138,82,92,169,124,157,15,84,141,23,200,55,70,100,23,81,46,181,96,222,137,238,255,130,132,195,151,75,220,115,21,166,97,6,196,144,213,230,156,5,78,161,253,7,85,119,153,179,89,112,227,125,114,59,147,82,146,116,118,12,71,113,24,142,217,224,51,104,41,47,135,63,219,168,185,44,161,11,207,17,51,158,49,112,231,64,235,83,95,154,127,38,45,235,175,149,56,242,0,93,175,230,207,214,126,223,124,84,207,0,235,127,142,198,248,10,202,131,10,190,201,244,95,112,9,28,245,244,170,5,92,98,71,52,44,253,255,131,184,156,93,102,68,219,99,241,34,93,158,61,51,192,167,184,222,104,52,5,183,252,213,70,82,54,213,207,108,28,160,130,97,15,57,244,116,122,158,1,159,188,49,215,190,14,96,73,134,125,21,202,124,152,11,106,52,77,137,41,222,45,92,229,44,41,114,30,179,114,44,1,197,91,66,28,122,136,75,212,150,33,45,139,82,245,248,128,109,167,128,33,238,10,207,92,220,92,71,191,29,58,132,181,176,82,81,61,43,152,204,220,112,240,242,204,15,97,8,194,40,146,207,93,57,254,221,105,215,175,154,1,210,193,143,175,139,254,97,107,250,30,175,155,123,107,76,6,188,117,181,66,183,128,182,230,58,154,95,46,147,80,75,246,219,3,14,68,104,216,105,123,121,33,97,102,44,53,137,88,158,167,106,44,136,39,49,33,35,83,90,109,215,233,211,156,144,195,54,22,159,225,250,223,1,131,221,232,79,202,182,195,78,62,99,221,125,197,245,134,22,126,145,50,42,238,248,224,238,99,5,20,131,148,3,98,238,230,166,248,88,114,84,35,3,124,126,236,195,171,132,126,96,190,171,152,174,74,209,2,82,198,108,6,198,124,102,200,155,209,29,34,98,21,77,84,21,50,171,147,206,114,151,99,239,171,243,73,16,129,215,239,20,224,75,98,237,89,74,149,101,139,32,208,71,198,4,49,10,210,49,92,85,51,245,156,158,35,114,23,98,174,202,135,146,192,104,169,111,120,78,58,182,224,193,255,249,46,197,201,91,149,46,4,218,13,155,213,164,23,243,1,112,182,40,227,207,235,189,195,93,205,205,102,224,42,246,148,194,123,37,32,23,94,141,128,186,93,128,104,77,50,248,220,149,247,152,137,160,255,226,49,129,200,188,207,165,108,92,89,127,138,247,221,152,113,253,182,69,168,59,71,161,53,248,86,85,112,228,86,79,41,147,198,62,178,9,19,167,134,57,154,54,6,64,83,91,161,207,162,6,183,57,229,70,187,148,206,104,0,85,190,223,43,217,185,133,152,49,214,156,203,225,96,176,139,222,136,220,245,223,115,104,39,40,23,181,23,22,50,100,100,225,231,167,247,101,160,101,56,69,139,30,203,88,19,199,210,105,165,182,57,114,214,42,31,118,122,151,162,118,92,230,12,92,89,192,45,231,102,157,105,105,63,124,35,58,56,140,164,251,168,122,134,60,145,185,160,138,217,50,85,189,93,163,153,35,0,86,141,158,31,176,87,183,175,25,160,38,220,18,134,139,174,162,28,131,179,146,97,80,52,41,97,113,154,132,167,185,169,23,4,143,255,112,90,8,62,219,51,95,125,134,208,68,35,60,174,114,169,7,108,1,172,99,118,75,206,216,221,77,54,92,205,4,9,11,246,9,183,78,44,28,148,247,173,127,213,7,187,112,229,240,5,11,179,119,40,249,148,180,156,117,190,87,255,217,97,12,149,74,255,56,97,103,183,141,220,179,229,15,155,5,156,129,46,76,163,190,179,114,82,9,37,212,209,150,46,235,193,29,122,46,166,148,171,15,127,53,51,244,92,255,198,146,63,226,90,61,189,251,191,226,31,108,188,108,118,52,18,53,157,233,240,191,8,95,141,79,193,121,151,175,125,100,23,177,0,45,1},
  {10,247,89,104,206,235,41,199,31,158,217,253,224,255,50,219,98,184,8,36,127,195,4,226,152,94,210,174,62,174,255,141,24,117,11,38,86,96,208,30,13,125,249,151,17,175,103,180,238,3,152,45,116,159,237,222,161,194,11,25,65,227,218,230,18,206,214,33,38,115,134,190,86,45,170,117,233,227,136,193,69,179,7,33,149,109,122,130,223,161,26,22,253,92,231,214,154,172,129,40,248,83,45,151,89,166,107,164,65,192,46,18,185,137,242,56,254,250,171,101,188,79,147,109,90,157,109,56,220,99,94,121,75,14,75,35,192,129,130,92,67,222,63,8,183,161,208,51,254,250,120,72,166,168,161,11,144,203,120,66,118,174,22,55,33,8,67,46,113,176,66,40,239,216,58,204,209,71,130,126,38,33,243,21,248,25,210,28,109,23,0,4,137,16,57,242,90,182,31,20,139,53,251,167,148,120,125,156,199,122,1,26,93,162,195,33,63,55,172,233,146,126,107,222,59,105,67,168,221,211,218,224,46,180,156,23,58,230,150,31,101,50,241,152,108,215,36,253,47,125,109,17,214,118,107,81,143,79,184,212,161,148,137,190,60,140,112,103,11,72,83,199,172,165,255,79,161,137,243,252,82,224,3,111,38,185,86,255,229,123,147,215,204,206,249,224,55,178,136,167,27,199,247,243,77,95,161,92,90,177,93,129,127,97,58,200,84,25,81,125,226,195,121,95,252,122,132,111,198,22,221,164,229,179,166,158,231,23,70,155,211,62,190,2,186,49,64,7,94,56,115,140,247,13,89,229,161,172,106,45,17,143,7,14,21,143,106,129,155,179,191,174,253,51,159,177,178,42,114,251,97,202,172,255,207,54,72,198,198,33,124,9,145,31,114,90,95,179,188,53,86,124,8,16,101,163,135,219,188,147,156,36,95,176,111,103,122,137,11,116,223,243,43,76,33,189,120,179,110,127,56,141,67,173,73,184,75,191,139,154,240,175,126,59,102,24,36,51,103,243,227,188,75,114,56,212,248,68,237,219,15,58,133,174,115,38,154,62,4,236,239,208,6,96,222,105,241,166,26,23,217,139,52,185,229,128,14,46,186,22,160,153,241,113,34,15,230,1,172,153,66,188,200,161,1,48,8,213,85,111,215,152,137,53,132,63,92,76,68,211,53,23,130,115,64,156,229,96,227,190,69,59,87,174,196,133,177,80,124,186,202,91,172,205,46,111,219,95,134,92,8,89,144,228,50,226,67,97,32,16,237,209,105,155,203,184,80,225,86,162,104,80,225,179,64,217,218,180,158,226,51,82,75,127,27,89,233,252,248,128,167,125,35,153,31,132,94,58,193,101,125,159,127,121,103,138,199,103,234,150,82,242,241,160,44,252,192,179,204,81,229,187,219,122,204,191,85,78,193,57,2,250,191,248,185,199,178,195,138,128,219,66,116,120,209,236,54,114,173,64,185,46,88,207,225,21,58,61,203,34,75,148,51,142,231,128,218,244,89,160,5,33,143,144,222,46,91,59,36,254,246,209,38,132,120,208,78,248,34,87,149,59,24,73,190,211,41,101,109,2,185,75,44,108,142,153,6,127,45,7,6,124,108,86,68,91,111,71,109,64,88,234,201,67,241,147,75,169,135,253,205,136,147,54,237,241,1,143,174,89,220,202,244,227,59,70,171,239,116,75,88,216,55,62,176,211,14,67,137,163,143,182,143,36,211,159,41,45,1,187,126,156,225,17,23,230,134,50,156,141,0,89,222,92,88,68,255,6,198,61,205,242,246,132,91,242,176,152,180,245,154,176,203,178,82,152,143,215,42,102,30,99,184,254,192,186,70,164,40,185,117,140,36,61,173,125,246,86,164,156,141,88,194,87,63,62,237,104,31,219,170,147,168,184,202,1,114,5,151,220,59,79,221,115,156,189,255,234,229,243,150,179,227,188,135,218,162,43,52,102,201,191,41,67,95,168,222,79,130,245,240,29,109,109,70,69,180,52,137,123,169,43,248,100,77,87,247,105,14,93,121,150,118,72,132,28,228,24,84,121,9,210,19,116,83,180,245,170,228,151,194,25,243,78,201,196,104,172,140,191,84,207,2,110,16,77,132,138,207,102,221,185,206,85,57,27,39,15,71,140,192,213,190,216,60,248,23,177,162,63,0,152,76,140,169,170,199,227,160,10,67,6,175,225,215,45,192,88,187,202,61,96,231,219,155,88,122,104,223,97,241,176,106,79,37,178,26,87,146,58,168,226,243,210,56,120,170,206,38,249,10,47,100,52,53,202,123,159,83,137,29,107,156,178,105,199,114,79,100,130,162,227,134,60,179,32,194,52,171,139,54,245,239,56,136,14,157,180,182,32,243,140,240,62,57,96,67,13,137,166,15,100,52,149,61,205,231,73,83,138,95,182,67,123,89,231,215,29,59,135,248,160,151,149,9,190,211,179,221,101,228,43,245,207,191,83,130,9,231,34,118,117,46,145,101,61,14,39,123,242,225,154,163,67,15,218,21,144,17,240,87,118,106,139,53,60,223,222,171,143,147,77,171,101,73,125,139,13,118,149,108,68,116,35,21,24,217,200,147,56,226,219,250,122,131,150,40,177,48,243,244,234,5,125,136,189,35,87,9,48,44,184,84,79,223,24,113,158,137,48,118,90,53,61,147,253,225,94,206,170,75,172,24,84,254,231,111,171,11,89,184,161,81,175,144,224,19,3,155,93,84,51,98,173,47,26,25,119,74,200,59,71,44,81,210,216,93,146,78,110,108,124,194,28,110,25,172,131,152,168,236,1,8,104,50,158,154,207,61,13,57,247,130,243,108,201,36,211,206,157,101,87,80,43,137,216,118,39,62,57,170,231,229,3,99,134,120,16,148,177,232,23,129,233,131,85,151,82,254,63,201,188,179,228,97,124,124,98,51,239,44,71,217,203,55,231,44,247,115,100,163,218,43,184,154,148,82,206,71,243,143,47,45,179,6,86,85,79,83,64,125,246,93,80,126,25,106,68,249,111,40,176,187,87,173,18,28,112,90,124,232,243,210,51,18,131,160,187,187,137,102,193,238,98,194,97,188,128,217,197,189,103,15,47,104,18,239,178,172,101,20,179,55,172,242,135,224,130,49,80,208,12,169,238,28,76,177,202,139,246,179,50,72,194,220,239,166,220,176,107,69,199,99,189,208,206,174,123,199,75,164,227,103,77,6,75,103,106,219,88,49,225,140,225,191,251,103,216,242,239,54,9,205,94,160,56,128,156,245,172,152,113,189,102,118,60,98,219,41,140,195,107,217,79,189,200,157,197,62,30,82,0,151,10,130,247,240,9,86,34,69,190,0,254,131,229,195,7,142,66,121,153,118,217,167,122,178,124,65,4,61,131,245,77,161,25,138,226,100,211,111,251,82,125,58,133,116,19,242,131,33,210,61,230,213,92,130,38,51,5,118,123,226,7,79,156,97,57,75,185,137,64,115,136,117,243,234,140,133,243,209,108,7,15,243,233,106,61,29,189,27,50,189,216,81,194,148,18,142,74,162,6,213,164,252,59,203,166,26,58,108,55,13,43,101,197,88,136,151,77,118,143,147,118,184,73,62,64,107,134,92,202,0,236,89,24,117,116,24,6,194,76,223,239,207,139,125,96,255,251,148,30,67,11,240,176,183,246,238,230,153,118,50,209,92,205,0,185,49,219,196,23,140,178,9,12,161,209,75,67,64,255,39,134,113,132,47,228,77,102,153,92,229,237,69,209,42,72,142,46,125,96,65,118,0,166,12,111,1,77,239,125,124,185,188,167,92,182,122,123,81,183,121,49,209,123,235,38,106,124,152,91,248,169,51,75,159,238,20,238,217,2,214,139,176,136,238,225,158,133,55,177,170,148,56,141,203,17,228,92,169,241,205,162,204,60,183,122,44,107,203,98,202,101,180,23,171,188,34,183,88,175,99,108,85,244,86,16,194,230,209,4,169,106,188,182,244,55,62,212,148,125,1,56,40,69,40,137,99,124,235,150,179,202,125,250,241,206,170,246,23,157,57,176,181,225,254,168,95,229,186,68,228,65,27,243,59,152,24,212,252,51,46,103,77,126,14,134,98,67,94,2,186,171,151,192,222,208,52,177,208,68,81,248,246,236,111,86,40,129,80,74,218,237,221,52,26,147,207,208,141,226,63,176,1,77,80,47,100,205,244,163,188,45,0,240,191,203,186,89,84,111,233,96,80,222,225,78,221,66,246,45,90,14,82,138,150,40,39,52,122,74,241,216,52,92,218,111,189,54,47,175,12,138,93,32,212,40,8,98,118,122,121,108,23,18,179,68,58,55,112,79,134,143,240,250,27,155,105,16,179,239,239,70,185,10,73,229,71,78,178,70,111,237,185,110,180,55,62,229,251,248,67,238,89,78,51,32,145,111,156,131,39,67,116,98,157,40,120,205,100,86,119,97,166,211,171,146,93,4,54,62,9,131,51,10,58,149,126,56,104,205,96,10,130,73,19,132,193,88,80,72,109,66,91,35,75,117,101,243,79,149,29,66,169,109,143,79,255,37,35,3,5,186,183,71,146,55,132,203,95,130,131,160,29,60,91,117,125,226,223,126,110,21,73,127,133,145,178,224,59,113,66,135,182,12,67,19,0,70,215,170,90,110,19,7,27},
  {225,169,47,36,148,186,118,228,29,102,182,234,79,64,244,26,20,12,155,209,93,98,177,93,207,183,158,211,143,27,228,196,218,4,56,128,38,32,252,124,173,37,44,232,183,222,128,150,224,27,80,194,173,160,81,0,37,40,86,9,91,8,46,154,50,182,115,141,247,80,203,26,163,101,57,116,84,90,157,42,34,168,212,38,55,153,137,215,81,46,6,47,76,19,206,133,61,78,220,169,38,48,185,199,176,243,15,77,192,60,89,200,38,168,182,89,2,166,157,105,118,105,188,54,192,223,108,88,26,66,172,19,214,159,82,21,199,219,140,107,244,82,217,19,68,26,112,234,22,132,54,71,107,182,0,20,245,109,141,241,102,70,1,79,45,105,248,25,184,23,83,144,183,8,29,169,50,254,248,176,255,207,116,230,55,193,53,32,153,94,184,209,85,86,58,45,73,46,109,238,235,23,31,131,75,238,130,185,167,152,94,101,144,106,125,252,225,93,47,50,77,119,44,85,134,174,113,169,213,243,104,109,222,109,28,102,227,70,133,120,193,145,17,255,118,128,189,140,242,147,200,203,32,36,100,120,72,206,147,109,50,140,206,149,174,146,237,10,20,30,220,240,15,198,146,6,105,21,8,246,153,151,38,174,101,60,176,131,82,155,210,189,40,194,252,138,223,69,11,48,18,88,134,8,146,142,106,101,24,103,252,242,229,205,31,228,236,184,74,150,14,174,64,215,14,203,108,107,233,54,175,225,233,27,215,95,227,37,218,198,58,163,61,0,150,1,243,193,221,196,216,200,167,119,161,170,86,183,42,241,67,91,37,111,79,28,92,169,208,124,153,239,26,34,113,32,168,75,119,253,166,154,229,184,42,99,247,12,184,118,233,111,27,95,22,66,10,194,105,186,230,238,218,229,254,48,224,148,1,23,255,240,19,25,172,190,211,232,11,130,164,150,8,40,166,146,10,247,81,238,65,175,233,120,134,128,205,213,98,36,167,136,211,41,146,15,248,97,222,139,29,176,91,13,3,14,185,24,74,153,6,156,7,205,119,22,174,66,194,233,21,234,43,247,19,67,150,110,129,186,213,151,84,24,139,130,97,17,254,200,59,18,33,225,161,246,141,95,172,205,49,83,55,190,70,104,60,0,180,192,140,46,37,124,114,234,245,205,150,132,84,154,249,73,34,230,143,104,217,28,8,116,172,181,13,138,13,168,57,229,30,138,251,13,230,15,51,51,251,220,132,105,150,51,7,131,179,178,159,160,71,228,240,66,205,61,30,7,229,179,166,6,47,115,150,158,147,172,38,129,58,184,68,43,110,161,208,92,140,20,215,65,27,7,183,173,184,132,156,50,61,192,102,77,123,129,158,204,155,85,77,193,64,151,130,13,240,254,14,237,225,212,189,138,68,172,24,149,9,77,65,245,40,243,199,214,144,89,30,35,237,222,42,203,214,89,75,118,243,33,102,145,176,182,53,10,2,119,109,207,73,88,109,167,132,10,28,0,73,240,60,135,51,28,254,134,204,194,59,19,238,242,4,150,180,185,227,36,207,26,108,219,80,207,208,166,145,185,24,72,219,171,15,206,96,181,18,35,151,194,193,70,189,203,19,232,29,3,53,240,12,197,147,69,142,243,20,19,241,188,160,141,213,50,114,86,181,124,166,180,69,0,51,231,44,6,174,97,86,65,11,112,147,209,88,60,192,112,2,78,3,62,111,135,208,200,211,134,246,190,50,103,220,105,98,84,16,196,232,112,30,150,180,225,107,230,181,239,41,202,239,226,147,56,158,60,182,234,13,1,72,145,21,92,74,0,76,23,155,24,151,62,162,245,210,251,159,186,26,241,21,68,49,248,114,176,71,120,10,81,70,125,212,180,190,22,174,15,192,133,225,113,149,211,231,140,58,219,221,91,150,86,60,146,28,161,118,248,161,245,77,105,63,29,113,113,206,17,165,80,241,214,85,50,59,57,105,113,176,213,168,214,55,82,189,206,255,113,232,31,57,16,86,209,174,191,241,111,209,184,205,96,92,74,52,60,106,203,99,26,14,79,242,184,224,166,55,179,181,69,90,10,163,175,233,42,178,130,9,91,91,46,222,225,200,249,116,58,48,73,180,112,180,193,109,194,178,173,153,80,112,138,252,197,100,1,228,244,10,164,218,11,209,246,67,211,94,249,165,216,125,240,135,154,98,251,52,202,219,115,190,168,235,140,231,107,236,166,91,109,154,81,83,171,0,108,101,0,10,109,1,203,51,171,157,4,42,77,182,155,203,69,123,12,6,202,42,245,213,93,98,194,246,66,227,80,110,157,213,97,96,212,12,144,66,183,253,32,72,106,139,73,248,173,165,66,206,187,168,23,28,54,232,195,128,51,84,56,208,191,237,95,207,236,21,115,4,202,153,31,138,55,127,4,185,59,102,49,84,135,44,196,4,86,201,50,175,25,164,125,170,217,243,169,103,186,197,166,51,220,207,139,249,193,69,111,112,241,67,91,7,109,44,207,73,195,52,215,249,138,30,191,100,71,26,232,178,202,118,172,194,223,236,219,106,142,70,194,163,136,106,234,67,66,17,21,187,209,17,100,41,158,216,154,22,187,161,107,238,212,184,179,232,51,77,11,130,125,181,169,189,82,89,81,96,130,239,75,116,189,212,112,205,84,129,54,160,248,71,204,1,221,25,249,36,31,40,125,73,128,75,7,157,185,7,16,130,166,94,194,102,17,69,36,130,198,211,8,47,175,227,38,240,206,118,158,18,166,92,42,182,28,102,49,111,85,173,212,6,126,69,216,99,220,73,57,78,133,112,59,167,173,86,42,182,255,140,153,132,231,34,52,170,200,189,114,215,55,178,18,43,231,36,114,138,41,124,171,106,223,56,230,124,64,107,153,70,66,252,199,163,251,91,23,104,205,75,21,18,153,222,160,89,130,255,215,49,120,191,65,112,190,241,123,240,47,186,55,159,175,130,166,54,196,107,234,100,123,163,1,1,120,227,219,27,200,61,87,19,58,4,245,75,4,96,193,247,186,250,77,164,51,135,222,62,252,42,184,213,41,3,27,131,47,214,71,44,202,178,108,226,94,198,114,129,248,207,41,103,138,74,80,113,149,34,201,219,49,45,102,93,201,188,136,134,192,252,193,129,72,68,146,93,20,60,205,73,30,0,19,124,236,214,49,112,178,155,224,122,185,23,246,129,76,212,142,224,217,189,14,71,191,166,1,140,253,92,168,131,252,155,41,174,253,246,119,138,44,84,153,192,82,90,216,173,254,161,183,102,161,47,88,41,113,88,68,115,249,7,94,171,208,187,118,57,45,26,70,80,181,254,162,166,132,241,232,246,97,250,111,3,139,241,119,27,128,81,252,71,216,144,89,201,169,205,228,40,152,185,54,243,165,140,116,0,185,78,16,162,253,236,103,197,67,11,204,235,122,224,236,172,13,96,149,106,211,114,27,235,184,111,241,125,241,91,179,239,253,82,137,92,172,171,159,129,136,211,102,48,241,67,170,213,238,99,108,174,108,113,39,15,194,123,117,39,223,165,57,57,178,4,223,125,116,31,191,24,99,176,95,245,26,114,117,183,94,176,78,248,253,172,101,32,145,102,56,173,188,187,2,103,220,214,5,133,249,116,102,253,80,20,152,64,210,205,249,254,208,45,44,88,148,227,65,86,202,53,56,160,141,142,215,106,100,141,73,250,7,201,77,28,145,211,203,118,110,41,83,164,184,93,177,92,20,8,9,53,12,137,59,83,49,202,18,4,36,26,226,130,110,95,228,159,39,6,16,164,36,43,22,5,218,22,117,158,119,186,85,9,171,154,29,216,81,215,190,98,61,246,132,210,153,9,82,151,103,39,190,64,173,182,222,27,156,68,179,106,165,41,27,129,78,228,63,1,120,82,216,54,55,106,49,40,56,113,31,137,158,10,203,132,0,192,225,229,250,106,202,134,159,133,218,124,159,14,185,252,89,147,213,150,169,251,246,17,195,121,159,112,240,182,149,109,216,153,135,162,184,241,118,198,168,184,196,191,233,41,0,176,15,55,37,189,121,108,249,131,163,191,144,50,179,146,151,173,120,133,66,251,218,2,82,11,254,154,5,223,218,215,124,9,138,212,243,155,136,71,147,155,61,12,11,28,76,189,188,167,65,215,229,62,17,19,45,200,129,172,52,73,123,82,10,10,40,67,243,232,81,78,87,22,0,120,221,39,23,139,182,93,105,79,152,3,177,120,28,219,21,80,77,103,179,4,146,253,94,139,83,67,192,239,125,156,207,31,11,38,251,45,175,187,107,72,94,77,226,251,79,125,210,133,240,148,146,25,82,249,118,106,176,230,127,246,78,71,148,12,169,171,192,16,181,120,209,98,121,201,199,109,224,163,99,96,20,126,26,1,25,219,103,176,208,33,159,125,27,9,70,108,23,182,60,237,96,49,226,91,150,239,206,78,107,68,42,72,44,142,190,88,143,171,110,168,131,26,146,54,123,5,174,192,206,38,51,98,153,120,243,174,166,69,222,89,86,72,94,175,253,8,61,207,156,99,184,105,84,120,124,245,135,80,185,160,128,67,80,238,40,162,41,16,96,189,153,10,241,66,75,122,113,154,4,64,143,179,17,207,217,182,231,15,128,94,186,65,113,21},
} ;

static const int16_t precomputed_encode_1277x7879_x[precomputed_encode_1277x7879_NUM][crypto_encode_ITEMS] = {
  {26536,-15692,7360,21771,-6987,-25614,6632,15510,-7944,22995,22709,32161,-6295,28864,4521,-26817,-23988,-15168,-26546,-1352,7928,19701,-15361,-14073,-21847,27356,-27018,3906,-25052,-32125,11177,-23130,-16391,-16240,-31952,19790,24963,-10149,19726,-19079,-21910,-14226,-22267,-15227,9704,15278,-2200,26472,-14496,-3559,31663,-2266,-5861,7022,-3058,9445,-5485,12880,22280,-1733,-18717,25707,-16961,-6081,21623,29117,-8102,-27850,-18312,15196,-19920,2923,9678,-8225,-23442,28610,-13904,26169,28404,-7789,-13788,-27739,-18520,-70,4267,2010,27555,-30975,-16481,8144,-17385,24749,13919,10939,-17617,10540,20380,8152,-16327,13815,-14288,-6581,-7793,-5566,-21435,-15043,8195,-25267,-10600,16069,15858,-1605,9895,-16235,15559,-21279,22198,27368,-26913,-12847,14872,19519,-26193,-5378,-20776,-3775,6864,32595,6662,-18535,28579,15965,10595,20285,-29827,-29008,-9077,-10680,1575,11092,-21377,-6459,23195,6166,-16729,31775,-20128,9088,9133,-28416,14552,-6398,21893,21540,16079,-6469,-19482,24828,11084,7890,17721,-15759,-15935,28844,-4814,-4977,-21263,-21781,-2870,-30704,-31559,3351,-13670,21628,-24381,-2223,-21830,8066,-8176,10251,18341,7873,20050,6401,29462,14143,-5638,13696,21485,22229,-10264,4696,23628,8667,-12952,15081,28331,6469,12287,30846,-27136,1349,-15832,23885,-19701,-3708,22071,-5715,-12004,3186,4220,-6946,30171,27701,-9540,13311,-15127,11562,-17624,-9831,-5647,13638,-251,16034,6562,14100,-3090,11481,9771,-25212,19648,-27817,-18055,11157,-2668,-3985,22739,8341,7160,-12552,12274,-3114,-17807,-9056,-7671,-13153,3387,-18367,-25236,-14828,-5336,17666,12618,10859,-7941,-8793,-17709,-12518,27444,-3024,-9007,20960,26482,28195,-21307,-15336,-22154,4214,-655,27687,-28050,12598,267,-13419,25276,22112,1644,-11676,-27341,-4743,-22324,23097,25435,1622,-4661,-22304,-13573,1804,8490,-3658,-23274,-7343,-22245,-29816,-26973,31846,-21687,-4521,10061,-23408,3501,5583,-23311,8055,20445,-6081,-11529,-17902,-11637,31542,-8458,-11415,5494,3026,-29624,-13460,5818,-22512,25687,11164,-1569,-24484,13879,6540,-11793,-15008,10912,9328,3645,-19825,-6018,10809,-11149,-5572,11069,11144,-27913,8849,-29834,15169,-17963,4839,-8834,23203,-18708,-22792,-11906,-31322,29497,32630,18275,-1042,-16144,15135,-2682,-18715,-12114,32473,25819,29894,10958,24743,-10776,23002,-6460,-28878,-9695,3993,8461,-1694,-3425,10736,-16208,-17484,28197,2307,6526,-29616,-31474,-11897,31596,17554,6895,2405,-23993,28708,2288,-19816,6442,27848,5066,-20734,12562,7700,-3296,-7969,32047,-9802,7427,-18505,-22013,-22821,11859,-15902,-27840,4178,7056,-13838,8223,8069,-11965,-18057,-23941,-3701,31018,-11185,-30641,8986,765,6205,3579,-32483,9153,19344,22512,3726,10936,32402,-29988,32275,-25577,-13411,-276,32440,-24427,7958,18172,-21630,1134,6964,16596,-6392,-23668,23961,26805,21613,-10203,-15347,26597,-30874,4466,-22560,18117,-1208,-25378,4119,23408,-25522,15300,13981,-14307,-7342,-26652,-20164,32356,-14657,-17937,28200,-7244,31552,-8827,369,20766,-30777,1328,9631,27014,-17987,-29958,23244,10684,-9337,-30691,-169,-4053,14349,21401,12465,4592,24734,6301,-13177,9908,-939,20840,-7862,-12042,-10576,-21431,9019,-21860,3673,-14057,17809,-12268,-15655,-28831,-26132,12984,-379,20285,-9925,-20197,16975,-28563,30019,-2321,-15228,-26930,11541,-23744,18714,5346,3903,-9676,17533,18694,32281,30418,-7598,-16199,-31667,-3006,29949,10015,1342,-5661,8649,-16870,-27276,-21223,3577,-13375,-14110,6152,-13209,21533,-14223,-5139,29904,32284,-8444,12847,-23446,1816,30874,-8608,-6162,10284,-25761,-18728,-26858,-5625,-18321,30563,15966,-13279,-13932,-25688,-12567,-21306,30838,-20105,-14830,-20748,21802,13769,-18579,-30261,-24191,-7186,-29202,-19807,-3831,8449,10187,-3050,-27572,13825,6123,29174,6868,-14590,-15198,-23442,-26266,-22979,9682,-23149,-23788,-14238,-12961,-19913,18660,-28874,23975,20246,-32032,14811,-3393,9622,23705,17109,26040,-4417,-702,20670,29444,11451,16330,10547,25018,5057,27349,-27565,-6796,-7798,-16805,-25678,7649,-15207,23179,-28870,-20285,17931,2239,2311,14018,-2515,-8062,-2219,-18589,22235,12189,5609,6485,-24948,-11799,24983,-6793,16441,31250,-21369,21619,-10486,7770,9906,25262,20939,-6703,-2932,7958,-6744,-13136,25377,28332,-5268,15033,-23873,-15368,-4920,-7848,14380,-29302,28584,7938,-22164,7230,21478,8455,16255,22874,-11402,-27592,-26663,17885,9666,-29460,19383,3601,25700,31235,13556,11120,-32033,9884,19760,-13614,-22377,-15049,25216,-14153,1845,22779,13168,-15189,-30763,21845,-8368,-5534,30019,1903,-16318,20269,28732,-20393,854,9421,-16275,-24889,241,-30149,17276,-29298,-16273,30157,-27884,-19032,266,-29663,30283,2930,-31372,10617,25371,12353,-11452,293,22473,-28629,-29592,-17743,-21788,23205,-4901,17813,1229,11917,25691,28728,-4072,24746,-20486,6172,-26810,13890,6354,6125,27597,-17869,-29605,12004,15615,24661,-13844,-3433,-29750,148,19723,15473,12309,-20925,-24042,12148,-21821,7162,19586,19030,-18449,-8651,-18162,-25817,-12827,30078,24138,-9971,-540,-12655,-17319,24270,-17665,-1471,16271,-18210,-30054,-11020,-13561,23814,-28814,-31390,-11937,-30151,-14665,-16096,6249,14264,12045,11879,7820,2764,-7851,13399,-11811,-26023,14648,-18948,13174,-6632,-7591,11847,-25777,-25304,28965,666,-4363,17738,31169,13758,-8236,-18521,22832,-25595,31469,29831,-8008,-20139,4907,-16481,-29286,-21821,11561,-18309,-16171,-19543,14708,6342,-10268,20088,-15787,-15253,-16343,29270,5301,-20298,22127,13658,2434,26069,10383,-5980,29498,10581,16867,19500,30762,-23560,-31200,13195,-26921,-20727,-2239,384,-32277,9540,-7954,-30297,-15181,-18906,-29263,-25436,-25789,-9637,12984,29052,29606,-12683,24069,-26181,-16670,31501,10608,23510,-7329,-9793,19756,-24507,-13755,18858,8035,600,-16692,18623,-6855,14329,-32425,-15485,15099,22313,17455,23997,-5563,-18980,-1842,15694,23398,4766,-6721,12572,4757,-6520,-3573,19083,17800,-25118,-8223,3128,-12533,9723,5454,-15164,-8227,-2115,21410,-2153,11786,-30131,5491,21513,20002,17804,-1101,22225,-15444,4341,-32154,-26727,-28628,17246,6908,31437,5580,6335,-4130,23846,-18805,-5310,-32128,14248,-2554,9386,-29196,23078,-4825,19017,-15089,25265,29890,20962,2113,-7434,14683,-23611,26080,-13615,-31835,-26693,21459,-10663,15493,8362,530,-1954,-19292,6001,-9778,-31413,17985,-9562,15586,26684,30330,9211,-15287,15537,-14206,-16029,-28432,15890,-729,15673,-28296,-19710,26930,-5810,-17870,22031,-19702,9851,-26449,-8511,-13897,-8382,19484,20745,7757,568,-11518,-28774,-8540,371,17422,7767,-12211,-28014,28261,13603,-1300,14395,25088,-14178,-28595,5138,2258,-2229,13754,-811,-13040,-20233,29259,-31865,-16886,15133,-8087,-24441,9622,-14484,-1788,28903,19496,20559,1345,4164,-30055,17794,-21755,11993,-8987,31211,20299,-17194,18485,-2628,-24750,2687,-30662,-1673,18877,-933,6702,13790,-13146,16446,27958,24293,-1391,16981,-14996,23220,2827,-17362,7900,32393,-32175,-7753,-16739,-22968,5792,-17105,7427,6485,-19254,-27248,19350,-12267,-17409,8052,-17266,31416,25153,-22787,-8830,-9442,8238,2793,31762,-3484,19120,30796,-1570,26993,10202,-840,-25707,14887,-2761,-9806,-9356,23152,25144,29040,20034,-28504,8340,-17939,24451,18091,14805,31733,11230,-4211,24200,-5440,6624,-23589,22059,26436,14770,4319,28586,-13914,-9302,27918,-15001,-12421,29619,22410,9075,-4337,31414,-9315,26284,-11289,7816,-31537,-24606,-32631,-3264,-19032,18782,-13334,17192,-20357,-31273,-18347,-26557,15027,20444,13630,4423,-19570,-24839,-20504,32481,13590,-26848,-26796,-1714,29349,28460,-14474,1741,-29743,-31105,12356,26805,-30764,25416,-24484,27886,-23040,-31305,3778,21156,-8069,-6763,-5643,-31965,26140,20946,-20956,15997,-3338,26110,7177,14542,20034,-2615,30556,-393,-13555,10670,29746,13926,9625,-17237,-28904,-20435,24781,26971,-10266,-26147,-10161,12935,6975,-20599,-532,-23271,-17013,17547,23834,26784,-10482,31460,-23223,-11187,-11197,29718,27985,-18715,-10325,-4790,-27825,-5245,-26693,26037,-6934,-11234,-27424,-225,21494,-9813,14846,19460,-10758,-28077,-32148,12862,9923,18077,93,-18473,-20129,-18688,31973,31966,-25451,22371,34,26306,12605,1989,31098,10293,-16058,-6428,-17325,-26484},
  {-12001,8233,16554,7851,-10524,-19198,-14278,14794,-4465,15616,350,-8932,-11466,15766,-31781,29743,-1113,-29867,-18029,-9123,2931,31602,21213,15081,22227,-15265,-11753,-31749,22284,2010,-26675,3542,10532,5345,-4941,-11297,22623,-12539,-16675,-12955,-5687,10027,-4547,10613,24120,5907,25461,1787,-4333,8155,17128,22625,-30561,-29391,31068,-9506,-31576,20380,-32126,24485,-972,-6435,20426,-2191,-13651,5242,-27218,-10449,-31449,-31657,18218,-7780,-29870,-23719,2490,22518,28431,26719,9600,-1767,26259,-7996,25650,-2456,28220,27621,-13102,9572,22953,2228,12005,-24812,9597,-25134,19756,23226,15623,31642,13436,32236,21108,2281,24489,21471,-31304,-20586,-9708,-31475,12613,14459,6105,-25400,-18123,-29657,-10478,12881,-11296,-30917,11862,-20149,-32394,-21666,-8046,21935,2193,31915,-31982,-25363,-1773,-25856,17436,-14716,-11624,-24232,18474,-30681,-29698,-8254,20136,19713,-12793,1872,13450,-32105,15055,-495,23667,-25638,-19227,11932,-22682,-14953,-12650,28571,-28134,-25339,3782,1439,-9129,-14021,27433,-13910,1192,-22595,-28356,-24245,-20351,-31415,-28300,-14710,12058,13537,-2918,-18282,-5547,-18918,-15664,-9505,-29898,3187,9779,32313,21563,27441,31989,-11901,4199,-7582,31515,-30305,22236,5731,-6533,5179,-25115,131,-30638,29839,-25449,31982,-27307,9574,19083,24452,27419,-32295,-328,2970,-11011,27758,-751,27692,24629,2381,-15504,-13689,-17119,-2126,28001,-29436,-13315,-20346,3412,-28205,21455,22860,-32015,-16297,-23460,-18720,-4925,27145,27205,32202,27016,-16047,-31304,18331,-15439,-913,-7130,-19296,-6578,-28106,-18470,-23924,-20116,28202,-2251,-22495,-8712,-4518,-25049,-1864,31244,-17949,-28201,30310,-6784,7253,-21459,6447,-29900,20678,-7942,9560,11582,-14422,-28877,-18134,28383,-20579,6075,2963,22568,-22325,-16579,6060,32607,6809,9261,-28315,18747,16502,5728,25403,24154,27172,-17520,25736,12121,9368,-25616,-29123,-21809,8682,-10296,21728,9262,19610,-23457,19892,5433,-12448,32574,-1308,-13060,815,15414,-32425,-24736,-1379,-26511,-17790,-29756,-26003,19662,-10335,-1650,-16552,22352,13957,-15559,22864,10756,19496,-30775,15657,30945,9170,-20723,-5605,31835,-21888,-2922,30099,-23404,14830,21366,9788,31145,20620,-299,8800,32571,-31131,26354,29349,-27755,-1636,-3386,-21400,10279,27375,-17237,4308,-12898,15811,26925,6826,30620,824,6681,23298,2011,12105,-15670,29616,879,-28365,-4958,-7564,-22202,2763,1166,6539,-12321,-31021,114,30669,-27862,22241,-11734,-141,-32260,6045,14688,-31472,24181,-30450,-9579,25262,17663,20682,3023,-9915,5490,-60,432,23882,30242,-3363,-16512,13609,25517,9301,-2128,2999,23870,18368,-27320,997,3652,9447,-674,-19504,-7664,3409,1090,21205,-29904,-7359,-10069,31646,4401,16421,-21787,17735,-15089,22365,10451,-13618,22718,-16718,21779,-28735,22476,972,-24285,-10156,-13397,-12130,-6482,-10897,5429,-6600,-21613,-27812,8594,5230,16454,-16637,-10644,18734,26988,-8795,19794,-23625,-25766,-20328,-10027,7670,-25252,-30334,26314,-5428,19296,3310,27035,-23233,32010,-30116,-21575,3560,-18883,31978,-3323,14650,28575,18033,26229,6216,-19103,-19009,-11949,8820,2099,19035,-29635,28127,-21290,-19759,-9501,28122,-18885,-5946,5269,14024,-8552,31376,-349,-22167,24461,-13546,-7876,8319,11545,30449,11314,-8362,12188,-26784,8370,-20717,20880,-10980,-23259,-11216,8381,22354,-20005,11155,-2638,12609,20504,14110,9015,28129,7671,-19676,-108,-12325,-10289,-634,-28484,-20683,-11528,-4526,23870,12401,2333,26804,-10733,7814,20685,-18759,-29510,11968,7925,-15478,-22046,19641,-17301,-12036,-26219,-31007,30714,8800,-13986,-25759,31269,3285,4759,-32347,7685,16826,7147,-20381,5454,30502,21707,17087,-30209,-20082,-11514,5812,-81,-15900,28115,31679,14546,1736,26472,-28034,-13981,-21187,-3863,250,-1482,-30246,25253,17070,379,-28422,16717,13275,-26383,6720,-14262,9164,-21996,-15069,21131,21466,17874,26922,-25342,-29772,20093,-16056,26301,-24131,2867,23376,10991,-22077,28904,-16639,-14502,11801,-23365,20061,31531,-23037,20022,3280,8908,27801,-22275,-23897,-6014,32140,21297,-2770,12833,21531,-8239,-4193,-12168,14582,-12001,7139,10293,16300,-25449,-10964,-13474,22346,21579,25177,16069,10575,17969,8575,1555,21871,-28824,12079,-12164,-7042,-9248,-645,5128,19478,-29559,-3890,1877,14568,10321,-30641,19244,-16944,24177,24896,6653,-499,-1630,16237,-8809,28123,4102,6308,-1804,-26106,23030,-29052,-28893,20174,10771,-13999,-23958,23605,16429,-8504,-21995,5091,2952,-25290,-14984,29038,31637,-26609,25974,-15258,7899,15073,-3677,-8177,27063,9861,-10027,23300,18608,19547,-13337,17634,28703,9701,-26105,1982,17355,-12819,24130,144,-9692,4915,8588,-2873,-5302,8026,1604,-13260,-5589,1642,32067,-30352,-25045,1658,-24772,-28629,18431,-199,-13294,30078,-11238,-9057,-18129,21508,-380,2232,-28370,-10825,21380,-28408,25916,-19216,-21150,2772,-24188,26520,-21605,-18370,-32701,-2160,12508,24246,10300,3682,-10085,20774,7161,-14218,7807,5825,14559,-14634,-16405,28326,-18395,30954,-12841,-29594,-24901,10487,18272,746,26674,29855,-994,-8984,23974,-15479,-25427,30848,29703,14440,22324,2623,26968,-25538,-3609,9532,-16434,10686,-22398,28631,-30251,17704,-11520,1567,13896,3338,7381,17662,-18684,26645,-32472,2947,8114,-26654,-9384,22123,-15792,19203,-11535,22190,16639,-13818,26587,-4646,8512,30265,21613,-17543,-25761,-29471,1082,11299,12145,-16917,-14064,-24315,-21166,14419,-13757,7186,13984,-3444,7332,31911,-31882,24724,-2448,-28290,-4221,24866,28516,-16831,-28670,-24565,15849,-7756,22946,28863,-23750,21945,-12996,25322,-25766,-28838,24772,-922,25796,-29238,17362,19619,25431,-25364,-23195,-28325,-27897,13798,-1731,25349,-7231,-24467,-15144,13326,-21327,2051,-12399,24424,-26948,2275,-512,19832,17111,-3085,-23551,-17756,9834,-12277,23497,-6541,30147,-4358,16066,25263,-19616,17226,-12752,-14961,-12055,19505,25707,-6342,32076,6979,-11616,10124,-1021,25994,15311,-10775,24675,-17222,-4820,8978,5574,-8521,24273,-28887,14902,-10498,-23397,21393,-26404,10142,14239,21011,23299,-22422,8868,15566,-5911,-18509,27095,20555,-23094,18339,-17244,15131,32590,-29707,6110,-23334,-6449,30107,14655,-3572,11267,28221,6251,-15160,-9535,12927,26187,-32741,-6128,-8422,22439,-10039,-30410,24406,14954,25486,-15453,-29055,-1158,-23187,-12476,-16397,29108,10143,-21212,-24367,21148,-20572,1260,21638,7160,8506,-7767,-3730,-18075,-24378,-18983,-14235,-22661,30646,-24350,-15170,-1496,-31098,-21700,18551,9769,-12375,-11699,27195,-27882,-24724,-10335,-16804,-16090,24659,28577,13418,-19583,3922,5635,-20158,10819,-21400,-29210,28620,-1345,7555,-6780,8372,17809,15592,-30811,-23999,-14640,-10476,-927,-26868,-3595,841,-30485,-2686,13658,30697,-5763,-25866,-14399,10786,-28770,25463,31660,9015,-22101,-5000,-10002,31979,-6121,-7119,14060,-29325,-23836,-3530,18312,29927,14932,-6121,11008,3631,-12667,-26479,19378,12200,-16060,-12570,14568,-17749,29268,2243,-30834,-14444,10612,3828,-2342,-19146,-12998,-28107,-28341,-26666,8779,-18930,-24438,-1784,-25260,27369,25680,31486,-19839,18885,24263,17819,31911,-27698,9858,-13519,24554,15316,4387,5158,-11600,21905,-9512,18159,-4643,-27909,-31691,23999,-30746,-16052,11306,-6342,-30137,6294,1432,-21478,-21484,-13480,-7837,-5750,22987,31443,-30503,28326,-9556,19376,18238,23398,29349,-21781,11105,31994,20207,4400,20807,-14863,-891,-26476,23286,-10939,28768,586,-20664,13095,-22147,718,-2572,-7841,20306,2831,-11227,-31515,14713,-19362,27257,7605,-14831,18182,23112,5722,6776,19765,-3822,-5572,3742,-15173,5825,-31134,20411,-24361,9445,-18777,29116,-2776,-21828,6896,-11342,-22277,1213,-27897,-19411,-22276,-6445,-18844,17145,-27339,-7348,13250,3430,3964,17530,9207,5687,-21467,-11692,21531,-8333,24222,28943,-7509,-24012,-23011,-5732,24997,26334,-20638,12848,-10257,30308,18495,30997,-10745,-14282,-15200,-8173,-10447,9921,-8442,4990,-5661,11262,-17413,-14834,8640,-23615,32427,3948,18132,8992,-9182,-13218,-18375,-28912,25087,21175,27976,-6661,-18756,21129,3998,-31545,14631,28756,-18009,-29248,-11835,23662,-9964,-23804,13096,-10737,-12237,-12813,-4694,-21211,-17049,-18172,21596,146,9362,28201,738,-4364,9333,-14297,6031,26879,-8317,-19715},
  {-31142,-5144,-1039,-1424,-12022,-21196,-25867,8260,-24174,22563,13300,26635,14228,-21652,-9736,-19186,-27245,17873,-15404,3140,-32275,31222,-31833,-10285,-13391,7417,18610,6904,-4542,1596,23431,-3104,15928,-31688,-15608,8189,14804,-634,-30612,-19308,14046,10097,-20396,-9141,11992,-17641,-26517,-30148,2579,-26011,11831,-1361,32306,-21306,12431,19146,6544,4991,-17430,12015,15339,12818,29635,-29879,4912,-23002,23595,8213,-29582,-11836,6881,-16309,12582,17512,-9970,-7012,-32028,30699,5250,3810,-20122,24129,18969,-29254,3722,7093,-22057,7517,-8608,-20575,7483,-4287,6157,-19032,1366,-6401,5500,-9206,7672,3655,-16011,-19331,15080,8875,32145,-17648,-25192,3501,26418,-25199,25497,28123,-29075,24684,14323,-31199,6954,-20572,11177,3590,-4163,12065,-25722,22179,-8113,-29259,14488,4763,9441,-13243,4797,-26257,-21301,25752,-15008,1493,-3757,-15037,22479,16589,-16781,-7224,25088,-18719,18470,-24833,-22354,-27674,30834,24364,-13550,7042,-19618,2704,-2927,-3448,17359,20303,-32257,-18217,-31670,23180,-12028,29046,-12562,-22451,7686,14067,-4231,-3744,15709,-16629,24651,-32684,23680,-28018,-21866,31749,10701,-18757,16569,-2749,9375,-11740,1611,10243,-1432,-26018,-19633,-22774,16175,-9793,3317,11748,-10019,-15908,20079,11221,17607,-28672,-5596,24697,-26838,11711,-19217,24651,-28147,-15320,-913,26880,-15054,17361,13147,-20218,-23030,25495,5482,8347,24409,11821,32532,-28502,-29936,-19227,-9685,-17784,-27167,21158,-6391,-1372,-26041,-28691,-30152,14962,28836,-25760,1608,-14186,-6576,24738,-4662,14757,5720,-31305,-21956,-13464,-5370,18698,11214,-10065,7686,14457,23565,-17401,-19864,17405,-2821,7908,1805,6165,-28592,7743,26861,-7268,-20924,11360,-7568,9496,5275,21288,10908,-19287,-6381,27063,12467,-9108,-25677,32442,28328,-3467,4485,29667,-484,3833,-32157,-4547,22130,19988,1793,-24044,-15281,-20300,29834,27590,29820,30899,-26148,18405,5582,24718,-16993,-3908,4425,9210,-7028,-15281,-20671,6584,-21032,-18298,17838,1521,-3107,-8858,10099,-16359,-11362,-16206,2440,6919,7056,-8906,-28808,-31473,-17916,-3744,-22878,10278,3049,18259,-16917,-30314,-14373,-7234,-15909,-20491,2562,1035,-8687,-30149,-6137,-22292,-32615,-4661,10029,6691,-25910,25586,-30611,-2657,23268,273,-31003,18550,2664,29343,-5383,-17616,-16794,-18700,4908,-23029,-23395,-9378,4614,22929,-11113,-2131,7695,-3028,-19009,-28392,-31465,7682,20512,24993,-14375,-7305,15828,-32374,12656,-15201,-1221,-737,27970,-23773,32582,-26362,-22052,-10018,18267,-24081,1729,-7480,17057,-4417,5142,4999,-32574,9038,-32727,31619,30222,22094,-1272,15827,19817,11530,-17418,20002,18215,-22533,21079,23504,31651,-5140,-1821,-32311,-3780,-23087,-7074,-30321,26867,32032,18316,-20773,28879,13607,19480,1554,22780,28668,-19198,-25905,29515,24362,-11409,-25764,29367,26532,-6926,-5846,-13699,7183,4566,-30968,-4051,-9111,15046,14191,-21317,30896,-26827,24658,-12360,10648,-13777,-9209,22561,-11284,-13599,13178,-31150,16717,-29785,17644,7342,9420,29164,-12480,-9573,25892,9587,-17427,4805,19767,28349,-19388,-8752,-4994,30323,898,-2177,-24133,-19462,7893,-7895,3339,25128,-20746,8728,13904,2254,2269,23999,-16739,19942,-16872,13892,-29840,-6218,-724,-26712,-10504,25666,25953,20769,-7175,-12642,-12119,7938,-30565,-20992,-5817,1567,-17269,-27466,-28862,22898,16310,-22803,-18544,26910,8340,16525,12749,12405,-4568,1018,31463,6084,-10865,14676,-16899,20433,17805,9003,19042,-18604,11696,32730,26280,-12724,14264,-24630,-3180,-22953,22644,19684,-5274,-4011,15565,13816,-2368,6413,-20789,25760,-26275,-8657,9119,-14308,-4929,15266,18713,12577,2846,-11229,25219,-22124,-26298,13627,9347,21782,7669,31348,-7956,-29506,15644,6055,-27543,-9977,5004,-3667,29066,19800,28989,-22864,29975,8949,-29443,20156,11477,-26184,-10155,13937,-24326,22061,8031,-10266,-6555,10194,-8683,12170,22395,3760,-25175,-13674,-8609,11103,11061,-10560,4086,26759,-27554,5861,22425,-20686,-11494,-28005,27743,-12921,-13622,6149,-25966,13456,-7940,-22259,-9584,-3299,596,230,-7140,29930,28315,-21082,8301,11622,11628,-31540,12906,-20869,-1352,29582,-26622,23326,-29747,9407,32233,14666,30877,7991,19590,2042,-5686,24720,9535,-8002,-14916,-7490,-1885,-3162,6987,2240,-1523,-22127,530,2232,-5402,15058,5465,-5574,-14859,31200,-27919,-16052,28150,22142,7507,7279,443,26448,17474,-5524,6286,-22658,-12466,-6421,7837,24062,-17452,9907,-986,23484,-29220,-10834,21384,16455,27686,-23131,-22768,-11849,3590,12112,16988,24103,-20359,30259,15277,-8031,-25812,4017,539,-12050,-9558,14802,31510,1380,-8011,-16412,26695,5204,-10252,13179,26970,-5747,148,8201,17606,11866,4227,-4390,-15987,29664,4813,-12186,-18087,-31664,17631,21816,-13326,-31893,-24033,-1987,-21079,-14184,20573,-12271,17326,10606,12770,25639,-28833,9197,894,17665,23281,10849,-1277,13049,19720,28329,-766,11330,-16797,32019,22872,27316,23291,-2270,-29631,24251,12093,-9955,7988,13404,-31867,26300,1534,-12239,-21931,9650,28250,29577,-8933,92,-24004,-8161,21560,-27683,-27673,21108,-1545,9000,-13350,-32004,17601,23109,24917,13287,10467,-2934,25992,-8878,-1065,5098,25200,-9192,-24599,-6384,26670,17630,-15912,14426,-19766,-691,525,-13635,-30905,-1631,11097,21989,22280,15573,15441,-14926,-29883,25960,32282,16544,-24076,-9563,-25360,2012,29954,-6946,20655,23414,15849,-23697,11496,16230,-22604,-22293,-1165,-9601,-28299,-7468,-19318,-21719,24378,-25439,-10066,3212,-23745,11066,-11610,16185,-9694,32664,8803,-6370,2528,-14353,4484,23820,6597,-4363,30467,32170,-15554,10155,-11510,-16503,-11912,-7418,-4873,-9936,-20486,-24694,-2976,-16047,-21119,-16204,-21865,453,13711,2935,22003,-17301,29706,-29571,32140,-2451,-28619,-27727,-14948,-21347,14318,10673,23251,22282,-7119,8425,5411,9045,-9103,-16532,-11040,24119,-2797,13993,31672,4348,-9399,-21908,28153,32174,3993,26392,-276,-28558,-4536,28309,18634,-3371,-13180,-20750,-13582,29107,8311,-30611,-14087,23239,-27131,7107,-669,32314,-32386,11779,30444,31911,-29390,10989,-3281,14929,-24080,10865,10674,7310,20375,-20977,-33,5958,11488,29910,9602,4505,28842,2724,12074,-13574,12002,16038,2370,32461,-25764,20825,30266,11595,2331,24752,30957,-31624,12329,-11524,12645,-14440,-4176,-23362,-3277,-9502,-3355,-4662,2579,-7863,5686,14376,21814,-5105,24008,-30572,15827,7284,-22158,16724,19903,13300,1986,-28832,9046,26624,14896,-7791,-17498,18406,-10954,32308,8178,-15923,-21769,-21450,13476,15688,-18916,854,12609,-28073,18388,-20041,-11876,-8951,-28828,23525,-21847,-30784,4135,21383,30677,-29316,-4624,-18957,-31759,-13855,-18101,-12736,-15091,16737,-6481,-29563,-13374,26847,-22519,12909,-25210,19991,24863,-27862,-499,-11942,23516,10189,-2622,12115,7315,-14847,-29152,-17991,62,-19287,12600,24962,-24029,-26434,-27662,-10591,15004,-26482,-24329,-30710,6279,2951,6272,481,-19546,13741,22284,13325,-18434,-27675,-14830,24656,17456,-5979,-11370,21312,-5113,30965,6730,22985,24932,-18274,22178,-3527,31356,-28094,31667,-18283,-16189,-24909,-30652,31936,30130,9349,31527,-11216,32315,22962,-4644,-23015,-30554,-25986,14237,24859,13136,-12405,-140,23479,21706,9334,15013,-25837,-22348,-2675,25683,-16173,8614,3437,-29930,-32060,-27911,17260,11193,25741,25098,-17213,-24734,502,-5925,-16578,-19936,414,-23846,5465,-7131,-24449,-8238,25789,-7908,31013,8506,5077,-3933,-27303,25199,23711,13588,-1855,19321,12002,5466,-25707,9409,8053,14344,-14830,-16142,-19046,32583,-24548,-13885,28291,-18905,-2165,-10489,-18058,-19865,-8461,-12118,-12367,-3456,24593,29579,17027,-10282,-11418,23939,-10584,-3305,-22861,32293,7646,5955,22657,16073,-22519,-20101,-6997,8500,-24544,-11563,-28433,-27129,10343,-28194,-26444,8028,31913,-10658,9946,-6065,-17188,4064,21350,-25540,19117,3206,-22512,9671,-31006,-17040,21191,-10748,31928,30212,21846,-6468,31463,24818,10311,12505,-29983,13621,-11608,17710,20874,-18668,-14901,18479,-29055,-21431,31496,-32748,27004,17196,20222,-23228,-3737,-25779,26155,-6026,-22883,4252,22730,2464,12121,-8083,-31573,31447,-29416,-25166,-22840,-3181,17714,5386,25554,23721,31938,-4668,31008,-21750,16173,-25421,12662,14641,-4557,-30616,10864},
  {-6600,27687,-28545,-20248,-18304,-1180,31458,-26652,-14295,8324,15176,12602,-21632,-31791,-27892,-32016,21542,9402,-7493,-29640,-3107,-20584,8688,-1201,-27782,18971,1015,-1479,5142,31191,22112,15220,26199,-14211,-1045,-28061,22548,-16522,-3700,-17624,5159,-31134,-21395,-19103,-11963,-4330,-13235,3917,18113,-20223,3753,13881,-12855,-11244,-6828,-10701,-20516,29319,-4003,-25513,-9201,10092,-1712,1098,29542,-8980,-21538,-23845,18908,-23771,1169,14350,22652,-28487,14944,5239,-13370,31002,17252,23575,-31753,19861,8734,18866,-19012,17349,-6185,-17706,23866,15689,-9971,-18601,-303,-30011,26238,26696,-18641,-4966,13146,28038,-28915,-19657,1609,21800,-130,4694,-27214,14035,23382,-7330,-10406,22049,-17391,-15269,-1820,-8010,9279,19261,-8750,18677,-30842,-20312,-22156,-19824,17416,-32608,15855,6835,-29740,31650,18062,-2550,12461,-7001,24000,5110,23571,-3900,20044,19160,30770,-22714,-25319,25944,4027,20039,21509,18773,5741,29223,32069,2975,-31518,-4281,-9897,32039,-4824,-19997,16372,-8521,-16970,5096,-25283,24116,28356,16231,31929,-30751,-1560,-2616,12971,32560,26836,-9187,-27255,-25116,863,-1619,-26349,-22005,-29924,20253,-29921,-25829,-5374,-22213,-10932,-5401,-24104,-3505,-11249,-24025,-29910,28309,12184,-29338,-28062,-29703,-31603,-1736,-24078,-26793,-5145,-5856,4147,-13504,-12385,16925,16280,-25199,1241,-17301,908,32500,-21134,-21579,-12274,-12627,-30034,-20081,6199,-942,-27706,-2174,-19827,8535,9623,-658,16543,-6350,8483,12971,-22325,-25235,-3210,-17342,-18026,355,15906,11677,-26342,2361,-20474,-21579,-4488,10794,15310,-31055,11253,-7885,25856,19728,18638,4662,25668,-17160,28499,23163,8621,22786,60,2162,10674,22812,11969,5571,-24453,-5610,11475,22991,-28878,-7906,1053,22166,-11003,-17629,-29892,-637,3723,-23117,4214,-1315,-27315,32119,-28686,6925,27390,-30250,3538,22680,3539,-24799,26561,6521,-13809,4291,-7357,11932,-20448,-11307,-20530,-19532,5024,26626,-13346,5572,-6121,9005,-25653,-11421,-2443,-31143,-2228,-28233,6551,-29872,-17356,-26720,11517,-15005,-25940,-30298,-7409,3935,7145,-26421,-3720,-23420,17189,-29644,31634,4627,-12529,11374,23091,-29868,-11232,-1219,19984,-3842,-18426,-5820,8190,27873,30894,-1552,3117,16418,4318,15137,-10990,-28126,-8188,9821,-9160,2919,24560,29058,25337,25951,-4446,25455,-14036,26455,-25324,18949,7499,22655,-2655,24177,11408,-11833,30983,-9875,-28666,-16555,7580,-26708,4403,-12364,-9803,7327,-6127,-18780,12661,-20037,-30567,-15158,16329,28849,-22608,-19689,-30963,9114,-19420,-5482,-27357,-3335,-4917,29066,-2350,5476,-3301,-14751,-6371,7215,-5562,24750,18712,20455,3195,21876,-7688,13093,-21300,-28360,-19543,-20066,20080,21157,-15596,4616,-28069,5635,-6996,-7602,29421,-31725,-24460,11347,-22957,-13382,154,-15279,-15856,-32270,-17716,25103,-9400,20014,-13653,6204,23201,-24746,22838,15580,-31984,-3088,-24355,4623,-22810,9257,-4572,-25047,8111,-4828,22226,13817,23749,16491,5412,31270,26129,-27278,-4277,13708,-19906,20008,-30011,12851,-7699,176,5050,9759,1683,-3688,25945,-2573,-20845,-3910,25448,-32445,-3541,-19033,-5751,-18682,-32736,-17969,-9159,3627,25935,460,-22201,-5778,28361,-27776,31904,24259,-30278,-15210,16584,-6297,9937,-20094,19626,-4708,-5480,-1196,-12558,22598,14754,-19490,5619,20566,9386,30224,-12368,-3925,-7763,4839,29274,-26546,-28589,-702,-4008,-29698,-16807,-18382,-16746,-13635,-1435,-2979,6358,4242,25383,9730,-10841,24194,7257,8760,-9623,-15429,9862,19963,-7488,28098,-25565,29320,-220,19081,-4295,26229,-19530,-19656,-30254,28219,21576,16725,13817,-31678,-1204,-11707,1732,-18292,-18009,-8510,29997,-15457,-25951,-17740,30045,4487,7091,-19780,-17844,27006,-19156,21625,20375,-16111,-29300,-25606,10187,-25129,12514,300,11380,13020,-15041,-4253,-22154,6575,-10232,-23699,-41,21816,19767,24975,-11171,32481,-18346,32761,-6538,-31832,18067,-2064,-18996,15030,26981,-6606,-22726,8301,2978,906,-17615,8255,-5598,218,-14699,8919,14583,21726,32157,31736,15322,-25506,16940,11212,17073,-768,-18158,369,-17927,7281,-15149,3204,440,896,25609,-26277,20550,825,-6554,-11468,7559,8273,23537,-3346,12484,-23439,-19977,1073,2917,11637,-10363,-9752,-19156,17298,23864,11579,11356,19907,19508,-14313,-31496,-15316,-12027,-20663,-18073,-30170,-4596,-16536,15848,25205,-7682,17688,-19561,10299,29581,-262,-3784,-6990,13526,-3718,30008,-25156,24193,-346,-15632,6209,-23367,-307,5701,-20043,-1881,28071,-27649,-18954,-9517,-30293,14437,-6926,-1368,-26503,17708,-956,-28418,27492,-12541,-540,21268,2051,26132,-17881,8710,-32093,23770,17085,13341,-17088,-4538,-26846,31925,-9142,-23853,-21371,979,-29745,-25623,-32560,-2567,12857,-239,3124,9329,4879,14402,781,-2800,22482,-29016,-21869,6674,32495,-22642,-10102,28390,-24304,31597,-26649,32250,17023,3183,4052,23034,14026,25963,27419,8194,13336,-18284,11825,15550,1247,-29286,24370,-31736,-26123,-8688,-9214,-20787,1419,24635,7791,16067,11393,12068,22988,19210,-10422,-28230,5780,10955,7911,-22330,-10677,31153,-18444,-18658,-14411,13104,8545,-22897,-17420,-3874,26712,-7366,700,5103,-27126,-24460,-26972,-12145,31842,-8345,21277,24021,29161,-3639,-5450,27963,-13860,-28741,-19975,-10169,13109,-14551,9458,21667,14057,20389,2600,6658,3953,-26257,3069,-14798,20059,20778,-19656,-12506,4856,-4695,4757,21248,-21910,11413,8503,1740,14212,-25178,19717,-6494,5773,19672,32401,16216,-730,-15229,-29202,-15942,10844,31224,-15436,18453,17881,-29233,-30919,-7071,-18728,1430,13737,-3716,20797,-8940,29139,21934,-27400,-21334,-187,2007,-10194,26415,8130,18941,25322,-2982,-9839,24795,30107,5612,-16516,-4265,-1992,-20002,11073,26485,-11970,10425,28273,2419,26402,16104,13882,-3864,24354,20515,-25126,-2746,-27851,28005,-17552,-3387,713,31900,7616,-917,18465,15407,-8636,-21611,32215,-8267,9715,-22308,12276,-10900,9973,18702,25913,27511,-23267,17691,27472,10207,-27458,20408,30030,22740,-25285,28482,25911,6842,32212,-23493,-2269,-7156,-16272,-1011,17629,29490,11910,18750,30706,-27870,18805,11820,-6046,9950,19333,-3276,-19204,-27276,30032,-31275,10001,26242,-18778,2677,-5413,-27863,-22817,-18393,-9186,-7214,-17889,-11799,19963,11469,3968,13046,-17063,-24134,-17949,27930,10640,-20619,7777,286,-32653,-22602,24784,-4089,-17900,4466,763,32001,-26155,21084,-25567,-27347,31043,-32591,-1946,24415,17263,-15872,-12405,-3065,-9731,-14600,-30521,-15115,13290,-23156,28031,32557,2867,17170,24660,-32221,10544,28817,-27426,340,22998,-1159,-25121,4813,-31024,1500,866,-30243,23351,19458,-30417,8104,-18398,6479,5986,14175,4111,-31428,8392,-12392,27422,-10628,30351,23677,-18699,32318,21347,3094,1830,-15186,-13975,-5134,5980,5374,-2018,-17436,28192,-29441,-24857,8381,29245,-18328,22220,-28363,-91,-18367,-3828,-16119,23074,8276,-21425,-16417,-6709,6080,-27017,12610,12688,-7516,-19867,16731,24266,-25912,24714,-25532,16008,-3830,3046,22453,3665,-11042,1493,31409,-19158,-1885,26639,19138,1008,19473,-21722,27757,-15794,26003,23894,14079,-24764,20959,6312,-18380,-30421,11265,16564,4245,31589,21820,12505,-26588,-227,-31504,27132,10306,-19495,-21064,-12100,7171,19826,29594,13940,6867,29695,-30256,-24706,-10248,30606,-13745,21433,357,22483,-26772,-5736,3728,8558,-29408,26050,-10874,-25325,22310,-20300,5619,-3256,17463,18542,15230,243,-20778,-23547,15844,32427,5343,-14505,26770,30580,-14156,-8509,28492,-23194,2815,3735,3270,-10266,5831,19298,-15718,-18448,8639,-21390,10926,5777,-7148,-30293,10853,-21691,-12697,16464,2849,-14803,20975,27403,12642,-27563,26738,-32623,-3637,-27749,-16996,-12523,21625,23888,-6424,-32417,-13395,-14359,-22222,-32654,15341,32476,-20039,17910,21920,17715,12240,-10967,-5555,21307,-24081,31537,-19532,7382,18637,736,15396,20170,-8419,-17230,-7455,-29350,13634,30319,-32726,7970,-26209,27529,-8477,24177,13647,7075,20532,10118,6206,-22608,-10047,-1542,14344,32587,4059,29589,5100,-18953,7190,30307,-24118,-17503,24405,10071,-2490,-24162,-15088,-5687,24609,-10949,-29583,21419,16739,-19545,9442,8294,-24726,-96,-21288,-12874,27336,27003,31460,1677,22468,-30278,-189,8944,-26900,-15072,-27186,21628,7769},
} ;

static void test_encode_1277x7879_impl(long long impl)
{
  unsigned char *s = test_encode_1277x7879_s;
  unsigned char *x = test_encode_1277x7879_x;
  unsigned char *s2 = test_encode_1277x7879_s2;
  unsigned char *x2 = test_encode_1277x7879_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1277x7879_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1277x7879(impl);
    printf("encode_1277x7879 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x7879_implementation(impl),ntruprime_dispatch_encode_1277x7879_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1277x7879;
    printf("encode_1277x7879 selected implementation %s compiler %s\n",ntruprime_encode_1277x7879_implementation(),ntruprime_encode_1277x7879_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1277x7879_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1277x7879_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1277x7879_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1277x7879_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1277x7879_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1277x7879_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1277x7879(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x7879")) return;
  storage_encode_1277x7879_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1277x7879_s = aligned(storage_encode_1277x7879_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1277x7879_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1277x7879_x = aligned(storage_encode_1277x7879_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1277x7879_s2 = callocplus(maxalloc);
  test_encode_1277x7879_s2 = aligned(storage_encode_1277x7879_s2,crypto_encode_STRBYTES);
  storage_encode_1277x7879_x2 = callocplus(maxalloc);
  test_encode_1277x7879_x2 = aligned(storage_encode_1277x7879_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1277x7879 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x7879();++impl)
      forked(test_encode_1277x7879_impl,impl);
    ++test_encode_1277x7879_s;
    ++test_encode_1277x7879_x;
    ++test_encode_1277x7879_s2;
    ++test_encode_1277x7879_x2;
  }
  free(storage_encode_1277x7879_x2);
  free(storage_encode_1277x7879_s2);
  free(storage_encode_1277x7879_x);
  free(storage_encode_1277x7879_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

