Inspired by the [collections/map][mout] util in mout.

## Usage

```js
var map = require('{%= name %}');
```

### objects

```js
var res = map({a: 'foo', b: 'bar', c: 'baz'}, function(item, key, obj) {
  return item;
});
console.log(res);
// => ['foo', 'bar', 'baz']

var res = map({a: 'foo', b: 'bar', c: 'baz'}, function(item, key, obj) {
  return key;
});
console.log(res);
// => ['a', 'b', 'c']
```

### arrays

```js
var res = map(['foo', 'bar', 'baz'], function(item, index, array) {
  return item;
});
console.log(res);
// => ['foo', 'bar', 'baz']

var res = map(['foo', 'bar', 'baz'], function(item, index, array) {
  return index;
});
console.log(res);
// => [0, 1, 2]
```

### strings

A string may be passed as the second argument, for getting properties:

```js
var obj = {
  a: {aaa: 'one', bbb: 'four', ccc: 'seven'},
  b: {aaa: 'two', bbb: 'five', ccc: 'eight'},
  c: {aaa: 'three', bbb: 'six', ccc: 'nine'}
};

console.log(map(obj, 'aaa'));
// => ['one', 'two', 'three']

var array = [obj.a, obj.b, obj.c];
console.log(map(array, 'bbb'));
// => ['four', 'five', 'six']
```

### thisArg

Invocation context may be passed as the last argument.

```js
var array = ['a', 'b', 'c'];
var ctx = {a: 'aaa', b: 'bbb', c: 'ccc'};

var res = map(array, function(item, index, array) {
  return this[item];
}, ctx);

console.log(res);
// => ['aaa', 'bbb', 'ccc']
```
