/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file yapf.hpp Base includes/functions for YAPF. */

#ifndef YAPF_HPP
#define YAPF_HPP

#include "../../landscape.h"
#include "../pathfinder_func.h"
#include "yapf.h"

#include "../../misc/fixedsizearray.hpp"
#include "../../misc/array.hpp"
#include "../../misc/hashtable.hpp"
#include "../../misc/binaryheap.hpp"
#include "../../misc/dbg_helpers.h"
#include "nodelist.hpp"
#include "../follow_track.hpp"
#include "yapf_type.hpp"
#include "yapf_base.hpp"
#include "yapf_node.hpp"
#include "yapf_common.hpp"
#include "yapf_costbase.hpp"
#include "yapf_costcache.hpp"


#endif /* YAPF_HPP */
