#ifndef __TRANSLATIONMANAGER_H_2022_07_17
#define __TRANSLATIONMANAGER_H_2022_07_17

#include <QDir>
#include <QString>

class QTranslator;

class TranslationManager
{
public:
    TranslationManager();
    /** Checks if the translation dir is found, prints an error to stdout if not. */
    static void checkIfTranslationDirIsAvailable();
    /** Loads the translation of the module with the given name (e.g. packagesearch, aptplugin, ...)*/
    static QTranslator* loadTranslation(QString moduleName);
private:
    static QDir findTranslationDir(bool logOnDirectoryNotFound);
};

#endif // __TRANSLATIONMANAGER_H_2022_07_17
