// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vpc "github.com/jdcloud-api/jdcloud-sdk-go/services/vpc/models"
)

type DescribeNetworkInterfaceRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* networkInterface ID  */
    NetworkInterfaceId string `json:"networkInterfaceId"`
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeNetworkInterfaceRequest(
    regionId string,
    networkInterfaceId string,
) *DescribeNetworkInterfaceRequest {

	return &DescribeNetworkInterfaceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 */
func NewDescribeNetworkInterfaceRequestWithAllParams(
    regionId string,
    networkInterfaceId string,
) *DescribeNetworkInterfaceRequest {

    return &DescribeNetworkInterfaceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeNetworkInterfaceRequestWithoutParam() *DescribeNetworkInterfaceRequest {

    return &DescribeNetworkInterfaceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DescribeNetworkInterfaceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param networkInterfaceId: networkInterface ID(Required) */
func (r *DescribeNetworkInterfaceRequest) SetNetworkInterfaceId(networkInterfaceId string) {
    r.NetworkInterfaceId = networkInterfaceId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeNetworkInterfaceRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeNetworkInterfaceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeNetworkInterfaceResult `json:"result"`
}

type DescribeNetworkInterfaceResult struct {
    NetworkInterface vpc.NetworkInterface `json:"networkInterface"`
}