# Third-party extensions

Third-party extensions are developed and maintained outside of the mkdocstrings organization, by various developers. They generally bring support for third-party libraries.

Extension | Description
--------- | -----------
[`docstring-inheritance`](third-party/docstring-inheritance.md) | A more advanced docstring inheritance utility that also provides a Griffe extension.
[`fieldz`](third-party/fieldz.md) | Support for data-class like objects (dataclasses, pydantic, attrs, etc.) using [fieldz](https://github.com/pyapp-kit/fieldz).
[`generics`](third-party/generics.md) | Resolve generic type parameters as bound types in subclasses.
[`inherited-method-crossrefs`](third-party/inherited-method-crossrefs.md) | Replace docstrings of inherited methods with cross-references to parents.
[`modernized-annotations`](third-party/modernized-annotations.md) | Modernize type annotations by adopting PEP 585 and PEP 604.

You can find more third-party extensions by exploring the [`griffe-extension` topic on GitHub](https://github.com/topics/griffe-extension). You can also check out the "in-project" extensions (not published to PyPI) used in various projects on GitHub by [searching for "griffe extension" in code](https://github.com/search?q=griffe+Extension+language%3Apython&type=code).
