% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmDSdata.R
\name{dmDSdata}
\alias{dmDSdata}
\title{Create dmDSdata object}
\usage{
dmDSdata(counts, samples)
}
\arguments{
\item{counts}{Data frame with counts. Rows correspond to features, for
example, transcripts or exons. This data frame has to contain a
\code{gene_id} column with gene IDs, \code{feature_id} column with feature
IDs and columns with counts for each sample. Column names corresponding to
sample IDs must be the same as in the \code{sample} data frame.}

\item{samples}{Data frame where each row corresponds to one sample. Columns
have to contain unique sample IDs in \code{sample_id} variable and a
grouping variable \code{group}.}
}
\value{
Returns a \linkS4class{dmDSdata} object.
}
\description{
Constructor function for a \code{\linkS4class{dmDSdata}} object.
}
\examples{
# --------------------------------------------------------------------------
# Create dmDSdata object 
# --------------------------------------------------------------------------
## Get kallisto transcript counts from the 'PasillaTranscriptExpr' package

library(PasillaTranscriptExpr)
\donttest{
data_dir  <- system.file("extdata", package = "PasillaTranscriptExpr")

## Load metadata
pasilla_metadata <- read.table(file.path(data_dir, "metadata.txt"), 
header = TRUE, as.is = TRUE)

## Load counts
pasilla_counts <- read.table(file.path(data_dir, "counts.txt"), 
header = TRUE, as.is = TRUE)

## Create a pasilla_samples data frame
pasilla_samples <- data.frame(sample_id = pasilla_metadata$SampleName, 
  group = pasilla_metadata$condition)
levels(pasilla_samples$group)

## Create a dmDSdata object
d <- dmDSdata(counts = pasilla_counts, samples = pasilla_samples)

## Use a subset of genes, which is defined in the following file
gene_id_subset <- readLines(file.path(data_dir, "gene_id_subset.txt"))

d <- d[names(d) \%in\% gene_id_subset, ]
}
}
\seealso{
\code{\link{plotData}}
}
\author{
Malgorzata Nowicka
}
