% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/308-extractDrugAutocorrelationCharge.R
\name{extractDrugAutocorrelationCharge}
\alias{extractDrugAutocorrelationCharge}
\title{Calculate the Moreau-Broto Autocorrelation Descriptors using Partial Charges}
\usage{
extractDrugAutocorrelationCharge(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns 5 columns named
\code{ATSc1}, \code{ATSc2}, \code{ATSc3}, \code{ATSc4}, \code{ATSc5}.
}
\description{
Calculate the Moreau-Broto Autocorrelation Descriptors using Partial Charges
}
\details{
Calculates the ATS autocorrelation descriptor,
where the weight equal to the charges.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugAutocorrelationCharge(mol)
head(dat)}
}
