% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPerCellQC.R
\name{quickPerCellQC}
\alias{quickPerCellQC}
\alias{quickPerCellQC,ANY-method}
\alias{quickPerCellQC,SummarizedExperiment-method}
\title{Quick cell-level QC}
\usage{
quickPerCellQC(x, ...)

\S4method{quickPerCellQC}{ANY}(
  x,
  sum.field = "sum",
  detected.field = "detected",
  sub.fields = NULL,
  ...,
  lib_size = NULL,
  n_features = NULL,
  percent_subsets = NULL
)

\S4method{quickPerCellQC}{SummarizedExperiment}(
  x,
  ...,
  subsets = NULL,
  assay.type = "counts",
  other.args = list(),
  filter = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{DataFrame} containing per-cell QC statistics, as computed by \code{\link{perCellQCMetrics}}.
Alternatively, a \linkS4class{SummarizedExperiment} object that can be used to create such a DataFrame via \code{\link{perCellQCMetrics}}.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the ANY method, further arguments to pass to \code{\link{isOutlier}}.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{sum.field}{String specifying the column of \code{x} containing the library size for each cell.}

\item{detected.field}{String specifying the column of \code{x} containing the number of detected features per cell.}

\item{sub.fields}{Character vector specifying the column(s) of \code{x} containing the percentage of counts in subsets of \dQuote{control features}, 
usually mitochondrial genes or spike-in transcripts.

If set to \code{TRUE}, this will default to all columns in \code{x} with names following the patterns \code{"subsets_.*_percent"} and \code{"altexps_.*_percent"}.}

\item{lib_size, n_features, percent_subsets}{Soft-deprecated equivalents of the arguments above.}

\item{subsets, assay.type}{Arguments to pass to the \code{\link{perCellQCMetrics}} function, exposed here for convenience.}

\item{other.args}{A named list containing other arguments to pass to the \code{\link{perCellQCMetrics}} function.}

\item{filter}{Logical scalar indicating whether to filter out low-quality cells from \code{x}.}
}
\value{
If \code{filter=FALSE} or \code{x} is a DataFrame, a \linkS4class{DataFrame} is returned with one row per cell and containing columns of logical vectors.
Each column specifies a reason for why a cell was considered to be low quality,
with the final \code{discard} column indicating whether the cell should be discarded.

If \code{filter=TRUE}, \code{x} is returned with the low-quality cells removed.
QC statistics and filtering information for all remaining cells are stored in the \code{\link{colData}}.
}
\description{
A convenient utility that identifies low-quality cells based on frequently used QC metrics.
}
\details{
For DataFrame \code{x}, this function simply calls \code{\link{perCellQCFilters}}.
The latter should be directly used in such cases; DataFrame inputs are soft-deprecated here.

For SummarizedExperiment \code{x}, this function is simply a convenient wrapper around \code{\link{perCellQCMetrics}} and \code{\link{perCellQCFilters}}.
}
\examples{
example_sce <- mockSCE()

filtered_sce <- quickPerCellQC(example_sce, subsets=list(Mito=1:100),
    sub.fields=c("subsets_Mito_percent", "altexps_Spikes_percent"))
ncol(filtered_sce)

# Same result as the longer chain of expressions:
stats <- perCellQCMetrics(example_sce, subsets=list(Mito=1:100))
discard <- perCellQCFilters(stats, 
    sub.fields=c("subsets_Mito_percent", "altexps_Spikes_percent"))
filtered_sce2 <- example_sce[,!discard$discard]
ncol(filtered_sce2)

}
\seealso{
\code{\link{perCellQCMetrics}}, for calculation of these metrics.

\code{\link{perCellQCFilters}}, to define filter thresholds based on those metrics.
}
\author{
Aaron Lun
}
