% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFormula.R
\name{checkFormula}
\alias{checkFormula}
\alias{check_formula}
\alias{assertFormula}
\alias{assert_formula}
\alias{testFormula}
\alias{test_formula}
\alias{expect_formula}
\title{Check if an argument is a formula}
\usage{
checkFormula(x, null.ok = FALSE)

check_formula(x, null.ok = FALSE)

assertFormula(x, null.ok = FALSE, .var.name = vname(x), add = NULL)

assert_formula(x, null.ok = FALSE, .var.name = vname(x), add = NULL)

testFormula(x, null.ok = FALSE)

test_formula(x, null.ok = FALSE)

expect_formula(x, null.ok = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertFormula}/\code{assert_formula} return 
 \code{x} invisibly, whereas
 \code{checkFormula}/\code{check_formula} and 
 \code{testFormula}/\code{test_formula} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertFormula}/\code{assert_formula}
 throws an error message, 
 \code{testFormula}/\code{test_formula}
 returns \code{FALSE},
 and \code{checkFormula}/\code{check_formula} 
 return a string with the error message.
 The function \code{expect_formula} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a formula
}
\examples{
f = Species ~ Sepal.Length + Sepal.Width
checkFormula(f)
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkAtomic}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFunction}()},
\code{\link{checkIntegerish}()},
\code{\link{checkInteger}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}
}
\concept{basetypes}
