% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{containers}
\alias{containers}
\title{CLI containers}
\description{
Container elements may contain other elements. Currently the following
commands create container elements: \code{\link[=cli_div]{cli_div()}}, \code{\link[=cli_par]{cli_par()}}, the list
elements: \code{\link[=cli_ul]{cli_ul()}}, \code{\link[=cli_ol]{cli_ol()}}, \code{\link[=cli_dl]{cli_dl()}}, and list items are
containers as well: \code{\link[=cli_it]{cli_it()}}.
}
\details{
Container elements need to be closed with \code{\link[=cli_end]{cli_end()}}. For convenience,
they are have an \code{.auto_close} argument, which allows automatically
closing a container element, when the function that created it
terminates (either regularly, or with an error).
}
\examples{
## div with custom theme
d <- cli_div(theme = list(h1 = list(color = "blue",
                                    "font-weight" = "bold")))
cli_h1("Custom title")
cli_end(d)

## Close automatically
div <- function() {
  cli_div(class = "tmp", theme = list(.tmp = list(color = "yellow")))
  cli_text("This is yellow")
}
div()
cli_text("This is not yellow any more")
}
