% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{clock-getters}
\alias{clock-getters}
\alias{get_year}
\alias{get_quarter}
\alias{get_month}
\alias{get_week}
\alias{get_day}
\alias{get_hour}
\alias{get_minute}
\alias{get_second}
\alias{get_millisecond}
\alias{get_microsecond}
\alias{get_nanosecond}
\alias{get_index}
\title{Calendar getters}
\usage{
get_year(x)

get_quarter(x)

get_month(x)

get_week(x)

get_day(x)

get_hour(x)

get_minute(x)

get_second(x)

get_millisecond(x)

get_microsecond(x)

get_nanosecond(x)

get_index(x)
}
\arguments{
\item{x}{\verb{[object]}

An object to get the component from.}
}
\value{
The component.
}
\description{
This family of functions extract fields from a calendar vector. Each
calendar has its own set of supported getters, which are documented on
their own help page:
\itemize{
\item \link[=year-month-day-getters]{year-month-day}
\item \link[=year-month-weekday-getters]{year-month-weekday}
\item \link[=iso-year-week-day-getters]{iso-year-week-day}
\item \link[=year-quarter-day-getters]{year-quarter-day}
\item \link[=year-day-getters]{year-day}
}

There are also convenience methods for extracting certain components
directly from R's native date and date-time types.
\itemize{
\item \link[=Date-getters]{dates (Date)}
\item \link[=posixt-getters]{date-times (POSIXct / POSIXlt)}
}
}
\details{
You cannot extract components directly from a time point type, such as
sys-time or naive-time. Convert it to a calendar type first. Similarly,
a zoned-time must be converted to either a sys-time or naive-time, and
then to a calendar type, to be able to extract components from it.
}
\examples{
x <- year_month_day(2019, 1:3, 5:7, 1, 20, 30)
get_month(x)
get_day(x)
get_second(x)
}
