% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\docType{data}
\name{geom_density_ridges}
\alias{geom_density_ridges}
\alias{GeomDensityRidges}
\alias{geom_density_ridges2}
\alias{GeomDensityRidges2}
\title{Create ridgeline plot}
\usage{
geom_density_ridges(
  mapping = NULL,
  data = NULL,
  stat = "density_ridges",
  position = "points_sina",
  panel_scaling = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_density_ridges2(
  mapping = NULL,
  data = NULL,
  stat = "density_ridges",
  position = "points_sina",
  panel_scaling = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.
If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{ggplot()}.

A \code{data.frame}, or other object, will override the plot
data.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{panel_scaling}{If \code{TRUE}, the default, relative scaling is calculated separately
for each panel. If \code{FALSE}, relative scaling is calculated globally.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{...}{other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{linewidth = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
\code{geom_density_ridges} arranges multiple density plots in a staggered fashion, as in the cover of the famous Joy Division album Unknown Pleasures.
}
\details{
By default, this geom calculates densities from the point data mapped onto the x axis. If density calculation is
not wanted, use \code{stat="identity"} or use \code{\link{geom_ridgeline}}. The difference between \code{geom_density_ridges} and \code{\link{geom_ridgeline}}
is that \code{geom_density_ridges} will provide automatic scaling of the ridgelines (controlled by the \code{scale} aesthetic), whereas
\link{geom_ridgeline} will plot the data as is. Note that when you set \code{stat="identity"}, the \code{height} aesthetic must
be provided.

Note that the default \code{\link{stat_density_ridges}} makes joint density estimation across all datasets. This may not generate
the desired result when using faceted plots. As an alternative, you can set \code{stat = "density"} to use
\link[ggplot2:geom_density]{ggplot2::stat_density}.
In this case, it is required to add the aesthetic mapping \code{height = after_stat(density)} (see examples).
}
\section{Aesthetics}{


Required aesthetics are in bold.
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{weight} Optional case weights passed to \code{stats::density} to calculate a weighted density estimate
\item \code{group} Defines the grouping. Not needed if a categorical variable is mapped onto \code{y}, but needed otherwise. Will typically be the same
variable as is mapped to \code{y}.
\item \code{height} The height of each ridgeline at the respective x value. Automatically calculated and
provided by \code{\link{stat_density_ridges}} if the default stat is not changed.
\item \code{scale} A scaling factor to scale the height of the ridgelines relative to the spacing between them.
A value of 1 indicates that the maximum point of any ridgeline touches the baseline right above, assuming
even spacing between baselines.
\item \code{rel_min_height} Lines with heights below this cutoff will be removed. The cutoff is measured relative to the
overall maximum, so \code{rel_min_height=0.01} would remove everything that is 1\\% or less than the highest point among all
ridgelines. Default is 0, so nothing is removed.
alpha
\item \code{colour}, \code{fill}, \code{group}, \code{alpha}, \code{linetype}, \code{linewidth}, as in \code{\link{geom_ridgeline}}.
\item \code{point_shape}, \code{point_colour}, \code{point_size}, \code{point_fill}, \code{point_alpha}, \code{point_stroke}, as in \code{\link{geom_ridgeline}}.
}
}

\examples{
library(ggplot2)

# set the `rel_min_height` argument to remove tails
ggplot(iris, aes(x = Sepal.Length, y = Species)) +
  geom_density_ridges(rel_min_height = 0.005) +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  theme_ridges()

# set the `scale` to determine how much overlap there is among the plots
ggplot(diamonds, aes(x = price, y = cut)) +
  geom_density_ridges(scale = 4) +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  theme_ridges()

# the same figure with colors, and using the ggplot2 density stat
ggplot(diamonds, aes(x = price, y = cut, fill = cut, height = after_stat(density))) +
  geom_density_ridges(scale = 4, stat = "density") +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  scale_fill_brewer(palette = 4) +
  theme_ridges() + theme(legend.position = "none")

# use geom_density_ridges2() instead of geom_density_ridges() for solid polygons
ggplot(iris, aes(x = Sepal.Length, y = Species)) +
  geom_density_ridges2() +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_x_continuous(expand = c(0.01, 0)) +
  theme_ridges()
}
\keyword{datasets}
