% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_RLum.Data.Curve.R
\name{merge_RLum.Data.Curve}
\alias{merge_RLum.Data.Curve}
\title{Merge function for RLum.Data.Curve S4 class objects}
\usage{
merge_RLum.Data.Curve(object, merge.method = "mean", method.info)
}
\arguments{
\item{object}{\link{list} of \linkS4class{RLum.Data.Curve} (\strong{required}):
list of S4 objects of class \code{RLum.Curve}.}

\item{merge.method}{\link{character} (\strong{required}):
method for combining of the objects, e.g.  \code{'mean'}, \code{'sum'}, see details for
further information and allowed methods.  Note: Elements in slot info will
be taken from the first curve in the list.}

\item{method.info}{\link{numeric} (\emph{optional}):
allows to specify how info elements of the input objects are combined,
e.g. \code{1} means that just the elements from the first object are kept,
\code{2} keeps only the info elements from the 2 object etc.
If nothing is provided all elements are combined.}
}
\value{
Returns an \linkS4class{RLum.Data.Curve} object.
}
\description{
Function allows merging of RLum.Data.Curve objects in different ways
}
\details{
This function simply allowing to merge \linkS4class{RLum.Data.Curve}
objects without touching the objects itself. Merging is always applied on
the 2nd column of the data matrix of the object.

\strong{Supported merge operations are \linkS4class{RLum.Data.Curve}}

\code{"sum"}

All count values will be summed up using the function \link{rowSums}.

\code{"mean"}

The mean over the count values is calculated using the function
\link{rowMeans}.

\code{"median"}

The median over the count values is calculated using the function
\link[matrixStats:rowMedians]{matrixStats::rowMedians}.

\code{"sd"}

The standard deviation over the count values is calculated using the function
\link[matrixStats:rowSds]{matrixStats::rowSds}.

\code{"var"}

The variance over the count values is calculated using the function
\link[matrixStats:rowVars]{matrixStats::rowVars}.

\code{"min"}

The min values from the count values is chosen using the function
\link[matrixStats:rowRanges]{matrixStats::rowMins}.

\code{"max"}

The max values from the count values is chosen using the function
\link[matrixStats:rowRanges]{matrixStats::rowMins}.

\code{"append"}

Appends count values of all curves to one combined data curve. The channel width
is automatically re-calculated, but requires a constant channel width of the
original data.

\code{"-"}

The row sums of the last objects are subtracted from the first object.

\code{"*"}

The row sums of the last objects are multiplied with the first object.

\code{"/"}

Values of the first object are divided by row sums of the last objects.
}
\note{
The information from the slot \code{recordType} is taken from the first
\linkS4class{RLum.Data.Curve} object in the input list. The slot
'curveType' is filled with the name \code{merged}.
}
\section{S3-generic support}{


This function is fully operational via S3-generics:
\code{+}, \code{-}, \code{/}, \code{*}, \code{merge}
}

\section{Function version}{
 0.2.1
}

\examples{


##load example data
data(ExampleData.XSYG, envir = environment())

##grep first and 3d TL curves
TL.curves  <- get_RLum(OSL.SARMeasurement$Sequence.Object, recordType = "TL (UVVIS)")
TL.curve.1 <- TL.curves[[1]]
TL.curve.3 <- TL.curves[[3]]

##plot single curves
plot_RLum(TL.curve.1)
plot_RLum(TL.curve.3)

##subtract the 1st curve from the 2nd and plot
TL.curve.merged <- merge_RLum.Data.Curve(list(TL.curve.3, TL.curve.1), merge.method = "/")
plot_RLum(TL.curve.merged)

}
\seealso{
\link{merge_RLum}, \linkS4class{RLum.Data.Curve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2023. merge_RLum.Data.Curve(): Merge function for RLum.Data.Curve S4 class objects. Function version 0.2.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.21. https://CRAN.R-project.org/package=Luminescence
}

\keyword{internal}
\keyword{utilities}
