% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info_functions.R
\name{get_modcomp}
\alias{get_modcomp}
\alias{getKR}
\alias{getSAT}
\title{Extract (or "get") components from a \code{KRmodcomp} or
\code{SATmodcomp} object.}
\usage{
getKR(
  object,
  name = c("ndf", "ddf", "Fstat", "p.value", "F.scaling", "FstatU", "p.valueU", "aux")
)

getSAT(object, name = c("ndf", "ddf", "Fstat", "p.value"))
}
\arguments{
\item{object}{A \code{KRmodcomp} object, which is the result of the
\code{KRmodcomp} function}

\item{name}{The available slots. If \code{name} is missing or \code{NULL}
then everything is returned.}
}
\description{
Extract (or "get") components from a \code{KRmodcomp}
or \code{SATmodcomp} object. In particular, get denominator
degrees of freedom.
}
\examples{

(fm0 <- lmer(Reaction ~ (Days|Subject), sleepstudy))
(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
(fm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))

x10 <- KRmodcomp(fm1, fm0)
getKR(x10, "ddf")

KRmodcomp(fm1, fm0) |> getKR("ddf")
KRmodcomp(fm2, fm0) |> getKR("ddf")
KRmodcomp(fm2, fm1) |> getKR("ddf")

## For comparison:

SATmodcomp(fm1, fm0) |> getSAT("ddf")
SATmodcomp(fm2, fm0) |> getSAT("ddf")
SATmodcomp(fm2, fm1) |> getSAT("ddf")

}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
Models - The R Package pbkrtest., Journal of Statistical Software,
58(10), 1-30., \url{https://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{KRmodcomp}}, \code{\link{PBmodcomp}},
\code{\link{vcovAdj}}
}
\author{
Søren Højsgaard \email{sorenh@math.aau.dk}
}
\keyword{utilities}
