% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-gpc-methods.R
\name{coerce-gpc-methods}
\alias{coerce-gpc-methods}
\alias{owin2gpc}
\alias{gpc2owin}
\alias{as.owin.gpc.poly}
\title{Conversion between polygonal \code{"owin"} and \code{"gpc.poly"}}
\usage{
owin2gpc(object)

gpc2owin(object, ...)

as.owin.gpc.poly(W, ...)
}
\arguments{
\item{object}{an object of class \code{"gpc.poly"} or \code{"owin"},
respectively.}

\item{...}{further arguments passed to \code{\link[spatstat.geom]{owin}}.}

\item{W}{an object of class \code{"gpc.poly"}.}
}
\value{
The converted polygon of class \code{"gpc.poly"} or \code{"owin"},
respectively. If package \pkg{gpclib} is not available,
\code{owin2gpc} will just return the \code{pts} slot of the
\code{"gpc.poly"} (no formal class) with a warning.
}
\description{
Package \pkg{polyCub} implements converters between the classes
\code{"\link[spatstat.geom:owin.object]{owin}"} of package \CRANpkg{spatstat.geom}
and \code{"gpc.poly"} of package \CRANpkg{gpclib}.
}
\note{
The converter \code{owin2gpc} requires the package
\pkg{gpclib} for the formal class definition of a \code{"gpc.poly"}.
It will produce vertices ordered according to the \pkg{sp} convention,
i.e. clockwise for normal boundaries and anticlockwise for holes, where,
however, the first vertex is \emph{not} repeated!
}
\examples{
\dontshow{if (requireNamespace("spatstat.geom")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## use example polygons from
example(plotpolyf, ask = FALSE)
letterR  # a simple "xylist"

letterR.owin <- spatstat.geom::owin(poly = letterR)
letterR.gpc_from_owin <- owin2gpc(letterR.owin)
## warns if "gpclib" is unavailable

if (is(letterR.gpc_from_owin, "gpc.poly")) {
  letterR.xylist_from_gpc <- xylist(letterR.gpc_from_owin)
  stopifnot(all.equal(letterR, lapply(letterR.xylist_from_gpc, `[`, 1:2)))
  letterR.owin_from_gpc <- gpc2owin(letterR.gpc_from_owin)
  stopifnot(all.equal(letterR.owin, letterR.owin_from_gpc))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{xylist}}
}
\author{
Sebastian Meyer
}
\keyword{methods}
\keyword{spatial}
