% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-sp-methods.R
\name{coerce-sp-methods}
\alias{coerce-sp-methods}
\alias{as.owin.SpatialPolygons}
\alias{as.owin.Polygons}
\alias{as.owin.Polygon}
\alias{coerce,SpatialPolygons,owin-method}
\alias{coerce,Polygons,owin-method}
\alias{coerce,Polygon,owin-method}
\alias{coerce,Polygon,Polygons-method}
\title{Coerce \code{"SpatialPolygons"} to \code{"owin"}}
\usage{
as.owin.SpatialPolygons(W, ...)

as.owin.Polygons(W, ...)

as.owin.Polygon(W, ...)
}
\arguments{
\item{W}{an object of class \code{"SpatialPolygons"},
\code{"Polygons"}, or \code{"Polygon"}.}

\item{...}{further arguments passed to \code{\link[spatstat.geom]{owin}}.}
}
\description{
Package \pkg{polyCub} implements \code{coerce}-methods
(\code{as(object, Class)}) to convert
\code{"\link[sp:SpatialPolygons-class]{SpatialPolygons}"}
(or \code{"\link[sp:Polygons-class]{Polygons}"}
or \code{"\link[sp:Polygon-class]{Polygon}"})
of package \CRANpkg{sp}
to \code{"\link[spatstat.geom:owin.object]{owin}"}
of package \CRANpkg{spatstat.geom}.
They are also available as \code{as.owin.*} functions to support
\code{\link{polyCub.midpoint}}.
}
\examples{
if (require("spatstat.geom") && require("sp")) {
    diamond <- list(x = c(1,2,1,0), y = c(1,2,3,2))  # anti-clockwise
    diamond.owin <- owin(poly = diamond)
    diamond.sp <- Polygon(lapply(diamond, rev))      # clockwise
    stopifnot(identical(xylist(diamond.sp), list(diamond)))
    diamond.owin_from_sp <- as.owin(diamond.sp)
    stopifnot(all.equal(diamond.owin, diamond.owin_from_sp))

    ## similarly works for Polygons and SpatialPolygons
    diamond.Ps <- as(diamond.sp, "Polygons")
    stopifnot(identical(diamond.owin, as.owin(diamond.Ps)))
    diamond.SpPs <- SpatialPolygons(list(diamond.Ps))
    stopifnot(identical(xylist(diamond.SpPs), list(diamond)))
    stopifnot(identical(diamond.owin, as.owin(diamond.SpPs)))
}
}
\seealso{
\code{\link{xylist}}
}
\author{
Sebastian Meyer
}
\keyword{methods}
\keyword{spatial}
