% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rcode.r
\name{joinrate}
\alias{joinrate}
\title{Join ratetables}
\usage{
joinrate(tables, dim.name = "country", merge = FALSE)
}
\arguments{
\item{tables}{a list of ratetables. If names are given, they are included as
\code{dimnames}.}

\item{dim.name}{the name of the added dimension.}

\item{merge}{if FALSE (default) only the intersect of all years/ages is taken.
If TRUE all possible years/ages are included (NOTE: in this case hazards are extrapolated
from earlier or later years/ages). This option only works for ratetables with dimensions}
}
\value{
An object of class \code{ratetable}.
}
\description{
The function joins two or more objects organized as \code{ratetable} by
adding a new dimension.
}
\details{
This function joins two or more \code{ratetable} objects by adding a new
dimension. The cutpoints of all the rate tables are compared; if merge=FALSE
(default) only the common intervals are kept, otherwise if merge=TRUE all
intervals are added (and hazards are extrapolated).
If the intervals defined by the cutpoints are not of
the same length, a warning message is displayed.  Each rate table must have
the same dimensions.
}
\examples{

#newpop <- joinrate(list(Arizona=survexp.az,Florida=survexp.fl,
#                   Minnesota=survexp.mn),dim.name="state")

}
\references{
Package: Pohar M., Stare J. (2006) "Relative survival analysis
in R." Computer Methods and Programs in Biomedicine, \bold{81}: 272-278.

Relative survival: Pohar, M., Stare, J. (2007) "Making relative survival
analysis relatively easy." Computers in biology and medicine, \bold{37}:
1741-1749.
}
\seealso{
\code{\link[survival:ratetable]{survival::ratetable}}, \code{\link{transrate.hld}},
\code{\link{transrate.hmd}}, \code{\link{transrate}}.
}
\keyword{survival}
