% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{slideWindowDb}
\alias{slideWindowDb}
\title{Sliding window approach towards filtering sequences in a \code{data.frame}}
\usage{
slideWindowDb(
  db,
  sequenceColumn = "sequence_alignment",
  germlineColumn = "germline_alignment_d_mask",
  mutThresh,
  windowSize
)
}
\arguments{
\item{db}{\code{data.frame} containing sequence data.}

\item{sequenceColumn}{name of the column containing IMGT-gapped sample sequences.}

\item{germlineColumn}{name of the column containing IMGT-gapped germline sequences.}

\item{mutThresh}{threshold on the number of mutations in \code{windowSize} 
consecutive nucleotides. Must be between 1 and \code{windowSize} 
inclusive.}

\item{windowSize}{length of consecutive nucleotides. Must be at least 2.}
}
\value{
a logical vector. The length of the vector matches the number of input sequences in 
          \code{db}. Each entry in the vector indicates whether the corresponding input sequence
          should be filtered based on the given parameters.
}
\description{
\code{slideWindowDb} determines whether each input sequence in a \code{data.frame} 
contains equal to or more than a given number of mutations in a given length of 
consecutive nucleotides (a "window") when compared to their respective germline 
sequence.
}
\examples{
# Use an entry in the example data for input and germline sequence
data(ExampleDb, package="alakazam")

# Apply the sliding window approach on a subset of ExampleDb
slideWindowDb(db=ExampleDb[1:10, ], sequenceColumn="sequence_alignment", 
              germlineColumn="germline_alignment_d_mask", 
              mutThresh=6, windowSize=10)

}
\seealso{
See \link{slideWindowSeq} for applying the sliding window approach on a single sequence. 
          See \link{slideWindowTune} for parameter tuning for \code{mutThresh} and \code{windowSize}.
}
