% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{st_downsample}
\alias{st_downsample}
\alias{st_downsample.stars}
\alias{st_downsample.stars_proxy}
\title{downsample stars or stars_proxy object by skipping rows, columns and bands}
\usage{
st_downsample(x, n, ...)

\method{st_downsample}{stars}(x, n, ...)

\method{st_downsample}{stars_proxy}(x, n, ...)
}
\arguments{
\item{x}{object of class stars or stars_proxy}

\item{n}{numeric; the number of pixels/lines/bands etc that will be skipped; see Details.}

\item{...}{ignored}
}
\description{
downsample stars or stars_proxy object by skipping rows, columns and bands
}
\details{
If all n == 0, no downsampling takes place; if it is 1, every second row/column/band
is skipped, if it is 2, every second+third row/column/band are skipped, etc.

Downsampling a \code{stars_proxy} object returns a \code{stars} object, is
equivalent to calling \code{st_as_stars(x, downsample = 2)}, and only downsamples
the first two (x and y) dimensions.

Downsampled regular rasters keep their dimension offsets, have a cell size (delta) that
is n[i]+1 times larger, and may result in a (slightly) different extent.
}
