// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Sensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class Sensor : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Sensor:1.0.0", null);

    public Sensor(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Sensor(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Sensor StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Sensor(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_NOT_SUPPORTED = 1;

    public enum Events {
      EVT_KEY_TYPESPEC_CHANGED,
    }

    public enum ReadingType {
      NUMERIC,
      DISCRETE_ON_OFF,
      DISCRETE_MULTI,
    }

    public enum OnOffState {
      OFF,
      ON,
    }

    public enum Type {
      RMS_VOLTAGE,
      RMS_CURRENT,
      PEAK_CURRENT,
      MAXIMUM_CURRENT,
      UNBALANCE_CURRENT,
      ACTIVE_POWER,
      APPARENT_POWER,
      POWER_FACTOR,
      ACTIVE_ENERGY,
      APPARENT_ENERGY,
      FREQUENCY,
      TEMPERATURE,
      HUMIDITY,
      AIR_FLOW,
      AIR_PRESSURE,
      CONTACT_CLOSURE,
      ON_OFF_SENSOR,
      TRIP_SENSOR,
      VIBRATION,
      WATER_LEAK,
      SMOKE_DETECTOR,
    }

    public enum Unit {
      NONE,
      VOLT,
      AMPERE,
      WATT,
      VOLT_AMP,
      WATT_HOUR,
      VOLT_AMP_HOUR,
      DEGREE_CELSIUS,
      HZ,
      PERCENT,
      METER_PER_SEC,
      PASCAL,
      G,
      RPM,
      METER,
      HOUR,
      MINUTE,
      SECOND,
    }

    public class TypeSpec : ICloneable {
      public object Clone() {
        TypeSpec copy = new TypeSpec();
        copy.readingtype = this.readingtype;
        copy.type = this.type;
        copy.unit = this.unit;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["readingtype"] = (int)this.readingtype;
        json["type"] = (int)this.type;
        json["unit"] = (int)this.unit;
        return json;
      }

      public static TypeSpec Decode(LightJson.JsonObject json, Agent agent) {
        TypeSpec inst = new TypeSpec();
        inst.readingtype = (Com.Raritan.Idl.sensors.Sensor.ReadingType)(int)json["readingtype"];
        inst.type = (Com.Raritan.Idl.sensors.Sensor.Type)(int)json["type"];
        inst.unit = (Com.Raritan.Idl.sensors.Sensor.Unit)(int)json["unit"];
        return inst;
      }

      public Com.Raritan.Idl.sensors.Sensor.ReadingType readingtype = Com.Raritan.Idl.sensors.Sensor.ReadingType.NUMERIC;
      public Com.Raritan.Idl.sensors.Sensor.Type type = Com.Raritan.Idl.sensors.Sensor.Type.RMS_VOLTAGE;
      public Com.Raritan.Idl.sensors.Sensor.Unit unit = Com.Raritan.Idl.sensors.Sensor.Unit.NONE;
    }

    public class GetTypeSpecResult {
      public Com.Raritan.Idl.sensors.Sensor.TypeSpec _ret_;
    }

    public GetTypeSpecResult getTypeSpec() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTypeSpec", _parameters);
      var _ret = new GetTypeSpecResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Sensor.TypeSpec.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getTypeSpec(AsyncRpcResponse<GetTypeSpecResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTypeSpec(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTypeSpec(AsyncRpcResponse<GetTypeSpecResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTypeSpec", _parameters,
        _result => {
          try {
            var _ret = new GetTypeSpecResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Sensor.TypeSpec.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetTypeResult {
      public int _ret_;
    }

    public SetTypeResult setType(Com.Raritan.Idl.sensors.Sensor.Type type, Com.Raritan.Idl.sensors.Sensor.Unit unit) {
      var _parameters = new LightJson.JsonObject();
      _parameters["type"] = (int)type;
      _parameters["unit"] = (int)unit;

      var _result = RpcCall("setType", _parameters);
      var _ret = new SetTypeResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setType(Com.Raritan.Idl.sensors.Sensor.Type type, Com.Raritan.Idl.sensors.Sensor.Unit unit, AsyncRpcResponse<SetTypeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setType(type, unit, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setType(Com.Raritan.Idl.sensors.Sensor.Type type, Com.Raritan.Idl.sensors.Sensor.Unit unit, AsyncRpcResponse<SetTypeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["type"] = (int)type;
        _parameters["unit"] = (int)unit;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setType", _parameters,
        _result => {
          try {
            var _ret = new SetTypeResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
