#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn CompareStringA(locale: u32, dwcmpflags: u32, lpstring1: &[i8], lpstring2: &[i8]) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn CompareStringA ( locale : u32 , dwcmpflags : u32 , lpstring1 : *const i8 , cchcount1 : i32 , lpstring2 : *const i8 , cchcount2 : i32 ) -> i32 );
    CompareStringA(locale, dwcmpflags, ::core::mem::transmute(lpstring1.as_ptr()), lpstring1.len() as _, ::core::mem::transmute(lpstring2.as_ptr()), lpstring2.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CompareStringEx<P0, P1>(lplocalename: P0, dwcmpflags: COMPARE_STRING_FLAGS, lpstring1: &[u16], lpstring2: &[u16], lpversioninformation: ::core::option::Option<*const NLSVERSIONINFO>, lpreserved: ::core::option::Option<*const ::core::ffi::c_void>, lparam: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn CompareStringEx ( lplocalename : :: windows::core::PCWSTR , dwcmpflags : COMPARE_STRING_FLAGS , lpstring1 : :: windows::core::PCWSTR , cchcount1 : i32 , lpstring2 : :: windows::core::PCWSTR , cchcount2 : i32 , lpversioninformation : *const NLSVERSIONINFO , lpreserved : *const ::core::ffi::c_void , lparam : super::Foundation:: LPARAM ) -> i32 );
    CompareStringEx(lplocalename.into_param().abi(), dwcmpflags, ::core::mem::transmute(lpstring1.as_ptr()), lpstring1.len() as _, ::core::mem::transmute(lpstring2.as_ptr()), lpstring2.len() as _, ::core::mem::transmute(lpversioninformation.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpreserved.unwrap_or(::std::ptr::null())), lparam.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CompareStringOrdinal<P0>(lpstring1: &[u16], lpstring2: &[u16], bignorecase: P0) -> i32
where
    P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn CompareStringOrdinal ( lpstring1 : :: windows::core::PCWSTR , cchcount1 : i32 , lpstring2 : :: windows::core::PCWSTR , cchcount2 : i32 , bignorecase : super::Foundation:: BOOL ) -> i32 );
    CompareStringOrdinal(::core::mem::transmute(lpstring1.as_ptr()), lpstring1.len() as _, ::core::mem::transmute(lpstring2.as_ptr()), lpstring2.len() as _, bignorecase.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn CompareStringW(locale: u32, dwcmpflags: u32, lpstring1: &[u16], lpstring2: &[u16]) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn CompareStringW ( locale : u32 , dwcmpflags : u32 , lpstring1 : :: windows::core::PCWSTR , cchcount1 : i32 , lpstring2 : :: windows::core::PCWSTR , cchcount2 : i32 ) -> i32 );
    CompareStringW(locale, dwcmpflags, ::core::mem::transmute(lpstring1.as_ptr()), lpstring1.len() as _, ::core::mem::transmute(lpstring2.as_ptr()), lpstring2.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ConvertDefaultLocale(locale: u32) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn ConvertDefaultLocale ( locale : u32 ) -> u32 );
    ConvertDefaultLocale(locale)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoA(lpcalinfoenumproc: CALINFO_ENUMPROCA, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumCalendarInfoA ( lpcalinfoenumproc : CALINFO_ENUMPROCA , locale : u32 , calendar : u32 , caltype : u32 ) -> super::Foundation:: BOOL );
    EnumCalendarInfoA(lpcalinfoenumproc, locale, calendar, caltype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExA(lpcalinfoenumprocex: CALINFO_ENUMPROCEXA, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumCalendarInfoExA ( lpcalinfoenumprocex : CALINFO_ENUMPROCEXA , locale : u32 , calendar : u32 , caltype : u32 ) -> super::Foundation:: BOOL );
    EnumCalendarInfoExA(lpcalinfoenumprocex, locale, calendar, caltype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExEx<P0, P1, P2>(pcalinfoenumprocexex: CALINFO_ENUMPROCEXEX, lplocalename: P0, calendar: u32, lpreserved: P1, caltype: u32, lparam: P2) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumCalendarInfoExEx ( pcalinfoenumprocexex : CALINFO_ENUMPROCEXEX , lplocalename : :: windows::core::PCWSTR , calendar : u32 , lpreserved : :: windows::core::PCWSTR , caltype : u32 , lparam : super::Foundation:: LPARAM ) -> super::Foundation:: BOOL );
    EnumCalendarInfoExEx(pcalinfoenumprocexex, lplocalename.into_param().abi(), calendar, lpreserved.into_param().abi(), caltype, lparam.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoExW(lpcalinfoenumprocex: CALINFO_ENUMPROCEXW, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumCalendarInfoExW ( lpcalinfoenumprocex : CALINFO_ENUMPROCEXW , locale : u32 , calendar : u32 , caltype : u32 ) -> super::Foundation:: BOOL );
    EnumCalendarInfoExW(lpcalinfoenumprocex, locale, calendar, caltype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumCalendarInfoW(lpcalinfoenumproc: CALINFO_ENUMPROCW, locale: u32, calendar: u32, caltype: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumCalendarInfoW ( lpcalinfoenumproc : CALINFO_ENUMPROCW , locale : u32 , calendar : u32 , caltype : u32 ) -> super::Foundation:: BOOL );
    EnumCalendarInfoW(lpcalinfoenumproc, locale, calendar, caltype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsA(lpdatefmtenumproc: DATEFMT_ENUMPROCA, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumDateFormatsA ( lpdatefmtenumproc : DATEFMT_ENUMPROCA , locale : u32 , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumDateFormatsA(lpdatefmtenumproc, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExA(lpdatefmtenumprocex: DATEFMT_ENUMPROCEXA, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumDateFormatsExA ( lpdatefmtenumprocex : DATEFMT_ENUMPROCEXA , locale : u32 , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumDateFormatsExA(lpdatefmtenumprocex, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExEx<P0, P1>(lpdatefmtenumprocexex: DATEFMT_ENUMPROCEXEX, lplocalename: P0, dwflags: ENUM_DATE_FORMATS_FLAGS, lparam: P1) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumDateFormatsExEx ( lpdatefmtenumprocexex : DATEFMT_ENUMPROCEXEX , lplocalename : :: windows::core::PCWSTR , dwflags : ENUM_DATE_FORMATS_FLAGS , lparam : super::Foundation:: LPARAM ) -> super::Foundation:: BOOL );
    EnumDateFormatsExEx(lpdatefmtenumprocexex, lplocalename.into_param().abi(), dwflags, lparam.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsExW(lpdatefmtenumprocex: DATEFMT_ENUMPROCEXW, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumDateFormatsExW ( lpdatefmtenumprocex : DATEFMT_ENUMPROCEXW , locale : u32 , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumDateFormatsExW(lpdatefmtenumprocex, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDateFormatsW(lpdatefmtenumproc: DATEFMT_ENUMPROCW, locale: u32, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumDateFormatsW ( lpdatefmtenumproc : DATEFMT_ENUMPROCW , locale : u32 , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumDateFormatsW(lpdatefmtenumproc, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumLanguageGroupLocalesA(lplanggrouplocaleenumproc: LANGGROUPLOCALE_ENUMPROCA, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumLanguageGroupLocalesA ( lplanggrouplocaleenumproc : LANGGROUPLOCALE_ENUMPROCA , languagegroup : u32 , dwflags : u32 , lparam : isize ) -> super::Foundation:: BOOL );
    EnumLanguageGroupLocalesA(lplanggrouplocaleenumproc, languagegroup, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumLanguageGroupLocalesW(lplanggrouplocaleenumproc: LANGGROUPLOCALE_ENUMPROCW, languagegroup: u32, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumLanguageGroupLocalesW ( lplanggrouplocaleenumproc : LANGGROUPLOCALE_ENUMPROCW , languagegroup : u32 , dwflags : u32 , lparam : isize ) -> super::Foundation:: BOOL );
    EnumLanguageGroupLocalesW(lplanggrouplocaleenumproc, languagegroup, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemCodePagesA(lpcodepageenumproc: CODEPAGE_ENUMPROCA, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemCodePagesA ( lpcodepageenumproc : CODEPAGE_ENUMPROCA , dwflags : ENUM_SYSTEM_CODE_PAGES_FLAGS ) -> super::Foundation:: BOOL );
    EnumSystemCodePagesA(lpcodepageenumproc, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemCodePagesW(lpcodepageenumproc: CODEPAGE_ENUMPROCW, dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemCodePagesW ( lpcodepageenumproc : CODEPAGE_ENUMPROCW , dwflags : ENUM_SYSTEM_CODE_PAGES_FLAGS ) -> super::Foundation:: BOOL );
    EnumSystemCodePagesW(lpcodepageenumproc, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemGeoID(geoclass: u32, parentgeoid: i32, lpgeoenumproc: GEO_ENUMPROC) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemGeoID ( geoclass : u32 , parentgeoid : i32 , lpgeoenumproc : GEO_ENUMPROC ) -> super::Foundation:: BOOL );
    EnumSystemGeoID(geoclass, parentgeoid, lpgeoenumproc)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemGeoNames<P0>(geoclass: u32, geoenumproc: GEO_ENUMNAMEPROC, data: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemGeoNames ( geoclass : u32 , geoenumproc : GEO_ENUMNAMEPROC , data : super::Foundation:: LPARAM ) -> super::Foundation:: BOOL );
    EnumSystemGeoNames(geoclass, geoenumproc, data.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLanguageGroupsA(lplanguagegroupenumproc: LANGUAGEGROUP_ENUMPROCA, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemLanguageGroupsA ( lplanguagegroupenumproc : LANGUAGEGROUP_ENUMPROCA , dwflags : ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS , lparam : isize ) -> super::Foundation:: BOOL );
    EnumSystemLanguageGroupsA(lplanguagegroupenumproc, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLanguageGroupsW(lplanguagegroupenumproc: LANGUAGEGROUP_ENUMPROCW, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemLanguageGroupsW ( lplanguagegroupenumproc : LANGUAGEGROUP_ENUMPROCW , dwflags : ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS , lparam : isize ) -> super::Foundation:: BOOL );
    EnumSystemLanguageGroupsW(lplanguagegroupenumproc, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesA(lplocaleenumproc: LOCALE_ENUMPROCA, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemLocalesA ( lplocaleenumproc : LOCALE_ENUMPROCA , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumSystemLocalesA(lplocaleenumproc, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesEx<P0>(lplocaleenumprocex: LOCALE_ENUMPROCEX, dwflags: u32, lparam: P0, lpreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemLocalesEx ( lplocaleenumprocex : LOCALE_ENUMPROCEX , dwflags : u32 , lparam : super::Foundation:: LPARAM , lpreserved : *const ::core::ffi::c_void ) -> super::Foundation:: BOOL );
    EnumSystemLocalesEx(lplocaleenumprocex, dwflags, lparam.into_param().abi(), ::core::mem::transmute(lpreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumSystemLocalesW(lplocaleenumproc: LOCALE_ENUMPROCW, dwflags: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumSystemLocalesW ( lplocaleenumproc : LOCALE_ENUMPROCW , dwflags : u32 ) -> super::Foundation:: BOOL );
    EnumSystemLocalesW(lplocaleenumproc, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsA(lptimefmtenumproc: TIMEFMT_ENUMPROCA, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumTimeFormatsA ( lptimefmtenumproc : TIMEFMT_ENUMPROCA , locale : u32 , dwflags : TIME_FORMAT_FLAGS ) -> super::Foundation:: BOOL );
    EnumTimeFormatsA(lptimefmtenumproc, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsEx<P0, P1>(lptimefmtenumprocex: TIMEFMT_ENUMPROCEX, lplocalename: P0, dwflags: u32, lparam: P1) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumTimeFormatsEx ( lptimefmtenumprocex : TIMEFMT_ENUMPROCEX , lplocalename : :: windows::core::PCWSTR , dwflags : u32 , lparam : super::Foundation:: LPARAM ) -> super::Foundation:: BOOL );
    EnumTimeFormatsEx(lptimefmtenumprocex, lplocalename.into_param().abi(), dwflags, lparam.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumTimeFormatsW(lptimefmtenumproc: TIMEFMT_ENUMPROCW, locale: u32, dwflags: TIME_FORMAT_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumTimeFormatsW ( lptimefmtenumproc : TIMEFMT_ENUMPROCW , locale : u32 , dwflags : TIME_FORMAT_FLAGS ) -> super::Foundation:: BOOL );
    EnumTimeFormatsW(lptimefmtenumproc, locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumUILanguagesA(lpuilanguageenumproc: UILANGUAGE_ENUMPROCA, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumUILanguagesA ( lpuilanguageenumproc : UILANGUAGE_ENUMPROCA , dwflags : u32 , lparam : isize ) -> super::Foundation:: BOOL );
    EnumUILanguagesA(lpuilanguageenumproc, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumUILanguagesW(lpuilanguageenumproc: UILANGUAGE_ENUMPROCW, dwflags: u32, lparam: isize) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EnumUILanguagesW ( lpuilanguageenumproc : UILANGUAGE_ENUMPROCW , dwflags : u32 , lparam : isize ) -> super::Foundation:: BOOL );
    EnumUILanguagesW(lpuilanguageenumproc, dwflags, lparam)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn FindNLSString(locale: u32, dwfindnlsstringflags: u32, lpstringsource: &[u16], lpstringvalue: &[u16], pcchfound: ::core::option::Option<*mut i32>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FindNLSString ( locale : u32 , dwfindnlsstringflags : u32 , lpstringsource : :: windows::core::PCWSTR , cchsource : i32 , lpstringvalue : :: windows::core::PCWSTR , cchvalue : i32 , pcchfound : *mut i32 ) -> i32 );
    FindNLSString(locale, dwfindnlsstringflags, ::core::mem::transmute(lpstringsource.as_ptr()), lpstringsource.len() as _, ::core::mem::transmute(lpstringvalue.as_ptr()), lpstringvalue.len() as _, ::core::mem::transmute(pcchfound.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindNLSStringEx<P0, P1>(lplocalename: P0, dwfindnlsstringflags: u32, lpstringsource: &[u16], lpstringvalue: &[u16], pcchfound: ::core::option::Option<*mut i32>, lpversioninformation: ::core::option::Option<*const NLSVERSIONINFO>, lpreserved: ::core::option::Option<*const ::core::ffi::c_void>, sorthandle: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn FindNLSStringEx ( lplocalename : :: windows::core::PCWSTR , dwfindnlsstringflags : u32 , lpstringsource : :: windows::core::PCWSTR , cchsource : i32 , lpstringvalue : :: windows::core::PCWSTR , cchvalue : i32 , pcchfound : *mut i32 , lpversioninformation : *const NLSVERSIONINFO , lpreserved : *const ::core::ffi::c_void , sorthandle : super::Foundation:: LPARAM ) -> i32 );
    FindNLSStringEx(lplocalename.into_param().abi(), dwfindnlsstringflags, ::core::mem::transmute(lpstringsource.as_ptr()), lpstringsource.len() as _, ::core::mem::transmute(lpstringvalue.as_ptr()), lpstringvalue.len() as _, ::core::mem::transmute(pcchfound.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(lpversioninformation.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpreserved.unwrap_or(::std::ptr::null())), sorthandle.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindStringOrdinal<P0>(dwfindstringordinalflags: u32, lpstringsource: &[u16], lpstringvalue: &[u16], bignorecase: P0) -> i32
where
    P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn FindStringOrdinal ( dwfindstringordinalflags : u32 , lpstringsource : :: windows::core::PCWSTR , cchsource : i32 , lpstringvalue : :: windows::core::PCWSTR , cchvalue : i32 , bignorecase : super::Foundation:: BOOL ) -> i32 );
    FindStringOrdinal(dwfindstringordinalflags, ::core::mem::transmute(lpstringsource.as_ptr()), lpstringsource.len() as _, ::core::mem::transmute(lpstringvalue.as_ptr()), lpstringvalue.len() as _, bignorecase.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn FoldStringA(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: &[u8], lpdeststr: ::core::option::Option<&mut [u8]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FoldStringA ( dwmapflags : FOLD_STRING_MAP_FLAGS , lpsrcstr : :: windows::core::PCSTR , cchsrc : i32 , lpdeststr : :: windows::core::PSTR , cchdest : i32 ) -> i32 );
    FoldStringA(dwmapflags, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, ::core::mem::transmute(lpdeststr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdeststr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn FoldStringW(dwmapflags: FOLD_STRING_MAP_FLAGS, lpsrcstr: &[u16], lpdeststr: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FoldStringW ( dwmapflags : FOLD_STRING_MAP_FLAGS , lpsrcstr : :: windows::core::PCWSTR , cchsrc : i32 , lpdeststr : :: windows::core::PWSTR , cchdest : i32 ) -> i32 );
    FoldStringW(dwmapflags, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, ::core::mem::transmute(lpdeststr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdeststr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetACP() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetACP ( ) -> u32 );
    GetACP()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfo(codepage: u32, lpcpinfo: *mut CPINFO) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCPInfo ( codepage : u32 , lpcpinfo : *mut CPINFO ) -> super::Foundation:: BOOL );
    GetCPInfo(codepage, lpcpinfo)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfoExA(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXA) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCPInfoExA ( codepage : u32 , dwflags : u32 , lpcpinfoex : *mut CPINFOEXA ) -> super::Foundation:: BOOL );
    GetCPInfoExA(codepage, dwflags, lpcpinfoex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCPInfoExW(codepage: u32, dwflags: u32, lpcpinfoex: *mut CPINFOEXW) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCPInfoExW ( codepage : u32 , dwflags : u32 , lpcpinfoex : *mut CPINFOEXW ) -> super::Foundation:: BOOL );
    GetCPInfoExW(codepage, dwflags, lpcpinfoex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCalendarInfoA(locale: u32, calendar: u32, caltype: u32, lpcaldata: ::core::option::Option<&mut [u8]>, lpvalue: ::core::option::Option<*mut u32>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCalendarInfoA ( locale : u32 , calendar : u32 , caltype : u32 , lpcaldata : :: windows::core::PSTR , cchdata : i32 , lpvalue : *mut u32 ) -> i32 );
    GetCalendarInfoA(locale, calendar, caltype, ::core::mem::transmute(lpcaldata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcaldata.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lpvalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCalendarInfoEx<P0, P1>(lplocalename: P0, calendar: u32, lpreserved: P1, caltype: u32, lpcaldata: ::core::option::Option<&mut [u16]>, lpvalue: ::core::option::Option<*mut u32>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCalendarInfoEx ( lplocalename : :: windows::core::PCWSTR , calendar : u32 , lpreserved : :: windows::core::PCWSTR , caltype : u32 , lpcaldata : :: windows::core::PWSTR , cchdata : i32 , lpvalue : *mut u32 ) -> i32 );
    GetCalendarInfoEx(lplocalename.into_param().abi(), calendar, lpreserved.into_param().abi(), caltype, ::core::mem::transmute(lpcaldata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcaldata.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lpvalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCalendarInfoW(locale: u32, calendar: u32, caltype: u32, lpcaldata: ::core::option::Option<&mut [u16]>, lpvalue: ::core::option::Option<*mut u32>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCalendarInfoW ( locale : u32 , calendar : u32 , caltype : u32 , lpcaldata : :: windows::core::PWSTR , cchdata : i32 , lpvalue : *mut u32 ) -> i32 );
    GetCalendarInfoW(locale, calendar, caltype, ::core::mem::transmute(lpcaldata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcaldata.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lpvalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCurrencyFormatA<P0>(locale: u32, dwflags: u32, lpvalue: P0, lpformat: ::core::option::Option<*const CURRENCYFMTA>, lpcurrencystr: ::core::option::Option<&mut [u8]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCurrencyFormatA ( locale : u32 , dwflags : u32 , lpvalue : :: windows::core::PCSTR , lpformat : *const CURRENCYFMTA , lpcurrencystr : :: windows::core::PSTR , cchcurrency : i32 ) -> i32 );
    GetCurrencyFormatA(locale, dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpcurrencystr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcurrencystr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCurrencyFormatEx<P0, P1>(lplocalename: P0, dwflags: u32, lpvalue: P1, lpformat: ::core::option::Option<*const CURRENCYFMTW>, lpcurrencystr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCurrencyFormatEx ( lplocalename : :: windows::core::PCWSTR , dwflags : u32 , lpvalue : :: windows::core::PCWSTR , lpformat : *const CURRENCYFMTW , lpcurrencystr : :: windows::core::PWSTR , cchcurrency : i32 ) -> i32 );
    GetCurrencyFormatEx(lplocalename.into_param().abi(), dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpcurrencystr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcurrencystr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetCurrencyFormatW<P0>(locale: u32, dwflags: u32, lpvalue: P0, lpformat: ::core::option::Option<*const CURRENCYFMTW>, lpcurrencystr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetCurrencyFormatW ( locale : u32 , dwflags : u32 , lpvalue : :: windows::core::PCWSTR , lpformat : *const CURRENCYFMTW , lpcurrencystr : :: windows::core::PWSTR , cchcurrency : i32 ) -> i32 );
    GetCurrencyFormatW(locale, dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpcurrencystr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpcurrencystr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatA<P0>(locale: u32, dwflags: u32, lpdate: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P0, lpdatestr: ::core::option::Option<&mut [u8]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetDateFormatA ( locale : u32 , dwflags : u32 , lpdate : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCSTR , lpdatestr : :: windows::core::PSTR , cchdate : i32 ) -> i32 );
    GetDateFormatA(locale, dwflags, ::core::mem::transmute(lpdate.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lpdatestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdatestr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatEx<P0, P1, P2>(lplocalename: P0, dwflags: ENUM_DATE_FORMATS_FLAGS, lpdate: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P1, lpdatestr: ::core::option::Option<&mut [u16]>, lpcalendar: P2) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetDateFormatEx ( lplocalename : :: windows::core::PCWSTR , dwflags : ENUM_DATE_FORMATS_FLAGS , lpdate : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCWSTR , lpdatestr : :: windows::core::PWSTR , cchdate : i32 , lpcalendar : :: windows::core::PCWSTR ) -> i32 );
    GetDateFormatEx(lplocalename.into_param().abi(), dwflags, ::core::mem::transmute(lpdate.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lpdatestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdatestr.as_deref().map_or(0, |slice| slice.len() as _), lpcalendar.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDateFormatW<P0>(locale: u32, dwflags: u32, lpdate: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P0, lpdatestr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetDateFormatW ( locale : u32 , dwflags : u32 , lpdate : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCWSTR , lpdatestr : :: windows::core::PWSTR , cchdate : i32 ) -> i32 );
    GetDateFormatW(locale, dwflags, ::core::mem::transmute(lpdate.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lpdatestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdatestr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetDistanceOfClosestLanguageInList<P0, P1>(pszlanguage: P0, pszlanguageslist: P1, wchlistdelimiter: u16) -> ::windows::core::Result<f64>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "bcp47mrm.dll""system" fn GetDistanceOfClosestLanguageInList ( pszlanguage : :: windows::core::PCWSTR , pszlanguageslist : :: windows::core::PCWSTR , wchlistdelimiter : u16 , pclosestdistance : *mut f64 ) -> :: windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<f64>();
    GetDistanceOfClosestLanguageInList(pszlanguage.into_param().abi(), pszlanguageslist.into_param().abi(), wchlistdelimiter, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDurationFormat<P0>(locale: u32, dwflags: u32, lpduration: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, ullduration: u64, lpformat: P0, lpdurationstr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetDurationFormat ( locale : u32 , dwflags : u32 , lpduration : *const super::Foundation:: SYSTEMTIME , ullduration : u64 , lpformat : :: windows::core::PCWSTR , lpdurationstr : :: windows::core::PWSTR , cchduration : i32 ) -> i32 );
    GetDurationFormat(locale, dwflags, ::core::mem::transmute(lpduration.unwrap_or(::std::ptr::null())), ullduration, lpformat.into_param().abi(), ::core::mem::transmute(lpdurationstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdurationstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDurationFormatEx<P0, P1>(lplocalename: P0, dwflags: u32, lpduration: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, ullduration: u64, lpformat: P1, lpdurationstr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetDurationFormatEx ( lplocalename : :: windows::core::PCWSTR , dwflags : u32 , lpduration : *const super::Foundation:: SYSTEMTIME , ullduration : u64 , lpformat : :: windows::core::PCWSTR , lpdurationstr : :: windows::core::PWSTR , cchduration : i32 ) -> i32 );
    GetDurationFormatEx(lplocalename.into_param().abi(), dwflags, ::core::mem::transmute(lpduration.unwrap_or(::std::ptr::null())), ullduration, lpformat.into_param().abi(), ::core::mem::transmute(lpdurationstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdurationstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileMUIInfo<P0>(dwflags: u32, pcwszfilepath: P0, pfilemuiinfo: ::core::option::Option<*mut FILEMUIINFO>, pcbfilemuiinfo: *mut u32) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetFileMUIInfo ( dwflags : u32 , pcwszfilepath : :: windows::core::PCWSTR , pfilemuiinfo : *mut FILEMUIINFO , pcbfilemuiinfo : *mut u32 ) -> super::Foundation:: BOOL );
    GetFileMUIInfo(dwflags, pcwszfilepath.into_param().abi(), ::core::mem::transmute(pfilemuiinfo.unwrap_or(::std::ptr::null_mut())), pcbfilemuiinfo)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileMUIPath<P0>(dwflags: u32, pcwszfilepath: P0, pwszlanguage: ::windows::core::PWSTR, pcchlanguage: *mut u32, pwszfilemuipath: ::windows::core::PWSTR, pcchfilemuipath: *mut u32, pululenumerator: *mut u64) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetFileMUIPath ( dwflags : u32 , pcwszfilepath : :: windows::core::PCWSTR , pwszlanguage : :: windows::core::PWSTR , pcchlanguage : *mut u32 , pwszfilemuipath : :: windows::core::PWSTR , pcchfilemuipath : *mut u32 , pululenumerator : *mut u64 ) -> super::Foundation:: BOOL );
    GetFileMUIPath(dwflags, pcwszfilepath.into_param().abi(), ::core::mem::transmute(pwszlanguage), pcchlanguage, ::core::mem::transmute(pwszfilemuipath), pcchfilemuipath, pululenumerator)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetGeoInfoA(location: i32, geotype: u32, lpgeodata: ::core::option::Option<&mut [u8]>, langid: u16) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetGeoInfoA ( location : i32 , geotype : u32 , lpgeodata : :: windows::core::PSTR , cchdata : i32 , langid : u16 ) -> i32 );
    GetGeoInfoA(location, geotype, ::core::mem::transmute(lpgeodata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpgeodata.as_deref().map_or(0, |slice| slice.len() as _), langid)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetGeoInfoEx<P0>(location: P0, geotype: u32, geodata: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetGeoInfoEx ( location : :: windows::core::PCWSTR , geotype : u32 , geodata : :: windows::core::PWSTR , geodatacount : i32 ) -> i32 );
    GetGeoInfoEx(location.into_param().abi(), geotype, ::core::mem::transmute(geodata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), geodata.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetGeoInfoW(location: i32, geotype: u32, lpgeodata: ::core::option::Option<&mut [u16]>, langid: u16) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetGeoInfoW ( location : i32 , geotype : u32 , lpgeodata : :: windows::core::PWSTR , cchdata : i32 , langid : u16 ) -> i32 );
    GetGeoInfoW(location, geotype, ::core::mem::transmute(lpgeodata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpgeodata.as_deref().map_or(0, |slice| slice.len() as _), langid)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetLocaleInfoA(locale: u32, lctype: u32, lplcdata: ::core::option::Option<&mut [u8]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetLocaleInfoA ( locale : u32 , lctype : u32 , lplcdata : :: windows::core::PSTR , cchdata : i32 ) -> i32 );
    GetLocaleInfoA(locale, lctype, ::core::mem::transmute(lplcdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lplcdata.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetLocaleInfoEx<P0>(lplocalename: P0, lctype: u32, lplcdata: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetLocaleInfoEx ( lplocalename : :: windows::core::PCWSTR , lctype : u32 , lplcdata : :: windows::core::PWSTR , cchdata : i32 ) -> i32 );
    GetLocaleInfoEx(lplocalename.into_param().abi(), lctype, ::core::mem::transmute(lplcdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lplcdata.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetLocaleInfoW(locale: u32, lctype: u32, lplcdata: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetLocaleInfoW ( locale : u32 , lctype : u32 , lplcdata : :: windows::core::PWSTR , cchdata : i32 ) -> i32 );
    GetLocaleInfoW(locale, lctype, ::core::mem::transmute(lplcdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lplcdata.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNLSVersion(function: u32, locale: u32, lpversioninformation: *mut NLSVERSIONINFO) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetNLSVersion ( function : u32 , locale : u32 , lpversioninformation : *mut NLSVERSIONINFO ) -> super::Foundation:: BOOL );
    GetNLSVersion(function, locale, lpversioninformation)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNLSVersionEx<P0>(function: u32, lplocalename: P0, lpversioninformation: *mut NLSVERSIONINFOEX) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetNLSVersionEx ( function : u32 , lplocalename : :: windows::core::PCWSTR , lpversioninformation : *mut NLSVERSIONINFOEX ) -> super::Foundation:: BOOL );
    GetNLSVersionEx(function, lplocalename.into_param().abi(), lpversioninformation)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetNumberFormatA<P0>(locale: u32, dwflags: u32, lpvalue: P0, lpformat: ::core::option::Option<*const NUMBERFMTA>, lpnumberstr: ::core::option::Option<&mut [u8]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetNumberFormatA ( locale : u32 , dwflags : u32 , lpvalue : :: windows::core::PCSTR , lpformat : *const NUMBERFMTA , lpnumberstr : :: windows::core::PSTR , cchnumber : i32 ) -> i32 );
    GetNumberFormatA(locale, dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpnumberstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpnumberstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetNumberFormatEx<P0, P1>(lplocalename: P0, dwflags: u32, lpvalue: P1, lpformat: ::core::option::Option<*const NUMBERFMTW>, lpnumberstr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetNumberFormatEx ( lplocalename : :: windows::core::PCWSTR , dwflags : u32 , lpvalue : :: windows::core::PCWSTR , lpformat : *const NUMBERFMTW , lpnumberstr : :: windows::core::PWSTR , cchnumber : i32 ) -> i32 );
    GetNumberFormatEx(lplocalename.into_param().abi(), dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpnumberstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpnumberstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetNumberFormatW<P0>(locale: u32, dwflags: u32, lpvalue: P0, lpformat: ::core::option::Option<*const NUMBERFMTW>, lpnumberstr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetNumberFormatW ( locale : u32 , dwflags : u32 , lpvalue : :: windows::core::PCWSTR , lpformat : *const NUMBERFMTW , lpnumberstr : :: windows::core::PWSTR , cchnumber : i32 ) -> i32 );
    GetNumberFormatW(locale, dwflags, lpvalue.into_param().abi(), ::core::mem::transmute(lpformat.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpnumberstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpnumberstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetOEMCP() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetOEMCP ( ) -> u32 );
    GetOEMCP()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProcessPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: ::windows::core::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetProcessPreferredUILanguages ( dwflags : u32 , pulnumlanguages : *mut u32 , pwszlanguagesbuffer : :: windows::core::PWSTR , pcchlanguagesbuffer : *mut u32 ) -> super::Foundation:: BOOL );
    GetProcessPreferredUILanguages(dwflags, pulnumlanguages, ::core::mem::transmute(pwszlanguagesbuffer), pcchlanguagesbuffer)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetStringScripts<P0>(dwflags: u32, lpstring: P0, cchstring: i32, lpscripts: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetStringScripts ( dwflags : u32 , lpstring : :: windows::core::PCWSTR , cchstring : i32 , lpscripts : :: windows::core::PWSTR , cchscripts : i32 ) -> i32 );
    GetStringScripts(dwflags, lpstring.into_param().abi(), cchstring, ::core::mem::transmute(lpscripts.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpscripts.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeA(locale: u32, dwinfotype: u32, lpsrcstr: &[u8], lpchartype: *mut u16) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetStringTypeA ( locale : u32 , dwinfotype : u32 , lpsrcstr : :: windows::core::PCSTR , cchsrc : i32 , lpchartype : *mut u16 ) -> super::Foundation:: BOOL );
    GetStringTypeA(locale, dwinfotype, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, lpchartype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeExA<P0>(locale: u32, dwinfotype: u32, lpsrcstr: P0, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetStringTypeExA ( locale : u32 , dwinfotype : u32 , lpsrcstr : :: windows::core::PCSTR , cchsrc : i32 , lpchartype : *mut u16 ) -> super::Foundation:: BOOL );
    GetStringTypeExA(locale, dwinfotype, lpsrcstr.into_param().abi(), cchsrc, lpchartype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeExW<P0>(locale: u32, dwinfotype: u32, lpsrcstr: P0, cchsrc: i32, lpchartype: *mut u16) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetStringTypeExW ( locale : u32 , dwinfotype : u32 , lpsrcstr : :: windows::core::PCWSTR , cchsrc : i32 , lpchartype : *mut u16 ) -> super::Foundation:: BOOL );
    GetStringTypeExW(locale, dwinfotype, lpsrcstr.into_param().abi(), cchsrc, lpchartype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetStringTypeW(dwinfotype: u32, lpsrcstr: &[u16], lpchartype: *mut u16) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetStringTypeW ( dwinfotype : u32 , lpsrcstr : :: windows::core::PCWSTR , cchsrc : i32 , lpchartype : *mut u16 ) -> super::Foundation:: BOOL );
    GetStringTypeW(dwinfotype, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, lpchartype)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetSystemDefaultLCID() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetSystemDefaultLCID ( ) -> u32 );
    GetSystemDefaultLCID()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetSystemDefaultLangID() -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetSystemDefaultLangID ( ) -> u16 );
    GetSystemDefaultLangID()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetSystemDefaultLocaleName(lplocalename: &mut [u16]) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetSystemDefaultLocaleName ( lplocalename : :: windows::core::PWSTR , cchlocalename : i32 ) -> i32 );
    GetSystemDefaultLocaleName(::core::mem::transmute(lplocalename.as_ptr()), lplocalename.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetSystemDefaultUILanguage() -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetSystemDefaultUILanguage ( ) -> u16 );
    GetSystemDefaultUILanguage()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetSystemPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: ::windows::core::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetSystemPreferredUILanguages ( dwflags : u32 , pulnumlanguages : *mut u32 , pwszlanguagesbuffer : :: windows::core::PWSTR , pcchlanguagesbuffer : *mut u32 ) -> super::Foundation:: BOOL );
    GetSystemPreferredUILanguages(dwflags, pulnumlanguages, ::core::mem::transmute(pwszlanguagesbuffer), pcchlanguagesbuffer)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn GetTextCharset<P0>(hdc: P0) -> i32
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "gdi32.dll""system" fn GetTextCharset ( hdc : super::Graphics::Gdi:: HDC ) -> i32 );
    GetTextCharset(hdc.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn GetTextCharsetInfo<P0>(hdc: P0, lpsig: ::core::option::Option<*mut FONTSIGNATURE>, dwflags: u32) -> i32
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "gdi32.dll""system" fn GetTextCharsetInfo ( hdc : super::Graphics::Gdi:: HDC , lpsig : *mut FONTSIGNATURE , dwflags : u32 ) -> i32 );
    GetTextCharsetInfo(hdc.into_param().abi(), ::core::mem::transmute(lpsig.unwrap_or(::std::ptr::null_mut())), dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetThreadLocale() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadLocale ( ) -> u32 );
    GetThreadLocale()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: ::windows::core::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadPreferredUILanguages ( dwflags : u32 , pulnumlanguages : *mut u32 , pwszlanguagesbuffer : :: windows::core::PWSTR , pcchlanguagesbuffer : *mut u32 ) -> super::Foundation:: BOOL );
    GetThreadPreferredUILanguages(dwflags, pulnumlanguages, ::core::mem::transmute(pwszlanguagesbuffer), pcchlanguagesbuffer)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetThreadUILanguage() -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadUILanguage ( ) -> u16 );
    GetThreadUILanguage()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatA<P0>(locale: u32, dwflags: u32, lptime: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P0, lptimestr: ::core::option::Option<&mut [u8]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetTimeFormatA ( locale : u32 , dwflags : u32 , lptime : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCSTR , lptimestr : :: windows::core::PSTR , cchtime : i32 ) -> i32 );
    GetTimeFormatA(locale, dwflags, ::core::mem::transmute(lptime.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lptimestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lptimestr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatEx<P0, P1>(lplocalename: P0, dwflags: TIME_FORMAT_FLAGS, lptime: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P1, lptimestr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetTimeFormatEx ( lplocalename : :: windows::core::PCWSTR , dwflags : TIME_FORMAT_FLAGS , lptime : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCWSTR , lptimestr : :: windows::core::PWSTR , cchtime : i32 ) -> i32 );
    GetTimeFormatEx(lplocalename.into_param().abi(), dwflags, ::core::mem::transmute(lptime.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lptimestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lptimestr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimeFormatW<P0>(locale: u32, dwflags: u32, lptime: ::core::option::Option<*const super::Foundation::SYSTEMTIME>, lpformat: P0, lptimestr: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetTimeFormatW ( locale : u32 , dwflags : u32 , lptime : *const super::Foundation:: SYSTEMTIME , lpformat : :: windows::core::PCWSTR , lptimestr : :: windows::core::PWSTR , cchtime : i32 ) -> i32 );
    GetTimeFormatW(locale, dwflags, ::core::mem::transmute(lptime.unwrap_or(::std::ptr::null())), lpformat.into_param().abi(), ::core::mem::transmute(lptimestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lptimestr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUILanguageInfo<P0>(dwflags: u32, pwmszlanguage: P0, pwszfallbacklanguages: ::windows::core::PWSTR, pcchfallbacklanguages: ::core::option::Option<*mut u32>, pattributes: *mut u32) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUILanguageInfo ( dwflags : u32 , pwmszlanguage : :: windows::core::PCWSTR , pwszfallbacklanguages : :: windows::core::PWSTR , pcchfallbacklanguages : *mut u32 , pattributes : *mut u32 ) -> super::Foundation:: BOOL );
    GetUILanguageInfo(dwflags, pwmszlanguage.into_param().abi(), ::core::mem::transmute(pwszfallbacklanguages), ::core::mem::transmute(pcchfallbacklanguages.unwrap_or(::std::ptr::null_mut())), pattributes)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserDefaultGeoName(geoname: &mut [u16]) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserDefaultGeoName ( geoname : :: windows::core::PWSTR , geonamecount : i32 ) -> i32 );
    GetUserDefaultGeoName(::core::mem::transmute(geoname.as_ptr()), geoname.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserDefaultLCID() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserDefaultLCID ( ) -> u32 );
    GetUserDefaultLCID()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserDefaultLangID() -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserDefaultLangID ( ) -> u16 );
    GetUserDefaultLangID()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserDefaultLocaleName(lplocalename: &mut [u16]) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserDefaultLocaleName ( lplocalename : :: windows::core::PWSTR , cchlocalename : i32 ) -> i32 );
    GetUserDefaultLocaleName(::core::mem::transmute(lplocalename.as_ptr()), lplocalename.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserDefaultUILanguage() -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserDefaultUILanguage ( ) -> u16 );
    GetUserDefaultUILanguage()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn GetUserGeoID(geoclass: u32) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserGeoID ( geoclass : u32 ) -> i32 );
    GetUserGeoID(geoclass)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserPreferredUILanguages(dwflags: u32, pulnumlanguages: *mut u32, pwszlanguagesbuffer: ::windows::core::PWSTR, pcchlanguagesbuffer: *mut u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetUserPreferredUILanguages ( dwflags : u32 , pulnumlanguages : *mut u32 , pwszlanguagesbuffer : :: windows::core::PWSTR , pcchlanguagesbuffer : *mut u32 ) -> super::Foundation:: BOOL );
    GetUserPreferredUILanguages(dwflags, pulnumlanguages, ::core::mem::transmute(pwszlanguagesbuffer), pcchlanguagesbuffer)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn IdnToAscii(dwflags: u32, lpunicodecharstr: &[u16], lpasciicharstr: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "normaliz.dll""system" fn IdnToAscii ( dwflags : u32 , lpunicodecharstr : :: windows::core::PCWSTR , cchunicodechar : i32 , lpasciicharstr : :: windows::core::PWSTR , cchasciichar : i32 ) -> i32 );
    IdnToAscii(dwflags, ::core::mem::transmute(lpunicodecharstr.as_ptr()), lpunicodecharstr.len() as _, ::core::mem::transmute(lpasciicharstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpasciicharstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn IdnToNameprepUnicode(dwflags: u32, lpunicodecharstr: &[u16], lpnameprepcharstr: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IdnToNameprepUnicode ( dwflags : u32 , lpunicodecharstr : :: windows::core::PCWSTR , cchunicodechar : i32 , lpnameprepcharstr : :: windows::core::PWSTR , cchnameprepchar : i32 ) -> i32 );
    IdnToNameprepUnicode(dwflags, ::core::mem::transmute(lpunicodecharstr.as_ptr()), lpunicodecharstr.len() as _, ::core::mem::transmute(lpnameprepcharstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpnameprepcharstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn IdnToUnicode(dwflags: u32, lpasciicharstr: &[u16], lpunicodecharstr: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "normaliz.dll""system" fn IdnToUnicode ( dwflags : u32 , lpasciicharstr : :: windows::core::PCWSTR , cchasciichar : i32 , lpunicodecharstr : :: windows::core::PWSTR , cchunicodechar : i32 ) -> i32 );
    IdnToUnicode(dwflags, ::core::mem::transmute(lpasciicharstr.as_ptr()), lpasciicharstr.len() as _, ::core::mem::transmute(lpunicodecharstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpunicodecharstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsDBCSLeadByte(testchar: u8) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsDBCSLeadByte ( testchar : u8 ) -> super::Foundation:: BOOL );
    IsDBCSLeadByte(testchar)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsDBCSLeadByteEx(codepage: u32, testchar: u8) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsDBCSLeadByteEx ( codepage : u32 , testchar : u8 ) -> super::Foundation:: BOOL );
    IsDBCSLeadByteEx(codepage, testchar)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsNLSDefinedString(function: u32, dwflags: u32, lpversioninformation: *const NLSVERSIONINFO, lpstring: &[u16]) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsNLSDefinedString ( function : u32 , dwflags : u32 , lpversioninformation : *const NLSVERSIONINFO , lpstring : :: windows::core::PCWSTR , cchstr : i32 ) -> super::Foundation:: BOOL );
    IsNLSDefinedString(function, dwflags, lpversioninformation, ::core::mem::transmute(lpstring.as_ptr()), lpstring.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsNormalizedString(normform: NORM_FORM, lpstring: &[u16]) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsNormalizedString ( normform : NORM_FORM , lpstring : :: windows::core::PCWSTR , cwlength : i32 ) -> super::Foundation:: BOOL );
    IsNormalizedString(normform, ::core::mem::transmute(lpstring.as_ptr()), lpstring.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsTextUnicode(lpv: *const ::core::ffi::c_void, isize: i32, lpiresult: ::core::option::Option<*mut IS_TEXT_UNICODE_RESULT>) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "advapi32.dll""system" fn IsTextUnicode ( lpv : *const ::core::ffi::c_void , isize : i32 , lpiresult : *mut IS_TEXT_UNICODE_RESULT ) -> super::Foundation:: BOOL );
    IsTextUnicode(lpv, isize, ::core::mem::transmute(lpiresult.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidCodePage(codepage: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsValidCodePage ( codepage : u32 ) -> super::Foundation:: BOOL );
    IsValidCodePage(codepage)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLanguageGroup(languagegroup: u32, dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsValidLanguageGroup ( languagegroup : u32 , dwflags : ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS ) -> super::Foundation:: BOOL );
    IsValidLanguageGroup(languagegroup, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLocale(locale: u32, dwflags: IS_VALID_LOCALE_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsValidLocale ( locale : u32 , dwflags : IS_VALID_LOCALE_FLAGS ) -> super::Foundation:: BOOL );
    IsValidLocale(locale, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsValidLocaleName<P0>(lplocalename: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsValidLocaleName ( lplocalename : :: windows::core::PCWSTR ) -> super::Foundation:: BOOL );
    IsValidLocaleName(lplocalename.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn IsValidNLSVersion<P0>(function: u32, lplocalename: P0, lpversioninformation: *const NLSVERSIONINFOEX) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsValidNLSVersion ( function : u32 , lplocalename : :: windows::core::PCWSTR , lpversioninformation : *const NLSVERSIONINFOEX ) -> u32 );
    IsValidNLSVersion(function, lplocalename.into_param().abi(), lpversioninformation)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn IsWellFormedTag<P0>(psztag: P0) -> u8
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "bcp47mrm.dll""system" fn IsWellFormedTag ( psztag : :: windows::core::PCWSTR ) -> u8 );
    IsWellFormedTag(psztag.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn LCIDToLocaleName(locale: u32, lpname: ::core::option::Option<&mut [u16]>, dwflags: u32) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn LCIDToLocaleName ( locale : u32 , lpname : :: windows::core::PWSTR , cchname : i32 , dwflags : u32 ) -> i32 );
    LCIDToLocaleName(locale, ::core::mem::transmute(lpname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpname.as_deref().map_or(0, |slice| slice.len() as _), dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn LCMapStringA(locale: u32, dwmapflags: u32, lpsrcstr: &[u8], lpdeststr: ::windows::core::PSTR, cchdest: i32) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn LCMapStringA ( locale : u32 , dwmapflags : u32 , lpsrcstr : :: windows::core::PCSTR , cchsrc : i32 , lpdeststr : :: windows::core::PSTR , cchdest : i32 ) -> i32 );
    LCMapStringA(locale, dwmapflags, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, ::core::mem::transmute(lpdeststr), cchdest)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LCMapStringEx<P0, P1>(lplocalename: P0, dwmapflags: u32, lpsrcstr: &[u16], lpdeststr: ::core::option::Option<&mut [u16]>, lpversioninformation: ::core::option::Option<*const NLSVERSIONINFO>, lpreserved: ::core::option::Option<*const ::core::ffi::c_void>, sorthandle: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<super::Foundation::LPARAM>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn LCMapStringEx ( lplocalename : :: windows::core::PCWSTR , dwmapflags : u32 , lpsrcstr : :: windows::core::PCWSTR , cchsrc : i32 , lpdeststr : :: windows::core::PWSTR , cchdest : i32 , lpversioninformation : *const NLSVERSIONINFO , lpreserved : *const ::core::ffi::c_void , sorthandle : super::Foundation:: LPARAM ) -> i32 );
    LCMapStringEx(lplocalename.into_param().abi(), dwmapflags, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, ::core::mem::transmute(lpdeststr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdeststr.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lpversioninformation.unwrap_or(::std::ptr::null())), ::core::mem::transmute(lpreserved.unwrap_or(::std::ptr::null())), sorthandle.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn LCMapStringW(locale: u32, dwmapflags: u32, lpsrcstr: &[u16], lpdeststr: ::windows::core::PWSTR, cchdest: i32) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn LCMapStringW ( locale : u32 , dwmapflags : u32 , lpsrcstr : :: windows::core::PCWSTR , cchsrc : i32 , lpdeststr : :: windows::core::PWSTR , cchdest : i32 ) -> i32 );
    LCMapStringW(locale, dwmapflags, ::core::mem::transmute(lpsrcstr.as_ptr()), lpsrcstr.len() as _, ::core::mem::transmute(lpdeststr), cchdest)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn LocaleNameToLCID<P0>(lpname: P0, dwflags: u32) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn LocaleNameToLCID ( lpname : :: windows::core::PCWSTR , dwflags : u32 ) -> u32 );
    LocaleNameToLCID(lpname.into_param().abi(), dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MappingDoAction<P0>(pbag: *mut MAPPING_PROPERTY_BAG, dwrangeindex: u32, pszactionid: P0) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "elscore.dll""system" fn MappingDoAction ( pbag : *mut MAPPING_PROPERTY_BAG , dwrangeindex : u32 , pszactionid : :: windows::core::PCWSTR ) -> :: windows::core::HRESULT );
    MappingDoAction(pbag, dwrangeindex, pszactionid.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MappingFreePropertyBag(pbag: *const MAPPING_PROPERTY_BAG) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "elscore.dll""system" fn MappingFreePropertyBag ( pbag : *const MAPPING_PROPERTY_BAG ) -> :: windows::core::HRESULT );
    MappingFreePropertyBag(pbag).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MappingFreeServices(pserviceinfo: *const MAPPING_SERVICE_INFO) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "elscore.dll""system" fn MappingFreeServices ( pserviceinfo : *const MAPPING_SERVICE_INFO ) -> :: windows::core::HRESULT );
    MappingFreeServices(pserviceinfo).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MappingGetServices(poptions: ::core::option::Option<*const MAPPING_ENUM_OPTIONS>, prgservices: *mut *mut MAPPING_SERVICE_INFO, pdwservicescount: *mut u32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "elscore.dll""system" fn MappingGetServices ( poptions : *const MAPPING_ENUM_OPTIONS , prgservices : *mut *mut MAPPING_SERVICE_INFO , pdwservicescount : *mut u32 ) -> :: windows::core::HRESULT );
    MappingGetServices(::core::mem::transmute(poptions.unwrap_or(::std::ptr::null())), prgservices, pdwservicescount).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MappingRecognizeText(pserviceinfo: *const MAPPING_SERVICE_INFO, psztext: &[u16], dwindex: u32, poptions: ::core::option::Option<*const MAPPING_OPTIONS>, pbag: *mut MAPPING_PROPERTY_BAG) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "elscore.dll""system" fn MappingRecognizeText ( pserviceinfo : *const MAPPING_SERVICE_INFO , psztext : :: windows::core::PCWSTR , dwlength : u32 , dwindex : u32 , poptions : *const MAPPING_OPTIONS , pbag : *mut MAPPING_PROPERTY_BAG ) -> :: windows::core::HRESULT );
    MappingRecognizeText(pserviceinfo, ::core::mem::transmute(psztext.as_ptr()), psztext.len() as _, dwindex, ::core::mem::transmute(poptions.unwrap_or(::std::ptr::null())), pbag).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn MultiByteToWideChar(codepage: u32, dwflags: MULTI_BYTE_TO_WIDE_CHAR_FLAGS, lpmultibytestr: &[u8], lpwidecharstr: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn MultiByteToWideChar ( codepage : u32 , dwflags : MULTI_BYTE_TO_WIDE_CHAR_FLAGS , lpmultibytestr : :: windows::core::PCSTR , cbmultibyte : i32 , lpwidecharstr : :: windows::core::PWSTR , cchwidechar : i32 ) -> i32 );
    MultiByteToWideChar(codepage, dwflags, ::core::mem::transmute(lpmultibytestr.as_ptr()), lpmultibytestr.len() as _, ::core::mem::transmute(lpwidecharstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpwidecharstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn NormalizeString(normform: NORM_FORM, lpsrcstring: &[u16], lpdststring: ::core::option::Option<&mut [u16]>) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn NormalizeString ( normform : NORM_FORM , lpsrcstring : :: windows::core::PCWSTR , cwsrclength : i32 , lpdststring : :: windows::core::PWSTR , cwdstlength : i32 ) -> i32 );
    NormalizeString(normform, ::core::mem::transmute(lpsrcstring.as_ptr()), lpsrcstring.len() as _, ::core::mem::transmute(lpdststring.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpdststring.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NotifyUILanguageChange<P0, P1>(dwflags: u32, pcwstrnewlanguage: P0, pcwstrpreviouslanguage: P1, dwreserved: u32, pdwstatusrtrn: ::core::option::Option<*mut u32>) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn NotifyUILanguageChange ( dwflags : u32 , pcwstrnewlanguage : :: windows::core::PCWSTR , pcwstrpreviouslanguage : :: windows::core::PCWSTR , dwreserved : u32 , pdwstatusrtrn : *mut u32 ) -> super::Foundation:: BOOL );
    NotifyUILanguageChange(dwflags, pcwstrnewlanguage.into_param().abi(), pcwstrpreviouslanguage.into_param().abi(), dwreserved, ::core::mem::transmute(pdwstatusrtrn.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ResolveLocaleName<P0>(lpnametoresolve: P0, lplocalename: ::core::option::Option<&mut [u16]>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn ResolveLocaleName ( lpnametoresolve : :: windows::core::PCWSTR , lplocalename : :: windows::core::PWSTR , cchlocalename : i32 ) -> i32 );
    ResolveLocaleName(lpnametoresolve.into_param().abi(), ::core::mem::transmute(lplocalename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lplocalename.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn RestoreThreadPreferredUILanguages<P0>(snapshot: P0)
where
    P0: ::windows::core::IntoParam<HSAVEDUILANGUAGES>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn RestoreThreadPreferredUILanguages ( snapshot : HSAVEDUILANGUAGES ) -> ( ) );
    RestoreThreadPreferredUILanguages(snapshot.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptApplyDigitSubstitution(psds: *const SCRIPT_DIGITSUBSTITUTE, psc: *mut SCRIPT_CONTROL, pss: *mut SCRIPT_STATE) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptApplyDigitSubstitution ( psds : *const SCRIPT_DIGITSUBSTITUTE , psc : *mut SCRIPT_CONTROL , pss : *mut SCRIPT_STATE ) -> :: windows::core::HRESULT );
    ScriptApplyDigitSubstitution(psds, psc, pss).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptApplyLogicalWidth(pidx: *const i32, cchars: i32, cglyphs: i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pabc: ::core::option::Option<*mut super::Graphics::Gdi::ABC>, pijustify: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptApplyLogicalWidth ( pidx : *const i32 , cchars : i32 , cglyphs : i32 , pwlogclust : *const u16 , psva : *const SCRIPT_VISATTR , piadvance : *const i32 , psa : *const SCRIPT_ANALYSIS , pabc : *mut super::Graphics::Gdi:: ABC , pijustify : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptApplyLogicalWidth(pidx, cchars, cglyphs, pwlogclust, psva, piadvance, psa, ::core::mem::transmute(pabc.unwrap_or(::std::ptr::null_mut())), pijustify).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptBreak<P0>(pwcchars: P0, cchars: i32, psa: *const SCRIPT_ANALYSIS, psla: *mut SCRIPT_LOGATTR) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptBreak ( pwcchars : :: windows::core::PCWSTR , cchars : i32 , psa : *const SCRIPT_ANALYSIS , psla : *mut SCRIPT_LOGATTR ) -> :: windows::core::HRESULT );
    ScriptBreak(pwcchars.into_param().abi(), cchars, psa, psla).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptCPtoX<P0>(icp: i32, ftrailing: P0, cglyphs: i32, pwlogclust: &[u16], psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, pix: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptCPtoX ( icp : i32 , ftrailing : super::Foundation:: BOOL , cchars : i32 , cglyphs : i32 , pwlogclust : *const u16 , psva : *const SCRIPT_VISATTR , piadvance : *const i32 , psa : *const SCRIPT_ANALYSIS , pix : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptCPtoX(icp, ftrailing.into_param().abi(), pwlogclust.len() as _, cglyphs, ::core::mem::transmute(pwlogclust.as_ptr()), psva, piadvance, psa, pix).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptCacheGetHeight<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, tmheight: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptCacheGetHeight ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , tmheight : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptCacheGetHeight(hdc.into_param().abi(), psc, tmheight).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptFreeCache(psc: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptFreeCache ( psc : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    ScriptFreeCache(psc).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetCMap<P0, P1>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, pwcinchars: P1, cchars: i32, dwflags: u32, pwoutglyphs: *mut u16) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetCMap ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , pwcinchars : :: windows::core::PCWSTR , cchars : i32 , dwflags : u32 , pwoutglyphs : *mut u16 ) -> :: windows::core::HRESULT );
    ScriptGetCMap(hdc.into_param().abi(), psc, pwcinchars.into_param().abi(), cchars, dwflags, pwoutglyphs).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontAlternateGlyphs<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, tagscript: u32, taglangsys: u32, tagfeature: u32, wglyphid: u16, palternateglyphs: &mut [u16], pcalternates: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetFontAlternateGlyphs ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , tagfeature : u32 , wglyphid : u16 , cmaxalternates : i32 , palternateglyphs : *mut u16 , pcalternates : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptGetFontAlternateGlyphs(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), tagscript, taglangsys, tagfeature, wglyphid, palternateglyphs.len() as _, ::core::mem::transmute(palternateglyphs.as_ptr()), pcalternates).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontFeatureTags<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, tagscript: u32, taglangsys: u32, pfeaturetags: &mut [u32], pctags: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetFontFeatureTags ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , cmaxtags : i32 , pfeaturetags : *mut u32 , pctags : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptGetFontFeatureTags(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), tagscript, taglangsys, pfeaturetags.len() as _, ::core::mem::transmute(pfeaturetags.as_ptr()), pctags).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontLanguageTags<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, tagscript: u32, plangsystags: &mut [u32], pctags: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetFontLanguageTags ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , tagscript : u32 , cmaxtags : i32 , plangsystags : *mut u32 , pctags : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptGetFontLanguageTags(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), tagscript, plangsystags.len() as _, ::core::mem::transmute(plangsystags.as_ptr()), pctags).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontProperties<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, sfp: *mut SCRIPT_FONTPROPERTIES) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetFontProperties ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , sfp : *mut SCRIPT_FONTPROPERTIES ) -> :: windows::core::HRESULT );
    ScriptGetFontProperties(hdc.into_param().abi(), psc, sfp).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetFontScriptTags<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, pscripttags: &mut [u32], pctags: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetFontScriptTags ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , cmaxtags : i32 , pscripttags : *mut u32 , pctags : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptGetFontScriptTags(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), pscripttags.len() as _, ::core::mem::transmute(pscripttags.as_ptr()), pctags).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptGetGlyphABCWidth<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, wglyph: u16, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetGlyphABCWidth ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , wglyph : u16 , pabc : *mut super::Graphics::Gdi:: ABC ) -> :: windows::core::HRESULT );
    ScriptGetGlyphABCWidth(hdc.into_param().abi(), psc, wglyph, pabc).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptGetLogicalWidths(psa: *const SCRIPT_ANALYSIS, cchars: i32, cglyphs: i32, piglyphwidth: *const i32, pwlogclust: *const u16, psva: *const SCRIPT_VISATTR, pidx: *const i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetLogicalWidths ( psa : *const SCRIPT_ANALYSIS , cchars : i32 , cglyphs : i32 , piglyphwidth : *const i32 , pwlogclust : *const u16 , psva : *const SCRIPT_VISATTR , pidx : *const i32 ) -> :: windows::core::HRESULT );
    ScriptGetLogicalWidths(psa, cchars, cglyphs, piglyphwidth, pwlogclust, psva, pidx).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptGetProperties(ppsp: *mut *mut *mut SCRIPT_PROPERTIES, pinumscripts: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptGetProperties ( ppsp : *mut *mut *mut SCRIPT_PROPERTIES , pinumscripts : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptGetProperties(ppsp, pinumscripts).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptIsComplex(pwcinchars: &[u16], dwflags: SCRIPT_IS_COMPLEX_FLAGS) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptIsComplex ( pwcinchars : :: windows::core::PCWSTR , cinchars : i32 , dwflags : SCRIPT_IS_COMPLEX_FLAGS ) -> :: windows::core::HRESULT );
    ScriptIsComplex(::core::mem::transmute(pwcinchars.as_ptr()), pwcinchars.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptItemize(pwcinchars: &[u16], pscontrol: ::core::option::Option<*const SCRIPT_CONTROL>, psstate: ::core::option::Option<*const SCRIPT_STATE>, pitems: &mut [SCRIPT_ITEM], pcitems: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptItemize ( pwcinchars : :: windows::core::PCWSTR , cinchars : i32 , cmaxitems : i32 , pscontrol : *const SCRIPT_CONTROL , psstate : *const SCRIPT_STATE , pitems : *mut SCRIPT_ITEM , pcitems : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptItemize(::core::mem::transmute(pwcinchars.as_ptr()), pwcinchars.len() as _, pitems.len() as _, ::core::mem::transmute(pscontrol.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psstate.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pitems.as_ptr()), pcitems).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptItemizeOpenType(pwcinchars: &[u16], cmaxitems: i32, pscontrol: ::core::option::Option<*const SCRIPT_CONTROL>, psstate: ::core::option::Option<*const SCRIPT_STATE>, pitems: *mut SCRIPT_ITEM, pscripttags: *mut u32, pcitems: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptItemizeOpenType ( pwcinchars : :: windows::core::PCWSTR , cinchars : i32 , cmaxitems : i32 , pscontrol : *const SCRIPT_CONTROL , psstate : *const SCRIPT_STATE , pitems : *mut SCRIPT_ITEM , pscripttags : *mut u32 , pcitems : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptItemizeOpenType(::core::mem::transmute(pwcinchars.as_ptr()), pwcinchars.len() as _, cmaxitems, ::core::mem::transmute(pscontrol.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psstate.unwrap_or(::std::ptr::null())), pitems, pscripttags, pcitems).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptJustify(psva: *const SCRIPT_VISATTR, piadvance: *const i32, cglyphs: i32, idx: i32, iminkashida: i32, pijustify: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptJustify ( psva : *const SCRIPT_VISATTR , piadvance : *const i32 , cglyphs : i32 , idx : i32 , iminkashida : i32 , pijustify : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptJustify(psva, piadvance, cglyphs, idx, iminkashida, pijustify).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptLayout(cruns: i32, pblevel: *const u8, pivisualtological: ::core::option::Option<*mut i32>, pilogicaltovisual: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptLayout ( cruns : i32 , pblevel : *const u8 , pivisualtological : *mut i32 , pilogicaltovisual : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptLayout(cruns, pblevel, ::core::mem::transmute(pivisualtological.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pilogicaltovisual.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptPlace<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, pwglyphs: *const u16, cglyphs: i32, psva: *const SCRIPT_VISATTR, psa: *mut SCRIPT_ANALYSIS, piadvance: *mut i32, pgoffset: ::core::option::Option<*mut GOFFSET>, pabc: *mut super::Graphics::Gdi::ABC) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptPlace ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , pwglyphs : *const u16 , cglyphs : i32 , psva : *const SCRIPT_VISATTR , psa : *mut SCRIPT_ANALYSIS , piadvance : *mut i32 , pgoffset : *mut GOFFSET , pabc : *mut super::Graphics::Gdi:: ABC ) -> :: windows::core::HRESULT );
    ScriptPlace(hdc.into_param().abi(), psc, pwglyphs, cglyphs, psva, psa, piadvance, ::core::mem::transmute(pgoffset.unwrap_or(::std::ptr::null_mut())), pabc).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptPlaceOpenType<P0, P1>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: *mut SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, rcrangechars: ::core::option::Option<*const i32>, rprangeproperties: ::core::option::Option<*const *const TEXTRANGE_PROPERTIES>, cranges: i32, pwcchars: P1, pwlogclust: *const u16, pcharprops: *const SCRIPT_CHARPROP, cchars: i32, pwglyphs: *const u16, pglyphprops: *const SCRIPT_GLYPHPROP, cglyphs: i32, piadvance: *mut i32, pgoffset: *mut GOFFSET, pabc: ::core::option::Option<*mut super::Graphics::Gdi::ABC>) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptPlaceOpenType ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *mut SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , rcrangechars : *const i32 , rprangeproperties : *const *const TEXTRANGE_PROPERTIES , cranges : i32 , pwcchars : :: windows::core::PCWSTR , pwlogclust : *const u16 , pcharprops : *const SCRIPT_CHARPROP , cchars : i32 , pwglyphs : *const u16 , pglyphprops : *const SCRIPT_GLYPHPROP , cglyphs : i32 , piadvance : *mut i32 , pgoffset : *mut GOFFSET , pabc : *mut super::Graphics::Gdi:: ABC ) -> :: windows::core::HRESULT );
    ScriptPlaceOpenType(hdc.into_param().abi(), psc, psa, tagscript, taglangsys, ::core::mem::transmute(rcrangechars.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rprangeproperties.unwrap_or(::std::ptr::null())), cranges, pwcchars.into_param().abi(), pwlogclust, pcharprops, cchars, pwglyphs, pglyphprops, cglyphs, piadvance, pgoffset, ::core::mem::transmute(pabc.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptPositionSingleGlyph<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, iadvance: i32, goffset: GOFFSET, pioutadvance: *mut i32, poutgoffset: *mut GOFFSET) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptPositionSingleGlyph ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , tagfeature : u32 , lparameter : i32 , wglyphid : u16 , iadvance : i32 , goffset : GOFFSET , pioutadvance : *mut i32 , poutgoffset : *mut GOFFSET ) -> :: windows::core::HRESULT );
    ScriptPositionSingleGlyph(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), tagscript, taglangsys, tagfeature, lparameter, wglyphid, iadvance, ::core::mem::transmute(goffset), pioutadvance, poutgoffset).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptRecordDigitSubstitution(locale: u32) -> ::windows::core::Result<SCRIPT_DIGITSUBSTITUTE> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptRecordDigitSubstitution ( locale : u32 , psds : *mut SCRIPT_DIGITSUBSTITUTE ) -> :: windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<SCRIPT_DIGITSUBSTITUTE>();
    ScriptRecordDigitSubstitution(locale, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptShape<P0, P1>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, pwcchars: P1, cchars: i32, cmaxglyphs: i32, psa: *mut SCRIPT_ANALYSIS, pwoutglyphs: *mut u16, pwlogclust: *mut u16, psva: *mut SCRIPT_VISATTR, pcglyphs: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptShape ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , pwcchars : :: windows::core::PCWSTR , cchars : i32 , cmaxglyphs : i32 , psa : *mut SCRIPT_ANALYSIS , pwoutglyphs : *mut u16 , pwlogclust : *mut u16 , psva : *mut SCRIPT_VISATTR , pcglyphs : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptShape(hdc.into_param().abi(), psc, pwcchars.into_param().abi(), cchars, cmaxglyphs, psa, pwoutglyphs, pwlogclust, psva, pcglyphs).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptShapeOpenType<P0, P1>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: *mut SCRIPT_ANALYSIS, tagscript: u32, taglangsys: u32, rcrangechars: ::core::option::Option<*const i32>, rprangeproperties: ::core::option::Option<*const *const TEXTRANGE_PROPERTIES>, cranges: i32, pwcchars: P1, cchars: i32, cmaxglyphs: i32, pwlogclust: *mut u16, pcharprops: *mut SCRIPT_CHARPROP, pwoutglyphs: *mut u16, poutglyphprops: *mut SCRIPT_GLYPHPROP, pcglyphs: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptShapeOpenType ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *mut SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , rcrangechars : *const i32 , rprangeproperties : *const *const TEXTRANGE_PROPERTIES , cranges : i32 , pwcchars : :: windows::core::PCWSTR , cchars : i32 , cmaxglyphs : i32 , pwlogclust : *mut u16 , pcharprops : *mut SCRIPT_CHARPROP , pwoutglyphs : *mut u16 , poutglyphprops : *mut SCRIPT_GLYPHPROP , pcglyphs : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptShapeOpenType(hdc.into_param().abi(), psc, psa, tagscript, taglangsys, ::core::mem::transmute(rcrangechars.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rprangeproperties.unwrap_or(::std::ptr::null())), cranges, pwcchars.into_param().abi(), cchars, cmaxglyphs, pwlogclust, pcharprops, pwoutglyphs, poutglyphprops, pcglyphs).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptStringAnalyse<P0>(hdc: P0, pstring: *const ::core::ffi::c_void, cglyphs: i32, icharset: i32, dwflags: u32, ireqwidth: i32, pscontrol: ::core::option::Option<*const SCRIPT_CONTROL>, psstate: ::core::option::Option<*const SCRIPT_STATE>, pidx: ::core::option::Option<&[i32]>, ptabdef: ::core::option::Option<*const SCRIPT_TABDEF>, pbinclass: *const u8, pssa: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringAnalyse ( hdc : super::Graphics::Gdi:: HDC , pstring : *const ::core::ffi::c_void , cstring : i32 , cglyphs : i32 , icharset : i32 , dwflags : u32 , ireqwidth : i32 , pscontrol : *const SCRIPT_CONTROL , psstate : *const SCRIPT_STATE , pidx : *const i32 , ptabdef : *const SCRIPT_TABDEF , pbinclass : *const u8 , pssa : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    ScriptStringAnalyse(hdc.into_param().abi(), pstring, pidx.as_deref().map_or(0, |slice| slice.len() as _), cglyphs, icharset, dwflags, ireqwidth, ::core::mem::transmute(pscontrol.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psstate.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pidx.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(ptabdef.unwrap_or(::std::ptr::null())), pbinclass, pssa).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptStringCPtoX<P0>(ssa: *const ::core::ffi::c_void, icp: i32, ftrailing: P0) -> ::windows::core::Result<i32>
where
    P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringCPtoX ( ssa : *const ::core::ffi::c_void , icp : i32 , ftrailing : super::Foundation:: BOOL , px : *mut i32 ) -> :: windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<i32>();
    ScriptStringCPtoX(ssa, icp, ftrailing.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptStringFree(pssa: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringFree ( pssa : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    ScriptStringFree(pssa).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptStringGetLogicalWidths(ssa: *const ::core::ffi::c_void, pidx: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringGetLogicalWidths ( ssa : *const ::core::ffi::c_void , pidx : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptStringGetLogicalWidths(ssa, pidx).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptStringGetOrder(ssa: *const ::core::ffi::c_void, puorder: *mut u32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringGetOrder ( ssa : *const ::core::ffi::c_void , puorder : *mut u32 ) -> :: windows::core::HRESULT );
    ScriptStringGetOrder(ssa, puorder).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptStringOut<P0>(ssa: *const ::core::ffi::c_void, ix: i32, iy: i32, uoptions: super::Graphics::Gdi::ETO_OPTIONS, prc: ::core::option::Option<*const super::Foundation::RECT>, iminsel: i32, imaxsel: i32, fdisabled: P0) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringOut ( ssa : *const ::core::ffi::c_void , ix : i32 , iy : i32 , uoptions : super::Graphics::Gdi:: ETO_OPTIONS , prc : *const super::Foundation:: RECT , iminsel : i32 , imaxsel : i32 , fdisabled : super::Foundation:: BOOL ) -> :: windows::core::HRESULT );
    ScriptStringOut(ssa, ix, iy, uoptions, ::core::mem::transmute(prc.unwrap_or(::std::ptr::null())), iminsel, imaxsel, fdisabled.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptStringValidate(ssa: *const ::core::ffi::c_void) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringValidate ( ssa : *const ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    ScriptStringValidate(ssa).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptStringXtoCP(ssa: *const ::core::ffi::c_void, ix: i32, pich: *mut i32, pitrailing: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptStringXtoCP ( ssa : *const ::core::ffi::c_void , ix : i32 , pich : *mut i32 , pitrailing : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptStringXtoCP(ssa, ix, pich, pitrailing).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptString_pLogAttr(ssa: *const ::core::ffi::c_void) -> *mut SCRIPT_LOGATTR {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptString_pLogAttr ( ssa : *const ::core::ffi::c_void ) -> *mut SCRIPT_LOGATTR );
    ScriptString_pLogAttr(ssa)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ScriptString_pSize(ssa: *const ::core::ffi::c_void) -> *mut super::Foundation::SIZE {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptString_pSize ( ssa : *const ::core::ffi::c_void ) -> *mut super::Foundation:: SIZE );
    ScriptString_pSize(ssa)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptString_pcOutChars(ssa: *const ::core::ffi::c_void) -> *mut i32 {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptString_pcOutChars ( ssa : *const ::core::ffi::c_void ) -> *mut i32 );
    ScriptString_pcOutChars(ssa)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn ScriptSubstituteSingleGlyph<P0>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, psa: ::core::option::Option<*const SCRIPT_ANALYSIS>, tagscript: u32, taglangsys: u32, tagfeature: u32, lparameter: i32, wglyphid: u16, pwoutglyphid: *mut u16) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptSubstituteSingleGlyph ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , psa : *const SCRIPT_ANALYSIS , tagscript : u32 , taglangsys : u32 , tagfeature : u32 , lparameter : i32 , wglyphid : u16 , pwoutglyphid : *mut u16 ) -> :: windows::core::HRESULT );
    ScriptSubstituteSingleGlyph(hdc.into_param().abi(), psc, ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())), tagscript, taglangsys, tagfeature, lparameter, wglyphid, pwoutglyphid).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn ScriptTextOut<P0, P1>(hdc: P0, psc: *mut *mut ::core::ffi::c_void, x: i32, y: i32, fuoptions: u32, lprc: ::core::option::Option<*const super::Foundation::RECT>, psa: *const SCRIPT_ANALYSIS, pwcreserved: P1, ireserved: i32, pwglyphs: *const u16, cglyphs: i32, piadvance: *const i32, pijustify: ::core::option::Option<*const i32>, pgoffset: *const GOFFSET) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptTextOut ( hdc : super::Graphics::Gdi:: HDC , psc : *mut *mut ::core::ffi::c_void , x : i32 , y : i32 , fuoptions : u32 , lprc : *const super::Foundation:: RECT , psa : *const SCRIPT_ANALYSIS , pwcreserved : :: windows::core::PCWSTR , ireserved : i32 , pwglyphs : *const u16 , cglyphs : i32 , piadvance : *const i32 , pijustify : *const i32 , pgoffset : *const GOFFSET ) -> :: windows::core::HRESULT );
    ScriptTextOut(hdc.into_param().abi(), psc, x, y, fuoptions, ::core::mem::transmute(lprc.unwrap_or(::std::ptr::null())), psa, pwcreserved.into_param().abi(), ireserved, pwglyphs, cglyphs, piadvance, ::core::mem::transmute(pijustify.unwrap_or(::std::ptr::null())), pgoffset).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ScriptXtoCP(ix: i32, cglyphs: i32, pwlogclust: &[u16], psva: *const SCRIPT_VISATTR, piadvance: *const i32, psa: *const SCRIPT_ANALYSIS, picp: *mut i32, pitrailing: *mut i32) -> ::windows::core::Result<()> {
    ::windows::imp::link ! ( "usp10.dll""system" fn ScriptXtoCP ( ix : i32 , cchars : i32 , cglyphs : i32 , pwlogclust : *const u16 , psva : *const SCRIPT_VISATTR , piadvance : *const i32 , psa : *const SCRIPT_ANALYSIS , picp : *mut i32 , pitrailing : *mut i32 ) -> :: windows::core::HRESULT );
    ScriptXtoCP(ix, pwlogclust.len() as _, cglyphs, ::core::mem::transmute(pwlogclust.as_ptr()), psva, piadvance, psa, picp, pitrailing).ok()
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetCalendarInfoA<P0>(locale: u32, calendar: u32, caltype: u32, lpcaldata: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetCalendarInfoA ( locale : u32 , calendar : u32 , caltype : u32 , lpcaldata : :: windows::core::PCSTR ) -> super::Foundation:: BOOL );
    SetCalendarInfoA(locale, calendar, caltype, lpcaldata.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetCalendarInfoW<P0>(locale: u32, calendar: u32, caltype: u32, lpcaldata: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetCalendarInfoW ( locale : u32 , calendar : u32 , caltype : u32 , lpcaldata : :: windows::core::PCWSTR ) -> super::Foundation:: BOOL );
    SetCalendarInfoW(locale, calendar, caltype, lpcaldata.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetLocaleInfoA<P0>(locale: u32, lctype: u32, lplcdata: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetLocaleInfoA ( locale : u32 , lctype : u32 , lplcdata : :: windows::core::PCSTR ) -> super::Foundation:: BOOL );
    SetLocaleInfoA(locale, lctype, lplcdata.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetLocaleInfoW<P0>(locale: u32, lctype: u32, lplcdata: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetLocaleInfoW ( locale : u32 , lctype : u32 , lplcdata : :: windows::core::PCWSTR ) -> super::Foundation:: BOOL );
    SetLocaleInfoW(locale, lctype, lplcdata.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetProcessPreferredUILanguages<P0>(dwflags: u32, pwszlanguagesbuffer: P0, pulnumlanguages: ::core::option::Option<*mut u32>) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetProcessPreferredUILanguages ( dwflags : u32 , pwszlanguagesbuffer : :: windows::core::PCWSTR , pulnumlanguages : *mut u32 ) -> super::Foundation:: BOOL );
    SetProcessPreferredUILanguages(dwflags, pwszlanguagesbuffer.into_param().abi(), ::core::mem::transmute(pulnumlanguages.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadLocale(locale: u32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadLocale ( locale : u32 ) -> super::Foundation:: BOOL );
    SetThreadLocale(locale)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadPreferredUILanguages<P0>(dwflags: u32, pwszlanguagesbuffer: P0, pulnumlanguages: ::core::option::Option<*mut u32>) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadPreferredUILanguages ( dwflags : u32 , pwszlanguagesbuffer : :: windows::core::PCWSTR , pulnumlanguages : *mut u32 ) -> super::Foundation:: BOOL );
    SetThreadPreferredUILanguages(dwflags, pwszlanguagesbuffer.into_param().abi(), ::core::mem::transmute(pulnumlanguages.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadPreferredUILanguages2<P0>(flags: u32, languages: P0, numlanguagesset: ::core::option::Option<*mut u32>, snapshot: ::core::option::Option<*mut HSAVEDUILANGUAGES>) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadPreferredUILanguages2 ( flags : u32 , languages : :: windows::core::PCWSTR , numlanguagesset : *mut u32 , snapshot : *mut HSAVEDUILANGUAGES ) -> super::Foundation:: BOOL );
    SetThreadPreferredUILanguages2(flags, languages.into_param().abi(), ::core::mem::transmute(numlanguagesset.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(snapshot.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn SetThreadUILanguage(langid: u16) -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadUILanguage ( langid : u16 ) -> u16 );
    SetThreadUILanguage(langid)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetUserGeoID(geoid: i32) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetUserGeoID ( geoid : i32 ) -> super::Foundation:: BOOL );
    SetUserGeoID(geoid)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetUserGeoName<P0>(geoname: P0) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetUserGeoName ( geoname : :: windows::core::PCWSTR ) -> super::Foundation:: BOOL );
    SetUserGeoName(geoname.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn TranslateCharsetInfo(lpsrc: *mut u32, lpcs: *mut CHARSETINFO, dwflags: TRANSLATE_CHARSET_INFO_FLAGS) -> super::Foundation::BOOL {
    ::windows::imp::link ! ( "gdi32.dll""system" fn TranslateCharsetInfo ( lpsrc : *mut u32 , lpcs : *mut CHARSETINFO , dwflags : TRANSLATE_CHARSET_INFO_FLAGS ) -> super::Foundation:: BOOL );
    TranslateCharsetInfo(lpsrc, lpcs, dwflags)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_ESCAPE(context: *const ::core::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_FROM_U_CALLBACK_ESCAPE ( context : *const ::core::ffi::c_void , fromuargs : *mut UConverterFromUnicodeArgs , codeunits : *const u16 , length : i32 , codepoint : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_FROM_U_CALLBACK_ESCAPE(context, fromuargs, codeunits, length, codepoint, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_SKIP(context: *const ::core::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_FROM_U_CALLBACK_SKIP ( context : *const ::core::ffi::c_void , fromuargs : *mut UConverterFromUnicodeArgs , codeunits : *const u16 , length : i32 , codepoint : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_FROM_U_CALLBACK_SKIP(context, fromuargs, codeunits, length, codepoint, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_STOP(context: *const ::core::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_FROM_U_CALLBACK_STOP ( context : *const ::core::ffi::c_void , fromuargs : *mut UConverterFromUnicodeArgs , codeunits : *const u16 , length : i32 , codepoint : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_FROM_U_CALLBACK_STOP(context, fromuargs, codeunits, length, codepoint, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_FROM_U_CALLBACK_SUBSTITUTE(context: *const ::core::ffi::c_void, fromuargs: *mut UConverterFromUnicodeArgs, codeunits: *const u16, length: i32, codepoint: i32, reason: UConverterCallbackReason, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_FROM_U_CALLBACK_SUBSTITUTE ( context : *const ::core::ffi::c_void , fromuargs : *mut UConverterFromUnicodeArgs , codeunits : *const u16 , length : i32 , codepoint : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_FROM_U_CALLBACK_SUBSTITUTE(context, fromuargs, codeunits, length, codepoint, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_ESCAPE<P0>(context: *const ::core::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: P0, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_TO_U_CALLBACK_ESCAPE ( context : *const ::core::ffi::c_void , touargs : *mut UConverterToUnicodeArgs , codeunits : :: windows::core::PCSTR , length : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_TO_U_CALLBACK_ESCAPE(context, touargs, codeunits.into_param().abi(), length, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_SKIP<P0>(context: *const ::core::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: P0, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_TO_U_CALLBACK_SKIP ( context : *const ::core::ffi::c_void , touargs : *mut UConverterToUnicodeArgs , codeunits : :: windows::core::PCSTR , length : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_TO_U_CALLBACK_SKIP(context, touargs, codeunits.into_param().abi(), length, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_STOP<P0>(context: *const ::core::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: P0, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_TO_U_CALLBACK_STOP ( context : *const ::core::ffi::c_void , touargs : *mut UConverterToUnicodeArgs , codeunits : :: windows::core::PCSTR , length : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_TO_U_CALLBACK_STOP(context, touargs, codeunits.into_param().abi(), length, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn UCNV_TO_U_CALLBACK_SUBSTITUTE<P0>(context: *const ::core::ffi::c_void, touargs: *mut UConverterToUnicodeArgs, codeunits: P0, length: i32, reason: UConverterCallbackReason, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn UCNV_TO_U_CALLBACK_SUBSTITUTE ( context : *const ::core::ffi::c_void , touargs : *mut UConverterToUnicodeArgs , codeunits : :: windows::core::PCSTR , length : i32 , reason : UConverterCallbackReason , err : *mut UErrorCode ) -> ( ) );
    UCNV_TO_U_CALLBACK_SUBSTITUTE(context, touargs, codeunits.into_param().abi(), length, reason, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn VerifyScripts<P0, P1>(dwflags: u32, lplocalescripts: P0, cchlocalescripts: i32, lptestscripts: P1, cchtestscripts: i32) -> super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn VerifyScripts ( dwflags : u32 , lplocalescripts : :: windows::core::PCWSTR , cchlocalescripts : i32 , lptestscripts : :: windows::core::PCWSTR , cchtestscripts : i32 ) -> super::Foundation:: BOOL );
    VerifyScripts(dwflags, lplocalescripts.into_param().abi(), cchlocalescripts, lptestscripts.into_param().abi(), cchtestscripts)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn WideCharToMultiByte<P0>(codepage: u32, dwflags: u32, lpwidecharstr: &[u16], lpmultibytestr: ::core::option::Option<&mut [u8]>, lpdefaultchar: P0, lpuseddefaultchar: ::core::option::Option<*mut i32>) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn WideCharToMultiByte ( codepage : u32 , dwflags : u32 , lpwidecharstr : :: windows::core::PCWSTR , cchwidechar : i32 , lpmultibytestr : :: windows::core::PSTR , cbmultibyte : i32 , lpdefaultchar : :: windows::core::PCSTR , lpuseddefaultchar : *mut i32 ) -> i32 );
    WideCharToMultiByte(codepage, dwflags, ::core::mem::transmute(lpwidecharstr.as_ptr()), lpwidecharstr.len() as _, ::core::mem::transmute(lpmultibytestr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpmultibytestr.as_deref().map_or(0, |slice| slice.len() as _), lpdefaultchar.into_param().abi(), ::core::mem::transmute(lpuseddefaultchar.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcatA<P0>(lpstring1: ::windows::core::PSTR, lpstring2: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcatA ( lpstring1 : :: windows::core::PSTR , lpstring2 : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    lstrcatA(::core::mem::transmute(lpstring1), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcatW<P0>(lpstring1: ::windows::core::PWSTR, lpstring2: P0) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcatW ( lpstring1 : :: windows::core::PWSTR , lpstring2 : :: windows::core::PCWSTR ) -> :: windows::core::PWSTR );
    lstrcatW(::core::mem::transmute(lpstring1), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcmpA<P0, P1>(lpstring1: P0, lpstring2: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcmpA ( lpstring1 : :: windows::core::PCSTR , lpstring2 : :: windows::core::PCSTR ) -> i32 );
    lstrcmpA(lpstring1.into_param().abi(), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcmpW<P0, P1>(lpstring1: P0, lpstring2: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcmpW ( lpstring1 : :: windows::core::PCWSTR , lpstring2 : :: windows::core::PCWSTR ) -> i32 );
    lstrcmpW(lpstring1.into_param().abi(), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcmpiA<P0, P1>(lpstring1: P0, lpstring2: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcmpiA ( lpstring1 : :: windows::core::PCSTR , lpstring2 : :: windows::core::PCSTR ) -> i32 );
    lstrcmpiA(lpstring1.into_param().abi(), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcmpiW<P0, P1>(lpstring1: P0, lpstring2: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcmpiW ( lpstring1 : :: windows::core::PCWSTR , lpstring2 : :: windows::core::PCWSTR ) -> i32 );
    lstrcmpiW(lpstring1.into_param().abi(), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcpyA<P0>(lpstring1: ::windows::core::PSTR, lpstring2: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcpyA ( lpstring1 : :: windows::core::PSTR , lpstring2 : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    lstrcpyA(::core::mem::transmute(lpstring1), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcpyW<P0>(lpstring1: ::windows::core::PWSTR, lpstring2: P0) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcpyW ( lpstring1 : :: windows::core::PWSTR , lpstring2 : :: windows::core::PCWSTR ) -> :: windows::core::PWSTR );
    lstrcpyW(::core::mem::transmute(lpstring1), lpstring2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcpynA<P0>(lpstring1: &mut [u8], lpstring2: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcpynA ( lpstring1 : :: windows::core::PSTR , lpstring2 : :: windows::core::PCSTR , imaxlength : i32 ) -> :: windows::core::PSTR );
    lstrcpynA(::core::mem::transmute(lpstring1.as_ptr()), lpstring2.into_param().abi(), lpstring1.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrcpynW<P0>(lpstring1: &mut [u16], lpstring2: P0) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrcpynW ( lpstring1 : :: windows::core::PWSTR , lpstring2 : :: windows::core::PCWSTR , imaxlength : i32 ) -> :: windows::core::PWSTR );
    lstrcpynW(::core::mem::transmute(lpstring1.as_ptr()), lpstring2.into_param().abi(), lpstring1.len() as _)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrlenA<P0>(lpstring: P0) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrlenA ( lpstring : :: windows::core::PCSTR ) -> i32 );
    lstrlenA(lpstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn lstrlenW<P0>(lpstring: P0) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn lstrlenW ( lpstring : :: windows::core::PCWSTR ) -> i32 );
    lstrlenW(lpstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_UCharsToChars<P0>(us: *const u16, cs: P0, length: i32)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_UCharsToChars ( us : *const u16 , cs : :: windows::core::PCSTR , length : i32 ) -> ( ) );
    u_UCharsToChars(us, cs.into_param().abi(), length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_austrcpy<P0>(dst: P0, src: *const u16) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_austrcpy ( dst : :: windows::core::PCSTR , src : *const u16 ) -> :: windows::core::PSTR );
    u_austrcpy(dst.into_param().abi(), src)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_austrncpy<P0>(dst: P0, src: *const u16, n: i32) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_austrncpy ( dst : :: windows::core::PCSTR , src : *const u16 , n : i32 ) -> :: windows::core::PSTR );
    u_austrncpy(dst.into_param().abi(), src, n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_catclose(catd: *mut UResourceBundle) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_catclose ( catd : *mut UResourceBundle ) -> ( ) );
    u_catclose(catd)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_catgets(catd: *mut UResourceBundle, set_num: i32, msg_num: i32, s: *const u16, len: *mut i32, ec: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_catgets ( catd : *mut UResourceBundle , set_num : i32 , msg_num : i32 , s : *const u16 , len : *mut i32 , ec : *mut UErrorCode ) -> *mut u16 );
    u_catgets(catd, set_num, msg_num, s, len, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_catopen<P0, P1>(name: P0, locale: P1, ec: *mut UErrorCode) -> *mut UResourceBundle
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_catopen ( name : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , ec : *mut UErrorCode ) -> *mut UResourceBundle );
    u_catopen(name.into_param().abi(), locale.into_param().abi(), ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charAge(c: i32, versionarray: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charAge ( c : i32 , versionarray : *mut u8 ) -> ( ) );
    u_charAge(c, versionarray)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charDigitValue(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charDigitValue ( c : i32 ) -> i32 );
    u_charDigitValue(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charDirection(c: i32) -> UCharDirection {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charDirection ( c : i32 ) -> UCharDirection );
    u_charDirection(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charFromName<P0>(namechoice: UCharNameChoice, name: P0, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charFromName ( namechoice : UCharNameChoice , name : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> i32 );
    u_charFromName(namechoice, name.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charMirror(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charMirror ( c : i32 ) -> i32 );
    u_charMirror(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charName<P0>(code: i32, namechoice: UCharNameChoice, buffer: P0, bufferlength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charName ( code : i32 , namechoice : UCharNameChoice , buffer : :: windows::core::PCSTR , bufferlength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    u_charName(code, namechoice, buffer.into_param().abi(), bufferlength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charType(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charType ( c : i32 ) -> i8 );
    u_charType(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_charsToUChars<P0>(cs: P0, us: *mut u16, length: i32)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_charsToUChars ( cs : :: windows::core::PCSTR , us : *mut u16 , length : i32 ) -> ( ) );
    u_charsToUChars(cs.into_param().abi(), us, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_cleanup() {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_cleanup ( ) -> ( ) );
    u_cleanup()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_countChar32(s: *const u16, length: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_countChar32 ( s : *const u16 , length : i32 ) -> i32 );
    u_countChar32(s, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_digit(ch: i32, radix: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_digit ( ch : i32 , radix : i8 ) -> i32 );
    u_digit(ch, radix)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_enumCharNames(start: i32, limit: i32, r#fn: *mut UEnumCharNamesFn, context: *mut ::core::ffi::c_void, namechoice: UCharNameChoice, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_enumCharNames ( start : i32 , limit : i32 , r#fn : *mut UEnumCharNamesFn , context : *mut ::core::ffi::c_void , namechoice : UCharNameChoice , perrorcode : *mut UErrorCode ) -> ( ) );
    u_enumCharNames(start, limit, r#fn, context, namechoice, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_enumCharTypes(enumrange: *mut UCharEnumTypeRange, context: *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_enumCharTypes ( enumrange : *mut UCharEnumTypeRange , context : *const ::core::ffi::c_void ) -> ( ) );
    u_enumCharTypes(enumrange, context)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_errorName(code: UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_errorName ( code : UErrorCode ) -> :: windows::core::PSTR );
    u_errorName(code)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_foldCase(c: i32, options: u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_foldCase ( c : i32 , options : u32 ) -> i32 );
    u_foldCase(c, options)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_forDigit(digit: i32, radix: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_forDigit ( digit : i32 , radix : i8 ) -> i32 );
    u_forDigit(digit, radix)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_formatMessage<P0>(locale: P0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_formatMessage ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    u_formatMessage(locale.into_param().abi(), pattern, patternlength, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_formatMessageWithError<P0>(locale: P0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_formatMessageWithError ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , result : *mut u16 , resultlength : i32 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> i32 );
    u_formatMessageWithError(locale.into_param().abi(), pattern, patternlength, result, resultlength, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getBidiPairedBracket(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getBidiPairedBracket ( c : i32 ) -> i32 );
    u_getBidiPairedBracket(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getBinaryPropertySet(property: UProperty, perrorcode: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getBinaryPropertySet ( property : UProperty , perrorcode : *mut UErrorCode ) -> *mut USet );
    u_getBinaryPropertySet(property, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getCombiningClass(c: i32) -> u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getCombiningClass ( c : i32 ) -> u8 );
    u_getCombiningClass(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getDataVersion(dataversionfillin: *mut u8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getDataVersion ( dataversionfillin : *mut u8 , status : *mut UErrorCode ) -> ( ) );
    u_getDataVersion(dataversionfillin, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getFC_NFKC_Closure(c: i32, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getFC_NFKC_Closure ( c : i32 , dest : *mut u16 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    u_getFC_NFKC_Closure(c, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getIntPropertyMap(property: UProperty, perrorcode: *mut UErrorCode) -> *mut UCPMap {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getIntPropertyMap ( property : UProperty , perrorcode : *mut UErrorCode ) -> *mut UCPMap );
    u_getIntPropertyMap(property, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getIntPropertyMaxValue(which: UProperty) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getIntPropertyMaxValue ( which : UProperty ) -> i32 );
    u_getIntPropertyMaxValue(which)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getIntPropertyMinValue(which: UProperty) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getIntPropertyMinValue ( which : UProperty ) -> i32 );
    u_getIntPropertyMinValue(which)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getIntPropertyValue(c: i32, which: UProperty) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getIntPropertyValue ( c : i32 , which : UProperty ) -> i32 );
    u_getIntPropertyValue(c, which)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getNumericValue(c: i32) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getNumericValue ( c : i32 ) -> f64 );
    u_getNumericValue(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getPropertyEnum<P0>(alias: P0) -> UProperty
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getPropertyEnum ( alias : :: windows::core::PCSTR ) -> UProperty );
    u_getPropertyEnum(alias.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getPropertyName(property: UProperty, namechoice: UPropertyNameChoice) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getPropertyName ( property : UProperty , namechoice : UPropertyNameChoice ) -> :: windows::core::PSTR );
    u_getPropertyName(property, namechoice)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getPropertyValueEnum<P0>(property: UProperty, alias: P0) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getPropertyValueEnum ( property : UProperty , alias : :: windows::core::PCSTR ) -> i32 );
    u_getPropertyValueEnum(property, alias.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getPropertyValueName(property: UProperty, value: i32, namechoice: UPropertyNameChoice) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getPropertyValueName ( property : UProperty , value : i32 , namechoice : UPropertyNameChoice ) -> :: windows::core::PSTR );
    u_getPropertyValueName(property, value, namechoice)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getUnicodeVersion(versionarray: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getUnicodeVersion ( versionarray : *mut u8 ) -> ( ) );
    u_getUnicodeVersion(versionarray)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_getVersion(versionarray: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_getVersion ( versionarray : *mut u8 ) -> ( ) );
    u_getVersion(versionarray)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_hasBinaryProperty(c: i32, which: UProperty) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_hasBinaryProperty ( c : i32 , which : UProperty ) -> i8 );
    u_hasBinaryProperty(c, which)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_init(status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_init ( status : *mut UErrorCode ) -> ( ) );
    u_init(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isIDIgnorable(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isIDIgnorable ( c : i32 ) -> i8 );
    u_isIDIgnorable(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isIDPart(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isIDPart ( c : i32 ) -> i8 );
    u_isIDPart(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isIDStart(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isIDStart ( c : i32 ) -> i8 );
    u_isIDStart(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isISOControl(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isISOControl ( c : i32 ) -> i8 );
    u_isISOControl(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isJavaIDPart(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isJavaIDPart ( c : i32 ) -> i8 );
    u_isJavaIDPart(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isJavaIDStart(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isJavaIDStart ( c : i32 ) -> i8 );
    u_isJavaIDStart(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isJavaSpaceChar(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isJavaSpaceChar ( c : i32 ) -> i8 );
    u_isJavaSpaceChar(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isMirrored(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isMirrored ( c : i32 ) -> i8 );
    u_isMirrored(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isUAlphabetic(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isUAlphabetic ( c : i32 ) -> i8 );
    u_isUAlphabetic(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isULowercase(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isULowercase ( c : i32 ) -> i8 );
    u_isULowercase(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isUUppercase(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isUUppercase ( c : i32 ) -> i8 );
    u_isUUppercase(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isUWhiteSpace(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isUWhiteSpace ( c : i32 ) -> i8 );
    u_isUWhiteSpace(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isWhitespace(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isWhitespace ( c : i32 ) -> i8 );
    u_isWhitespace(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isalnum(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isalnum ( c : i32 ) -> i8 );
    u_isalnum(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isalpha(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isalpha ( c : i32 ) -> i8 );
    u_isalpha(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isbase(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isbase ( c : i32 ) -> i8 );
    u_isbase(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isblank(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isblank ( c : i32 ) -> i8 );
    u_isblank(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_iscntrl(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_iscntrl ( c : i32 ) -> i8 );
    u_iscntrl(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isdefined(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isdefined ( c : i32 ) -> i8 );
    u_isdefined(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isdigit(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isdigit ( c : i32 ) -> i8 );
    u_isdigit(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isgraph(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isgraph ( c : i32 ) -> i8 );
    u_isgraph(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_islower(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_islower ( c : i32 ) -> i8 );
    u_islower(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isprint(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isprint ( c : i32 ) -> i8 );
    u_isprint(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_ispunct(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_ispunct ( c : i32 ) -> i8 );
    u_ispunct(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isspace(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isspace ( c : i32 ) -> i8 );
    u_isspace(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_istitle(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_istitle ( c : i32 ) -> i8 );
    u_istitle(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isupper(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isupper ( c : i32 ) -> i8 );
    u_isupper(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_isxdigit(c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_isxdigit ( c : i32 ) -> i8 );
    u_isxdigit(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memcasecmp(s1: *const u16, s2: *const u16, length: i32, options: u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memcasecmp ( s1 : *const u16 , s2 : *const u16 , length : i32 , options : u32 ) -> i32 );
    u_memcasecmp(s1, s2, length, options)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memchr(s: *const u16, c: u16, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memchr ( s : *const u16 , c : u16 , count : i32 ) -> *mut u16 );
    u_memchr(s, c, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memchr32(s: *const u16, c: i32, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memchr32 ( s : *const u16 , c : i32 , count : i32 ) -> *mut u16 );
    u_memchr32(s, c, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memcmp(buf1: *const u16, buf2: *const u16, count: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memcmp ( buf1 : *const u16 , buf2 : *const u16 , count : i32 ) -> i32 );
    u_memcmp(buf1, buf2, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memcmpCodePointOrder(s1: *const u16, s2: *const u16, count: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memcmpCodePointOrder ( s1 : *const u16 , s2 : *const u16 , count : i32 ) -> i32 );
    u_memcmpCodePointOrder(s1, s2, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memcpy(dest: *mut u16, src: *const u16, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memcpy ( dest : *mut u16 , src : *const u16 , count : i32 ) -> *mut u16 );
    u_memcpy(dest, src, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memmove(dest: *mut u16, src: *const u16, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memmove ( dest : *mut u16 , src : *const u16 , count : i32 ) -> *mut u16 );
    u_memmove(dest, src, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memrchr(s: *const u16, c: u16, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memrchr ( s : *const u16 , c : u16 , count : i32 ) -> *mut u16 );
    u_memrchr(s, c, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memrchr32(s: *const u16, c: i32, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memrchr32 ( s : *const u16 , c : i32 , count : i32 ) -> *mut u16 );
    u_memrchr32(s, c, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_memset(dest: *mut u16, c: u16, count: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_memset ( dest : *mut u16 , c : u16 , count : i32 ) -> *mut u16 );
    u_memset(dest, c, count)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_parseMessage<P0>(locale: P0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_parseMessage ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , source : *const u16 , sourcelength : i32 , status : *mut UErrorCode ) -> ( ) );
    u_parseMessage(locale.into_param().abi(), pattern, patternlength, source, sourcelength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_parseMessageWithError<P0>(locale: P0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, parseerror: *mut UParseError, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_parseMessageWithError ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , source : *const u16 , sourcelength : i32 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> ( ) );
    u_parseMessageWithError(locale.into_param().abi(), pattern, patternlength, source, sourcelength, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_setMemoryFunctions(context: *const ::core::ffi::c_void, a: *mut UMemAllocFn, r: *mut UMemReallocFn, f: *mut UMemFreeFn, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_setMemoryFunctions ( context : *const ::core::ffi::c_void , a : *mut UMemAllocFn , r : *mut UMemReallocFn , f : *mut UMemFreeFn , status : *mut UErrorCode ) -> ( ) );
    u_setMemoryFunctions(context, a, r, f, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_shapeArabic(source: *const u16, sourcelength: i32, dest: *mut u16, destsize: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_shapeArabic ( source : *const u16 , sourcelength : i32 , dest : *mut u16 , destsize : i32 , options : u32 , perrorcode : *mut UErrorCode ) -> i32 );
    u_shapeArabic(source, sourcelength, dest, destsize, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strCaseCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strCaseCompare ( s1 : *const u16 , length1 : i32 , s2 : *const u16 , length2 : i32 , options : u32 , perrorcode : *mut UErrorCode ) -> i32 );
    u_strCaseCompare(s1, length1, s2, length2, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strCompare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, codepointorder: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strCompare ( s1 : *const u16 , length1 : i32 , s2 : *const u16 , length2 : i32 , codepointorder : i8 ) -> i32 );
    u_strCompare(s1, length1, s2, length2, codepointorder)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strCompareIter(iter1: *mut UCharIterator, iter2: *mut UCharIterator, codepointorder: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strCompareIter ( iter1 : *mut UCharIterator , iter2 : *mut UCharIterator , codepointorder : i8 ) -> i32 );
    u_strCompareIter(iter1, iter2, codepointorder)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFindFirst(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFindFirst ( s : *const u16 , length : i32 , substring : *const u16 , sublength : i32 ) -> *mut u16 );
    u_strFindFirst(s, length, substring, sublength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFindLast(s: *const u16, length: i32, substring: *const u16, sublength: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFindLast ( s : *const u16 , length : i32 , substring : *const u16 , sublength : i32 ) -> *mut u16 );
    u_strFindLast(s, length, substring, sublength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFoldCase(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFoldCase ( dest : *mut u16 , destcapacity : i32 , src : *const u16 , srclength : i32 , options : u32 , perrorcode : *mut UErrorCode ) -> i32 );
    u_strFoldCase(dest, destcapacity, src, srclength, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromJavaModifiedUTF8WithSub<P0>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: P0, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromJavaModifiedUTF8WithSub ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : :: windows::core::PCSTR , srclength : i32 , subchar : i32 , pnumsubstitutions : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromJavaModifiedUTF8WithSub(dest, destcapacity, pdestlength, src.into_param().abi(), srclength, subchar, pnumsubstitutions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromUTF32(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromUTF32 ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : *const i32 , srclength : i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromUTF32(dest, destcapacity, pdestlength, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromUTF32WithSub(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: *const i32, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromUTF32WithSub ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : *const i32 , srclength : i32 , subchar : i32 , pnumsubstitutions : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromUTF32WithSub(dest, destcapacity, pdestlength, src, srclength, subchar, pnumsubstitutions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromUTF8<P0>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: P0, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromUTF8 ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromUTF8(dest, destcapacity, pdestlength, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromUTF8Lenient<P0>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: P0, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromUTF8Lenient ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromUTF8Lenient(dest, destcapacity, pdestlength, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromUTF8WithSub<P0>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: P0, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromUTF8WithSub ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : :: windows::core::PCSTR , srclength : i32 , subchar : i32 , pnumsubstitutions : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromUTF8WithSub(dest, destcapacity, pdestlength, src.into_param().abi(), srclength, subchar, pnumsubstitutions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strFromWCS<P0>(dest: *mut u16, destcapacity: i32, pdestlength: *mut i32, src: P0, srclength: i32, perrorcode: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strFromWCS ( dest : *mut u16 , destcapacity : i32 , pdestlength : *mut i32 , src : :: windows::core::PCWSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> *mut u16 );
    u_strFromWCS(dest, destcapacity, pdestlength, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strHasMoreChar32Than(s: *const u16, length: i32, number: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strHasMoreChar32Than ( s : *const u16 , length : i32 , number : i32 ) -> i8 );
    u_strHasMoreChar32Than(s, length, number)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToJavaModifiedUTF8<P0>(dest: P0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToJavaModifiedUTF8 ( dest : :: windows::core::PCSTR , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    u_strToJavaModifiedUTF8(dest.into_param().abi(), destcapacity, pdestlength, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToLower<P0>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: P0, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToLower ( dest : *mut u16 , destcapacity : i32 , src : *const u16 , srclength : i32 , locale : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> i32 );
    u_strToLower(dest, destcapacity, src, srclength, locale.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToTitle<P0>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, titleiter: *mut UBreakIterator, locale: P0, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToTitle ( dest : *mut u16 , destcapacity : i32 , src : *const u16 , srclength : i32 , titleiter : *mut UBreakIterator , locale : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> i32 );
    u_strToTitle(dest, destcapacity, src, srclength, titleiter, locale.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToUTF32(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> *mut i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToUTF32 ( dest : *mut i32 , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> *mut i32 );
    u_strToUTF32(dest, destcapacity, pdestlength, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToUTF32WithSub(dest: *mut i32, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> *mut i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToUTF32WithSub ( dest : *mut i32 , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , subchar : i32 , pnumsubstitutions : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut i32 );
    u_strToUTF32WithSub(dest, destcapacity, pdestlength, src, srclength, subchar, pnumsubstitutions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToUTF8<P0>(dest: P0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToUTF8 ( dest : :: windows::core::PCSTR , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    u_strToUTF8(dest.into_param().abi(), destcapacity, pdestlength, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToUTF8WithSub<P0>(dest: P0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, subchar: i32, pnumsubstitutions: *mut i32, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToUTF8WithSub ( dest : :: windows::core::PCSTR , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , subchar : i32 , pnumsubstitutions : *mut i32 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    u_strToUTF8WithSub(dest.into_param().abi(), destcapacity, pdestlength, src, srclength, subchar, pnumsubstitutions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToUpper<P0>(dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, locale: P0, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToUpper ( dest : *mut u16 , destcapacity : i32 , src : *const u16 , srclength : i32 , locale : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> i32 );
    u_strToUpper(dest, destcapacity, src, srclength, locale.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strToWCS<P0>(dest: P0, destcapacity: i32, pdestlength: *mut i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strToWCS ( dest : :: windows::core::PCWSTR , destcapacity : i32 , pdestlength : *mut i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> :: windows::core::PWSTR );
    u_strToWCS(dest.into_param().abi(), destcapacity, pdestlength, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcasecmp(s1: *const u16, s2: *const u16, options: u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcasecmp ( s1 : *const u16 , s2 : *const u16 , options : u32 ) -> i32 );
    u_strcasecmp(s1, s2, options)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcat(dst: *mut u16, src: *const u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcat ( dst : *mut u16 , src : *const u16 ) -> *mut u16 );
    u_strcat(dst, src)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strchr(s: *const u16, c: u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strchr ( s : *const u16 , c : u16 ) -> *mut u16 );
    u_strchr(s, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strchr32(s: *const u16, c: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strchr32 ( s : *const u16 , c : i32 ) -> *mut u16 );
    u_strchr32(s, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcmp(s1: *const u16, s2: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcmp ( s1 : *const u16 , s2 : *const u16 ) -> i32 );
    u_strcmp(s1, s2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcmpCodePointOrder(s1: *const u16, s2: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcmpCodePointOrder ( s1 : *const u16 , s2 : *const u16 ) -> i32 );
    u_strcmpCodePointOrder(s1, s2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcpy(dst: *mut u16, src: *const u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcpy ( dst : *mut u16 , src : *const u16 ) -> *mut u16 );
    u_strcpy(dst, src)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strcspn(string: *const u16, matchset: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strcspn ( string : *const u16 , matchset : *const u16 ) -> i32 );
    u_strcspn(string, matchset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strlen(s: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strlen ( s : *const u16 ) -> i32 );
    u_strlen(s)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strncasecmp(s1: *const u16, s2: *const u16, n: i32, options: u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strncasecmp ( s1 : *const u16 , s2 : *const u16 , n : i32 , options : u32 ) -> i32 );
    u_strncasecmp(s1, s2, n, options)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strncat(dst: *mut u16, src: *const u16, n: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strncat ( dst : *mut u16 , src : *const u16 , n : i32 ) -> *mut u16 );
    u_strncat(dst, src, n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strncmp(ucs1: *const u16, ucs2: *const u16, n: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strncmp ( ucs1 : *const u16 , ucs2 : *const u16 , n : i32 ) -> i32 );
    u_strncmp(ucs1, ucs2, n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strncmpCodePointOrder(s1: *const u16, s2: *const u16, n: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strncmpCodePointOrder ( s1 : *const u16 , s2 : *const u16 , n : i32 ) -> i32 );
    u_strncmpCodePointOrder(s1, s2, n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strncpy(dst: *mut u16, src: *const u16, n: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strncpy ( dst : *mut u16 , src : *const u16 , n : i32 ) -> *mut u16 );
    u_strncpy(dst, src, n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strpbrk(string: *const u16, matchset: *const u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strpbrk ( string : *const u16 , matchset : *const u16 ) -> *mut u16 );
    u_strpbrk(string, matchset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strrchr(s: *const u16, c: u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strrchr ( s : *const u16 , c : u16 ) -> *mut u16 );
    u_strrchr(s, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strrchr32(s: *const u16, c: i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strrchr32 ( s : *const u16 , c : i32 ) -> *mut u16 );
    u_strrchr32(s, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strrstr(s: *const u16, substring: *const u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strrstr ( s : *const u16 , substring : *const u16 ) -> *mut u16 );
    u_strrstr(s, substring)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strspn(string: *const u16, matchset: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strspn ( string : *const u16 , matchset : *const u16 ) -> i32 );
    u_strspn(string, matchset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strstr(s: *const u16, substring: *const u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strstr ( s : *const u16 , substring : *const u16 ) -> *mut u16 );
    u_strstr(s, substring)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_strtok_r(src: *mut u16, delim: *const u16, savestate: *mut *mut u16) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_strtok_r ( src : *mut u16 , delim : *const u16 , savestate : *mut *mut u16 ) -> *mut u16 );
    u_strtok_r(src, delim, savestate)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_tolower(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_tolower ( c : i32 ) -> i32 );
    u_tolower(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_totitle(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_totitle ( c : i32 ) -> i32 );
    u_totitle(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_toupper(c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_toupper ( c : i32 ) -> i32 );
    u_toupper(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_uastrcpy<P0>(dst: *mut u16, src: P0) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_uastrcpy ( dst : *mut u16 , src : :: windows::core::PCSTR ) -> *mut u16 );
    u_uastrcpy(dst, src.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_uastrncpy<P0>(dst: *mut u16, src: P0, n: i32) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_uastrncpy ( dst : *mut u16 , src : :: windows::core::PCSTR , n : i32 ) -> *mut u16 );
    u_uastrncpy(dst, src.into_param().abi(), n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_unescape<P0>(src: P0, dest: *mut u16, destcapacity: i32) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_unescape ( src : :: windows::core::PCSTR , dest : *mut u16 , destcapacity : i32 ) -> i32 );
    u_unescape(src.into_param().abi(), dest, destcapacity)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_unescapeAt(charat: UNESCAPE_CHAR_AT, offset: *mut i32, length: i32, context: *mut ::core::ffi::c_void) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_unescapeAt ( charat : UNESCAPE_CHAR_AT , offset : *mut i32 , length : i32 , context : *mut ::core::ffi::c_void ) -> i32 );
    u_unescapeAt(charat, offset, length, context)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_versionFromString<P0>(versionarray: *mut u8, versionstring: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_versionFromString ( versionarray : *mut u8 , versionstring : :: windows::core::PCSTR ) -> ( ) );
    u_versionFromString(versionarray, versionstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_versionFromUString(versionarray: *mut u8, versionstring: *const u16) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_versionFromUString ( versionarray : *mut u8 , versionstring : *const u16 ) -> ( ) );
    u_versionFromUString(versionarray, versionstring)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_versionToString<P0>(versionarray: *const u8, versionstring: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_versionToString ( versionarray : *const u8 , versionstring : :: windows::core::PCSTR ) -> ( ) );
    u_versionToString(versionarray, versionstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_vformatMessage<P0>(locale: P0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, ap: *mut i8, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_vformatMessage ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , result : *mut u16 , resultlength : i32 , ap : *mut i8 , status : *mut UErrorCode ) -> i32 );
    u_vformatMessage(locale.into_param().abi(), pattern, patternlength, result, resultlength, ap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_vformatMessageWithError<P0>(locale: P0, pattern: *const u16, patternlength: i32, result: *mut u16, resultlength: i32, parseerror: *mut UParseError, ap: *mut i8, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_vformatMessageWithError ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , result : *mut u16 , resultlength : i32 , parseerror : *mut UParseError , ap : *mut i8 , status : *mut UErrorCode ) -> i32 );
    u_vformatMessageWithError(locale.into_param().abi(), pattern, patternlength, result, resultlength, parseerror, ap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_vparseMessage<P0>(locale: P0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_vparseMessage ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , source : *const u16 , sourcelength : i32 , ap : *mut i8 , status : *mut UErrorCode ) -> ( ) );
    u_vparseMessage(locale.into_param().abi(), pattern, patternlength, source, sourcelength, ap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn u_vparseMessageWithError<P0>(locale: P0, pattern: *const u16, patternlength: i32, source: *const u16, sourcelength: i32, ap: *mut i8, parseerror: *mut UParseError, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn u_vparseMessageWithError ( locale : :: windows::core::PCSTR , pattern : *const u16 , patternlength : i32 , source : *const u16 , sourcelength : i32 , ap : *mut i8 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> ( ) );
    u_vparseMessageWithError(locale.into_param().abi(), pattern, patternlength, source, sourcelength, ap, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_close(pbidi: *mut UBiDi) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_close ( pbidi : *mut UBiDi ) -> ( ) );
    ubidi_close(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_countParagraphs(pbidi: *mut UBiDi) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_countParagraphs ( pbidi : *mut UBiDi ) -> i32 );
    ubidi_countParagraphs(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_countRuns(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_countRuns ( pbidi : *mut UBiDi , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_countRuns(pbidi, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getBaseDirection(text: *const u16, length: i32) -> UBiDiDirection {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getBaseDirection ( text : *const u16 , length : i32 ) -> UBiDiDirection );
    ubidi_getBaseDirection(text, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getClassCallback(pbidi: *mut UBiDi, r#fn: *mut UBiDiClassCallback, context: *const *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getClassCallback ( pbidi : *mut UBiDi , r#fn : *mut UBiDiClassCallback , context : *const *const ::core::ffi::c_void ) -> ( ) );
    ubidi_getClassCallback(pbidi, r#fn, context)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getCustomizedClass(pbidi: *mut UBiDi, c: i32) -> UCharDirection {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getCustomizedClass ( pbidi : *mut UBiDi , c : i32 ) -> UCharDirection );
    ubidi_getCustomizedClass(pbidi, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getDirection(pbidi: *const UBiDi) -> UBiDiDirection {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getDirection ( pbidi : *const UBiDi ) -> UBiDiDirection );
    ubidi_getDirection(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLength(pbidi: *const UBiDi) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLength ( pbidi : *const UBiDi ) -> i32 );
    ubidi_getLength(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLevelAt(pbidi: *const UBiDi, charindex: i32) -> u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLevelAt ( pbidi : *const UBiDi , charindex : i32 ) -> u8 );
    ubidi_getLevelAt(pbidi, charindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLevels(pbidi: *mut UBiDi, perrorcode: *mut UErrorCode) -> *mut u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLevels ( pbidi : *mut UBiDi , perrorcode : *mut UErrorCode ) -> *mut u8 );
    ubidi_getLevels(pbidi, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLogicalIndex(pbidi: *mut UBiDi, visualindex: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLogicalIndex ( pbidi : *mut UBiDi , visualindex : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_getLogicalIndex(pbidi, visualindex, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLogicalMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLogicalMap ( pbidi : *mut UBiDi , indexmap : *mut i32 , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_getLogicalMap(pbidi, indexmap, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getLogicalRun(pbidi: *const UBiDi, logicalposition: i32, plogicallimit: *mut i32, plevel: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getLogicalRun ( pbidi : *const UBiDi , logicalposition : i32 , plogicallimit : *mut i32 , plevel : *mut u8 ) -> ( ) );
    ubidi_getLogicalRun(pbidi, logicalposition, plogicallimit, plevel)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getParaLevel(pbidi: *const UBiDi) -> u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getParaLevel ( pbidi : *const UBiDi ) -> u8 );
    ubidi_getParaLevel(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getParagraph(pbidi: *const UBiDi, charindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getParagraph ( pbidi : *const UBiDi , charindex : i32 , pparastart : *mut i32 , pparalimit : *mut i32 , pparalevel : *mut u8 , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_getParagraph(pbidi, charindex, pparastart, pparalimit, pparalevel, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getParagraphByIndex(pbidi: *const UBiDi, paraindex: i32, pparastart: *mut i32, pparalimit: *mut i32, pparalevel: *mut u8, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getParagraphByIndex ( pbidi : *const UBiDi , paraindex : i32 , pparastart : *mut i32 , pparalimit : *mut i32 , pparalevel : *mut u8 , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_getParagraphByIndex(pbidi, paraindex, pparastart, pparalimit, pparalevel, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getProcessedLength(pbidi: *const UBiDi) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getProcessedLength ( pbidi : *const UBiDi ) -> i32 );
    ubidi_getProcessedLength(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getReorderingMode(pbidi: *mut UBiDi) -> UBiDiReorderingMode {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getReorderingMode ( pbidi : *mut UBiDi ) -> UBiDiReorderingMode );
    ubidi_getReorderingMode(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getReorderingOptions(pbidi: *mut UBiDi) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getReorderingOptions ( pbidi : *mut UBiDi ) -> u32 );
    ubidi_getReorderingOptions(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getResultLength(pbidi: *const UBiDi) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getResultLength ( pbidi : *const UBiDi ) -> i32 );
    ubidi_getResultLength(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getText(pbidi: *const UBiDi) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getText ( pbidi : *const UBiDi ) -> *mut u16 );
    ubidi_getText(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getVisualIndex(pbidi: *mut UBiDi, logicalindex: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getVisualIndex ( pbidi : *mut UBiDi , logicalindex : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_getVisualIndex(pbidi, logicalindex, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getVisualMap(pbidi: *mut UBiDi, indexmap: *mut i32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getVisualMap ( pbidi : *mut UBiDi , indexmap : *mut i32 , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_getVisualMap(pbidi, indexmap, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_getVisualRun(pbidi: *mut UBiDi, runindex: i32, plogicalstart: *mut i32, plength: *mut i32) -> UBiDiDirection {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_getVisualRun ( pbidi : *mut UBiDi , runindex : i32 , plogicalstart : *mut i32 , plength : *mut i32 ) -> UBiDiDirection );
    ubidi_getVisualRun(pbidi, runindex, plogicalstart, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_invertMap(srcmap: *const i32, destmap: *mut i32, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_invertMap ( srcmap : *const i32 , destmap : *mut i32 , length : i32 ) -> ( ) );
    ubidi_invertMap(srcmap, destmap, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_isInverse(pbidi: *mut UBiDi) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_isInverse ( pbidi : *mut UBiDi ) -> i8 );
    ubidi_isInverse(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_isOrderParagraphsLTR(pbidi: *mut UBiDi) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_isOrderParagraphsLTR ( pbidi : *mut UBiDi ) -> i8 );
    ubidi_isOrderParagraphsLTR(pbidi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_open() -> *mut UBiDi {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_open ( ) -> *mut UBiDi );
    ubidi_open()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_openSized(maxlength: i32, maxruncount: i32, perrorcode: *mut UErrorCode) -> *mut UBiDi {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_openSized ( maxlength : i32 , maxruncount : i32 , perrorcode : *mut UErrorCode ) -> *mut UBiDi );
    ubidi_openSized(maxlength, maxruncount, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_orderParagraphsLTR(pbidi: *mut UBiDi, orderparagraphsltr: i8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_orderParagraphsLTR ( pbidi : *mut UBiDi , orderparagraphsltr : i8 ) -> ( ) );
    ubidi_orderParagraphsLTR(pbidi, orderparagraphsltr)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_reorderLogical(levels: *const u8, length: i32, indexmap: *mut i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_reorderLogical ( levels : *const u8 , length : i32 , indexmap : *mut i32 ) -> ( ) );
    ubidi_reorderLogical(levels, length, indexmap)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_reorderVisual(levels: *const u8, length: i32, indexmap: *mut i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_reorderVisual ( levels : *const u8 , length : i32 , indexmap : *mut i32 ) -> ( ) );
    ubidi_reorderVisual(levels, length, indexmap)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setClassCallback(pbidi: *mut UBiDi, newfn: UBiDiClassCallback, newcontext: *const ::core::ffi::c_void, oldfn: *mut UBiDiClassCallback, oldcontext: *const *const ::core::ffi::c_void, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setClassCallback ( pbidi : *mut UBiDi , newfn : UBiDiClassCallback , newcontext : *const ::core::ffi::c_void , oldfn : *mut UBiDiClassCallback , oldcontext : *const *const ::core::ffi::c_void , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_setClassCallback(pbidi, newfn, newcontext, oldfn, oldcontext, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setContext(pbidi: *mut UBiDi, prologue: *const u16, prolength: i32, epilogue: *const u16, epilength: i32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setContext ( pbidi : *mut UBiDi , prologue : *const u16 , prolength : i32 , epilogue : *const u16 , epilength : i32 , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_setContext(pbidi, prologue, prolength, epilogue, epilength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setInverse(pbidi: *mut UBiDi, isinverse: i8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setInverse ( pbidi : *mut UBiDi , isinverse : i8 ) -> ( ) );
    ubidi_setInverse(pbidi, isinverse)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setLine(pparabidi: *const UBiDi, start: i32, limit: i32, plinebidi: *mut UBiDi, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setLine ( pparabidi : *const UBiDi , start : i32 , limit : i32 , plinebidi : *mut UBiDi , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_setLine(pparabidi, start, limit, plinebidi, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setPara(pbidi: *mut UBiDi, text: *const u16, length: i32, paralevel: u8, embeddinglevels: *mut u8, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setPara ( pbidi : *mut UBiDi , text : *const u16 , length : i32 , paralevel : u8 , embeddinglevels : *mut u8 , perrorcode : *mut UErrorCode ) -> ( ) );
    ubidi_setPara(pbidi, text, length, paralevel, embeddinglevels, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setReorderingMode(pbidi: *mut UBiDi, reorderingmode: UBiDiReorderingMode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setReorderingMode ( pbidi : *mut UBiDi , reorderingmode : UBiDiReorderingMode ) -> ( ) );
    ubidi_setReorderingMode(pbidi, reorderingmode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_setReorderingOptions(pbidi: *mut UBiDi, reorderingoptions: u32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_setReorderingOptions ( pbidi : *mut UBiDi , reorderingoptions : u32 ) -> ( ) );
    ubidi_setReorderingOptions(pbidi, reorderingoptions)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_writeReordered(pbidi: *mut UBiDi, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_writeReordered ( pbidi : *mut UBiDi , dest : *mut u16 , destsize : i32 , options : u16 , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_writeReordered(pbidi, dest, destsize, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubidi_writeReverse(src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, options: u16, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubidi_writeReverse ( src : *const u16 , srclength : i32 , dest : *mut u16 , destsize : i32 , options : u16 , perrorcode : *mut UErrorCode ) -> i32 );
    ubidi_writeReverse(src, srclength, dest, destsize, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubiditransform_close(pbiditransform: *mut UBiDiTransform) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubiditransform_close ( pbiditransform : *mut UBiDiTransform ) -> ( ) );
    ubiditransform_close(pbiditransform)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubiditransform_open(perrorcode: *mut UErrorCode) -> *mut UBiDiTransform {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubiditransform_open ( perrorcode : *mut UErrorCode ) -> *mut UBiDiTransform );
    ubiditransform_open(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubiditransform_transform(pbiditransform: *mut UBiDiTransform, src: *const u16, srclength: i32, dest: *mut u16, destsize: i32, inparalevel: u8, inorder: UBiDiOrder, outparalevel: u8, outorder: UBiDiOrder, domirroring: UBiDiMirroring, shapingoptions: u32, perrorcode: *mut UErrorCode) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubiditransform_transform ( pbiditransform : *mut UBiDiTransform , src : *const u16 , srclength : i32 , dest : *mut u16 , destsize : i32 , inparalevel : u8 , inorder : UBiDiOrder , outparalevel : u8 , outorder : UBiDiOrder , domirroring : UBiDiMirroring , shapingoptions : u32 , perrorcode : *mut UErrorCode ) -> u32 );
    ubiditransform_transform(pbiditransform, src, srclength, dest, destsize, inparalevel, inorder, outparalevel, outorder, domirroring, shapingoptions, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ublock_getCode(c: i32) -> UBlockCode {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ublock_getCode ( c : i32 ) -> UBlockCode );
    ublock_getCode(c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_close(bi: *mut UBreakIterator) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_close ( bi : *mut UBreakIterator ) -> ( ) );
    ubrk_close(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_countAvailable ( ) -> i32 );
    ubrk_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_current(bi: *const UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_current ( bi : *const UBreakIterator ) -> i32 );
    ubrk_current(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_first(bi: *mut UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_first ( bi : *mut UBreakIterator ) -> i32 );
    ubrk_first(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_following(bi: *mut UBreakIterator, offset: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_following ( bi : *mut UBreakIterator , offset : i32 ) -> i32 );
    ubrk_following(bi, offset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_getAvailable(index: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_getAvailable ( index : i32 ) -> :: windows::core::PSTR );
    ubrk_getAvailable(index)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_getBinaryRules(bi: *mut UBreakIterator, binaryrules: *mut u8, rulescapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_getBinaryRules ( bi : *mut UBreakIterator , binaryrules : *mut u8 , rulescapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ubrk_getBinaryRules(bi, binaryrules, rulescapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_getLocaleByType(bi: *const UBreakIterator, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_getLocaleByType ( bi : *const UBreakIterator , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ubrk_getLocaleByType(bi, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_getRuleStatus(bi: *mut UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_getRuleStatus ( bi : *mut UBreakIterator ) -> i32 );
    ubrk_getRuleStatus(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_getRuleStatusVec(bi: *mut UBreakIterator, fillinvec: *mut i32, capacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_getRuleStatusVec ( bi : *mut UBreakIterator , fillinvec : *mut i32 , capacity : i32 , status : *mut UErrorCode ) -> i32 );
    ubrk_getRuleStatusVec(bi, fillinvec, capacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_isBoundary(bi: *mut UBreakIterator, offset: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_isBoundary ( bi : *mut UBreakIterator , offset : i32 ) -> i8 );
    ubrk_isBoundary(bi, offset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_last(bi: *mut UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_last ( bi : *mut UBreakIterator ) -> i32 );
    ubrk_last(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_next(bi: *mut UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_next ( bi : *mut UBreakIterator ) -> i32 );
    ubrk_next(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_open<P0>(r#type: UBreakIteratorType, locale: P0, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_open ( r#type : UBreakIteratorType , locale : :: windows::core::PCSTR , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> *mut UBreakIterator );
    ubrk_open(r#type, locale.into_param().abi(), text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_openBinaryRules(binaryrules: *const u8, ruleslength: i32, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UBreakIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_openBinaryRules ( binaryrules : *const u8 , ruleslength : i32 , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> *mut UBreakIterator );
    ubrk_openBinaryRules(binaryrules, ruleslength, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_openRules(rules: *const u16, ruleslength: i32, text: *const u16, textlength: i32, parseerr: *mut UParseError, status: *mut UErrorCode) -> *mut UBreakIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_openRules ( rules : *const u16 , ruleslength : i32 , text : *const u16 , textlength : i32 , parseerr : *mut UParseError , status : *mut UErrorCode ) -> *mut UBreakIterator );
    ubrk_openRules(rules, ruleslength, text, textlength, parseerr, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_preceding(bi: *mut UBreakIterator, offset: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_preceding ( bi : *mut UBreakIterator , offset : i32 ) -> i32 );
    ubrk_preceding(bi, offset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_previous(bi: *mut UBreakIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_previous ( bi : *mut UBreakIterator ) -> i32 );
    ubrk_previous(bi)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_refreshUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_refreshUText ( bi : *mut UBreakIterator , text : *mut UText , status : *mut UErrorCode ) -> ( ) );
    ubrk_refreshUText(bi, text, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_safeClone(bi: *const UBreakIterator, stackbuffer: *mut ::core::ffi::c_void, pbuffersize: *mut i32, status: *mut UErrorCode) -> *mut UBreakIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_safeClone ( bi : *const UBreakIterator , stackbuffer : *mut ::core::ffi::c_void , pbuffersize : *mut i32 , status : *mut UErrorCode ) -> *mut UBreakIterator );
    ubrk_safeClone(bi, stackbuffer, pbuffersize, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_setText(bi: *mut UBreakIterator, text: *const u16, textlength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_setText ( bi : *mut UBreakIterator , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> ( ) );
    ubrk_setText(bi, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ubrk_setUText(bi: *mut UBreakIterator, text: *mut UText, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ubrk_setUText ( bi : *mut UBreakIterator , text : *mut UText , status : *mut UErrorCode ) -> ( ) );
    ubrk_setUText(bi, text, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_add(cal: *mut *mut ::core::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_add ( cal : *mut *mut ::core::ffi::c_void , field : UCalendarDateFields , amount : i32 , status : *mut UErrorCode ) -> ( ) );
    ucal_add(cal, field, amount, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_clear(calendar: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_clear ( calendar : *mut *mut ::core::ffi::c_void ) -> ( ) );
    ucal_clear(calendar)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_clearField(cal: *mut *mut ::core::ffi::c_void, field: UCalendarDateFields) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_clearField ( cal : *mut *mut ::core::ffi::c_void , field : UCalendarDateFields ) -> ( ) );
    ucal_clearField(cal, field)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_clone(cal: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_clone ( cal : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    ucal_clone(cal, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_close(cal: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_close ( cal : *mut *mut ::core::ffi::c_void ) -> ( ) );
    ucal_close(cal)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_countAvailable ( ) -> i32 );
    ucal_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_equivalentTo(cal1: *const *const ::core::ffi::c_void, cal2: *const *const ::core::ffi::c_void) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_equivalentTo ( cal1 : *const *const ::core::ffi::c_void , cal2 : *const *const ::core::ffi::c_void ) -> i8 );
    ucal_equivalentTo(cal1, cal2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_get(cal: *const *const ::core::ffi::c_void, field: UCalendarDateFields, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_get ( cal : *const *const ::core::ffi::c_void , field : UCalendarDateFields , status : *mut UErrorCode ) -> i32 );
    ucal_get(cal, field, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getAttribute(cal: *const *const ::core::ffi::c_void, attr: UCalendarAttribute) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getAttribute ( cal : *const *const ::core::ffi::c_void , attr : UCalendarAttribute ) -> i32 );
    ucal_getAttribute(cal, attr)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getAvailable(localeindex: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getAvailable ( localeindex : i32 ) -> :: windows::core::PSTR );
    ucal_getAvailable(localeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getCanonicalTimeZoneID(id: *const u16, len: i32, result: *mut u16, resultcapacity: i32, issystemid: *mut i8, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getCanonicalTimeZoneID ( id : *const u16 , len : i32 , result : *mut u16 , resultcapacity : i32 , issystemid : *mut i8 , status : *mut UErrorCode ) -> i32 );
    ucal_getCanonicalTimeZoneID(id, len, result, resultcapacity, issystemid, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getDSTSavings(zoneid: *const u16, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getDSTSavings ( zoneid : *const u16 , ec : *mut UErrorCode ) -> i32 );
    ucal_getDSTSavings(zoneid, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getDayOfWeekType(cal: *const *const ::core::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> UCalendarWeekdayType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getDayOfWeekType ( cal : *const *const ::core::ffi::c_void , dayofweek : UCalendarDaysOfWeek , status : *mut UErrorCode ) -> UCalendarWeekdayType );
    ucal_getDayOfWeekType(cal, dayofweek, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getDefaultTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getDefaultTimeZone ( result : *mut u16 , resultcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    ucal_getDefaultTimeZone(result, resultcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getFieldDifference(cal: *mut *mut ::core::ffi::c_void, target: f64, field: UCalendarDateFields, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getFieldDifference ( cal : *mut *mut ::core::ffi::c_void , target : f64 , field : UCalendarDateFields , status : *mut UErrorCode ) -> i32 );
    ucal_getFieldDifference(cal, target, field, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getGregorianChange(cal: *const *const ::core::ffi::c_void, perrorcode: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getGregorianChange ( cal : *const *const ::core::ffi::c_void , perrorcode : *mut UErrorCode ) -> f64 );
    ucal_getGregorianChange(cal, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getHostTimeZone(result: *mut u16, resultcapacity: i32, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getHostTimeZone ( result : *mut u16 , resultcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    ucal_getHostTimeZone(result, resultcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getKeywordValuesForLocale<P0, P1>(key: P0, locale: P1, commonlyused: i8, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getKeywordValuesForLocale ( key : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , commonlyused : i8 , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucal_getKeywordValuesForLocale(key.into_param().abi(), locale.into_param().abi(), commonlyused, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getLimit(cal: *const *const ::core::ffi::c_void, field: UCalendarDateFields, r#type: UCalendarLimitType, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getLimit ( cal : *const *const ::core::ffi::c_void , field : UCalendarDateFields , r#type : UCalendarLimitType , status : *mut UErrorCode ) -> i32 );
    ucal_getLimit(cal, field, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getLocaleByType(cal: *const *const ::core::ffi::c_void, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getLocaleByType ( cal : *const *const ::core::ffi::c_void , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucal_getLocaleByType(cal, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getMillis(cal: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getMillis ( cal : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> f64 );
    ucal_getMillis(cal, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getNow() -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getNow ( ) -> f64 );
    ucal_getNow()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getTZDataVersion(status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getTZDataVersion ( status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucal_getTZDataVersion(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneDisplayName<P0>(cal: *const *const ::core::ffi::c_void, r#type: UCalendarDisplayNameType, locale: P0, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getTimeZoneDisplayName ( cal : *const *const ::core::ffi::c_void , r#type : UCalendarDisplayNameType , locale : :: windows::core::PCSTR , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    ucal_getTimeZoneDisplayName(cal, r#type, locale.into_param().abi(), result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneID(cal: *const *const ::core::ffi::c_void, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getTimeZoneID ( cal : *const *const ::core::ffi::c_void , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    ucal_getTimeZoneID(cal, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneIDForWindowsID<P0>(winid: *const u16, len: i32, region: P0, id: *mut u16, idcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getTimeZoneIDForWindowsID ( winid : *const u16 , len : i32 , region : :: windows::core::PCSTR , id : *mut u16 , idcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ucal_getTimeZoneIDForWindowsID(winid, len, region.into_param().abi(), id, idcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getTimeZoneTransitionDate(cal: *const *const ::core::ffi::c_void, r#type: UTimeZoneTransitionType, transition: *mut f64, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getTimeZoneTransitionDate ( cal : *const *const ::core::ffi::c_void , r#type : UTimeZoneTransitionType , transition : *mut f64 , status : *mut UErrorCode ) -> i8 );
    ucal_getTimeZoneTransitionDate(cal, r#type, transition, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getType(cal: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getType ( cal : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucal_getType(cal, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getWeekendTransition(cal: *const *const ::core::ffi::c_void, dayofweek: UCalendarDaysOfWeek, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getWeekendTransition ( cal : *const *const ::core::ffi::c_void , dayofweek : UCalendarDaysOfWeek , status : *mut UErrorCode ) -> i32 );
    ucal_getWeekendTransition(cal, dayofweek, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_getWindowsTimeZoneID(id: *const u16, len: i32, winid: *mut u16, winidcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_getWindowsTimeZoneID ( id : *const u16 , len : i32 , winid : *mut u16 , winidcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ucal_getWindowsTimeZoneID(id, len, winid, winidcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_inDaylightTime(cal: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_inDaylightTime ( cal : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> i8 );
    ucal_inDaylightTime(cal, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_isSet(cal: *const *const ::core::ffi::c_void, field: UCalendarDateFields) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_isSet ( cal : *const *const ::core::ffi::c_void , field : UCalendarDateFields ) -> i8 );
    ucal_isSet(cal, field)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_isWeekend(cal: *const *const ::core::ffi::c_void, date: f64, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_isWeekend ( cal : *const *const ::core::ffi::c_void , date : f64 , status : *mut UErrorCode ) -> i8 );
    ucal_isWeekend(cal, date, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_open<P0>(zoneid: *const u16, len: i32, locale: P0, r#type: UCalendarType, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_open ( zoneid : *const u16 , len : i32 , locale : :: windows::core::PCSTR , r#type : UCalendarType , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    ucal_open(zoneid, len, locale.into_param().abi(), r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_openCountryTimeZones<P0>(country: P0, ec: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_openCountryTimeZones ( country : :: windows::core::PCSTR , ec : *mut UErrorCode ) -> *mut UEnumeration );
    ucal_openCountryTimeZones(country.into_param().abi(), ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_openTimeZoneIDEnumeration<P0>(zonetype: USystemTimeZoneType, region: P0, rawoffset: *const i32, ec: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_openTimeZoneIDEnumeration ( zonetype : USystemTimeZoneType , region : :: windows::core::PCSTR , rawoffset : *const i32 , ec : *mut UErrorCode ) -> *mut UEnumeration );
    ucal_openTimeZoneIDEnumeration(zonetype, region.into_param().abi(), rawoffset, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_openTimeZones(ec: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_openTimeZones ( ec : *mut UErrorCode ) -> *mut UEnumeration );
    ucal_openTimeZones(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_roll(cal: *mut *mut ::core::ffi::c_void, field: UCalendarDateFields, amount: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_roll ( cal : *mut *mut ::core::ffi::c_void , field : UCalendarDateFields , amount : i32 , status : *mut UErrorCode ) -> ( ) );
    ucal_roll(cal, field, amount, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_set(cal: *mut *mut ::core::ffi::c_void, field: UCalendarDateFields, value: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_set ( cal : *mut *mut ::core::ffi::c_void , field : UCalendarDateFields , value : i32 ) -> ( ) );
    ucal_set(cal, field, value)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setAttribute(cal: *mut *mut ::core::ffi::c_void, attr: UCalendarAttribute, newvalue: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setAttribute ( cal : *mut *mut ::core::ffi::c_void , attr : UCalendarAttribute , newvalue : i32 ) -> ( ) );
    ucal_setAttribute(cal, attr, newvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setDate(cal: *mut *mut ::core::ffi::c_void, year: i32, month: i32, date: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setDate ( cal : *mut *mut ::core::ffi::c_void , year : i32 , month : i32 , date : i32 , status : *mut UErrorCode ) -> ( ) );
    ucal_setDate(cal, year, month, date, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setDateTime(cal: *mut *mut ::core::ffi::c_void, year: i32, month: i32, date: i32, hour: i32, minute: i32, second: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setDateTime ( cal : *mut *mut ::core::ffi::c_void , year : i32 , month : i32 , date : i32 , hour : i32 , minute : i32 , second : i32 , status : *mut UErrorCode ) -> ( ) );
    ucal_setDateTime(cal, year, month, date, hour, minute, second, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setDefaultTimeZone(zoneid: *const u16, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setDefaultTimeZone ( zoneid : *const u16 , ec : *mut UErrorCode ) -> ( ) );
    ucal_setDefaultTimeZone(zoneid, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setGregorianChange(cal: *mut *mut ::core::ffi::c_void, date: f64, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setGregorianChange ( cal : *mut *mut ::core::ffi::c_void , date : f64 , perrorcode : *mut UErrorCode ) -> ( ) );
    ucal_setGregorianChange(cal, date, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setMillis(cal: *mut *mut ::core::ffi::c_void, datetime: f64, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setMillis ( cal : *mut *mut ::core::ffi::c_void , datetime : f64 , status : *mut UErrorCode ) -> ( ) );
    ucal_setMillis(cal, datetime, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucal_setTimeZone(cal: *mut *mut ::core::ffi::c_void, zoneid: *const u16, len: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucal_setTimeZone ( cal : *mut *mut ::core::ffi::c_void , zoneid : *const u16 , len : i32 , status : *mut UErrorCode ) -> ( ) );
    ucal_setTimeZone(cal, zoneid, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_close(csm: *mut UCaseMap) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_close ( csm : *mut UCaseMap ) -> ( ) );
    ucasemap_close(csm)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_getBreakIterator(csm: *const UCaseMap) -> *mut UBreakIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_getBreakIterator ( csm : *const UCaseMap ) -> *mut UBreakIterator );
    ucasemap_getBreakIterator(csm)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_getLocale(csm: *const UCaseMap) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_getLocale ( csm : *const UCaseMap ) -> :: windows::core::PSTR );
    ucasemap_getLocale(csm)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_getOptions(csm: *const UCaseMap) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_getOptions ( csm : *const UCaseMap ) -> u32 );
    ucasemap_getOptions(csm)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_open<P0>(locale: P0, options: u32, perrorcode: *mut UErrorCode) -> *mut UCaseMap
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_open ( locale : :: windows::core::PCSTR , options : u32 , perrorcode : *mut UErrorCode ) -> *mut UCaseMap );
    ucasemap_open(locale.into_param().abi(), options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_setBreakIterator(csm: *mut UCaseMap, itertoadopt: *mut UBreakIterator, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_setBreakIterator ( csm : *mut UCaseMap , itertoadopt : *mut UBreakIterator , perrorcode : *mut UErrorCode ) -> ( ) );
    ucasemap_setBreakIterator(csm, itertoadopt, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_setLocale<P0>(csm: *mut UCaseMap, locale: P0, perrorcode: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_setLocale ( csm : *mut UCaseMap , locale : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> ( ) );
    ucasemap_setLocale(csm, locale.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_setOptions(csm: *mut UCaseMap, options: u32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_setOptions ( csm : *mut UCaseMap , options : u32 , perrorcode : *mut UErrorCode ) -> ( ) );
    ucasemap_setOptions(csm, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_toTitle(csm: *mut UCaseMap, dest: *mut u16, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_toTitle ( csm : *mut UCaseMap , dest : *mut u16 , destcapacity : i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucasemap_toTitle(csm, dest, destcapacity, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_utf8FoldCase<P0, P1>(csm: *const UCaseMap, dest: P0, destcapacity: i32, src: P1, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_utf8FoldCase ( csm : *const UCaseMap , dest : :: windows::core::PCSTR , destcapacity : i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucasemap_utf8FoldCase(csm, dest.into_param().abi(), destcapacity, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_utf8ToLower<P0, P1>(csm: *const UCaseMap, dest: P0, destcapacity: i32, src: P1, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_utf8ToLower ( csm : *const UCaseMap , dest : :: windows::core::PCSTR , destcapacity : i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucasemap_utf8ToLower(csm, dest.into_param().abi(), destcapacity, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_utf8ToTitle<P0, P1>(csm: *mut UCaseMap, dest: P0, destcapacity: i32, src: P1, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_utf8ToTitle ( csm : *mut UCaseMap , dest : :: windows::core::PCSTR , destcapacity : i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucasemap_utf8ToTitle(csm, dest.into_param().abi(), destcapacity, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucasemap_utf8ToUpper<P0, P1>(csm: *const UCaseMap, dest: P0, destcapacity: i32, src: P1, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucasemap_utf8ToUpper ( csm : *const UCaseMap , dest : :: windows::core::PCSTR , destcapacity : i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucasemap_utf8ToUpper(csm, dest.into_param().abi(), destcapacity, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_close(ucfpos: *mut UConstrainedFieldPosition) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_close ( ucfpos : *mut UConstrainedFieldPosition ) -> ( ) );
    ucfpos_close(ucfpos)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_constrainCategory(ucfpos: *mut UConstrainedFieldPosition, category: i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_constrainCategory ( ucfpos : *mut UConstrainedFieldPosition , category : i32 , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_constrainCategory(ucfpos, category, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_constrainField(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_constrainField ( ucfpos : *mut UConstrainedFieldPosition , category : i32 , field : i32 , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_constrainField(ucfpos, category, field, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_getCategory(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_getCategory ( ucfpos : *const UConstrainedFieldPosition , ec : *mut UErrorCode ) -> i32 );
    ucfpos_getCategory(ucfpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_getField(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_getField ( ucfpos : *const UConstrainedFieldPosition , ec : *mut UErrorCode ) -> i32 );
    ucfpos_getField(ucfpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_getIndexes(ucfpos: *const UConstrainedFieldPosition, pstart: *mut i32, plimit: *mut i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_getIndexes ( ucfpos : *const UConstrainedFieldPosition , pstart : *mut i32 , plimit : *mut i32 , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_getIndexes(ucfpos, pstart, plimit, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_getInt64IterationContext(ucfpos: *const UConstrainedFieldPosition, ec: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_getInt64IterationContext ( ucfpos : *const UConstrainedFieldPosition , ec : *mut UErrorCode ) -> i64 );
    ucfpos_getInt64IterationContext(ucfpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_matchesField(ucfpos: *const UConstrainedFieldPosition, category: i32, field: i32, ec: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_matchesField ( ucfpos : *const UConstrainedFieldPosition , category : i32 , field : i32 , ec : *mut UErrorCode ) -> i8 );
    ucfpos_matchesField(ucfpos, category, field, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_open(ec: *mut UErrorCode) -> *mut UConstrainedFieldPosition {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_open ( ec : *mut UErrorCode ) -> *mut UConstrainedFieldPosition );
    ucfpos_open(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_reset(ucfpos: *mut UConstrainedFieldPosition, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_reset ( ucfpos : *mut UConstrainedFieldPosition , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_reset(ucfpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_setInt64IterationContext(ucfpos: *mut UConstrainedFieldPosition, context: i64, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_setInt64IterationContext ( ucfpos : *mut UConstrainedFieldPosition , context : i64 , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_setInt64IterationContext(ucfpos, context, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucfpos_setState(ucfpos: *mut UConstrainedFieldPosition, category: i32, field: i32, start: i32, limit: i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucfpos_setState ( ucfpos : *mut UConstrainedFieldPosition , category : i32 , field : i32 , start : i32 , limit : i32 , ec : *mut UErrorCode ) -> ( ) );
    ucfpos_setState(ucfpos, category, field, start, limit, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_cbFromUWriteBytes<P0>(args: *mut UConverterFromUnicodeArgs, source: P0, length: i32, offsetindex: i32, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_cbFromUWriteBytes ( args : *mut UConverterFromUnicodeArgs , source : :: windows::core::PCSTR , length : i32 , offsetindex : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_cbFromUWriteBytes(args, source.into_param().abi(), length, offsetindex, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_cbFromUWriteSub(args: *mut UConverterFromUnicodeArgs, offsetindex: i32, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_cbFromUWriteSub ( args : *mut UConverterFromUnicodeArgs , offsetindex : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_cbFromUWriteSub(args, offsetindex, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_cbFromUWriteUChars(args: *mut UConverterFromUnicodeArgs, source: *const *const u16, sourcelimit: *const u16, offsetindex: i32, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_cbFromUWriteUChars ( args : *mut UConverterFromUnicodeArgs , source : *const *const u16 , sourcelimit : *const u16 , offsetindex : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_cbFromUWriteUChars(args, source, sourcelimit, offsetindex, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_cbToUWriteSub(args: *mut UConverterToUnicodeArgs, offsetindex: i32, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_cbToUWriteSub ( args : *mut UConverterToUnicodeArgs , offsetindex : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_cbToUWriteSub(args, offsetindex, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_cbToUWriteUChars(args: *mut UConverterToUnicodeArgs, source: *const u16, length: i32, offsetindex: i32, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_cbToUWriteUChars ( args : *mut UConverterToUnicodeArgs , source : *const u16 , length : i32 , offsetindex : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_cbToUWriteUChars(args, source, length, offsetindex, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_close(converter: *mut UConverter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_close ( converter : *mut UConverter ) -> ( ) );
    ucnv_close(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_compareNames<P0, P1>(name1: P0, name2: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_compareNames ( name1 : :: windows::core::PCSTR , name2 : :: windows::core::PCSTR ) -> i32 );
    ucnv_compareNames(name1.into_param().abi(), name2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_convert<P0, P1, P2, P3>(toconvertername: P0, fromconvertername: P1, target: P2, targetcapacity: i32, source: P3, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_convert ( toconvertername : :: windows::core::PCSTR , fromconvertername : :: windows::core::PCSTR , target : :: windows::core::PCSTR , targetcapacity : i32 , source : :: windows::core::PCSTR , sourcelength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucnv_convert(toconvertername.into_param().abi(), fromconvertername.into_param().abi(), target.into_param().abi(), targetcapacity, source.into_param().abi(), sourcelength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_convertEx<P0, P1>(targetcnv: *mut UConverter, sourcecnv: *mut UConverter, target: *mut *mut i8, targetlimit: P0, source: *const *const i8, sourcelimit: P1, pivotstart: *mut u16, pivotsource: *mut *mut u16, pivottarget: *mut *mut u16, pivotlimit: *const u16, reset: i8, flush: i8, perrorcode: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_convertEx ( targetcnv : *mut UConverter , sourcecnv : *mut UConverter , target : *mut *mut i8 , targetlimit : :: windows::core::PCSTR , source : *const *const i8 , sourcelimit : :: windows::core::PCSTR , pivotstart : *mut u16 , pivotsource : *mut *mut u16 , pivottarget : *mut *mut u16 , pivotlimit : *const u16 , reset : i8 , flush : i8 , perrorcode : *mut UErrorCode ) -> ( ) );
    ucnv_convertEx(targetcnv, sourcecnv, target, targetlimit.into_param().abi(), source, sourcelimit.into_param().abi(), pivotstart, pivotsource, pivottarget, pivotlimit, reset, flush, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_countAliases<P0>(alias: P0, perrorcode: *mut UErrorCode) -> u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_countAliases ( alias : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> u16 );
    ucnv_countAliases(alias.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_countAvailable ( ) -> i32 );
    ucnv_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_countStandards() -> u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_countStandards ( ) -> u16 );
    ucnv_countStandards()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_detectUnicodeSignature<P0>(source: P0, sourcelength: i32, signaturelength: *mut i32, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_detectUnicodeSignature ( source : :: windows::core::PCSTR , sourcelength : i32 , signaturelength : *mut i32 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_detectUnicodeSignature(source.into_param().abi(), sourcelength, signaturelength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_fixFileSeparator(cnv: *const UConverter, source: *mut u16, sourcelen: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_fixFileSeparator ( cnv : *const UConverter , source : *mut u16 , sourcelen : i32 ) -> ( ) );
    ucnv_fixFileSeparator(cnv, source, sourcelen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_flushCache() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_flushCache ( ) -> i32 );
    ucnv_flushCache()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_fromAlgorithmic<P0, P1>(cnv: *mut UConverter, algorithmictype: UConverterType, target: P0, targetcapacity: i32, source: P1, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_fromAlgorithmic ( cnv : *mut UConverter , algorithmictype : UConverterType , target : :: windows::core::PCSTR , targetcapacity : i32 , source : :: windows::core::PCSTR , sourcelength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucnv_fromAlgorithmic(cnv, algorithmictype, target.into_param().abi(), targetcapacity, source.into_param().abi(), sourcelength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_fromUChars<P0>(cnv: *mut UConverter, dest: P0, destcapacity: i32, src: *const u16, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_fromUChars ( cnv : *mut UConverter , dest : :: windows::core::PCSTR , destcapacity : i32 , src : *const u16 , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucnv_fromUChars(cnv, dest.into_param().abi(), destcapacity, src, srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_fromUCountPending(cnv: *const UConverter, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_fromUCountPending ( cnv : *const UConverter , status : *mut UErrorCode ) -> i32 );
    ucnv_fromUCountPending(cnv, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_fromUnicode<P0>(converter: *mut UConverter, target: *mut *mut i8, targetlimit: P0, source: *const *const u16, sourcelimit: *const u16, offsets: *mut i32, flush: i8, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_fromUnicode ( converter : *mut UConverter , target : *mut *mut i8 , targetlimit : :: windows::core::PCSTR , source : *const *const u16 , sourcelimit : *const u16 , offsets : *mut i32 , flush : i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_fromUnicode(converter, target, targetlimit.into_param().abi(), source, sourcelimit, offsets, flush, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getAlias<P0>(alias: P0, n: u16, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getAlias ( alias : :: windows::core::PCSTR , n : u16 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_getAlias(alias.into_param().abi(), n, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getAliases<P0>(alias: P0, aliases: *const *const i8, perrorcode: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getAliases ( alias : :: windows::core::PCSTR , aliases : *const *const i8 , perrorcode : *mut UErrorCode ) -> ( ) );
    ucnv_getAliases(alias.into_param().abi(), aliases, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getAvailableName(n: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getAvailableName ( n : i32 ) -> :: windows::core::PSTR );
    ucnv_getAvailableName(n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getCCSID(converter: *const UConverter, err: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getCCSID ( converter : *const UConverter , err : *mut UErrorCode ) -> i32 );
    ucnv_getCCSID(converter, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getCanonicalName<P0, P1>(alias: P0, standard: P1, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getCanonicalName ( alias : :: windows::core::PCSTR , standard : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_getCanonicalName(alias.into_param().abi(), standard.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getDefaultName() -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getDefaultName ( ) -> :: windows::core::PSTR );
    ucnv_getDefaultName()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getDisplayName<P0>(converter: *const UConverter, displaylocale: P0, displayname: *mut u16, displaynamecapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getDisplayName ( converter : *const UConverter , displaylocale : :: windows::core::PCSTR , displayname : *mut u16 , displaynamecapacity : i32 , err : *mut UErrorCode ) -> i32 );
    ucnv_getDisplayName(converter, displaylocale.into_param().abi(), displayname, displaynamecapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getFromUCallBack(converter: *const UConverter, action: *mut UConverterFromUCallback, context: *const *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getFromUCallBack ( converter : *const UConverter , action : *mut UConverterFromUCallback , context : *const *const ::core::ffi::c_void ) -> ( ) );
    ucnv_getFromUCallBack(converter, action, context)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getInvalidChars<P0>(converter: *const UConverter, errbytes: P0, len: *mut i8, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getInvalidChars ( converter : *const UConverter , errbytes : :: windows::core::PCSTR , len : *mut i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_getInvalidChars(converter, errbytes.into_param().abi(), len, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getInvalidUChars(converter: *const UConverter, erruchars: *mut u16, len: *mut i8, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getInvalidUChars ( converter : *const UConverter , erruchars : *mut u16 , len : *mut i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_getInvalidUChars(converter, erruchars, len, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getMaxCharSize(converter: *const UConverter) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getMaxCharSize ( converter : *const UConverter ) -> i8 );
    ucnv_getMaxCharSize(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getMinCharSize(converter: *const UConverter) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getMinCharSize ( converter : *const UConverter ) -> i8 );
    ucnv_getMinCharSize(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getName(converter: *const UConverter, err: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getName ( converter : *const UConverter , err : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_getName(converter, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getNextUChar<P0>(converter: *mut UConverter, source: *const *const i8, sourcelimit: P0, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getNextUChar ( converter : *mut UConverter , source : *const *const i8 , sourcelimit : :: windows::core::PCSTR , err : *mut UErrorCode ) -> i32 );
    ucnv_getNextUChar(converter, source, sourcelimit.into_param().abi(), err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getPlatform(converter: *const UConverter, err: *mut UErrorCode) -> UConverterPlatform {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getPlatform ( converter : *const UConverter , err : *mut UErrorCode ) -> UConverterPlatform );
    ucnv_getPlatform(converter, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getStandard(n: u16, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getStandard ( n : u16 , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_getStandard(n, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getStandardName<P0, P1>(name: P0, standard: P1, perrorcode: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getStandardName ( name : :: windows::core::PCSTR , standard : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucnv_getStandardName(name.into_param().abi(), standard.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getStarters(converter: *const UConverter, starters: *mut i8, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getStarters ( converter : *const UConverter , starters : *mut i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_getStarters(converter, starters, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getSubstChars<P0>(converter: *const UConverter, subchars: P0, len: *mut i8, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getSubstChars ( converter : *const UConverter , subchars : :: windows::core::PCSTR , len : *mut i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_getSubstChars(converter, subchars.into_param().abi(), len, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getToUCallBack(converter: *const UConverter, action: *mut UConverterToUCallback, context: *const *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getToUCallBack ( converter : *const UConverter , action : *mut UConverterToUCallback , context : *const *const ::core::ffi::c_void ) -> ( ) );
    ucnv_getToUCallBack(converter, action, context)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getType(converter: *const UConverter) -> UConverterType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getType ( converter : *const UConverter ) -> UConverterType );
    ucnv_getType(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_getUnicodeSet(cnv: *const UConverter, setfillin: *mut USet, whichset: UConverterUnicodeSet, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_getUnicodeSet ( cnv : *const UConverter , setfillin : *mut USet , whichset : UConverterUnicodeSet , perrorcode : *mut UErrorCode ) -> ( ) );
    ucnv_getUnicodeSet(cnv, setfillin, whichset, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_isAmbiguous(cnv: *const UConverter) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_isAmbiguous ( cnv : *const UConverter ) -> i8 );
    ucnv_isAmbiguous(cnv)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_isFixedWidth(cnv: *mut UConverter, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_isFixedWidth ( cnv : *mut UConverter , status : *mut UErrorCode ) -> i8 );
    ucnv_isFixedWidth(cnv, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_open<P0>(convertername: P0, err: *mut UErrorCode) -> *mut UConverter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_open ( convertername : :: windows::core::PCSTR , err : *mut UErrorCode ) -> *mut UConverter );
    ucnv_open(convertername.into_param().abi(), err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_openAllNames(perrorcode: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_openAllNames ( perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    ucnv_openAllNames(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_openCCSID(codepage: i32, platform: UConverterPlatform, err: *mut UErrorCode) -> *mut UConverter {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_openCCSID ( codepage : i32 , platform : UConverterPlatform , err : *mut UErrorCode ) -> *mut UConverter );
    ucnv_openCCSID(codepage, platform, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_openPackage<P0, P1>(packagename: P0, convertername: P1, err: *mut UErrorCode) -> *mut UConverter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_openPackage ( packagename : :: windows::core::PCSTR , convertername : :: windows::core::PCSTR , err : *mut UErrorCode ) -> *mut UConverter );
    ucnv_openPackage(packagename.into_param().abi(), convertername.into_param().abi(), err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_openStandardNames<P0, P1>(convname: P0, standard: P1, perrorcode: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_openStandardNames ( convname : :: windows::core::PCSTR , standard : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    ucnv_openStandardNames(convname.into_param().abi(), standard.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_openU(name: *const u16, err: *mut UErrorCode) -> *mut UConverter {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_openU ( name : *const u16 , err : *mut UErrorCode ) -> *mut UConverter );
    ucnv_openU(name, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_reset(converter: *mut UConverter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_reset ( converter : *mut UConverter ) -> ( ) );
    ucnv_reset(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_resetFromUnicode(converter: *mut UConverter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_resetFromUnicode ( converter : *mut UConverter ) -> ( ) );
    ucnv_resetFromUnicode(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_resetToUnicode(converter: *mut UConverter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_resetToUnicode ( converter : *mut UConverter ) -> ( ) );
    ucnv_resetToUnicode(converter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_safeClone(cnv: *const UConverter, stackbuffer: *mut ::core::ffi::c_void, pbuffersize: *mut i32, status: *mut UErrorCode) -> *mut UConverter {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_safeClone ( cnv : *const UConverter , stackbuffer : *mut ::core::ffi::c_void , pbuffersize : *mut i32 , status : *mut UErrorCode ) -> *mut UConverter );
    ucnv_safeClone(cnv, stackbuffer, pbuffersize, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setDefaultName<P0>(name: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setDefaultName ( name : :: windows::core::PCSTR ) -> ( ) );
    ucnv_setDefaultName(name.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setFallback(cnv: *mut UConverter, usesfallback: i8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setFallback ( cnv : *mut UConverter , usesfallback : i8 ) -> ( ) );
    ucnv_setFallback(cnv, usesfallback)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setFromUCallBack(converter: *mut UConverter, newaction: UConverterFromUCallback, newcontext: *const ::core::ffi::c_void, oldaction: *mut UConverterFromUCallback, oldcontext: *const *const ::core::ffi::c_void, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setFromUCallBack ( converter : *mut UConverter , newaction : UConverterFromUCallback , newcontext : *const ::core::ffi::c_void , oldaction : *mut UConverterFromUCallback , oldcontext : *const *const ::core::ffi::c_void , err : *mut UErrorCode ) -> ( ) );
    ucnv_setFromUCallBack(converter, newaction, newcontext, oldaction, oldcontext, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setSubstChars<P0>(converter: *mut UConverter, subchars: P0, len: i8, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setSubstChars ( converter : *mut UConverter , subchars : :: windows::core::PCSTR , len : i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_setSubstChars(converter, subchars.into_param().abi(), len, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setSubstString(cnv: *mut UConverter, s: *const u16, length: i32, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setSubstString ( cnv : *mut UConverter , s : *const u16 , length : i32 , err : *mut UErrorCode ) -> ( ) );
    ucnv_setSubstString(cnv, s, length, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_setToUCallBack(converter: *mut UConverter, newaction: UConverterToUCallback, newcontext: *const ::core::ffi::c_void, oldaction: *mut UConverterToUCallback, oldcontext: *const *const ::core::ffi::c_void, err: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_setToUCallBack ( converter : *mut UConverter , newaction : UConverterToUCallback , newcontext : *const ::core::ffi::c_void , oldaction : *mut UConverterToUCallback , oldcontext : *const *const ::core::ffi::c_void , err : *mut UErrorCode ) -> ( ) );
    ucnv_setToUCallBack(converter, newaction, newcontext, oldaction, oldcontext, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_toAlgorithmic<P0, P1>(algorithmictype: UConverterType, cnv: *mut UConverter, target: P0, targetcapacity: i32, source: P1, sourcelength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_toAlgorithmic ( algorithmictype : UConverterType , cnv : *mut UConverter , target : :: windows::core::PCSTR , targetcapacity : i32 , source : :: windows::core::PCSTR , sourcelength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucnv_toAlgorithmic(algorithmictype, cnv, target.into_param().abi(), targetcapacity, source.into_param().abi(), sourcelength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_toUChars<P0>(cnv: *mut UConverter, dest: *mut u16, destcapacity: i32, src: P0, srclength: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_toUChars ( cnv : *mut UConverter , dest : *mut u16 , destcapacity : i32 , src : :: windows::core::PCSTR , srclength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucnv_toUChars(cnv, dest, destcapacity, src.into_param().abi(), srclength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_toUCountPending(cnv: *const UConverter, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_toUCountPending ( cnv : *const UConverter , status : *mut UErrorCode ) -> i32 );
    ucnv_toUCountPending(cnv, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_toUnicode<P0>(converter: *mut UConverter, target: *mut *mut u16, targetlimit: *const u16, source: *const *const i8, sourcelimit: P0, offsets: *mut i32, flush: i8, err: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_toUnicode ( converter : *mut UConverter , target : *mut *mut u16 , targetlimit : *const u16 , source : *const *const i8 , sourcelimit : :: windows::core::PCSTR , offsets : *mut i32 , flush : i8 , err : *mut UErrorCode ) -> ( ) );
    ucnv_toUnicode(converter, target, targetlimit, source, sourcelimit.into_param().abi(), offsets, flush, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnv_usesFallback(cnv: *const UConverter) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnv_usesFallback ( cnv : *const UConverter ) -> i8 );
    ucnv_usesFallback(cnv)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_close(sel: *mut UConverterSelector) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_close ( sel : *mut UConverterSelector ) -> ( ) );
    ucnvsel_close(sel)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_open(converterlist: *const *const i8, converterlistsize: i32, excludedcodepoints: *const USet, whichset: UConverterUnicodeSet, status: *mut UErrorCode) -> *mut UConverterSelector {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_open ( converterlist : *const *const i8 , converterlistsize : i32 , excludedcodepoints : *const USet , whichset : UConverterUnicodeSet , status : *mut UErrorCode ) -> *mut UConverterSelector );
    ucnvsel_open(converterlist, converterlistsize, excludedcodepoints, whichset, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_openFromSerialized(buffer: *const ::core::ffi::c_void, length: i32, status: *mut UErrorCode) -> *mut UConverterSelector {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_openFromSerialized ( buffer : *const ::core::ffi::c_void , length : i32 , status : *mut UErrorCode ) -> *mut UConverterSelector );
    ucnvsel_openFromSerialized(buffer, length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_selectForString(sel: *const UConverterSelector, s: *const u16, length: i32, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_selectForString ( sel : *const UConverterSelector , s : *const u16 , length : i32 , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucnvsel_selectForString(sel, s, length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_selectForUTF8<P0>(sel: *const UConverterSelector, s: P0, length: i32, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_selectForUTF8 ( sel : *const UConverterSelector , s : :: windows::core::PCSTR , length : i32 , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucnvsel_selectForUTF8(sel, s.into_param().abi(), length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucnvsel_serialize(sel: *const UConverterSelector, buffer: *mut ::core::ffi::c_void, buffercapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucnvsel_serialize ( sel : *const UConverterSelector , buffer : *mut ::core::ffi::c_void , buffercapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ucnvsel_serialize(sel, buffer, buffercapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_cloneBinary(coll: *const UCollator, buffer: *mut u8, capacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_cloneBinary ( coll : *const UCollator , buffer : *mut u8 , capacity : i32 , status : *mut UErrorCode ) -> i32 );
    ucol_cloneBinary(coll, buffer, capacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_close(coll: *mut UCollator) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_close ( coll : *mut UCollator ) -> ( ) );
    ucol_close(coll)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_closeElements(elems: *mut UCollationElements) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_closeElements ( elems : *mut UCollationElements ) -> ( ) );
    ucol_closeElements(elems)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_countAvailable ( ) -> i32 );
    ucol_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_equal(coll: *const UCollator, source: *const u16, sourcelength: i32, target: *const u16, targetlength: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_equal ( coll : *const UCollator , source : *const u16 , sourcelength : i32 , target : *const u16 , targetlength : i32 ) -> i8 );
    ucol_equal(coll, source, sourcelength, target, targetlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getAttribute(coll: *const UCollator, attr: UColAttribute, status: *mut UErrorCode) -> UColAttributeValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getAttribute ( coll : *const UCollator , attr : UColAttribute , status : *mut UErrorCode ) -> UColAttributeValue );
    ucol_getAttribute(coll, attr, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getAvailable(localeindex: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getAvailable ( localeindex : i32 ) -> :: windows::core::PSTR );
    ucol_getAvailable(localeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getBound(source: *const u8, sourcelength: i32, boundtype: UColBoundMode, nooflevels: u32, result: *mut u8, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getBound ( source : *const u8 , sourcelength : i32 , boundtype : UColBoundMode , nooflevels : u32 , result : *mut u8 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    ucol_getBound(source, sourcelength, boundtype, nooflevels, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getContractionsAndExpansions(coll: *const UCollator, contractions: *mut USet, expansions: *mut USet, addprefixes: i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getContractionsAndExpansions ( coll : *const UCollator , contractions : *mut USet , expansions : *mut USet , addprefixes : i8 , status : *mut UErrorCode ) -> ( ) );
    ucol_getContractionsAndExpansions(coll, contractions, expansions, addprefixes, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getDisplayName<P0, P1>(objloc: P0, disploc: P1, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getDisplayName ( objloc : :: windows::core::PCSTR , disploc : :: windows::core::PCSTR , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    ucol_getDisplayName(objloc.into_param().abi(), disploc.into_param().abi(), result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getEquivalentReorderCodes(reordercode: i32, dest: *mut i32, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getEquivalentReorderCodes ( reordercode : i32 , dest : *mut i32 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucol_getEquivalentReorderCodes(reordercode, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getFunctionalEquivalent<P0, P1, P2>(result: P0, resultcapacity: i32, keyword: P1, locale: P2, isavailable: *mut i8, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getFunctionalEquivalent ( result : :: windows::core::PCSTR , resultcapacity : i32 , keyword : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , isavailable : *mut i8 , status : *mut UErrorCode ) -> i32 );
    ucol_getFunctionalEquivalent(result.into_param().abi(), resultcapacity, keyword.into_param().abi(), locale.into_param().abi(), isavailable, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getKeywordValues<P0>(keyword: P0, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getKeywordValues ( keyword : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucol_getKeywordValues(keyword.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getKeywordValuesForLocale<P0, P1>(key: P0, locale: P1, commonlyused: i8, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getKeywordValuesForLocale ( key : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , commonlyused : i8 , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucol_getKeywordValuesForLocale(key.into_param().abi(), locale.into_param().abi(), commonlyused, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getKeywords(status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getKeywords ( status : *mut UErrorCode ) -> *mut UEnumeration );
    ucol_getKeywords(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getLocaleByType(coll: *const UCollator, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getLocaleByType ( coll : *const UCollator , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucol_getLocaleByType(coll, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getMaxExpansion(elems: *const UCollationElements, order: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getMaxExpansion ( elems : *const UCollationElements , order : i32 ) -> i32 );
    ucol_getMaxExpansion(elems, order)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getMaxVariable(coll: *const UCollator) -> UColReorderCode {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getMaxVariable ( coll : *const UCollator ) -> UColReorderCode );
    ucol_getMaxVariable(coll)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getOffset(elems: *const UCollationElements) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getOffset ( elems : *const UCollationElements ) -> i32 );
    ucol_getOffset(elems)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getReorderCodes(coll: *const UCollator, dest: *mut i32, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getReorderCodes ( coll : *const UCollator , dest : *mut i32 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucol_getReorderCodes(coll, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getRules(coll: *const UCollator, length: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getRules ( coll : *const UCollator , length : *mut i32 ) -> *mut u16 );
    ucol_getRules(coll, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getRulesEx(coll: *const UCollator, delta: UColRuleOption, buffer: *mut u16, bufferlen: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getRulesEx ( coll : *const UCollator , delta : UColRuleOption , buffer : *mut u16 , bufferlen : i32 ) -> i32 );
    ucol_getRulesEx(coll, delta, buffer, bufferlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getSortKey(coll: *const UCollator, source: *const u16, sourcelength: i32, result: *mut u8, resultlength: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getSortKey ( coll : *const UCollator , source : *const u16 , sourcelength : i32 , result : *mut u8 , resultlength : i32 ) -> i32 );
    ucol_getSortKey(coll, source, sourcelength, result, resultlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getStrength(coll: *const UCollator) -> UColAttributeValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getStrength ( coll : *const UCollator ) -> UColAttributeValue );
    ucol_getStrength(coll)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getTailoredSet(coll: *const UCollator, status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getTailoredSet ( coll : *const UCollator , status : *mut UErrorCode ) -> *mut USet );
    ucol_getTailoredSet(coll, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getUCAVersion(coll: *const UCollator, info: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getUCAVersion ( coll : *const UCollator , info : *mut u8 ) -> ( ) );
    ucol_getUCAVersion(coll, info)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getVariableTop(coll: *const UCollator, status: *mut UErrorCode) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getVariableTop ( coll : *const UCollator , status : *mut UErrorCode ) -> u32 );
    ucol_getVariableTop(coll, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_getVersion(coll: *const UCollator, info: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_getVersion ( coll : *const UCollator , info : *mut u8 ) -> ( ) );
    ucol_getVersion(coll, info)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_greater(coll: *const UCollator, source: *const u16, sourcelength: i32, target: *const u16, targetlength: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_greater ( coll : *const UCollator , source : *const u16 , sourcelength : i32 , target : *const u16 , targetlength : i32 ) -> i8 );
    ucol_greater(coll, source, sourcelength, target, targetlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_greaterOrEqual(coll: *const UCollator, source: *const u16, sourcelength: i32, target: *const u16, targetlength: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_greaterOrEqual ( coll : *const UCollator , source : *const u16 , sourcelength : i32 , target : *const u16 , targetlength : i32 ) -> i8 );
    ucol_greaterOrEqual(coll, source, sourcelength, target, targetlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_keyHashCode(key: *const u8, length: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_keyHashCode ( key : *const u8 , length : i32 ) -> i32 );
    ucol_keyHashCode(key, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_mergeSortkeys(src1: *const u8, src1length: i32, src2: *const u8, src2length: i32, dest: *mut u8, destcapacity: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_mergeSortkeys ( src1 : *const u8 , src1length : i32 , src2 : *const u8 , src2length : i32 , dest : *mut u8 , destcapacity : i32 ) -> i32 );
    ucol_mergeSortkeys(src1, src1length, src2, src2length, dest, destcapacity)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_next(elems: *mut UCollationElements, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_next ( elems : *mut UCollationElements , status : *mut UErrorCode ) -> i32 );
    ucol_next(elems, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_nextSortKeyPart(coll: *const UCollator, iter: *mut UCharIterator, state: *mut u32, dest: *mut u8, count: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_nextSortKeyPart ( coll : *const UCollator , iter : *mut UCharIterator , state : *mut u32 , dest : *mut u8 , count : i32 , status : *mut UErrorCode ) -> i32 );
    ucol_nextSortKeyPart(coll, iter, state, dest, count, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_open<P0>(loc: P0, status: *mut UErrorCode) -> *mut UCollator
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_open ( loc : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UCollator );
    ucol_open(loc.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_openAvailableLocales(status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_openAvailableLocales ( status : *mut UErrorCode ) -> *mut UEnumeration );
    ucol_openAvailableLocales(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_openBinary(bin: *const u8, length: i32, base: *const UCollator, status: *mut UErrorCode) -> *mut UCollator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_openBinary ( bin : *const u8 , length : i32 , base : *const UCollator , status : *mut UErrorCode ) -> *mut UCollator );
    ucol_openBinary(bin, length, base, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_openElements(coll: *const UCollator, text: *const u16, textlength: i32, status: *mut UErrorCode) -> *mut UCollationElements {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_openElements ( coll : *const UCollator , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> *mut UCollationElements );
    ucol_openElements(coll, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_openRules(rules: *const u16, ruleslength: i32, normalizationmode: UColAttributeValue, strength: UColAttributeValue, parseerror: *mut UParseError, status: *mut UErrorCode) -> *mut UCollator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_openRules ( rules : *const u16 , ruleslength : i32 , normalizationmode : UColAttributeValue , strength : UColAttributeValue , parseerror : *mut UParseError , status : *mut UErrorCode ) -> *mut UCollator );
    ucol_openRules(rules, ruleslength, normalizationmode, strength, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_previous(elems: *mut UCollationElements, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_previous ( elems : *mut UCollationElements , status : *mut UErrorCode ) -> i32 );
    ucol_previous(elems, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_primaryOrder(order: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_primaryOrder ( order : i32 ) -> i32 );
    ucol_primaryOrder(order)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_reset(elems: *mut UCollationElements) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_reset ( elems : *mut UCollationElements ) -> ( ) );
    ucol_reset(elems)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_safeClone(coll: *const UCollator, stackbuffer: *mut ::core::ffi::c_void, pbuffersize: *mut i32, status: *mut UErrorCode) -> *mut UCollator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_safeClone ( coll : *const UCollator , stackbuffer : *mut ::core::ffi::c_void , pbuffersize : *mut i32 , status : *mut UErrorCode ) -> *mut UCollator );
    ucol_safeClone(coll, stackbuffer, pbuffersize, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_secondaryOrder(order: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_secondaryOrder ( order : i32 ) -> i32 );
    ucol_secondaryOrder(order)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setAttribute(coll: *mut UCollator, attr: UColAttribute, value: UColAttributeValue, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setAttribute ( coll : *mut UCollator , attr : UColAttribute , value : UColAttributeValue , status : *mut UErrorCode ) -> ( ) );
    ucol_setAttribute(coll, attr, value, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setMaxVariable(coll: *mut UCollator, group: UColReorderCode, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setMaxVariable ( coll : *mut UCollator , group : UColReorderCode , perrorcode : *mut UErrorCode ) -> ( ) );
    ucol_setMaxVariable(coll, group, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setOffset(elems: *mut UCollationElements, offset: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setOffset ( elems : *mut UCollationElements , offset : i32 , status : *mut UErrorCode ) -> ( ) );
    ucol_setOffset(elems, offset, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setReorderCodes(coll: *mut UCollator, reordercodes: *const i32, reordercodeslength: i32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setReorderCodes ( coll : *mut UCollator , reordercodes : *const i32 , reordercodeslength : i32 , perrorcode : *mut UErrorCode ) -> ( ) );
    ucol_setReorderCodes(coll, reordercodes, reordercodeslength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setStrength(coll: *mut UCollator, strength: UColAttributeValue) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setStrength ( coll : *mut UCollator , strength : UColAttributeValue ) -> ( ) );
    ucol_setStrength(coll, strength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_setText(elems: *mut UCollationElements, text: *const u16, textlength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_setText ( elems : *mut UCollationElements , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> ( ) );
    ucol_setText(elems, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_strcoll(coll: *const UCollator, source: *const u16, sourcelength: i32, target: *const u16, targetlength: i32) -> UCollationResult {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_strcoll ( coll : *const UCollator , source : *const u16 , sourcelength : i32 , target : *const u16 , targetlength : i32 ) -> UCollationResult );
    ucol_strcoll(coll, source, sourcelength, target, targetlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_strcollIter(coll: *const UCollator, siter: *mut UCharIterator, titer: *mut UCharIterator, status: *mut UErrorCode) -> UCollationResult {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_strcollIter ( coll : *const UCollator , siter : *mut UCharIterator , titer : *mut UCharIterator , status : *mut UErrorCode ) -> UCollationResult );
    ucol_strcollIter(coll, siter, titer, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_strcollUTF8<P0, P1>(coll: *const UCollator, source: P0, sourcelength: i32, target: P1, targetlength: i32, status: *mut UErrorCode) -> UCollationResult
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_strcollUTF8 ( coll : *const UCollator , source : :: windows::core::PCSTR , sourcelength : i32 , target : :: windows::core::PCSTR , targetlength : i32 , status : *mut UErrorCode ) -> UCollationResult );
    ucol_strcollUTF8(coll, source.into_param().abi(), sourcelength, target.into_param().abi(), targetlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucol_tertiaryOrder(order: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucol_tertiaryOrder ( order : i32 ) -> i32 );
    ucol_tertiaryOrder(order)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucpmap_get(map: *const UCPMap, c: i32) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucpmap_get ( map : *const UCPMap , c : i32 ) -> u32 );
    ucpmap_get(map, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucpmap_getRange(map: *const UCPMap, start: i32, option: UCPMapRangeOption, surrogatevalue: u32, filter: *mut UCPMapValueFilter, context: *const ::core::ffi::c_void, pvalue: *mut u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucpmap_getRange ( map : *const UCPMap , start : i32 , option : UCPMapRangeOption , surrogatevalue : u32 , filter : *mut UCPMapValueFilter , context : *const ::core::ffi::c_void , pvalue : *mut u32 ) -> i32 );
    ucpmap_getRange(map, start, option, surrogatevalue, filter, context, pvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_close(trie: *mut UCPTrie) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_close ( trie : *mut UCPTrie ) -> ( ) );
    ucptrie_close(trie)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_get(trie: *const UCPTrie, c: i32) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_get ( trie : *const UCPTrie , c : i32 ) -> u32 );
    ucptrie_get(trie, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_getRange(trie: *const UCPTrie, start: i32, option: UCPMapRangeOption, surrogatevalue: u32, filter: *mut UCPMapValueFilter, context: *const ::core::ffi::c_void, pvalue: *mut u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_getRange ( trie : *const UCPTrie , start : i32 , option : UCPMapRangeOption , surrogatevalue : u32 , filter : *mut UCPMapValueFilter , context : *const ::core::ffi::c_void , pvalue : *mut u32 ) -> i32 );
    ucptrie_getRange(trie, start, option, surrogatevalue, filter, context, pvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_getType(trie: *const UCPTrie) -> UCPTrieType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_getType ( trie : *const UCPTrie ) -> UCPTrieType );
    ucptrie_getType(trie)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_getValueWidth(trie: *const UCPTrie) -> UCPTrieValueWidth {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_getValueWidth ( trie : *const UCPTrie ) -> UCPTrieValueWidth );
    ucptrie_getValueWidth(trie)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_internalSmallIndex(trie: *const UCPTrie, c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_internalSmallIndex ( trie : *const UCPTrie , c : i32 ) -> i32 );
    ucptrie_internalSmallIndex(trie, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_internalSmallU8Index(trie: *const UCPTrie, lt1: i32, t2: u8, t3: u8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_internalSmallU8Index ( trie : *const UCPTrie , lt1 : i32 , t2 : u8 , t3 : u8 ) -> i32 );
    ucptrie_internalSmallU8Index(trie, lt1, t2, t3)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_internalU8PrevIndex(trie: *const UCPTrie, c: i32, start: *const u8, src: *const u8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_internalU8PrevIndex ( trie : *const UCPTrie , c : i32 , start : *const u8 , src : *const u8 ) -> i32 );
    ucptrie_internalU8PrevIndex(trie, c, start, src)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_openFromBinary(r#type: UCPTrieType, valuewidth: UCPTrieValueWidth, data: *const ::core::ffi::c_void, length: i32, pactuallength: *mut i32, perrorcode: *mut UErrorCode) -> *mut UCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_openFromBinary ( r#type : UCPTrieType , valuewidth : UCPTrieValueWidth , data : *const ::core::ffi::c_void , length : i32 , pactuallength : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut UCPTrie );
    ucptrie_openFromBinary(r#type, valuewidth, data, length, pactuallength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucptrie_toBinary(trie: *const UCPTrie, data: *mut ::core::ffi::c_void, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucptrie_toBinary ( trie : *const UCPTrie , data : *mut ::core::ffi::c_void , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    ucptrie_toBinary(trie, data, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_close(ucsd: *mut UCharsetDetector) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_close ( ucsd : *mut UCharsetDetector ) -> ( ) );
    ucsdet_close(ucsd)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_detect(ucsd: *mut UCharsetDetector, status: *mut UErrorCode) -> *mut UCharsetMatch {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_detect ( ucsd : *mut UCharsetDetector , status : *mut UErrorCode ) -> *mut UCharsetMatch );
    ucsdet_detect(ucsd, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_detectAll(ucsd: *mut UCharsetDetector, matchesfound: *mut i32, status: *mut UErrorCode) -> *mut *mut UCharsetMatch {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_detectAll ( ucsd : *mut UCharsetDetector , matchesfound : *mut i32 , status : *mut UErrorCode ) -> *mut *mut UCharsetMatch );
    ucsdet_detectAll(ucsd, matchesfound, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_enableInputFilter(ucsd: *mut UCharsetDetector, filter: i8) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_enableInputFilter ( ucsd : *mut UCharsetDetector , filter : i8 ) -> i8 );
    ucsdet_enableInputFilter(ucsd, filter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_getAllDetectableCharsets(ucsd: *const UCharsetDetector, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_getAllDetectableCharsets ( ucsd : *const UCharsetDetector , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucsdet_getAllDetectableCharsets(ucsd, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_getConfidence(ucsm: *const UCharsetMatch, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_getConfidence ( ucsm : *const UCharsetMatch , status : *mut UErrorCode ) -> i32 );
    ucsdet_getConfidence(ucsm, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_getLanguage(ucsm: *const UCharsetMatch, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_getLanguage ( ucsm : *const UCharsetMatch , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucsdet_getLanguage(ucsm, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_getName(ucsm: *const UCharsetMatch, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_getName ( ucsm : *const UCharsetMatch , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ucsdet_getName(ucsm, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_getUChars(ucsm: *const UCharsetMatch, buf: *mut u16, cap: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_getUChars ( ucsm : *const UCharsetMatch , buf : *mut u16 , cap : i32 , status : *mut UErrorCode ) -> i32 );
    ucsdet_getUChars(ucsm, buf, cap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_isInputFilterEnabled(ucsd: *const UCharsetDetector) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_isInputFilterEnabled ( ucsd : *const UCharsetDetector ) -> i8 );
    ucsdet_isInputFilterEnabled(ucsd)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_open(status: *mut UErrorCode) -> *mut UCharsetDetector {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_open ( status : *mut UErrorCode ) -> *mut UCharsetDetector );
    ucsdet_open(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_setDeclaredEncoding<P0>(ucsd: *mut UCharsetDetector, encoding: P0, length: i32, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_setDeclaredEncoding ( ucsd : *mut UCharsetDetector , encoding : :: windows::core::PCSTR , length : i32 , status : *mut UErrorCode ) -> ( ) );
    ucsdet_setDeclaredEncoding(ucsd, encoding.into_param().abi(), length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucsdet_setText<P0>(ucsd: *mut UCharsetDetector, textin: P0, len: i32, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucsdet_setText ( ucsd : *mut UCharsetDetector , textin : :: windows::core::PCSTR , len : i32 , status : *mut UErrorCode ) -> ( ) );
    ucsdet_setText(ucsd, textin.into_param().abi(), len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_countCurrencies<P0>(locale: P0, date: f64, ec: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_countCurrencies ( locale : :: windows::core::PCSTR , date : f64 , ec : *mut UErrorCode ) -> i32 );
    ucurr_countCurrencies(locale.into_param().abi(), date, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_forLocale<P0>(locale: P0, buff: *mut u16, buffcapacity: i32, ec: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_forLocale ( locale : :: windows::core::PCSTR , buff : *mut u16 , buffcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    ucurr_forLocale(locale.into_param().abi(), buff, buffcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_forLocaleAndDate<P0>(locale: P0, date: f64, index: i32, buff: *mut u16, buffcapacity: i32, ec: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_forLocaleAndDate ( locale : :: windows::core::PCSTR , date : f64 , index : i32 , buff : *mut u16 , buffcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    ucurr_forLocaleAndDate(locale.into_param().abi(), date, index, buff, buffcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getDefaultFractionDigits(currency: *const u16, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getDefaultFractionDigits ( currency : *const u16 , ec : *mut UErrorCode ) -> i32 );
    ucurr_getDefaultFractionDigits(currency, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getDefaultFractionDigitsForUsage(currency: *const u16, usage: UCurrencyUsage, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getDefaultFractionDigitsForUsage ( currency : *const u16 , usage : UCurrencyUsage , ec : *mut UErrorCode ) -> i32 );
    ucurr_getDefaultFractionDigitsForUsage(currency, usage, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getKeywordValuesForLocale<P0, P1>(key: P0, locale: P1, commonlyused: i8, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getKeywordValuesForLocale ( key : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , commonlyused : i8 , status : *mut UErrorCode ) -> *mut UEnumeration );
    ucurr_getKeywordValuesForLocale(key.into_param().abi(), locale.into_param().abi(), commonlyused, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getName<P0>(currency: *const u16, locale: P0, namestyle: UCurrNameStyle, ischoiceformat: *mut i8, len: *mut i32, ec: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getName ( currency : *const u16 , locale : :: windows::core::PCSTR , namestyle : UCurrNameStyle , ischoiceformat : *mut i8 , len : *mut i32 , ec : *mut UErrorCode ) -> *mut u16 );
    ucurr_getName(currency, locale.into_param().abi(), namestyle, ischoiceformat, len, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getNumericCode(currency: *const u16) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getNumericCode ( currency : *const u16 ) -> i32 );
    ucurr_getNumericCode(currency)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getPluralName<P0, P1>(currency: *const u16, locale: P0, ischoiceformat: *mut i8, pluralcount: P1, len: *mut i32, ec: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getPluralName ( currency : *const u16 , locale : :: windows::core::PCSTR , ischoiceformat : *mut i8 , pluralcount : :: windows::core::PCSTR , len : *mut i32 , ec : *mut UErrorCode ) -> *mut u16 );
    ucurr_getPluralName(currency, locale.into_param().abi(), ischoiceformat, pluralcount.into_param().abi(), len, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getRoundingIncrement(currency: *const u16, ec: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getRoundingIncrement ( currency : *const u16 , ec : *mut UErrorCode ) -> f64 );
    ucurr_getRoundingIncrement(currency, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_getRoundingIncrementForUsage(currency: *const u16, usage: UCurrencyUsage, ec: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_getRoundingIncrementForUsage ( currency : *const u16 , usage : UCurrencyUsage , ec : *mut UErrorCode ) -> f64 );
    ucurr_getRoundingIncrementForUsage(currency, usage, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_isAvailable(isocode: *const u16, from: f64, to: f64, errorcode: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_isAvailable ( isocode : *const u16 , from : f64 , to : f64 , errorcode : *mut UErrorCode ) -> i8 );
    ucurr_isAvailable(isocode, from, to, errorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_openISOCurrencies(currtype: u32, perrorcode: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_openISOCurrencies ( currtype : u32 , perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    ucurr_openISOCurrencies(currtype, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_register<P0>(isocode: *const u16, locale: P0, status: *mut UErrorCode) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_register ( isocode : *const u16 , locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut ::core::ffi::c_void );
    ucurr_register(isocode, locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ucurr_unregister(key: *mut ::core::ffi::c_void, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ucurr_unregister ( key : *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> i8 );
    ucurr_unregister(key, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_adoptNumberFormat(fmt: *mut *mut ::core::ffi::c_void, numberformattoadopt: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_adoptNumberFormat ( fmt : *mut *mut ::core::ffi::c_void , numberformattoadopt : *mut *mut ::core::ffi::c_void ) -> ( ) );
    udat_adoptNumberFormat(fmt, numberformattoadopt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_adoptNumberFormatForFields(fmt: *mut *mut ::core::ffi::c_void, fields: *const u16, numberformattoset: *mut *mut ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_adoptNumberFormatForFields ( fmt : *mut *mut ::core::ffi::c_void , fields : *const u16 , numberformattoset : *mut *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    udat_adoptNumberFormatForFields(fmt, fields, numberformattoset, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_applyPattern(format: *mut *mut ::core::ffi::c_void, localized: i8, pattern: *const u16, patternlength: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_applyPattern ( format : *mut *mut ::core::ffi::c_void , localized : i8 , pattern : *const u16 , patternlength : i32 ) -> ( ) );
    udat_applyPattern(format, localized, pattern, patternlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_clone(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_clone ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    udat_clone(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_close(format: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_close ( format : *mut *mut ::core::ffi::c_void ) -> ( ) );
    udat_close(format)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_countAvailable ( ) -> i32 );
    udat_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_countSymbols(fmt: *const *const ::core::ffi::c_void, r#type: UDateFormatSymbolType) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_countSymbols ( fmt : *const *const ::core::ffi::c_void , r#type : UDateFormatSymbolType ) -> i32 );
    udat_countSymbols(fmt, r#type)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_format(format: *const *const ::core::ffi::c_void, datetoformat: f64, result: *mut u16, resultlength: i32, position: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_format ( format : *const *const ::core::ffi::c_void , datetoformat : f64 , result : *mut u16 , resultlength : i32 , position : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    udat_format(format, datetoformat, result, resultlength, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_formatCalendar(format: *const *const ::core::ffi::c_void, calendar: *mut *mut ::core::ffi::c_void, result: *mut u16, capacity: i32, position: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_formatCalendar ( format : *const *const ::core::ffi::c_void , calendar : *mut *mut ::core::ffi::c_void , result : *mut u16 , capacity : i32 , position : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    udat_formatCalendar(format, calendar, result, capacity, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_formatCalendarForFields(format: *const *const ::core::ffi::c_void, calendar: *mut *mut ::core::ffi::c_void, result: *mut u16, capacity: i32, fpositer: *mut UFieldPositionIterator, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_formatCalendarForFields ( format : *const *const ::core::ffi::c_void , calendar : *mut *mut ::core::ffi::c_void , result : *mut u16 , capacity : i32 , fpositer : *mut UFieldPositionIterator , status : *mut UErrorCode ) -> i32 );
    udat_formatCalendarForFields(format, calendar, result, capacity, fpositer, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_formatForFields(format: *const *const ::core::ffi::c_void, datetoformat: f64, result: *mut u16, resultlength: i32, fpositer: *mut UFieldPositionIterator, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_formatForFields ( format : *const *const ::core::ffi::c_void , datetoformat : f64 , result : *mut u16 , resultlength : i32 , fpositer : *mut UFieldPositionIterator , status : *mut UErrorCode ) -> i32 );
    udat_formatForFields(format, datetoformat, result, resultlength, fpositer, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_get2DigitYearStart(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_get2DigitYearStart ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> f64 );
    udat_get2DigitYearStart(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getAvailable(localeindex: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getAvailable ( localeindex : i32 ) -> :: windows::core::PSTR );
    udat_getAvailable(localeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getBooleanAttribute(fmt: *const *const ::core::ffi::c_void, attr: UDateFormatBooleanAttribute, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getBooleanAttribute ( fmt : *const *const ::core::ffi::c_void , attr : UDateFormatBooleanAttribute , status : *mut UErrorCode ) -> i8 );
    udat_getBooleanAttribute(fmt, attr, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getCalendar(fmt: *const *const ::core::ffi::c_void) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getCalendar ( fmt : *const *const ::core::ffi::c_void ) -> *mut *mut ::core::ffi::c_void );
    udat_getCalendar(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getContext(fmt: *const *const ::core::ffi::c_void, r#type: UDisplayContextType, status: *mut UErrorCode) -> UDisplayContext {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getContext ( fmt : *const *const ::core::ffi::c_void , r#type : UDisplayContextType , status : *mut UErrorCode ) -> UDisplayContext );
    udat_getContext(fmt, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getLocaleByType(fmt: *const *const ::core::ffi::c_void, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getLocaleByType ( fmt : *const *const ::core::ffi::c_void , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    udat_getLocaleByType(fmt, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getNumberFormat(fmt: *const *const ::core::ffi::c_void) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getNumberFormat ( fmt : *const *const ::core::ffi::c_void ) -> *mut *mut ::core::ffi::c_void );
    udat_getNumberFormat(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getNumberFormatForField(fmt: *const *const ::core::ffi::c_void, field: u16) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getNumberFormatForField ( fmt : *const *const ::core::ffi::c_void , field : u16 ) -> *mut *mut ::core::ffi::c_void );
    udat_getNumberFormatForField(fmt, field)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_getSymbols(fmt: *const *const ::core::ffi::c_void, r#type: UDateFormatSymbolType, symbolindex: i32, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_getSymbols ( fmt : *const *const ::core::ffi::c_void , r#type : UDateFormatSymbolType , symbolindex : i32 , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    udat_getSymbols(fmt, r#type, symbolindex, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_isLenient(fmt: *const *const ::core::ffi::c_void) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_isLenient ( fmt : *const *const ::core::ffi::c_void ) -> i8 );
    udat_isLenient(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_open<P0>(timestyle: UDateFormatStyle, datestyle: UDateFormatStyle, locale: P0, tzid: *const u16, tzidlength: i32, pattern: *const u16, patternlength: i32, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_open ( timestyle : UDateFormatStyle , datestyle : UDateFormatStyle , locale : :: windows::core::PCSTR , tzid : *const u16 , tzidlength : i32 , pattern : *const u16 , patternlength : i32 , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    udat_open(timestyle, datestyle, locale.into_param().abi(), tzid, tzidlength, pattern, patternlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_parse(format: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_parse ( format : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> f64 );
    udat_parse(format, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_parseCalendar(format: *const *const ::core::ffi::c_void, calendar: *mut *mut ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_parseCalendar ( format : *const *const ::core::ffi::c_void , calendar : *mut *mut ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> ( ) );
    udat_parseCalendar(format, calendar, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_set2DigitYearStart(fmt: *mut *mut ::core::ffi::c_void, d: f64, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_set2DigitYearStart ( fmt : *mut *mut ::core::ffi::c_void , d : f64 , status : *mut UErrorCode ) -> ( ) );
    udat_set2DigitYearStart(fmt, d, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setBooleanAttribute(fmt: *mut *mut ::core::ffi::c_void, attr: UDateFormatBooleanAttribute, newvalue: i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setBooleanAttribute ( fmt : *mut *mut ::core::ffi::c_void , attr : UDateFormatBooleanAttribute , newvalue : i8 , status : *mut UErrorCode ) -> ( ) );
    udat_setBooleanAttribute(fmt, attr, newvalue, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setCalendar(fmt: *mut *mut ::core::ffi::c_void, calendartoset: *const *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setCalendar ( fmt : *mut *mut ::core::ffi::c_void , calendartoset : *const *const ::core::ffi::c_void ) -> ( ) );
    udat_setCalendar(fmt, calendartoset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setContext(fmt: *mut *mut ::core::ffi::c_void, value: UDisplayContext, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setContext ( fmt : *mut *mut ::core::ffi::c_void , value : UDisplayContext , status : *mut UErrorCode ) -> ( ) );
    udat_setContext(fmt, value, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setLenient(fmt: *mut *mut ::core::ffi::c_void, islenient: i8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setLenient ( fmt : *mut *mut ::core::ffi::c_void , islenient : i8 ) -> ( ) );
    udat_setLenient(fmt, islenient)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setNumberFormat(fmt: *mut *mut ::core::ffi::c_void, numberformattoset: *const *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setNumberFormat ( fmt : *mut *mut ::core::ffi::c_void , numberformattoset : *const *const ::core::ffi::c_void ) -> ( ) );
    udat_setNumberFormat(fmt, numberformattoset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_setSymbols(format: *mut *mut ::core::ffi::c_void, r#type: UDateFormatSymbolType, symbolindex: i32, value: *mut u16, valuelength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_setSymbols ( format : *mut *mut ::core::ffi::c_void , r#type : UDateFormatSymbolType , symbolindex : i32 , value : *mut u16 , valuelength : i32 , status : *mut UErrorCode ) -> ( ) );
    udat_setSymbols(format, r#type, symbolindex, value, valuelength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_toCalendarDateField(field: UDateFormatField) -> UCalendarDateFields {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_toCalendarDateField ( field : UDateFormatField ) -> UCalendarDateFields );
    udat_toCalendarDateField(field)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udat_toPattern(fmt: *const *const ::core::ffi::c_void, localized: i8, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udat_toPattern ( fmt : *const *const ::core::ffi::c_void , localized : i8 , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    udat_toPattern(fmt, localized, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_addPattern(dtpg: *mut *mut ::core::ffi::c_void, pattern: *const u16, patternlength: i32, r#override: i8, conflictingpattern: *mut u16, capacity: i32, plength: *mut i32, perrorcode: *mut UErrorCode) -> UDateTimePatternConflict {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_addPattern ( dtpg : *mut *mut ::core::ffi::c_void , pattern : *const u16 , patternlength : i32 , r#override : i8 , conflictingpattern : *mut u16 , capacity : i32 , plength : *mut i32 , perrorcode : *mut UErrorCode ) -> UDateTimePatternConflict );
    udatpg_addPattern(dtpg, pattern, patternlength, r#override, conflictingpattern, capacity, plength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_clone(dtpg: *const *const ::core::ffi::c_void, perrorcode: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_clone ( dtpg : *const *const ::core::ffi::c_void , perrorcode : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    udatpg_clone(dtpg, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_close(dtpg: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_close ( dtpg : *mut *mut ::core::ffi::c_void ) -> ( ) );
    udatpg_close(dtpg)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getAppendItemFormat(dtpg: *const *const ::core::ffi::c_void, field: UDateTimePatternField, plength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getAppendItemFormat ( dtpg : *const *const ::core::ffi::c_void , field : UDateTimePatternField , plength : *mut i32 ) -> *mut u16 );
    udatpg_getAppendItemFormat(dtpg, field, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getAppendItemName(dtpg: *const *const ::core::ffi::c_void, field: UDateTimePatternField, plength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getAppendItemName ( dtpg : *const *const ::core::ffi::c_void , field : UDateTimePatternField , plength : *mut i32 ) -> *mut u16 );
    udatpg_getAppendItemName(dtpg, field, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getBaseSkeleton(unuseddtpg: *mut *mut ::core::ffi::c_void, pattern: *const u16, length: i32, baseskeleton: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getBaseSkeleton ( unuseddtpg : *mut *mut ::core::ffi::c_void , pattern : *const u16 , length : i32 , baseskeleton : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_getBaseSkeleton(unuseddtpg, pattern, length, baseskeleton, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getBestPattern(dtpg: *mut *mut ::core::ffi::c_void, skeleton: *const u16, length: i32, bestpattern: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getBestPattern ( dtpg : *mut *mut ::core::ffi::c_void , skeleton : *const u16 , length : i32 , bestpattern : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_getBestPattern(dtpg, skeleton, length, bestpattern, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getBestPatternWithOptions(dtpg: *mut *mut ::core::ffi::c_void, skeleton: *const u16, length: i32, options: UDateTimePatternMatchOptions, bestpattern: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getBestPatternWithOptions ( dtpg : *mut *mut ::core::ffi::c_void , skeleton : *const u16 , length : i32 , options : UDateTimePatternMatchOptions , bestpattern : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_getBestPatternWithOptions(dtpg, skeleton, length, options, bestpattern, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getDateTimeFormat(dtpg: *const *const ::core::ffi::c_void, plength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getDateTimeFormat ( dtpg : *const *const ::core::ffi::c_void , plength : *mut i32 ) -> *mut u16 );
    udatpg_getDateTimeFormat(dtpg, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getDecimal(dtpg: *const *const ::core::ffi::c_void, plength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getDecimal ( dtpg : *const *const ::core::ffi::c_void , plength : *mut i32 ) -> *mut u16 );
    udatpg_getDecimal(dtpg, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getFieldDisplayName(dtpg: *const *const ::core::ffi::c_void, field: UDateTimePatternField, width: UDateTimePGDisplayWidth, fieldname: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getFieldDisplayName ( dtpg : *const *const ::core::ffi::c_void , field : UDateTimePatternField , width : UDateTimePGDisplayWidth , fieldname : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_getFieldDisplayName(dtpg, field, width, fieldname, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getPatternForSkeleton(dtpg: *const *const ::core::ffi::c_void, skeleton: *const u16, skeletonlength: i32, plength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getPatternForSkeleton ( dtpg : *const *const ::core::ffi::c_void , skeleton : *const u16 , skeletonlength : i32 , plength : *mut i32 ) -> *mut u16 );
    udatpg_getPatternForSkeleton(dtpg, skeleton, skeletonlength, plength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_getSkeleton(unuseddtpg: *mut *mut ::core::ffi::c_void, pattern: *const u16, length: i32, skeleton: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_getSkeleton ( unuseddtpg : *mut *mut ::core::ffi::c_void , pattern : *const u16 , length : i32 , skeleton : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_getSkeleton(unuseddtpg, pattern, length, skeleton, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_open<P0>(locale: P0, perrorcode: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_open ( locale : :: windows::core::PCSTR , perrorcode : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    udatpg_open(locale.into_param().abi(), perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_openBaseSkeletons(dtpg: *const *const ::core::ffi::c_void, perrorcode: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_openBaseSkeletons ( dtpg : *const *const ::core::ffi::c_void , perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    udatpg_openBaseSkeletons(dtpg, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_openEmpty(perrorcode: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_openEmpty ( perrorcode : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    udatpg_openEmpty(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_openSkeletons(dtpg: *const *const ::core::ffi::c_void, perrorcode: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_openSkeletons ( dtpg : *const *const ::core::ffi::c_void , perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    udatpg_openSkeletons(dtpg, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_replaceFieldTypes(dtpg: *mut *mut ::core::ffi::c_void, pattern: *const u16, patternlength: i32, skeleton: *const u16, skeletonlength: i32, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_replaceFieldTypes ( dtpg : *mut *mut ::core::ffi::c_void , pattern : *const u16 , patternlength : i32 , skeleton : *const u16 , skeletonlength : i32 , dest : *mut u16 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_replaceFieldTypes(dtpg, pattern, patternlength, skeleton, skeletonlength, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_replaceFieldTypesWithOptions(dtpg: *mut *mut ::core::ffi::c_void, pattern: *const u16, patternlength: i32, skeleton: *const u16, skeletonlength: i32, options: UDateTimePatternMatchOptions, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_replaceFieldTypesWithOptions ( dtpg : *mut *mut ::core::ffi::c_void , pattern : *const u16 , patternlength : i32 , skeleton : *const u16 , skeletonlength : i32 , options : UDateTimePatternMatchOptions , dest : *mut u16 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    udatpg_replaceFieldTypesWithOptions(dtpg, pattern, patternlength, skeleton, skeletonlength, options, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_setAppendItemFormat(dtpg: *mut *mut ::core::ffi::c_void, field: UDateTimePatternField, value: *const u16, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_setAppendItemFormat ( dtpg : *mut *mut ::core::ffi::c_void , field : UDateTimePatternField , value : *const u16 , length : i32 ) -> ( ) );
    udatpg_setAppendItemFormat(dtpg, field, value, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_setAppendItemName(dtpg: *mut *mut ::core::ffi::c_void, field: UDateTimePatternField, value: *const u16, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_setAppendItemName ( dtpg : *mut *mut ::core::ffi::c_void , field : UDateTimePatternField , value : *const u16 , length : i32 ) -> ( ) );
    udatpg_setAppendItemName(dtpg, field, value, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_setDateTimeFormat(dtpg: *const *const ::core::ffi::c_void, dtformat: *const u16, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_setDateTimeFormat ( dtpg : *const *const ::core::ffi::c_void , dtformat : *const u16 , length : i32 ) -> ( ) );
    udatpg_setDateTimeFormat(dtpg, dtformat, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udatpg_setDecimal(dtpg: *mut *mut ::core::ffi::c_void, decimal: *const u16, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udatpg_setDecimal ( dtpg : *mut *mut ::core::ffi::c_void , decimal : *const u16 , length : i32 ) -> ( ) );
    udatpg_setDecimal(dtpg, decimal, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_close(formatter: *mut UDateIntervalFormat) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_close ( formatter : *mut UDateIntervalFormat ) -> ( ) );
    udtitvfmt_close(formatter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_closeResult(uresult: *mut UFormattedDateInterval) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_closeResult ( uresult : *mut UFormattedDateInterval ) -> ( ) );
    udtitvfmt_closeResult(uresult)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_format(formatter: *const UDateIntervalFormat, fromdate: f64, todate: f64, result: *mut u16, resultcapacity: i32, position: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_format ( formatter : *const UDateIntervalFormat , fromdate : f64 , todate : f64 , result : *mut u16 , resultcapacity : i32 , position : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    udtitvfmt_format(formatter, fromdate, todate, result, resultcapacity, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_open<P0>(locale: P0, skeleton: *const u16, skeletonlength: i32, tzid: *const u16, tzidlength: i32, status: *mut UErrorCode) -> *mut UDateIntervalFormat
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_open ( locale : :: windows::core::PCSTR , skeleton : *const u16 , skeletonlength : i32 , tzid : *const u16 , tzidlength : i32 , status : *mut UErrorCode ) -> *mut UDateIntervalFormat );
    udtitvfmt_open(locale.into_param().abi(), skeleton, skeletonlength, tzid, tzidlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_openResult(ec: *mut UErrorCode) -> *mut UFormattedDateInterval {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_openResult ( ec : *mut UErrorCode ) -> *mut UFormattedDateInterval );
    udtitvfmt_openResult(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn udtitvfmt_resultAsValue(uresult: *const UFormattedDateInterval, ec: *mut UErrorCode) -> *mut UFormattedValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn udtitvfmt_resultAsValue ( uresult : *const UFormattedDateInterval , ec : *mut UErrorCode ) -> *mut UFormattedValue );
    udtitvfmt_resultAsValue(uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_close(en: *mut UEnumeration) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_close ( en : *mut UEnumeration ) -> ( ) );
    uenum_close(en)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_count(en: *mut UEnumeration, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_count ( en : *mut UEnumeration , status : *mut UErrorCode ) -> i32 );
    uenum_count(en, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_next(en: *mut UEnumeration, resultlength: *mut i32, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_next ( en : *mut UEnumeration , resultlength : *mut i32 , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    uenum_next(en, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_openCharStringsEnumeration(strings: *const *const i8, count: i32, ec: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_openCharStringsEnumeration ( strings : *const *const i8 , count : i32 , ec : *mut UErrorCode ) -> *mut UEnumeration );
    uenum_openCharStringsEnumeration(strings, count, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_openUCharStringsEnumeration(strings: *const *const u16, count: i32, ec: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_openUCharStringsEnumeration ( strings : *const *const u16 , count : i32 , ec : *mut UErrorCode ) -> *mut UEnumeration );
    uenum_openUCharStringsEnumeration(strings, count, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_reset(en: *mut UEnumeration, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_reset ( en : *mut UEnumeration , status : *mut UErrorCode ) -> ( ) );
    uenum_reset(en, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uenum_unext(en: *mut UEnumeration, resultlength: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uenum_unext ( en : *mut UEnumeration , resultlength : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    uenum_unext(en, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufieldpositer_close(fpositer: *mut UFieldPositionIterator) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufieldpositer_close ( fpositer : *mut UFieldPositionIterator ) -> ( ) );
    ufieldpositer_close(fpositer)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufieldpositer_next(fpositer: *mut UFieldPositionIterator, beginindex: *mut i32, endindex: *mut i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufieldpositer_next ( fpositer : *mut UFieldPositionIterator , beginindex : *mut i32 , endindex : *mut i32 ) -> i32 );
    ufieldpositer_next(fpositer, beginindex, endindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufieldpositer_open(status: *mut UErrorCode) -> *mut UFieldPositionIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufieldpositer_open ( status : *mut UErrorCode ) -> *mut UFieldPositionIterator );
    ufieldpositer_open(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_close(fmt: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_close ( fmt : *mut *mut ::core::ffi::c_void ) -> ( ) );
    ufmt_close(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getArrayItemByIndex(fmt: *mut *mut ::core::ffi::c_void, n: i32, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getArrayItemByIndex ( fmt : *mut *mut ::core::ffi::c_void , n : i32 , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    ufmt_getArrayItemByIndex(fmt, n, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getArrayLength(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getArrayLength ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> i32 );
    ufmt_getArrayLength(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getDate(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getDate ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> f64 );
    ufmt_getDate(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getDecNumChars(fmt: *mut *mut ::core::ffi::c_void, len: *mut i32, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getDecNumChars ( fmt : *mut *mut ::core::ffi::c_void , len : *mut i32 , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ufmt_getDecNumChars(fmt, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getDouble(fmt: *mut *mut ::core::ffi::c_void, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getDouble ( fmt : *mut *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> f64 );
    ufmt_getDouble(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getInt64(fmt: *mut *mut ::core::ffi::c_void, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getInt64 ( fmt : *mut *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> i64 );
    ufmt_getInt64(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getLong(fmt: *mut *mut ::core::ffi::c_void, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getLong ( fmt : *mut *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> i32 );
    ufmt_getLong(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getObject(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getObject ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut ::core::ffi::c_void );
    ufmt_getObject(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getType(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> UFormattableType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getType ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> UFormattableType );
    ufmt_getType(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_getUChars(fmt: *mut *mut ::core::ffi::c_void, len: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_getUChars ( fmt : *mut *mut ::core::ffi::c_void , len : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    ufmt_getUChars(fmt, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_isNumeric(fmt: *const *const ::core::ffi::c_void) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_isNumeric ( fmt : *const *const ::core::ffi::c_void ) -> i8 );
    ufmt_isNumeric(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmt_open(status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmt_open ( status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    ufmt_open(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmtval_getString(ufmtval: *const UFormattedValue, plength: *mut i32, ec: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmtval_getString ( ufmtval : *const UFormattedValue , plength : *mut i32 , ec : *mut UErrorCode ) -> *mut u16 );
    ufmtval_getString(ufmtval, plength, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ufmtval_nextPosition(ufmtval: *const UFormattedValue, ucfpos: *mut UConstrainedFieldPosition, ec: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ufmtval_nextPosition ( ufmtval : *const UFormattedValue , ucfpos : *mut UConstrainedFieldPosition , ec : *mut UErrorCode ) -> i8 );
    ufmtval_nextPosition(ufmtval, ucfpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ugender_getInstance<P0>(locale: P0, status: *mut UErrorCode) -> *mut UGenderInfo
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ugender_getInstance ( locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UGenderInfo );
    ugender_getInstance(locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ugender_getListGender(genderinfo: *const UGenderInfo, genders: *const UGender, size: i32, status: *mut UErrorCode) -> UGender {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ugender_getListGender ( genderinfo : *const UGenderInfo , genders : *const UGender , size : i32 , status : *mut UErrorCode ) -> UGender );
    ugender_getListGender(genderinfo, genders, size, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_close(idna: *mut UIDNA) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_close ( idna : *mut UIDNA ) -> ( ) );
    uidna_close(idna)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_labelToASCII(idna: *const UIDNA, label: *const u16, length: i32, dest: *mut u16, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_labelToASCII ( idna : *const UIDNA , label : *const u16 , length : i32 , dest : *mut u16 , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_labelToASCII(idna, label, length, dest, capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_labelToASCII_UTF8<P0, P1>(idna: *const UIDNA, label: P0, length: i32, dest: P1, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_labelToASCII_UTF8 ( idna : *const UIDNA , label : :: windows::core::PCSTR , length : i32 , dest : :: windows::core::PCSTR , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_labelToASCII_UTF8(idna, label.into_param().abi(), length, dest.into_param().abi(), capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_labelToUnicode(idna: *const UIDNA, label: *const u16, length: i32, dest: *mut u16, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_labelToUnicode ( idna : *const UIDNA , label : *const u16 , length : i32 , dest : *mut u16 , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_labelToUnicode(idna, label, length, dest, capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_labelToUnicodeUTF8<P0, P1>(idna: *const UIDNA, label: P0, length: i32, dest: P1, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_labelToUnicodeUTF8 ( idna : *const UIDNA , label : :: windows::core::PCSTR , length : i32 , dest : :: windows::core::PCSTR , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_labelToUnicodeUTF8(idna, label.into_param().abi(), length, dest.into_param().abi(), capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_nameToASCII(idna: *const UIDNA, name: *const u16, length: i32, dest: *mut u16, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_nameToASCII ( idna : *const UIDNA , name : *const u16 , length : i32 , dest : *mut u16 , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_nameToASCII(idna, name, length, dest, capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_nameToASCII_UTF8<P0, P1>(idna: *const UIDNA, name: P0, length: i32, dest: P1, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_nameToASCII_UTF8 ( idna : *const UIDNA , name : :: windows::core::PCSTR , length : i32 , dest : :: windows::core::PCSTR , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_nameToASCII_UTF8(idna, name.into_param().abi(), length, dest.into_param().abi(), capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_nameToUnicode(idna: *const UIDNA, name: *const u16, length: i32, dest: *mut u16, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_nameToUnicode ( idna : *const UIDNA , name : *const u16 , length : i32 , dest : *mut u16 , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_nameToUnicode(idna, name, length, dest, capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_nameToUnicodeUTF8<P0, P1>(idna: *const UIDNA, name: P0, length: i32, dest: P1, capacity: i32, pinfo: *mut UIDNAInfo, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_nameToUnicodeUTF8 ( idna : *const UIDNA , name : :: windows::core::PCSTR , length : i32 , dest : :: windows::core::PCSTR , capacity : i32 , pinfo : *mut UIDNAInfo , perrorcode : *mut UErrorCode ) -> i32 );
    uidna_nameToUnicodeUTF8(idna, name.into_param().abi(), length, dest.into_param().abi(), capacity, pinfo, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uidna_openUTS46(options: u32, perrorcode: *mut UErrorCode) -> *mut UIDNA {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uidna_openUTS46 ( options : u32 , perrorcode : *mut UErrorCode ) -> *mut UIDNA );
    uidna_openUTS46(options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_current32(iter: *mut UCharIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_current32 ( iter : *mut UCharIterator ) -> i32 );
    uiter_current32(iter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_getState(iter: *const UCharIterator) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_getState ( iter : *const UCharIterator ) -> u32 );
    uiter_getState(iter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_next32(iter: *mut UCharIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_next32 ( iter : *mut UCharIterator ) -> i32 );
    uiter_next32(iter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_previous32(iter: *mut UCharIterator) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_previous32 ( iter : *mut UCharIterator ) -> i32 );
    uiter_previous32(iter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_setState(iter: *mut UCharIterator, state: u32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_setState ( iter : *mut UCharIterator , state : u32 , perrorcode : *mut UErrorCode ) -> ( ) );
    uiter_setState(iter, state, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_setString(iter: *mut UCharIterator, s: *const u16, length: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_setString ( iter : *mut UCharIterator , s : *const u16 , length : i32 ) -> ( ) );
    uiter_setString(iter, s, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_setUTF16BE<P0>(iter: *mut UCharIterator, s: P0, length: i32)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_setUTF16BE ( iter : *mut UCharIterator , s : :: windows::core::PCSTR , length : i32 ) -> ( ) );
    uiter_setUTF16BE(iter, s.into_param().abi(), length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uiter_setUTF8<P0>(iter: *mut UCharIterator, s: P0, length: i32)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uiter_setUTF8 ( iter : *mut UCharIterator , s : :: windows::core::PCSTR , length : i32 ) -> ( ) );
    uiter_setUTF8(iter, s.into_param().abi(), length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_close(ldn: *mut ULocaleDisplayNames) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_close ( ldn : *mut ULocaleDisplayNames ) -> ( ) );
    uldn_close(ldn)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_getContext(ldn: *const ULocaleDisplayNames, r#type: UDisplayContextType, perrorcode: *mut UErrorCode) -> UDisplayContext {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_getContext ( ldn : *const ULocaleDisplayNames , r#type : UDisplayContextType , perrorcode : *mut UErrorCode ) -> UDisplayContext );
    uldn_getContext(ldn, r#type, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_getDialectHandling(ldn: *const ULocaleDisplayNames) -> UDialectHandling {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_getDialectHandling ( ldn : *const ULocaleDisplayNames ) -> UDialectHandling );
    uldn_getDialectHandling(ldn)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_getLocale(ldn: *const ULocaleDisplayNames) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_getLocale ( ldn : *const ULocaleDisplayNames ) -> :: windows::core::PSTR );
    uldn_getLocale(ldn)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_keyDisplayName<P0>(ldn: *const ULocaleDisplayNames, key: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_keyDisplayName ( ldn : *const ULocaleDisplayNames , key : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_keyDisplayName(ldn, key.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_keyValueDisplayName<P0, P1>(ldn: *const ULocaleDisplayNames, key: P0, value: P1, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_keyValueDisplayName ( ldn : *const ULocaleDisplayNames , key : :: windows::core::PCSTR , value : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_keyValueDisplayName(ldn, key.into_param().abi(), value.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_languageDisplayName<P0>(ldn: *const ULocaleDisplayNames, lang: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_languageDisplayName ( ldn : *const ULocaleDisplayNames , lang : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_languageDisplayName(ldn, lang.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_localeDisplayName<P0>(ldn: *const ULocaleDisplayNames, locale: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_localeDisplayName ( ldn : *const ULocaleDisplayNames , locale : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_localeDisplayName(ldn, locale.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_open<P0>(locale: P0, dialecthandling: UDialectHandling, perrorcode: *mut UErrorCode) -> *mut ULocaleDisplayNames
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_open ( locale : :: windows::core::PCSTR , dialecthandling : UDialectHandling , perrorcode : *mut UErrorCode ) -> *mut ULocaleDisplayNames );
    uldn_open(locale.into_param().abi(), dialecthandling, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_openForContext<P0>(locale: P0, contexts: *mut UDisplayContext, length: i32, perrorcode: *mut UErrorCode) -> *mut ULocaleDisplayNames
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_openForContext ( locale : :: windows::core::PCSTR , contexts : *mut UDisplayContext , length : i32 , perrorcode : *mut UErrorCode ) -> *mut ULocaleDisplayNames );
    uldn_openForContext(locale.into_param().abi(), contexts, length, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_regionDisplayName<P0>(ldn: *const ULocaleDisplayNames, region: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_regionDisplayName ( ldn : *const ULocaleDisplayNames , region : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_regionDisplayName(ldn, region.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_scriptCodeDisplayName(ldn: *const ULocaleDisplayNames, scriptcode: UScriptCode, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_scriptCodeDisplayName ( ldn : *const ULocaleDisplayNames , scriptcode : UScriptCode , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_scriptCodeDisplayName(ldn, scriptcode, result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_scriptDisplayName<P0>(ldn: *const ULocaleDisplayNames, script: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_scriptDisplayName ( ldn : *const ULocaleDisplayNames , script : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_scriptDisplayName(ldn, script.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uldn_variantDisplayName<P0>(ldn: *const ULocaleDisplayNames, variant: P0, result: *mut u16, maxresultsize: i32, perrorcode: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uldn_variantDisplayName ( ldn : *const ULocaleDisplayNames , variant : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uldn_variantDisplayName(ldn, variant.into_param().abi(), result, maxresultsize, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_close(listfmt: *mut UListFormatter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_close ( listfmt : *mut UListFormatter ) -> ( ) );
    ulistfmt_close(listfmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_closeResult(uresult: *mut UFormattedList) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_closeResult ( uresult : *mut UFormattedList ) -> ( ) );
    ulistfmt_closeResult(uresult)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_format(listfmt: *const UListFormatter, strings: *const *const u16, stringlengths: *const i32, stringcount: i32, result: *mut u16, resultcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_format ( listfmt : *const UListFormatter , strings : *const *const u16 , stringlengths : *const i32 , stringcount : i32 , result : *mut u16 , resultcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ulistfmt_format(listfmt, strings, stringlengths, stringcount, result, resultcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_formatStringsToResult(listfmt: *const UListFormatter, strings: *const *const u16, stringlengths: *const i32, stringcount: i32, uresult: *mut UFormattedList, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_formatStringsToResult ( listfmt : *const UListFormatter , strings : *const *const u16 , stringlengths : *const i32 , stringcount : i32 , uresult : *mut UFormattedList , status : *mut UErrorCode ) -> ( ) );
    ulistfmt_formatStringsToResult(listfmt, strings, stringlengths, stringcount, uresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_open<P0>(locale: P0, status: *mut UErrorCode) -> *mut UListFormatter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_open ( locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UListFormatter );
    ulistfmt_open(locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_openForType<P0>(locale: P0, r#type: UListFormatterType, width: UListFormatterWidth, status: *mut UErrorCode) -> *mut UListFormatter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_openForType ( locale : :: windows::core::PCSTR , r#type : UListFormatterType , width : UListFormatterWidth , status : *mut UErrorCode ) -> *mut UListFormatter );
    ulistfmt_openForType(locale.into_param().abi(), r#type, width, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_openResult(ec: *mut UErrorCode) -> *mut UFormattedList {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_openResult ( ec : *mut UErrorCode ) -> *mut UFormattedList );
    ulistfmt_openResult(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulistfmt_resultAsValue(uresult: *const UFormattedList, ec: *mut UErrorCode) -> *mut UFormattedValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulistfmt_resultAsValue ( uresult : *const UFormattedList , ec : *mut UErrorCode ) -> *mut UFormattedValue );
    ulistfmt_resultAsValue(uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_acceptLanguage<P0>(result: P0, resultavailable: i32, outresult: *mut UAcceptResult, acceptlist: *const *const i8, acceptlistcount: i32, availablelocales: *mut UEnumeration, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_acceptLanguage ( result : :: windows::core::PCSTR , resultavailable : i32 , outresult : *mut UAcceptResult , acceptlist : *const *const i8 , acceptlistcount : i32 , availablelocales : *mut UEnumeration , status : *mut UErrorCode ) -> i32 );
    uloc_acceptLanguage(result.into_param().abi(), resultavailable, outresult, acceptlist, acceptlistcount, availablelocales, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_acceptLanguageFromHTTP<P0, P1>(result: P0, resultavailable: i32, outresult: *mut UAcceptResult, httpacceptlanguage: P1, availablelocales: *mut UEnumeration, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_acceptLanguageFromHTTP ( result : :: windows::core::PCSTR , resultavailable : i32 , outresult : *mut UAcceptResult , httpacceptlanguage : :: windows::core::PCSTR , availablelocales : *mut UEnumeration , status : *mut UErrorCode ) -> i32 );
    uloc_acceptLanguageFromHTTP(result.into_param().abi(), resultavailable, outresult, httpacceptlanguage.into_param().abi(), availablelocales, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_addLikelySubtags<P0, P1>(localeid: P0, maximizedlocaleid: P1, maximizedlocaleidcapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_addLikelySubtags ( localeid : :: windows::core::PCSTR , maximizedlocaleid : :: windows::core::PCSTR , maximizedlocaleidcapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_addLikelySubtags(localeid.into_param().abi(), maximizedlocaleid.into_param().abi(), maximizedlocaleidcapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_canonicalize<P0, P1>(localeid: P0, name: P1, namecapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_canonicalize ( localeid : :: windows::core::PCSTR , name : :: windows::core::PCSTR , namecapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_canonicalize(localeid.into_param().abi(), name.into_param().abi(), namecapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_countAvailable ( ) -> i32 );
    uloc_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_forLanguageTag<P0, P1>(langtag: P0, localeid: P1, localeidcapacity: i32, parsedlength: *mut i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_forLanguageTag ( langtag : :: windows::core::PCSTR , localeid : :: windows::core::PCSTR , localeidcapacity : i32 , parsedlength : *mut i32 , err : *mut UErrorCode ) -> i32 );
    uloc_forLanguageTag(langtag.into_param().abi(), localeid.into_param().abi(), localeidcapacity, parsedlength, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getAvailable(n: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getAvailable ( n : i32 ) -> :: windows::core::PSTR );
    uloc_getAvailable(n)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getBaseName<P0, P1>(localeid: P0, name: P1, namecapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getBaseName ( localeid : :: windows::core::PCSTR , name : :: windows::core::PCSTR , namecapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getBaseName(localeid.into_param().abi(), name.into_param().abi(), namecapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getCharacterOrientation<P0>(localeid: P0, status: *mut UErrorCode) -> ULayoutType
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getCharacterOrientation ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> ULayoutType );
    uloc_getCharacterOrientation(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getCountry<P0, P1>(localeid: P0, country: P1, countrycapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getCountry ( localeid : :: windows::core::PCSTR , country : :: windows::core::PCSTR , countrycapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getCountry(localeid.into_param().abi(), country.into_param().abi(), countrycapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDefault() -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDefault ( ) -> :: windows::core::PSTR );
    uloc_getDefault()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayCountry<P0, P1>(locale: P0, displaylocale: P1, country: *mut u16, countrycapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayCountry ( locale : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , country : *mut u16 , countrycapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayCountry(locale.into_param().abi(), displaylocale.into_param().abi(), country, countrycapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayKeyword<P0, P1>(keyword: P0, displaylocale: P1, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayKeyword ( keyword : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , dest : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayKeyword(keyword.into_param().abi(), displaylocale.into_param().abi(), dest, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayKeywordValue<P0, P1, P2>(locale: P0, keyword: P1, displaylocale: P2, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayKeywordValue ( locale : :: windows::core::PCSTR , keyword : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , dest : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayKeywordValue(locale.into_param().abi(), keyword.into_param().abi(), displaylocale.into_param().abi(), dest, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayLanguage<P0, P1>(locale: P0, displaylocale: P1, language: *mut u16, languagecapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayLanguage ( locale : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , language : *mut u16 , languagecapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayLanguage(locale.into_param().abi(), displaylocale.into_param().abi(), language, languagecapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayName<P0, P1>(localeid: P0, inlocaleid: P1, result: *mut u16, maxresultsize: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayName ( localeid : :: windows::core::PCSTR , inlocaleid : :: windows::core::PCSTR , result : *mut u16 , maxresultsize : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getDisplayName(localeid.into_param().abi(), inlocaleid.into_param().abi(), result, maxresultsize, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayScript<P0, P1>(locale: P0, displaylocale: P1, script: *mut u16, scriptcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayScript ( locale : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , script : *mut u16 , scriptcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayScript(locale.into_param().abi(), displaylocale.into_param().abi(), script, scriptcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getDisplayVariant<P0, P1>(locale: P0, displaylocale: P1, variant: *mut u16, variantcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getDisplayVariant ( locale : :: windows::core::PCSTR , displaylocale : :: windows::core::PCSTR , variant : *mut u16 , variantcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getDisplayVariant(locale.into_param().abi(), displaylocale.into_param().abi(), variant, variantcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getISO3Country<P0>(localeid: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getISO3Country ( localeid : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_getISO3Country(localeid.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getISO3Language<P0>(localeid: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getISO3Language ( localeid : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_getISO3Language(localeid.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getISOCountries() -> *mut *mut i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getISOCountries ( ) -> *mut *mut i8 );
    uloc_getISOCountries()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getISOLanguages() -> *mut *mut i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getISOLanguages ( ) -> *mut *mut i8 );
    uloc_getISOLanguages()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getKeywordValue<P0, P1, P2>(localeid: P0, keywordname: P1, buffer: P2, buffercapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getKeywordValue ( localeid : :: windows::core::PCSTR , keywordname : :: windows::core::PCSTR , buffer : :: windows::core::PCSTR , buffercapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getKeywordValue(localeid.into_param().abi(), keywordname.into_param().abi(), buffer.into_param().abi(), buffercapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getLCID<P0>(localeid: P0) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getLCID ( localeid : :: windows::core::PCSTR ) -> u32 );
    uloc_getLCID(localeid.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getLanguage<P0, P1>(localeid: P0, language: P1, languagecapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getLanguage ( localeid : :: windows::core::PCSTR , language : :: windows::core::PCSTR , languagecapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getLanguage(localeid.into_param().abi(), language.into_param().abi(), languagecapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getLineOrientation<P0>(localeid: P0, status: *mut UErrorCode) -> ULayoutType
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getLineOrientation ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> ULayoutType );
    uloc_getLineOrientation(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getLocaleForLCID<P0>(hostid: u32, locale: P0, localecapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getLocaleForLCID ( hostid : u32 , locale : :: windows::core::PCSTR , localecapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_getLocaleForLCID(hostid, locale.into_param().abi(), localecapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getName<P0, P1>(localeid: P0, name: P1, namecapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getName ( localeid : :: windows::core::PCSTR , name : :: windows::core::PCSTR , namecapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getName(localeid.into_param().abi(), name.into_param().abi(), namecapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getParent<P0, P1>(localeid: P0, parent: P1, parentcapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getParent ( localeid : :: windows::core::PCSTR , parent : :: windows::core::PCSTR , parentcapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getParent(localeid.into_param().abi(), parent.into_param().abi(), parentcapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getScript<P0, P1>(localeid: P0, script: P1, scriptcapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getScript ( localeid : :: windows::core::PCSTR , script : :: windows::core::PCSTR , scriptcapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getScript(localeid.into_param().abi(), script.into_param().abi(), scriptcapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_getVariant<P0, P1>(localeid: P0, variant: P1, variantcapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_getVariant ( localeid : :: windows::core::PCSTR , variant : :: windows::core::PCSTR , variantcapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_getVariant(localeid.into_param().abi(), variant.into_param().abi(), variantcapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_isRightToLeft<P0>(locale: P0) -> i8
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_isRightToLeft ( locale : :: windows::core::PCSTR ) -> i8 );
    uloc_isRightToLeft(locale.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_minimizeSubtags<P0, P1>(localeid: P0, minimizedlocaleid: P1, minimizedlocaleidcapacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_minimizeSubtags ( localeid : :: windows::core::PCSTR , minimizedlocaleid : :: windows::core::PCSTR , minimizedlocaleidcapacity : i32 , err : *mut UErrorCode ) -> i32 );
    uloc_minimizeSubtags(localeid.into_param().abi(), minimizedlocaleid.into_param().abi(), minimizedlocaleidcapacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_openAvailableByType(r#type: ULocAvailableType, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_openAvailableByType ( r#type : ULocAvailableType , status : *mut UErrorCode ) -> *mut UEnumeration );
    uloc_openAvailableByType(r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_openKeywords<P0>(localeid: P0, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_openKeywords ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UEnumeration );
    uloc_openKeywords(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_setDefault<P0>(localeid: P0, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_setDefault ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> ( ) );
    uloc_setDefault(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_setKeywordValue<P0, P1, P2>(keywordname: P0, keywordvalue: P1, buffer: P2, buffercapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_setKeywordValue ( keywordname : :: windows::core::PCSTR , keywordvalue : :: windows::core::PCSTR , buffer : :: windows::core::PCSTR , buffercapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uloc_setKeywordValue(keywordname.into_param().abi(), keywordvalue.into_param().abi(), buffer.into_param().abi(), buffercapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_toLanguageTag<P0, P1>(localeid: P0, langtag: P1, langtagcapacity: i32, strict: i8, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_toLanguageTag ( localeid : :: windows::core::PCSTR , langtag : :: windows::core::PCSTR , langtagcapacity : i32 , strict : i8 , err : *mut UErrorCode ) -> i32 );
    uloc_toLanguageTag(localeid.into_param().abi(), langtag.into_param().abi(), langtagcapacity, strict, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_toLegacyKey<P0>(keyword: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_toLegacyKey ( keyword : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_toLegacyKey(keyword.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_toLegacyType<P0, P1>(keyword: P0, value: P1) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_toLegacyType ( keyword : :: windows::core::PCSTR , value : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_toLegacyType(keyword.into_param().abi(), value.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_toUnicodeLocaleKey<P0>(keyword: P0) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_toUnicodeLocaleKey ( keyword : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_toUnicodeLocaleKey(keyword.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uloc_toUnicodeLocaleType<P0, P1>(keyword: P0, value: P1) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uloc_toUnicodeLocaleType ( keyword : :: windows::core::PCSTR , value : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    uloc_toUnicodeLocaleType(keyword.into_param().abi(), value.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_close(uld: *mut ULocaleData) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_close ( uld : *mut ULocaleData ) -> ( ) );
    ulocdata_close(uld)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getCLDRVersion(versionarray: *mut u8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getCLDRVersion ( versionarray : *mut u8 , status : *mut UErrorCode ) -> ( ) );
    ulocdata_getCLDRVersion(versionarray, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getDelimiter(uld: *mut ULocaleData, r#type: ULocaleDataDelimiterType, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getDelimiter ( uld : *mut ULocaleData , r#type : ULocaleDataDelimiterType , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    ulocdata_getDelimiter(uld, r#type, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getExemplarSet(uld: *mut ULocaleData, fillin: *mut USet, options: u32, extype: ULocaleDataExemplarSetType, status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getExemplarSet ( uld : *mut ULocaleData , fillin : *mut USet , options : u32 , extype : ULocaleDataExemplarSetType , status : *mut UErrorCode ) -> *mut USet );
    ulocdata_getExemplarSet(uld, fillin, options, extype, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getLocaleDisplayPattern(uld: *mut ULocaleData, pattern: *mut u16, patterncapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getLocaleDisplayPattern ( uld : *mut ULocaleData , pattern : *mut u16 , patterncapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ulocdata_getLocaleDisplayPattern(uld, pattern, patterncapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getLocaleSeparator(uld: *mut ULocaleData, separator: *mut u16, separatorcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getLocaleSeparator ( uld : *mut ULocaleData , separator : *mut u16 , separatorcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ulocdata_getLocaleSeparator(uld, separator, separatorcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getMeasurementSystem<P0>(localeid: P0, status: *mut UErrorCode) -> UMeasurementSystem
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getMeasurementSystem ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> UMeasurementSystem );
    ulocdata_getMeasurementSystem(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getNoSubstitute(uld: *mut ULocaleData) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getNoSubstitute ( uld : *mut ULocaleData ) -> i8 );
    ulocdata_getNoSubstitute(uld)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_getPaperSize<P0>(localeid: P0, height: *mut i32, width: *mut i32, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_getPaperSize ( localeid : :: windows::core::PCSTR , height : *mut i32 , width : *mut i32 , status : *mut UErrorCode ) -> ( ) );
    ulocdata_getPaperSize(localeid.into_param().abi(), height, width, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_open<P0>(localeid: P0, status: *mut UErrorCode) -> *mut ULocaleData
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_open ( localeid : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut ULocaleData );
    ulocdata_open(localeid.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ulocdata_setNoSubstitute(uld: *mut ULocaleData, setting: i8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ulocdata_setNoSubstitute ( uld : *mut ULocaleData , setting : i8 ) -> ( ) );
    ulocdata_setNoSubstitute(uld, setting)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_applyPattern(fmt: *mut *mut ::core::ffi::c_void, pattern: *const u16, patternlength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_applyPattern ( fmt : *mut *mut ::core::ffi::c_void , pattern : *const u16 , patternlength : i32 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> ( ) );
    umsg_applyPattern(fmt, pattern, patternlength, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_autoQuoteApostrophe(pattern: *const u16, patternlength: i32, dest: *mut u16, destcapacity: i32, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_autoQuoteApostrophe ( pattern : *const u16 , patternlength : i32 , dest : *mut u16 , destcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    umsg_autoQuoteApostrophe(pattern, patternlength, dest, destcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_clone(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_clone ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut ::core::ffi::c_void );
    umsg_clone(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_close(format: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_close ( format : *mut *mut ::core::ffi::c_void ) -> ( ) );
    umsg_close(format)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_format(fmt: *const *const ::core::ffi::c_void, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_format ( fmt : *const *const ::core::ffi::c_void , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    umsg_format(fmt, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_getLocale(fmt: *const *const ::core::ffi::c_void) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_getLocale ( fmt : *const *const ::core::ffi::c_void ) -> :: windows::core::PSTR );
    umsg_getLocale(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_open<P0>(pattern: *const u16, patternlength: i32, locale: P0, parseerror: *mut UParseError, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_open ( pattern : *const u16 , patternlength : i32 , locale : :: windows::core::PCSTR , parseerror : *mut UParseError , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    umsg_open(pattern, patternlength, locale.into_param().abi(), parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_parse(fmt: *const *const ::core::ffi::c_void, source: *const u16, sourcelength: i32, count: *mut i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_parse ( fmt : *const *const ::core::ffi::c_void , source : *const u16 , sourcelength : i32 , count : *mut i32 , status : *mut UErrorCode ) -> ( ) );
    umsg_parse(fmt, source, sourcelength, count, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_setLocale<P0>(fmt: *mut *mut ::core::ffi::c_void, locale: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_setLocale ( fmt : *mut *mut ::core::ffi::c_void , locale : :: windows::core::PCSTR ) -> ( ) );
    umsg_setLocale(fmt, locale.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_toPattern(fmt: *const *const ::core::ffi::c_void, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_toPattern ( fmt : *const *const ::core::ffi::c_void , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    umsg_toPattern(fmt, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_vformat(fmt: *const *const ::core::ffi::c_void, result: *mut u16, resultlength: i32, ap: *mut i8, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_vformat ( fmt : *const *const ::core::ffi::c_void , result : *mut u16 , resultlength : i32 , ap : *mut i8 , status : *mut UErrorCode ) -> i32 );
    umsg_vformat(fmt, result, resultlength, ap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umsg_vparse(fmt: *const *const ::core::ffi::c_void, source: *const u16, sourcelength: i32, count: *mut i32, ap: *mut i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umsg_vparse ( fmt : *const *const ::core::ffi::c_void , source : *const u16 , sourcelength : i32 , count : *mut i32 , ap : *mut i8 , status : *mut UErrorCode ) -> ( ) );
    umsg_vparse(fmt, source, sourcelength, count, ap, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_buildImmutable(trie: *mut UMutableCPTrie, r#type: UCPTrieType, valuewidth: UCPTrieValueWidth, perrorcode: *mut UErrorCode) -> *mut UCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_buildImmutable ( trie : *mut UMutableCPTrie , r#type : UCPTrieType , valuewidth : UCPTrieValueWidth , perrorcode : *mut UErrorCode ) -> *mut UCPTrie );
    umutablecptrie_buildImmutable(trie, r#type, valuewidth, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_clone(other: *const UMutableCPTrie, perrorcode: *mut UErrorCode) -> *mut UMutableCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_clone ( other : *const UMutableCPTrie , perrorcode : *mut UErrorCode ) -> *mut UMutableCPTrie );
    umutablecptrie_clone(other, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_close(trie: *mut UMutableCPTrie) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_close ( trie : *mut UMutableCPTrie ) -> ( ) );
    umutablecptrie_close(trie)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_fromUCPMap(map: *const UCPMap, perrorcode: *mut UErrorCode) -> *mut UMutableCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_fromUCPMap ( map : *const UCPMap , perrorcode : *mut UErrorCode ) -> *mut UMutableCPTrie );
    umutablecptrie_fromUCPMap(map, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_fromUCPTrie(trie: *const UCPTrie, perrorcode: *mut UErrorCode) -> *mut UMutableCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_fromUCPTrie ( trie : *const UCPTrie , perrorcode : *mut UErrorCode ) -> *mut UMutableCPTrie );
    umutablecptrie_fromUCPTrie(trie, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_get(trie: *const UMutableCPTrie, c: i32) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_get ( trie : *const UMutableCPTrie , c : i32 ) -> u32 );
    umutablecptrie_get(trie, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_getRange(trie: *const UMutableCPTrie, start: i32, option: UCPMapRangeOption, surrogatevalue: u32, filter: *mut UCPMapValueFilter, context: *const ::core::ffi::c_void, pvalue: *mut u32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_getRange ( trie : *const UMutableCPTrie , start : i32 , option : UCPMapRangeOption , surrogatevalue : u32 , filter : *mut UCPMapValueFilter , context : *const ::core::ffi::c_void , pvalue : *mut u32 ) -> i32 );
    umutablecptrie_getRange(trie, start, option, surrogatevalue, filter, context, pvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_open(initialvalue: u32, errorvalue: u32, perrorcode: *mut UErrorCode) -> *mut UMutableCPTrie {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_open ( initialvalue : u32 , errorvalue : u32 , perrorcode : *mut UErrorCode ) -> *mut UMutableCPTrie );
    umutablecptrie_open(initialvalue, errorvalue, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_set(trie: *mut UMutableCPTrie, c: i32, value: u32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_set ( trie : *mut UMutableCPTrie , c : i32 , value : u32 , perrorcode : *mut UErrorCode ) -> ( ) );
    umutablecptrie_set(trie, c, value, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn umutablecptrie_setRange(trie: *mut UMutableCPTrie, start: i32, end: i32, value: u32, perrorcode: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn umutablecptrie_setRange ( trie : *mut UMutableCPTrie , start : i32 , end : i32 , value : u32 , perrorcode : *mut UErrorCode ) -> ( ) );
    umutablecptrie_setRange(trie, start, end, value, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_append(norm2: *const UNormalizer2, first: *mut u16, firstlength: i32, firstcapacity: i32, second: *const u16, secondlength: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_append ( norm2 : *const UNormalizer2 , first : *mut u16 , firstlength : i32 , firstcapacity : i32 , second : *const u16 , secondlength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_append(norm2, first, firstlength, firstcapacity, second, secondlength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_close(norm2: *mut UNormalizer2) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_close ( norm2 : *mut UNormalizer2 ) -> ( ) );
    unorm2_close(norm2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_composePair(norm2: *const UNormalizer2, a: i32, b: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_composePair ( norm2 : *const UNormalizer2 , a : i32 , b : i32 ) -> i32 );
    unorm2_composePair(norm2, a, b)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getCombiningClass(norm2: *const UNormalizer2, c: i32) -> u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getCombiningClass ( norm2 : *const UNormalizer2 , c : i32 ) -> u8 );
    unorm2_getCombiningClass(norm2, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getDecomposition(norm2: *const UNormalizer2, c: i32, decomposition: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getDecomposition ( norm2 : *const UNormalizer2 , c : i32 , decomposition : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_getDecomposition(norm2, c, decomposition, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getInstance<P0, P1>(packagename: P0, name: P1, mode: UNormalization2Mode, perrorcode: *mut UErrorCode) -> *mut UNormalizer2
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getInstance ( packagename : :: windows::core::PCSTR , name : :: windows::core::PCSTR , mode : UNormalization2Mode , perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getInstance(packagename.into_param().abi(), name.into_param().abi(), mode, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getNFCInstance(perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getNFCInstance ( perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getNFCInstance(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getNFDInstance(perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getNFDInstance ( perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getNFDInstance(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getNFKCCasefoldInstance(perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getNFKCCasefoldInstance ( perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getNFKCCasefoldInstance(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getNFKCInstance(perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getNFKCInstance ( perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getNFKCInstance(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getNFKDInstance(perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getNFKDInstance ( perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_getNFKDInstance(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_getRawDecomposition(norm2: *const UNormalizer2, c: i32, decomposition: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_getRawDecomposition ( norm2 : *const UNormalizer2 , c : i32 , decomposition : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_getRawDecomposition(norm2, c, decomposition, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_hasBoundaryAfter(norm2: *const UNormalizer2, c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_hasBoundaryAfter ( norm2 : *const UNormalizer2 , c : i32 ) -> i8 );
    unorm2_hasBoundaryAfter(norm2, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_hasBoundaryBefore(norm2: *const UNormalizer2, c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_hasBoundaryBefore ( norm2 : *const UNormalizer2 , c : i32 ) -> i8 );
    unorm2_hasBoundaryBefore(norm2, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_isInert(norm2: *const UNormalizer2, c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_isInert ( norm2 : *const UNormalizer2 , c : i32 ) -> i8 );
    unorm2_isInert(norm2, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_isNormalized(norm2: *const UNormalizer2, s: *const u16, length: i32, perrorcode: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_isNormalized ( norm2 : *const UNormalizer2 , s : *const u16 , length : i32 , perrorcode : *mut UErrorCode ) -> i8 );
    unorm2_isNormalized(norm2, s, length, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_normalize(norm2: *const UNormalizer2, src: *const u16, length: i32, dest: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_normalize ( norm2 : *const UNormalizer2 , src : *const u16 , length : i32 , dest : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_normalize(norm2, src, length, dest, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_normalizeSecondAndAppend(norm2: *const UNormalizer2, first: *mut u16, firstlength: i32, firstcapacity: i32, second: *const u16, secondlength: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_normalizeSecondAndAppend ( norm2 : *const UNormalizer2 , first : *mut u16 , firstlength : i32 , firstcapacity : i32 , second : *const u16 , secondlength : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_normalizeSecondAndAppend(norm2, first, firstlength, firstcapacity, second, secondlength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_openFiltered(norm2: *const UNormalizer2, filterset: *const USet, perrorcode: *mut UErrorCode) -> *mut UNormalizer2 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_openFiltered ( norm2 : *const UNormalizer2 , filterset : *const USet , perrorcode : *mut UErrorCode ) -> *mut UNormalizer2 );
    unorm2_openFiltered(norm2, filterset, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_quickCheck(norm2: *const UNormalizer2, s: *const u16, length: i32, perrorcode: *mut UErrorCode) -> UNormalizationCheckResult {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_quickCheck ( norm2 : *const UNormalizer2 , s : *const u16 , length : i32 , perrorcode : *mut UErrorCode ) -> UNormalizationCheckResult );
    unorm2_quickCheck(norm2, s, length, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm2_spanQuickCheckYes(norm2: *const UNormalizer2, s: *const u16, length: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm2_spanQuickCheckYes ( norm2 : *const UNormalizer2 , s : *const u16 , length : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm2_spanQuickCheckYes(norm2, s, length, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unorm_compare(s1: *const u16, length1: i32, s2: *const u16, length2: i32, options: u32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unorm_compare ( s1 : *const u16 , length1 : i32 , s2 : *const u16 , length2 : i32 , options : u32 , perrorcode : *mut UErrorCode ) -> i32 );
    unorm_compare(s1, length1, s2, length2, options, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_applyPattern(format: *mut *mut ::core::ffi::c_void, localized: i8, pattern: *const u16, patternlength: i32, parseerror: *mut UParseError, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_applyPattern ( format : *mut *mut ::core::ffi::c_void , localized : i8 , pattern : *const u16 , patternlength : i32 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> ( ) );
    unum_applyPattern(format, localized, pattern, patternlength, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_clone(fmt: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_clone ( fmt : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    unum_clone(fmt, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_close(fmt: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_close ( fmt : *mut *mut ::core::ffi::c_void ) -> ( ) );
    unum_close(fmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_countAvailable() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_countAvailable ( ) -> i32 );
    unum_countAvailable()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_format(fmt: *const *const ::core::ffi::c_void, number: i32, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_format ( fmt : *const *const ::core::ffi::c_void , number : i32 , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_format(fmt, number, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatDecimal<P0>(fmt: *const *const ::core::ffi::c_void, number: P0, length: i32, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatDecimal ( fmt : *const *const ::core::ffi::c_void , number : :: windows::core::PCSTR , length : i32 , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_formatDecimal(fmt, number.into_param().abi(), length, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatDouble(fmt: *const *const ::core::ffi::c_void, number: f64, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatDouble ( fmt : *const *const ::core::ffi::c_void , number : f64 , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_formatDouble(fmt, number, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatDoubleCurrency(fmt: *const *const ::core::ffi::c_void, number: f64, currency: *mut u16, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatDoubleCurrency ( fmt : *const *const ::core::ffi::c_void , number : f64 , currency : *mut u16 , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_formatDoubleCurrency(fmt, number, currency, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatDoubleForFields(format: *const *const ::core::ffi::c_void, number: f64, result: *mut u16, resultlength: i32, fpositer: *mut UFieldPositionIterator, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatDoubleForFields ( format : *const *const ::core::ffi::c_void , number : f64 , result : *mut u16 , resultlength : i32 , fpositer : *mut UFieldPositionIterator , status : *mut UErrorCode ) -> i32 );
    unum_formatDoubleForFields(format, number, result, resultlength, fpositer, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatInt64(fmt: *const *const ::core::ffi::c_void, number: i64, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatInt64 ( fmt : *const *const ::core::ffi::c_void , number : i64 , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_formatInt64(fmt, number, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_formatUFormattable(fmt: *const *const ::core::ffi::c_void, number: *const *const ::core::ffi::c_void, result: *mut u16, resultlength: i32, pos: *mut UFieldPosition, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_formatUFormattable ( fmt : *const *const ::core::ffi::c_void , number : *const *const ::core::ffi::c_void , result : *mut u16 , resultlength : i32 , pos : *mut UFieldPosition , status : *mut UErrorCode ) -> i32 );
    unum_formatUFormattable(fmt, number, result, resultlength, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getAttribute(fmt: *const *const ::core::ffi::c_void, attr: UNumberFormatAttribute) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getAttribute ( fmt : *const *const ::core::ffi::c_void , attr : UNumberFormatAttribute ) -> i32 );
    unum_getAttribute(fmt, attr)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getAvailable(localeindex: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getAvailable ( localeindex : i32 ) -> :: windows::core::PSTR );
    unum_getAvailable(localeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getContext(fmt: *const *const ::core::ffi::c_void, r#type: UDisplayContextType, status: *mut UErrorCode) -> UDisplayContext {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getContext ( fmt : *const *const ::core::ffi::c_void , r#type : UDisplayContextType , status : *mut UErrorCode ) -> UDisplayContext );
    unum_getContext(fmt, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getDoubleAttribute(fmt: *const *const ::core::ffi::c_void, attr: UNumberFormatAttribute) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getDoubleAttribute ( fmt : *const *const ::core::ffi::c_void , attr : UNumberFormatAttribute ) -> f64 );
    unum_getDoubleAttribute(fmt, attr)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getLocaleByType(fmt: *const *const ::core::ffi::c_void, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getLocaleByType ( fmt : *const *const ::core::ffi::c_void , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    unum_getLocaleByType(fmt, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getSymbol(fmt: *const *const ::core::ffi::c_void, symbol: UNumberFormatSymbol, buffer: *mut u16, size: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getSymbol ( fmt : *const *const ::core::ffi::c_void , symbol : UNumberFormatSymbol , buffer : *mut u16 , size : i32 , status : *mut UErrorCode ) -> i32 );
    unum_getSymbol(fmt, symbol, buffer, size, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_getTextAttribute(fmt: *const *const ::core::ffi::c_void, tag: UNumberFormatTextAttribute, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_getTextAttribute ( fmt : *const *const ::core::ffi::c_void , tag : UNumberFormatTextAttribute , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    unum_getTextAttribute(fmt, tag, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_open<P0>(style: UNumberFormatStyle, pattern: *const u16, patternlength: i32, locale: P0, parseerr: *mut UParseError, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_open ( style : UNumberFormatStyle , pattern : *const u16 , patternlength : i32 , locale : :: windows::core::PCSTR , parseerr : *mut UParseError , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    unum_open(style, pattern, patternlength, locale.into_param().abi(), parseerr, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parse(fmt: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parse ( fmt : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> i32 );
    unum_parse(fmt, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parseDecimal<P0>(fmt: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, outbuf: P0, outbuflength: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parseDecimal ( fmt : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , outbuf : :: windows::core::PCSTR , outbuflength : i32 , status : *mut UErrorCode ) -> i32 );
    unum_parseDecimal(fmt, text, textlength, parsepos, outbuf.into_param().abi(), outbuflength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parseDouble(fmt: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parseDouble ( fmt : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> f64 );
    unum_parseDouble(fmt, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parseDoubleCurrency(fmt: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, currency: *mut u16, status: *mut UErrorCode) -> f64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parseDoubleCurrency ( fmt : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , currency : *mut u16 , status : *mut UErrorCode ) -> f64 );
    unum_parseDoubleCurrency(fmt, text, textlength, parsepos, currency, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parseInt64(fmt: *const *const ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parseInt64 ( fmt : *const *const ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> i64 );
    unum_parseInt64(fmt, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_parseToUFormattable(fmt: *const *const ::core::ffi::c_void, result: *mut *mut ::core::ffi::c_void, text: *const u16, textlength: i32, parsepos: *mut i32, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_parseToUFormattable ( fmt : *const *const ::core::ffi::c_void , result : *mut *mut ::core::ffi::c_void , text : *const u16 , textlength : i32 , parsepos : *mut i32 , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    unum_parseToUFormattable(fmt, result, text, textlength, parsepos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_setAttribute(fmt: *mut *mut ::core::ffi::c_void, attr: UNumberFormatAttribute, newvalue: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_setAttribute ( fmt : *mut *mut ::core::ffi::c_void , attr : UNumberFormatAttribute , newvalue : i32 ) -> ( ) );
    unum_setAttribute(fmt, attr, newvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_setContext(fmt: *mut *mut ::core::ffi::c_void, value: UDisplayContext, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_setContext ( fmt : *mut *mut ::core::ffi::c_void , value : UDisplayContext , status : *mut UErrorCode ) -> ( ) );
    unum_setContext(fmt, value, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_setDoubleAttribute(fmt: *mut *mut ::core::ffi::c_void, attr: UNumberFormatAttribute, newvalue: f64) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_setDoubleAttribute ( fmt : *mut *mut ::core::ffi::c_void , attr : UNumberFormatAttribute , newvalue : f64 ) -> ( ) );
    unum_setDoubleAttribute(fmt, attr, newvalue)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_setSymbol(fmt: *mut *mut ::core::ffi::c_void, symbol: UNumberFormatSymbol, value: *const u16, length: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_setSymbol ( fmt : *mut *mut ::core::ffi::c_void , symbol : UNumberFormatSymbol , value : *const u16 , length : i32 , status : *mut UErrorCode ) -> ( ) );
    unum_setSymbol(fmt, symbol, value, length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_setTextAttribute(fmt: *mut *mut ::core::ffi::c_void, tag: UNumberFormatTextAttribute, newvalue: *const u16, newvaluelength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_setTextAttribute ( fmt : *mut *mut ::core::ffi::c_void , tag : UNumberFormatTextAttribute , newvalue : *const u16 , newvaluelength : i32 , status : *mut UErrorCode ) -> ( ) );
    unum_setTextAttribute(fmt, tag, newvalue, newvaluelength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unum_toPattern(fmt: *const *const ::core::ffi::c_void, ispatternlocalized: i8, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unum_toPattern ( fmt : *const *const ::core::ffi::c_void , ispatternlocalized : i8 , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    unum_toPattern(fmt, ispatternlocalized, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_close(uformatter: *mut UNumberFormatter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_close ( uformatter : *mut UNumberFormatter ) -> ( ) );
    unumf_close(uformatter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_closeResult(uresult: *mut UFormattedNumber) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_closeResult ( uresult : *mut UFormattedNumber ) -> ( ) );
    unumf_closeResult(uresult)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_formatDecimal<P0>(uformatter: *const UNumberFormatter, value: P0, valuelen: i32, uresult: *mut UFormattedNumber, ec: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_formatDecimal ( uformatter : *const UNumberFormatter , value : :: windows::core::PCSTR , valuelen : i32 , uresult : *mut UFormattedNumber , ec : *mut UErrorCode ) -> ( ) );
    unumf_formatDecimal(uformatter, value.into_param().abi(), valuelen, uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_formatDouble(uformatter: *const UNumberFormatter, value: f64, uresult: *mut UFormattedNumber, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_formatDouble ( uformatter : *const UNumberFormatter , value : f64 , uresult : *mut UFormattedNumber , ec : *mut UErrorCode ) -> ( ) );
    unumf_formatDouble(uformatter, value, uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_formatInt(uformatter: *const UNumberFormatter, value: i64, uresult: *mut UFormattedNumber, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_formatInt ( uformatter : *const UNumberFormatter , value : i64 , uresult : *mut UFormattedNumber , ec : *mut UErrorCode ) -> ( ) );
    unumf_formatInt(uformatter, value, uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_openForSkeletonAndLocale<P0>(skeleton: *const u16, skeletonlen: i32, locale: P0, ec: *mut UErrorCode) -> *mut UNumberFormatter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_openForSkeletonAndLocale ( skeleton : *const u16 , skeletonlen : i32 , locale : :: windows::core::PCSTR , ec : *mut UErrorCode ) -> *mut UNumberFormatter );
    unumf_openForSkeletonAndLocale(skeleton, skeletonlen, locale.into_param().abi(), ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_openForSkeletonAndLocaleWithError<P0>(skeleton: *const u16, skeletonlen: i32, locale: P0, perror: *mut UParseError, ec: *mut UErrorCode) -> *mut UNumberFormatter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_openForSkeletonAndLocaleWithError ( skeleton : *const u16 , skeletonlen : i32 , locale : :: windows::core::PCSTR , perror : *mut UParseError , ec : *mut UErrorCode ) -> *mut UNumberFormatter );
    unumf_openForSkeletonAndLocaleWithError(skeleton, skeletonlen, locale.into_param().abi(), perror, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_openResult(ec: *mut UErrorCode) -> *mut UFormattedNumber {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_openResult ( ec : *mut UErrorCode ) -> *mut UFormattedNumber );
    unumf_openResult(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_resultAsValue(uresult: *const UFormattedNumber, ec: *mut UErrorCode) -> *mut UFormattedValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_resultAsValue ( uresult : *const UFormattedNumber , ec : *mut UErrorCode ) -> *mut UFormattedValue );
    unumf_resultAsValue(uresult, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_resultGetAllFieldPositions(uresult: *const UFormattedNumber, ufpositer: *mut UFieldPositionIterator, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_resultGetAllFieldPositions ( uresult : *const UFormattedNumber , ufpositer : *mut UFieldPositionIterator , ec : *mut UErrorCode ) -> ( ) );
    unumf_resultGetAllFieldPositions(uresult, ufpositer, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_resultNextFieldPosition(uresult: *const UFormattedNumber, ufpos: *mut UFieldPosition, ec: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_resultNextFieldPosition ( uresult : *const UFormattedNumber , ufpos : *mut UFieldPosition , ec : *mut UErrorCode ) -> i8 );
    unumf_resultNextFieldPosition(uresult, ufpos, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumf_resultToString(uresult: *const UFormattedNumber, buffer: *mut u16, buffercapacity: i32, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumf_resultToString ( uresult : *const UFormattedNumber , buffer : *mut u16 , buffercapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    unumf_resultToString(uresult, buffer, buffercapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_close(unumsys: *mut UNumberingSystem) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_close ( unumsys : *mut UNumberingSystem ) -> ( ) );
    unumsys_close(unumsys)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_getDescription(unumsys: *const UNumberingSystem, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_getDescription ( unumsys : *const UNumberingSystem , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    unumsys_getDescription(unumsys, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_getName(unumsys: *const UNumberingSystem) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_getName ( unumsys : *const UNumberingSystem ) -> :: windows::core::PSTR );
    unumsys_getName(unumsys)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_getRadix(unumsys: *const UNumberingSystem) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_getRadix ( unumsys : *const UNumberingSystem ) -> i32 );
    unumsys_getRadix(unumsys)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_isAlgorithmic(unumsys: *const UNumberingSystem) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_isAlgorithmic ( unumsys : *const UNumberingSystem ) -> i8 );
    unumsys_isAlgorithmic(unumsys)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_open<P0>(locale: P0, status: *mut UErrorCode) -> *mut UNumberingSystem
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_open ( locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UNumberingSystem );
    unumsys_open(locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_openAvailableNames(status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_openAvailableNames ( status : *mut UErrorCode ) -> *mut UEnumeration );
    unumsys_openAvailableNames(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn unumsys_openByName<P0>(name: P0, status: *mut UErrorCode) -> *mut UNumberingSystem
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn unumsys_openByName ( name : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UNumberingSystem );
    unumsys_openByName(name.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_close(uplrules: *mut UPluralRules) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_close ( uplrules : *mut UPluralRules ) -> ( ) );
    uplrules_close(uplrules)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_getKeywords(uplrules: *const UPluralRules, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_getKeywords ( uplrules : *const UPluralRules , status : *mut UErrorCode ) -> *mut UEnumeration );
    uplrules_getKeywords(uplrules, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_open<P0>(locale: P0, status: *mut UErrorCode) -> *mut UPluralRules
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_open ( locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UPluralRules );
    uplrules_open(locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_openForType<P0>(locale: P0, r#type: UPluralType, status: *mut UErrorCode) -> *mut UPluralRules
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_openForType ( locale : :: windows::core::PCSTR , r#type : UPluralType , status : *mut UErrorCode ) -> *mut UPluralRules );
    uplrules_openForType(locale.into_param().abi(), r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_select(uplrules: *const UPluralRules, number: f64, keyword: *mut u16, capacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_select ( uplrules : *const UPluralRules , number : f64 , keyword : *mut u16 , capacity : i32 , status : *mut UErrorCode ) -> i32 );
    uplrules_select(uplrules, number, keyword, capacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uplrules_selectFormatted(uplrules: *const UPluralRules, number: *const UFormattedNumber, keyword: *mut u16, capacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uplrules_selectFormatted ( uplrules : *const UPluralRules , number : *const UFormattedNumber , keyword : *mut u16 , capacity : i32 , status : *mut UErrorCode ) -> i32 );
    uplrules_selectFormatted(uplrules, number, keyword, capacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_appendReplacement(regexp: *mut URegularExpression, replacementtext: *const u16, replacementlength: i32, destbuf: *mut *mut u16, destcapacity: *mut i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_appendReplacement ( regexp : *mut URegularExpression , replacementtext : *const u16 , replacementlength : i32 , destbuf : *mut *mut u16 , destcapacity : *mut i32 , status : *mut UErrorCode ) -> i32 );
    uregex_appendReplacement(regexp, replacementtext, replacementlength, destbuf, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_appendReplacementUText(regexp: *mut URegularExpression, replacementtext: *mut UText, dest: *mut UText, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_appendReplacementUText ( regexp : *mut URegularExpression , replacementtext : *mut UText , dest : *mut UText , status : *mut UErrorCode ) -> ( ) );
    uregex_appendReplacementUText(regexp, replacementtext, dest, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_appendTail(regexp: *mut URegularExpression, destbuf: *mut *mut u16, destcapacity: *mut i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_appendTail ( regexp : *mut URegularExpression , destbuf : *mut *mut u16 , destcapacity : *mut i32 , status : *mut UErrorCode ) -> i32 );
    uregex_appendTail(regexp, destbuf, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_appendTailUText(regexp: *mut URegularExpression, dest: *mut UText, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_appendTailUText ( regexp : *mut URegularExpression , dest : *mut UText , status : *mut UErrorCode ) -> *mut UText );
    uregex_appendTailUText(regexp, dest, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_clone(regexp: *const URegularExpression, status: *mut UErrorCode) -> *mut URegularExpression {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_clone ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> *mut URegularExpression );
    uregex_clone(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_close(regexp: *mut URegularExpression) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_close ( regexp : *mut URegularExpression ) -> ( ) );
    uregex_close(regexp)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_end(regexp: *mut URegularExpression, groupnum: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_end ( regexp : *mut URegularExpression , groupnum : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_end(regexp, groupnum, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_end64(regexp: *mut URegularExpression, groupnum: i32, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_end64 ( regexp : *mut URegularExpression , groupnum : i32 , status : *mut UErrorCode ) -> i64 );
    uregex_end64(regexp, groupnum, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_find(regexp: *mut URegularExpression, startindex: i32, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_find ( regexp : *mut URegularExpression , startindex : i32 , status : *mut UErrorCode ) -> i8 );
    uregex_find(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_find64(regexp: *mut URegularExpression, startindex: i64, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_find64 ( regexp : *mut URegularExpression , startindex : i64 , status : *mut UErrorCode ) -> i8 );
    uregex_find64(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_findNext(regexp: *mut URegularExpression, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_findNext ( regexp : *mut URegularExpression , status : *mut UErrorCode ) -> i8 );
    uregex_findNext(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_flags(regexp: *const URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_flags ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_flags(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getFindProgressCallback(regexp: *const URegularExpression, callback: *mut URegexFindProgressCallback, context: *const *const ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getFindProgressCallback ( regexp : *const URegularExpression , callback : *mut URegexFindProgressCallback , context : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    uregex_getFindProgressCallback(regexp, callback, context, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getMatchCallback(regexp: *const URegularExpression, callback: *mut URegexMatchCallback, context: *const *const ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getMatchCallback ( regexp : *const URegularExpression , callback : *mut URegexMatchCallback , context : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    uregex_getMatchCallback(regexp, callback, context, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getStackLimit(regexp: *const URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getStackLimit ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_getStackLimit(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getText(regexp: *mut URegularExpression, textlength: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getText ( regexp : *mut URegularExpression , textlength : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    uregex_getText(regexp, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getTimeLimit(regexp: *const URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getTimeLimit ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_getTimeLimit(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_getUText(regexp: *mut URegularExpression, dest: *mut UText, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_getUText ( regexp : *mut URegularExpression , dest : *mut UText , status : *mut UErrorCode ) -> *mut UText );
    uregex_getUText(regexp, dest, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_group(regexp: *mut URegularExpression, groupnum: i32, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_group ( regexp : *mut URegularExpression , groupnum : i32 , dest : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_group(regexp, groupnum, dest, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_groupCount(regexp: *mut URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_groupCount ( regexp : *mut URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_groupCount(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_groupNumberFromCName<P0>(regexp: *mut URegularExpression, groupname: P0, namelength: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_groupNumberFromCName ( regexp : *mut URegularExpression , groupname : :: windows::core::PCSTR , namelength : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_groupNumberFromCName(regexp, groupname.into_param().abi(), namelength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_groupNumberFromName(regexp: *mut URegularExpression, groupname: *const u16, namelength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_groupNumberFromName ( regexp : *mut URegularExpression , groupname : *const u16 , namelength : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_groupNumberFromName(regexp, groupname, namelength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_groupUText(regexp: *mut URegularExpression, groupnum: i32, dest: *mut UText, grouplength: *mut i64, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_groupUText ( regexp : *mut URegularExpression , groupnum : i32 , dest : *mut UText , grouplength : *mut i64 , status : *mut UErrorCode ) -> *mut UText );
    uregex_groupUText(regexp, groupnum, dest, grouplength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_hasAnchoringBounds(regexp: *const URegularExpression, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_hasAnchoringBounds ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i8 );
    uregex_hasAnchoringBounds(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_hasTransparentBounds(regexp: *const URegularExpression, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_hasTransparentBounds ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i8 );
    uregex_hasTransparentBounds(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_hitEnd(regexp: *const URegularExpression, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_hitEnd ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i8 );
    uregex_hitEnd(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_lookingAt(regexp: *mut URegularExpression, startindex: i32, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_lookingAt ( regexp : *mut URegularExpression , startindex : i32 , status : *mut UErrorCode ) -> i8 );
    uregex_lookingAt(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_lookingAt64(regexp: *mut URegularExpression, startindex: i64, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_lookingAt64 ( regexp : *mut URegularExpression , startindex : i64 , status : *mut UErrorCode ) -> i8 );
    uregex_lookingAt64(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_matches(regexp: *mut URegularExpression, startindex: i32, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_matches ( regexp : *mut URegularExpression , startindex : i32 , status : *mut UErrorCode ) -> i8 );
    uregex_matches(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_matches64(regexp: *mut URegularExpression, startindex: i64, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_matches64 ( regexp : *mut URegularExpression , startindex : i64 , status : *mut UErrorCode ) -> i8 );
    uregex_matches64(regexp, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_open(pattern: *const u16, patternlength: i32, flags: u32, pe: *mut UParseError, status: *mut UErrorCode) -> *mut URegularExpression {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_open ( pattern : *const u16 , patternlength : i32 , flags : u32 , pe : *mut UParseError , status : *mut UErrorCode ) -> *mut URegularExpression );
    uregex_open(pattern, patternlength, flags, pe, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_openC<P0>(pattern: P0, flags: u32, pe: *mut UParseError, status: *mut UErrorCode) -> *mut URegularExpression
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_openC ( pattern : :: windows::core::PCSTR , flags : u32 , pe : *mut UParseError , status : *mut UErrorCode ) -> *mut URegularExpression );
    uregex_openC(pattern.into_param().abi(), flags, pe, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_openUText(pattern: *mut UText, flags: u32, pe: *mut UParseError, status: *mut UErrorCode) -> *mut URegularExpression {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_openUText ( pattern : *mut UText , flags : u32 , pe : *mut UParseError , status : *mut UErrorCode ) -> *mut URegularExpression );
    uregex_openUText(pattern, flags, pe, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_pattern(regexp: *const URegularExpression, patlength: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_pattern ( regexp : *const URegularExpression , patlength : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    uregex_pattern(regexp, patlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_patternUText(regexp: *const URegularExpression, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_patternUText ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> *mut UText );
    uregex_patternUText(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_refreshUText(regexp: *mut URegularExpression, text: *mut UText, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_refreshUText ( regexp : *mut URegularExpression , text : *mut UText , status : *mut UErrorCode ) -> ( ) );
    uregex_refreshUText(regexp, text, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_regionEnd(regexp: *const URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_regionEnd ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_regionEnd(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_regionEnd64(regexp: *const URegularExpression, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_regionEnd64 ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i64 );
    uregex_regionEnd64(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_regionStart(regexp: *const URegularExpression, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_regionStart ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i32 );
    uregex_regionStart(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_regionStart64(regexp: *const URegularExpression, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_regionStart64 ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i64 );
    uregex_regionStart64(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_replaceAll(regexp: *mut URegularExpression, replacementtext: *const u16, replacementlength: i32, destbuf: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_replaceAll ( regexp : *mut URegularExpression , replacementtext : *const u16 , replacementlength : i32 , destbuf : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_replaceAll(regexp, replacementtext, replacementlength, destbuf, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_replaceAllUText(regexp: *mut URegularExpression, replacement: *mut UText, dest: *mut UText, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_replaceAllUText ( regexp : *mut URegularExpression , replacement : *mut UText , dest : *mut UText , status : *mut UErrorCode ) -> *mut UText );
    uregex_replaceAllUText(regexp, replacement, dest, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_replaceFirst(regexp: *mut URegularExpression, replacementtext: *const u16, replacementlength: i32, destbuf: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_replaceFirst ( regexp : *mut URegularExpression , replacementtext : *const u16 , replacementlength : i32 , destbuf : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_replaceFirst(regexp, replacementtext, replacementlength, destbuf, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_replaceFirstUText(regexp: *mut URegularExpression, replacement: *mut UText, dest: *mut UText, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_replaceFirstUText ( regexp : *mut URegularExpression , replacement : *mut UText , dest : *mut UText , status : *mut UErrorCode ) -> *mut UText );
    uregex_replaceFirstUText(regexp, replacement, dest, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_requireEnd(regexp: *const URegularExpression, status: *mut UErrorCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_requireEnd ( regexp : *const URegularExpression , status : *mut UErrorCode ) -> i8 );
    uregex_requireEnd(regexp, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_reset(regexp: *mut URegularExpression, index: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_reset ( regexp : *mut URegularExpression , index : i32 , status : *mut UErrorCode ) -> ( ) );
    uregex_reset(regexp, index, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_reset64(regexp: *mut URegularExpression, index: i64, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_reset64 ( regexp : *mut URegularExpression , index : i64 , status : *mut UErrorCode ) -> ( ) );
    uregex_reset64(regexp, index, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setFindProgressCallback(regexp: *mut URegularExpression, callback: URegexFindProgressCallback, context: *const ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setFindProgressCallback ( regexp : *mut URegularExpression , callback : URegexFindProgressCallback , context : *const ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    uregex_setFindProgressCallback(regexp, callback, context, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setMatchCallback(regexp: *mut URegularExpression, callback: URegexMatchCallback, context: *const ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setMatchCallback ( regexp : *mut URegularExpression , callback : URegexMatchCallback , context : *const ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    uregex_setMatchCallback(regexp, callback, context, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setRegion(regexp: *mut URegularExpression, regionstart: i32, regionlimit: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setRegion ( regexp : *mut URegularExpression , regionstart : i32 , regionlimit : i32 , status : *mut UErrorCode ) -> ( ) );
    uregex_setRegion(regexp, regionstart, regionlimit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setRegion64(regexp: *mut URegularExpression, regionstart: i64, regionlimit: i64, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setRegion64 ( regexp : *mut URegularExpression , regionstart : i64 , regionlimit : i64 , status : *mut UErrorCode ) -> ( ) );
    uregex_setRegion64(regexp, regionstart, regionlimit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setRegionAndStart(regexp: *mut URegularExpression, regionstart: i64, regionlimit: i64, startindex: i64, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setRegionAndStart ( regexp : *mut URegularExpression , regionstart : i64 , regionlimit : i64 , startindex : i64 , status : *mut UErrorCode ) -> ( ) );
    uregex_setRegionAndStart(regexp, regionstart, regionlimit, startindex, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setStackLimit(regexp: *mut URegularExpression, limit: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setStackLimit ( regexp : *mut URegularExpression , limit : i32 , status : *mut UErrorCode ) -> ( ) );
    uregex_setStackLimit(regexp, limit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setText(regexp: *mut URegularExpression, text: *const u16, textlength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setText ( regexp : *mut URegularExpression , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> ( ) );
    uregex_setText(regexp, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setTimeLimit(regexp: *mut URegularExpression, limit: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setTimeLimit ( regexp : *mut URegularExpression , limit : i32 , status : *mut UErrorCode ) -> ( ) );
    uregex_setTimeLimit(regexp, limit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_setUText(regexp: *mut URegularExpression, text: *mut UText, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_setUText ( regexp : *mut URegularExpression , text : *mut UText , status : *mut UErrorCode ) -> ( ) );
    uregex_setUText(regexp, text, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_split(regexp: *mut URegularExpression, destbuf: *mut u16, destcapacity: i32, requiredcapacity: *mut i32, destfields: *mut *mut u16, destfieldscapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_split ( regexp : *mut URegularExpression , destbuf : *mut u16 , destcapacity : i32 , requiredcapacity : *mut i32 , destfields : *mut *mut u16 , destfieldscapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_split(regexp, destbuf, destcapacity, requiredcapacity, destfields, destfieldscapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_splitUText(regexp: *mut URegularExpression, destfields: *mut *mut UText, destfieldscapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_splitUText ( regexp : *mut URegularExpression , destfields : *mut *mut UText , destfieldscapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_splitUText(regexp, destfields, destfieldscapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_start(regexp: *mut URegularExpression, groupnum: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_start ( regexp : *mut URegularExpression , groupnum : i32 , status : *mut UErrorCode ) -> i32 );
    uregex_start(regexp, groupnum, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_start64(regexp: *mut URegularExpression, groupnum: i32, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_start64 ( regexp : *mut URegularExpression , groupnum : i32 , status : *mut UErrorCode ) -> i64 );
    uregex_start64(regexp, groupnum, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_useAnchoringBounds(regexp: *mut URegularExpression, b: i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_useAnchoringBounds ( regexp : *mut URegularExpression , b : i8 , status : *mut UErrorCode ) -> ( ) );
    uregex_useAnchoringBounds(regexp, b, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregex_useTransparentBounds(regexp: *mut URegularExpression, b: i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregex_useTransparentBounds ( regexp : *mut URegularExpression , b : i8 , status : *mut UErrorCode ) -> ( ) );
    uregex_useTransparentBounds(regexp, b, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_areEqual(uregion: *const URegion, otherregion: *const URegion) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_areEqual ( uregion : *const URegion , otherregion : *const URegion ) -> i8 );
    uregion_areEqual(uregion, otherregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_contains(uregion: *const URegion, otherregion: *const URegion) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_contains ( uregion : *const URegion , otherregion : *const URegion ) -> i8 );
    uregion_contains(uregion, otherregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getAvailable(r#type: URegionType, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getAvailable ( r#type : URegionType , status : *mut UErrorCode ) -> *mut UEnumeration );
    uregion_getAvailable(r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getContainedRegions(uregion: *const URegion, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getContainedRegions ( uregion : *const URegion , status : *mut UErrorCode ) -> *mut UEnumeration );
    uregion_getContainedRegions(uregion, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getContainedRegionsOfType(uregion: *const URegion, r#type: URegionType, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getContainedRegionsOfType ( uregion : *const URegion , r#type : URegionType , status : *mut UErrorCode ) -> *mut UEnumeration );
    uregion_getContainedRegionsOfType(uregion, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getContainingRegion(uregion: *const URegion) -> *mut URegion {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getContainingRegion ( uregion : *const URegion ) -> *mut URegion );
    uregion_getContainingRegion(uregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getContainingRegionOfType(uregion: *const URegion, r#type: URegionType) -> *mut URegion {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getContainingRegionOfType ( uregion : *const URegion , r#type : URegionType ) -> *mut URegion );
    uregion_getContainingRegionOfType(uregion, r#type)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getNumericCode(uregion: *const URegion) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getNumericCode ( uregion : *const URegion ) -> i32 );
    uregion_getNumericCode(uregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getPreferredValues(uregion: *const URegion, status: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getPreferredValues ( uregion : *const URegion , status : *mut UErrorCode ) -> *mut UEnumeration );
    uregion_getPreferredValues(uregion, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getRegionCode(uregion: *const URegion) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getRegionCode ( uregion : *const URegion ) -> :: windows::core::PSTR );
    uregion_getRegionCode(uregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getRegionFromCode<P0>(regioncode: P0, status: *mut UErrorCode) -> *mut URegion
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getRegionFromCode ( regioncode : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut URegion );
    uregion_getRegionFromCode(regioncode.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getRegionFromNumericCode(code: i32, status: *mut UErrorCode) -> *mut URegion {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getRegionFromNumericCode ( code : i32 , status : *mut UErrorCode ) -> *mut URegion );
    uregion_getRegionFromNumericCode(code, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uregion_getType(uregion: *const URegion) -> URegionType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uregion_getType ( uregion : *const URegion ) -> URegionType );
    uregion_getType(uregion)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_close(reldatefmt: *mut URelativeDateTimeFormatter) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_close ( reldatefmt : *mut URelativeDateTimeFormatter ) -> ( ) );
    ureldatefmt_close(reldatefmt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_closeResult(ufrdt: *mut UFormattedRelativeDateTime) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_closeResult ( ufrdt : *mut UFormattedRelativeDateTime ) -> ( ) );
    ureldatefmt_closeResult(ufrdt)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_combineDateAndTime(reldatefmt: *const URelativeDateTimeFormatter, relativedatestring: *const u16, relativedatestringlen: i32, timestring: *const u16, timestringlen: i32, result: *mut u16, resultcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_combineDateAndTime ( reldatefmt : *const URelativeDateTimeFormatter , relativedatestring : *const u16 , relativedatestringlen : i32 , timestring : *const u16 , timestringlen : i32 , result : *mut u16 , resultcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ureldatefmt_combineDateAndTime(reldatefmt, relativedatestring, relativedatestringlen, timestring, timestringlen, result, resultcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_format(reldatefmt: *const URelativeDateTimeFormatter, offset: f64, unit: URelativeDateTimeUnit, result: *mut u16, resultcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_format ( reldatefmt : *const URelativeDateTimeFormatter , offset : f64 , unit : URelativeDateTimeUnit , result : *mut u16 , resultcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ureldatefmt_format(reldatefmt, offset, unit, result, resultcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_formatNumeric(reldatefmt: *const URelativeDateTimeFormatter, offset: f64, unit: URelativeDateTimeUnit, result: *mut u16, resultcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_formatNumeric ( reldatefmt : *const URelativeDateTimeFormatter , offset : f64 , unit : URelativeDateTimeUnit , result : *mut u16 , resultcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    ureldatefmt_formatNumeric(reldatefmt, offset, unit, result, resultcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_formatNumericToResult(reldatefmt: *const URelativeDateTimeFormatter, offset: f64, unit: URelativeDateTimeUnit, result: *mut UFormattedRelativeDateTime, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_formatNumericToResult ( reldatefmt : *const URelativeDateTimeFormatter , offset : f64 , unit : URelativeDateTimeUnit , result : *mut UFormattedRelativeDateTime , status : *mut UErrorCode ) -> ( ) );
    ureldatefmt_formatNumericToResult(reldatefmt, offset, unit, result, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_formatToResult(reldatefmt: *const URelativeDateTimeFormatter, offset: f64, unit: URelativeDateTimeUnit, result: *mut UFormattedRelativeDateTime, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_formatToResult ( reldatefmt : *const URelativeDateTimeFormatter , offset : f64 , unit : URelativeDateTimeUnit , result : *mut UFormattedRelativeDateTime , status : *mut UErrorCode ) -> ( ) );
    ureldatefmt_formatToResult(reldatefmt, offset, unit, result, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_open<P0>(locale: P0, nftoadopt: *mut *mut ::core::ffi::c_void, width: UDateRelativeDateTimeFormatterStyle, capitalizationcontext: UDisplayContext, status: *mut UErrorCode) -> *mut URelativeDateTimeFormatter
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_open ( locale : :: windows::core::PCSTR , nftoadopt : *mut *mut ::core::ffi::c_void , width : UDateRelativeDateTimeFormatterStyle , capitalizationcontext : UDisplayContext , status : *mut UErrorCode ) -> *mut URelativeDateTimeFormatter );
    ureldatefmt_open(locale.into_param().abi(), nftoadopt, width, capitalizationcontext, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_openResult(ec: *mut UErrorCode) -> *mut UFormattedRelativeDateTime {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_openResult ( ec : *mut UErrorCode ) -> *mut UFormattedRelativeDateTime );
    ureldatefmt_openResult(ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ureldatefmt_resultAsValue(ufrdt: *const UFormattedRelativeDateTime, ec: *mut UErrorCode) -> *mut UFormattedValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ureldatefmt_resultAsValue ( ufrdt : *const UFormattedRelativeDateTime , ec : *mut UErrorCode ) -> *mut UFormattedValue );
    ureldatefmt_resultAsValue(ufrdt, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_close(resourcebundle: *mut UResourceBundle) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_close ( resourcebundle : *mut UResourceBundle ) -> ( ) );
    ures_close(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getBinary(resourcebundle: *const UResourceBundle, len: *mut i32, status: *mut UErrorCode) -> *mut u8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getBinary ( resourcebundle : *const UResourceBundle , len : *mut i32 , status : *mut UErrorCode ) -> *mut u8 );
    ures_getBinary(resourcebundle, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getByIndex(resourcebundle: *const UResourceBundle, indexr: i32, fillin: *mut UResourceBundle, status: *mut UErrorCode) -> *mut UResourceBundle {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getByIndex ( resourcebundle : *const UResourceBundle , indexr : i32 , fillin : *mut UResourceBundle , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_getByIndex(resourcebundle, indexr, fillin, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getByKey<P0>(resourcebundle: *const UResourceBundle, key: P0, fillin: *mut UResourceBundle, status: *mut UErrorCode) -> *mut UResourceBundle
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getByKey ( resourcebundle : *const UResourceBundle , key : :: windows::core::PCSTR , fillin : *mut UResourceBundle , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_getByKey(resourcebundle, key.into_param().abi(), fillin, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getInt(resourcebundle: *const UResourceBundle, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getInt ( resourcebundle : *const UResourceBundle , status : *mut UErrorCode ) -> i32 );
    ures_getInt(resourcebundle, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getIntVector(resourcebundle: *const UResourceBundle, len: *mut i32, status: *mut UErrorCode) -> *mut i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getIntVector ( resourcebundle : *const UResourceBundle , len : *mut i32 , status : *mut UErrorCode ) -> *mut i32 );
    ures_getIntVector(resourcebundle, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getKey(resourcebundle: *const UResourceBundle) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getKey ( resourcebundle : *const UResourceBundle ) -> :: windows::core::PSTR );
    ures_getKey(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getLocaleByType(resourcebundle: *const UResourceBundle, r#type: ULocDataLocaleType, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getLocaleByType ( resourcebundle : *const UResourceBundle , r#type : ULocDataLocaleType , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ures_getLocaleByType(resourcebundle, r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getNextResource(resourcebundle: *mut UResourceBundle, fillin: *mut UResourceBundle, status: *mut UErrorCode) -> *mut UResourceBundle {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getNextResource ( resourcebundle : *mut UResourceBundle , fillin : *mut UResourceBundle , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_getNextResource(resourcebundle, fillin, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getNextString(resourcebundle: *mut UResourceBundle, len: *mut i32, key: *const *const i8, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getNextString ( resourcebundle : *mut UResourceBundle , len : *mut i32 , key : *const *const i8 , status : *mut UErrorCode ) -> *mut u16 );
    ures_getNextString(resourcebundle, len, key, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getSize(resourcebundle: *const UResourceBundle) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getSize ( resourcebundle : *const UResourceBundle ) -> i32 );
    ures_getSize(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getString(resourcebundle: *const UResourceBundle, len: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getString ( resourcebundle : *const UResourceBundle , len : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    ures_getString(resourcebundle, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getStringByIndex(resourcebundle: *const UResourceBundle, indexs: i32, len: *mut i32, status: *mut UErrorCode) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getStringByIndex ( resourcebundle : *const UResourceBundle , indexs : i32 , len : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    ures_getStringByIndex(resourcebundle, indexs, len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getStringByKey<P0>(resb: *const UResourceBundle, key: P0, len: *mut i32, status: *mut UErrorCode) -> *mut u16
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getStringByKey ( resb : *const UResourceBundle , key : :: windows::core::PCSTR , len : *mut i32 , status : *mut UErrorCode ) -> *mut u16 );
    ures_getStringByKey(resb, key.into_param().abi(), len, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getType(resourcebundle: *const UResourceBundle) -> UResType {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getType ( resourcebundle : *const UResourceBundle ) -> UResType );
    ures_getType(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getUInt(resourcebundle: *const UResourceBundle, status: *mut UErrorCode) -> u32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getUInt ( resourcebundle : *const UResourceBundle , status : *mut UErrorCode ) -> u32 );
    ures_getUInt(resourcebundle, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getUTF8String<P0>(resb: *const UResourceBundle, dest: P0, length: *mut i32, forcecopy: i8, status: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getUTF8String ( resb : *const UResourceBundle , dest : :: windows::core::PCSTR , length : *mut i32 , forcecopy : i8 , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ures_getUTF8String(resb, dest.into_param().abi(), length, forcecopy, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getUTF8StringByIndex<P0>(resb: *const UResourceBundle, stringindex: i32, dest: P0, plength: *mut i32, forcecopy: i8, status: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getUTF8StringByIndex ( resb : *const UResourceBundle , stringindex : i32 , dest : :: windows::core::PCSTR , plength : *mut i32 , forcecopy : i8 , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ures_getUTF8StringByIndex(resb, stringindex, dest.into_param().abi(), plength, forcecopy, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getUTF8StringByKey<P0, P1>(resb: *const UResourceBundle, key: P0, dest: P1, plength: *mut i32, forcecopy: i8, status: *mut UErrorCode) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getUTF8StringByKey ( resb : *const UResourceBundle , key : :: windows::core::PCSTR , dest : :: windows::core::PCSTR , plength : *mut i32 , forcecopy : i8 , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    ures_getUTF8StringByKey(resb, key.into_param().abi(), dest.into_param().abi(), plength, forcecopy, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_getVersion(resb: *const UResourceBundle, versioninfo: *mut u8) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_getVersion ( resb : *const UResourceBundle , versioninfo : *mut u8 ) -> ( ) );
    ures_getVersion(resb, versioninfo)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_hasNext(resourcebundle: *const UResourceBundle) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_hasNext ( resourcebundle : *const UResourceBundle ) -> i8 );
    ures_hasNext(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_open<P0, P1>(packagename: P0, locale: P1, status: *mut UErrorCode) -> *mut UResourceBundle
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_open ( packagename : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_open(packagename.into_param().abi(), locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_openAvailableLocales<P0>(packagename: P0, status: *mut UErrorCode) -> *mut UEnumeration
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_openAvailableLocales ( packagename : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UEnumeration );
    ures_openAvailableLocales(packagename.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_openDirect<P0, P1>(packagename: P0, locale: P1, status: *mut UErrorCode) -> *mut UResourceBundle
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_openDirect ( packagename : :: windows::core::PCSTR , locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_openDirect(packagename.into_param().abi(), locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_openU<P0>(packagename: *const u16, locale: P0, status: *mut UErrorCode) -> *mut UResourceBundle
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_openU ( packagename : *const u16 , locale : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UResourceBundle );
    ures_openU(packagename, locale.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn ures_resetIterator(resourcebundle: *mut UResourceBundle) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn ures_resetIterator ( resourcebundle : *mut UResourceBundle ) -> ( ) );
    ures_resetIterator(resourcebundle)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_breaksBetweenLetters(script: UScriptCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_breaksBetweenLetters ( script : UScriptCode ) -> i8 );
    uscript_breaksBetweenLetters(script)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getCode<P0>(nameorabbrorlocale: P0, fillin: *mut UScriptCode, capacity: i32, err: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getCode ( nameorabbrorlocale : :: windows::core::PCSTR , fillin : *mut UScriptCode , capacity : i32 , err : *mut UErrorCode ) -> i32 );
    uscript_getCode(nameorabbrorlocale.into_param().abi(), fillin, capacity, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getName(scriptcode: UScriptCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getName ( scriptcode : UScriptCode ) -> :: windows::core::PSTR );
    uscript_getName(scriptcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getSampleString(script: UScriptCode, dest: *mut u16, capacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getSampleString ( script : UScriptCode , dest : *mut u16 , capacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uscript_getSampleString(script, dest, capacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getScript(codepoint: i32, err: *mut UErrorCode) -> UScriptCode {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getScript ( codepoint : i32 , err : *mut UErrorCode ) -> UScriptCode );
    uscript_getScript(codepoint, err)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getScriptExtensions(c: i32, scripts: *mut UScriptCode, capacity: i32, errorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getScriptExtensions ( c : i32 , scripts : *mut UScriptCode , capacity : i32 , errorcode : *mut UErrorCode ) -> i32 );
    uscript_getScriptExtensions(c, scripts, capacity, errorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getShortName(scriptcode: UScriptCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getShortName ( scriptcode : UScriptCode ) -> :: windows::core::PSTR );
    uscript_getShortName(scriptcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_getUsage(script: UScriptCode) -> UScriptUsage {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_getUsage ( script : UScriptCode ) -> UScriptUsage );
    uscript_getUsage(script)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_hasScript(c: i32, sc: UScriptCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_hasScript ( c : i32 , sc : UScriptCode ) -> i8 );
    uscript_hasScript(c, sc)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_isCased(script: UScriptCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_isCased ( script : UScriptCode ) -> i8 );
    uscript_isCased(script)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uscript_isRightToLeft(script: UScriptCode) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uscript_isRightToLeft ( script : UScriptCode ) -> i8 );
    uscript_isRightToLeft(script)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_close(searchiter: *mut UStringSearch) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_close ( searchiter : *mut UStringSearch ) -> ( ) );
    usearch_close(searchiter)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_first(strsrch: *mut UStringSearch, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_first ( strsrch : *mut UStringSearch , status : *mut UErrorCode ) -> i32 );
    usearch_first(strsrch, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_following(strsrch: *mut UStringSearch, position: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_following ( strsrch : *mut UStringSearch , position : i32 , status : *mut UErrorCode ) -> i32 );
    usearch_following(strsrch, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getAttribute(strsrch: *const UStringSearch, attribute: USearchAttribute) -> USearchAttributeValue {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getAttribute ( strsrch : *const UStringSearch , attribute : USearchAttribute ) -> USearchAttributeValue );
    usearch_getAttribute(strsrch, attribute)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getBreakIterator(strsrch: *const UStringSearch) -> *mut UBreakIterator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getBreakIterator ( strsrch : *const UStringSearch ) -> *mut UBreakIterator );
    usearch_getBreakIterator(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getCollator(strsrch: *const UStringSearch) -> *mut UCollator {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getCollator ( strsrch : *const UStringSearch ) -> *mut UCollator );
    usearch_getCollator(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getMatchedLength(strsrch: *const UStringSearch) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getMatchedLength ( strsrch : *const UStringSearch ) -> i32 );
    usearch_getMatchedLength(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getMatchedStart(strsrch: *const UStringSearch) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getMatchedStart ( strsrch : *const UStringSearch ) -> i32 );
    usearch_getMatchedStart(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getMatchedText(strsrch: *const UStringSearch, result: *mut u16, resultcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getMatchedText ( strsrch : *const UStringSearch , result : *mut u16 , resultcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    usearch_getMatchedText(strsrch, result, resultcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getOffset(strsrch: *const UStringSearch) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getOffset ( strsrch : *const UStringSearch ) -> i32 );
    usearch_getOffset(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getPattern(strsrch: *const UStringSearch, length: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getPattern ( strsrch : *const UStringSearch , length : *mut i32 ) -> *mut u16 );
    usearch_getPattern(strsrch, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_getText(strsrch: *const UStringSearch, length: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_getText ( strsrch : *const UStringSearch , length : *mut i32 ) -> *mut u16 );
    usearch_getText(strsrch, length)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_last(strsrch: *mut UStringSearch, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_last ( strsrch : *mut UStringSearch , status : *mut UErrorCode ) -> i32 );
    usearch_last(strsrch, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_next(strsrch: *mut UStringSearch, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_next ( strsrch : *mut UStringSearch , status : *mut UErrorCode ) -> i32 );
    usearch_next(strsrch, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_open<P0>(pattern: *const u16, patternlength: i32, text: *const u16, textlength: i32, locale: P0, breakiter: *mut UBreakIterator, status: *mut UErrorCode) -> *mut UStringSearch
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_open ( pattern : *const u16 , patternlength : i32 , text : *const u16 , textlength : i32 , locale : :: windows::core::PCSTR , breakiter : *mut UBreakIterator , status : *mut UErrorCode ) -> *mut UStringSearch );
    usearch_open(pattern, patternlength, text, textlength, locale.into_param().abi(), breakiter, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_openFromCollator(pattern: *const u16, patternlength: i32, text: *const u16, textlength: i32, collator: *const UCollator, breakiter: *mut UBreakIterator, status: *mut UErrorCode) -> *mut UStringSearch {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_openFromCollator ( pattern : *const u16 , patternlength : i32 , text : *const u16 , textlength : i32 , collator : *const UCollator , breakiter : *mut UBreakIterator , status : *mut UErrorCode ) -> *mut UStringSearch );
    usearch_openFromCollator(pattern, patternlength, text, textlength, collator, breakiter, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_preceding(strsrch: *mut UStringSearch, position: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_preceding ( strsrch : *mut UStringSearch , position : i32 , status : *mut UErrorCode ) -> i32 );
    usearch_preceding(strsrch, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_previous(strsrch: *mut UStringSearch, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_previous ( strsrch : *mut UStringSearch , status : *mut UErrorCode ) -> i32 );
    usearch_previous(strsrch, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_reset(strsrch: *mut UStringSearch) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_reset ( strsrch : *mut UStringSearch ) -> ( ) );
    usearch_reset(strsrch)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setAttribute(strsrch: *mut UStringSearch, attribute: USearchAttribute, value: USearchAttributeValue, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setAttribute ( strsrch : *mut UStringSearch , attribute : USearchAttribute , value : USearchAttributeValue , status : *mut UErrorCode ) -> ( ) );
    usearch_setAttribute(strsrch, attribute, value, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setBreakIterator(strsrch: *mut UStringSearch, breakiter: *mut UBreakIterator, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setBreakIterator ( strsrch : *mut UStringSearch , breakiter : *mut UBreakIterator , status : *mut UErrorCode ) -> ( ) );
    usearch_setBreakIterator(strsrch, breakiter, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setCollator(strsrch: *mut UStringSearch, collator: *const UCollator, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setCollator ( strsrch : *mut UStringSearch , collator : *const UCollator , status : *mut UErrorCode ) -> ( ) );
    usearch_setCollator(strsrch, collator, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setOffset(strsrch: *mut UStringSearch, position: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setOffset ( strsrch : *mut UStringSearch , position : i32 , status : *mut UErrorCode ) -> ( ) );
    usearch_setOffset(strsrch, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setPattern(strsrch: *mut UStringSearch, pattern: *const u16, patternlength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setPattern ( strsrch : *mut UStringSearch , pattern : *const u16 , patternlength : i32 , status : *mut UErrorCode ) -> ( ) );
    usearch_setPattern(strsrch, pattern, patternlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usearch_setText(strsrch: *mut UStringSearch, text: *const u16, textlength: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usearch_setText ( strsrch : *mut UStringSearch , text : *const u16 , textlength : i32 , status : *mut UErrorCode ) -> ( ) );
    usearch_setText(strsrch, text, textlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_add(set: *mut USet, c: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_add ( set : *mut USet , c : i32 ) -> ( ) );
    uset_add(set, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_addAll(set: *mut USet, additionalset: *const USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_addAll ( set : *mut USet , additionalset : *const USet ) -> ( ) );
    uset_addAll(set, additionalset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_addAllCodePoints(set: *mut USet, str: *const u16, strlen: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_addAllCodePoints ( set : *mut USet , str : *const u16 , strlen : i32 ) -> ( ) );
    uset_addAllCodePoints(set, str, strlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_addRange(set: *mut USet, start: i32, end: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_addRange ( set : *mut USet , start : i32 , end : i32 ) -> ( ) );
    uset_addRange(set, start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_addString(set: *mut USet, str: *const u16, strlen: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_addString ( set : *mut USet , str : *const u16 , strlen : i32 ) -> ( ) );
    uset_addString(set, str, strlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_applyIntPropertyValue(set: *mut USet, prop: UProperty, value: i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_applyIntPropertyValue ( set : *mut USet , prop : UProperty , value : i32 , ec : *mut UErrorCode ) -> ( ) );
    uset_applyIntPropertyValue(set, prop, value, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_applyPattern(set: *mut USet, pattern: *const u16, patternlength: i32, options: u32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_applyPattern ( set : *mut USet , pattern : *const u16 , patternlength : i32 , options : u32 , status : *mut UErrorCode ) -> i32 );
    uset_applyPattern(set, pattern, patternlength, options, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_applyPropertyAlias(set: *mut USet, prop: *const u16, proplength: i32, value: *const u16, valuelength: i32, ec: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_applyPropertyAlias ( set : *mut USet , prop : *const u16 , proplength : i32 , value : *const u16 , valuelength : i32 , ec : *mut UErrorCode ) -> ( ) );
    uset_applyPropertyAlias(set, prop, proplength, value, valuelength, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_charAt(set: *const USet, charindex: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_charAt ( set : *const USet , charindex : i32 ) -> i32 );
    uset_charAt(set, charindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_clear(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_clear ( set : *mut USet ) -> ( ) );
    uset_clear(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_clone(set: *const USet) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_clone ( set : *const USet ) -> *mut USet );
    uset_clone(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_cloneAsThawed(set: *const USet) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_cloneAsThawed ( set : *const USet ) -> *mut USet );
    uset_cloneAsThawed(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_close(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_close ( set : *mut USet ) -> ( ) );
    uset_close(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_closeOver(set: *mut USet, attributes: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_closeOver ( set : *mut USet , attributes : i32 ) -> ( ) );
    uset_closeOver(set, attributes)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_compact(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_compact ( set : *mut USet ) -> ( ) );
    uset_compact(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_complement(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_complement ( set : *mut USet ) -> ( ) );
    uset_complement(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_complementAll(set: *mut USet, complement: *const USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_complementAll ( set : *mut USet , complement : *const USet ) -> ( ) );
    uset_complementAll(set, complement)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_contains(set: *const USet, c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_contains ( set : *const USet , c : i32 ) -> i8 );
    uset_contains(set, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsAll(set1: *const USet, set2: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsAll ( set1 : *const USet , set2 : *const USet ) -> i8 );
    uset_containsAll(set1, set2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsAllCodePoints(set: *const USet, str: *const u16, strlen: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsAllCodePoints ( set : *const USet , str : *const u16 , strlen : i32 ) -> i8 );
    uset_containsAllCodePoints(set, str, strlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsNone(set1: *const USet, set2: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsNone ( set1 : *const USet , set2 : *const USet ) -> i8 );
    uset_containsNone(set1, set2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsRange(set: *const USet, start: i32, end: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsRange ( set : *const USet , start : i32 , end : i32 ) -> i8 );
    uset_containsRange(set, start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsSome(set1: *const USet, set2: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsSome ( set1 : *const USet , set2 : *const USet ) -> i8 );
    uset_containsSome(set1, set2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_containsString(set: *const USet, str: *const u16, strlen: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_containsString ( set : *const USet , str : *const u16 , strlen : i32 ) -> i8 );
    uset_containsString(set, str, strlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_equals(set1: *const USet, set2: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_equals ( set1 : *const USet , set2 : *const USet ) -> i8 );
    uset_equals(set1, set2)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_freeze(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_freeze ( set : *mut USet ) -> ( ) );
    uset_freeze(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_getItem(set: *const USet, itemindex: i32, start: *mut i32, end: *mut i32, str: *mut u16, strcapacity: i32, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_getItem ( set : *const USet , itemindex : i32 , start : *mut i32 , end : *mut i32 , str : *mut u16 , strcapacity : i32 , ec : *mut UErrorCode ) -> i32 );
    uset_getItem(set, itemindex, start, end, str, strcapacity, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_getItemCount(set: *const USet) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_getItemCount ( set : *const USet ) -> i32 );
    uset_getItemCount(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_getSerializedRange(set: *const USerializedSet, rangeindex: i32, pstart: *mut i32, pend: *mut i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_getSerializedRange ( set : *const USerializedSet , rangeindex : i32 , pstart : *mut i32 , pend : *mut i32 ) -> i8 );
    uset_getSerializedRange(set, rangeindex, pstart, pend)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_getSerializedRangeCount(set: *const USerializedSet) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_getSerializedRangeCount ( set : *const USerializedSet ) -> i32 );
    uset_getSerializedRangeCount(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_getSerializedSet(fillset: *mut USerializedSet, src: *const u16, srclength: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_getSerializedSet ( fillset : *mut USerializedSet , src : *const u16 , srclength : i32 ) -> i8 );
    uset_getSerializedSet(fillset, src, srclength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_indexOf(set: *const USet, c: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_indexOf ( set : *const USet , c : i32 ) -> i32 );
    uset_indexOf(set, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_isEmpty(set: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_isEmpty ( set : *const USet ) -> i8 );
    uset_isEmpty(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_isFrozen(set: *const USet) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_isFrozen ( set : *const USet ) -> i8 );
    uset_isFrozen(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_open(start: i32, end: i32) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_open ( start : i32 , end : i32 ) -> *mut USet );
    uset_open(start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_openEmpty() -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_openEmpty ( ) -> *mut USet );
    uset_openEmpty()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_openPattern(pattern: *const u16, patternlength: i32, ec: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_openPattern ( pattern : *const u16 , patternlength : i32 , ec : *mut UErrorCode ) -> *mut USet );
    uset_openPattern(pattern, patternlength, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_openPatternOptions(pattern: *const u16, patternlength: i32, options: u32, ec: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_openPatternOptions ( pattern : *const u16 , patternlength : i32 , options : u32 , ec : *mut UErrorCode ) -> *mut USet );
    uset_openPatternOptions(pattern, patternlength, options, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_remove(set: *mut USet, c: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_remove ( set : *mut USet , c : i32 ) -> ( ) );
    uset_remove(set, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_removeAll(set: *mut USet, removeset: *const USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_removeAll ( set : *mut USet , removeset : *const USet ) -> ( ) );
    uset_removeAll(set, removeset)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_removeAllStrings(set: *mut USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_removeAllStrings ( set : *mut USet ) -> ( ) );
    uset_removeAllStrings(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_removeRange(set: *mut USet, start: i32, end: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_removeRange ( set : *mut USet , start : i32 , end : i32 ) -> ( ) );
    uset_removeRange(set, start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_removeString(set: *mut USet, str: *const u16, strlen: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_removeString ( set : *mut USet , str : *const u16 , strlen : i32 ) -> ( ) );
    uset_removeString(set, str, strlen)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_resemblesPattern(pattern: *const u16, patternlength: i32, pos: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_resemblesPattern ( pattern : *const u16 , patternlength : i32 , pos : i32 ) -> i8 );
    uset_resemblesPattern(pattern, patternlength, pos)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_retain(set: *mut USet, start: i32, end: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_retain ( set : *mut USet , start : i32 , end : i32 ) -> ( ) );
    uset_retain(set, start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_retainAll(set: *mut USet, retain: *const USet) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_retainAll ( set : *mut USet , retain : *const USet ) -> ( ) );
    uset_retainAll(set, retain)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_serialize(set: *const USet, dest: *mut u16, destcapacity: i32, perrorcode: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_serialize ( set : *const USet , dest : *mut u16 , destcapacity : i32 , perrorcode : *mut UErrorCode ) -> i32 );
    uset_serialize(set, dest, destcapacity, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_serializedContains(set: *const USerializedSet, c: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_serializedContains ( set : *const USerializedSet , c : i32 ) -> i8 );
    uset_serializedContains(set, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_set(set: *mut USet, start: i32, end: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_set ( set : *mut USet , start : i32 , end : i32 ) -> ( ) );
    uset_set(set, start, end)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_setSerializedToOne(fillset: *mut USerializedSet, c: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_setSerializedToOne ( fillset : *mut USerializedSet , c : i32 ) -> ( ) );
    uset_setSerializedToOne(fillset, c)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_size(set: *const USet) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_size ( set : *const USet ) -> i32 );
    uset_size(set)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_span(set: *const USet, s: *const u16, length: i32, spancondition: USetSpanCondition) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_span ( set : *const USet , s : *const u16 , length : i32 , spancondition : USetSpanCondition ) -> i32 );
    uset_span(set, s, length, spancondition)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_spanBack(set: *const USet, s: *const u16, length: i32, spancondition: USetSpanCondition) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_spanBack ( set : *const USet , s : *const u16 , length : i32 , spancondition : USetSpanCondition ) -> i32 );
    uset_spanBack(set, s, length, spancondition)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_spanBackUTF8<P0>(set: *const USet, s: P0, length: i32, spancondition: USetSpanCondition) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_spanBackUTF8 ( set : *const USet , s : :: windows::core::PCSTR , length : i32 , spancondition : USetSpanCondition ) -> i32 );
    uset_spanBackUTF8(set, s.into_param().abi(), length, spancondition)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_spanUTF8<P0>(set: *const USet, s: P0, length: i32, spancondition: USetSpanCondition) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_spanUTF8 ( set : *const USet , s : :: windows::core::PCSTR , length : i32 , spancondition : USetSpanCondition ) -> i32 );
    uset_spanUTF8(set, s.into_param().abi(), length, spancondition)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uset_toPattern(set: *const USet, result: *mut u16, resultcapacity: i32, escapeunprintable: i8, ec: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uset_toPattern ( set : *const USet , result : *mut u16 , resultcapacity : i32 , escapeunprintable : i8 , ec : *mut UErrorCode ) -> i32 );
    uset_toPattern(set, result, resultcapacity, escapeunprintable, ec)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_areConfusable(sc: *const USpoofChecker, id1: *const u16, length1: i32, id2: *const u16, length2: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_areConfusable ( sc : *const USpoofChecker , id1 : *const u16 , length1 : i32 , id2 : *const u16 , length2 : i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_areConfusable(sc, id1, length1, id2, length2, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_areConfusableUTF8<P0, P1>(sc: *const USpoofChecker, id1: P0, length1: i32, id2: P1, length2: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_areConfusableUTF8 ( sc : *const USpoofChecker , id1 : :: windows::core::PCSTR , length1 : i32 , id2 : :: windows::core::PCSTR , length2 : i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_areConfusableUTF8(sc, id1.into_param().abi(), length1, id2.into_param().abi(), length2, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_check(sc: *const USpoofChecker, id: *const u16, length: i32, position: *mut i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_check ( sc : *const USpoofChecker , id : *const u16 , length : i32 , position : *mut i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_check(sc, id, length, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_check2(sc: *const USpoofChecker, id: *const u16, length: i32, checkresult: *mut USpoofCheckResult, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_check2 ( sc : *const USpoofChecker , id : *const u16 , length : i32 , checkresult : *mut USpoofCheckResult , status : *mut UErrorCode ) -> i32 );
    uspoof_check2(sc, id, length, checkresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_check2UTF8<P0>(sc: *const USpoofChecker, id: P0, length: i32, checkresult: *mut USpoofCheckResult, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_check2UTF8 ( sc : *const USpoofChecker , id : :: windows::core::PCSTR , length : i32 , checkresult : *mut USpoofCheckResult , status : *mut UErrorCode ) -> i32 );
    uspoof_check2UTF8(sc, id.into_param().abi(), length, checkresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_checkUTF8<P0>(sc: *const USpoofChecker, id: P0, length: i32, position: *mut i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_checkUTF8 ( sc : *const USpoofChecker , id : :: windows::core::PCSTR , length : i32 , position : *mut i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_checkUTF8(sc, id.into_param().abi(), length, position, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_clone(sc: *const USpoofChecker, status: *mut UErrorCode) -> *mut USpoofChecker {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_clone ( sc : *const USpoofChecker , status : *mut UErrorCode ) -> *mut USpoofChecker );
    uspoof_clone(sc, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_close(sc: *mut USpoofChecker) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_close ( sc : *mut USpoofChecker ) -> ( ) );
    uspoof_close(sc)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_closeCheckResult(checkresult: *mut USpoofCheckResult) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_closeCheckResult ( checkresult : *mut USpoofCheckResult ) -> ( ) );
    uspoof_closeCheckResult(checkresult)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getAllowedChars(sc: *const USpoofChecker, status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getAllowedChars ( sc : *const USpoofChecker , status : *mut UErrorCode ) -> *mut USet );
    uspoof_getAllowedChars(sc, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getAllowedLocales(sc: *mut USpoofChecker, status: *mut UErrorCode) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getAllowedLocales ( sc : *mut USpoofChecker , status : *mut UErrorCode ) -> :: windows::core::PSTR );
    uspoof_getAllowedLocales(sc, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getCheckResultChecks(checkresult: *const USpoofCheckResult, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getCheckResultChecks ( checkresult : *const USpoofCheckResult , status : *mut UErrorCode ) -> i32 );
    uspoof_getCheckResultChecks(checkresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getCheckResultNumerics(checkresult: *const USpoofCheckResult, status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getCheckResultNumerics ( checkresult : *const USpoofCheckResult , status : *mut UErrorCode ) -> *mut USet );
    uspoof_getCheckResultNumerics(checkresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getCheckResultRestrictionLevel(checkresult: *const USpoofCheckResult, status: *mut UErrorCode) -> URestrictionLevel {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getCheckResultRestrictionLevel ( checkresult : *const USpoofCheckResult , status : *mut UErrorCode ) -> URestrictionLevel );
    uspoof_getCheckResultRestrictionLevel(checkresult, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getChecks(sc: *const USpoofChecker, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getChecks ( sc : *const USpoofChecker , status : *mut UErrorCode ) -> i32 );
    uspoof_getChecks(sc, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getInclusionSet(status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getInclusionSet ( status : *mut UErrorCode ) -> *mut USet );
    uspoof_getInclusionSet(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getRecommendedSet(status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getRecommendedSet ( status : *mut UErrorCode ) -> *mut USet );
    uspoof_getRecommendedSet(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getRestrictionLevel(sc: *const USpoofChecker) -> URestrictionLevel {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getRestrictionLevel ( sc : *const USpoofChecker ) -> URestrictionLevel );
    uspoof_getRestrictionLevel(sc)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getSkeleton(sc: *const USpoofChecker, r#type: u32, id: *const u16, length: i32, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getSkeleton ( sc : *const USpoofChecker , r#type : u32 , id : *const u16 , length : i32 , dest : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_getSkeleton(sc, r#type, id, length, dest, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_getSkeletonUTF8<P0, P1>(sc: *const USpoofChecker, r#type: u32, id: P0, length: i32, dest: P1, destcapacity: i32, status: *mut UErrorCode) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_getSkeletonUTF8 ( sc : *const USpoofChecker , r#type : u32 , id : :: windows::core::PCSTR , length : i32 , dest : :: windows::core::PCSTR , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_getSkeletonUTF8(sc, r#type, id.into_param().abi(), length, dest.into_param().abi(), destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_open(status: *mut UErrorCode) -> *mut USpoofChecker {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_open ( status : *mut UErrorCode ) -> *mut USpoofChecker );
    uspoof_open(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_openCheckResult(status: *mut UErrorCode) -> *mut USpoofCheckResult {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_openCheckResult ( status : *mut UErrorCode ) -> *mut USpoofCheckResult );
    uspoof_openCheckResult(status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_openFromSerialized(data: *const ::core::ffi::c_void, length: i32, pactuallength: *mut i32, perrorcode: *mut UErrorCode) -> *mut USpoofChecker {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_openFromSerialized ( data : *const ::core::ffi::c_void , length : i32 , pactuallength : *mut i32 , perrorcode : *mut UErrorCode ) -> *mut USpoofChecker );
    uspoof_openFromSerialized(data, length, pactuallength, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_openFromSource<P0, P1>(confusables: P0, confusableslen: i32, confusableswholescript: P1, confusableswholescriptlen: i32, errtype: *mut i32, pe: *mut UParseError, status: *mut UErrorCode) -> *mut USpoofChecker
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_openFromSource ( confusables : :: windows::core::PCSTR , confusableslen : i32 , confusableswholescript : :: windows::core::PCSTR , confusableswholescriptlen : i32 , errtype : *mut i32 , pe : *mut UParseError , status : *mut UErrorCode ) -> *mut USpoofChecker );
    uspoof_openFromSource(confusables.into_param().abi(), confusableslen, confusableswholescript.into_param().abi(), confusableswholescriptlen, errtype, pe, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_serialize(sc: *mut USpoofChecker, data: *mut ::core::ffi::c_void, capacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_serialize ( sc : *mut USpoofChecker , data : *mut ::core::ffi::c_void , capacity : i32 , status : *mut UErrorCode ) -> i32 );
    uspoof_serialize(sc, data, capacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_setAllowedChars(sc: *mut USpoofChecker, chars: *const USet, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_setAllowedChars ( sc : *mut USpoofChecker , chars : *const USet , status : *mut UErrorCode ) -> ( ) );
    uspoof_setAllowedChars(sc, chars, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_setAllowedLocales<P0>(sc: *mut USpoofChecker, localeslist: P0, status: *mut UErrorCode)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_setAllowedLocales ( sc : *mut USpoofChecker , localeslist : :: windows::core::PCSTR , status : *mut UErrorCode ) -> ( ) );
    uspoof_setAllowedLocales(sc, localeslist.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_setChecks(sc: *mut USpoofChecker, checks: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_setChecks ( sc : *mut USpoofChecker , checks : i32 , status : *mut UErrorCode ) -> ( ) );
    uspoof_setChecks(sc, checks, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn uspoof_setRestrictionLevel(sc: *mut USpoofChecker, restrictionlevel: URestrictionLevel) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn uspoof_setRestrictionLevel ( sc : *mut USpoofChecker , restrictionlevel : URestrictionLevel ) -> ( ) );
    uspoof_setRestrictionLevel(sc, restrictionlevel)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usprep_close(profile: *mut UStringPrepProfile) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usprep_close ( profile : *mut UStringPrepProfile ) -> ( ) );
    usprep_close(profile)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usprep_open<P0, P1>(path: P0, filename: P1, status: *mut UErrorCode) -> *mut UStringPrepProfile
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usprep_open ( path : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , status : *mut UErrorCode ) -> *mut UStringPrepProfile );
    usprep_open(path.into_param().abi(), filename.into_param().abi(), status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usprep_openByType(r#type: UStringPrepProfileType, status: *mut UErrorCode) -> *mut UStringPrepProfile {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usprep_openByType ( r#type : UStringPrepProfileType , status : *mut UErrorCode ) -> *mut UStringPrepProfile );
    usprep_openByType(r#type, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn usprep_prepare(prep: *const UStringPrepProfile, src: *const u16, srclength: i32, dest: *mut u16, destcapacity: i32, options: i32, parseerror: *mut UParseError, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn usprep_prepare ( prep : *const UStringPrepProfile , src : *const u16 , srclength : i32 , dest : *mut u16 , destcapacity : i32 , options : i32 , parseerror : *mut UParseError , status : *mut UErrorCode ) -> i32 );
    usprep_prepare(prep, src, srclength, dest, destcapacity, options, parseerror, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_char32At(ut: *mut UText, nativeindex: i64) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_char32At ( ut : *mut UText , nativeindex : i64 ) -> i32 );
    utext_char32At(ut, nativeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_clone(dest: *mut UText, src: *const UText, deep: i8, readonly: i8, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_clone ( dest : *mut UText , src : *const UText , deep : i8 , readonly : i8 , status : *mut UErrorCode ) -> *mut UText );
    utext_clone(dest, src, deep, readonly, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_close(ut: *mut UText) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_close ( ut : *mut UText ) -> *mut UText );
    utext_close(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_copy(ut: *mut UText, nativestart: i64, nativelimit: i64, destindex: i64, r#move: i8, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_copy ( ut : *mut UText , nativestart : i64 , nativelimit : i64 , destindex : i64 , r#move : i8 , status : *mut UErrorCode ) -> ( ) );
    utext_copy(ut, nativestart, nativelimit, destindex, r#move, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_current32(ut: *mut UText) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_current32 ( ut : *mut UText ) -> i32 );
    utext_current32(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_equals(a: *const UText, b: *const UText) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_equals ( a : *const UText , b : *const UText ) -> i8 );
    utext_equals(a, b)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_extract(ut: *mut UText, nativestart: i64, nativelimit: i64, dest: *mut u16, destcapacity: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_extract ( ut : *mut UText , nativestart : i64 , nativelimit : i64 , dest : *mut u16 , destcapacity : i32 , status : *mut UErrorCode ) -> i32 );
    utext_extract(ut, nativestart, nativelimit, dest, destcapacity, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_freeze(ut: *mut UText) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_freeze ( ut : *mut UText ) -> ( ) );
    utext_freeze(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_getNativeIndex(ut: *const UText) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_getNativeIndex ( ut : *const UText ) -> i64 );
    utext_getNativeIndex(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_getPreviousNativeIndex(ut: *mut UText) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_getPreviousNativeIndex ( ut : *mut UText ) -> i64 );
    utext_getPreviousNativeIndex(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_hasMetaData(ut: *const UText) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_hasMetaData ( ut : *const UText ) -> i8 );
    utext_hasMetaData(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_isLengthExpensive(ut: *const UText) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_isLengthExpensive ( ut : *const UText ) -> i8 );
    utext_isLengthExpensive(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_isWritable(ut: *const UText) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_isWritable ( ut : *const UText ) -> i8 );
    utext_isWritable(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_moveIndex32(ut: *mut UText, delta: i32) -> i8 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_moveIndex32 ( ut : *mut UText , delta : i32 ) -> i8 );
    utext_moveIndex32(ut, delta)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_nativeLength(ut: *mut UText) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_nativeLength ( ut : *mut UText ) -> i64 );
    utext_nativeLength(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_next32(ut: *mut UText) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_next32 ( ut : *mut UText ) -> i32 );
    utext_next32(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_next32From(ut: *mut UText, nativeindex: i64) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_next32From ( ut : *mut UText , nativeindex : i64 ) -> i32 );
    utext_next32From(ut, nativeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_openUChars(ut: *mut UText, s: *const u16, length: i64, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_openUChars ( ut : *mut UText , s : *const u16 , length : i64 , status : *mut UErrorCode ) -> *mut UText );
    utext_openUChars(ut, s, length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_openUTF8<P0>(ut: *mut UText, s: P0, length: i64, status: *mut UErrorCode) -> *mut UText
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_openUTF8 ( ut : *mut UText , s : :: windows::core::PCSTR , length : i64 , status : *mut UErrorCode ) -> *mut UText );
    utext_openUTF8(ut, s.into_param().abi(), length, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_previous32(ut: *mut UText) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_previous32 ( ut : *mut UText ) -> i32 );
    utext_previous32(ut)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_previous32From(ut: *mut UText, nativeindex: i64) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_previous32From ( ut : *mut UText , nativeindex : i64 ) -> i32 );
    utext_previous32From(ut, nativeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_replace(ut: *mut UText, nativestart: i64, nativelimit: i64, replacementtext: *const u16, replacementlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_replace ( ut : *mut UText , nativestart : i64 , nativelimit : i64 , replacementtext : *const u16 , replacementlength : i32 , status : *mut UErrorCode ) -> i32 );
    utext_replace(ut, nativestart, nativelimit, replacementtext, replacementlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_setNativeIndex(ut: *mut UText, nativeindex: i64) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_setNativeIndex ( ut : *mut UText , nativeindex : i64 ) -> ( ) );
    utext_setNativeIndex(ut, nativeindex)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utext_setup(ut: *mut UText, extraspace: i32, status: *mut UErrorCode) -> *mut UText {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utext_setup ( ut : *mut UText , extraspace : i32 , status : *mut UErrorCode ) -> *mut UText );
    utext_setup(ut, extraspace, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utf8_appendCharSafeBody(s: *mut u8, i: i32, length: i32, c: i32, piserror: *mut i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utf8_appendCharSafeBody ( s : *mut u8 , i : i32 , length : i32 , c : i32 , piserror : *mut i8 ) -> i32 );
    utf8_appendCharSafeBody(s, i, length, c, piserror)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utf8_back1SafeBody(s: *const u8, start: i32, i: i32) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utf8_back1SafeBody ( s : *const u8 , start : i32 , i : i32 ) -> i32 );
    utf8_back1SafeBody(s, start, i)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utf8_nextCharSafeBody(s: *const u8, pi: *mut i32, length: i32, c: i32, strict: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utf8_nextCharSafeBody ( s : *const u8 , pi : *mut i32 , length : i32 , c : i32 , strict : i8 ) -> i32 );
    utf8_nextCharSafeBody(s, pi, length, c, strict)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utf8_prevCharSafeBody(s: *const u8, start: i32, pi: *mut i32, c: i32, strict: i8) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utf8_prevCharSafeBody ( s : *const u8 , start : i32 , pi : *mut i32 , c : i32 , strict : i8 ) -> i32 );
    utf8_prevCharSafeBody(s, start, pi, c, strict)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utmscale_fromInt64(othertime: i64, timescale: UDateTimeScale, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utmscale_fromInt64 ( othertime : i64 , timescale : UDateTimeScale , status : *mut UErrorCode ) -> i64 );
    utmscale_fromInt64(othertime, timescale, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utmscale_getTimeScaleValue(timescale: UDateTimeScale, value: UTimeScaleValue, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utmscale_getTimeScaleValue ( timescale : UDateTimeScale , value : UTimeScaleValue , status : *mut UErrorCode ) -> i64 );
    utmscale_getTimeScaleValue(timescale, value, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utmscale_toInt64(universaltime: i64, timescale: UDateTimeScale, status: *mut UErrorCode) -> i64 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utmscale_toInt64 ( universaltime : i64 , timescale : UDateTimeScale , status : *mut UErrorCode ) -> i64 );
    utmscale_toInt64(universaltime, timescale, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_format<P0, P1>(outbuf: P0, capacity: i32, indent: i32, fmt: P1) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_format ( outbuf : :: windows::core::PCSTR , capacity : i32 , indent : i32 , fmt : :: windows::core::PCSTR ) -> i32 );
    utrace_format(outbuf.into_param().abi(), capacity, indent, fmt.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_functionName(fnnumber: i32) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_functionName ( fnnumber : i32 ) -> :: windows::core::PSTR );
    utrace_functionName(fnnumber)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_getFunctions(context: *const *const ::core::ffi::c_void, e: *mut UTraceEntry, x: *mut UTraceExit, d: *mut UTraceData) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_getFunctions ( context : *const *const ::core::ffi::c_void , e : *mut UTraceEntry , x : *mut UTraceExit , d : *mut UTraceData ) -> ( ) );
    utrace_getFunctions(context, e, x, d)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_getLevel() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_getLevel ( ) -> i32 );
    utrace_getLevel()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_setFunctions(context: *const ::core::ffi::c_void, e: UTraceEntry, x: UTraceExit, d: UTraceData) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_setFunctions ( context : *const ::core::ffi::c_void , e : UTraceEntry , x : UTraceExit , d : UTraceData ) -> ( ) );
    utrace_setFunctions(context, e, x, d)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_setLevel(tracelevel: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_setLevel ( tracelevel : i32 ) -> ( ) );
    utrace_setLevel(tracelevel)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrace_vformat<P0, P1>(outbuf: P0, capacity: i32, indent: i32, fmt: P1, args: *mut i8) -> i32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrace_vformat ( outbuf : :: windows::core::PCSTR , capacity : i32 , indent : i32 , fmt : :: windows::core::PCSTR , args : *mut i8 ) -> i32 );
    utrace_vformat(outbuf.into_param().abi(), capacity, indent, fmt.into_param().abi(), args)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_clone(trans: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_clone ( trans : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    utrans_clone(trans, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_close(trans: *mut *mut ::core::ffi::c_void) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_close ( trans : *mut *mut ::core::ffi::c_void ) -> ( ) );
    utrans_close(trans)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_countAvailableIDs() -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_countAvailableIDs ( ) -> i32 );
    utrans_countAvailableIDs()
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_getSourceSet(trans: *const *const ::core::ffi::c_void, ignorefilter: i8, fillin: *mut USet, status: *mut UErrorCode) -> *mut USet {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_getSourceSet ( trans : *const *const ::core::ffi::c_void , ignorefilter : i8 , fillin : *mut USet , status : *mut UErrorCode ) -> *mut USet );
    utrans_getSourceSet(trans, ignorefilter, fillin, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_getUnicodeID(trans: *const *const ::core::ffi::c_void, resultlength: *mut i32) -> *mut u16 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_getUnicodeID ( trans : *const *const ::core::ffi::c_void , resultlength : *mut i32 ) -> *mut u16 );
    utrans_getUnicodeID(trans, resultlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_openIDs(perrorcode: *mut UErrorCode) -> *mut UEnumeration {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_openIDs ( perrorcode : *mut UErrorCode ) -> *mut UEnumeration );
    utrans_openIDs(perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_openInverse(trans: *const *const ::core::ffi::c_void, status: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_openInverse ( trans : *const *const ::core::ffi::c_void , status : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    utrans_openInverse(trans, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_openU(id: *const u16, idlength: i32, dir: UTransDirection, rules: *const u16, ruleslength: i32, parseerror: *mut UParseError, perrorcode: *mut UErrorCode) -> *mut *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_openU ( id : *const u16 , idlength : i32 , dir : UTransDirection , rules : *const u16 , ruleslength : i32 , parseerror : *mut UParseError , perrorcode : *mut UErrorCode ) -> *mut *mut ::core::ffi::c_void );
    utrans_openU(id, idlength, dir, rules, ruleslength, parseerror, perrorcode)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_register(adoptedtrans: *mut *mut ::core::ffi::c_void, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_register ( adoptedtrans : *mut *mut ::core::ffi::c_void , status : *mut UErrorCode ) -> ( ) );
    utrans_register(adoptedtrans, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_setFilter(trans: *mut *mut ::core::ffi::c_void, filterpattern: *const u16, filterpatternlen: i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_setFilter ( trans : *mut *mut ::core::ffi::c_void , filterpattern : *const u16 , filterpatternlen : i32 , status : *mut UErrorCode ) -> ( ) );
    utrans_setFilter(trans, filterpattern, filterpatternlen, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_toRules(trans: *const *const ::core::ffi::c_void, escapeunprintable: i8, result: *mut u16, resultlength: i32, status: *mut UErrorCode) -> i32 {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_toRules ( trans : *const *const ::core::ffi::c_void , escapeunprintable : i8 , result : *mut u16 , resultlength : i32 , status : *mut UErrorCode ) -> i32 );
    utrans_toRules(trans, escapeunprintable, result, resultlength, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_trans(trans: *const *const ::core::ffi::c_void, rep: *mut *mut ::core::ffi::c_void, repfunc: *const UReplaceableCallbacks, start: i32, limit: *mut i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_trans ( trans : *const *const ::core::ffi::c_void , rep : *mut *mut ::core::ffi::c_void , repfunc : *const UReplaceableCallbacks , start : i32 , limit : *mut i32 , status : *mut UErrorCode ) -> ( ) );
    utrans_trans(trans, rep, repfunc, start, limit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_transIncremental(trans: *const *const ::core::ffi::c_void, rep: *mut *mut ::core::ffi::c_void, repfunc: *const UReplaceableCallbacks, pos: *mut UTransPosition, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_transIncremental ( trans : *const *const ::core::ffi::c_void , rep : *mut *mut ::core::ffi::c_void , repfunc : *const UReplaceableCallbacks , pos : *mut UTransPosition , status : *mut UErrorCode ) -> ( ) );
    utrans_transIncremental(trans, rep, repfunc, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_transIncrementalUChars(trans: *const *const ::core::ffi::c_void, text: *mut u16, textlength: *mut i32, textcapacity: i32, pos: *mut UTransPosition, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_transIncrementalUChars ( trans : *const *const ::core::ffi::c_void , text : *mut u16 , textlength : *mut i32 , textcapacity : i32 , pos : *mut UTransPosition , status : *mut UErrorCode ) -> ( ) );
    utrans_transIncrementalUChars(trans, text, textlength, textcapacity, pos, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_transUChars(trans: *const *const ::core::ffi::c_void, text: *mut u16, textlength: *mut i32, textcapacity: i32, start: i32, limit: *mut i32, status: *mut UErrorCode) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_transUChars ( trans : *const *const ::core::ffi::c_void , text : *mut u16 , textlength : *mut i32 , textcapacity : i32 , start : i32 , limit : *mut i32 , status : *mut UErrorCode ) -> ( ) );
    utrans_transUChars(trans, text, textlength, textcapacity, start, limit, status)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[inline]
pub unsafe fn utrans_unregisterID(id: *const u16, idlength: i32) {
    ::windows::imp::link ! ( "icu.dll""cdecl" fn utrans_unregisterID ( id : *const u16 , idlength : i32 ) -> ( ) );
    utrans_unregisterID(id, idlength)
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IComprehensiveSpellCheckProvider(::windows::core::IUnknown);
impl IComprehensiveSpellCheckProvider {
    pub unsafe fn ComprehensiveCheck<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).ComprehensiveCheck)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IComprehensiveSpellCheckProvider, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IComprehensiveSpellCheckProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IComprehensiveSpellCheckProvider {}
impl ::core::fmt::Debug for IComprehensiveSpellCheckProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IComprehensiveSpellCheckProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IComprehensiveSpellCheckProvider {
    type Vtable = IComprehensiveSpellCheckProvider_Vtbl;
}
impl ::core::clone::Clone for IComprehensiveSpellCheckProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IComprehensiveSpellCheckProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c58f8de_8e94_479e_9717_70c42c4ad2c3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IComprehensiveSpellCheckProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ComprehensiveCheck: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, text: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IEnumCodePage(::windows::core::IUnknown);
impl IEnumCodePage {
    pub unsafe fn Clone(&self, ppenum: ::core::option::Option<*const ::core::option::Option<IEnumCodePage>>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clone)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppenum.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut MIMECPINFO, pceltfetched: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), celt, rgelt, ::core::mem::transmute(pceltfetched.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::windows::core::Interface::as_raw(self), celt).ok()
    }
}
::windows::imp::interface_hierarchy!(IEnumCodePage, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IEnumCodePage {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumCodePage {}
impl ::core::fmt::Debug for IEnumCodePage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumCodePage").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumCodePage {
    type Vtable = IEnumCodePage_Vtbl;
}
impl ::core::clone::Clone for IEnumCodePage {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IEnumCodePage {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x275c23e3_3747_11d0_9fea_00aa003f8646);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumCodePage_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *const *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut MIMECPINFO, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IEnumRfc1766(::windows::core::IUnknown);
impl IEnumRfc1766 {
    pub unsafe fn Clone(&self, ppenum: ::core::option::Option<*const ::core::option::Option<IEnumRfc1766>>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clone)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppenum.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut RFC1766INFO, pceltfetched: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), celt, rgelt, ::core::mem::transmute(pceltfetched.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::windows::core::Interface::as_raw(self), celt).ok()
    }
}
::windows::imp::interface_hierarchy!(IEnumRfc1766, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IEnumRfc1766 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumRfc1766 {}
impl ::core::fmt::Debug for IEnumRfc1766 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumRfc1766").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumRfc1766 {
    type Vtable = IEnumRfc1766_Vtbl;
}
impl ::core::clone::Clone for IEnumRfc1766 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IEnumRfc1766 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3dc39d1d_c030_11d0_b81b_00c04fc9b31f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRfc1766_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *const *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut RFC1766INFO, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IEnumScript(::windows::core::IUnknown);
impl IEnumScript {
    pub unsafe fn Clone(&self, ppenum: ::core::option::Option<*const ::core::option::Option<IEnumScript>>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clone)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppenum.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut SCRIPTINFO, pceltfetched: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), celt, rgelt, ::core::mem::transmute(pceltfetched.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Skip)(::windows::core::Interface::as_raw(self), celt).ok()
    }
}
::windows::imp::interface_hierarchy!(IEnumScript, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IEnumScript {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumScript {}
impl ::core::fmt::Debug for IEnumScript {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumScript").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumScript {
    type Vtable = IEnumScript_Vtbl;
}
impl ::core::clone::Clone for IEnumScript {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IEnumScript {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xae5f1430_388b_11d2_8380_00c04f8f5da1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumScript_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *const *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut SCRIPTINFO, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IEnumSpellingError(::windows::core::IUnknown);
impl IEnumSpellingError {
    pub unsafe fn Next(&self) -> ::windows::core::Result<ISpellingError> {
        let mut result__ = ::windows::core::zeroed::<ISpellingError>();
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IEnumSpellingError, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IEnumSpellingError {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSpellingError {}
impl ::core::fmt::Debug for IEnumSpellingError {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSpellingError").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnumSpellingError {
    type Vtable = IEnumSpellingError_Vtbl;
}
impl ::core::clone::Clone for IEnumSpellingError {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IEnumSpellingError {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x803e3bd4_2828_4410_8290_418d1d73c762);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSpellingError_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangCodePages(::windows::core::IUnknown);
impl IMLangCodePages {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetCharCodePages)(::windows::core::Interface::as_raw(self), chsrc, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStrCodePages(&self, pszsrc: &[u16], dwprioritycodepages: u32, pdwcodepages: ::core::option::Option<*mut u32>, pcchcodepages: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStrCodePages)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, dwprioritycodepages, ::core::mem::transmute(pdwcodepages.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchcodepages.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).CodePageToCodePages)(::windows::core::Interface::as_raw(self), ucodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).CodePagesToCodePage)(::windows::core::Interface::as_raw(self), dwcodepages, udefaultcodepage, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IMLangCodePages, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangCodePages {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangCodePages {}
impl ::core::fmt::Debug for IMLangCodePages {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangCodePages").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangCodePages {
    type Vtable = IMLangCodePages_Vtbl;
}
impl ::core::clone::Clone for IMLangCodePages {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangCodePages {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x359f3443_bd4a_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangCodePages_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetCharCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, chsrc: u16, pdwcodepages: *mut u32) -> ::windows::core::HRESULT,
    pub GetStrCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsrc: ::windows::core::PCWSTR, cchsrc: i32, dwprioritycodepages: u32, pdwcodepages: *mut u32, pcchcodepages: *mut i32) -> ::windows::core::HRESULT,
    pub CodePageToCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ucodepage: u32, pdwcodepages: *mut u32) -> ::windows::core::HRESULT,
    pub CodePagesToCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcodepages: u32, udefaultcodepage: u32, pucodepage: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangConvertCharset(::windows::core::IUnknown);
impl IMLangConvertCharset {
    pub unsafe fn Initialize(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), uisrccodepage, uidstcodepage, dwproperty).ok()
    }
    pub unsafe fn GetSourceCodePage(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetSourceCodePage)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDestinationCodePage(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetDestinationCodePage)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetProperty(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProperty)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DoConversion(&self, psrcstr: *const u8, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: *mut u8, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoConversion)(::windows::core::Interface::as_raw(self), psrcstr, ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), pdststr, ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn DoConversionToUnicode<P0>(&self, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).DoConversionToUnicode)(::windows::core::Interface::as_raw(self), psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn DoConversionFromUnicode<P0>(&self, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DoConversionFromUnicode)(::windows::core::Interface::as_raw(self), psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangConvertCharset, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangConvertCharset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangConvertCharset {}
impl ::core::fmt::Debug for IMLangConvertCharset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangConvertCharset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangConvertCharset {
    type Vtable = IMLangConvertCharset_Vtbl;
}
impl ::core::clone::Clone for IMLangConvertCharset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangConvertCharset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd66d6f98_cdaa_11d0_b822_00c04fc9b31f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangConvertCharset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::core::HRESULT,
    pub GetSourceCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puisrccodepage: *mut u32) -> ::windows::core::HRESULT,
    pub GetDestinationCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puidstcodepage: *mut u32) -> ::windows::core::HRESULT,
    pub GetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwproperty: *mut u32) -> ::windows::core::HRESULT,
    pub DoConversion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub DoConversionToUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psrcstr: ::windows::core::PCSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PWSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub DoConversionFromUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psrcstr: ::windows::core::PCWSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangFontLink(::windows::core::IUnknown);
impl IMLangFontLink {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetCharCodePages)(::windows::core::Interface::as_raw(self), chsrc, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStrCodePages(&self, pszsrc: &[u16], dwprioritycodepages: u32, pdwcodepages: ::core::option::Option<*mut u32>, pcchcodepages: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetStrCodePages)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, dwprioritycodepages, ::core::mem::transmute(pdwcodepages.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchcodepages.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.CodePageToCodePages)(::windows::core::Interface::as_raw(self), ucodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.CodePagesToCodePage)(::windows::core::Interface::as_raw(self), dwcodepages, udefaultcodepage, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontCodePages<P0, P1>(&self, hdc: P0, hfont: P1, pdwcodepages: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
        P1: ::windows::core::IntoParam<super::Graphics::Gdi::HFONT>,
    {
        (::windows::core::Interface::vtable(self).GetFontCodePages)(::windows::core::Interface::as_raw(self), hdc.into_param().abi(), hfont.into_param().abi(), ::core::mem::transmute(pdwcodepages.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn MapFont<P0, P1>(&self, hdc: P0, dwcodepages: u32, hsrcfont: P1, phdestfont: ::core::option::Option<*mut super::Graphics::Gdi::HFONT>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
        P1: ::windows::core::IntoParam<super::Graphics::Gdi::HFONT>,
    {
        (::windows::core::Interface::vtable(self).MapFont)(::windows::core::Interface::as_raw(self), hdc.into_param().abi(), dwcodepages, hsrcfont.into_param().abi(), ::core::mem::transmute(phdestfont.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn ReleaseFont<P0>(&self, hfont: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HFONT>,
    {
        (::windows::core::Interface::vtable(self).ReleaseFont)(::windows::core::Interface::as_raw(self), hfont.into_param().abi()).ok()
    }
    pub unsafe fn ResetFontMapping(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetFontMapping)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangFontLink, ::windows::core::IUnknown, IMLangCodePages);
impl ::core::cmp::PartialEq for IMLangFontLink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangFontLink {}
impl ::core::fmt::Debug for IMLangFontLink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangFontLink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangFontLink {
    type Vtable = IMLangFontLink_Vtbl;
}
impl ::core::clone::Clone for IMLangFontLink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangFontLink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x359f3441_bd4a_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink_Vtbl {
    pub base__: IMLangCodePages_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetFontCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Graphics::Gdi::HDC, hfont: super::Graphics::Gdi::HFONT, pdwcodepages: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetFontCodePages: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub MapFont: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Graphics::Gdi::HDC, dwcodepages: u32, hsrcfont: super::Graphics::Gdi::HFONT, phdestfont: *mut super::Graphics::Gdi::HFONT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    MapFont: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub ReleaseFont: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hfont: super::Graphics::Gdi::HFONT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    ReleaseFont: usize,
    pub ResetFontMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangFontLink2(::windows::core::IUnknown);
impl IMLangFontLink2 {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetCharCodePages)(::windows::core::Interface::as_raw(self), chsrc, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStrCodePages(&self, pszsrc: &[u16], dwprioritycodepages: u32, pdwcodepages: ::core::option::Option<*mut u32>, pcchcodepages: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetStrCodePages)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, dwprioritycodepages, ::core::mem::transmute(pdwcodepages.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchcodepages.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.CodePageToCodePages)(::windows::core::Interface::as_raw(self), ucodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn CodePagesToCodePage(&self, dwcodepages: u32, udefaultcodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.CodePagesToCodePage)(::windows::core::Interface::as_raw(self), dwcodepages, udefaultcodepage, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontCodePages<P0, P1>(&self, hdc: P0, hfont: P1, pdwcodepages: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
        P1: ::windows::core::IntoParam<super::Graphics::Gdi::HFONT>,
    {
        (::windows::core::Interface::vtable(self).GetFontCodePages)(::windows::core::Interface::as_raw(self), hdc.into_param().abi(), hfont.into_param().abi(), ::core::mem::transmute(pdwcodepages.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn ReleaseFont<P0>(&self, hfont: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HFONT>,
    {
        (::windows::core::Interface::vtable(self).ReleaseFont)(::windows::core::Interface::as_raw(self), hfont.into_param().abi()).ok()
    }
    pub unsafe fn ResetFontMapping(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetFontMapping)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn MapFont<P0>(&self, hdc: P0, dwcodepages: u32, chsrc: u16, pfont: ::core::option::Option<*mut super::Graphics::Gdi::HFONT>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    {
        (::windows::core::Interface::vtable(self).MapFont)(::windows::core::Interface::as_raw(self), hdc.into_param().abi(), dwcodepages, chsrc, ::core::mem::transmute(pfont.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontUnicodeRanges<P0>(&self, hdc: P0, puiranges: *const u32, puranges: ::core::option::Option<*mut UNICODERANGE>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Graphics::Gdi::HDC>,
    {
        (::windows::core::Interface::vtable(self).GetFontUnicodeRanges)(::windows::core::Interface::as_raw(self), hdc.into_param().abi(), puiranges, ::core::mem::transmute(puranges.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetScriptFontInfo(&self, sid: u8, dwflags: u32, puifonts: *mut u32, pscriptfont: ::core::option::Option<*mut SCRIPTFONTINFO>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetScriptFontInfo)(::windows::core::Interface::as_raw(self), sid, dwflags, puifonts, ::core::mem::transmute(pscriptfont.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CodePageToScriptID(&self, uicodepage: u32) -> ::windows::core::Result<u8> {
        let mut result__ = ::windows::core::zeroed::<u8>();
        (::windows::core::Interface::vtable(self).CodePageToScriptID)(::windows::core::Interface::as_raw(self), uicodepage, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IMLangFontLink2, ::windows::core::IUnknown, IMLangCodePages);
impl ::core::cmp::PartialEq for IMLangFontLink2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangFontLink2 {}
impl ::core::fmt::Debug for IMLangFontLink2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangFontLink2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangFontLink2 {
    type Vtable = IMLangFontLink2_Vtbl;
}
impl ::core::clone::Clone for IMLangFontLink2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangFontLink2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdccfc162_2b38_11d2_b7ec_00c04f8f5d9a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink2_Vtbl {
    pub base__: IMLangCodePages_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetFontCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Graphics::Gdi::HDC, hfont: super::Graphics::Gdi::HFONT, pdwcodepages: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetFontCodePages: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub ReleaseFont: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hfont: super::Graphics::Gdi::HFONT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    ReleaseFont: usize,
    pub ResetFontMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub MapFont: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Graphics::Gdi::HDC, dwcodepages: u32, chsrc: u16, pfont: *mut super::Graphics::Gdi::HFONT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    MapFont: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetFontUnicodeRanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Graphics::Gdi::HDC, puiranges: *const u32, puranges: *mut UNICODERANGE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetFontUnicodeRanges: usize,
    pub GetScriptFontInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sid: u8, dwflags: u32, puifonts: *mut u32, pscriptfont: *mut SCRIPTFONTINFO) -> ::windows::core::HRESULT,
    pub CodePageToScriptID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, psid: *mut u8) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangLineBreakConsole(::windows::core::IUnknown);
impl IMLangLineBreakConsole {
    pub unsafe fn BreakLineML<P0>(&self, psrcmlstr: P0, lsrcpos: i32, lsrclen: i32, cmincolumns: i32, cmaxcolumns: i32, pllinelen: ::core::option::Option<*mut i32>, plskiplen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IMLangString>,
    {
        (::windows::core::Interface::vtable(self).BreakLineML)(::windows::core::Interface::as_raw(self), psrcmlstr.into_param().abi(), lsrcpos, lsrclen, cmincolumns, cmaxcolumns, ::core::mem::transmute(pllinelen.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plskiplen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BreakLineW(&self, locale: u32, pszsrc: &[u16], cmaxcolumns: i32, pcchline: ::core::option::Option<*mut i32>, pcchskip: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BreakLineW)(::windows::core::Interface::as_raw(self), locale, ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, cmaxcolumns, ::core::mem::transmute(pcchline.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchskip.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BreakLineA(&self, locale: u32, ucodepage: u32, pszsrc: &[u8], cmaxcolumns: i32, pcchline: ::core::option::Option<*mut i32>, pcchskip: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BreakLineA)(::windows::core::Interface::as_raw(self), locale, ucodepage, ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, cmaxcolumns, ::core::mem::transmute(pcchline.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchskip.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangLineBreakConsole, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangLineBreakConsole {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangLineBreakConsole {}
impl ::core::fmt::Debug for IMLangLineBreakConsole {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangLineBreakConsole").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangLineBreakConsole {
    type Vtable = IMLangLineBreakConsole_Vtbl;
}
impl ::core::clone::Clone for IMLangLineBreakConsole {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangLineBreakConsole {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf5be2ee1_bfd7_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangLineBreakConsole_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub BreakLineML: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psrcmlstr: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, cmincolumns: i32, cmaxcolumns: i32, pllinelen: *mut i32, plskiplen: *mut i32) -> ::windows::core::HRESULT,
    pub BreakLineW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, pszsrc: ::windows::core::PCWSTR, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::core::HRESULT,
    pub BreakLineA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, ucodepage: u32, pszsrc: ::windows::core::PCSTR, cchsrc: i32, cmaxcolumns: i32, pcchline: *mut i32, pcchskip: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangString(::windows::core::IUnknown);
impl IMLangString {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<P0>(&self, fnoaccess: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).Sync)(::windows::core::Interface::as_raw(self), fnoaccess.into_param().abi()).ok()
    }
    pub unsafe fn GetLength(&self, pllen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pllen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetMLStr<P0>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: P0, lsrcpos: i32, lsrclen: i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).SetMLStr)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, psrcmlstr.into_param().abi(), lsrcpos, lsrclen).ok()
    }
    pub unsafe fn GetMLStr<P0>(&self, lsrcpos: i32, lsrclen: i32, punkouter: P0, dwclscontext: u32, piid: *const ::windows::core::GUID, ppdestmlstr: *mut ::core::option::Option<::windows::core::IUnknown>, pldestpos: ::core::option::Option<*mut i32>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).GetMLStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, punkouter.into_param().abi(), dwclscontext, piid, ::core::mem::transmute(ppdestmlstr), ::core::mem::transmute(pldestpos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangString, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangString {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangString {}
impl ::core::fmt::Debug for IMLangString {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangString").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangString {
    type Vtable = IMLangString_Vtbl;
}
impl ::core::clone::Clone for IMLangString {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangString {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc04d65ce_b70d_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangString_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Sync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fnoaccess: super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Sync: usize,
    pub GetLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pllen: *mut i32) -> ::windows::core::HRESULT,
    pub SetMLStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, psrcmlstr: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32) -> ::windows::core::HRESULT,
    pub GetMLStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, punkouter: *mut ::core::ffi::c_void, dwclscontext: u32, piid: *const ::windows::core::GUID, ppdestmlstr: *mut *mut ::core::ffi::c_void, pldestpos: *mut i32, pldestlen: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangStringAStr(::windows::core::IUnknown);
impl IMLangStringAStr {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<P0>(&self, fnoaccess: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.Sync)(::windows::core::Interface::as_raw(self), fnoaccess.into_param().abi()).ok()
    }
    pub unsafe fn GetLength(&self, pllen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pllen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetMLStr<P0>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: P0, lsrcpos: i32, lsrclen: i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMLStr)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, psrcmlstr.into_param().abi(), lsrcpos, lsrclen).ok()
    }
    pub unsafe fn GetMLStr<P0>(&self, lsrcpos: i32, lsrclen: i32, punkouter: P0, dwclscontext: u32, piid: *const ::windows::core::GUID, ppdestmlstr: *mut ::core::option::Option<::windows::core::IUnknown>, pldestpos: ::core::option::Option<*mut i32>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.GetMLStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, punkouter.into_param().abi(), dwclscontext, piid, ::core::mem::transmute(ppdestmlstr), ::core::mem::transmute(pldestpos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetAStr(&self, ldestpos: i32, ldestlen: i32, ucodepage: u32, pszsrc: &[u8], pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAStr)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, ucodepage, ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetStrBufA<P0>(&self, ldestpos: i32, ldestlen: i32, ucodepage: u32, psrcbuf: P0, pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IMLangStringBufA>,
    {
        (::windows::core::Interface::vtable(self).SetStrBufA)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, ucodepage, psrcbuf.into_param().abi(), ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetAStr(&self, lsrcpos: i32, lsrclen: i32, ucodepagein: u32, pucodepageout: ::core::option::Option<*const u32>, pszdest: ::core::option::Option<&mut [u8]>, pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, ucodepagein, ::core::mem::transmute(pucodepageout.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pszdest.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pszdest.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetStrBufA(&self, lsrcpos: i32, lsrcmaxlen: i32, pudestcodepage: ::core::option::Option<*mut u32>, ppdestbuf: *mut ::core::option::Option<IMLangStringBufA>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStrBufA)(::windows::core::Interface::as_raw(self), lsrcpos, lsrcmaxlen, ::core::mem::transmute(pudestcodepage.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppdestbuf), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn LockAStr(&self, lsrcpos: i32, lsrclen: i32, lflags: i32, ucodepagein: u32, cchrequest: i32, pucodepageout: ::core::option::Option<*mut u32>, ppszdest: ::core::option::Option<*mut ::windows::core::PSTR>, pcchdest: ::core::option::Option<*mut i32>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LockAStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, lflags, ucodepagein, cchrequest, ::core::mem::transmute(pucodepageout.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppszdest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchdest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn UnlockAStr(&self, pszsrc: &[u8], pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnlockAStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetLocale(&self, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetLocale)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, locale).ok()
    }
    pub unsafe fn GetLocale(&self, lsrcpos: i32, lsrcmaxlen: i32, plocale: ::core::option::Option<*mut u32>, pllocalepos: ::core::option::Option<*mut i32>, pllocalelen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLocale)(::windows::core::Interface::as_raw(self), lsrcpos, lsrcmaxlen, ::core::mem::transmute(plocale.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pllocalepos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pllocalelen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangStringAStr, ::windows::core::IUnknown, IMLangString);
impl ::core::cmp::PartialEq for IMLangStringAStr {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangStringAStr {}
impl ::core::fmt::Debug for IMLangStringAStr {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangStringAStr").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangStringAStr {
    type Vtable = IMLangStringAStr_Vtbl;
}
impl ::core::clone::Clone for IMLangStringAStr {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangStringAStr {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc04d65d2_b70d_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringAStr_Vtbl {
    pub base__: IMLangString_Vtbl,
    pub SetAStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, ucodepage: u32, pszsrc: ::windows::core::PCSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub SetStrBufA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, ucodepage: u32, psrcbuf: *mut ::core::ffi::c_void, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub GetAStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, ucodepagein: u32, pucodepageout: *const u32, pszdest: ::windows::core::PSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub GetStrBufA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrcmaxlen: i32, pudestcodepage: *mut u32, ppdestbuf: *mut *mut ::core::ffi::c_void, pldestlen: *mut i32) -> ::windows::core::HRESULT,
    pub LockAStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, lflags: i32, ucodepagein: u32, cchrequest: i32, pucodepageout: *mut u32, ppszdest: *mut ::windows::core::PSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::core::HRESULT,
    pub UnlockAStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsrc: ::windows::core::PCSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub SetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::core::HRESULT,
    pub GetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangStringBufA(::windows::core::IUnknown);
impl IMLangStringBufA {
    pub unsafe fn GetStatus(&self, plflags: ::core::option::Option<*mut i32>, pcchbuf: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(plflags.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchbuf.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn LockBuf(&self, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u8, pcchbuf: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LockBuf)(::windows::core::Interface::as_raw(self), cchoffset, cchmaxlock, ppszbuf, ::core::mem::transmute(pcchbuf.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn UnlockBuf<P0>(&self, pszbuf: P0, cchoffset: i32, cchwrite: i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).UnlockBuf)(::windows::core::Interface::as_raw(self), pszbuf.into_param().abi(), cchoffset, cchwrite).ok()
    }
    pub unsafe fn Insert(&self, cchoffset: i32, cchmaxinsert: i32, pcchactual: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Insert)(::windows::core::Interface::as_raw(self), cchoffset, cchmaxinsert, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::windows::core::Interface::as_raw(self), cchoffset, cchdelete).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangStringBufA, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangStringBufA {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangStringBufA {}
impl ::core::fmt::Debug for IMLangStringBufA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangStringBufA").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangStringBufA {
    type Vtable = IMLangStringBufA_Vtbl;
}
impl ::core::clone::Clone for IMLangStringBufA {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangStringBufA {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd24acd23_ba72_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufA_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::core::HRESULT,
    pub LockBuf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u8, pcchbuf: *mut i32) -> ::windows::core::HRESULT,
    pub UnlockBuf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszbuf: ::windows::core::PCSTR, cchoffset: i32, cchwrite: i32) -> ::windows::core::HRESULT,
    pub Insert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchmaxinsert: i32, pcchactual: *mut i32) -> ::windows::core::HRESULT,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchdelete: i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangStringBufW(::windows::core::IUnknown);
impl IMLangStringBufW {
    pub unsafe fn GetStatus(&self, plflags: ::core::option::Option<*mut i32>, pcchbuf: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(plflags.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchbuf.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn LockBuf(&self, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u16, pcchbuf: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LockBuf)(::windows::core::Interface::as_raw(self), cchoffset, cchmaxlock, ppszbuf, ::core::mem::transmute(pcchbuf.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn UnlockBuf<P0>(&self, pszbuf: P0, cchoffset: i32, cchwrite: i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).UnlockBuf)(::windows::core::Interface::as_raw(self), pszbuf.into_param().abi(), cchoffset, cchwrite).ok()
    }
    pub unsafe fn Insert(&self, cchoffset: i32, cchmaxinsert: i32, pcchactual: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Insert)(::windows::core::Interface::as_raw(self), cchoffset, cchmaxinsert, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::windows::core::Interface::as_raw(self), cchoffset, cchdelete).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangStringBufW, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMLangStringBufW {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangStringBufW {}
impl ::core::fmt::Debug for IMLangStringBufW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangStringBufW").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangStringBufW {
    type Vtable = IMLangStringBufW_Vtbl;
}
impl ::core::clone::Clone for IMLangStringBufW {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangStringBufW {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd24acd21_ba72_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufW_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plflags: *mut i32, pcchbuf: *mut i32) -> ::windows::core::HRESULT,
    pub LockBuf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchmaxlock: i32, ppszbuf: *mut *mut u16, pcchbuf: *mut i32) -> ::windows::core::HRESULT,
    pub UnlockBuf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszbuf: ::windows::core::PCWSTR, cchoffset: i32, cchwrite: i32) -> ::windows::core::HRESULT,
    pub Insert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchmaxinsert: i32, pcchactual: *mut i32) -> ::windows::core::HRESULT,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cchoffset: i32, cchdelete: i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMLangStringWStr(::windows::core::IUnknown);
impl IMLangStringWStr {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<P0>(&self, fnoaccess: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.Sync)(::windows::core::Interface::as_raw(self), fnoaccess.into_param().abi()).ok()
    }
    pub unsafe fn GetLength(&self, pllen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pllen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetMLStr<P0>(&self, ldestpos: i32, ldestlen: i32, psrcmlstr: P0, lsrcpos: i32, lsrclen: i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMLStr)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, psrcmlstr.into_param().abi(), lsrcpos, lsrclen).ok()
    }
    pub unsafe fn GetMLStr<P0>(&self, lsrcpos: i32, lsrclen: i32, punkouter: P0, dwclscontext: u32, piid: *const ::windows::core::GUID, ppdestmlstr: *mut ::core::option::Option<::windows::core::IUnknown>, pldestpos: ::core::option::Option<*mut i32>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.GetMLStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, punkouter.into_param().abi(), dwclscontext, piid, ::core::mem::transmute(ppdestmlstr), ::core::mem::transmute(pldestpos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetWStr(&self, ldestpos: i32, ldestlen: i32, pszsrc: &[u16], pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetWStr)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetStrBufW<P0>(&self, ldestpos: i32, ldestlen: i32, psrcbuf: P0, pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IMLangStringBufW>,
    {
        (::windows::core::Interface::vtable(self).SetStrBufW)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, psrcbuf.into_param().abi(), ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetWStr(&self, lsrcpos: i32, lsrclen: i32, pszdest: ::core::option::Option<&mut [u16]>, pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetWStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, ::core::mem::transmute(pszdest.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pszdest.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetStrBufW(&self, lsrcpos: i32, lsrcmaxlen: i32, ppdestbuf: *mut ::core::option::Option<IMLangStringBufW>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStrBufW)(::windows::core::Interface::as_raw(self), lsrcpos, lsrcmaxlen, ::core::mem::transmute(ppdestbuf), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn LockWStr(&self, lsrcpos: i32, lsrclen: i32, lflags: i32, cchrequest: i32, ppszdest: ::core::option::Option<*mut ::windows::core::PWSTR>, pcchdest: ::core::option::Option<*mut i32>, pldestlen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LockWStr)(::windows::core::Interface::as_raw(self), lsrcpos, lsrclen, lflags, cchrequest, ::core::mem::transmute(ppszdest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchdest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pldestlen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn UnlockWStr(&self, pszsrc: &[u16], pcchactual: ::core::option::Option<*mut i32>, plactuallen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnlockWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _, ::core::mem::transmute(pcchactual.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plactuallen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetLocale(&self, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetLocale)(::windows::core::Interface::as_raw(self), ldestpos, ldestlen, locale).ok()
    }
    pub unsafe fn GetLocale(&self, lsrcpos: i32, lsrcmaxlen: i32, plocale: ::core::option::Option<*mut u32>, pllocalepos: ::core::option::Option<*mut i32>, pllocalelen: ::core::option::Option<*mut i32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLocale)(::windows::core::Interface::as_raw(self), lsrcpos, lsrcmaxlen, ::core::mem::transmute(plocale.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pllocalepos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pllocalelen.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IMLangStringWStr, ::windows::core::IUnknown, IMLangString);
impl ::core::cmp::PartialEq for IMLangStringWStr {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMLangStringWStr {}
impl ::core::fmt::Debug for IMLangStringWStr {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMLangStringWStr").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMLangStringWStr {
    type Vtable = IMLangStringWStr_Vtbl;
}
impl ::core::clone::Clone for IMLangStringWStr {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMLangStringWStr {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc04d65d0_b70d_11d0_b188_00aa0038c969);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringWStr_Vtbl {
    pub base__: IMLangString_Vtbl,
    pub SetWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, pszsrc: ::windows::core::PCWSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub SetStrBufW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, psrcbuf: *mut ::core::ffi::c_void, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub GetWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, pszdest: ::windows::core::PWSTR, cchdest: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub GetStrBufW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrcmaxlen: i32, ppdestbuf: *mut *mut ::core::ffi::c_void, pldestlen: *mut i32) -> ::windows::core::HRESULT,
    pub LockWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrclen: i32, lflags: i32, cchrequest: i32, ppszdest: *mut ::windows::core::PWSTR, pcchdest: *mut i32, pldestlen: *mut i32) -> ::windows::core::HRESULT,
    pub UnlockWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsrc: ::windows::core::PCWSTR, cchsrc: i32, pcchactual: *mut i32, plactuallen: *mut i32) -> ::windows::core::HRESULT,
    pub SetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldestpos: i32, ldestlen: i32, locale: u32) -> ::windows::core::HRESULT,
    pub GetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsrcpos: i32, lsrcmaxlen: i32, plocale: *mut u32, pllocalepos: *mut i32, pllocalelen: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMultiLanguage(::windows::core::IUnknown);
impl IMultiLanguage {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOfCodePageInfo)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32, pcodepageinfo: *mut MIMECPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCodePageInfo)(::windows::core::Interface::as_raw(self), uicodepage, pcodepageinfo).ok()
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetFamilyCodePage)(::windows::core::Interface::as_raw(self), uicodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumCodePages(&self, grfflags: u32) -> ::windows::core::Result<IEnumCodePage> {
        let mut result__ = ::windows::core::zeroed::<IEnumCodePage>();
        (::windows::core::Interface::vtable(self).EnumCodePages)(::windows::core::Interface::as_raw(self), grfflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCharsetInfo<P0>(&self, charset: P0, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).GetCharsetInfo)(::windows::core::Interface::as_raw(self), charset.into_param().abi(), pcharsetinfo).ok()
    }
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsConvertible)(::windows::core::Interface::as_raw(self), dwsrcencoding, dwdstencoding).ok()
    }
    pub unsafe fn ConvertString(&self, pdwmode: ::core::option::Option<*mut u32>, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: ::core::option::Option<*const u8>, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::core::option::Option<*mut u8>, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConvertString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwsrcencoding, dwdstencoding, ::core::mem::transmute(psrcstr.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringToUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringToUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringFromUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringFromUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConvertStringReset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetRfc1766FromLcid)(::windows::core::Interface::as_raw(self), locale, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetLcidFromRfc1766<P0>(&self, plocale: *mut u32, bstrrfc1766: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).GetLcidFromRfc1766)(::windows::core::Interface::as_raw(self), plocale, bstrrfc1766.into_param().abi()).ok()
    }
    pub unsafe fn EnumRfc1766(&self) -> ::windows::core::Result<IEnumRfc1766> {
        let mut result__ = ::windows::core::zeroed::<IEnumRfc1766>();
        (::windows::core::Interface::vtable(self).EnumRfc1766)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRfc1766Info(&self, locale: u32, prfc1766info: *mut RFC1766INFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRfc1766Info)(::windows::core::Interface::as_raw(self), locale, prfc1766info).ok()
    }
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::core::Result<IMLangConvertCharset> {
        let mut result__ = ::windows::core::zeroed::<IMLangConvertCharset>();
        (::windows::core::Interface::vtable(self).CreateConvertCharset)(::windows::core::Interface::as_raw(self), uisrccodepage, uidstcodepage, dwproperty, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IMultiLanguage, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMultiLanguage {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultiLanguage {}
impl ::core::fmt::Debug for IMultiLanguage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultiLanguage").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMultiLanguage {
    type Vtable = IMultiLanguage_Vtbl;
}
impl ::core::clone::Clone for IMultiLanguage {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMultiLanguage {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x275c23e1_3747_11d0_9fea_00aa003f8646);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetNumberOfCodePageInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccodepage: *mut u32) -> ::windows::core::HRESULT,
    pub GetCodePageInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, pcodepageinfo: *mut MIMECPINFO) -> ::windows::core::HRESULT,
    pub GetFamilyCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, puifamilycodepage: *mut u32) -> ::windows::core::HRESULT,
    pub EnumCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, grfflags: u32, ppenumcodepage: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCharsetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, charset: ::std::mem::MaybeUninit<::windows::core::BSTR>, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::core::HRESULT,
    pub IsConvertible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::core::HRESULT,
    pub ConvertString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringToUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PWSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringFromUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCWSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringReset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRfc1766FromLcid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, pbstrrfc1766: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetLcidFromRfc1766: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plocale: *mut u32, bstrrfc1766: ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub EnumRfc1766: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenumrfc1766: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRfc1766Info: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, prfc1766info: *mut RFC1766INFO) -> ::windows::core::HRESULT,
    pub CreateConvertCharset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32, ppmlangconvertcharset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMultiLanguage2(::windows::core::IUnknown);
impl IMultiLanguage2 {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOfCodePageInfo)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32, langid: u16, pcodepageinfo: *mut MIMECPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCodePageInfo)(::windows::core::Interface::as_raw(self), uicodepage, langid, pcodepageinfo).ok()
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetFamilyCodePage)(::windows::core::Interface::as_raw(self), uicodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumCodePages(&self, grfflags: u32, langid: u16) -> ::windows::core::Result<IEnumCodePage> {
        let mut result__ = ::windows::core::zeroed::<IEnumCodePage>();
        (::windows::core::Interface::vtable(self).EnumCodePages)(::windows::core::Interface::as_raw(self), grfflags, langid, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCharsetInfo<P0>(&self, charset: P0, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).GetCharsetInfo)(::windows::core::Interface::as_raw(self), charset.into_param().abi(), pcharsetinfo).ok()
    }
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsConvertible)(::windows::core::Interface::as_raw(self), dwsrcencoding, dwdstencoding).ok()
    }
    pub unsafe fn ConvertString(&self, pdwmode: ::core::option::Option<*mut u32>, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: ::core::option::Option<*const u8>, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::core::option::Option<*mut u8>, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConvertString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwsrcencoding, dwdstencoding, ::core::mem::transmute(psrcstr.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringToUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringToUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringFromUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringFromUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConvertStringReset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetRfc1766FromLcid)(::windows::core::Interface::as_raw(self), locale, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetLcidFromRfc1766<P0>(&self, plocale: *mut u32, bstrrfc1766: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).GetLcidFromRfc1766)(::windows::core::Interface::as_raw(self), plocale, bstrrfc1766.into_param().abi()).ok()
    }
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::core::Result<IEnumRfc1766> {
        let mut result__ = ::windows::core::zeroed::<IEnumRfc1766>();
        (::windows::core::Interface::vtable(self).EnumRfc1766)(::windows::core::Interface::as_raw(self), langid, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRfc1766Info(&self, locale: u32, langid: u16, prfc1766info: *mut RFC1766INFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRfc1766Info)(::windows::core::Interface::as_raw(self), locale, langid, prfc1766info).ok()
    }
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::core::Result<IMLangConvertCharset> {
        let mut result__ = ::windows::core::zeroed::<IMLangConvertCharset>();
        (::windows::core::Interface::vtable(self).CreateConvertCharset)(::windows::core::Interface::as_raw(self), uisrccodepage, uidstcodepage, dwproperty, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ConvertStringInIStream<P0, P1, P2>(&self, pdwmode: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P0, dwsrcencoding: u32, dwdstencoding: u32, pstmin: P1, pstmout: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<super::System::Com::IStream>,
        P2: ::windows::core::IntoParam<super::System::Com::IStream>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringInIStream)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi(), dwsrcencoding, dwdstencoding, pstmin.into_param().abi(), pstmout.into_param().abi()).ok()
    }
    pub unsafe fn ConvertStringToUnicodeEx<P0, P1>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringToUnicodeEx)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi()).ok()
    }
    pub unsafe fn ConvertStringFromUnicodeEx<P0, P1>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ConvertStringFromUnicodeEx)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn DetectCodepageInIStream<P0>(&self, dwflag: u32, dwprefwincodepage: u32, pstmin: P0, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::System::Com::IStream>,
    {
        (::windows::core::Interface::vtable(self).DetectCodepageInIStream)(::windows::core::Interface::as_raw(self), dwflag, dwprefwincodepage, pstmin.into_param().abi(), lpencoding, pnscores).ok()
    }
    pub unsafe fn DetectInputCodepage<P0>(&self, dwflag: u32, dwprefwincodepage: u32, psrcstr: P0, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).DetectInputCodepage)(::windows::core::Interface::as_raw(self), dwflag, dwprefwincodepage, psrcstr.into_param().abi(), pcsrcsize, lpencoding, pnscores).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePage<P0>(&self, uicodepage: u32, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).ValidateCodePage)(::windows::core::Interface::as_raw(self), uicodepage, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetCodePageDescription(&self, uicodepage: u32, lcid: u32, lpwidecharstr: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCodePageDescription)(::windows::core::Interface::as_raw(self), uicodepage, lcid, ::core::mem::transmute(lpwidecharstr.as_ptr()), lpwidecharstr.len() as _).ok()
    }
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsCodePageInstallable)(::windows::core::Interface::as_raw(self), uicodepage).ok()
    }
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMimeDBSource)(::windows::core::Interface::as_raw(self), dwsource).ok()
    }
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOfScripts)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumScripts(&self, dwflags: u32, langid: u16) -> ::windows::core::Result<IEnumScript> {
        let mut result__ = ::windows::core::zeroed::<IEnumScript>();
        (::windows::core::Interface::vtable(self).EnumScripts)(::windows::core::Interface::as_raw(self), dwflags, langid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePageEx<P0>(&self, uicodepage: u32, hwnd: P0, dwfiodcontrol: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).ValidateCodePageEx)(::windows::core::Interface::as_raw(self), uicodepage, hwnd.into_param().abi(), dwfiodcontrol).ok()
    }
}
::windows::imp::interface_hierarchy!(IMultiLanguage2, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IMultiLanguage2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultiLanguage2 {}
impl ::core::fmt::Debug for IMultiLanguage2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultiLanguage2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMultiLanguage2 {
    type Vtable = IMultiLanguage2_Vtbl;
}
impl ::core::clone::Clone for IMultiLanguage2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMultiLanguage2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdccfc164_2b38_11d2_b7ec_00c04f8f5d9a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage2_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetNumberOfCodePageInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccodepage: *mut u32) -> ::windows::core::HRESULT,
    pub GetCodePageInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, langid: u16, pcodepageinfo: *mut MIMECPINFO) -> ::windows::core::HRESULT,
    pub GetFamilyCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, puifamilycodepage: *mut u32) -> ::windows::core::HRESULT,
    pub EnumCodePages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, grfflags: u32, langid: u16, ppenumcodepage: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCharsetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, charset: ::std::mem::MaybeUninit<::windows::core::BSTR>, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::core::HRESULT,
    pub IsConvertible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::core::HRESULT,
    pub ConvertString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: *const u8, pcsrcsize: *mut u32, pdststr: *mut u8, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringToUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PWSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringFromUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCWSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PSTR, pcdstsize: *mut u32) -> ::windows::core::HRESULT,
    pub ConvertStringReset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRfc1766FromLcid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, pbstrrfc1766: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetLcidFromRfc1766: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plocale: *mut u32, bstrrfc1766: ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub EnumRfc1766: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, langid: u16, ppenumrfc1766: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRfc1766Info: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, locale: u32, langid: u16, prfc1766info: *mut RFC1766INFO) -> ::windows::core::HRESULT,
    pub CreateConvertCharset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32, ppmlangconvertcharset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub ConvertStringInIStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwflag: u32, lpfallback: ::windows::core::PCWSTR, dwsrcencoding: u32, dwdstencoding: u32, pstmin: *mut ::core::ffi::c_void, pstmout: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ConvertStringInIStream: usize,
    pub ConvertStringToUnicodeEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PWSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ConvertStringFromUnicodeEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmode: *mut u32, dwencoding: u32, psrcstr: ::windows::core::PCWSTR, pcsrcsize: *mut u32, pdststr: ::windows::core::PSTR, pcdstsize: *mut u32, dwflag: u32, lpfallback: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub DetectCodepageInIStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32, dwprefwincodepage: u32, pstmin: *mut ::core::ffi::c_void, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    DetectCodepageInIStream: usize,
    pub DetectInputCodepage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32, dwprefwincodepage: u32, psrcstr: ::windows::core::PCSTR, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ValidateCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, hwnd: super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ValidateCodePage: usize,
    pub GetCodePageDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, lcid: u32, lpwidecharstr: ::windows::core::PWSTR, cchwidechar: i32) -> ::windows::core::HRESULT,
    pub IsCodePageInstallable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32) -> ::windows::core::HRESULT,
    pub SetMimeDBSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsource: MIMECONTF) -> ::windows::core::HRESULT,
    pub GetNumberOfScripts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnscripts: *mut u32) -> ::windows::core::HRESULT,
    pub EnumScripts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, langid: u16, ppenumscript: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ValidateCodePageEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicodepage: u32, hwnd: super::Foundation::HWND, dwfiodcontrol: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ValidateCodePageEx: usize,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IMultiLanguage3(::windows::core::IUnknown);
impl IMultiLanguage3 {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetNumberOfCodePageInfo)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCodePageInfo(&self, uicodepage: u32, langid: u16, pcodepageinfo: *mut MIMECPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCodePageInfo)(::windows::core::Interface::as_raw(self), uicodepage, langid, pcodepageinfo).ok()
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetFamilyCodePage)(::windows::core::Interface::as_raw(self), uicodepage, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumCodePages(&self, grfflags: u32, langid: u16) -> ::windows::core::Result<IEnumCodePage> {
        let mut result__ = ::windows::core::zeroed::<IEnumCodePage>();
        (::windows::core::Interface::vtable(self).base__.EnumCodePages)(::windows::core::Interface::as_raw(self), grfflags, langid, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCharsetInfo<P0>(&self, charset: P0, pcharsetinfo: *mut MIMECSETINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.GetCharsetInfo)(::windows::core::Interface::as_raw(self), charset.into_param().abi(), pcharsetinfo).ok()
    }
    pub unsafe fn IsConvertible(&self, dwsrcencoding: u32, dwdstencoding: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.IsConvertible)(::windows::core::Interface::as_raw(self), dwsrcencoding, dwdstencoding).ok()
    }
    pub unsafe fn ConvertString(&self, pdwmode: ::core::option::Option<*mut u32>, dwsrcencoding: u32, dwdstencoding: u32, psrcstr: ::core::option::Option<*const u8>, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::core::option::Option<*mut u8>, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ConvertString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwsrcencoding, dwdstencoding, ::core::mem::transmute(psrcstr.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringToUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.ConvertStringToUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringFromUnicode<P0>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.ConvertStringFromUnicode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ConvertStringReset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRfc1766FromLcid(&self, locale: u32) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetRfc1766FromLcid)(::windows::core::Interface::as_raw(self), locale, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetLcidFromRfc1766<P0>(&self, plocale: *mut u32, bstrrfc1766: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.GetLcidFromRfc1766)(::windows::core::Interface::as_raw(self), plocale, bstrrfc1766.into_param().abi()).ok()
    }
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::core::Result<IEnumRfc1766> {
        let mut result__ = ::windows::core::zeroed::<IEnumRfc1766>();
        (::windows::core::Interface::vtable(self).base__.EnumRfc1766)(::windows::core::Interface::as_raw(self), langid, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRfc1766Info(&self, locale: u32, langid: u16, prfc1766info: *mut RFC1766INFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetRfc1766Info)(::windows::core::Interface::as_raw(self), locale, langid, prfc1766info).ok()
    }
    pub unsafe fn CreateConvertCharset(&self, uisrccodepage: u32, uidstcodepage: u32, dwproperty: u32) -> ::windows::core::Result<IMLangConvertCharset> {
        let mut result__ = ::windows::core::zeroed::<IMLangConvertCharset>();
        (::windows::core::Interface::vtable(self).base__.CreateConvertCharset)(::windows::core::Interface::as_raw(self), uisrccodepage, uidstcodepage, dwproperty, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ConvertStringInIStream<P0, P1, P2>(&self, pdwmode: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P0, dwsrcencoding: u32, dwdstencoding: u32, pstmin: P1, pstmout: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<super::System::Com::IStream>,
        P2: ::windows::core::IntoParam<super::System::Com::IStream>,
    {
        (::windows::core::Interface::vtable(self).base__.ConvertStringInIStream)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi(), dwsrcencoding, dwdstencoding, pstmin.into_param().abi(), pstmout.into_param().abi()).ok()
    }
    pub unsafe fn ConvertStringToUnicodeEx<P0, P1>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PWSTR, pcdstsize: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.ConvertStringToUnicodeEx)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi()).ok()
    }
    pub unsafe fn ConvertStringFromUnicodeEx<P0, P1>(&self, pdwmode: ::core::option::Option<*mut u32>, dwencoding: u32, psrcstr: P0, pcsrcsize: ::core::option::Option<*mut u32>, pdststr: ::windows::core::PSTR, pcdstsize: ::core::option::Option<*mut u32>, dwflag: u32, lpfallback: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.ConvertStringFromUnicodeEx)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwmode.unwrap_or(::std::ptr::null_mut())), dwencoding, psrcstr.into_param().abi(), ::core::mem::transmute(pcsrcsize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdststr), ::core::mem::transmute(pcdstsize.unwrap_or(::std::ptr::null_mut())), dwflag, lpfallback.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn DetectCodepageInIStream<P0>(&self, dwflag: u32, dwprefwincodepage: u32, pstmin: P0, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::System::Com::IStream>,
    {
        (::windows::core::Interface::vtable(self).base__.DetectCodepageInIStream)(::windows::core::Interface::as_raw(self), dwflag, dwprefwincodepage, pstmin.into_param().abi(), lpencoding, pnscores).ok()
    }
    pub unsafe fn DetectInputCodepage<P0>(&self, dwflag: u32, dwprefwincodepage: u32, psrcstr: P0, pcsrcsize: *mut i32, lpencoding: *mut DetectEncodingInfo, pnscores: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.DetectInputCodepage)(::windows::core::Interface::as_raw(self), dwflag, dwprefwincodepage, psrcstr.into_param().abi(), pcsrcsize, lpencoding, pnscores).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePage<P0>(&self, uicodepage: u32, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).base__.ValidateCodePage)(::windows::core::Interface::as_raw(self), uicodepage, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetCodePageDescription(&self, uicodepage: u32, lcid: u32, lpwidecharstr: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCodePageDescription)(::windows::core::Interface::as_raw(self), uicodepage, lcid, ::core::mem::transmute(lpwidecharstr.as_ptr()), lpwidecharstr.len() as _).ok()
    }
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.IsCodePageInstallable)(::windows::core::Interface::as_raw(self), uicodepage).ok()
    }
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetMimeDBSource)(::windows::core::Interface::as_raw(self), dwsource).ok()
    }
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetNumberOfScripts)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumScripts(&self, dwflags: u32, langid: u16) -> ::windows::core::Result<IEnumScript> {
        let mut result__ = ::windows::core::zeroed::<IEnumScript>();
        (::windows::core::Interface::vtable(self).base__.EnumScripts)(::windows::core::Interface::as_raw(self), dwflags, langid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePageEx<P0>(&self, uicodepage: u32, hwnd: P0, dwfiodcontrol: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).base__.ValidateCodePageEx)(::windows::core::Interface::as_raw(self), uicodepage, hwnd.into_param().abi(), dwfiodcontrol).ok()
    }
    pub unsafe fn DetectOutboundCodePage<P0>(&self, dwflags: u32, lpwidecharstr: &[u16], puipreferredcodepages: ::core::option::Option<&[u32]>, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DetectOutboundCodePage)(::windows::core::Interface::as_raw(self), dwflags, ::core::mem::transmute(lpwidecharstr.as_ptr()), lpwidecharstr.len() as _, ::core::mem::transmute(puipreferredcodepages.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), puipreferredcodepages.as_deref().map_or(0, |slice| slice.len() as _), puidetectedcodepages, pndetectedcodepages, lpspecialchar.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn DetectOutboundCodePageInIStream<P0, P1>(&self, dwflags: u32, pstrin: P0, puipreferredcodepages: ::core::option::Option<&[u32]>, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::System::Com::IStream>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DetectOutboundCodePageInIStream)(::windows::core::Interface::as_raw(self), dwflags, pstrin.into_param().abi(), ::core::mem::transmute(puipreferredcodepages.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), puipreferredcodepages.as_deref().map_or(0, |slice| slice.len() as _), puidetectedcodepages, pndetectedcodepages, lpspecialchar.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IMultiLanguage3, ::windows::core::IUnknown, IMultiLanguage2);
impl ::core::cmp::PartialEq for IMultiLanguage3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultiLanguage3 {}
impl ::core::fmt::Debug for IMultiLanguage3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultiLanguage3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IMultiLanguage3 {
    type Vtable = IMultiLanguage3_Vtbl;
}
impl ::core::clone::Clone for IMultiLanguage3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IMultiLanguage3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4e5868ab_b157_4623_9acc_6a1d9caebe04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage3_Vtbl {
    pub base__: IMultiLanguage2_Vtbl,
    pub DetectOutboundCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, lpwidecharstr: ::windows::core::PCWSTR, cchwidechar: u32, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub DetectOutboundCodePageInIStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, pstrin: *mut ::core::ffi::c_void, puipreferredcodepages: *const u32, npreferredcodepages: u32, puidetectedcodepages: *mut u32, pndetectedcodepages: *mut u32, lpspecialchar: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    DetectOutboundCodePageInIStream: usize,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IOptionDescription(::windows::core::IUnknown);
impl IOptionDescription {
    pub unsafe fn Id(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Id)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Heading(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Heading)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Description(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Description)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Labels(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).Labels)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IOptionDescription, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IOptionDescription {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOptionDescription {}
impl ::core::fmt::Debug for IOptionDescription {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOptionDescription").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IOptionDescription {
    type Vtable = IOptionDescription_Vtbl;
}
impl ::core::clone::Clone for IOptionDescription {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IOptionDescription {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x432e5f85_35cf_4606_a801_6f70277e1d7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOptionDescription_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Id: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Heading: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Description: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Labels: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Labels: usize,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellCheckProvider(::windows::core::IUnknown);
impl ISpellCheckProvider {
    pub unsafe fn LanguageTag(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).LanguageTag)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Check<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).Check)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Suggest<P0>(&self, word: P0) -> ::windows::core::Result<super::System::Com::IEnumString>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).Suggest)(::windows::core::Interface::as_raw(self), word.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetOptionValue<P0>(&self, optionid: P0) -> ::windows::core::Result<u8>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u8>();
        (::windows::core::Interface::vtable(self).GetOptionValue)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOptionValue<P0>(&self, optionid: P0, value: u8) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOptionValue)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), value).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).OptionIds)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Id(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Id)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn LocalizedName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).LocalizedName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetOptionDescription<P0>(&self, optionid: P0) -> ::windows::core::Result<IOptionDescription>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IOptionDescription>();
        (::windows::core::Interface::vtable(self).GetOptionDescription)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeWordlist<P0>(&self, wordlisttype: WORDLIST_TYPE, words: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::System::Com::IEnumString>,
    {
        (::windows::core::Interface::vtable(self).InitializeWordlist)(::windows::core::Interface::as_raw(self), wordlisttype, words.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(ISpellCheckProvider, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellCheckProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellCheckProvider {}
impl ::core::fmt::Debug for ISpellCheckProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellCheckProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellCheckProvider {
    type Vtable = ISpellCheckProvider_Vtbl;
}
impl ::core::clone::Clone for ISpellCheckProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellCheckProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73e976e0_8ed4_4eb1_80d7_1be0a16b0c38);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub LanguageTag: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Check: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, text: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Suggest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, word: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Suggest: usize,
    pub GetOptionValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, optionid: ::windows::core::PCWSTR, value: *mut u8) -> ::windows::core::HRESULT,
    pub SetOptionValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, optionid: ::windows::core::PCWSTR, value: u8) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OptionIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OptionIds: usize,
    pub Id: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub LocalizedName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetOptionDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, optionid: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub InitializeWordlist: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wordlisttype: WORDLIST_TYPE, words: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InitializeWordlist: usize,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellCheckProviderFactory(::windows::core::IUnknown);
impl ISpellCheckProviderFactory {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SupportedLanguages(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).SupportedLanguages)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSupported<P0>(&self, languagetag: P0) -> ::windows::core::Result<super::Foundation::BOOL>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsSupported)(::windows::core::Interface::as_raw(self), languagetag.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSpellCheckProvider<P0>(&self, languagetag: P0) -> ::windows::core::Result<ISpellCheckProvider>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<ISpellCheckProvider>();
        (::windows::core::Interface::vtable(self).CreateSpellCheckProvider)(::windows::core::Interface::as_raw(self), languagetag.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(ISpellCheckProviderFactory, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellCheckProviderFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellCheckProviderFactory {}
impl ::core::fmt::Debug for ISpellCheckProviderFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellCheckProviderFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellCheckProviderFactory {
    type Vtable = ISpellCheckProviderFactory_Vtbl;
}
impl ::core::clone::Clone for ISpellCheckProviderFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellCheckProviderFactory {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f671e11_77d6_4c92_aefb_615215e3a4be);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProviderFactory_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SupportedLanguages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SupportedLanguages: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, languagetag: ::windows::core::PCWSTR, value: *mut super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSupported: usize,
    pub CreateSpellCheckProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, languagetag: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellChecker(::windows::core::IUnknown);
impl ISpellChecker {
    pub unsafe fn LanguageTag(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).LanguageTag)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Check<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).Check)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Suggest<P0>(&self, word: P0) -> ::windows::core::Result<super::System::Com::IEnumString>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).Suggest)(::windows::core::Interface::as_raw(self), word.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Add<P0>(&self, word: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), word.into_param().abi()).ok()
    }
    pub unsafe fn Ignore<P0>(&self, word: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Ignore)(::windows::core::Interface::as_raw(self), word.into_param().abi()).ok()
    }
    pub unsafe fn AutoCorrect<P0, P1>(&self, from: P0, to: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AutoCorrect)(::windows::core::Interface::as_raw(self), from.into_param().abi(), to.into_param().abi()).ok()
    }
    pub unsafe fn GetOptionValue<P0>(&self, optionid: P0) -> ::windows::core::Result<u8>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u8>();
        (::windows::core::Interface::vtable(self).GetOptionValue)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).OptionIds)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Id(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Id)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn LocalizedName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).LocalizedName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn add_SpellCheckerChanged<P0>(&self, handler: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<ISpellCheckerChangedEventHandler>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).add_SpellCheckerChanged)(::windows::core::Interface::as_raw(self), handler.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn remove_SpellCheckerChanged(&self, eventcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).remove_SpellCheckerChanged)(::windows::core::Interface::as_raw(self), eventcookie).ok()
    }
    pub unsafe fn GetOptionDescription<P0>(&self, optionid: P0) -> ::windows::core::Result<IOptionDescription>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IOptionDescription>();
        (::windows::core::Interface::vtable(self).GetOptionDescription)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn ComprehensiveCheck<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).ComprehensiveCheck)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(ISpellChecker, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellChecker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellChecker {}
impl ::core::fmt::Debug for ISpellChecker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellChecker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellChecker {
    type Vtable = ISpellChecker_Vtbl;
}
impl ::core::clone::Clone for ISpellChecker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellChecker {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb6fd0b71_e2bc_4653_8d05_f197e412770b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub LanguageTag: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Check: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, text: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Suggest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, word: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Suggest: usize,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, word: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub Ignore: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, word: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AutoCorrect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, from: ::windows::core::PCWSTR, to: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetOptionValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, optionid: ::windows::core::PCWSTR, value: *mut u8) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OptionIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OptionIds: usize,
    pub Id: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub LocalizedName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub add_SpellCheckerChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handler: *mut ::core::ffi::c_void, eventcookie: *mut u32) -> ::windows::core::HRESULT,
    pub remove_SpellCheckerChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventcookie: u32) -> ::windows::core::HRESULT,
    pub GetOptionDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, optionid: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ComprehensiveCheck: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, text: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellChecker2(::windows::core::IUnknown);
impl ISpellChecker2 {
    pub unsafe fn LanguageTag(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).base__.LanguageTag)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Check<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).base__.Check)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Suggest<P0>(&self, word: P0) -> ::windows::core::Result<super::System::Com::IEnumString>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).base__.Suggest)(::windows::core::Interface::as_raw(self), word.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Add<P0>(&self, word: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Add)(::windows::core::Interface::as_raw(self), word.into_param().abi()).ok()
    }
    pub unsafe fn Ignore<P0>(&self, word: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Ignore)(::windows::core::Interface::as_raw(self), word.into_param().abi()).ok()
    }
    pub unsafe fn AutoCorrect<P0, P1>(&self, from: P0, to: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.AutoCorrect)(::windows::core::Interface::as_raw(self), from.into_param().abi(), to.into_param().abi()).ok()
    }
    pub unsafe fn GetOptionValue<P0>(&self, optionid: P0) -> ::windows::core::Result<u8>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u8>();
        (::windows::core::Interface::vtable(self).base__.GetOptionValue)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).base__.OptionIds)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Id(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).base__.Id)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn LocalizedName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).base__.LocalizedName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn add_SpellCheckerChanged<P0>(&self, handler: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<ISpellCheckerChangedEventHandler>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.add_SpellCheckerChanged)(::windows::core::Interface::as_raw(self), handler.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn remove_SpellCheckerChanged(&self, eventcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.remove_SpellCheckerChanged)(::windows::core::Interface::as_raw(self), eventcookie).ok()
    }
    pub unsafe fn GetOptionDescription<P0>(&self, optionid: P0) -> ::windows::core::Result<IOptionDescription>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IOptionDescription>();
        (::windows::core::Interface::vtable(self).base__.GetOptionDescription)(::windows::core::Interface::as_raw(self), optionid.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn ComprehensiveCheck<P0>(&self, text: P0) -> ::windows::core::Result<IEnumSpellingError>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IEnumSpellingError>();
        (::windows::core::Interface::vtable(self).base__.ComprehensiveCheck)(::windows::core::Interface::as_raw(self), text.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Remove<P0>(&self, word: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), word.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(ISpellChecker2, ::windows::core::IUnknown, ISpellChecker);
impl ::core::cmp::PartialEq for ISpellChecker2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellChecker2 {}
impl ::core::fmt::Debug for ISpellChecker2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellChecker2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellChecker2 {
    type Vtable = ISpellChecker2_Vtbl;
}
impl ::core::clone::Clone for ISpellChecker2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellChecker2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe7ed1c71_87f7_4378_a840_c9200dacee47);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker2_Vtbl {
    pub base__: ISpellChecker_Vtbl,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, word: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellCheckerChangedEventHandler(::windows::core::IUnknown);
impl ISpellCheckerChangedEventHandler {
    pub unsafe fn Invoke<P0>(&self, sender: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<ISpellChecker>,
    {
        (::windows::core::Interface::vtable(self).Invoke)(::windows::core::Interface::as_raw(self), sender.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(ISpellCheckerChangedEventHandler, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellCheckerChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellCheckerChangedEventHandler {}
impl ::core::fmt::Debug for ISpellCheckerChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellCheckerChangedEventHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellCheckerChangedEventHandler {
    type Vtable = ISpellCheckerChangedEventHandler_Vtbl;
}
impl ::core::clone::Clone for ISpellCheckerChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellCheckerChangedEventHandler {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b83a5b0_792f_4eab_9799_acf52c5ed08a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerChangedEventHandler_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sender: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellCheckerFactory(::windows::core::IUnknown);
impl ISpellCheckerFactory {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SupportedLanguages(&self) -> ::windows::core::Result<super::System::Com::IEnumString> {
        let mut result__ = ::windows::core::zeroed::<super::System::Com::IEnumString>();
        (::windows::core::Interface::vtable(self).SupportedLanguages)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSupported<P0>(&self, languagetag: P0) -> ::windows::core::Result<super::Foundation::BOOL>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsSupported)(::windows::core::Interface::as_raw(self), languagetag.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSpellChecker<P0>(&self, languagetag: P0) -> ::windows::core::Result<ISpellChecker>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<ISpellChecker>();
        (::windows::core::Interface::vtable(self).CreateSpellChecker)(::windows::core::Interface::as_raw(self), languagetag.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(ISpellCheckerFactory, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellCheckerFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellCheckerFactory {}
impl ::core::fmt::Debug for ISpellCheckerFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellCheckerFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellCheckerFactory {
    type Vtable = ISpellCheckerFactory_Vtbl;
}
impl ::core::clone::Clone for ISpellCheckerFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellCheckerFactory {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8e018a9d_2415_4677_bf08_794ea61f94bb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerFactory_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SupportedLanguages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SupportedLanguages: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, languagetag: ::windows::core::PCWSTR, value: *mut super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSupported: usize,
    pub CreateSpellChecker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, languagetag: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct ISpellingError(::windows::core::IUnknown);
impl ISpellingError {
    pub unsafe fn StartIndex(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).StartIndex)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Length(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).Length)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CorrectiveAction(&self) -> ::windows::core::Result<CORRECTIVE_ACTION> {
        let mut result__ = ::windows::core::zeroed::<CORRECTIVE_ACTION>();
        (::windows::core::Interface::vtable(self).CorrectiveAction)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Replacement(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).Replacement)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(ISpellingError, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ISpellingError {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISpellingError {}
impl ::core::fmt::Debug for ISpellingError {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISpellingError").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ISpellingError {
    type Vtable = ISpellingError_Vtbl;
}
impl ::core::clone::Clone for ISpellingError {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ISpellingError {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb7c82d61_fbe8_4b47_9b27_6c0d2e0de0a3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellingError_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StartIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut u32) -> ::windows::core::HRESULT,
    pub Length: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut u32) -> ::windows::core::HRESULT,
    pub CorrectiveAction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut CORRECTIVE_ACTION) -> ::windows::core::HRESULT,
    pub Replacement: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
pub struct IUserDictionariesRegistrar(::windows::core::IUnknown);
impl IUserDictionariesRegistrar {
    pub unsafe fn RegisterUserDictionary<P0, P1>(&self, dictionarypath: P0, languagetag: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).RegisterUserDictionary)(::windows::core::Interface::as_raw(self), dictionarypath.into_param().abi(), languagetag.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterUserDictionary<P0, P1>(&self, dictionarypath: P0, languagetag: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).UnregisterUserDictionary)(::windows::core::Interface::as_raw(self), dictionarypath.into_param().abi(), languagetag.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IUserDictionariesRegistrar, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IUserDictionariesRegistrar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUserDictionariesRegistrar {}
impl ::core::fmt::Debug for IUserDictionariesRegistrar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUserDictionariesRegistrar").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IUserDictionariesRegistrar {
    type Vtable = IUserDictionariesRegistrar_Vtbl;
}
impl ::core::clone::Clone for IUserDictionariesRegistrar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IUserDictionariesRegistrar {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaa176b85_0e12_4844_8e1a_eef1da77f586);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUserDictionariesRegistrar_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub RegisterUserDictionary: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dictionarypath: ::windows::core::PCWSTR, languagetag: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub UnregisterUserDictionary: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dictionarypath: ::windows::core::PCWSTR, languagetag: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ALL_SERVICES: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ALL_SERVICE_TYPES: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_ALPHA: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_BLANK: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_CNTRL: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_DEFINED: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_DIGIT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_LOWER: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_PUNCT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_SPACE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_UPPER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C1_XDIGIT: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_ARABICNUMBER: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_BLOCKSEPARATOR: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_COMMONSEPARATOR: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_EUROPENUMBER: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_EUROPESEPARATOR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_EUROPETERMINATOR: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_LEFTTORIGHT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_NOTAPPLICABLE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_OTHERNEUTRAL: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_RIGHTTOLEFT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_SEGMENTSEPARATOR: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C2_WHITESPACE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_ALPHA: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_DIACRITIC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_FULLWIDTH: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_HALFWIDTH: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_HIGHSURROGATE: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_HIRAGANA: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_IDEOGRAPH: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_KASHIDA: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_KATAKANA: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_LEXICAL: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_LOWSURROGATE: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_NONSPACING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_NOTAPPLICABLE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_SYMBOL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const C3_VOWELMARK: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN_ARABIC: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN_ME_FRENCH: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN_US: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN_XLIT_ENGLISH: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_GREGORIAN_XLIT_FRENCH: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_HEBREW: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_HIJRI: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_ICALINTVALUE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_ITWODIGITYEARMAX: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_IYEAROFFSETRANGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_JAPAN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_KOREA: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_NOUSEROVERRIDE: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_PERSIAN: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_RETURN_NUMBER: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME1: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME2: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME3: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME4: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME5: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME6: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVDAYNAME7: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVERASTRING: u32 = 57u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME1: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME10: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME11: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME12: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME13: u32 = 46u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME2: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME3: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME4: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME5: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME6: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME7: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME8: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SABBREVMONTHNAME9: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SCALNAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME1: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME2: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME3: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME4: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME5: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME6: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SDAYNAME7: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SENGLISHABBREVERANAME: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SENGLISHERANAME: u32 = 59u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SERASTRING: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SJAPANESEERAFIRSTYEAR: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SLONGDATE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHDAY: u32 = 56u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME1: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME10: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME11: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME12: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME13: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME2: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME3: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME4: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME5: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME6: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME7: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME8: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SMONTHNAME9: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SRELATIVELONGDATE: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTDATE: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME1: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME2: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME3: u32 = 51u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME4: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME5: u32 = 53u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME6: u32 = 54u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SSHORTESTDAYNAME7: u32 = 55u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_SYEARMONTH: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_TAIWAN: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_THAI: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_UMALQURA: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CAL_USE_CP_ACP: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CANITER_SKIP_ZEROES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CMLangConvertCharset: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd66d6f99_cdaa_11d0_b822_00c04fc9b31f);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CMLangString: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc04d65cf_b70d_11d0_b188_00aa0038c969);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CMultiLanguage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x275c23e2_3747_11d0_9fea_00aa003f8646);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CPIOD_FORCE_PROMPT: i32 = -2147483648i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CPIOD_PEEK: i32 = 1073741824i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_ACP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_MACCP: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_OEMCP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_SYMBOL: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_THREAD_ACP: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_UTF7: u32 = 65000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_UTF8: u32 = 65001u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CSTR_EQUAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CSTR_GREATER_THAN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CSTR_LESS_THAN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ALBANIA: u32 = 355u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ALGERIA: u32 = 213u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ARGENTINA: u32 = 54u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ARMENIA: u32 = 374u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_AUSTRALIA: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_AUSTRIA: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_AZERBAIJAN: u32 = 994u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BAHRAIN: u32 = 973u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BELARUS: u32 = 375u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BELGIUM: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BELIZE: u32 = 501u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BOLIVIA: u32 = 591u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BRAZIL: u32 = 55u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BRUNEI_DARUSSALAM: u32 = 673u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_BULGARIA: u32 = 359u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_CANADA: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_CARIBBEAN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_CHILE: u32 = 56u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_COLOMBIA: u32 = 57u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_COSTA_RICA: u32 = 506u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_CROATIA: u32 = 385u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_CZECH: u32 = 420u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_DENMARK: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_DOMINICAN_REPUBLIC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ECUADOR: u32 = 593u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_EGYPT: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_EL_SALVADOR: u32 = 503u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ESTONIA: u32 = 372u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_FAEROE_ISLANDS: u32 = 298u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_FINLAND: u32 = 358u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_FRANCE: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_GEORGIA: u32 = 995u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_GERMANY: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_GREECE: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_GUATEMALA: u32 = 502u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_HONDURAS: u32 = 504u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_HONG_KONG: u32 = 852u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_HUNGARY: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ICELAND: u32 = 354u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_INDIA: u32 = 91u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_INDONESIA: u32 = 62u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_IRAN: u32 = 981u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_IRAQ: u32 = 964u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_IRELAND: u32 = 353u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ISRAEL: u32 = 972u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ITALY: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_JAMAICA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_JAPAN: u32 = 81u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_JORDAN: u32 = 962u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_KAZAKSTAN: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_KENYA: u32 = 254u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_KUWAIT: u32 = 965u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_KYRGYZSTAN: u32 = 996u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LATVIA: u32 = 371u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LEBANON: u32 = 961u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LIBYA: u32 = 218u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LIECHTENSTEIN: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LITHUANIA: u32 = 370u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_LUXEMBOURG: u32 = 352u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MACAU: u32 = 853u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MACEDONIA: u32 = 389u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MALAYSIA: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MALDIVES: u32 = 960u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MEXICO: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MONACO: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MONGOLIA: u32 = 976u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_MOROCCO: u32 = 212u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_NETHERLANDS: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_NEW_ZEALAND: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_NICARAGUA: u32 = 505u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_NORWAY: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_OMAN: u32 = 968u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PAKISTAN: u32 = 92u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PANAMA: u32 = 507u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PARAGUAY: u32 = 595u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PERU: u32 = 51u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PHILIPPINES: u32 = 63u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_POLAND: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PORTUGAL: u32 = 351u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PRCHINA: u32 = 86u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_PUERTO_RICO: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_QATAR: u32 = 974u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ROMANIA: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_RUSSIA: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SAUDI_ARABIA: u32 = 966u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SERBIA: u32 = 381u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SINGAPORE: u32 = 65u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SLOVAK: u32 = 421u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SLOVENIA: u32 = 386u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SOUTH_AFRICA: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SOUTH_KOREA: u32 = 82u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SPAIN: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SWEDEN: u32 = 46u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SWITZERLAND: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_SYRIA: u32 = 963u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_TAIWAN: u32 = 886u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_TATARSTAN: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_THAILAND: u32 = 66u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_TRINIDAD_Y_TOBAGO: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_TUNISIA: u32 = 216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_TURKEY: u32 = 90u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_UAE: u32 = 971u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_UKRAINE: u32 = 380u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_UNITED_KINGDOM: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_UNITED_STATES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_URUGUAY: u32 = 598u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_UZBEKISTAN: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_VENEZUELA: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_VIET_NAM: u32 = 84u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_YEMEN: u32 = 967u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CTRY_ZIMBABWE: u32 = 263u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CT_CTYPE1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CT_CTYPE2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CT_CTYPE3: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_LANGUAGE_DETECTION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcf7e00b1_909b_4d95_a8f4_611f7c377702);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_SCRIPT_DETECTION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d64b439_6caf_4f6b_b688_e5d0f4faa7d7);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_BENGALI_TO_LATIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf4dfd825_91a4_489f_855e_9ad9bee55727);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_CYRILLIC_TO_LATIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3dd12a98_5afd_4903_a13f_e17e6c0bfe01);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_DEVANAGARI_TO_LATIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4a4dcfe_2661_4d02_9835_f48187109803);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_HANGUL_DECOMPOSITION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4ba2a721_e43d_41b7_b330_536ae1e48863);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_HANS_TO_HANT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3caccdc8_5590_42dc_9a7b_b5a6b5b3b63b);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_HANT_TO_HANS: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3a8333b_f4fc_42f6_a0c4_0462fe7317cb);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ELS_GUID_TRANSLITERATION_MALAYALAM_TO_LATIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8b983b1_f8bf_4a2b_bcd5_5b5ea20613e1);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ENUM_ALL_CALENDARS: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const FIND_ENDSWITH: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const FIND_FROMEND: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const FIND_FROMSTART: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const FIND_STARTSWITH: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEOID_NOT_AVAILABLE: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GSS_ALLOW_INHERITED_COMMON: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const HIGHLEVEL_SERVICE_TYPES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const HIGH_SURROGATE_END: u32 = 56319u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const HIGH_SURROGATE_START: u32 = 55296u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IDN_ALLOW_UNASSIGNED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IDN_EMAIL_ADDRESS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IDN_RAW_PUNYCODE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IDN_USE_STD3_ASCII_RULES: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCID_ALTERNATE_SORTS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_BYTEREV: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_FULLWIDTH: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_HALFWIDTH: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_HASH: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_HIRAGANA: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_KATAKANA: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_LINGUISTIC_CASING: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_LOWERCASE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_SIMPLIFIED_CHINESE: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_SORTHANDLE: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_SORTKEY: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_TITLECASE: u32 = 768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_TRADITIONAL_CHINESE: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCMAP_UPPERCASE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_ARABIC: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_ARMENIAN: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_BALTIC: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_CENTRAL_EUROPE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_CYRILLIC: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_GEORGIAN: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_GREEK: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_HEBREW: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_INDIC: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_JAPANESE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_KOREAN: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_SIMPLIFIED_CHINESE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_THAI: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_TRADITIONAL_CHINESE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_TURKIC: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_TURKISH: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_VIETNAMESE: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_WESTERN_EUROPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ALL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ALLOW_NEUTRAL_NAMES: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ALTERNATE_SORTS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_FONTSIGNATURE: u32 = 88u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICALENDARTYPE: u32 = 4105u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICENTURY: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICONSTRUCTEDLOCALE: u32 = 125u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICOUNTRY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICURRDIGITS: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ICURRENCY: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDATE: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDAYLZERO: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTANSICODEPAGE: u32 = 4100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTCODEPAGE: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTCOUNTRY: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTEBCDICCODEPAGE: u32 = 4114u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTLANGUAGE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDEFAULTMACCODEPAGE: u32 = 4113u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDIALINGCODE: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDIGITS: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IDIGITSUBSTITUTION: u32 = 4116u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IFIRSTDAYOFWEEK: u32 = 4108u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IFIRSTWEEKOFYEAR: u32 = 4109u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IGEOID: u32 = 91u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IINTLCURRDIGITS: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ILANGUAGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ILDATE: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ILZERO: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IMEASURE: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IMONLZERO: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGATIVEPERCENT: u32 = 116u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGCURR: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGNUMBER: u32 = 4112u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGSEPBYSPACE: u32 = 87u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGSIGNPOSN: u32 = 83u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEGSYMPRECEDES: u32 = 86u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_INEUTRAL: u32 = 113u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IOPTIONALCALENDAR: u32 = 4107u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IPAPERSIZE: u32 = 4106u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IPOSITIVEPERCENT: u32 = 117u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IPOSSEPBYSPACE: u32 = 85u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IPOSSIGNPOSN: u32 = 82u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IPOSSYMPRECEDES: u32 = 84u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IREADINGLAYOUT: u32 = 112u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ITIME: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ITIMEMARKPOSN: u32 = 4101u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_ITLZERO: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IUSEUTF8LEGACYACP: u32 = 1638u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_IUSEUTF8LEGACYOEMCP: u32 = 2457u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_NAME_INVARIANT: ::windows::core::PCWSTR = ::windows::w!("");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_NAME_SYSTEM_DEFAULT: ::windows::core::PCWSTR = ::windows::w!("!x-sys-default-locale");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_NEUTRALDATA: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_NOUSEROVERRIDE: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_REPLACEMENT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_RETURN_NUMBER: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_S1159: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_S2359: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVCTRYNAME: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME1: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME2: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME3: u32 = 51u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME4: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME5: u32 = 53u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME6: u32 = 54u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVDAYNAME7: u32 = 55u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVLANGNAME: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME1: u32 = 68u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME10: u32 = 77u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME11: u32 = 78u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME12: u32 = 79u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME13: u32 = 4111u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME2: u32 = 69u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME3: u32 = 70u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME4: u32 = 71u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME5: u32 = 72u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME6: u32 = 73u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME7: u32 = 74u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME8: u32 = 75u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SABBREVMONTHNAME9: u32 = 76u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SAM: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SCONSOLEFALLBACKNAME: u32 = 110u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SCOUNTRY: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SCURRENCY: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDATE: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME1: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME2: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME3: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME4: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME5: u32 = 46u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME6: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDAYNAME7: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDECIMAL: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SDURATION: u32 = 93u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGCOUNTRY: u32 = 4098u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGCURRNAME: u32 = 4103u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGLANGUAGE: u32 = 4097u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGLISHCOUNTRYNAME: u32 = 4098u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGLISHDISPLAYNAME: u32 = 114u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SENGLISHLANGUAGENAME: u32 = 4097u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SGROUPING: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SINTLSYMBOL: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SISO3166CTRYNAME: u32 = 90u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SISO3166CTRYNAME2: u32 = 104u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SISO639LANGNAME: u32 = 89u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SISO639LANGNAME2: u32 = 103u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SKEYBOARDSTOINSTALL: u32 = 94u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLANGDISPLAYNAME: u32 = 111u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLANGUAGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLIST: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLOCALIZEDCOUNTRYNAME: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLOCALIZEDDISPLAYNAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLOCALIZEDLANGUAGENAME: u32 = 111u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SLONGDATE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONDECIMALSEP: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONGROUPING: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHDAY: u32 = 120u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME1: u32 = 56u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME10: u32 = 65u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME11: u32 = 66u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME12: u32 = 67u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME13: u32 = 4110u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME2: u32 = 57u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME3: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME4: u32 = 59u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME5: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME6: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME7: u32 = 62u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME8: u32 = 63u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHNAME9: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SMONTHOUSANDSEP: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNAME: u32 = 92u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNAN: u32 = 105u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVECOUNTRYNAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVECTRYNAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVECURRNAME: u32 = 4104u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVEDIGITS: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVEDISPLAYNAME: u32 = 115u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVELANGNAME: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNATIVELANGUAGENAME: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNEGATIVESIGN: u32 = 81u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SNEGINFINITY: u32 = 107u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SOPENTYPELANGUAGETAG: u32 = 122u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPARENT: u32 = 109u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPECIFICDATA: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPERCENT: u32 = 118u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPERMILLE: u32 = 119u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPM: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPOSINFINITY: u32 = 106u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SPOSITIVESIGN: u32 = 80u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SRELATIVELONGDATE: u32 = 124u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSCRIPTS: u32 = 108u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTDATE: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTAM: u32 = 126u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME1: u32 = 96u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME2: u32 = 97u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME3: u32 = 98u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME4: u32 = 99u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME5: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME6: u32 = 101u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTDAYNAME7: u32 = 102u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTESTPM: u32 = 127u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSHORTTIME: u32 = 121u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSORTLOCALE: u32 = 123u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SSORTNAME: u32 = 4115u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_STHOUSAND: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_STIME: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_STIMEFORMAT: u32 = 4099u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SUPPLEMENTAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_SYEARMONTH: u32 = 4102u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_USE_CP_ACP: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOCALE_WINDOWS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOWLEVEL_SERVICE_TYPES: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOW_SURROGATE_END: u32 = 57343u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LOW_SURROGATE_START: u32 = 56320u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_DEFAULTCHAR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_LEADBYTES: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_LOCALE_NAME: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_MIMECP_NAME: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_MIMECSET_NAME: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_MIMEFACE_NAME: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_RFC1766_NAME: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAX_SCRIPT_NAME: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIN_SPELLING_NTDDI: u32 = 100794368u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_COMPLEX_SCRIPT_FILTER: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_CONSOLE_FILTER: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FILEINFO_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MAIN: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MUI: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FILETYPE_NOT_LANGUAGE_NEUTRAL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FORMAT_INF_COMPAT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FORMAT_REG_COMPAT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_FULL_LANGUAGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_IMMUTABLE_LOOKUP: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANGUAGE_EXACT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANGUAGE_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANGUAGE_INSTALLED: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANGUAGE_LICENSED: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANGUAGE_NAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LANG_NEUTRAL_PE_FILE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_LIP_LANGUAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_MACHINE_LANGUAGE_SETTINGS: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_MERGE_SYSTEM_FALLBACK: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_MERGE_USER_FALLBACK: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_NON_LANG_NEUTRAL_FILE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_PARTIAL_LANGUAGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_QUERY_CHECKSUM: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_QUERY_LANGUAGE_NAME: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_QUERY_RESOURCE_TYPES: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_QUERY_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_RESET_FILTERS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_SKIP_STRING_CACHE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_THREAD_LANGUAGES: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_USER_PREFERRED_UI_LANGUAGES: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_USE_INSTALLED_LANGUAGES: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_USE_SEARCH_ALL_LANGUAGES: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MUI_VERIFY_FILE_EXISTS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NLS_CP_CPINFO: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NLS_CP_MBTOWC: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NLS_CP_WCTOMB: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NUMSYS_NAME_CAPACITY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const OFFLINE_SERVICES: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ONLINE_SERVICES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_DIGITSUBSTITUTE_CONTEXT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_DIGITSUBSTITUTE_NATIONAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_DIGITSUBSTITUTE_NONE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_DIGITSUBSTITUTE_TRADITIONAL: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_TAG_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_UNDEFINED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SGCM_RTL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SORTING_PARADIGM_ICU: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SORTING_PARADIGM_NLS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_BREAK: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_CLIP: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_DONTGLYPH: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_DZWG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_FALLBACK: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_FIT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_FULLMEASURE: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_GCP: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_GLYPHS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_HIDEHOTKEY: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_HOTKEY: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_HOTKEYONLY: u32 = 9216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_LAYOUTRTL: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_LINK: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_LPKANSIFALLBACK: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_METAFILE: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_NOKASHIDA: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_PASSWORD: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_PIDX: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_RTL: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SSA_TAB: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SpellCheckerFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ab36653_1796_484b_bdfa_e74f1db7c1dc);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U16_MAX_LENGTH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U8_LEAD3_T1_BITS: ::windows::core::PCSTR = ::windows::s!(" 000000000000\u{10}00");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U8_LEAD4_T1_BITS: ::windows::core::PCSTR = ::windows::s!("\u{0}\u{0}\u{0}\u{0}\u{0}\u{0}\u{0}\u{0}\u{1e}\u{f}\u{f}\u{f}\u{0}\u{0}\u{0}\u{0}");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U8_MAX_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_DEFAULT_LTR: u32 = 254u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_DEFAULT_RTL: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_DO_MIRRORING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_INSERT_LRM_FOR_NUMERIC: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_KEEP_BASE_COMBINING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_LEVEL_OVERRIDE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_MAP_NOWHERE: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_MAX_EXPLICIT_LEVEL: u32 = 125u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_OUTPUT_REVERSE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REMOVE_BIDI_CONTROLS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_UNKNOWN_ZONE_ID: ::windows::core::PCSTR = ::windows::s!("Etc/Unknown");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCHAR_MAX_VALUE: u32 = 1114111u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCHAR_MIN_VALUE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCLN_NO_AUTO_CLEANUP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_C: ::windows::core::PCSTR = ::windows::s!("C");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_CSS2: ::windows::core::PCSTR = ::windows::s!("S");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_JAVA: ::windows::core::PCSTR = ::windows::s!("J");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_UNICODE: ::windows::core::PCSTR = ::windows::s!("U");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_XML_DEC: ::windows::core::PCSTR = ::windows::s!("D");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ESCAPE_XML_HEX: ::windows::core::PCSTR = ::windows::s!("X");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LOCALE_OPTION_STRING: ::windows::core::PCSTR = ::windows::s!(",locale=");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_MAX_CONVERTER_NAME_LENGTH: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_OPTION_SEP_STRING: ::windows::core::PCSTR = ::windows::s!(",");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SI: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SKIP_STOP_ON_ILLEGAL: ::windows::core::PCSTR = ::windows::s!("i");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SO: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SUB_STOP_ON_ILLEGAL: ::windows::core::PCSTR = ::windows::s!("i");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SWAP_LFNL_OPTION_STRING: ::windows::core::PCSTR = ::windows::s!(",swaplfnl");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_VALUE_SEP_STRING: ::windows::core::PCSTR = ::windows::s!("=");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_VERSION_OPTION_STRING: ::windows::core::PCSTR = ::windows::s!(",version=");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_ENABLE_PLUGINS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_FORMAT_FASTPATHS_49: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_HAVE_PARSEALLINPUT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_BREAK_ITERATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_COLLATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_CONVERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_FILE_IO: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_FILTERED_BREAK_ITERATION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_FORMATTING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_IDNA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_LEGACY_CONVERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_NORMALIZATION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_REGULAR_EXPRESSIONS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_SERVICE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_NO_TRANSLITERATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_ONLY_COLLATION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCONFIG_ONLY_HTML_CONVERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_ERROR_VALUE_NEG_DATA_OFFSET: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_FAST_DATA_BLOCK_LENGTH: i32 = 64i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_FAST_DATA_MASK: i32 = 63i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_FAST_SHIFT: i32 = 6i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_HIGH_VALUE_NEG_DATA_OFFSET: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_SMALL_MAX: i32 = 4095i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_GENERIC_TZ: ::windows::core::PCSTR = ::windows::s!("v");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_MONTH: ::windows::core::PCSTR = ::windows::s!("MMM");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("MMMd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("MMMEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_QUARTER: ::windows::core::PCSTR = ::windows::s!("QQQ");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_SPECIFIC_TZ: ::windows::core::PCSTR = ::windows::s!("z");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_UTC_TZ: ::windows::core::PCSTR = ::windows::s!("ZZZZ");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABBR_WEEKDAY: ::windows::core::PCSTR = ::windows::s!("E");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DAY: ::windows::core::PCSTR = ::windows::s!("d");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_GENERIC_TZ: ::windows::core::PCSTR = ::windows::s!("vvvv");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR: ::windows::core::PCSTR = ::windows::s!("j");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR24: ::windows::core::PCSTR = ::windows::s!("H");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR24_MINUTE: ::windows::core::PCSTR = ::windows::s!("Hm");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR24_MINUTE_SECOND: ::windows::core::PCSTR = ::windows::s!("Hms");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR_MINUTE: ::windows::core::PCSTR = ::windows::s!("jm");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR_MINUTE_SECOND: ::windows::core::PCSTR = ::windows::s!("jms");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_LOCATION_TZ: ::windows::core::PCSTR = ::windows::s!("VVVV");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MINUTE: ::windows::core::PCSTR = ::windows::s!("m");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MINUTE_SECOND: ::windows::core::PCSTR = ::windows::s!("ms");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MONTH: ::windows::core::PCSTR = ::windows::s!("MMMM");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("MMMMd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("MMMMEEEEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NUM_MONTH: ::windows::core::PCSTR = ::windows::s!("M");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NUM_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("Md");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NUM_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("MEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_QUARTER: ::windows::core::PCSTR = ::windows::s!("QQQQ");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SECOND: ::windows::core::PCSTR = ::windows::s!("s");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SPECIFIC_TZ: ::windows::core::PCSTR = ::windows::s!("zzzz");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_WEEKDAY: ::windows::core::PCSTR = ::windows::s!("EEEE");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR: ::windows::core::PCSTR = ::windows::s!("y");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_ABBR_MONTH: ::windows::core::PCSTR = ::windows::s!("yMMM");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_ABBR_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("yMMMd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_ABBR_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("yMMMEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_ABBR_QUARTER: ::windows::core::PCSTR = ::windows::s!("yQQQ");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_MONTH: ::windows::core::PCSTR = ::windows::s!("yMMMM");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("yMMMMd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("yMMMMEEEEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_NUM_MONTH: ::windows::core::PCSTR = ::windows::s!("yM");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_NUM_MONTH_DAY: ::windows::core::PCSTR = ::windows::s!("yMd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_NUM_MONTH_WEEKDAY_DAY: ::windows::core::PCSTR = ::windows::s!("yMEd");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_QUARTER: ::windows::core::PCSTR = ::windows::s!("yQQQQ");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_CHECK_BIDI: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_CHECK_CONTEXTJ: i32 = 8i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_CHECK_CONTEXTO: i32 = 64i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_DEFAULT: i32 = 0i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_BIDI: i32 = 2048i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_CONTEXTJ: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_CONTEXTO_DIGITS: i32 = 16384i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_CONTEXTO_PUNCTUATION: i32 = 8192i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_DISALLOWED: i32 = 128i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_DOMAIN_NAME_TOO_LONG: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_EMPTY_LABEL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_HYPHEN_3_4: i32 = 32i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_INVALID_ACE_LABEL: i32 = 1024i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_LABEL_HAS_DOT: i32 = 512i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_LABEL_TOO_LONG: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_LEADING_COMBINING_MARK: i32 = 64i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_LEADING_HYPHEN: i32 = 8i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_PUNYCODE: i32 = 256i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_ERROR_TRAILING_HYPHEN: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_NONTRANSITIONAL_TO_ASCII: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_NONTRANSITIONAL_TO_UNICODE: i32 = 32i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UIDNA_USE_STD3_RULES: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_UNKNOWN_INDEX: i32 = -2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_CANADA: ::windows::core::PCSTR = ::windows::s!("en_CA");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_CANADA_FRENCH: ::windows::core::PCSTR = ::windows::s!("fr_CA");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_CHINA: ::windows::core::PCSTR = ::windows::s!("zh_CN");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_CHINESE: ::windows::core::PCSTR = ::windows::s!("zh");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_COUNTRY_CAPACITY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ENGLISH: ::windows::core::PCSTR = ::windows::s!("en");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_FRANCE: ::windows::core::PCSTR = ::windows::s!("fr_FR");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_FRENCH: ::windows::core::PCSTR = ::windows::s!("fr");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_FULLNAME_CAPACITY: u32 = 157u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_GERMAN: ::windows::core::PCSTR = ::windows::s!("de");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_GERMANY: ::windows::core::PCSTR = ::windows::s!("de_DE");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ITALIAN: ::windows::core::PCSTR = ::windows::s!("it");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ITALY: ::windows::core::PCSTR = ::windows::s!("it_IT");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_JAPAN: ::windows::core::PCSTR = ::windows::s!("ja_JP");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_JAPANESE: ::windows::core::PCSTR = ::windows::s!("ja");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KEYWORDS_CAPACITY: u32 = 96u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KEYWORD_AND_VALUES_CAPACITY: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KEYWORD_ASSIGN_UNICODE: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KEYWORD_ITEM_SEPARATOR_UNICODE: u32 = 59u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KEYWORD_SEPARATOR_UNICODE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KOREA: ::windows::core::PCSTR = ::windows::s!("ko_KR");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_KOREAN: ::windows::core::PCSTR = ::windows::s!("ko");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_LANG_CAPACITY: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_PRC: ::windows::core::PCSTR = ::windows::s!("zh_CN");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_SCRIPT_CAPACITY: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_SIMPLIFIED_CHINESE: ::windows::core::PCSTR = ::windows::s!("zh_CN");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_TAIWAN: ::windows::core::PCSTR = ::windows::s!("zh_TW");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_TRADITIONAL_CHINESE: ::windows::core::PCSTR = ::windows::s!("zh_TW");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_UK: ::windows::core::PCSTR = ::windows::s!("en_GB");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_US: ::windows::core::PCSTR = ::windows::s!("en_US");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UMSGPAT_ARG_NAME_NOT_NUMBER: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UMSGPAT_ARG_NAME_NOT_VALID: i32 = -2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNISCRIBE_OPENTYPE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNORM_INPUT_IS_FCD: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USEARCH_DONE: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USET_ADD_CASE_MAPPINGS: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USET_CASE_INSENSITIVE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USET_IGNORE_SPACE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USET_SERIALIZED_STATIC_ARRAY_CAPACITY: i32 = 8i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USPREP_ALLOW_UNASSIGNED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USPREP_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const USP_E_SCRIPT_NOT_IN_FONT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147220992i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_MAGIC: i32 = 878368812i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_PROVIDER_HAS_META_DATA: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_PROVIDER_LENGTH_IS_EXPENSIVE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_PROVIDER_OWNS_TEXT: i32 = 5i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_PROVIDER_STABLE_CHUNKS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTEXT_PROVIDER_WRITABLE: i32 = 3i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF16_MAX_CHAR_LENGTH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF32_MAX_CHAR_LENGTH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF8_ERROR_VALUE_1: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF8_ERROR_VALUE_2: u32 = 159u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF8_MAX_CHAR_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF_ERROR_VALUE: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF_MAX_CHAR_LENGTH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UTF_SIZE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ASCII_FAMILY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHAR16_IS_TYPEDEF: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHARSET_FAMILY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHARSET_IS_UTF8: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHECK_DYLOAD: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COMBINED_IMPLEMENTATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COMPARE_CODE_POINT_ORDER: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COMPARE_IGNORE_CASE: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COPYRIGHT_STRING_LENGTH: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CPLUSPLUS_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DEBUG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DEFAULT_SHOW_DRAFT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DEFINE_FALSE_AND_TRUE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DISABLE_RENAMING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EBCDIC_FAMILY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EDITS_NO_RESET: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ENABLE_DYLOAD: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ENABLE_TRACING: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FOLD_CASE_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FOLD_CASE_EXCLUDE_SPECIAL_I: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_GCC_MAJOR_MINOR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_CHAR16_T: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_DEBUG_LOCATION_NEW: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_INTTYPES_H: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_LIB_SUFFIX: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_PLACEMENT_NEW: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_RBNF: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_RVALUE_REFERENCES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_STDINT_H: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_STD_STRING: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_WCHAR_H: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HAVE_WCSCPY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HIDE_DEPRECATED_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HIDE_DRAFT_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HIDE_INTERNAL_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HIDE_OBSOLETE_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_HIDE_OBSOLETE_UTF_OLD_H: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ICUDATA_TYPE_LETTER: ::windows::core::PCSTR = ::windows::s!("e");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ICU_DATA_KEY: ::windows::core::PCSTR = ::windows::s!("DataVersion");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ICU_VERSION_BUNDLE: ::windows::core::PCSTR = ::windows::s!("icuver");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_IOSTREAM_SOURCE: u32 = 199711u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_IS_BIG_ENDIAN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LIB_SUFFIX_C_NAME_STRING: ::windows::core::PCSTR = ::windows::s!("");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MAX_VERSION_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MAX_VERSION_STRING_LENGTH: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MILLIS_PER_DAY: u32 = 86400000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MILLIS_PER_HOUR: u32 = 3600000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MILLIS_PER_MINUTE: u32 = 60000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MILLIS_PER_SECOND: u32 = 1000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NO_DEFAULT_INCLUDE_UTF_HEADERS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OMIT_UNCHANGED_TEXT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OVERRIDE_CXX_ALLOCATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PARSE_CONTEXT_LEN: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_AIX: u32 = 3100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_ANDROID: u32 = 4050u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_BROWSER_NATIVE_CLIENT: u32 = 4020u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_BSD: u32 = 3000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_CYGWIN: u32 = 1900u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_DARWIN: u32 = 3500u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_EMSCRIPTEN: u32 = 5010u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_FUCHSIA: u32 = 4100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_HPUX: u32 = 2100u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_IPHONE: u32 = 3550u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_IRIX: u32 = 3200u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_LINUX: u32 = 4000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_MINGW: u32 = 1800u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_OS390: u32 = 9000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_OS400: u32 = 9400u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_QNX: u32 = 3700u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_SOLARIS: u32 = 2600u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PF_WINDOWS: u32 = 1000u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM: u32 = 1800u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_HAS_WIN32_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_HAS_WINUWP_API: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_IMPLEMENTS_POSIX: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_IS_DARWIN_BASED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_IS_LINUX_BASED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLATFORM_USES_ONLY_WIN32_API: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SENTINEL: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL_MASK: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_AGGREGATE_TASHKEEL_NOOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_ALEN2AN_INIT_AL: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_ALEN2AN_INIT_LR: u32 = 96u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_AN2EN: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_EN2AN: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_MASK: u32 = 224u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_NOOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGITS_RESERVED: u32 = 160u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGIT_TYPE_AN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGIT_TYPE_AN_EXTENDED: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGIT_TYPE_MASK: u32 = 768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_DIGIT_TYPE_RESERVED: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_AUTO: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_BEGIN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_END: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_MASK: u32 = 65539u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_NEAR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LAMALEF_RESIZE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_AT_BEGINNING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_AT_END: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LENGTH_FIXED_SPACES_NEAR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LENGTH_GROW_SHRINK: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LENGTH_MASK: u32 = 65539u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LETTERS_MASK: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LETTERS_NOOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LETTERS_SHAPE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LETTERS_SHAPE_TASHKEEL_ISOLATED: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_LETTERS_UNSHAPE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION_MASK: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_PRESERVE_PRESENTATION_NOOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_SEEN_MASK: u32 = 7340032u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_SEEN_TWOCELL_NEAR: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_SPACES_RELATIVE_TO_TEXT_BEGIN_END: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_SPACES_RELATIVE_TO_TEXT_MASK: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TAIL_NEW_UNICODE: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TAIL_TYPE_MASK: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TASHKEEL_BEGIN: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TASHKEEL_END: u32 = 393216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TASHKEEL_MASK: u32 = 917504u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TASHKEEL_REPLACE_BY_TATWEEL: u32 = 786432u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TASHKEEL_RESIZE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TEXT_DIRECTION_LOGICAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TEXT_DIRECTION_MASK: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TEXT_DIRECTION_VISUAL_LTR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_TEXT_DIRECTION_VISUAL_RTL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_YEHHAMZA_MASK: u32 = 58720256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHAPE_YEHHAMZA_TWOCELL_NEAR: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SHOW_CPLUSPLUS_API: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SIZEOF_UCHAR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SIZEOF_WCHAR_T: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_ADJUST_TO_CASED: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_NO_BREAK_ADJUSTMENT: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_NO_LOWERCASE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_SENTENCES: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_WHOLE_STRING: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNICODE_VERSION: ::windows::core::PCSTR = ::windows::s!("8.0");
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_USING_ICU_NAMESPACE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const VS_ALLOW_LATIN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_COMPOSITECHECK: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_DEFAULTCHAR: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_DISCARDNS: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_ERR_INVALID_CHARS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_NO_BEST_FIT_CHARS: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const WC_SEPCHARS: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct COMPARE_STRING_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LINGUISTIC_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LINGUISTIC_IGNOREDIACRITIC: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_IGNOREKANATYPE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(65536u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_IGNORENONSPACE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_IGNORESYMBOLS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_IGNOREWIDTH: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(131072u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NORM_LINGUISTIC_CASING: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(134217728u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SORT_DIGITSASNUMBERS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SORT_STRINGSORT: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4096u32);
impl ::core::marker::Copy for COMPARE_STRING_FLAGS {}
impl ::core::clone::Clone for COMPARE_STRING_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for COMPARE_STRING_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for COMPARE_STRING_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for COMPARE_STRING_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("COMPARE_STRING_FLAGS").field(&self.0).finish()
    }
}
impl COMPARE_STRING_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for COMPARE_STRING_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for COMPARE_STRING_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CORRECTIVE_ACTION(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CORRECTIVE_ACTION_NONE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CORRECTIVE_ACTION_GET_SUGGESTIONS: CORRECTIVE_ACTION = CORRECTIVE_ACTION(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CORRECTIVE_ACTION_REPLACE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CORRECTIVE_ACTION_DELETE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(3i32);
impl ::core::marker::Copy for CORRECTIVE_ACTION {}
impl ::core::clone::Clone for CORRECTIVE_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CORRECTIVE_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for CORRECTIVE_ACTION {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for CORRECTIVE_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CORRECTIVE_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ENUM_DATE_FORMATS_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_SHORTDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_LONGDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_YEARMONTH: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_MONTHDAY: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_AUTOLAYOUT: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_LTRREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_RTLREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const DATE_USE_ALT_CALENDAR: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(4u32);
impl ::core::marker::Copy for ENUM_DATE_FORMATS_FLAGS {}
impl ::core::clone::Clone for ENUM_DATE_FORMATS_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ENUM_DATE_FORMATS_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for ENUM_DATE_FORMATS_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for ENUM_DATE_FORMATS_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ENUM_DATE_FORMATS_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ENUM_SYSTEM_CODE_PAGES_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_INSTALLED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const CP_SUPPORTED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(2u32);
impl ::core::marker::Copy for ENUM_SYSTEM_CODE_PAGES_FLAGS {}
impl ::core::clone::Clone for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ENUM_SYSTEM_CODE_PAGES_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_INSTALLED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS = ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LGRPID_SUPPORTED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS = ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(2u32);
impl ::core::marker::Copy for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {}
impl ::core::clone::Clone for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLD_STRING_MAP_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAP_COMPOSITE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAP_EXPAND_LIGATURES: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(8192u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAP_FOLDCZONE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAP_FOLDDIGITS: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MAP_PRECOMPOSED: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(32u32);
impl ::core::marker::Copy for FOLD_STRING_MAP_FLAGS {}
impl ::core::clone::Clone for FOLD_STRING_MAP_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLD_STRING_MAP_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for FOLD_STRING_MAP_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for FOLD_STRING_MAP_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLD_STRING_MAP_FLAGS").field(&self.0).finish()
    }
}
impl FOLD_STRING_MAP_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for FOLD_STRING_MAP_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for FOLD_STRING_MAP_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct IS_TEXT_UNICODE_RESULT(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_REVERSE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(16u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_STATISTICS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_REVERSE_STATISTICS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(32u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_REVERSE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(64u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_SIGNATURE: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(8u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_REVERSE_SIGNATURE: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(128u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_ILLEGAL_CHARS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(256u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_ODD_LENGTH: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(512u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_NULL_BYTES: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4096u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_UNICODE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(15u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_REVERSE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(240u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_NOT_UNICODE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(3840u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const IS_TEXT_UNICODE_NOT_ASCII_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(61440u32);
impl ::core::marker::Copy for IS_TEXT_UNICODE_RESULT {}
impl ::core::clone::Clone for IS_TEXT_UNICODE_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for IS_TEXT_UNICODE_RESULT {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for IS_TEXT_UNICODE_RESULT {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for IS_TEXT_UNICODE_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IS_TEXT_UNICODE_RESULT").field(&self.0).finish()
    }
}
impl IS_TEXT_UNICODE_RESULT {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for IS_TEXT_UNICODE_RESULT {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for IS_TEXT_UNICODE_RESULT {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct IS_VALID_LOCALE_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCID_INSTALLED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const LCID_SUPPORTED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(2u32);
impl ::core::marker::Copy for IS_VALID_LOCALE_FLAGS {}
impl ::core::clone::Clone for IS_VALID_LOCALE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for IS_VALID_LOCALE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for IS_VALID_LOCALE_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for IS_VALID_LOCALE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IS_VALID_LOCALE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MIMECONTF(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_MAILNEWS: MIMECONTF = MIMECONTF(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_BROWSER: MIMECONTF = MIMECONTF(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_MINIMAL: MIMECONTF = MIMECONTF(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_IMPORT: MIMECONTF = MIMECONTF(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_SAVABLE_MAILNEWS: MIMECONTF = MIMECONTF(256i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_SAVABLE_BROWSER: MIMECONTF = MIMECONTF(512i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_EXPORT: MIMECONTF = MIMECONTF(1024i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_PRIVCONVERTER: MIMECONTF = MIMECONTF(65536i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_VALID: MIMECONTF = MIMECONTF(131072i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_VALID_NLS: MIMECONTF = MIMECONTF(262144i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_MIME_IE4: MIMECONTF = MIMECONTF(268435456i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_MIME_LATEST: MIMECONTF = MIMECONTF(536870912i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MIMECONTF_MIME_REGISTRY: MIMECONTF = MIMECONTF(1073741824i32);
impl ::core::marker::Copy for MIMECONTF {}
impl ::core::clone::Clone for MIMECONTF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MIMECONTF {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MIMECONTF {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MIMECONTF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MIMECONTF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MLCONVCHAR(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_AUTODETECT: MLCONVCHAR = MLCONVCHAR(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_ENTITIZE: MLCONVCHAR = MLCONVCHAR(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_NCR_ENTITIZE: MLCONVCHAR = MLCONVCHAR(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_NAME_ENTITIZE: MLCONVCHAR = MLCONVCHAR(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_USEDEFCHAR: MLCONVCHAR = MLCONVCHAR(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_NOBESTFITCHARS: MLCONVCHAR = MLCONVCHAR(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLCONVCHARF_DETECTJPN: MLCONVCHAR = MLCONVCHAR(32i32);
impl ::core::marker::Copy for MLCONVCHAR {}
impl ::core::clone::Clone for MLCONVCHAR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MLCONVCHAR {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MLCONVCHAR {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MLCONVCHAR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MLCONVCHAR").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MLCP(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_MAILNEWS: MLCP = MLCP(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_BROWSER: MLCP = MLCP(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_VALID: MLCP = MLCP(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_VALID_NLS: MLCP = MLCP(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_PRESERVE_ORDER: MLCP = MLCP(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_PREFERRED_ONLY: MLCP = MLCP(32i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_FILTER_SPECIALCHAR: MLCP = MLCP(64i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTF_EURO_UTF8: MLCP = MLCP(128i32);
impl ::core::marker::Copy for MLCP {}
impl ::core::clone::Clone for MLCP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MLCP {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MLCP {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MLCP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MLCP").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MLDETECTCP(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_NONE: MLDETECTCP = MLDETECTCP(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_7BIT: MLDETECTCP = MLDETECTCP(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_8BIT: MLDETECTCP = MLDETECTCP(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_DBCS: MLDETECTCP = MLDETECTCP(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_HTML: MLDETECTCP = MLDETECTCP(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLDETECTCP_NUMBER: MLDETECTCP = MLDETECTCP(16i32);
impl ::core::marker::Copy for MLDETECTCP {}
impl ::core::clone::Clone for MLDETECTCP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MLDETECTCP {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MLDETECTCP {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MLDETECTCP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MLDETECTCP").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MLSTR_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLSTR_READ: MLSTR_FLAGS = MLSTR_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MLSTR_WRITE: MLSTR_FLAGS = MLSTR_FLAGS(2i32);
impl ::core::marker::Copy for MLSTR_FLAGS {}
impl ::core::clone::Clone for MLSTR_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MLSTR_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MLSTR_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MLSTR_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MLSTR_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MULTI_BYTE_TO_WIDE_CHAR_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MB_COMPOSITE: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MB_ERR_INVALID_CHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MB_PRECOMPOSED: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const MB_USEGLYPHCHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(4u32);
impl ::core::marker::Copy for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {}
impl ::core::clone::Clone for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MULTI_BYTE_TO_WIDE_CHAR_FLAGS").field(&self.0).finish()
    }
}
impl MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct NORM_FORM(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NormalizationOther: NORM_FORM = NORM_FORM(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NormalizationC: NORM_FORM = NORM_FORM(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NormalizationD: NORM_FORM = NORM_FORM(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NormalizationKC: NORM_FORM = NORM_FORM(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const NormalizationKD: NORM_FORM = NORM_FORM(6i32);
impl ::core::marker::Copy for NORM_FORM {}
impl ::core::clone::Clone for NORM_FORM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for NORM_FORM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for NORM_FORM {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for NORM_FORM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("NORM_FORM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SCRIPTCONTF(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidDefault: SCRIPTCONTF = SCRIPTCONTF(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidMerge: SCRIPTCONTF = SCRIPTCONTF(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidAsciiSym: SCRIPTCONTF = SCRIPTCONTF(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidAsciiLatin: SCRIPTCONTF = SCRIPTCONTF(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidLatin: SCRIPTCONTF = SCRIPTCONTF(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidGreek: SCRIPTCONTF = SCRIPTCONTF(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidCyrillic: SCRIPTCONTF = SCRIPTCONTF(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidArmenian: SCRIPTCONTF = SCRIPTCONTF(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidHebrew: SCRIPTCONTF = SCRIPTCONTF(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidArabic: SCRIPTCONTF = SCRIPTCONTF(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidDevanagari: SCRIPTCONTF = SCRIPTCONTF(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidBengali: SCRIPTCONTF = SCRIPTCONTF(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidGurmukhi: SCRIPTCONTF = SCRIPTCONTF(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidGujarati: SCRIPTCONTF = SCRIPTCONTF(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidOriya: SCRIPTCONTF = SCRIPTCONTF(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidTamil: SCRIPTCONTF = SCRIPTCONTF(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidTelugu: SCRIPTCONTF = SCRIPTCONTF(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidKannada: SCRIPTCONTF = SCRIPTCONTF(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidMalayalam: SCRIPTCONTF = SCRIPTCONTF(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidThai: SCRIPTCONTF = SCRIPTCONTF(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidLao: SCRIPTCONTF = SCRIPTCONTF(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidTibetan: SCRIPTCONTF = SCRIPTCONTF(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidGeorgian: SCRIPTCONTF = SCRIPTCONTF(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidHangul: SCRIPTCONTF = SCRIPTCONTF(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidKana: SCRIPTCONTF = SCRIPTCONTF(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidBopomofo: SCRIPTCONTF = SCRIPTCONTF(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidHan: SCRIPTCONTF = SCRIPTCONTF(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidEthiopic: SCRIPTCONTF = SCRIPTCONTF(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidCanSyllabic: SCRIPTCONTF = SCRIPTCONTF(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidCherokee: SCRIPTCONTF = SCRIPTCONTF(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidYi: SCRIPTCONTF = SCRIPTCONTF(30i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidBraille: SCRIPTCONTF = SCRIPTCONTF(31i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidRunic: SCRIPTCONTF = SCRIPTCONTF(32i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidOgham: SCRIPTCONTF = SCRIPTCONTF(33i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidSinhala: SCRIPTCONTF = SCRIPTCONTF(34i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidSyriac: SCRIPTCONTF = SCRIPTCONTF(35i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidBurmese: SCRIPTCONTF = SCRIPTCONTF(36i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidKhmer: SCRIPTCONTF = SCRIPTCONTF(37i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidThaana: SCRIPTCONTF = SCRIPTCONTF(38i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidMongolian: SCRIPTCONTF = SCRIPTCONTF(39i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidUserDefined: SCRIPTCONTF = SCRIPTCONTF(40i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidLim: SCRIPTCONTF = SCRIPTCONTF(41i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidFEFirst: SCRIPTCONTF = SCRIPTCONTF(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const sidFELast: SCRIPTCONTF = SCRIPTCONTF(26i32);
impl ::core::marker::Copy for SCRIPTCONTF {}
impl ::core::clone::Clone for SCRIPTCONTF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SCRIPTCONTF {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SCRIPTCONTF {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SCRIPTCONTF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SCRIPTCONTF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SCRIPTFONTCONTF(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPTCONTF_FIXED_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPTCONTF_PROPORTIONAL_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPTCONTF_SCRIPT_USER: SCRIPTFONTCONTF = SCRIPTFONTCONTF(65536i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPTCONTF_SCRIPT_HIDE: SCRIPTFONTCONTF = SCRIPTFONTCONTF(131072i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPTCONTF_SCRIPT_SYSTEM: SCRIPTFONTCONTF = SCRIPTFONTCONTF(262144i32);
impl ::core::marker::Copy for SCRIPTFONTCONTF {}
impl ::core::clone::Clone for SCRIPTFONTCONTF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SCRIPTFONTCONTF {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SCRIPTFONTCONTF {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SCRIPTFONTCONTF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SCRIPTFONTCONTF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SCRIPT_IS_COMPLEX_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SIC_ASCIIDIGIT: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SIC_COMPLEX: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SIC_NEUTRAL: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(4u32);
impl ::core::marker::Copy for SCRIPT_IS_COMPLEX_FLAGS {}
impl ::core::clone::Clone for SCRIPT_IS_COMPLEX_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SCRIPT_IS_COMPLEX_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SCRIPT_IS_COMPLEX_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SCRIPT_IS_COMPLEX_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SCRIPT_IS_COMPLEX_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SCRIPT_JUSTIFY(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_NONE: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_CHARACTER: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_RESERVED1: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_RESERVED2: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_RESERVED3: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_NORMAL: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_KASHIDA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_ALEF: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_HA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_RA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_BA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_BARA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_SEEN: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const SCRIPT_JUSTIFY_ARABIC_SEEN_M: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(15i32);
impl ::core::marker::Copy for SCRIPT_JUSTIFY {}
impl ::core::clone::Clone for SCRIPT_JUSTIFY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SCRIPT_JUSTIFY {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SCRIPT_JUSTIFY {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SCRIPT_JUSTIFY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SCRIPT_JUSTIFY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SYSGEOCLASS(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEOCLASS_NATION: SYSGEOCLASS = SYSGEOCLASS(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEOCLASS_REGION: SYSGEOCLASS = SYSGEOCLASS(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEOCLASS_ALL: SYSGEOCLASS = SYSGEOCLASS(0i32);
impl ::core::marker::Copy for SYSGEOCLASS {}
impl ::core::clone::Clone for SYSGEOCLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SYSGEOCLASS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SYSGEOCLASS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SYSGEOCLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SYSGEOCLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SYSGEOTYPE(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_NATION: SYSGEOTYPE = SYSGEOTYPE(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_LATITUDE: SYSGEOTYPE = SYSGEOTYPE(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_LONGITUDE: SYSGEOTYPE = SYSGEOTYPE(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_ISO2: SYSGEOTYPE = SYSGEOTYPE(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_ISO3: SYSGEOTYPE = SYSGEOTYPE(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_RFC1766: SYSGEOTYPE = SYSGEOTYPE(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_LCID: SYSGEOTYPE = SYSGEOTYPE(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_FRIENDLYNAME: SYSGEOTYPE = SYSGEOTYPE(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_OFFICIALNAME: SYSGEOTYPE = SYSGEOTYPE(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_TIMEZONES: SYSGEOTYPE = SYSGEOTYPE(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_OFFICIALLANGUAGES: SYSGEOTYPE = SYSGEOTYPE(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_ISO_UN_NUMBER: SYSGEOTYPE = SYSGEOTYPE(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_PARENT: SYSGEOTYPE = SYSGEOTYPE(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_DIALINGCODE: SYSGEOTYPE = SYSGEOTYPE(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_CURRENCYCODE: SYSGEOTYPE = SYSGEOTYPE(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_CURRENCYSYMBOL: SYSGEOTYPE = SYSGEOTYPE(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_NAME: SYSGEOTYPE = SYSGEOTYPE(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const GEO_ID: SYSGEOTYPE = SYSGEOTYPE(18i32);
impl ::core::marker::Copy for SYSGEOTYPE {}
impl ::core::clone::Clone for SYSGEOTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SYSGEOTYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SYSGEOTYPE {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SYSGEOTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SYSGEOTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SYSNLS_FUNCTION(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const COMPARE_STRING: SYSNLS_FUNCTION = SYSNLS_FUNCTION(1i32);
impl ::core::marker::Copy for SYSNLS_FUNCTION {}
impl ::core::clone::Clone for SYSNLS_FUNCTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SYSNLS_FUNCTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for SYSNLS_FUNCTION {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for SYSNLS_FUNCTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SYSNLS_FUNCTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct TIME_FORMAT_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TIME_NOMINUTESORSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TIME_NOSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TIME_NOTIMEMARKER: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TIME_FORCE24HOURFORMAT: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(8u32);
impl ::core::marker::Copy for TIME_FORMAT_FLAGS {}
impl ::core::clone::Clone for TIME_FORMAT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for TIME_FORMAT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for TIME_FORMAT_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for TIME_FORMAT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("TIME_FORMAT_FLAGS").field(&self.0).finish()
    }
}
impl TIME_FORMAT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for TIME_FORMAT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for TIME_FORMAT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct TRANSLATE_CHARSET_INFO_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TCI_SRCCHARSET: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TCI_SRCCODEPAGE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TCI_SRCFONTSIG: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(3u32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const TCI_SRCLOCALE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(4096u32);
impl ::core::marker::Copy for TRANSLATE_CHARSET_INFO_FLAGS {}
impl ::core::clone::Clone for TRANSLATE_CHARSET_INFO_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for TRANSLATE_CHARSET_INFO_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for TRANSLATE_CHARSET_INFO_FLAGS {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for TRANSLATE_CHARSET_INFO_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("TRANSLATE_CHARSET_INFO_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UAcceptResult(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ACCEPT_FAILED: UAcceptResult = UAcceptResult(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ACCEPT_VALID: UAcceptResult = UAcceptResult(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULOC_ACCEPT_FALLBACK: UAcceptResult = UAcceptResult(2i32);
impl ::core::marker::Copy for UAcceptResult {}
impl ::core::clone::Clone for UAcceptResult {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UAcceptResult {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UAcceptResult {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UAcceptResult {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UAcceptResult").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UAlphabeticIndexLabelType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ALPHAINDEX_NORMAL: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ALPHAINDEX_UNDERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ALPHAINDEX_INFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ALPHAINDEX_OVERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(3i32);
impl ::core::marker::Copy for UAlphabeticIndexLabelType {}
impl ::core::clone::Clone for UAlphabeticIndexLabelType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UAlphabeticIndexLabelType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UAlphabeticIndexLabelType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UAlphabeticIndexLabelType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UAlphabeticIndexLabelType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBiDiDirection(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_LTR: UBiDiDirection = UBiDiDirection(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_RTL: UBiDiDirection = UBiDiDirection(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_MIXED: UBiDiDirection = UBiDiDirection(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_NEUTRAL: UBiDiDirection = UBiDiDirection(3i32);
impl ::core::marker::Copy for UBiDiDirection {}
impl ::core::clone::Clone for UBiDiDirection {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBiDiDirection {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBiDiDirection {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBiDiDirection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBiDiDirection").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBiDiMirroring(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_MIRRORING_OFF: UBiDiMirroring = UBiDiMirroring(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_MIRRORING_ON: UBiDiMirroring = UBiDiMirroring(1i32);
impl ::core::marker::Copy for UBiDiMirroring {}
impl ::core::clone::Clone for UBiDiMirroring {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBiDiMirroring {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBiDiMirroring {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBiDiMirroring {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBiDiMirroring").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBiDiOrder(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_LOGICAL: UBiDiOrder = UBiDiOrder(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_VISUAL: UBiDiOrder = UBiDiOrder(1i32);
impl ::core::marker::Copy for UBiDiOrder {}
impl ::core::clone::Clone for UBiDiOrder {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBiDiOrder {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBiDiOrder {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBiDiOrder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBiDiOrder").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBiDiReorderingMode(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_DEFAULT: UBiDiReorderingMode = UBiDiReorderingMode(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_NUMBERS_SPECIAL: UBiDiReorderingMode = UBiDiReorderingMode(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_GROUP_NUMBERS_WITH_R: UBiDiReorderingMode = UBiDiReorderingMode(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_RUNS_ONLY: UBiDiReorderingMode = UBiDiReorderingMode(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_INVERSE_NUMBERS_AS_L: UBiDiReorderingMode = UBiDiReorderingMode(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_INVERSE_LIKE_DIRECT: UBiDiReorderingMode = UBiDiReorderingMode(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_REORDER_INVERSE_FOR_NUMBERS_SPECIAL: UBiDiReorderingMode = UBiDiReorderingMode(6i32);
impl ::core::marker::Copy for UBiDiReorderingMode {}
impl ::core::clone::Clone for UBiDiReorderingMode {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBiDiReorderingMode {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBiDiReorderingMode {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBiDiReorderingMode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBiDiReorderingMode").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBiDiReorderingOption(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_OPTION_DEFAULT: UBiDiReorderingOption = UBiDiReorderingOption(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_OPTION_INSERT_MARKS: UBiDiReorderingOption = UBiDiReorderingOption(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_OPTION_REMOVE_CONTROLS: UBiDiReorderingOption = UBiDiReorderingOption(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBIDI_OPTION_STREAMING: UBiDiReorderingOption = UBiDiReorderingOption(4i32);
impl ::core::marker::Copy for UBiDiReorderingOption {}
impl ::core::clone::Clone for UBiDiReorderingOption {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBiDiReorderingOption {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBiDiReorderingOption {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBiDiReorderingOption {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBiDiReorderingOption").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBidiPairedBracketType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BPT_NONE: UBidiPairedBracketType = UBidiPairedBracketType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BPT_OPEN: UBidiPairedBracketType = UBidiPairedBracketType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BPT_CLOSE: UBidiPairedBracketType = UBidiPairedBracketType(2i32);
impl ::core::marker::Copy for UBidiPairedBracketType {}
impl ::core::clone::Clone for UBidiPairedBracketType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBidiPairedBracketType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBidiPairedBracketType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBidiPairedBracketType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBidiPairedBracketType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBlockCode(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NO_BLOCK: UBlockCode = UBlockCode(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BASIC_LATIN: UBlockCode = UBlockCode(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_1_SUPPLEMENT: UBlockCode = UBlockCode(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_A: UBlockCode = UBlockCode(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_B: UBlockCode = UBlockCode(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_IPA_EXTENSIONS: UBlockCode = UBlockCode(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SPACING_MODIFIER_LETTERS: UBlockCode = UBlockCode(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS: UBlockCode = UBlockCode(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GREEK: UBlockCode = UBlockCode(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC: UBlockCode = UBlockCode(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARMENIAN: UBlockCode = UBlockCode(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HEBREW: UBlockCode = UBlockCode(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC: UBlockCode = UBlockCode(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SYRIAC: UBlockCode = UBlockCode(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_THAANA: UBlockCode = UBlockCode(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DEVANAGARI: UBlockCode = UBlockCode(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BENGALI: UBlockCode = UBlockCode(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GURMUKHI: UBlockCode = UBlockCode(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GUJARATI: UBlockCode = UBlockCode(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ORIYA: UBlockCode = UBlockCode(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAMIL: UBlockCode = UBlockCode(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TELUGU: UBlockCode = UBlockCode(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KANNADA: UBlockCode = UBlockCode(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MALAYALAM: UBlockCode = UBlockCode(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SINHALA: UBlockCode = UBlockCode(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_THAI: UBlockCode = UBlockCode(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LAO: UBlockCode = UBlockCode(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TIBETAN: UBlockCode = UBlockCode(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MYANMAR: UBlockCode = UBlockCode(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GEORGIAN: UBlockCode = UBlockCode(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANGUL_JAMO: UBlockCode = UBlockCode(30i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ETHIOPIC: UBlockCode = UBlockCode(31i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHEROKEE: UBlockCode = UBlockCode(32i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS: UBlockCode = UBlockCode(33i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OGHAM: UBlockCode = UBlockCode(34i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_RUNIC: UBlockCode = UBlockCode(35i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHMER: UBlockCode = UBlockCode(36i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MONGOLIAN: UBlockCode = UBlockCode(37i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_ADDITIONAL: UBlockCode = UBlockCode(38i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GREEK_EXTENDED: UBlockCode = UBlockCode(39i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GENERAL_PUNCTUATION: UBlockCode = UBlockCode(40i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS: UBlockCode = UBlockCode(41i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CURRENCY_SYMBOLS: UBlockCode = UBlockCode(42i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMBINING_MARKS_FOR_SYMBOLS: UBlockCode = UBlockCode(43i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LETTERLIKE_SYMBOLS: UBlockCode = UBlockCode(44i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NUMBER_FORMS: UBlockCode = UBlockCode(45i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARROWS: UBlockCode = UBlockCode(46i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(47i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_TECHNICAL: UBlockCode = UBlockCode(48i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CONTROL_PICTURES: UBlockCode = UBlockCode(49i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OPTICAL_CHARACTER_RECOGNITION: UBlockCode = UBlockCode(50i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ENCLOSED_ALPHANUMERICS: UBlockCode = UBlockCode(51i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BOX_DRAWING: UBlockCode = UBlockCode(52i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BLOCK_ELEMENTS: UBlockCode = UBlockCode(53i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GEOMETRIC_SHAPES: UBlockCode = UBlockCode(54i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_SYMBOLS: UBlockCode = UBlockCode(55i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DINGBATS: UBlockCode = UBlockCode(56i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BRAILLE_PATTERNS: UBlockCode = UBlockCode(57i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_RADICALS_SUPPLEMENT: UBlockCode = UBlockCode(58i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KANGXI_RADICALS: UBlockCode = UBlockCode(59i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS: UBlockCode = UBlockCode(60i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(61i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HIRAGANA: UBlockCode = UBlockCode(62i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KATAKANA: UBlockCode = UBlockCode(63i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BOPOMOFO: UBlockCode = UBlockCode(64i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANGUL_COMPATIBILITY_JAMO: UBlockCode = UBlockCode(65i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KANBUN: UBlockCode = UBlockCode(66i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BOPOMOFO_EXTENDED: UBlockCode = UBlockCode(67i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS: UBlockCode = UBlockCode(68i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_COMPATIBILITY: UBlockCode = UBlockCode(69i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A: UBlockCode = UBlockCode(70i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS: UBlockCode = UBlockCode(71i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_YI_SYLLABLES: UBlockCode = UBlockCode(72i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_YI_RADICALS: UBlockCode = UBlockCode(73i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANGUL_SYLLABLES: UBlockCode = UBlockCode(74i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HIGH_SURROGATES: UBlockCode = UBlockCode(75i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HIGH_PRIVATE_USE_SURROGATES: UBlockCode = UBlockCode(76i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LOW_SURROGATES: UBlockCode = UBlockCode(77i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PRIVATE_USE_AREA: UBlockCode = UBlockCode(78i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PRIVATE_USE: UBlockCode = UBlockCode(78i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS: UBlockCode = UBlockCode(79i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ALPHABETIC_PRESENTATION_FORMS: UBlockCode = UBlockCode(80i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_A: UBlockCode = UBlockCode(81i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMBINING_HALF_MARKS: UBlockCode = UBlockCode(82i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_COMPATIBILITY_FORMS: UBlockCode = UBlockCode(83i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SMALL_FORM_VARIANTS: UBlockCode = UBlockCode(84i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_B: UBlockCode = UBlockCode(85i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SPECIALS: UBlockCode = UBlockCode(86i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS: UBlockCode = UBlockCode(87i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_ITALIC: UBlockCode = UBlockCode(88i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GOTHIC: UBlockCode = UBlockCode(89i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DESERET: UBlockCode = UBlockCode(90i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BYZANTINE_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(91i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(92i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS: UBlockCode = UBlockCode(93i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B: UBlockCode = UBlockCode(94i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT: UBlockCode = UBlockCode(95i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAGS: UBlockCode = UBlockCode(96i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC_SUPPLEMENT: UBlockCode = UBlockCode(97i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC_SUPPLEMENTARY: UBlockCode = UBlockCode(97i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAGALOG: UBlockCode = UBlockCode(98i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANUNOO: UBlockCode = UBlockCode(99i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BUHID: UBlockCode = UBlockCode(100i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAGBANWA: UBlockCode = UBlockCode(101i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A: UBlockCode = UBlockCode(102i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_ARROWS_A: UBlockCode = UBlockCode(103i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_ARROWS_B: UBlockCode = UBlockCode(104i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B: UBlockCode = UBlockCode(105i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(106i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KATAKANA_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(107i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_VARIATION_SELECTORS: UBlockCode = UBlockCode(108i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A: UBlockCode = UBlockCode(109i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B: UBlockCode = UBlockCode(110i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LIMBU: UBlockCode = UBlockCode(111i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAI_LE: UBlockCode = UBlockCode(112i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHMER_SYMBOLS: UBlockCode = UBlockCode(113i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(114i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS: UBlockCode = UBlockCode(115i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_YIJING_HEXAGRAM_SYMBOLS: UBlockCode = UBlockCode(116i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LINEAR_B_SYLLABARY: UBlockCode = UBlockCode(117i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LINEAR_B_IDEOGRAMS: UBlockCode = UBlockCode(118i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_AEGEAN_NUMBERS: UBlockCode = UBlockCode(119i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_UGARITIC: UBlockCode = UBlockCode(120i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SHAVIAN: UBlockCode = UBlockCode(121i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OSMANYA: UBlockCode = UBlockCode(122i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYPRIOT_SYLLABARY: UBlockCode = UBlockCode(123i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAI_XUAN_JING_SYMBOLS: UBlockCode = UBlockCode(124i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_VARIATION_SELECTORS_SUPPLEMENT: UBlockCode = UBlockCode(125i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION: UBlockCode = UBlockCode(126i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ANCIENT_GREEK_NUMBERS: UBlockCode = UBlockCode(127i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC_SUPPLEMENT: UBlockCode = UBlockCode(128i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BUGINESE: UBlockCode = UBlockCode(129i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_STROKES: UBlockCode = UBlockCode(130i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT: UBlockCode = UBlockCode(131i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COPTIC: UBlockCode = UBlockCode(132i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ETHIOPIC_EXTENDED: UBlockCode = UBlockCode(133i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ETHIOPIC_SUPPLEMENT: UBlockCode = UBlockCode(134i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GEORGIAN_SUPPLEMENT: UBlockCode = UBlockCode(135i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GLAGOLITIC: UBlockCode = UBlockCode(136i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHAROSHTHI: UBlockCode = UBlockCode(137i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MODIFIER_TONE_LETTERS: UBlockCode = UBlockCode(138i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NEW_TAI_LUE: UBlockCode = UBlockCode(139i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_PERSIAN: UBlockCode = UBlockCode(140i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT: UBlockCode = UBlockCode(141i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_PUNCTUATION: UBlockCode = UBlockCode(142i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SYLOTI_NAGRI: UBlockCode = UBlockCode(143i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TIFINAGH: UBlockCode = UBlockCode(144i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_VERTICAL_FORMS: UBlockCode = UBlockCode(145i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NKO: UBlockCode = UBlockCode(146i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BALINESE: UBlockCode = UBlockCode(147i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_C: UBlockCode = UBlockCode(148i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_D: UBlockCode = UBlockCode(149i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PHAGS_PA: UBlockCode = UBlockCode(150i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PHOENICIAN: UBlockCode = UBlockCode(151i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CUNEIFORM: UBlockCode = UBlockCode(152i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION: UBlockCode = UBlockCode(153i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COUNTING_ROD_NUMERALS: UBlockCode = UBlockCode(154i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUNDANESE: UBlockCode = UBlockCode(155i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LEPCHA: UBlockCode = UBlockCode(156i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OL_CHIKI: UBlockCode = UBlockCode(157i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC_EXTENDED_A: UBlockCode = UBlockCode(158i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_VAI: UBlockCode = UBlockCode(159i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC_EXTENDED_B: UBlockCode = UBlockCode(160i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SAURASHTRA: UBlockCode = UBlockCode(161i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KAYAH_LI: UBlockCode = UBlockCode(162i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_REJANG: UBlockCode = UBlockCode(163i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHAM: UBlockCode = UBlockCode(164i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ANCIENT_SYMBOLS: UBlockCode = UBlockCode(165i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PHAISTOS_DISC: UBlockCode = UBlockCode(166i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LYCIAN: UBlockCode = UBlockCode(167i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CARIAN: UBlockCode = UBlockCode(168i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LYDIAN: UBlockCode = UBlockCode(169i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MAHJONG_TILES: UBlockCode = UBlockCode(170i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DOMINO_TILES: UBlockCode = UBlockCode(171i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SAMARITAN: UBlockCode = UBlockCode(172i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED: UBlockCode = UBlockCode(173i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAI_THAM: UBlockCode = UBlockCode(174i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_VEDIC_EXTENSIONS: UBlockCode = UBlockCode(175i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LISU: UBlockCode = UBlockCode(176i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BAMUM: UBlockCode = UBlockCode(177i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMMON_INDIC_NUMBER_FORMS: UBlockCode = UBlockCode(178i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DEVANAGARI_EXTENDED: UBlockCode = UBlockCode(179i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANGUL_JAMO_EXTENDED_A: UBlockCode = UBlockCode(180i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_JAVANESE: UBlockCode = UBlockCode(181i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MYANMAR_EXTENDED_A: UBlockCode = UBlockCode(182i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAI_VIET: UBlockCode = UBlockCode(183i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MEETEI_MAYEK: UBlockCode = UBlockCode(184i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANGUL_JAMO_EXTENDED_B: UBlockCode = UBlockCode(185i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_IMPERIAL_ARAMAIC: UBlockCode = UBlockCode(186i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_SOUTH_ARABIAN: UBlockCode = UBlockCode(187i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_AVESTAN: UBlockCode = UBlockCode(188i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_INSCRIPTIONAL_PARTHIAN: UBlockCode = UBlockCode(189i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_INSCRIPTIONAL_PAHLAVI: UBlockCode = UBlockCode(190i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_TURKIC: UBlockCode = UBlockCode(191i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_RUMI_NUMERAL_SYMBOLS: UBlockCode = UBlockCode(192i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KAITHI: UBlockCode = UBlockCode(193i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_EGYPTIAN_HIEROGLYPHS: UBlockCode = UBlockCode(194i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT: UBlockCode = UBlockCode(195i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT: UBlockCode = UBlockCode(196i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C: UBlockCode = UBlockCode(197i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MANDAIC: UBlockCode = UBlockCode(198i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BATAK: UBlockCode = UBlockCode(199i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ETHIOPIC_EXTENDED_A: UBlockCode = UBlockCode(200i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BRAHMI: UBlockCode = UBlockCode(201i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BAMUM_SUPPLEMENT: UBlockCode = UBlockCode(202i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KANA_SUPPLEMENT: UBlockCode = UBlockCode(203i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PLAYING_CARDS: UBlockCode = UBlockCode(204i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(205i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_EMOTICONS: UBlockCode = UBlockCode(206i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TRANSPORT_AND_MAP_SYMBOLS: UBlockCode = UBlockCode(207i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ALCHEMICAL_SYMBOLS: UBlockCode = UBlockCode(208i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D: UBlockCode = UBlockCode(209i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC_EXTENDED_A: UBlockCode = UBlockCode(210i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS: UBlockCode = UBlockCode(211i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHAKMA: UBlockCode = UBlockCode(212i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MEETEI_MAYEK_EXTENSIONS: UBlockCode = UBlockCode(213i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MEROITIC_CURSIVE: UBlockCode = UBlockCode(214i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MEROITIC_HIEROGLYPHS: UBlockCode = UBlockCode(215i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MIAO: UBlockCode = UBlockCode(216i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SHARADA: UBlockCode = UBlockCode(217i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SORA_SOMPENG: UBlockCode = UBlockCode(218i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUNDANESE_SUPPLEMENT: UBlockCode = UBlockCode(219i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAKRI: UBlockCode = UBlockCode(220i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BASSA_VAH: UBlockCode = UBlockCode(221i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CAUCASIAN_ALBANIAN: UBlockCode = UBlockCode(222i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COPTIC_EPACT_NUMBERS: UBlockCode = UBlockCode(223i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED: UBlockCode = UBlockCode(224i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DUPLOYAN: UBlockCode = UBlockCode(225i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ELBASAN: UBlockCode = UBlockCode(226i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GEOMETRIC_SHAPES_EXTENDED: UBlockCode = UBlockCode(227i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GRANTHA: UBlockCode = UBlockCode(228i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHOJKI: UBlockCode = UBlockCode(229i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHUDAWADI: UBlockCode = UBlockCode(230i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LATIN_EXTENDED_E: UBlockCode = UBlockCode(231i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LINEAR_A: UBlockCode = UBlockCode(232i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MAHAJANI: UBlockCode = UBlockCode(233i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MANICHAEAN: UBlockCode = UBlockCode(234i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MENDE_KIKAKUI: UBlockCode = UBlockCode(235i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MODI: UBlockCode = UBlockCode(236i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MRO: UBlockCode = UBlockCode(237i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MYANMAR_EXTENDED_B: UBlockCode = UBlockCode(238i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NABATAEAN: UBlockCode = UBlockCode(239i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_NORTH_ARABIAN: UBlockCode = UBlockCode(240i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_PERMIC: UBlockCode = UBlockCode(241i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ORNAMENTAL_DINGBATS: UBlockCode = UBlockCode(242i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PAHAWH_HMONG: UBlockCode = UBlockCode(243i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PALMYRENE: UBlockCode = UBlockCode(244i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PAU_CIN_HAU: UBlockCode = UBlockCode(245i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_PSALTER_PAHLAVI: UBlockCode = UBlockCode(246i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SHORTHAND_FORMAT_CONTROLS: UBlockCode = UBlockCode(247i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SIDDHAM: UBlockCode = UBlockCode(248i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SINHALA_ARCHAIC_NUMBERS: UBlockCode = UBlockCode(249i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_ARROWS_C: UBlockCode = UBlockCode(250i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TIRHUTA: UBlockCode = UBlockCode(251i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_WARANG_CITI: UBlockCode = UBlockCode(252i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_AHOM: UBlockCode = UBlockCode(253i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ANATOLIAN_HIEROGLYPHS: UBlockCode = UBlockCode(254i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHEROKEE_SUPPLEMENT: UBlockCode = UBlockCode(255i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E: UBlockCode = UBlockCode(256i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_EARLY_DYNASTIC_CUNEIFORM: UBlockCode = UBlockCode(257i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HATRAN: UBlockCode = UBlockCode(258i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MULTANI: UBlockCode = UBlockCode(259i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_HUNGARIAN: UBlockCode = UBlockCode(260i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(261i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SUTTON_SIGNWRITING: UBlockCode = UBlockCode(262i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ADLAM: UBlockCode = UBlockCode(263i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_BHAIKSUKI: UBlockCode = UBlockCode(264i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CYRILLIC_EXTENDED_C: UBlockCode = UBlockCode(265i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GLAGOLITIC_SUPPLEMENT: UBlockCode = UBlockCode(266i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(267i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MARCHEN: UBlockCode = UBlockCode(268i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MONGOLIAN_SUPPLEMENT: UBlockCode = UBlockCode(269i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NEWA: UBlockCode = UBlockCode(270i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OSAGE: UBlockCode = UBlockCode(271i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TANGUT: UBlockCode = UBlockCode(272i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TANGUT_COMPONENTS: UBlockCode = UBlockCode(273i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F: UBlockCode = UBlockCode(274i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KANA_EXTENDED_A: UBlockCode = UBlockCode(275i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MASARAM_GONDI: UBlockCode = UBlockCode(276i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NUSHU: UBlockCode = UBlockCode(277i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SOYOMBO: UBlockCode = UBlockCode(278i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SYRIAC_SUPPLEMENT: UBlockCode = UBlockCode(279i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ZANABAZAR_SQUARE: UBlockCode = UBlockCode(280i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHESS_SYMBOLS: UBlockCode = UBlockCode(281i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DOGRA: UBlockCode = UBlockCode(282i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GEORGIAN_EXTENDED: UBlockCode = UBlockCode(283i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_GUNJALA_GONDI: UBlockCode = UBlockCode(284i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_HANIFI_ROHINGYA: UBlockCode = UBlockCode(285i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_INDIC_SIYAQ_NUMBERS: UBlockCode = UBlockCode(286i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MAKASAR: UBlockCode = UBlockCode(287i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MAYAN_NUMERALS: UBlockCode = UBlockCode(288i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_MEDEFAIDRIN: UBlockCode = UBlockCode(289i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OLD_SOGDIAN: UBlockCode = UBlockCode(290i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SOGDIAN: UBlockCode = UBlockCode(291i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS: UBlockCode = UBlockCode(292i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_ELYMAIC: UBlockCode = UBlockCode(293i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NANDINAGARI: UBlockCode = UBlockCode(294i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_NYIAKENG_PUACHUE_HMONG: UBlockCode = UBlockCode(295i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_OTTOMAN_SIYAQ_NUMBERS: UBlockCode = UBlockCode(296i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SMALL_KANA_EXTENSION: UBlockCode = UBlockCode(297i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A: UBlockCode = UBlockCode(298i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TAMIL_SUPPLEMENT: UBlockCode = UBlockCode(299i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_WANCHO: UBlockCode = UBlockCode(300i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CHORASMIAN: UBlockCode = UBlockCode(301i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G: UBlockCode = UBlockCode(302i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_DIVES_AKURU: UBlockCode = UBlockCode(303i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_KHITAN_SMALL_SCRIPT: UBlockCode = UBlockCode(304i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_LISU_SUPPLEMENT: UBlockCode = UBlockCode(305i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING: UBlockCode = UBlockCode(306i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_TANGUT_SUPPLEMENT: UBlockCode = UBlockCode(307i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_YEZIDI: UBlockCode = UBlockCode(308i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBLOCK_INVALID_CODE: UBlockCode = UBlockCode(-1i32);
impl ::core::marker::Copy for UBlockCode {}
impl ::core::clone::Clone for UBlockCode {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBlockCode {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBlockCode {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBlockCode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBlockCode").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UBreakIteratorType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBRK_CHARACTER: UBreakIteratorType = UBreakIteratorType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBRK_WORD: UBreakIteratorType = UBreakIteratorType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBRK_LINE: UBreakIteratorType = UBreakIteratorType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UBRK_SENTENCE: UBreakIteratorType = UBreakIteratorType(3i32);
impl ::core::marker::Copy for UBreakIteratorType {}
impl ::core::clone::Clone for UBreakIteratorType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UBreakIteratorType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UBreakIteratorType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UBreakIteratorType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UBreakIteratorType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCPMapRangeOption(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPMAP_RANGE_NORMAL: UCPMapRangeOption = UCPMapRangeOption(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPMAP_RANGE_FIXED_LEAD_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPMAP_RANGE_FIXED_ALL_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(2i32);
impl ::core::marker::Copy for UCPMapRangeOption {}
impl ::core::clone::Clone for UCPMapRangeOption {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCPMapRangeOption {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCPMapRangeOption {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCPMapRangeOption {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCPMapRangeOption").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCPTrieType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_TYPE_ANY: UCPTrieType = UCPTrieType(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_TYPE_FAST: UCPTrieType = UCPTrieType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_TYPE_SMALL: UCPTrieType = UCPTrieType(1i32);
impl ::core::marker::Copy for UCPTrieType {}
impl ::core::clone::Clone for UCPTrieType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCPTrieType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCPTrieType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCPTrieType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCPTrieType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCPTrieValueWidth(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_VALUE_BITS_ANY: UCPTrieValueWidth = UCPTrieValueWidth(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_VALUE_BITS_16: UCPTrieValueWidth = UCPTrieValueWidth(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_VALUE_BITS_32: UCPTrieValueWidth = UCPTrieValueWidth(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCPTRIE_VALUE_BITS_8: UCPTrieValueWidth = UCPTrieValueWidth(2i32);
impl ::core::marker::Copy for UCPTrieValueWidth {}
impl ::core::clone::Clone for UCPTrieValueWidth {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCPTrieValueWidth {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCPTrieValueWidth {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCPTrieValueWidth {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCPTrieValueWidth").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarAMPMs(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_AM: UCalendarAMPMs = UCalendarAMPMs(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_PM: UCalendarAMPMs = UCalendarAMPMs(1i32);
impl ::core::marker::Copy for UCalendarAMPMs {}
impl ::core::clone::Clone for UCalendarAMPMs {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarAMPMs {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarAMPMs {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarAMPMs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarAMPMs").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarAttribute(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_LENIENT: UCalendarAttribute = UCalendarAttribute(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_FIRST_DAY_OF_WEEK: UCalendarAttribute = UCalendarAttribute(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MINIMAL_DAYS_IN_FIRST_WEEK: UCalendarAttribute = UCalendarAttribute(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_REPEATED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SKIPPED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(4i32);
impl ::core::marker::Copy for UCalendarAttribute {}
impl ::core::clone::Clone for UCalendarAttribute {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarAttribute {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarAttribute {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarAttribute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarAttribute").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarDateFields(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_ERA: UCalendarDateFields = UCalendarDateFields(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_YEAR: UCalendarDateFields = UCalendarDateFields(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MONTH: UCalendarDateFields = UCalendarDateFields(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEK_OF_YEAR: UCalendarDateFields = UCalendarDateFields(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEK_OF_MONTH: UCalendarDateFields = UCalendarDateFields(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DATE: UCalendarDateFields = UCalendarDateFields(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DAY_OF_YEAR: UCalendarDateFields = UCalendarDateFields(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DAY_OF_WEEK: UCalendarDateFields = UCalendarDateFields(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DAY_OF_WEEK_IN_MONTH: UCalendarDateFields = UCalendarDateFields(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_AM_PM: UCalendarDateFields = UCalendarDateFields(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_HOUR: UCalendarDateFields = UCalendarDateFields(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_HOUR_OF_DAY: UCalendarDateFields = UCalendarDateFields(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MINUTE: UCalendarDateFields = UCalendarDateFields(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SECOND: UCalendarDateFields = UCalendarDateFields(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MILLISECOND: UCalendarDateFields = UCalendarDateFields(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_ZONE_OFFSET: UCalendarDateFields = UCalendarDateFields(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DST_OFFSET: UCalendarDateFields = UCalendarDateFields(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_YEAR_WOY: UCalendarDateFields = UCalendarDateFields(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DOW_LOCAL: UCalendarDateFields = UCalendarDateFields(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_EXTENDED_YEAR: UCalendarDateFields = UCalendarDateFields(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_JULIAN_DAY: UCalendarDateFields = UCalendarDateFields(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MILLISECONDS_IN_DAY: UCalendarDateFields = UCalendarDateFields(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_IS_LEAP_MONTH: UCalendarDateFields = UCalendarDateFields(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_FIELD_COUNT: UCalendarDateFields = UCalendarDateFields(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DAY_OF_MONTH: UCalendarDateFields = UCalendarDateFields(5i32);
impl ::core::marker::Copy for UCalendarDateFields {}
impl ::core::clone::Clone for UCalendarDateFields {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarDateFields {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarDateFields {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarDateFields {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarDateFields").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarDaysOfWeek(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SUNDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MONDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_TUESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEDNESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_THURSDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_FRIDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SATURDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(7i32);
impl ::core::marker::Copy for UCalendarDaysOfWeek {}
impl ::core::clone::Clone for UCalendarDaysOfWeek {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarDaysOfWeek {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarDaysOfWeek {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarDaysOfWeek {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarDaysOfWeek").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarDisplayNameType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SHORT_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SHORT_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(3i32);
impl ::core::marker::Copy for UCalendarDisplayNameType {}
impl ::core::clone::Clone for UCalendarDisplayNameType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarDisplayNameType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarDisplayNameType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarDisplayNameType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarDisplayNameType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarLimitType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_GREATEST_MINIMUM: UCalendarLimitType = UCalendarLimitType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_LEAST_MAXIMUM: UCalendarLimitType = UCalendarLimitType(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_ACTUAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_ACTUAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(5i32);
impl ::core::marker::Copy for UCalendarLimitType {}
impl ::core::clone::Clone for UCalendarLimitType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarLimitType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarLimitType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarLimitType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarLimitType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarMonths(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_JANUARY: UCalendarMonths = UCalendarMonths(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_FEBRUARY: UCalendarMonths = UCalendarMonths(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MARCH: UCalendarMonths = UCalendarMonths(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_APRIL: UCalendarMonths = UCalendarMonths(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_MAY: UCalendarMonths = UCalendarMonths(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_JUNE: UCalendarMonths = UCalendarMonths(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_JULY: UCalendarMonths = UCalendarMonths(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_AUGUST: UCalendarMonths = UCalendarMonths(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_SEPTEMBER: UCalendarMonths = UCalendarMonths(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_OCTOBER: UCalendarMonths = UCalendarMonths(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_NOVEMBER: UCalendarMonths = UCalendarMonths(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DECEMBER: UCalendarMonths = UCalendarMonths(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_UNDECIMBER: UCalendarMonths = UCalendarMonths(12i32);
impl ::core::marker::Copy for UCalendarMonths {}
impl ::core::clone::Clone for UCalendarMonths {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarMonths {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarMonths {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarMonths {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarMonths").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_TRADITIONAL: UCalendarType = UCalendarType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_DEFAULT: UCalendarType = UCalendarType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_GREGORIAN: UCalendarType = UCalendarType(1i32);
impl ::core::marker::Copy for UCalendarType {}
impl ::core::clone::Clone for UCalendarType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarWallTimeOption(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WALLTIME_LAST: UCalendarWallTimeOption = UCalendarWallTimeOption(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WALLTIME_FIRST: UCalendarWallTimeOption = UCalendarWallTimeOption(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WALLTIME_NEXT_VALID: UCalendarWallTimeOption = UCalendarWallTimeOption(2i32);
impl ::core::marker::Copy for UCalendarWallTimeOption {}
impl ::core::clone::Clone for UCalendarWallTimeOption {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarWallTimeOption {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarWallTimeOption {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarWallTimeOption {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarWallTimeOption").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCalendarWeekdayType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEKDAY: UCalendarWeekdayType = UCalendarWeekdayType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEKEND: UCalendarWeekdayType = UCalendarWeekdayType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEKEND_ONSET: UCalendarWeekdayType = UCalendarWeekdayType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCAL_WEEKEND_CEASE: UCalendarWeekdayType = UCalendarWeekdayType(3i32);
impl ::core::marker::Copy for UCalendarWeekdayType {}
impl ::core::clone::Clone for UCalendarWeekdayType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCalendarWeekdayType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCalendarWeekdayType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCalendarWeekdayType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCalendarWeekdayType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCharCategory(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNASSIGNED: UCharCategory = UCharCategory(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_GENERAL_OTHER_TYPES: UCharCategory = UCharCategory(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UPPERCASE_LETTER: UCharCategory = UCharCategory(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LOWERCASE_LETTER: UCharCategory = UCharCategory(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TITLECASE_LETTER: UCharCategory = UCharCategory(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MODIFIER_LETTER: UCharCategory = UCharCategory(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OTHER_LETTER: UCharCategory = UCharCategory(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NON_SPACING_MARK: UCharCategory = UCharCategory(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ENCLOSING_MARK: UCharCategory = UCharCategory(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COMBINING_SPACING_MARK: UCharCategory = UCharCategory(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DECIMAL_DIGIT_NUMBER: UCharCategory = UCharCategory(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LETTER_NUMBER: UCharCategory = UCharCategory(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OTHER_NUMBER: UCharCategory = UCharCategory(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SPACE_SEPARATOR: UCharCategory = UCharCategory(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LINE_SEPARATOR: UCharCategory = UCharCategory(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PARAGRAPH_SEPARATOR: UCharCategory = UCharCategory(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CONTROL_CHAR: UCharCategory = UCharCategory(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FORMAT_CHAR: UCharCategory = UCharCategory(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PRIVATE_USE_CHAR: UCharCategory = UCharCategory(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SURROGATE: UCharCategory = UCharCategory(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DASH_PUNCTUATION: UCharCategory = UCharCategory(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_START_PUNCTUATION: UCharCategory = UCharCategory(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_END_PUNCTUATION: UCharCategory = UCharCategory(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CONNECTOR_PUNCTUATION: UCharCategory = UCharCategory(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OTHER_PUNCTUATION: UCharCategory = UCharCategory(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MATH_SYMBOL: UCharCategory = UCharCategory(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CURRENCY_SYMBOL: UCharCategory = UCharCategory(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MODIFIER_SYMBOL: UCharCategory = UCharCategory(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OTHER_SYMBOL: UCharCategory = UCharCategory(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INITIAL_PUNCTUATION: UCharCategory = UCharCategory(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FINAL_PUNCTUATION: UCharCategory = UCharCategory(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHAR_CATEGORY_COUNT: UCharCategory = UCharCategory(30i32);
impl ::core::marker::Copy for UCharCategory {}
impl ::core::clone::Clone for UCharCategory {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCharCategory {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCharCategory {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCharCategory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCharCategory").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCharDirection(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LEFT_TO_RIGHT: UCharDirection = UCharDirection(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RIGHT_TO_LEFT: UCharDirection = UCharDirection(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EUROPEAN_NUMBER: UCharDirection = UCharDirection(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EUROPEAN_NUMBER_SEPARATOR: UCharDirection = UCharDirection(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EUROPEAN_NUMBER_TERMINATOR: UCharDirection = UCharDirection(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ARABIC_NUMBER: UCharDirection = UCharDirection(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COMMON_NUMBER_SEPARATOR: UCharDirection = UCharDirection(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BLOCK_SEPARATOR: UCharDirection = UCharDirection(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SEGMENT_SEPARATOR: UCharDirection = UCharDirection(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_WHITE_SPACE_NEUTRAL: UCharDirection = UCharDirection(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_OTHER_NEUTRAL: UCharDirection = UCharDirection(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LEFT_TO_RIGHT_EMBEDDING: UCharDirection = UCharDirection(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LEFT_TO_RIGHT_OVERRIDE: UCharDirection = UCharDirection(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RIGHT_TO_LEFT_ARABIC: UCharDirection = UCharDirection(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RIGHT_TO_LEFT_EMBEDDING: UCharDirection = UCharDirection(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RIGHT_TO_LEFT_OVERRIDE: UCharDirection = UCharDirection(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_POP_DIRECTIONAL_FORMAT: UCharDirection = UCharDirection(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DIR_NON_SPACING_MARK: UCharDirection = UCharDirection(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BOUNDARY_NEUTRAL: UCharDirection = UCharDirection(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FIRST_STRONG_ISOLATE: UCharDirection = UCharDirection(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_LEFT_TO_RIGHT_ISOLATE: UCharDirection = UCharDirection(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RIGHT_TO_LEFT_ISOLATE: UCharDirection = UCharDirection(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_POP_DIRECTIONAL_ISOLATE: UCharDirection = UCharDirection(22i32);
impl ::core::marker::Copy for UCharDirection {}
impl ::core::clone::Clone for UCharDirection {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCharDirection {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCharDirection {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCharDirection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCharDirection").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCharIteratorOrigin(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_START: UCharIteratorOrigin = UCharIteratorOrigin(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_CURRENT: UCharIteratorOrigin = UCharIteratorOrigin(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_LIMIT: UCharIteratorOrigin = UCharIteratorOrigin(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_ZERO: UCharIteratorOrigin = UCharIteratorOrigin(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UITER_LENGTH: UCharIteratorOrigin = UCharIteratorOrigin(4i32);
impl ::core::marker::Copy for UCharIteratorOrigin {}
impl ::core::clone::Clone for UCharIteratorOrigin {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCharIteratorOrigin {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCharIteratorOrigin {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCharIteratorOrigin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCharIteratorOrigin").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCharNameChoice(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNICODE_CHAR_NAME: UCharNameChoice = UCharNameChoice(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EXTENDED_CHAR_NAME: UCharNameChoice = UCharNameChoice(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CHAR_NAME_ALIAS: UCharNameChoice = UCharNameChoice(3i32);
impl ::core::marker::Copy for UCharNameChoice {}
impl ::core::clone::Clone for UCharNameChoice {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCharNameChoice {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCharNameChoice {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCharNameChoice {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCharNameChoice").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UColAttribute(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_FRENCH_COLLATION: UColAttribute = UColAttribute(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_ALTERNATE_HANDLING: UColAttribute = UColAttribute(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_CASE_FIRST: UColAttribute = UColAttribute(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_CASE_LEVEL: UColAttribute = UColAttribute(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_NORMALIZATION_MODE: UColAttribute = UColAttribute(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_DECOMPOSITION_MODE: UColAttribute = UColAttribute(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_STRENGTH: UColAttribute = UColAttribute(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_NUMERIC_COLLATION: UColAttribute = UColAttribute(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_ATTRIBUTE_COUNT: UColAttribute = UColAttribute(8i32);
impl ::core::marker::Copy for UColAttribute {}
impl ::core::clone::Clone for UColAttribute {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UColAttribute {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UColAttribute {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UColAttribute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UColAttribute").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UColAttributeValue(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_DEFAULT: UColAttributeValue = UColAttributeValue(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_PRIMARY: UColAttributeValue = UColAttributeValue(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_SECONDARY: UColAttributeValue = UColAttributeValue(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_TERTIARY: UColAttributeValue = UColAttributeValue(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_DEFAULT_STRENGTH: UColAttributeValue = UColAttributeValue(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_CE_STRENGTH_LIMIT: UColAttributeValue = UColAttributeValue(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_QUATERNARY: UColAttributeValue = UColAttributeValue(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_IDENTICAL: UColAttributeValue = UColAttributeValue(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_STRENGTH_LIMIT: UColAttributeValue = UColAttributeValue(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_OFF: UColAttributeValue = UColAttributeValue(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_ON: UColAttributeValue = UColAttributeValue(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_SHIFTED: UColAttributeValue = UColAttributeValue(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_NON_IGNORABLE: UColAttributeValue = UColAttributeValue(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_LOWER_FIRST: UColAttributeValue = UColAttributeValue(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_UPPER_FIRST: UColAttributeValue = UColAttributeValue(25i32);
impl ::core::marker::Copy for UColAttributeValue {}
impl ::core::clone::Clone for UColAttributeValue {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UColAttributeValue {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UColAttributeValue {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UColAttributeValue {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UColAttributeValue").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UColBoundMode(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_BOUND_LOWER: UColBoundMode = UColBoundMode(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_BOUND_UPPER: UColBoundMode = UColBoundMode(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_BOUND_UPPER_LONG: UColBoundMode = UColBoundMode(2i32);
impl ::core::marker::Copy for UColBoundMode {}
impl ::core::clone::Clone for UColBoundMode {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UColBoundMode {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UColBoundMode {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UColBoundMode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UColBoundMode").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UColReorderCode(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_DEFAULT: UColReorderCode = UColReorderCode(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_NONE: UColReorderCode = UColReorderCode(103i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_OTHERS: UColReorderCode = UColReorderCode(103i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_SPACE: UColReorderCode = UColReorderCode(4096i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_FIRST: UColReorderCode = UColReorderCode(4096i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_PUNCTUATION: UColReorderCode = UColReorderCode(4097i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_SYMBOL: UColReorderCode = UColReorderCode(4098i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_CURRENCY: UColReorderCode = UColReorderCode(4099i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_REORDER_CODE_DIGIT: UColReorderCode = UColReorderCode(4100i32);
impl ::core::marker::Copy for UColReorderCode {}
impl ::core::clone::Clone for UColReorderCode {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UColReorderCode {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UColReorderCode {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UColReorderCode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UColReorderCode").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UColRuleOption(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_TAILORING_ONLY: UColRuleOption = UColRuleOption(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_FULL_RULES: UColRuleOption = UColRuleOption(1i32);
impl ::core::marker::Copy for UColRuleOption {}
impl ::core::clone::Clone for UColRuleOption {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UColRuleOption {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UColRuleOption {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UColRuleOption {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UColRuleOption").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCollationResult(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_EQUAL: UCollationResult = UCollationResult(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_GREATER: UCollationResult = UCollationResult(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCOL_LESS: UCollationResult = UCollationResult(-1i32);
impl ::core::marker::Copy for UCollationResult {}
impl ::core::clone::Clone for UCollationResult {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCollationResult {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCollationResult {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCollationResult {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCollationResult").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UConverterCallbackReason(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UNASSIGNED: UConverterCallbackReason = UConverterCallbackReason(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ILLEGAL: UConverterCallbackReason = UConverterCallbackReason(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_IRREGULAR: UConverterCallbackReason = UConverterCallbackReason(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_RESET: UConverterCallbackReason = UConverterCallbackReason(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_CLOSE: UConverterCallbackReason = UConverterCallbackReason(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_CLONE: UConverterCallbackReason = UConverterCallbackReason(5i32);
impl ::core::marker::Copy for UConverterCallbackReason {}
impl ::core::clone::Clone for UConverterCallbackReason {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UConverterCallbackReason {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UConverterCallbackReason {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UConverterCallbackReason {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UConverterCallbackReason").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UConverterPlatform(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UNKNOWN: UConverterPlatform = UConverterPlatform(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_IBM: UConverterPlatform = UConverterPlatform(0i32);
impl ::core::marker::Copy for UConverterPlatform {}
impl ::core::clone::Clone for UConverterPlatform {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UConverterPlatform {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UConverterPlatform {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UConverterPlatform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UConverterPlatform").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UConverterType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UNSUPPORTED_CONVERTER: UConverterType = UConverterType(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SBCS: UConverterType = UConverterType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_DBCS: UConverterType = UConverterType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_MBCS: UConverterType = UConverterType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LATIN_1: UConverterType = UConverterType(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF8: UConverterType = UConverterType(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF16_BigEndian: UConverterType = UConverterType(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF16_LittleEndian: UConverterType = UConverterType(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF32_BigEndian: UConverterType = UConverterType(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF32_LittleEndian: UConverterType = UConverterType(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_EBCDIC_STATEFUL: UConverterType = UConverterType(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ISO_2022: UConverterType = UConverterType(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_1: UConverterType = UConverterType(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_2: UConverterType = UConverterType(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_3: UConverterType = UConverterType(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_4: UConverterType = UConverterType(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_5: UConverterType = UConverterType(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_6: UConverterType = UConverterType(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_8: UConverterType = UConverterType(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_11: UConverterType = UConverterType(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_16: UConverterType = UConverterType(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_17: UConverterType = UConverterType(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_18: UConverterType = UConverterType(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_19: UConverterType = UConverterType(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_LMBCS_LAST: UConverterType = UConverterType(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_HZ: UConverterType = UConverterType(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_SCSU: UConverterType = UConverterType(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ISCII: UConverterType = UConverterType(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_US_ASCII: UConverterType = UConverterType(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF7: UConverterType = UConverterType(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_BOCU1: UConverterType = UConverterType(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF16: UConverterType = UConverterType(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_UTF32: UConverterType = UConverterType(30i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_CESU8: UConverterType = UConverterType(31i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_IMAP_MAILBOX: UConverterType = UConverterType(32i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_COMPOUND_TEXT: UConverterType = UConverterType(33i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_NUMBER_OF_SUPPORTED_CONVERTER_TYPES: UConverterType = UConverterType(34i32);
impl ::core::marker::Copy for UConverterType {}
impl ::core::clone::Clone for UConverterType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UConverterType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UConverterType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UConverterType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UConverterType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UConverterUnicodeSet(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ROUNDTRIP_SET: UConverterUnicodeSet = UConverterUnicodeSet(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCNV_ROUNDTRIP_AND_FALLBACK_SET: UConverterUnicodeSet = UConverterUnicodeSet(1i32);
impl ::core::marker::Copy for UConverterUnicodeSet {}
impl ::core::clone::Clone for UConverterUnicodeSet {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UConverterUnicodeSet {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UConverterUnicodeSet {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UConverterUnicodeSet {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UConverterUnicodeSet").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCurrCurrencyType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_ALL: UCurrCurrencyType = UCurrCurrencyType(2147483647i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_COMMON: UCurrCurrencyType = UCurrCurrencyType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_UNCOMMON: UCurrCurrencyType = UCurrCurrencyType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_DEPRECATED: UCurrCurrencyType = UCurrCurrencyType(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_NON_DEPRECATED: UCurrCurrencyType = UCurrCurrencyType(8i32);
impl ::core::marker::Copy for UCurrCurrencyType {}
impl ::core::clone::Clone for UCurrCurrencyType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCurrCurrencyType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCurrCurrencyType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCurrCurrencyType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCurrCurrencyType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCurrNameStyle(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_SYMBOL_NAME: UCurrNameStyle = UCurrNameStyle(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_LONG_NAME: UCurrNameStyle = UCurrNameStyle(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_NARROW_SYMBOL_NAME: UCurrNameStyle = UCurrNameStyle(2i32);
impl ::core::marker::Copy for UCurrNameStyle {}
impl ::core::clone::Clone for UCurrNameStyle {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCurrNameStyle {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCurrNameStyle {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCurrNameStyle {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCurrNameStyle").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCurrencySpacing(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNUM_CURRENCY_MATCH: UCurrencySpacing = UCurrencySpacing(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNUM_CURRENCY_SURROUNDING_MATCH: UCurrencySpacing = UCurrencySpacing(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNUM_CURRENCY_INSERT: UCurrencySpacing = UCurrencySpacing(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UNUM_CURRENCY_SPACING_COUNT: UCurrencySpacing = UCurrencySpacing(3i32);
impl ::core::marker::Copy for UCurrencySpacing {}
impl ::core::clone::Clone for UCurrencySpacing {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCurrencySpacing {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCurrencySpacing {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCurrencySpacing {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCurrencySpacing").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UCurrencyUsage(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_USAGE_STANDARD: UCurrencyUsage = UCurrencyUsage(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UCURR_USAGE_CASH: UCurrencyUsage = UCurrencyUsage(1i32);
impl ::core::marker::Copy for UCurrencyUsage {}
impl ::core::clone::Clone for UCurrencyUsage {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UCurrencyUsage {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UCurrencyUsage {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UCurrencyUsage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UCurrencyUsage").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateAbsoluteUnit(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_SUNDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_MONDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_TUESDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_WEDNESDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_THURSDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_FRIDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_SATURDAY: UDateAbsoluteUnit = UDateAbsoluteUnit(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_DAY: UDateAbsoluteUnit = UDateAbsoluteUnit(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_WEEK: UDateAbsoluteUnit = UDateAbsoluteUnit(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_MONTH: UDateAbsoluteUnit = UDateAbsoluteUnit(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_YEAR: UDateAbsoluteUnit = UDateAbsoluteUnit(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_NOW: UDateAbsoluteUnit = UDateAbsoluteUnit(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ABSOLUTE_UNIT_COUNT: UDateAbsoluteUnit = UDateAbsoluteUnit(12i32);
impl ::core::marker::Copy for UDateAbsoluteUnit {}
impl ::core::clone::Clone for UDateAbsoluteUnit {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateAbsoluteUnit {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateAbsoluteUnit {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateAbsoluteUnit {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateAbsoluteUnit").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateDirection(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_LAST_2: UDateDirection = UDateDirection(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_LAST: UDateDirection = UDateDirection(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_THIS: UDateDirection = UDateDirection(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_NEXT: UDateDirection = UDateDirection(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_NEXT_2: UDateDirection = UDateDirection(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_PLAIN: UDateDirection = UDateDirection(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DIRECTION_COUNT: UDateDirection = UDateDirection(6i32);
impl ::core::marker::Copy for UDateDirection {}
impl ::core::clone::Clone for UDateDirection {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateDirection {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateDirection {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateDirection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateDirection").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateFormatBooleanAttribute(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_PARSE_ALLOW_WHITESPACE: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_PARSE_ALLOW_NUMERIC: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_PARSE_PARTIAL_LITERAL_MATCH: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_PARSE_MULTIPLE_PATTERNS_FOR_MATCH: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_BOOLEAN_ATTRIBUTE_COUNT: UDateFormatBooleanAttribute = UDateFormatBooleanAttribute(4i32);
impl ::core::marker::Copy for UDateFormatBooleanAttribute {}
impl ::core::clone::Clone for UDateFormatBooleanAttribute {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateFormatBooleanAttribute {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateFormatBooleanAttribute {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateFormatBooleanAttribute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateFormatBooleanAttribute").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateFormatField(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ERA_FIELD: UDateFormatField = UDateFormatField(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_FIELD: UDateFormatField = UDateFormatField(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MONTH_FIELD: UDateFormatField = UDateFormatField(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DATE_FIELD: UDateFormatField = UDateFormatField(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR_OF_DAY1_FIELD: UDateFormatField = UDateFormatField(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR_OF_DAY0_FIELD: UDateFormatField = UDateFormatField(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MINUTE_FIELD: UDateFormatField = UDateFormatField(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SECOND_FIELD: UDateFormatField = UDateFormatField(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_FRACTIONAL_SECOND_FIELD: UDateFormatField = UDateFormatField(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DAY_OF_WEEK_FIELD: UDateFormatField = UDateFormatField(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DAY_OF_YEAR_FIELD: UDateFormatField = UDateFormatField(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DAY_OF_WEEK_IN_MONTH_FIELD: UDateFormatField = UDateFormatField(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_WEEK_OF_YEAR_FIELD: UDateFormatField = UDateFormatField(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_WEEK_OF_MONTH_FIELD: UDateFormatField = UDateFormatField(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_AM_PM_FIELD: UDateFormatField = UDateFormatField(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR1_FIELD: UDateFormatField = UDateFormatField(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_HOUR0_FIELD: UDateFormatField = UDateFormatField(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_FIELD: UDateFormatField = UDateFormatField(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_WOY_FIELD: UDateFormatField = UDateFormatField(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DOW_LOCAL_FIELD: UDateFormatField = UDateFormatField(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_EXTENDED_YEAR_FIELD: UDateFormatField = UDateFormatField(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_JULIAN_DAY_FIELD: UDateFormatField = UDateFormatField(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MILLISECONDS_IN_DAY_FIELD: UDateFormatField = UDateFormatField(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_RFC_FIELD: UDateFormatField = UDateFormatField(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_GENERIC_FIELD: UDateFormatField = UDateFormatField(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_DAY_FIELD: UDateFormatField = UDateFormatField(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_MONTH_FIELD: UDateFormatField = UDateFormatField(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_QUARTER_FIELD: UDateFormatField = UDateFormatField(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_QUARTER_FIELD: UDateFormatField = UDateFormatField(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_SPECIAL_FIELD: UDateFormatField = UDateFormatField(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_YEAR_NAME_FIELD: UDateFormatField = UDateFormatField(30i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD: UDateFormatField = UDateFormatField(31i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_ISO_FIELD: UDateFormatField = UDateFormatField(32i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_TIMEZONE_ISO_LOCAL_FIELD: UDateFormatField = UDateFormatField(33i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_AM_PM_MIDNIGHT_NOON_FIELD: UDateFormatField = UDateFormatField(35i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_FLEXIBLE_DAY_PERIOD_FIELD: UDateFormatField = UDateFormatField(36i32);
impl ::core::marker::Copy for UDateFormatField {}
impl ::core::clone::Clone for UDateFormatField {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateFormatField {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateFormatField {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateFormatField {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateFormatField").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateFormatStyle(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_FULL: UDateFormatStyle = UDateFormatStyle(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_LONG: UDateFormatStyle = UDateFormatStyle(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MEDIUM: UDateFormatStyle = UDateFormatStyle(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORT: UDateFormatStyle = UDateFormatStyle(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_DEFAULT: UDateFormatStyle = UDateFormatStyle(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE: UDateFormatStyle = UDateFormatStyle(128i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_FULL_RELATIVE: UDateFormatStyle = UDateFormatStyle(128i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_LONG_RELATIVE: UDateFormatStyle = UDateFormatStyle(129i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MEDIUM_RELATIVE: UDateFormatStyle = UDateFormatStyle(130i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORT_RELATIVE: UDateFormatStyle = UDateFormatStyle(131i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NONE: UDateFormatStyle = UDateFormatStyle(-1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_PATTERN: UDateFormatStyle = UDateFormatStyle(-2i32);
impl ::core::marker::Copy for UDateFormatStyle {}
impl ::core::clone::Clone for UDateFormatStyle {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateFormatStyle {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateFormatStyle {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateFormatStyle {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateFormatStyle").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateFormatSymbolType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ERAS: UDateFormatSymbolType = UDateFormatSymbolType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_AM_PMS: UDateFormatSymbolType = UDateFormatSymbolType(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_LOCALIZED_CHARS: UDateFormatSymbolType = UDateFormatSymbolType(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ERA_NAMES: UDateFormatSymbolType = UDateFormatSymbolType(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NARROW_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_NARROW_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_SHORT_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_NARROW_MONTHS: UDateFormatSymbolType = UDateFormatSymbolType(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_SHORT_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_NARROW_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_SHORT_QUARTERS: UDateFormatSymbolType = UDateFormatSymbolType(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_SHORTER_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STANDALONE_SHORTER_WEEKDAYS: UDateFormatSymbolType = UDateFormatSymbolType(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_CYCLIC_YEARS_WIDE: UDateFormatSymbolType = UDateFormatSymbolType(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_CYCLIC_YEARS_ABBREVIATED: UDateFormatSymbolType = UDateFormatSymbolType(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_CYCLIC_YEARS_NARROW: UDateFormatSymbolType = UDateFormatSymbolType(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ZODIAC_NAMES_WIDE: UDateFormatSymbolType = UDateFormatSymbolType(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ZODIAC_NAMES_ABBREVIATED: UDateFormatSymbolType = UDateFormatSymbolType(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_ZODIAC_NAMES_NARROW: UDateFormatSymbolType = UDateFormatSymbolType(27i32);
impl ::core::marker::Copy for UDateFormatSymbolType {}
impl ::core::clone::Clone for UDateFormatSymbolType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateFormatSymbolType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateFormatSymbolType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateFormatSymbolType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateFormatSymbolType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateRelativeDateTimeFormatterStyle(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STYLE_LONG: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STYLE_SHORT: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_STYLE_NARROW: UDateRelativeDateTimeFormatterStyle = UDateRelativeDateTimeFormatterStyle(2i32);
impl ::core::marker::Copy for UDateRelativeDateTimeFormatterStyle {}
impl ::core::clone::Clone for UDateRelativeDateTimeFormatterStyle {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateRelativeDateTimeFormatterStyle {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateRelativeDateTimeFormatterStyle {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateRelativeDateTimeFormatterStyle {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateRelativeDateTimeFormatterStyle").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateRelativeUnit(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_SECONDS: UDateRelativeUnit = UDateRelativeUnit(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_MINUTES: UDateRelativeUnit = UDateRelativeUnit(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_HOURS: UDateRelativeUnit = UDateRelativeUnit(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_DAYS: UDateRelativeUnit = UDateRelativeUnit(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_WEEKS: UDateRelativeUnit = UDateRelativeUnit(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_MONTHS: UDateRelativeUnit = UDateRelativeUnit(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_YEARS: UDateRelativeUnit = UDateRelativeUnit(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDAT_RELATIVE_UNIT_COUNT: UDateRelativeUnit = UDateRelativeUnit(7i32);
impl ::core::marker::Copy for UDateRelativeUnit {}
impl ::core::clone::Clone for UDateRelativeUnit {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateRelativeUnit {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateRelativeUnit {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateRelativeUnit {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateRelativeUnit").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateTimePGDisplayWidth(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_WIDE: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_ABBREVIATED: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_NARROW: UDateTimePGDisplayWidth = UDateTimePGDisplayWidth(2i32);
impl ::core::marker::Copy for UDateTimePGDisplayWidth {}
impl ::core::clone::Clone for UDateTimePGDisplayWidth {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateTimePGDisplayWidth {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateTimePGDisplayWidth {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateTimePGDisplayWidth {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateTimePGDisplayWidth").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateTimePatternConflict(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_NO_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_BASE_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_CONFLICT: UDateTimePatternConflict = UDateTimePatternConflict(2i32);
impl ::core::marker::Copy for UDateTimePatternConflict {}
impl ::core::clone::Clone for UDateTimePatternConflict {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateTimePatternConflict {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateTimePatternConflict {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateTimePatternConflict {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateTimePatternConflict").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateTimePatternField(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_ERA_FIELD: UDateTimePatternField = UDateTimePatternField(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_QUARTER_FIELD: UDateTimePatternField = UDateTimePatternField(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_WEEK_OF_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_WEEK_OF_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_WEEKDAY_FIELD: UDateTimePatternField = UDateTimePatternField(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_DAY_OF_YEAR_FIELD: UDateTimePatternField = UDateTimePatternField(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_DAY_OF_WEEK_IN_MONTH_FIELD: UDateTimePatternField = UDateTimePatternField(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_DAY_FIELD: UDateTimePatternField = UDateTimePatternField(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_DAYPERIOD_FIELD: UDateTimePatternField = UDateTimePatternField(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_HOUR_FIELD: UDateTimePatternField = UDateTimePatternField(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_MINUTE_FIELD: UDateTimePatternField = UDateTimePatternField(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_SECOND_FIELD: UDateTimePatternField = UDateTimePatternField(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_FRACTIONAL_SECOND_FIELD: UDateTimePatternField = UDateTimePatternField(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_ZONE_FIELD: UDateTimePatternField = UDateTimePatternField(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_FIELD_COUNT: UDateTimePatternField = UDateTimePatternField(16i32);
impl ::core::marker::Copy for UDateTimePatternField {}
impl ::core::clone::Clone for UDateTimePatternField {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateTimePatternField {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateTimePatternField {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateTimePatternField {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateTimePatternField").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateTimePatternMatchOptions(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_MATCH_NO_OPTIONS: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_MATCH_HOUR_FIELD_LENGTH: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(2048i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDATPG_MATCH_ALL_FIELDS_LENGTH: UDateTimePatternMatchOptions = UDateTimePatternMatchOptions(65535i32);
impl ::core::marker::Copy for UDateTimePatternMatchOptions {}
impl ::core::clone::Clone for UDateTimePatternMatchOptions {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateTimePatternMatchOptions {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateTimePatternMatchOptions {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateTimePatternMatchOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateTimePatternMatchOptions").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDateTimeScale(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_JAVA_TIME: UDateTimeScale = UDateTimeScale(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_UNIX_TIME: UDateTimeScale = UDateTimeScale(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_ICU4C_TIME: UDateTimeScale = UDateTimeScale(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_WINDOWS_FILE_TIME: UDateTimeScale = UDateTimeScale(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_DOTNET_DATE_TIME: UDateTimeScale = UDateTimeScale(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_MAC_OLD_TIME: UDateTimeScale = UDateTimeScale(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_MAC_TIME: UDateTimeScale = UDateTimeScale(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_EXCEL_TIME: UDateTimeScale = UDateTimeScale(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_DB2_TIME: UDateTimeScale = UDateTimeScale(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDTS_UNIX_MICROSECONDS_TIME: UDateTimeScale = UDateTimeScale(9i32);
impl ::core::marker::Copy for UDateTimeScale {}
impl ::core::clone::Clone for UDateTimeScale {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDateTimeScale {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDateTimeScale {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDateTimeScale {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDateTimeScale").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDecompositionType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_NONE: UDecompositionType = UDecompositionType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_CANONICAL: UDecompositionType = UDecompositionType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_COMPAT: UDecompositionType = UDecompositionType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_CIRCLE: UDecompositionType = UDecompositionType(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_FINAL: UDecompositionType = UDecompositionType(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_FONT: UDecompositionType = UDecompositionType(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_FRACTION: UDecompositionType = UDecompositionType(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_INITIAL: UDecompositionType = UDecompositionType(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_ISOLATED: UDecompositionType = UDecompositionType(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_MEDIAL: UDecompositionType = UDecompositionType(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_NARROW: UDecompositionType = UDecompositionType(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_NOBREAK: UDecompositionType = UDecompositionType(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_SMALL: UDecompositionType = UDecompositionType(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_SQUARE: UDecompositionType = UDecompositionType(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_SUB: UDecompositionType = UDecompositionType(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_SUPER: UDecompositionType = UDecompositionType(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_VERTICAL: UDecompositionType = UDecompositionType(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DT_WIDE: UDecompositionType = UDecompositionType(17i32);
impl ::core::marker::Copy for UDecompositionType {}
impl ::core::clone::Clone for UDecompositionType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDecompositionType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDecompositionType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDecompositionType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDecompositionType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDialectHandling(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULDN_STANDARD_NAMES: UDialectHandling = UDialectHandling(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const ULDN_DIALECT_NAMES: UDialectHandling = UDialectHandling(1i32);
impl ::core::marker::Copy for UDialectHandling {}
impl ::core::clone::Clone for UDialectHandling {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDialectHandling {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDialectHandling {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDialectHandling {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDialectHandling").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDisplayContext(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_STANDARD_NAMES: UDisplayContext = UDisplayContext(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_DIALECT_NAMES: UDisplayContext = UDisplayContext(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_CAPITALIZATION_NONE: UDisplayContext = UDisplayContext(256i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE: UDisplayContext = UDisplayContext(257i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE: UDisplayContext = UDisplayContext(258i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_CAPITALIZATION_FOR_UI_LIST_OR_MENU: UDisplayContext = UDisplayContext(259i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_CAPITALIZATION_FOR_STANDALONE: UDisplayContext = UDisplayContext(260i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_LENGTH_FULL: UDisplayContext = UDisplayContext(512i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_LENGTH_SHORT: UDisplayContext = UDisplayContext(513i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_SUBSTITUTE: UDisplayContext = UDisplayContext(768i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_NO_SUBSTITUTE: UDisplayContext = UDisplayContext(769i32);
impl ::core::marker::Copy for UDisplayContext {}
impl ::core::clone::Clone for UDisplayContext {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDisplayContext {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDisplayContext {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDisplayContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDisplayContext").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UDisplayContextType(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_TYPE_DIALECT_HANDLING: UDisplayContextType = UDisplayContextType(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_TYPE_CAPITALIZATION: UDisplayContextType = UDisplayContextType(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_TYPE_DISPLAY_LENGTH: UDisplayContextType = UDisplayContextType(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const UDISPCTX_TYPE_SUBSTITUTE_HANDLING: UDisplayContextType = UDisplayContextType(3i32);
impl ::core::marker::Copy for UDisplayContextType {}
impl ::core::clone::Clone for UDisplayContextType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UDisplayContextType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UDisplayContextType {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UDisplayContextType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UDisplayContextType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UEastAsianWidth(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_NEUTRAL: UEastAsianWidth = UEastAsianWidth(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_AMBIGUOUS: UEastAsianWidth = UEastAsianWidth(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_HALFWIDTH: UEastAsianWidth = UEastAsianWidth(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_FULLWIDTH: UEastAsianWidth = UEastAsianWidth(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_NARROW: UEastAsianWidth = UEastAsianWidth(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_EA_WIDE: UEastAsianWidth = UEastAsianWidth(5i32);
impl ::core::marker::Copy for UEastAsianWidth {}
impl ::core::clone::Clone for UEastAsianWidth {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for UEastAsianWidth {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for UEastAsianWidth {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for UEastAsianWidth {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("UEastAsianWidth").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct UErrorCode(pub i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_USING_FALLBACK_WARNING: UErrorCode = UErrorCode(-128i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ERROR_WARNING_START: UErrorCode = UErrorCode(-128i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_USING_DEFAULT_WARNING: UErrorCode = UErrorCode(-127i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SAFECLONE_ALLOCATED_WARNING: UErrorCode = UErrorCode(-126i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_STATE_OLD_WARNING: UErrorCode = UErrorCode(-125i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_STRING_NOT_TERMINATED_WARNING: UErrorCode = UErrorCode(-124i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_SORT_KEY_TOO_SHORT_WARNING: UErrorCode = UErrorCode(-123i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_AMBIGUOUS_ALIAS_WARNING: UErrorCode = UErrorCode(-122i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DIFFERENT_UCA_VERSION: UErrorCode = UErrorCode(-121i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PLUGIN_CHANGED_LEVEL_WARNING: UErrorCode = UErrorCode(-120i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ZERO_ERROR: UErrorCode = UErrorCode(0i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_ARGUMENT_ERROR: UErrorCode = UErrorCode(1i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISSING_RESOURCE_ERROR: UErrorCode = UErrorCode(2i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_FORMAT_ERROR: UErrorCode = UErrorCode(3i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FILE_ACCESS_ERROR: UErrorCode = UErrorCode(4i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INTERNAL_PROGRAM_ERROR: UErrorCode = UErrorCode(5i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MESSAGE_PARSE_ERROR: UErrorCode = UErrorCode(6i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MEMORY_ALLOCATION_ERROR: UErrorCode = UErrorCode(7i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INDEX_OUTOFBOUNDS_ERROR: UErrorCode = UErrorCode(8i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PARSE_ERROR: UErrorCode = UErrorCode(9i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_CHAR_FOUND: UErrorCode = UErrorCode(10i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TRUNCATED_CHAR_FOUND: UErrorCode = UErrorCode(11i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_CHAR_FOUND: UErrorCode = UErrorCode(12i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_TABLE_FORMAT: UErrorCode = UErrorCode(13i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_TABLE_FILE: UErrorCode = UErrorCode(14i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BUFFER_OVERFLOW_ERROR: UErrorCode = UErrorCode(15i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNSUPPORTED_ERROR: UErrorCode = UErrorCode(16i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RESOURCE_TYPE_MISMATCH: UErrorCode = UErrorCode(17i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_ESCAPE_SEQUENCE: UErrorCode = UErrorCode(18i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNSUPPORTED_ESCAPE_SEQUENCE: UErrorCode = UErrorCode(19i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NO_SPACE_AVAILABLE: UErrorCode = UErrorCode(20i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_CE_NOT_FOUND_ERROR: UErrorCode = UErrorCode(21i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PRIMARY_TOO_LONG_ERROR: UErrorCode = UErrorCode(22i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_STATE_TOO_OLD_ERROR: UErrorCode = UErrorCode(23i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TOO_MANY_ALIASES_ERROR: UErrorCode = UErrorCode(24i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ENUM_OUT_OF_SYNC_ERROR: UErrorCode = UErrorCode(25i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVARIANT_CONVERSION_ERROR: UErrorCode = UErrorCode(26i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_STATE_ERROR: UErrorCode = UErrorCode(27i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_COLLATOR_VERSION_MISMATCH: UErrorCode = UErrorCode(28i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_USELESS_COLLATOR_ERROR: UErrorCode = UErrorCode(29i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NO_WRITE_PERMISSION: UErrorCode = UErrorCode(30i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BAD_VARIABLE_DEFINITION: UErrorCode = UErrorCode(65536i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PARSE_ERROR_START: UErrorCode = UErrorCode(65536i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_RULE: UErrorCode = UErrorCode(65537i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_SET: UErrorCode = UErrorCode(65538i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_SYMBOL_REFERENCE: UErrorCode = UErrorCode(65539i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_UNICODE_ESCAPE: UErrorCode = UErrorCode(65540i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_VARIABLE_DEFINITION: UErrorCode = UErrorCode(65541i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_VARIABLE_REFERENCE: UErrorCode = UErrorCode(65542i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISMATCHED_SEGMENT_DELIMITERS: UErrorCode = UErrorCode(65543i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISPLACED_ANCHOR_START: UErrorCode = UErrorCode(65544i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISPLACED_CURSOR_OFFSET: UErrorCode = UErrorCode(65545i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISPLACED_QUANTIFIER: UErrorCode = UErrorCode(65546i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISSING_OPERATOR: UErrorCode = UErrorCode(65547i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISSING_SEGMENT_CLOSE: UErrorCode = UErrorCode(65548i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_ANTE_CONTEXTS: UErrorCode = UErrorCode(65549i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_CURSORS: UErrorCode = UErrorCode(65550i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_POST_CONTEXTS: UErrorCode = UErrorCode(65551i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_TRAILING_BACKSLASH: UErrorCode = UErrorCode(65552i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNDEFINED_SEGMENT_REFERENCE: UErrorCode = UErrorCode(65553i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNDEFINED_VARIABLE: UErrorCode = UErrorCode(65554i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNQUOTED_SPECIAL: UErrorCode = UErrorCode(65555i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNTERMINATED_QUOTE: UErrorCode = UErrorCode(65556i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_RULE_MASK_ERROR: UErrorCode = UErrorCode(65557i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MISPLACED_COMPOUND_FILTER: UErrorCode = UErrorCode(65558i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_COMPOUND_FILTERS: UErrorCode = UErrorCode(65559i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_RBT_SYNTAX: UErrorCode = UErrorCode(65560i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_PROPERTY_PATTERN: UErrorCode = UErrorCode(65561i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_PRAGMA: UErrorCode = UErrorCode(65562i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNCLOSED_SEGMENT: UErrorCode = UErrorCode(65563i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_CHAR_IN_SEGMENT: UErrorCode = UErrorCode(65564i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_VARIABLE_RANGE_EXHAUSTED: UErrorCode = UErrorCode(65565i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_VARIABLE_RANGE_OVERLAP: UErrorCode = UErrorCode(65566i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_CHARACTER: UErrorCode = UErrorCode(65567i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INTERNAL_TRANSLITERATOR_ERROR: UErrorCode = UErrorCode(65568i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_ID: UErrorCode = UErrorCode(65569i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_INVALID_FUNCTION: UErrorCode = UErrorCode(65570i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNEXPECTED_TOKEN: UErrorCode = UErrorCode(65792i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FMT_PARSE_ERROR_START: UErrorCode = UErrorCode(65792i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_DECIMAL_SEPARATORS: UErrorCode = UErrorCode(65793i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_DECIMAL_SEPERATORS: UErrorCode = UErrorCode(65793i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_EXPONENTIAL_SYMBOLS: UErrorCode = UErrorCode(65794i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MALFORMED_EXPONENTIAL_PATTERN: UErrorCode = UErrorCode(65795i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_PERCENT_SYMBOLS: UErrorCode = UErrorCode(65796i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_PERMILL_SYMBOLS: UErrorCode = UErrorCode(65797i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_MULTIPLE_PAD_SPECIFIERS: UErrorCode = UErrorCode(65798i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_PATTERN_SYNTAX_ERROR: UErrorCode = UErrorCode(65799i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ILLEGAL_PAD_POSITION: UErrorCode = UErrorCode(65800i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNMATCHED_BRACES: UErrorCode = UErrorCode(65801i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNSUPPORTED_PROPERTY: UErrorCode = UErrorCode(65802i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNSUPPORTED_ATTRIBUTE: UErrorCode = UErrorCode(65803i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_ARGUMENT_TYPE_MISMATCH: UErrorCode = UErrorCode(65804i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DUPLICATE_KEYWORD: UErrorCode = UErrorCode(65805i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_UNDEFINED_KEYWORD: UErrorCode = UErrorCode(65806i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DEFAULT_KEYWORD_MISSING: UErrorCode = UErrorCode(65807i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_DECIMAL_NUMBER_SYNTAX_ERROR: UErrorCode = UErrorCode(65808i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_FORMAT_INEXACT_ERROR: UErrorCode = UErrorCode(65809i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NUMBER_ARG_OUTOFBOUNDS_ERROR: UErrorCode = UErrorCode(65810i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_NUMBER_SKELETON_SYNTAX_ERROR: UErrorCode = UErrorCode(65811i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BRK_INTERNAL_ERROR: UErrorCode = UErrorCode(66048i32);
#[doc = "*Required features: `\"Win32_Globalization\"`*"]
pub const U_BRK_ERROR_START: UErrorCode = U