# The Rust Code of Conduct

A version of this document [can be found online](https://www.rust-lang.org/conduct.html).

## Conduct

**Contact**: [rust-mods@rust-lang.org](mailto:rust-mods@rust-lang.org)

* We are committed to providing a friendly, safe and welcoming environment for all, regardless of level of experience,
  gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age,
  religion, nationality, or other similar characteristic.
* On IRC, please avoid using overtly sexual nicknames or other nicknames that might detract from a friendly, safe and
  welcoming environment for all.
* Please be kind and courteous. There's no need to be mean or rude.
* Respect that people have differences of opinion and that every design or implementation choice carries a trade-off and
  numerous costs. There is seldom a right answer.
* Please keep unstructured critique to a minimum. If you have solid ideas you want to experiment with, make a fork and
  see how it works.
* We will exclude you from interaction if you insult, demean or harass anyone. That is not welcome behavior. We
  interpret the term "harassment" as including the definition in the <a href="http://citizencodeofconduct.org/">Citizen
  Code of Conduct</a>; if you have any lack of clarity about what might be included in that concept, please read their
  definition. In particular, we don't tolerate behavior that excludes people in socially marginalized groups.
* Private harassment is also unacceptable. No matter who you are, if you feel you have been or are being harassed or
  made uncomfortable by a community member, please contact one of the channel ops or any of the [Rust moderation
  team][mod_team] immediately. Whether you're a regular contributor or a newcomer, we care about making this community a
  safe place for you and we've got your back.
* Likewise any spamming, trolling, flaming, baiting or other attention-stealing behavior is not welcome.

## Moderation


These are the policies for upholding our community's standards of conduct. If you feel that a thread needs moderation,
please contact the [Rust moderation team][mod_team].

1. Remarks that violate the Rust standards of conduct, including hateful, hurtful, oppressive, or exclusionary remarks,
   are not allowed. (Cursing is allowed, but never targeting another user, and never in a hateful manner.)
2. Remarks that moderators find inappropriate, whether listed in the code of conduct or not, are also not allowed.
3. Moderators will first respond to such remarks with a warning.
4. If the warning is unheeded, the user will be "kicked," i.e., kicked out of the communication channel to cool off.
5. If the user comes back and continues to make trouble, they will be banned, i.e., indefinitely excluded.
6. Moderators may choose at their discretion to un-ban the user if it was a first offense and they offer the offended
   party a genuine apology.
7. If a moderator bans someone and you think it was unjustified, please take it up with that moderator, or with a
   different moderator, **in private**. Complaints about bans in-channel are not allowed.
8. Moderators are held to a higher standard than other community members. If a moderator creates an inappropriate
   situation, they should expect less leeway than others.

In the Rust community we strive to go the extra step to look out for each other. Don't just aim to be technically
unimpeachable, try to be your best self. In particular, avoid flirting with offensive or sensitive issues, particularly
if they're off-topic; this all too often leads to unnecessary fights, hurt feelings, and damaged trust; worse, it can
drive people away from the community entirely.

And if someone takes issue with something you said or did, resist the urge to be defensive. Just stop doing what it was
they complained about and apologize. Even if you feel you were misinterpreted or unfairly accused, chances are good
there was something you could've communicated better — remember that it's your responsibility to make your fellow
Rustaceans comfortable. Everyone wants to get along and we are all here first and foremost because we want to talk about
cool technology. You will find that people will be eager to assume good intent and forgive as long as you earn their
trust.

The enforcement policies listed above apply to all official Rust venues; including official IRC channels (#rust,
#rust-internals, #rust-tools, #rust-libs, #rustc, #rust-beginners, #rust-docs, #rust-community, #rust-lang, and #cargo);
GitHub repositories under rust-lang, rust-lang-nursery, and rust-lang-deprecated; and all forums under rust-lang.org
(users.rust-lang.org, internals.rust-lang.org). For other projects adopting the Rust Code of Conduct, please contact the
maintainers of those projects for enforcement. If you wish to use this code of conduct for your own project, consider
explicitly mentioning your moderation policy or making a copy with your own moderation policy so as to avoid confusion.

*Adapted from the [Node.js Policy on Trolling](http://blog.izs.me/post/30036893703/policy-on-trolling) as well as the
[Contributor Covenant v1.3.0](https://www.contributor-covenant.org/version/1/3/0/).*

[mod_team]: https://www.rust-lang.org/team.html#Moderation-team
