/*  Part of SWI-Prolog interface to Qt

    Author:        Carlo Capelli
    E-mail:        cc.carlo.cap@gmail.com
    Copyright (c)  2013, Carlo Capelli
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in
       the documentation and/or other materials provided with the
       distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PQCONSOLE_H
#define PQCONSOLE_H

#include "pqConsole_global.h"

/*!
  \mainpage
    [pqConsole](@ref pqConsole) is an attempt to bring [SWI-Prolog](http://www.swi-prolog.org/) running in [Qt](http://qt-project.org/) environment.

    Using a shared library as basic component, it allows for maximum flexibility in reuse and deployment.
    It's being hosted on [Github](https://github.com/CapelliC/pqConsole).

  \author Carlo Capelli
  \version 0.1

  \class generated by QtCreator for project, this class represent library entry point.
  You can use [ConsoleEdit](@ref ConsoleEdit) *without* instancing pqConsole. Indeed argc/argv are forwarded to ConsoleEdit constructor.

  */
class PQCONSOLESHARED_EXPORT pqConsole {
public:

    pqConsole();

    /*! Run a vanilla QMainWindow displaying SWI-Prolog console */
    int runDemo(int argc, char *argv[]);
};

#endif // PQCONSOLE_H
